/* RainLoop Webmail (c) RainLoop Team | Licensed under RainLoop Software License */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.l = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// identity function for calling harmory imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };

/******/ 	// define getter function for harmory exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		Object.defineProperty(exports, name, {
/******/ 			configurable: false,
/******/ 			enumerable: true,
/******/ 			get: getter
/******/ 		});
/******/ 	};

/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "rainloop/v/0.0.0/static/js/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 178);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!******************************!*\
  !*** ./dev/Common/Utils.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko___default = __WEBPACK_IMPORTED_MODULE_3_ko__ && __WEBPACK_IMPORTED_MODULE_3_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_3_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Mime__ = __webpack_require__(/*! Common/Mime */ 69);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__ = __webpack_require__(/*! JSEncrypt */ 85);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default = __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__ && __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default, 'a', __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Autolinker__ = __webpack_require__(/*! Autolinker */ 84);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Autolinker___default = __WEBPACK_IMPORTED_MODULE_8_Autolinker__ && __WEBPACK_IMPORTED_MODULE_8_Autolinker__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_8_Autolinker__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_8_Autolinker__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_8_Autolinker___default, 'a', __WEBPACK_IMPORTED_MODULE_8_Autolinker___default);

/* harmony export */ __webpack_require__.d(exports, "isArray", function() { return isArray; });
/* harmony export */ __webpack_require__.d(exports, "isObject", function() { return isObject; });
/* harmony export */ __webpack_require__.d(exports, "isUnd", function() { return isUnd; });
/* harmony export */ __webpack_require__.d(exports, "isNull", function() { return isNull; });
/* harmony export */ __webpack_require__.d(exports, "has", function() { return has; });
/* harmony export */ __webpack_require__.d(exports, "bind", function() { return bind; });
/* harmony export */ __webpack_require__.d(exports, "noop", function() { return noop; });
/* harmony export */ __webpack_require__.d(exports, "noopTrue", function() { return noopTrue; });
/* harmony export */ __webpack_require__.d(exports, "noopFalse", function() { return noopFalse; });
/* harmony export */ __webpack_require__.d(exports, "trim", function() { return trim; });
/* harmony export */ __webpack_require__.d(exports, "inArray", function() { return inArray; });
/* harmony export */ __webpack_require__.d(exports, "isFunc", function() { return isFunc; });/* harmony export */ exports["silentTryCatch"] = silentTryCatch;/* harmony export */ exports["isNormal"] = isNormal;/* harmony export */ exports["isPosNumeric"] = isPosNumeric;/* harmony export */ exports["pInt"] = pInt;/* harmony export */ exports["pString"] = pString;/* harmony export */ exports["pBool"] = pBool;/* harmony export */ exports["isNonEmptyArray"] = isNonEmptyArray;/* harmony export */ exports["encodeURIComponent"] = encodeURIComponent;/* harmony export */ exports["decodeURIComponent"] = decodeURIComponent;/* harmony export */ exports["decodeURI"] = decodeURI;/* harmony export */ exports["encodeURI"] = encodeURI;/* harmony export */ exports["simpleQueryParser"] = simpleQueryParser;/* harmony export */ exports["fakeMd5"] = fakeMd5;
/* harmony export */ __webpack_require__.d(exports, "rsaEncode", function() { return rsaEncode; });/* harmony export */ exports["encodeHtml"] = encodeHtml;/* harmony export */ exports["splitPlainText"] = splitPlainText;
/* harmony export */ __webpack_require__.d(exports, "timeOutAction", function() { return timeOutAction; });
/* harmony export */ __webpack_require__.d(exports, "timeOutActionSecond", function() { return timeOutActionSecond; });/* harmony export */ exports["inFocus"] = inFocus;/* harmony export */ exports["removeInFocus"] = removeInFocus;/* harmony export */ exports["removeSelection"] = removeSelection;/* harmony export */ exports["replySubjectAdd"] = replySubjectAdd;/* harmony export */ exports["roundNumber"] = roundNumber;/* harmony export */ exports["friendlySize"] = friendlySize;/* harmony export */ exports["log"] = log;/* harmony export */ exports["delegateRun"] = delegateRun;/* harmony export */ exports["kill_CtrlA_CtrlS"] = kill_CtrlA_CtrlS;/* harmony export */ exports["createCommand"] = createCommand;
/* harmony export */ __webpack_require__.d(exports, "convertThemeName", function() { return convertThemeName; });/* harmony export */ exports["quoteName"] = quoteName;/* harmony export */ exports["microtime"] = microtime;/* harmony export */ exports["timestamp"] = timestamp;/* harmony export */ exports["convertLangName"] = convertLangName;/* harmony export */ exports["draggablePlace"] = draggablePlace;/* harmony export */ exports["defautOptionsAfterRender"] = defautOptionsAfterRender;/* harmony export */ exports["clearBqSwitcher"] = clearBqSwitcher;/* harmony export */ exports["previewMessage"] = previewMessage;/* harmony export */ exports["settingsSaveHelperFunction"] = settingsSaveHelperFunction;/* harmony export */ exports["settingsSaveHelperSimpleFunction"] = settingsSaveHelperSimpleFunction;/* harmony export */ exports["settingsSaveHelperSubscribeFunction"] = settingsSaveHelperSubscribeFunction;/* harmony export */ exports["findEmailAndLinks"] = findEmailAndLinks;/* harmony export */ exports["htmlToPlain"] = htmlToPlain;/* harmony export */ exports["plainToHtml"] = plainToHtml;/* harmony export */ exports["folderListOptionsBuilder"] = folderListOptionsBuilder;/* harmony export */ exports["selectElement"] = selectElement;
/* harmony export */ __webpack_require__.d(exports, "detectDropdownVisibility", function() { return detectDropdownVisibility; });/* harmony export */ exports["triggerAutocompleteInputChange"] = triggerAutocompleteInputChange;/* harmony export */ exports["getConfigurationFromScriptTag"] = getConfigurationFromScriptTag;/* harmony export */ exports["disposeOne"] = disposeOne;/* harmony export */ exports["disposeObject"] = disposeObject;/* harmony export */ exports["delegateRunOnDestroy"] = delegateRunOnDestroy;/* harmony export */ exports["appendStyles"] = appendStyles;/* harmony export */ exports["changeTheme"] = changeTheme;/* harmony export */ exports["computedPagenatorHelper"] = computedPagenatorHelper;/* harmony export */ exports["getFileExtension"] = getFileExtension;/* harmony export */ exports["mimeContentType"] = mimeContentType;/* harmony export */ exports["resizeAndCrop"] = resizeAndCrop;/* harmony export */ exports["mailToHelper"] = mailToHelper;
/* harmony export */ __webpack_require__.d(exports, "windowResize", function() { return windowResize; });/* harmony export */ exports["windowResizeCallback"] = windowResizeCallback;var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };












var trim = __WEBPACK_IMPORTED_MODULE_1_____default.a.trim;
var inArray = __WEBPACK_IMPORTED_MODULE_1_____default.a.inArray;
var isArray = __WEBPACK_IMPORTED_MODULE_2_____default.a.isArray;
var isObject = __WEBPACK_IMPORTED_MODULE_2_____default.a.isObject;
var isFunc = __WEBPACK_IMPORTED_MODULE_2_____default.a.isFunction;
var isUnd = __WEBPACK_IMPORTED_MODULE_2_____default.a.isUndefined;
var isNull = __WEBPACK_IMPORTED_MODULE_2_____default.a.isNull;
var has = __WEBPACK_IMPORTED_MODULE_2_____default.a.has;
var bind = __WEBPACK_IMPORTED_MODULE_2_____default.a.bind;
var noop = function noop() {}; // eslint-disable-line no-empty-function
var noopTrue = function noopTrue() {
	return true;
};
var noopFalse = function noopFalse() {
	return false;
};



/**
 * @param {Function} func
 */
function silentTryCatch(func) {
	try {
		func();
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function isNormal(value) {
	return !isUnd(value) && !isNull(value);
}

/**
 * @param {(string|number)} value
 * @param {boolean=} includeZero = true
 * @returns {boolean}
 */
function isPosNumeric(value) {
	var includeZero = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];

	return !isNormal(value) ? false : includeZero ? /^[0-9]*$/.test(value.toString()) : /^[1-9]+[0-9]*$/.test(value.toString());
}

/**
 * @param {*} value
 * @param {number=} defaultValur = 0
 * @returns {number}
 */
function pInt(value) {
	var defaultValur = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];

	var result = isNormal(value) && '' !== value ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(value, 10) : defaultValur;
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.isNaN(result) ? defaultValur : result;
}

/**
 * @param {*} value
 * @returns {string}
 */
function pString(value) {
	return isNormal(value) ? '' + value : '';
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function pBool(value) {
	return !!value;
}

/**
 * @param {*} values
 * @returns {boolean}
 */
function isNonEmptyArray(values) {
	return isArray(values) && 0 < values.length;
}

/**
 * @param {string} component
 * @returns {string}
 */
function encodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURIComponent(component);
}

/**
 * @param {string} component
 * @returns {string}
 */
function decodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURIComponent(component);
}

/**
 * @param {string} url
 * @returns {string}
 */
function decodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURI(url);
}

/**
 * @param {string} url
 * @returns {string}
 */
function encodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(url);
}

/**
 * @param {string} queryString
 * @returns {Object}
 */
function simpleQueryParser(queryString) {
	var index = 0,
	    len = 0,
	    temp = null;

	var queries = queryString.split('&'),
	    params = {};

	for (len = queries.length; index < len; index++) {
		temp = queries[index].split('=');
		params[decodeURIComponent(temp[0])] = decodeURIComponent(temp[1]);
	}

	return params;
}

/**
 * @param {number=} len = 32
 * @returns {string}
 */
function fakeMd5() {
	var len = arguments.length <= 0 || arguments[0] === undefined ? 32 : arguments[0];

	var line = '0123456789abcdefghijklmnopqrstuvwxyz',
	    lineLen = line.length;

	len = pInt(len);

	var result = '';
	while (result.length < len) {
		result += line.substr(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.random() * lineLen), 1);
	}

	return result;
}

var encryptObject = null;

/**
 * @param {constructor} JSEncryptClass
 * @param {string} publicKey
 * @returns {JSEncrypt|boolean}
 */
var rsaObject = function rsaObject(JSEncryptClass, publicKey) {

	if (JSEncryptClass && publicKey && (null === encryptObject || encryptObject && encryptObject.__publicKey !== publicKey) && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues) {
		encryptObject = new JSEncryptClass();
		encryptObject.setPublicKey(publicKey);
		encryptObject.__publicKey = publicKey;
	} else {
		encryptObject = false;
	}

	return encryptObject;
};

/**
 * @param {string} value
 * @param {string} publicKey
 * @returns {string}
 */
var rsaEncode = function rsaEncode(value, publicKey) {

	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues && publicKey) {
		var resultValue = false;
		var encrypt = rsaObject(__WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default.a, publicKey);

		if (encrypt) {
			resultValue = encrypt.encrypt(fakeMd5() + ':' + value + ':' + fakeMd5());
			if (false !== resultValue && isNormal(resultValue)) {
				return 'rsa:xxx:' + resultValue;
			}
		}
	}

	return value;
};

rsaEncode.supported = !!(__WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues && false && __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default.a);



/**
 * @param {string} text
 * @returns {string}
 */
function encodeHtml(text) {
	return isNormal(text) ? __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(text.toString()) : '';
}

/**
 * @param {string} text
 * @param {number=} iLen = 100
 * @returns {string}
 */
function splitPlainText(text) {
	var len = arguments.length <= 1 || arguments[1] === undefined ? 100 : arguments[1];

	var prefix = '',
	    subText = '',
	    result = text,
	    spacePos = 0,
	    newLinePos = 0;

	while (result.length > len) {
		subText = result.substring(0, len);
		spacePos = subText.lastIndexOf(' ');
		newLinePos = subText.lastIndexOf('\n');

		if (-1 !== newLinePos) {
			spacePos = newLinePos;
		}

		if (-1 === spacePos) {
			spacePos = len;
		}

		prefix += subText.substring(0, spacePos) + '\n';
		result = result.substring(spacePos + 1);
	}

	return prefix + result;
}

var timeOutAction = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		timeOuts[action] = isUnd(timeOuts[action]) ? 0 : timeOuts[action];
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(timeOuts[action]);
		timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(fFunction, timeOut);
	};
}();

var timeOutActionSecond = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		if (!timeOuts[action]) {
			timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				fFunction();
				timeOuts[action] = 0;
			}, timeOut);
		}
	};
}();



/**
 * @returns {boolean}
 */
function inFocus() {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement) {
		if (isUnd(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache)) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement).is('input,textarea,iframe,.cke_editable');
		}

		return !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache;
	}

	return false;
}

/**
 * @param {boolean} force
 * @returns {void}
 */
function removeInFocus(force) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur) {
		try {
			var activeEl = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement);
			if (activeEl && activeEl.is('input,textarea')) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			} else if (force) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			}
		} catch (e) {} // eslint-disable-line no-empty
	}
}

/**
 * @returns {void}
 */
function removeSelection() {
	try {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a && __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
			var sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
			if (sel && sel.removeAllRanges) {
				sel.removeAllRanges();
			}
		} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty();
		}
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {string} prefix
 * @param {string} subject
 * @returns {string}
 */
function replySubjectAdd(prefix, subject) {
	prefix = trim(prefix.toUpperCase());
	subject = trim(subject.replace(/[\s]+/g, ' '));

	var drop = false,
	    re = 'RE' === prefix,
	    fwd = 'FWD' === prefix;

	var parts = [],
	    prefixIsRe = !fwd;

	if ('' !== subject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.each(subject.split(':'), function (part) {
			var trimmedPart = trim(part);
			if (!drop && (/^(RE|FWD)$/i.test(trimmedPart) || /^(RE|FWD)[\[\(][\d]+[\]\)]$/i.test(trimmedPart))) {
				if (!re) {
					re = !!/^RE/i.test(trimmedPart);
				}

				if (!fwd) {
					fwd = !!/^FWD/i.test(trimmedPart);
				}
			} else {
				parts.push(part);
				drop = true;
			}
		});
	}

	if (prefixIsRe) {
		re = false;
	} else {
		fwd = false;
	}

	return trim((prefixIsRe ? 'Re: ' : 'Fwd: ') + (re ? 'Re: ' : '') + (fwd ? 'Fwd: ' : '') + trim(parts.join(':')));
}

/**
 * @param {number} num
 * @param {number} dec
 * @returns {number}
 */
function roundNumber(num, dec) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(num * __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec)) / __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec);
}

/**
 * @param {(number|string)} sizeInBytes
 * @returns {string}
 */
function friendlySize(sizeInBytes) {
	sizeInBytes = pInt(sizeInBytes);

	switch (true) {
		case 1073741824 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1073741824, 1) + 'GB';
		case 1048576 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1048576, 1) + 'MB';
		case 1024 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1024, 0) + 'KB';
		// no default
	}

	return sizeInBytes + 'B';
}

/**
 * @param {string} desc
 */
function log(desc) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.console && __WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log(desc);
	}
}

/**
 * @param {?} object
 * @param {string} methodName
 * @param {Array=} params
 * @param {number=} delay = 0
 */
function delegateRun(object, methodName, params) {
	var delay = arguments.length <= 3 || arguments[3] === undefined ? 0 : arguments[3];

	if (object && object[methodName]) {
		delay = pInt(delay);
		params = isArray(params) ? params : [];

		if (0 >= delay) {
			object[methodName].apply(object, params);
		} else {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				object[methodName].apply(object, params);
			}, delay);
		}
	}
}

/**
 * @param {?} event
 */
function kill_CtrlA_CtrlS(event) {
	event = event || __WEBPACK_IMPORTED_MODULE_0_window___default.a.event;
	if (event && event.ctrlKey && !event.shiftKey && !event.altKey) {
		var key = event.keyCode || event.which;
		if (key === __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].S) {
			event.preventDefault();
			return;
		} else if (key === __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].A) {
			var sender = event.target || event.srcElement;
			if (sender && ('true' === '' + sender.contentEditable || sender.tagName && sender.tagName.match(/INPUT|TEXTAREA/i))) {
				return;
			}

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection().removeAllRanges();
			} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear();
			}

			event.preventDefault();
		}
	}
}

/**
 * @param {(Object|null|undefined)} context
 * @param {Function} fExecute
 * @param {(Function|boolean|null)=} fCanExecute = true
 * @returns {Function}
 */
function createCommand(context, fExecute) {
	var fCanExecute = arguments.length <= 2 || arguments[2] === undefined ? true : arguments[2];

	var fResult = null;
	var fNonEmpty = function fNonEmpty() {
		for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
			args[_key] = arguments[_key];
		}

		if (fResult && fResult.canExecute && fResult.canExecute()) {
			fExecute.apply(context, args);
		}
		return false;
	};

	fResult = fExecute ? fNonEmpty : noop;
	fResult.enabled = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(true);

	if (isFunc(fCanExecute)) {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return fResult.enabled() && fCanExecute.call(context);
		});
	} else {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return fResult.enabled() && !!fCanExecute;
		});
	}

	return fResult;
}

/**
 * @param {string} theme
 * @returns {string}
 */
var convertThemeName = __WEBPACK_IMPORTED_MODULE_2_____default.a.memoize(function (theme) {

	if ('@custom' === theme.substr(-7)) {
		theme = trim(theme.substring(0, theme.length - 7));
	}

	return trim(theme.replace(/[^a-zA-Z0-9]+/g, ' ').replace(/([A-Z])/g, ' $1').replace(/[\s]+/g, ' '));
});

/**
 * @param {string} name
 * @returns {string}
 */
function quoteName(name) {
	return name.replace(/["]/g, '\\"');
}

/**
 * @returns {number}
 */
function microtime() {
	return new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();
}

/**
 * @returns {number}
 */
function timestamp() {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(microtime() / 1000);
}

/**
 *
 * @param {string} language
 * @param {boolean=} isEng = false
 * @returns {string}
 */
function convertLangName(language) {
	var isEng = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	return __webpack_require__(/*! Common/Translator */ 6).i18n('LANGS_NAMES' + (true === isEng ? '_EN' : '') + '/LANG_' + language.toUpperCase().replace(/[^a-zA-Z0-9]+/g, '_'), null, language);
}

/**
 * @returns {object}
 */
function draggablePlace() {
	return __WEBPACK_IMPORTED_MODULE_1_____default()('<div class="draggablePlace">' + '<span class="text"></span>&nbsp;' + '<i class="icon-copy icon-white visible-on-ctrl"></i>' + '<i class="icon-mail icon-white hidden-on-ctrl"></i>' + '</div>').appendTo('#rl-hidden');
}

/**
 * @param {object} domOption
 * @param {object} item
 * @returns {void}
 */
function defautOptionsAfterRender(domItem, item) {
	if (item && !isUnd(item.disabled) && domItem) {
		__WEBPACK_IMPORTED_MODULE_1_____default()(domItem).toggleClass('disabled', item.disabled).prop('disabled', item.disabled);
	}
}

/**
 * @param {string} title
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 */
function clearBqSwitcher(body) {
	body.find('blockquote.rl-bq-switcher').removeClass('rl-bq-switcher hidden-bq');
	body.find('.rlBlockquoteSwitcher').off('.rlBlockquoteSwitcher').remove();
	body.find('[data-html-editor-font-wrapper]').removeAttr('data-html-editor-font-wrapper');
}

/**
 * @param {string} title
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 */
function previewMessage(title, body, isHtml, print) {
	var win = __WEBPACK_IMPORTED_MODULE_0_window___default.a.open(''),
	    doc = win.document,
	    bodyClone = body.clone(),
	    bodyClass = isHtml ? 'html' : 'plain';

	clearBqSwitcher(bodyClone);

	var html = bodyClone ? bodyClone.html() : '';

	title = encodeHtml(title);

	doc.write('<html>\n<head>\n\t<meta charset="utf-8" />\n\t<meta name="viewport" content="user-scalable=no" />\n\t<meta name="apple-mobile-web-app-capable" content="yes" />\n\t<meta name="robots" content="noindex, nofollow, noodp" />\n\t<title>' + title + '</title>\n\t<style>\nhtml, body {\n\tbackground-color: #fff;\n\tfont-size: 13px;\n\tfont-family: arial, sans-serif;\n}\n\na {color: blue; text-decoration: underline}\na:visited {color: #609}\na:active {color: red}\nblockquote {border-left: 2px solid black; margin: 0; padding: 0px 10px}\n\npre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\tbackground: #fff;\n\tborder: none;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: break-all;\n}\n\nbody.html pre {\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\nbody.plain {\n\n\tpadding: 15px;\n\twhite-space: pre-wrap;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n}\n\nbody.plain pre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tbackground: #fff;\n\tborder: none;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\nbody.plain blockquote {\n\tborder-left: 2px solid blue;\n\tcolor: blue;\n}\n\nbody.plain blockquote blockquote {\n\tborder-left: 2px solid green;\n\tcolor: green;\n}\n\nbody.plain blockquote blockquote blockquote {\n\tborder-left: 2px solid red;\n\tcolor: red;\n}\n\t</style>\n</head>\n<body class="' + bodyClass + '">' + html + '</body>\n</html>');

	doc.close();

	if (print) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return win.print();
		}, 100);
	}
}

/**
 * @param {Function} fCallback
 * @param {?} koTrigger
 * @param {?} context = null
 * @param {number=} timer = 1000
 * @returns {Function}
 */
function settingsSaveHelperFunction(fCallback, koTrigger) {
	var context = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
	var timer = arguments.length <= 3 || arguments[3] === undefined ? 1000 : arguments[3];

	timer = pInt(timer);
	return function (type, data, cached, requestAction, requestParameters) {
		koTrigger.call(context, data && data.Result ? __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].TrueResult : __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].FalseResult);
		if (fCallback) {
			fCallback.call(context, type, data, cached, requestAction, requestParameters);
		}
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
			koTrigger.call(context, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Idle);
		}, timer);
	};
}

/**
 * @param {object} koTrigger
 * @param {mixed} context
 * @returns {mixed}
 */
function settingsSaveHelperSimpleFunction(koTrigger, context) {
	return settingsSaveHelperFunction(null, koTrigger, context, 1000);
}

/**
 * @param {object} remote
 * @param {string} settingName
 * @param {string} type
 * @param {function} fTriggerFunction
 * @returns {function}
 */
function settingsSaveHelperSubscribeFunction(remote, settingName, type, fTriggerFunction) {
	return function (value) {

		if (remote) {
			switch (type) {
				case 'bool':
				case 'boolean':
					value = value ? '1' : '0';
					break;
				case 'int':
				case 'integer':
				case 'number':
					value = pInt(value);
					break;
				case 'trim':
					value = trim(value);
					break;
				default:
					value = pString(value);
					break;
			}

			var data = {};
			data[settingName] = value;

			if (remote.saveAdminConfig) {
				remote.saveAdminConfig(fTriggerFunction || null, data);
			} else if (remote.saveSettings) {
				remote.saveSettings(fTriggerFunction || null, data);
			}
		}
	};
}

/**
 * @param {string} html
 * @returns {string}
 */
function findEmailAndLinks(html) {
	//	return html;
	return __WEBPACK_IMPORTED_MODULE_8_Autolinker___default.a.link(html, {
		newWindow: true,
		stripPrefix: false,
		urls: true,
		email: true,
		twitter: false,
		replaceFn: function replaceFn(autolinker, match) {
			return !(autolinker && match && 'url' === match.getType() && match.matchedText && 0 !== match.matchedText.indexOf('http'));
		}
	});
}

/**
 * @param {string} html
 * @returns {string}
 */
function htmlToPlain(html) {
	var pos = 0,
	    limit = 0,
	    iP1 = 0,
	    iP2 = 0,
	    iP3 = 0,
	    text = '';

	var convertBlockquote = function convertBlockquote(blockquoteText) {
		blockquoteText = '> ' + trim(blockquoteText).replace(/\n/gm, '\n> ');
		return blockquoteText.replace(/(^|\n)([> ]+)/gm, function () {
			for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
				args[_key2] = arguments[_key2];
			}

			return args && 2 < args.length ? args[1] + trim(args[2].replace(/[\s]/g, '')) + ' ' : '';
		});
	},
	    convertDivs = function convertDivs() {
		for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
			args[_key3] = arguments[_key3];
		}

		if (args && 1 < args.length) {
			var divText = trim(args[1]);
			if (0 < divText.length) {
				divText = divText.replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs);
				divText = '\n' + trim(divText) + '\n';
			}

			return divText;
		}

		return '';
	},
	    convertPre = function convertPre() {
		for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
			args[_key4] = arguments[_key4];
		}

		return args && 1 < args.length ? args[1].toString().replace(/[\n]/gm, '<br />').replace(/[\r]/gm, '') : '';
	},
	    fixAttibuteValue = function fixAttibuteValue() {
		for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
			args[_key5] = arguments[_key5];
		}

		return args && 1 < args.length ? '' + args[1] + __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(args[2]) : '';
	},
	    convertLinks = function convertLinks() {
		for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
			args[_key6] = arguments[_key6];
		}

		return args && 1 < args.length ? trim(args[1]) : '';
	};

	text = html.replace(/\u0002([\s\S]*)\u0002/gm, '‌$1‌').replace(/<p[^>]*><\/p>/gi, '').replace(/<pre[^>]*>([\s\S\r\n\t]*)<\/pre>/gmi, convertPre).replace(/[\s]+/gm, ' ').replace(/((?:href|data)\s?=\s?)("[^"]+?"|'[^']+?')/gmi, fixAttibuteValue).replace(/<br[^>]*>/gmi, '\n').replace(/<\/h[\d]>/gi, '\n').replace(/<\/p>/gi, '\n\n').replace(/<ul[^>]*>/gmi, '\n').replace(/<\/ul>/gi, '\n').replace(/<li[^>]*>/gmi, ' * ').replace(/<\/li>/gi, '\n').replace(/<\/td>/gi, '\n').replace(/<\/tr>/gi, '\n').replace(/<hr[^>]*>/gmi, '\n_______________________________\n\n').replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs).replace(/<blockquote[^>]*>/gmi, '\n__bq__start__\n').replace(/<\/blockquote>/gmi, '\n__bq__end__\n').replace(/<a [^>]*>([\s\S\r\n]*?)<\/a>/gmi, convertLinks).replace(/<\/div>/gi, '\n').replace(/&nbsp;/gi, ' ').replace(/&quot;/gi, '"').replace(/<[^>]*>/gm, '');

	text = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$div"].html(text).text();

	text = text.replace(/\n[ \t]+/gm, '\n').replace(/[\n]{3,}/gm, '\n\n').replace(/&gt;/gi, '>').replace(/&lt;/gi, '<').replace(/&amp;/gi, '&');

	text = splitPlainText(trim(text));

	pos = 0;
	limit = 800;

	while (0 < limit) {
		limit -= 1;
		iP1 = text.indexOf('__bq__start__', pos);
		if (-1 < iP1) {
			iP2 = text.indexOf('__bq__start__', iP1 + 5);
			iP3 = text.indexOf('__bq__end__', iP1 + 5);

			if ((-1 === iP2 || iP3 < iP2) && iP1 < iP3) {
				text = text.substring(0, iP1) + convertBlockquote(text.substring(iP1 + 13, iP3)) + text.substring(iP3 + 11);

				pos = 0;
			} else if (-1 < iP2 && iP2 < iP3) {
				pos = iP2 - 1;
			} else {
				pos = 0;
			}
		} else {
			break;
		}
	}

	text = text.replace(/__bq__start__/gm, '').replace(/__bq__end__/gm, '');

	return text;
}

/**
 * @param {string} plain
 * @param {boolean} findEmailAndLinksInText = false
 * @returns {string}
 */
function plainToHtml(plain) {
	var findEmailAndLinksInText = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	plain = plain.toString().replace(/\r/g, '');
	plain = plain.replace(/^>[> ]>+/gm, function (_ref) {
		var match = _ref[0];
		return match ? match.replace(/[ ]+/g, '') : match;
	});

	var bIn = false,
	    bDo = true,
	    bStart = true,
	    aNextText = [],
	    sLine = '',
	    iIndex = 0,
	    aText = plain.split('\n');

	do {
		bDo = false;
		aNextText = [];
		for (iIndex = 0; iIndex < aText.length; iIndex++) {
			sLine = aText[iIndex];
			bStart = '>' === sLine.substr(0, 1);
			if (bStart && !bIn) {
				bDo = true;
				bIn = true;
				aNextText.push('~~~blockquote~~~');
				aNextText.push(sLine.substr(1));
			} else if (!bStart && bIn) {
				if ('' !== sLine) {
					bIn = false;
					aNextText.push('~~~/blockquote~~~');
					aNextText.push(sLine);
				} else {
					aNextText.push(sLine);
				}
			} else if (bStart && bIn) {
				aNextText.push(sLine.substr(1));
			} else {
				aNextText.push(sLine);
			}
		}

		if (bIn) {
			bIn = false;
			aNextText.push('~~~/blockquote~~~');
		}

		aText = aNextText;
	} while (bDo);

	plain = aText.join('\n');

	plain = plain
	//			.replace(/~~~\/blockquote~~~\n~~~blockquote~~~/g, '\n')
	.replace(/&/g, '&amp;').replace(/>/g, '&gt;').replace(/</g, '&lt;').replace(/~~~blockquote~~~[\s]*/g, '<blockquote>').replace(/[\s]*~~~\/blockquote~~~/g, '</blockquote>').replace(/\u200C([\s\S]*)\u200C/g, '\u0002$1\u0002').replace(/\n/g, '<br />');

	return findEmailAndLinksInText ? findEmailAndLinks(plain) : plain;
}

__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloop_Utils_htmlToPlain = htmlToPlain;
__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloop_Utils_plainToHtml = plainToHtml;

/**
 * @param {Array} aSystem
 * @param {Array} aList
 * @param {Array=} aDisabled
 * @param {Array=} aHeaderLines
 * @param {?number=} iUnDeep
 * @param {Function=} fDisableCallback
 * @param {Function=} fVisibleCallback
 * @param {Function=} fRenameCallback
 * @param {boolean=} bSystem
 * @param {boolean=} bBuildUnvisible
 * @returns {Array}
 */
function folderListOptionsBuilder(aSystem, aList, aDisabled, aHeaderLines, iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible) {
	var
	/**
  * @type {?FolderModel}
  */
	oItem = null,
	    bSep = false,
	    iIndex = 0,
	    iLen = 0,
	    aResult = [];

	var sDeepPrefix = '   ';

	bBuildUnvisible = isUnd(bBuildUnvisible) ? false : !!bBuildUnvisible;
	bSystem = !isNormal(bSystem) ? 0 < aSystem.length : bSystem;
	iUnDeep = !isNormal(iUnDeep) ? 0 : iUnDeep;
	fDisableCallback = isNormal(fDisableCallback) ? fDisableCallback : null;
	fVisibleCallback = isNormal(fVisibleCallback) ? fVisibleCallback : null;
	fRenameCallback = isNormal(fRenameCallback) ? fRenameCallback : null;

	if (!isArray(aDisabled)) {
		aDisabled = [];
	}

	if (!isArray(aHeaderLines)) {
		aHeaderLines = [];
	}

	for (iIndex = 0, iLen = aHeaderLines.length; iIndex < iLen; iIndex++) {
		aResult.push({
			id: aHeaderLines[iIndex][0],
			name: aHeaderLines[iIndex][1],
			system: false,
			seporator: false,
			disabled: false
		});
	}

	bSep = true;
	for (iIndex = 0, iLen = aSystem.length; iIndex < iLen; iIndex++) {
		oItem = aSystem[iIndex];
		if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
			if (bSep && 0 < aResult.length) {
				aResult.push({
					id: '---',
					name: '---',
					system: false,
					seporator: true,
					disabled: true
				});
			}

			bSep = false;
			aResult.push({
				id: oItem.fullNameRaw,
				name: fRenameCallback ? fRenameCallback(oItem) : oItem.name(),
				system: true,
				seporator: false,
				disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
			});
		}
	}

	bSep = true;
	for (iIndex = 0, iLen = aList.length; iIndex < iLen; iIndex++) {
		oItem = aList[iIndex];
		//			if (oItem.subScribed() || !oItem.existen || bBuildUnvisible)
		if ((oItem.subScribed() || !oItem.existen || bBuildUnvisible) && (oItem.selectable || oItem.hasSubScribedSubfolders())) {
			if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
				if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["FolderType"].User === oItem.type() || !bSystem || oItem.hasSubScribedSubfolders()) {
					if (bSep && 0 < aResult.length) {
						aResult.push({
							id: '---',
							name: '---',
							system: false,
							seporator: true,
							disabled: true
						});
					}

					bSep = false;
					aResult.push({
						id: oItem.fullNameRaw,
						name: new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Array(oItem.deep + 1 - iUnDeep).join(sDeepPrefix) + (fRenameCallback ? fRenameCallback(oItem) : oItem.name()),
						system: false,
						seporator: false,
						disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
					});
				}
			}
		}

		if (oItem.subScribed() && 0 < oItem.subFolders().length) {
			aResult = aResult.concat(folderListOptionsBuilder([], oItem.subFolders(), aDisabled, [], iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible));
		}
	}

	return aResult;
}

/**
 * @param {object} element
 * @returns {void}
 */
function selectElement(element) {
	var sel = null,
	    range = null;
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
		sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
		sel.removeAllRanges();
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createRange();
		range.selectNodeContents(element);
		sel.addRange(range);
	} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection) {
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.body.createTextRange();
		range.moveToElementText(element);
		range.select();
	}
}

var detectDropdownVisibility = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function () {
	__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["dropdownVisibility"])(!!__WEBPACK_IMPORTED_MODULE_2_____default.a.find(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["data"].aBootstrapDropdowns, function (item) {
		return item.hasClass('open');
	}));
}, 50);

/**
 * @param {boolean=} delay = false
 */
function triggerAutocompleteInputChange() {
	var delay = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];


	var fFunc = function fFunc() {
		__WEBPACK_IMPORTED_MODULE_1_____default()('.checkAutocomplete').trigger('change');
	};

	if (delay) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(fFunc, 100);
	} else {
		fFunc();
	}
}

var configurationScriptTagCache = {};

/**
 * @param {string} configuration
 * @returns {object}
 */
function getConfigurationFromScriptTag(configuration) {
	if (!configurationScriptTagCache[configuration]) {
		configurationScriptTagCache[configuration] = __WEBPACK_IMPORTED_MODULE_1_____default()('script[type="application/json"][data-configuration="' + configuration + '"]');
	}

	try {
		return JSON.parse(configurationScriptTagCache[configuration].text());
	} catch (e) {} // eslint-disable-line no-empty

	return {};
}

/**
 * @param {mixed} mPropOrValue
 * @param {mixed} value
 */
function disposeOne(propOrValue, value) {
	var disposable = value || propOrValue;
	if (disposable && 'function' === typeof disposable.dispose) {
		disposable.dispose();
	}
}

/**
 * @param {Object} object
 */
function disposeObject(object) {
	if (object) {
		if (isArray(object.disposables)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(object.disposables, disposeOne);
		}

		__WEBPACK_IMPORTED_MODULE_3_ko___default.a.utils.objectForEach(object, disposeOne);
	}
}

/**
 * @param {Object|Array} objectOrObjects
 * @returns {void}
 */
function delegateRunOnDestroy(objectOrObjects) {
	if (objectOrObjects) {
		if (isArray(objectOrObjects)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(objectOrObjects, function (item) {
				delegateRunOnDestroy(item);
			});
		} else if (objectOrObjects && objectOrObjects.onDestroy) {
			objectOrObjects.onDestroy();
		}
	}
}

/**
 * @param {object} $styleTag
 * @param {string} css
 * @returns {boolean}
 */
function appendStyles($styleTag, css) {
	if ($styleTag && $styleTag[0]) {
		if ($styleTag[0].styleSheet && !isUnd($styleTag[0].styleSheet.cssText)) {
			$styleTag[0].styleSheet.cssText = css;
		} else {
			$styleTag.text(css);
		}

		return true;
	}

	return false;
}

var __themeTimer = 0,
    __themeAjax = null;

/**
 * @param {string} value
 * @param {function} themeTrigger
 * @returns {void}
 */
function changeTheme(value, themeTrigger) {
	var themeLink = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-link'),
	    clearTimer = function clearTimer() {
		__themeTimer = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Idle);
		}, 1000);
		__themeAjax = null;
	};

	var themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-style'),
	    url = themeLink.attr('href');

	if (!url) {
		url = themeStyle.attr('data-href');
	}

	if (url) {
		url = url.toString().replace(/\/-\/[^\/]+\/\-\//, '/-/' + value + '/-/');
		url = url.toString().replace(/\/Css\/[^\/]+\/User\//, '/Css/0/User/');
		url = url.toString().replace(/\/Hash\/[^\/]+\//, '/Hash/-/');

		if ('Json/' !== url.substring(url.length - 5, url.length)) {
			url += 'Json/';
		}

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(__themeTimer);
		themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Animate);

		if (__themeAjax && __themeAjax.abort) {
			__themeAjax.abort();
		}

		__themeAjax = __WEBPACK_IMPORTED_MODULE_1_____default.a.ajax({
			url: url,
			dataType: 'json'
		}).then(function (data) {

			if (data && isArray(data) && 2 === data.length) {
				if (themeLink && themeLink[0] && (!themeStyle || !themeStyle[0])) {
					themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('<style id="app-theme-style"></style>');
					themeLink.after(themeStyle);
					themeLink.remove();
				}

				if (themeStyle && themeStyle[0]) {
					if (appendStyles(themeStyle, data[1])) {
						themeStyle.attr('data-href', url).attr('data-theme', data[0]);
					}
				}

				themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].TrueResult);
			}
		}).then(clearTimer, clearTimer);
	}
}

/**
 * @returns {function}
 */
function computedPagenatorHelper(koCurrentPage, koPageCount) {
	return function () {

		var currentPage = koCurrentPage(),
		    pageCount = koPageCount(),
		    result = [],
		    fAdd = function fAdd(index) {
			var push = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];
			var customName = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];


			var data = {
				current: index === currentPage,
				name: '' === customName ? index.toString() : customName.toString(),
				custom: '' !== customName,
				title: '' === customName ? '' : index.toString(),
				value: index.toString()
			};

			if (push) {
				result.push(data);
			} else {
				result.unshift(data);
			}
		};

		var prev = 0,
		    next = 0,
		    limit = 2;

		if (1 < pageCount || 0 < pageCount && pageCount < currentPage) {
			if (pageCount < currentPage) {
				fAdd(pageCount);
				prev = pageCount;
				next = pageCount;
			} else {
				if (3 >= currentPage || pageCount - 2 <= currentPage) {
					limit += 2;
				}

				fAdd(currentPage);
				prev = currentPage;
				next = currentPage;
			}

			while (0 < limit) {

				prev -= 1;
				next += 1;

				if (0 < prev) {
					fAdd(prev, false);
					limit -= 1;
				}

				if (pageCount >= next) {
					fAdd(next, true);
					limit -= 1;
				} else if (0 >= prev) {
					break;
				}
			}

			if (3 === prev) {
				fAdd(2, false);
			} else if (3 < prev) {
				fAdd(Math.round((prev - 1) / 2), false, '...');
			}

			if (pageCount - 2 === next) {
				fAdd(pageCount - 1, true);
			} else if (pageCount - 2 > next) {
				fAdd(Math.round((pageCount + next) / 2), true, '...');
			}

			// first and last
			if (1 < prev) {
				fAdd(1, false);
			}

			if (pageCount > next) {
				fAdd(pageCount, true);
			}
		}

		return result;
	};
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function getFileExtension(fileName) {
	fileName = trim(fileName).toLowerCase();

	var result = fileName.split('.').pop();
	return result === fileName ? '' : result;
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function mimeContentType(fileName) {
	var ext = '',
	    result = 'application/octet-stream';

	fileName = trim(fileName).toLowerCase();

	if ('winmail.dat' === fileName) {
		return 'application/ms-tnef';
	}

	ext = getFileExtension(fileName);
	if (ext && 0 < ext.length && !isUnd(__WEBPACK_IMPORTED_MODULE_6_Common_Mime__["a" /* Mime */][ext])) {
		result = __WEBPACK_IMPORTED_MODULE_6_Common_Mime__["a" /* Mime */][ext];
	}

	return result;
}

/**
 * @param {string} url
 * @param {number} value
 * @param {Function} fCallback
 */
function resizeAndCrop(url, value, fCallback) {
	var img = new Image();
	img.onload = function () {

		var diff = [0, 0];

		var canvas = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('canvas'),
		    ctx = canvas.getContext('2d');

		canvas.width = value;
		canvas.height = value;

		if (this.width > this.height) {
			diff = [this.width - this.height, 0];
		} else {
			diff = [0, this.height - this.width];
		}

		ctx.fillStyle = '#fff';
		ctx.fillRect(0, 0, value, value);
		ctx.drawImage(this, diff[0] / 2, diff[1] / 2, this.width - diff[0], this.height - diff[1], 0, 0, value, value);

		fCallback(canvas.toDataURL('image/jpeg'));
	};

	img.src = url;
}

/**
 * @param {string} mailToUrl
 * @param {Function} PopupComposeVoreModel
 * @returns {boolean}
 */
function mailToHelper(mailToUrl, PopupComposeVoreModel) {
	if (mailToUrl && 'mailto:' === mailToUrl.toString().substr(0, 7).toLowerCase()) {
		var _ret = function () {
			if (!PopupComposeVoreModel) {
				return {
					v: true
				};
			}

			mailToUrl = mailToUrl.toString().substr(7);

			var to = [],
			    cc = null,
			    bcc = null,
			    params = {};

			var email = mailToUrl.replace(/\?.+$/, ''),
			    query = mailToUrl.replace(/^[^\?]*\?/, ''),
			    EmailModel = __webpack_require__(/*! Model/Email */ 30).default,
			    emailObj = new EmailModel(),
			    fParseEmailLine = function fParseEmailLine(line) {
				return line ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(decodeURIComponent(line).split(/[,]/), function (item) {
					emailObj.clear();
					emailObj.mailsoParse(item);
					return '' !== emailObj.email ? emailObj : null;
				})) : null;
			};

			to = fParseEmailLine(email);
			params = simpleQueryParser(query);

			if (!isUnd(params.cc)) {
				cc = fParseEmailLine(decodeURIComponent(params.cc));
			}

			if (!isUnd(params.bcc)) {
				bcc = fParseEmailLine(decodeURIComponent(params.bcc));
			}

			__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(PopupComposeVoreModel, [__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["ComposeType"].Empty, null, to, cc, bcc, isUnd(params.subject) ? null : pString(decodeURIComponent(params.subject)), isUnd(params.body) ? null : plainToHtml(pString(decodeURIComponent(params.body)))]);

			return {
				v: true
			};
		}();

		if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
	}

	return false;
}

var windowResize = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function (timeout) {
	if (isUnd(timeout) || isNull(timeout)) {
		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].resize();
	} else {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].resize();
		}, timeout);
	}
}, 50);

/**
 * @returns {void}
 */
function windowResizeCallback() {
	windowResize();
}

var substr = __WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr;
if ('b' !== 'ab'.substr(-1)) {
	substr = function substr(str, start, length) {
		start = 0 > start ? str.length + start : start;
		return str.substr(start, length);
	};

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr = substr;
}

/***/ },
/* 1 */
/*!****************************!*\
  !*** ./dev/External/ko.js ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	ko = window.ko,
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	JSON = __webpack_require__(/*! JSON */ 33),
	Opentip = __webpack_require__(/*! Opentip */ 57),
	Pikaday = __webpack_require__(/*! pikaday */ 82),

	fDisposalTooltipHelper = function(oElement) {
		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			if (oElement && oElement.__opentip)
			{
				oElement.__opentip.deactivate();
			}
		});
	};

ko.bindingHandlers.updateWidth = {
	init: function(oElement, fValueAccessor) {
		var
			$w = $(window),
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			fInit = function() {
				fValue($oEl.width());
				window.setTimeout(function() {
					fValue($oEl.width());
				}, 500);
			};

		$w.on('resize', fInit);
		fInit();

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$w.off('resize', fInit);
		});
	}
};

ko.bindingHandlers.editor = {
	init: function(oElement, fValueAccessor) {

		var
			oEditor = null,
			fValue = fValueAccessor(),

			fUpdateEditorValue = function() {
				if (fValue && fValue.__editor)
				{
					fValue.__editor.setHtmlOrPlain(fValue());
				}
			},

			fUpdateKoValue = function() {
				if (fValue && fValue.__editor)
				{
					fValue(fValue.__editor.getDataWithHtmlMark());
				}
			},

			fOnReady = function() {
				fValue.__editor = oEditor;
				fUpdateEditorValue();
			},

			HtmlEditor = __webpack_require__(/*! Common/HtmlEditor */ 45);

		if (ko.isObservable(fValue) && HtmlEditor)
		{
			oEditor = new HtmlEditor(oElement, fUpdateKoValue, fOnReady, fUpdateKoValue);

			fValue.__fetchEditorValue = fUpdateKoValue;

			fValue.subscribe(fUpdateEditorValue);

//				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
//				});
		}
	}
};

ko.bindingHandlers.json = {
	init: function(oElement, fValueAccessor) {
		$(oElement).text(JSON.stringify(ko.unwrap(fValueAccessor())));
	},
	update: function(oElement, fValueAccessor) {
		$(oElement).text(JSON.stringify(ko.unwrap(fValueAccessor())));
	}
};

ko.bindingHandlers.scrollerShadows = {
	init: function(oElement) {

		var
			iLimit = 8,
			$oEl = $(oElement),
			$win = $(window),
			oCont = $oEl.find('[data-scroller-shadows-content]')[0] || null,
			fFunc = _.throttle(function() {
				$oEl
					.toggleClass('scroller-shadow-top', iLimit < oCont.scrollTop)
					.toggleClass('scroller-shadow-bottom', oCont.scrollTop + iLimit < oCont.scrollHeight - oCont.clientHeight);
			}, 100);

		if (oCont)
		{
			$(oCont).on('scroll resize', fFunc);
			$win.on('resize', fFunc);

			ko.utils.domNodeDisposal.addDisposeCallback(oCont, function() {
				$(oCont).off();
				$win.off('resize', fFunc);
			});
		}
	}
};

ko.bindingHandlers.pikaday = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {

		ko.bindingHandlers.textInput
			.init.apply(oViewModel, Array.prototype.slice.call(arguments)); // eslint-disable-line prefer-rest-params

		if (Pikaday)
		{
			oElement.__pikaday = new Pikaday({
				field: oElement
			});
		}
	}
};

ko.bindingHandlers.tooltip = {
	init: function(oElement, fValueAccessor) {

		var
			bi18n = true,
			sValue = '',
			Translator = null,
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			bMobile = 'on' === ($oEl.data('tooltip-mobile') || 'off'),
			Globals = __webpack_require__(/*! Common/Globals */ 5);

		if (!Globals.bMobileDevice || bMobile)
		{
			bi18n = 'on' === ($oEl.data('tooltip-i18n') || 'on');
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue);

			oElement.__opentip = new Opentip(oElement, {
				'style': 'rainloopTip',
				'element': oElement,
				'tipJoint': $oEl.data('tooltip-join') || 'bottom'
			});

			Globals.dropdownVisibility.subscribe(function(bV) {
				if (bV) {
					oElement.__opentip.hide();
				}
			});

			if ('' === sValue)
			{
				oElement.__opentip.hide();
				oElement.__opentip.deactivate();
				oElement.__opentip.setContent('');
			}
			else
			{
				oElement.__opentip.activate();
			}

			if (bi18n)
			{
				Translator = __webpack_require__(/*! Common/Translator */ 6);

				oElement.__opentip.setContent(Translator.i18n(sValue));

				Translator.trigger.subscribe(function() {
					oElement.__opentip.setContent(Translator.i18n(sValue));
				});

				Globals.dropdownVisibility.subscribe(function() {
					if (oElement && oElement.__opentip)
					{
						oElement.__opentip.setContent(__webpack_require__(/*! Common/Translator */ 6).i18n(sValue));
					}
				});
			}
			else
			{
				oElement.__opentip.setContent(sValue);
			}
		}
	},
	update: function(oElement, fValueAccessor) {

		var
			bi18n = true,
			sValue = '',
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			bMobile = 'on' === ($oEl.data('tooltip-mobile') || 'off'),
			Globals = __webpack_require__(/*! Common/Globals */ 5);

		if ((!Globals.bMobileDevice || bMobile) && oElement.__opentip)
		{
			bi18n = 'on' === ($oEl.data('tooltip-i18n') || 'on');
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue);

			if (sValue)
			{
				oElement.__opentip.setContent(
					bi18n ? __webpack_require__(/*! Common/Translator */ 6).i18n(sValue) : sValue);
				oElement.__opentip.activate();
			}
			else
			{
				oElement.__opentip.hide();
				oElement.__opentip.deactivate();
				oElement.__opentip.setContent('');
			}
		}
	}
};

ko.bindingHandlers.tooltipErrorTip = {
	init: function(oElement) {

		var $oEl = $(oElement);

		oElement.__opentip = new Opentip(oElement, {
			'style': 'rainloopErrorTip',
			'hideOn': 'mouseout click',
			'element': oElement,
			'tipJoint': $oEl.data('tooltip-join') || 'top'
		});

		oElement.__opentip.deactivate();

		$(window.document).on('click', function() {
			if (oElement && oElement.__opentip)
			{
				oElement.__opentip.hide();
			}
		});

		fDisposalTooltipHelper(oElement);
	},
	update: function(oElement, fValueAccessor) {

		var
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue),
			oOpenTips = oElement.__opentip;

		if (oOpenTips)
		{
			if ('' === sValue)
			{
				oOpenTips.hide();
				oOpenTips.deactivate();
				oOpenTips.setContent('');
			}
			else
			{
				_.delay(function() {
					if ($oEl.is(':visible'))
					{
						oOpenTips.setContent(sValue);
						oOpenTips.activate();
						oOpenTips.show();
					}
					else
					{
						oOpenTips.hide();
						oOpenTips.deactivate();
						oOpenTips.setContent('');
					}
				}, 100);
			}
		}
	}
};

ko.bindingHandlers.registrateBootstrapDropdown = {
	init: function(oElement) {
		var Globals = __webpack_require__(/*! Common/Globals */ 5);
		if (Globals && Globals.data.aBootstrapDropdowns)
		{
			Globals.data.aBootstrapDropdowns.push($(oElement));

			$(oElement).click(function() {
				__webpack_require__(/*! Common/Utils */ 0).detectDropdownVisibility();
			});

//				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
//				});
		}
	}
};

ko.bindingHandlers.openDropdownTrigger = {
	update: function(oElement, fValueAccessor) {
		if (ko.unwrap(fValueAccessor()))
		{
			var $oEl = $(oElement);
			if (!$oEl.hasClass('open'))
			{
				$oEl.find('.dropdown-toggle').dropdown('toggle');
			}

			$oEl.find('.dropdown-toggle').focus();

			__webpack_require__(/*! Common/Utils */ 0).detectDropdownVisibility();
			fValueAccessor()(false);
		}
	}
};

ko.bindingHandlers.dropdownCloser = {
	init: function(oElement) {
		$(oElement).closest('.dropdown').on('click', '.e-item', function() {
			$(oElement).dropdown('toggle');
		});
	}
};

ko.bindingHandlers.popover = {
	init: function(oElement, fValueAccessor) {
		$(oElement).popover(ko.unwrap(fValueAccessor()));

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).popover('destroy');
		});
	}
};

ko.bindingHandlers.csstext = {};
ko.bindingHandlers.csstext.init = ko.bindingHandlers.csstext.update = function(oElement, fValueAccessor) {
	if (oElement && oElement.styleSheet && 'undefined' !== typeof oElement.styleSheet.cssText)
	{
		oElement.styleSheet.cssText = ko.unwrap(fValueAccessor());
	}
	else
	{
		$(oElement).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.resizecrop = {
	init: function(oElement) {
		$(oElement).addClass('resizecrop').resizecrop({
			'width': '100',
			'height': '100',
			'wrapperCSS': {
				'border-radius': '10px'
			}
		});
	},
	update: function(oElement, fValueAccessor) {
		fValueAccessor()();
		$(oElement).resizecrop({
			'width': '100',
			'height': '100'
		});
	}
};

ko.bindingHandlers.onEnter = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keypress.koOnEnter', function(oEvent) {
			if (oEvent && 13 === window.parseInt(oEvent.keyCode, 10))
			{
				$(oElement).trigger('change');
				fValueAccessor().call(oViewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keypress.koOnEnter');
		});
	}
};

ko.bindingHandlers.onSpace = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keyup.koOnSpace', function(oEvent) {
			if (oEvent && 32 === window.parseInt(oEvent.keyCode, 10))
			{
				fValueAccessor().call(oViewModel, oEvent);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keyup.koOnSpace');
		});
	}
};

ko.bindingHandlers.onTab = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keydown.koOnTab', function(oEvent) {
			if (oEvent && 9 === window.parseInt(oEvent.keyCode, 10))
			{
				return fValueAccessor().call(oViewModel, !!oEvent.shiftKey);
			}
			return true;
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keydown.koOnTab');
		});
	}
};

ko.bindingHandlers.onEsc = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keypress.koOnEsc', function(oEvent) {
			if (oEvent && 27 === window.parseInt(oEvent.keyCode, 10))
			{
				$(oElement).trigger('change');
				fValueAccessor().call(oViewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keypress.koOnEsc');
		});
	}
};

ko.bindingHandlers.clickOnTrue = {
	update: function(oElement, fValueAccessor) {
		if (ko.unwrap(fValueAccessor()))
		{
			$(oElement).click();
		}
	}
};

ko.bindingHandlers.modal = {
	init: function(oElement, fValueAccessor) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Utils = __webpack_require__(/*! Common/Utils */ 0);

		$(oElement).toggleClass('fade', !Globals.bMobileDevice).modal({
			'keyboard': false,
			'show': ko.unwrap(fValueAccessor())
		})
		.on('shown.koModal', Utils.windowResizeCallback)
		.find('.close').on('click.koModal', function() {
			fValueAccessor()(false);
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement)
				.off('shown.koModal')
				.find('.close')
				.off('click.koModal');
		});
	},
	update: function(oElement, fValueAccessor) {

		var Globals = __webpack_require__(/*! Common/Globals */ 5);

		$(oElement).modal(ko.unwrap(fValueAccessor()) ? 'show' : 'hide');

		if (Globals.$html.hasClass('rl-anim'))
		{
			Globals.$html.addClass('rl-modal-animation');
			_.delay(function() {
				Globals.$html.removeClass('rl-modal-animation');
			}, 400);
		}

	}
};

ko.bindingHandlers.moment = {
	init: function(oElement, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 26).momentToNode(
			$(oElement).addClass('moment').data('moment-time', ko.unwrap(fValueAccessor()))
		);
	},
	update: function(oElement, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 26).momentToNode(
			$(oElement).data('moment-time', ko.unwrap(fValueAccessor()))
		);
	}
};

ko.bindingHandlers.i18nInit = {
	init: function(oElement) {
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.translatorInit = {
	init: function(oElement) {
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.i18nUpdate = {
	update: function(oElement, fValueAccessor) {
		ko.unwrap(fValueAccessor());
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.link = {
	update: function(oElement, fValueAccessor) {
		$(oElement).attr('href', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.title = {
	update: function(oElement, fValueAccessor) {
		$(oElement).attr('title', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.textF = {
	init: function(oElement, fValueAccessor) {
		$(oElement).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.initDom = {
	init: function(oElement, fValueAccessor) {
		fValueAccessor()(oElement);
	}
};

ko.bindingHandlers.initFixedTrigger = {
	init: function(oElement, fValueAccessor) {
		var
			aValues = ko.unwrap(fValueAccessor()),
			$oContainer = null,
			$oElement = $(oElement),
			oOffset = null,

			iTop = aValues[1] || 0;

		$oContainer = $(aValues[0] || null);
		$oContainer = $oContainer[0] ? $oContainer : null;

		if ($oContainer)
		{
			$(window).resize(function() {
				oOffset = $oContainer.offset();
				if (oOffset && oOffset.top)
				{
					$oElement.css('top', oOffset.top + iTop);
				}
			});
		}
	}
};

ko.bindingHandlers.initResizeTrigger = {
	init: function(oElement, fValueAccessor) {
		var aValues = ko.unwrap(fValueAccessor());
		$(oElement).css({
			'height': aValues[1],
			'min-height': aValues[1]
		});
	},
	update: function(oElement, fValueAccessor) {

		var
			Utils = __webpack_require__(/*! Common/Utils */ 0),
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			aValues = ko.unwrap(fValueAccessor()),
			iValue = Utils.pInt(aValues[1]),
			iSize = 0,
			iOffset = $(oElement).offset().top;

		if (0 < iOffset)
		{
			iOffset += Utils.pInt(aValues[2]);
			iSize = Globals.$win.height() - iOffset;

			if (iValue < iSize)
			{
				iValue = iSize;
			}

			$(oElement).css({
				'height': iValue,
				'min-height': iValue
			});
		}
	}
};

ko.bindingHandlers.appendDom = {
	update: function(oElement, fValueAccessor) {
		$(oElement).hide().empty().append(ko.unwrap(fValueAccessor())).show();
	}
};

ko.bindingHandlers.draggable = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Utils = __webpack_require__(/*! Common/Utils */ 0);

		if (!Globals.bMobileDevice)
		{
			var
				iTriggerZone = 100,
				iScrollSpeed = 3,
				fAllValueFunc = fAllBindingsAccessor(),
				sDroppableSelector = fAllValueFunc && fAllValueFunc.droppableSelector ? fAllValueFunc.droppableSelector : '',
				oConf = {
					distance: 20,
					handle: '.dragHandle',
					cursorAt: {top: 22, left: 3},
					refreshPositions: true,
					scroll: true
				};

			if (sDroppableSelector)
			{
				oConf.drag = function(oEvent) {

					$(sDroppableSelector).each(function() {
						var
							moveUp = null,
							moveDown = null,
							$this = $(this),
							oOffset = $this.offset(),
							bottomPos = oOffset.top + $this.height();

						window.clearInterval($this.data('timerScroll'));
						$this.data('timerScroll', false);

						if (oEvent.pageX >= oOffset.left && oEvent.pageX <= oOffset.left + $this.width())
						{
							if (oEvent.pageY >= bottomPos - iTriggerZone && oEvent.pageY <= bottomPos)
							{
								moveUp = function() {
									$this.scrollTop($this.scrollTop() + iScrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', window.setInterval(moveUp, 10));
								moveUp();
							}

							if (oEvent.pageY >= oOffset.top && oEvent.pageY <= oOffset.top + iTriggerZone)
							{
								moveDown = function() {
									$this.scrollTop($this.scrollTop() - iScrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', window.setInterval(moveDown, 10));
								moveDown();
							}
						}
					});
				};

				oConf.stop = function() {
					$(sDroppableSelector).each(function() {
						window.clearInterval($(this).data('timerScroll'));
						$(this).data('timerScroll', false);
					});
				};
			}

			oConf.helper = function(oEvent) {
				return fValueAccessor()(oEvent && oEvent.target ? ko.dataFor(oEvent.target) : null);
			};

			$(oElement).draggable(oConf).on('mousedown.koDraggable', function() {
				Utils.removeInFocus();
			});

			ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
				$(oElement)
					.off('mousedown.koDraggable')
					.draggable('destroy');
			});
		}
	}
};

ko.bindingHandlers.droppable = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {
		var Globals = __webpack_require__(/*! Common/Globals */ 5);
		if (!Globals.bMobileDevice)
		{
			var
				fValueFunc = fValueAccessor(),
				fAllValueFunc = fAllBindingsAccessor(),
				fOverCallback = fAllValueFunc && fAllValueFunc.droppableOver ? fAllValueFunc.droppableOver : null,
				fOutCallback = fAllValueFunc && fAllValueFunc.droppableOut ? fAllValueFunc.droppableOut : null,
				oConf = {
					tolerance: 'pointer',
					hoverClass: 'droppableHover'
				};

			if (fValueFunc)
			{
				oConf.drop = function(oEvent, oUi) {
					fValueFunc(oEvent, oUi);
				};

				if (fOverCallback)
				{
					oConf.over = function(oEvent, oUi) {
						fOverCallback(oEvent, oUi);
					};
				}

				if (fOutCallback)
				{
					oConf.out = function(oEvent, oUi) {
						fOutCallback(oEvent, oUi);
					};
				}

				$(oElement).droppable(oConf);

				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
					$(oElement).droppable('destroy');
				});
			}
		}
	}
};

ko.bindingHandlers.nano = {
	init: function(oElement) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Settings = __webpack_require__(/*! Storage/Settings */ 7);

		if (!Globals.bDisableNanoScroll && !Settings.appSettingsGet('useNativeScrollbars'))
		{
			$(oElement)
				.addClass('nano')
				.nanoScroller({
					'iOSNativeScrolling': false,
					'preventPageScrolling': true
				});
		}
	}
};

ko.bindingHandlers.saveTrigger = {
	init: function(oElement) {

		var $oEl = $(oElement);

		$oEl.data('save-trigger-type', $oEl.is('input[type=text],input[type=email],input[type=password],select,textarea') ? 'input' : 'custom');

		if ('custom' === $oEl.data('save-trigger-type'))
		{
			$oEl.append(
				'&nbsp;&nbsp;<i class="icon-spinner animated"></i><i class="icon-remove error"></i><i class="icon-ok success"></i>'
			).addClass('settings-saved-trigger');
		}
		else
		{
			$oEl.addClass('settings-saved-trigger-input');
		}
	},
	update: function(oElement, fValueAccessor) {
		var
			mValue = ko.unwrap(fValueAccessor()),
			$oEl = $(oElement);

		if ('custom' === $oEl.data('save-trigger-type'))
		{
			switch (mValue.toString())
			{
				case '1':
					$oEl
						.find('.animated,.error').hide().removeClass('visible')
						.end()
						.find('.success').show().addClass('visible');
					break;
				case '0':
					$oEl
						.find('.animated,.success').hide().removeClass('visible')
						.end()
						.find('.error').show().addClass('visible');
					break;
				case '-2':
					$oEl
						.find('.error,.success').hide().removeClass('visible')
						.end()
						.find('.animated').show().addClass('visible');
					break;
				default:
					$oEl
						.find('.animated').hide()
						.end()
						.find('.error,.success').removeClass('visible');
					break;
			}
		}
		else
		{
			switch (mValue.toString())
			{
				case '1':
					$oEl.addClass('success').removeClass('error');
					break;
				case '0':
					$oEl.addClass('error').removeClass('success');
					break;
				case '-2':
//					$oEl;
					break;
				default:
					$oEl.removeClass('error success');
					break;
			}
		}
	}
};

ko.bindingHandlers.emailsTags = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {

		var
			Utils = __webpack_require__(/*! Common/Utils */ 0),
			EmailModel = __webpack_require__(/*! Model/Email */ 30).default,

			$oEl = $(oElement),
			fValue = fValueAccessor(),
			fAllBindings = fAllBindingsAccessor(),
			fAutoCompleteSource = fAllBindings.autoCompleteSource || null,
			fFocusCallback = function(bValue) {
				if (fValue && fValue.focused)
				{
					fValue.focused(!!bValue);
				}
			};

		$oEl.inputosaurus({
			'parseOnBlur': true,
			'allowDragAndDrop': true,
			'focusCallback': fFocusCallback,
			'inputDelimiters': [',', ';', '\n'],
			'autoCompleteSource': fAutoCompleteSource,
//				'elementHook': function(oEl, oItem) {
//					if (oEl && oItem)
//					{
//						oEl.addClass('pgp');
//						window.console.log(arguments);
//					}
//				},
			'parseHook': function(aInput) {

				return _.map(aInput, function(sInputValue) {

					var
						sValue = Utils.trim(sInputValue),
						oEmail = null;

					if ('' !== sValue)
					{
						oEmail = new EmailModel();
						oEmail.mailsoParse(sValue);
						return [oEmail.toLine(false), oEmail];
					}

					return [sValue, null];

				});

//					var aResult = [];
//
//					_.each(aInput, function(sInputValue) {
//
//						var
//							aM = null,
//							aValues = [],
//							sValue = Utils.trim(sInputValue),
//							oEmail = null
//						;
//
//						if ('' !== sValue)
//						{
//							aM = sValue.match(/[@]/g);
//							if (aM && 0 < aM.length)
//							{
//								sValue = sValue.replace(/[\r\n]+/g, '; ').replace(/[\s]+/g, ' ');
//								aValues = EmailModel.splitHelper(sValue, ';');
//
//								_.each(aValues, function(sV) {
//
//									oEmail = new EmailModel();
//									oEmail.mailsoParse(sV);
//
//									if (oEmail.email)
//									{
//										aResult.push([oEmail.toLine(false), oEmail]);
//									}
//									else
//									{
//										aResult.push(['', null]);
//									}
//								});
//							}
//							else
//							{
//								aResult.push([sInputValue, null]);
//							}
//						}
//						else
//						{
//							aResult.push([sInputValue, null]);
//						}
//					});
//
//					return aResult;
			},
			'change': _.bind(function(oEvent) {
				$oEl.data('EmailsTagsValue', oEvent.target.value);
				fValue(oEvent.target.value);
			}, this)
		});

		if (fValue && fValue.focused && fValue.focused.subscribe)
		{
			fValue.focused.subscribe(function(bValue) {
				$oEl.inputosaurus(bValue ? 'focus' : 'blur');
			});
		}
	},
	update: function(oElement, fValueAccessor) {

		var
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			sValue = ko.unwrap(fValue);

		if ($oEl.data('EmailsTagsValue') !== sValue)
		{
			$oEl.val(sValue);
			$oEl.data('EmailsTagsValue', sValue);
			$oEl.inputosaurus('refresh');
		}
	}
};

ko.bindingHandlers.command = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		var
			jqElement = $(oElement),
			oCommand = fValueAccessor();

		if (!oCommand || !oCommand.enabled || !oCommand.canExecute)
		{
			throw new Error('You are not using command function');
		}

		jqElement.addClass('command');
		ko.bindingHandlers[jqElement.is('form') ? 'submit' : 'click']
			.init.apply(oViewModel, Array.prototype.slice.call(arguments)); // eslint-disable-line prefer-rest-params
	},

	update: function(oElement, fValueAccessor) {

		var
			bResult = true,
			jqElement = $(oElement),
			oCommand = fValueAccessor();

		bResult = oCommand.enabled();
		jqElement.toggleClass('command-not-enabled', !bResult);

		if (bResult)
		{
			bResult = oCommand.canExecute();
			jqElement.toggleClass('command-can-not-be-execute', !bResult);
		}

		jqElement.toggleClass('command-disabled disable disabled', !bResult).toggleClass('no-disabled', !!bResult);

		if (jqElement.is('input') || jqElement.is('button'))
		{
			jqElement.prop('disabled', !bResult);
		}
	}
};

// extenders

ko.extenders.trimmer = function(oTarget)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {
				oTarget(Utils.trim(sNewValue.toString()));
			},
			'owner': this
		});

	oResult(oTarget());
	return oResult;
};

ko.extenders.posInterer = function(oTarget, iDefault)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {
				var iNew = Utils.pInt(sNewValue.toString(), iDefault);
				if (0 >= iNew)
				{
					iNew = iDefault;
				}

				if (iNew === oTarget() && '' + iNew !== '' + sNewValue)
				{
					oTarget(iNew + 1);
				}

				oTarget(iNew);
			}
		});

	oResult(oTarget());
	return oResult;
};

ko.extenders.limitedList = function(oTarget, mList)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {

				var
					sCurrentValue = ko.unwrap(oTarget),
					aList = ko.unwrap(mList);

				if (Utils.isNonEmptyArray(aList))
				{
					if (-1 < Utils.inArray(sNewValue, aList))
					{
						oTarget(sNewValue);
					}
					else if (-1 < Utils.inArray(sCurrentValue, aList))
					{
						oTarget(sCurrentValue + ' ');
						oTarget(sCurrentValue);
					}
					else
					{
						oTarget(aList[0] + ' ');
						oTarget(aList[0]);
					}
				}
				else
				{
					oTarget('');
				}
			}
		}).extend({'notify': 'always'});

	oResult(oTarget());

	if (!oResult.valueHasMutated)
	{
		oResult.valueHasMutated = function() {
			oTarget.valueHasMutated();
		};
	}

	return oResult;
};

ko.extenders.reversible = function(oTarget)
{
	var mValue = oTarget();

	oTarget.commit = function()
	{
		mValue = oTarget();
	};

	oTarget.reverse = function()
	{
		oTarget(mValue);
	};

	oTarget.commitedValue = function()
	{
		return mValue;
	};

	return oTarget;
};

ko.extenders.toggleSubscribe = function(oTarget, oOptions)
{
	oTarget.subscribe(oOptions[1], oOptions[0], 'beforeChange');
	oTarget.subscribe(oOptions[2], oOptions[0]);

	return oTarget;
};

ko.extenders.toggleSubscribeProperty = function(oTarget, oOptions)
{
	var sProp = oOptions[1];

	if (sProp)
	{
		oTarget.subscribe(function(oPrev) {
			if (oPrev && oPrev[sProp])
			{
				oPrev[sProp](false);
			}
		}, oOptions[0], 'beforeChange');

		oTarget.subscribe(function(oNext) {
			if (oNext && oNext[sProp])
			{
				oNext[sProp](true);
			}
		}, oOptions[0]);
	}

	return oTarget;
};

ko.extenders.falseTimeout = function(oTarget, iOption)
{
	oTarget.iFalseTimeoutTimeout = 0;
	oTarget.subscribe(function(bValue) {
		if (bValue)
		{
			window.clearTimeout(oTarget.iFalseTimeoutTimeout);
			oTarget.iFalseTimeoutTimeout = window.setTimeout(function() {
				oTarget(false);
				oTarget.iFalseTimeoutTimeout = 0;
			}, __webpack_require__(/*! Common/Utils */ 0).pInt(iOption));
		}
	});

	return oTarget;
};

ko.extenders.specialThrottle = function(oTarget, iOption)
{
	oTarget.iSpecialThrottleTimeoutValue = __webpack_require__(/*! Common/Utils */ 0).pInt(iOption);
	if (0 < oTarget.iSpecialThrottleTimeoutValue)
	{
		oTarget.iSpecialThrottleTimeout = 0;
		oTarget.valueForRead = ko.observable(!!oTarget()).extend({'throttle': 10});

		return ko.computed({
			'read': oTarget.valueForRead,
			'write': function(bValue) {

				if (bValue)
				{
					oTarget.valueForRead(bValue);
				}
				else
				{
					if (oTarget.valueForRead())
					{
						window.clearTimeout(oTarget.iSpecialThrottleTimeout);
						oTarget.iSpecialThrottleTimeout = window.setTimeout(function() {
							oTarget.valueForRead(false);
							oTarget.iSpecialThrottleTimeout = 0;
						}, oTarget.iSpecialThrottleTimeoutValue);
					}
					else
					{
						oTarget.valueForRead(bValue);
					}
				}
			}
		});
	}

	return oTarget;
};

// functions

ko.observable.fn.validateNone = function()
{
	this.hasError = ko.observable(false);
	return this;
};

ko.observable.fn.validateEmail = function()
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasError = ko.observable(false);

	this.subscribe(function(sValue) {
		sValue = Utils.trim(sValue);
		this.hasError('' !== sValue && !(/^[^@\s]+@[^@\s]+$/.test(sValue)));
	}, this);

	this.valueHasMutated();
	return this;
};

ko.observable.fn.validateSimpleEmail = function()
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasError = ko.observable(false);

	this.subscribe(function(sValue) {
		sValue = Utils.trim(sValue);
		this.hasError('' !== sValue && !(/^.+@.+$/.test(sValue)));
	}, this);

	this.valueHasMutated();
	return this;
};

ko.observable.fn.deleteAccessHelper = function()
{
	this.extend({'falseTimeout': 3000}).extend({'toggleSubscribe': [null,
		function(oPrev) {
			if (oPrev && oPrev.deleteAccess)
			{
				oPrev.deleteAccess(false);
			}
		}, function(oNext) {
			if (oNext && oNext.deleteAccess)
			{
				oNext.deleteAccess(true);
			}
		}
	]});

	return this;
};

ko.observable.fn.validateFunc = function(fFunc)
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasFuncError = ko.observable(false);

	if (Utils.isFunc(fFunc))
	{
		this.subscribe(function(sValue) {
			this.hasFuncError(!fFunc(sValue));
		}, this);

		this.valueHasMutated();
	}

	return this;
};

module.exports = ko;


/***/ },
/* 2 */
/*!***************************!*\
  !*** external "window._" ***!
  \***************************/
/***/ function(module, exports) {

module.exports = window._;

/***/ },
/* 3 */
/*!******************************!*\
  !*** ./dev/Common/Enums.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "FileType", function() { return FileType; });
/* harmony export */ __webpack_require__.d(exports, "StorageResultType", function() { return StorageResultType; });
/* harmony export */ __webpack_require__.d(exports, "Focused", function() { return Focused; });
/* harmony export */ __webpack_require__.d(exports, "State", function() { return State; });
/* harmony export */ __webpack_require__.d(exports, "StateType", function() { return StateType; });
/* harmony export */ __webpack_require__.d(exports, "Capa", function() { return Capa; });
/* harmony export */ __webpack_require__.d(exports, "KeyState", function() { return KeyState; });
/* harmony export */ __webpack_require__.d(exports, "FolderType", function() { return FolderType; });
/* harmony export */ __webpack_require__.d(exports, "ServerFolderType", function() { return ServerFolderType; });
/* harmony export */ __webpack_require__.d(exports, "LoginSignMeTypeAsString", function() { return LoginSignMeTypeAsString; });
/* harmony export */ __webpack_require__.d(exports, "LoginSignMeType", function() { return LoginSignMeType; });
/* harmony export */ __webpack_require__.d(exports, "ComposeType", function() { return ComposeType; });
/* harmony export */ __webpack_require__.d(exports, "UploadErrorCode", function() { return UploadErrorCode; });
/* harmony export */ __webpack_require__.d(exports, "SetSystemFoldersNotification", function() { return SetSystemFoldersNotification; });
/* harmony export */ __webpack_require__.d(exports, "ClientSideKeyName", function() { return ClientSideKeyName; });
/* harmony export */ __webpack_require__.d(exports, "EventKeyCode", function() { return EventKeyCode; });
/* harmony export */ __webpack_require__.d(exports, "MessageSetAction", function() { return MessageSetAction; });
/* harmony export */ __webpack_require__.d(exports, "MessageSelectAction", function() { return MessageSelectAction; });
/* harmony export */ __webpack_require__.d(exports, "DesktopNotification", function() { return DesktopNotification; });
/* harmony export */ __webpack_require__.d(exports, "MessagePriority", function() { return MessagePriority; });
/* harmony export */ __webpack_require__.d(exports, "EditorDefaultType", function() { return EditorDefaultType; });
/* harmony export */ __webpack_require__.d(exports, "ServerSecure", function() { return ServerSecure; });
/* harmony export */ __webpack_require__.d(exports, "SearchDateType", function() { return SearchDateType; });
/* harmony export */ __webpack_require__.d(exports, "SaveSettingsStep", function() { return SaveSettingsStep; });
/* harmony export */ __webpack_require__.d(exports, "Layout", function() { return Layout; });
/* harmony export */ __webpack_require__.d(exports, "FilterConditionField", function() { return FilterConditionField; });
/* harmony export */ __webpack_require__.d(exports, "FilterConditionType", function() { return FilterConditionType; });
/* harmony export */ __webpack_require__.d(exports, "FiltersAction", function() { return FiltersAction; });
/* harmony export */ __webpack_require__.d(exports, "FilterRulesType", function() { return FilterRulesType; });
/* harmony export */ __webpack_require__.d(exports, "SignedVerifyStatus", function() { return SignedVerifyStatus; });
/* harmony export */ __webpack_require__.d(exports, "ContactPropertyType", function() { return ContactPropertyType; });
/* harmony export */ __webpack_require__.d(exports, "Magics", function() { return Magics; });
/* harmony export */ __webpack_require__.d(exports, "Ports", function() { return Ports; });
/* harmony export */ __webpack_require__.d(exports, "Notification", function() { return Notification; });
/* eslint quote-props: 0 */

/**
 * @enum {string}
 */
var FileType = {
	'Unknown': 'unknown',
	'Text': 'text',
	'Html': 'html',
	'Code': 'code',
	'Eml': 'eml',
	'WordText': 'word-text',
	'Pdf': 'pdf',
	'Image': 'image',
	'Audio': 'audio',
	'Video': 'video',
	'Sheet': 'sheet',
	'Presentation': 'presentation',
	'Certificate': 'certificate',
	'CertificateBin': 'certificate-bin',
	'Archive': 'archive'
};

/**
 * @enum {string}
 */
var StorageResultType = {
	'Success': 'success',
	'Abort': 'abort',
	'Error': 'error',
	'Unload': 'unload'
};

/**
 * @enum {string}
 */
var Focused = {
	'None': 'none',
	'MessageList': 'message-list',
	'MessageView': 'message-view',
	'FolderList': 'folder-list'
};

/**
 * @enum {number}
 */
var State = {
	'Empty': 10,
	'Login': 20,
	'Auth': 30
};

/**
 * @enum {number}
 */
var StateType = {
	'Webmail': 0,
	'Admin': 1
};

/**
 * @enum {string}
 */
var Capa = {
	'TwoFactor': 'TWO_FACTOR',
	'TwoFactorForce': 'TWO_FACTOR_FORCE',
	'OpenPGP': 'OPEN_PGP',
	'Prefetch': 'PREFETCH',
	'Gravatar': 'GRAVATAR',
	'Folders': 'FOLDERS',
	'Composer': 'COMPOSER',
	'Contacts': 'CONTACTS',
	'Reload': 'RELOAD',
	'Search': 'SEARCH',
	'SearchAdv': 'SEARCH_ADV',
	'MessageActions': 'MESSAGE_ACTIONS',
	'MessageListActions': 'MESSAGELIST_ACTIONS',
	'AttachmentsActions': 'ATTACHMENTS_ACTIONS',
	'DangerousActions': 'DANGEROUS_ACTIONS',
	'Settings': 'SETTINGS',
	'Help': 'HELP',
	'Themes': 'THEMES',
	'UserBackground': 'USER_BACKGROUND',
	'Sieve': 'SIEVE',
	'Filters': 'FILTERS',
	'AttachmentThumbnails': 'ATTACHMENT_THUMBNAILS',
	'Templates': 'TEMPLATES',
	'AutoLogout': 'AUTOLOGOUT',
	'AdditionalAccounts': 'ADDITIONAL_ACCOUNTS',
	'Identities': 'IDENTITIES'
};

/**
 * @enum {string}
 */
var KeyState = {
	'All': 'all',
	'None': 'none',
	'ContactList': 'contact-list',
	'MessageList': 'message-list',
	'FolderList': 'folder-list',
	'MessageView': 'message-view',
	'Compose': 'compose',
	'Settings': 'settings',
	'Menu': 'menu',
	'PopupComposeOpenPGP': 'compose-open-pgp',
	'PopupMessageOpenPGP': 'message-open-pgp',
	'PopupViewOpenPGP': 'view-open-pgp',
	'PopupKeyboardShortcutsHelp': 'popup-keyboard-shortcuts-help',
	'PopupAsk': 'popup-ask'
};

/**
 * @enum {number}
 */
var FolderType = {
	'Inbox': 10,
	'SentItems': 11,
	'Draft': 12,
	'Trash': 13,
	'Spam': 14,
	'Archive': 15,
	'NotSpam': 80,
	'User': 99
};

/**
 * @enum {number}
 */
var ServerFolderType = {
	'USER': 0,
	'INBOX': 1,
	'SENT': 2,
	'DRAFTS': 3,
	'JUNK': 4,
	'TRASH': 5,
	'IMPORTANT': 10,
	'FLAGGED': 11,
	'ALL': 12
};

/**
 * @enum {string}
 */
var LoginSignMeTypeAsString = {
	'DefaultOff': 'defaultoff',
	'DefaultOn': 'defaulton',
	'Unused': 'unused'
};

/**
 * @enum {number}
 */
var LoginSignMeType = {
	'DefaultOff': 0,
	'DefaultOn': 1,
	'Unused': 2
};

/**
 * @enum {string}
 */
var ComposeType = {
	'Empty': 'empty',
	'Reply': 'reply',
	'ReplyAll': 'replyall',
	'Forward': 'forward',
	'ForwardAsAttachment': 'forward-as-attachment',
	'Draft': 'draft',
	'EditAsNew': 'editasnew'
};

/**
 * @enum {number}
 */
var UploadErrorCode = {
	'Normal': 0,
	'FileIsTooBig': 1,
	'FilePartiallyUploaded': 2,
	'FileNoUploaded': 3,
	'MissingTempFolder': 4,
	'FileOnSaveingError': 5,
	'FileType': 98,
	'Unknown': 99
};

/**
 * @enum {number}
 */
var SetSystemFoldersNotification = {
	'None': 0,
	'Sent': 1,
	'Draft': 2,
	'Spam': 3,
	'Trash': 4,
	'Archive': 5
};

/**
 * @enum {number}
 */
var ClientSideKeyName = {
	'FoldersLashHash': 0,
	'MessagesInboxLastHash': 1,
	'MailBoxListSize': 2,
	'ExpandedFolders': 3,
	'FolderListSize': 4,
	'MessageListSize': 5,
	'LastReplyAction': 6,
	'LastSignMe': 7,
	'ComposeLastIdentityID': 8,
	'MessageHeaderFullInfo': 9
};

/**
 * @enum {number}
 */
var EventKeyCode = {
	'Backspace': 8,
	'Tab': 9,
	'Enter': 13,
	'Esc': 27,
	'PageUp': 33,
	'PageDown': 34,
	'Left': 37,
	'Right': 39,
	'Up': 38,
	'Down': 40,
	'End': 35,
	'Home': 36,
	'Space': 32,
	'Insert': 45,
	'Delete': 46,
	'A': 65,
	'S': 83
};

/**
 * @enum {number}
 */
var MessageSetAction = {
	'SetSeen': 0,
	'UnsetSeen': 1,
	'SetFlag': 2,
	'UnsetFlag': 3
};

/**
 * @enum {number}
 */
var MessageSelectAction = {
	'All': 0,
	'None': 1,
	'Invert': 2,
	'Unseen': 3,
	'Seen': 4,
	'Flagged': 5,
	'Unflagged': 6
};

/**
 * @enum {number}
 */
var DesktopNotification = {
	'Allowed': 0,
	'NotAllowed': 1,
	'Denied': 2,
	'NotSupported': 9
};

/**
 * @enum {number}
 */
var MessagePriority = {
	'Low': 5,
	'Normal': 3,
	'High': 1
};

/**
 * @enum {string}
 */
var EditorDefaultType = {
	'Html': 'Html',
	'Plain': 'Plain',
	'HtmlForced': 'HtmlForced',
	'PlainForced': 'PlainForced'
};

/**
 * @enum {number}
 */
var ServerSecure = {
	'None': 0,
	'SSL': 1,
	'TLS': 2
};

/**
 * @enum {number}
 */
var SearchDateType = {
	'All': -1,
	'Days3': 3,
	'Days7': 7,
	'Month': 30
};

/**
 * @enum {number}
 */
var SaveSettingsStep = {
	'Animate': -2,
	'Idle': -1,
	'TrueResult': 1,
	'FalseResult': 0
};

/**
 * @enum {number}
 */
var Layout = {
	'NoPreview': 0,
	'SidePreview': 1,
	'BottomPreview': 2
};

/**
 * @enum {string}
 */
var FilterConditionField = {
	'From': 'From',
	'Recipient': 'Recipient',
	'Subject': 'Subject',
	'Header': 'Header',
	'Size': 'Size'
};

/**
 * @enum {string}
 */
var FilterConditionType = {
	'Contains': 'Contains',
	'NotContains': 'NotContains',
	'EqualTo': 'EqualTo',
	'NotEqualTo': 'NotEqualTo',
	'Regex': 'Regex',
	'Over': 'Over',
	'Under': 'Under'
};

/**
 * @enum {string}
 */
var FiltersAction = {
	'None': 'None',
	'MoveTo': 'MoveTo',
	'Discard': 'Discard',
	'Vacation': 'Vacation',
	'Reject': 'Reject',
	'Forward': 'Forward'
};

/**
 * @enum {string}
 */
var FilterRulesType = {
	'All': 'All',
	'Any': 'Any'
};

/**
 * @enum {number}
 */
var SignedVerifyStatus = {
	'UnknownPublicKeys': -4,
	'UnknownPrivateKey': -3,
	'Unverified': -2,
	'Error': -1,
	'None': 0,
	'Success': 1
};

/**
 * @enum {number}
 */
var ContactPropertyType = {

	'Unknown': 0,

	'FullName': 10,

	'FirstName': 15,
	'LastName': 16,
	'MiddleName': 16,
	'Nick': 18,

	'NamePrefix': 20,
	'NameSuffix': 21,

	'Email': 30,
	'Phone': 31,
	'Web': 32,

	'Birthday': 40,

	'Facebook': 90,
	'Skype': 91,
	'GitHub': 92,

	'Note': 110,

	'Custom': 250
};

/**
 * @enum {number}
 */
var Magics = {
	'EventWhichMouseMiddle': 3,
	'ifvisibleIdle10s': 10,

	'BitLength2048': 2048,
	'BitLength1024': 1024,

	'Size50px': 50,
	'Size20px': 20,
	'Size1px': 1,

	'Time1m': 60000,
	'Time30s': 30000,
	'Time7s': 7000,
	'Time5s': 5000,
	'Time3s': 3000,
	'Time1s': 1000,
	'Time500ms': 500,
	'Time350ms': 350,
	'Time250ms': 250,
	'Time200ms': 200,
	'Time100ms': 100,
	'Time50ms': 50,
	'Time20ms': 20
};

/**
 * @enum {number}
 */
var Ports = {
	'Imap': 143,
	'ImapSsl': 993,
	'Smtp': 25,
	'SmtpSsl': 465,
	'SmtpStartTls': 587
};

/**
 * @enum {number}
 */
var Notification = {
	'InvalidToken': 101,
	'AuthError': 102,
	'AccessError': 103,
	'ConnectionError': 104,
	'CaptchaError': 105,
	'SocialFacebookLoginAccessDisable': 106,
	'SocialTwitterLoginAccessDisable': 107,
	'SocialGoogleLoginAccessDisable': 108,
	'DomainNotAllowed': 109,
	'AccountNotAllowed': 110,

	'AccountTwoFactorAuthRequired': 120,
	'AccountTwoFactorAuthError': 121,

	'CouldNotSaveNewPassword': 130,
	'CurrentPasswordIncorrect': 131,
	'NewPasswordShort': 132,
	'NewPasswordWeak': 133,
	'NewPasswordForbidden': 134,

	'ContactsSyncError': 140,

	'CantGetMessageList': 201,
	'CantGetMessage': 202,
	'CantDeleteMessage': 203,
	'CantMoveMessage': 204,
	'CantCopyMessage': 205,

	'CantSaveMessage': 301,
	'CantSendMessage': 302,
	'InvalidRecipients': 303,

	'CantSaveFilters': 351,
	'CantGetFilters': 352,
	'FiltersAreNotCorrect': 355,

	'CantCreateFolder': 400,
	'CantRenameFolder': 401,
	'CantDeleteFolder': 402,
	'CantSubscribeFolder': 403,
	'CantUnsubscribeFolder': 404,
	'CantDeleteNonEmptyFolder': 405,

	'CantSaveSettings': 501,
	'CantSavePluginSettings': 502,

	'DomainAlreadyExists': 601,

	'CantInstallPackage': 701,
	'CantDeletePackage': 702,
	'InvalidPluginPackage': 703,
	'UnsupportedPluginPackage': 704,

	'LicensingServerIsUnavailable': 710,
	'LicensingExpired': 711,
	'LicensingBanned': 712,

	'DemoSendMessageError': 750,
	'DemoAccountError': 751,

	'AccountAlreadyExists': 801,
	'AccountDoesNotExist': 802,

	'MailServerError': 901,
	'ClientViewError': 902,
	'InvalidInputArgument': 903,

	'AjaxFalse': 950,
	'AjaxAbort': 951,
	'AjaxParse': 952,
	'AjaxTimeout': 953,

	'UnknownNotification': 999,
	'UnknownError': 999
};

/***/ },
/* 4 */
/*!*****************************!*\
  !*** ./dev/Knoin/Knoin.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher__ = __webpack_require__(/*! hasher */ 87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher___default = __WEBPACK_IMPORTED_MODULE_3_hasher__ && __WEBPACK_IMPORTED_MODULE_3_hasher__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_hasher__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_hasher__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_hasher___default, 'a', __WEBPACK_IMPORTED_MODULE_3_hasher___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads__ = __webpack_require__(/*! crossroads */ 48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads___default = __WEBPACK_IMPORTED_MODULE_4_crossroads__ && __WEBPACK_IMPORTED_MODULE_4_crossroads__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_4_crossroads__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_4_crossroads__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_4_crossroads___default, 'a', __WEBPACK_IMPORTED_MODULE_4_crossroads___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony export */ exports["hideLoading"] = hideLoading;/* harmony export */ exports["constructorEnd"] = constructorEnd;/* harmony export */ exports["extendAsViewModel"] = extendAsViewModel;/* harmony export */ exports["addSettingsViewModel"] = addSettingsViewModel;/* harmony export */ exports["removeSettingsViewModel"] = removeSettingsViewModel;/* harmony export */ exports["disableSettingsViewModel"] = disableSettingsViewModel;/* harmony export */ exports["routeOff"] = routeOff;/* harmony export */ exports["routeOn"] = routeOn;/* harmony export */ exports["screen"] = screen;/* harmony export */ exports["hideScreenPopup"] = hideScreenPopup;/* harmony export */ exports["vmRunHook"] = vmRunHook;/* harmony export */ exports["buildViewModel"] = buildViewModel;/* harmony export */ exports["showScreenPopup"] = showScreenPopup;/* harmony export */ exports["isPopupVisible"] = isPopupVisible;/* harmony export */ exports["screenOnRoute"] = screenOnRoute;/* harmony export */ exports["startScreens"] = startScreens;/* harmony export */ exports["setHash"] = setHash;











var currentScreen = null,
    defaultScreenName = '';

var SCREENS = {};

/**
 * @returns {void}
 */
function hideLoading() {
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content').addClass('rl-content-show');
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-loading').hide().remove();
}

/**
 * @param {Object} context
 * @returns {void}
 */
function constructorEnd(context) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isFunc"])(context.__constructor_end)) {
		context.__constructor_end();
	}
}

/**
 * @param {string|Array} name
 * @param {Function} ViewModelClass
 * @returns {void}
 */
function extendAsViewModel(name, ViewModelClass) {
	if (ViewModelClass) {
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(name)) {
			ViewModelClass.__names = name;
		} else {
			ViewModelClass.__names = [name];
		}

		ViewModelClass.__name = ViewModelClass.__names[0];
	}
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} template
 * @param {string} labelName
 * @param {string} route
 * @param {boolean=} isDefault = false
 * @returns {void}
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	var isDefault = arguments.length <= 4 || arguments[4] === undefined ? false : arguments[4];

	SettingsViewModelClass.__rlSettingsData = {
		Label: labelName,
		Template: template,
		Route: route,
		IsDefault: !!isDefault
	};

	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"].settings.push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function removeSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"]['settings-removed'].push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function disableSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"]['settings-disabled'].push(SettingsViewModelClass);
}

/**
 * @returns {void}
 */
function routeOff() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
}

/**
 * @returns {void}
 */
function routeOn() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
}

/**
 * @param {string} screenName
 * @returns {?Object}
 */
function screen(screenName) {
	return '' !== screenName && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(SCREENS[screenName]) ? SCREENS[screenName] : null;
}

/**
 * @param {Function} ViewModelClassToHide
 * @returns {void}
 */
function hideScreenPopup(ViewModelClassToHide) {
	if (ViewModelClassToHide && ViewModelClassToHide.__vm && ViewModelClassToHide.__dom) {
		ViewModelClassToHide.__vm.modalVisibility(false);
	}
}

/**
 * @param {string} hookName
 * @param {Function} ViewModelClass
 * @param {mixed=} params = null
 */
function vmRunHook(hookName, ViewModelClass) {
	var params = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(ViewModelClass.__names, function (name) {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])(hookName, [name, ViewModelClass.__vm, params]);
	});
}

/**
 * @param {Function} ViewModelClass
 * @param {Object=} vmScreen
 * @returns {*}
 */
function buildViewModel(ViewModelClass, vmScreen) {
	if (ViewModelClass && !ViewModelClass.__builded) {
		(function () {
			var vmDom = null;
			var vm = new ViewModelClass(vmScreen),
			    position = vm.viewModelPosition(),
			    vmPlace = __WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content #rl-' + position.toLowerCase());

			ViewModelClass.__builded = true;
			ViewModelClass.__vm = vm;

			vm.onShowTrigger = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
			vm.onHideTrigger = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

			vm.viewModelName = ViewModelClass.__name;
			vm.viewModelNames = ViewModelClass.__names;

			if (vmPlace && 1 === vmPlace.length) {
				vmDom = __WEBPACK_IMPORTED_MODULE_1_____default()('<div></div>').addClass('rl-view-model').addClass('RL-' + vm.viewModelTemplate()).hide();
				vmDom.appendTo(vmPlace);

				vm.viewModelDom = vmDom;
				ViewModelClass.__dom = vmDom;

				if ('Popups' === position) {
					vm.cancelCommand = vm.closeCommand = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["createCommand"])(vm, function () {
						hideScreenPopup(ViewModelClass);
					});

					vm.modalVisibility.subscribe(function (value) {
						if (value) {
							vm.viewModelDom.show();
							vm.storeAndSetKeyScope();

							__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"].push(vm.viewModelName);
							vm.viewModelDom.css('z-index', 3000 + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"])().length + 10);

							if (vm.onShowTrigger) {
								vm.onShowTrigger(!vm.onShowTrigger());
							}

							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onShowWithDelay', [], 500);
						} else {
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onHide');
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onHideWithDelay', [], 500);

							if (vm.onHideTrigger) {
								vm.onHideTrigger(!vm.onHideTrigger());
							}

							vm.restoreKeyScope();

							vmRunHook('view-model-on-hide', ViewModelClass);

							__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"].remove(vm.viewModelName);
							vm.viewModelDom.css('z-index', 2000);

							__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
								return vm.viewModelDom.hide();
							}, 300);
						}
					});
				}

				vmRunHook('view-model-pre-build', ViewModelClass, vmDom);

				__WEBPACK_IMPORTED_MODULE_2_ko___default.a.applyBindingAccessorsToNode(vmDom[0], {
					translatorInit: true,
					template: function template() {
						return { name: vm.viewModelTemplate() };
					}
				}, vm);

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onBuild', [vmDom]);
				if (vm && 'Popups' === position) {
					vm.registerPopupKeyDown();
				}

				vmRunHook('view-model-post-build', ViewModelClass, vmDom);
			} else {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["log"])('Cannot find view model position: ' + position);
			}
		})();
	}

	return ViewModelClass ? ViewModelClass.__vm : null;
}

/**
 * @param {Function} ViewModelClassToShow
 * @param {Array=} params
 * @returns {void}
 */
function showScreenPopup(ViewModelClassToShow) {
	var params = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

	if (ViewModelClassToShow) {
		buildViewModel(ViewModelClassToShow);

		if (ViewModelClassToShow.__vm && ViewModelClassToShow.__dom) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClassToShow.__vm, 'onBeforeShow', params || []);

			ViewModelClassToShow.__vm.modalVisibility(true);

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClassToShow.__vm, 'onShow', params || []);

			vmRunHook('view-model-on-show', ViewModelClassToShow, params || []);
		}
	}
}

/**
 * @param {Function} ViewModelClassToShow
 * @returns {boolean}
 */
function isPopupVisible(ViewModelClassToShow) {
	return ViewModelClassToShow && ViewModelClassToShow.__vm ? ViewModelClassToShow.__vm.modalVisibility() : false;
}

/**
 * @param {string} screenName
 * @param {string} subPart
 * @returns {void}
 */
function screenOnRoute(screenName, subPart) {
	var vmScreen = null,
	    isSameScreen = false,
	    cross = null;

	if ('' === __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(screenName)) {
		screenName = defaultScreenName;
	}

	if ('' !== screenName) {
		vmScreen = screen(screenName);
		if (!vmScreen) {
			vmScreen = screen(defaultScreenName);
			if (vmScreen) {
				subPart = screenName + '/' + subPart;
				screenName = defaultScreenName;
			}
		}

		if (vmScreen && vmScreen.__started) {
			isSameScreen = currentScreen && vmScreen === currentScreen;

			if (!vmScreen.__builded) {
				vmScreen.__builded = true;

				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(vmScreen.viewModels())) {
					__WEBPACK_IMPORTED_MODULE_0_____default.a.each(vmScreen.viewModels(), function (ViewModelClass) {
						buildViewModel(ViewModelClass, vmScreen);
					});
				}

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vmScreen, 'onBuild');
			}

			__WEBPACK_IMPORTED_MODULE_0_____default.a.defer(function () {
				// hide screen
				if (currentScreen && !isSameScreen) {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onHide');
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onHideWithDelay', [], 500);

					if (currentScreen.onHideTrigger) {
						currentScreen.onHideTrigger(!currentScreen.onHideTrigger());
					}

					if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {
							if (ViewModelClass.__vm && ViewModelClass.__dom && 'Popups' !== ViewModelClass.__vm.viewModelPosition()) {
								ViewModelClass.__dom.hide();
								ViewModelClass.__vm.viewModelVisibility(false);

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHide');
								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHideWithDelay', [], 500);

								if (ViewModelClass.__vm.onHideTrigger) {
									ViewModelClass.__vm.onHideTrigger(!ViewModelClass.__vm.onHideTrigger());
								}
							}
						});
					}
				}
				// --

				currentScreen = vmScreen;

				// show screen
				if (currentScreen && !isSameScreen) {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onShow');
					if (currentScreen.onShowTrigger) {
						currentScreen.onShowTrigger(!currentScreen.onShowTrigger());
					}

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-on-show', [currentScreen.screenName(), currentScreen]);

					if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {

							if (ViewModelClass.__vm && ViewModelClass.__dom && 'Popups' !== ViewModelClass.__vm.viewModelPosition()) {
								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onBeforeShow');

								ViewModelClass.__dom.show();
								ViewModelClass.__vm.viewModelVisibility(true);

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShow');
								if (ViewModelClass.__vm.onShowTrigger) {
									ViewModelClass.__vm.onShowTrigger(!ViewModelClass.__vm.onShowTrigger());
								}

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShowWithDelay', [], 200);
								vmRunHook('view-model-on-show', ViewModelClass);
							}
						});
					}
				}
				// --

				cross = vmScreen.__cross ? vmScreen.__cross() : null;
				if (cross) {
					cross.parse(subPart);
				}
			});
		}
	}
}

/**
 * @param {Array} screensClasses
 * @returns {void}
 */
function startScreens(screensClasses) {
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(screensClasses, function (CScreen) {
		if (CScreen) {
			var vmScreen = new CScreen(),
			    screenName = vmScreen ? vmScreen.screenName() : '';

			if (vmScreen && '' !== screenName) {
				if ('' === defaultScreenName) {
					defaultScreenName = screenName;
				}

				SCREENS[screenName] = vmScreen;
			}
		}
	});

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SCREENS, function (vmScreen) {
		if (vmScreen && !vmScreen.__started && vmScreen.__start) {
			vmScreen.__started = true;
			vmScreen.__start();

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-pre-start', [vmScreen.screenName(), vmScreen]);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vmScreen, 'onStart');
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-post-start', [vmScreen.screenName(), vmScreen]);
		}
	});

	var cross = __WEBPACK_IMPORTED_MODULE_4_crossroads___default.a.create();
	cross.addRoute(/^([a-zA-Z0-9\-]*)\/?(.*)$/, screenOnRoute);

	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.initialized.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.init();

	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-started-trigger').addClass('rl-started');
	}, 100);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-started-delay');
	}, 200);
}

/**
 * @param {string} sHash
 * @param {boolean=} silence = false
 * @param {boolean=} replace = false
 * @returns {void}
 */
function setHash(hash) {
	var silence = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
	var replace = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

	hash = '#' === hash.substr(0, 1) ? hash.substr(1) : hash;
	hash = '/' === hash.substr(0, 1) ? hash.substr(1) : hash;

	var cmd = replace ? 'replaceHash' : 'setHash';

	if (silence) {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
	} else {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.setHash(hash);
	}
}

/***/ },
/* 5 */
/*!********************************!*\
  !*** ./dev/Common/Globals.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __WEBPACK_IMPORTED_MODULE_3_key__ && __WEBPACK_IMPORTED_MODULE_3_key__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_key__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_key__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_key___default, 'a', __WEBPACK_IMPORTED_MODULE_3_key___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko___default = __WEBPACK_IMPORTED_MODULE_4_ko__ && __WEBPACK_IMPORTED_MODULE_4_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_4_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_4_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_4_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_4_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);

/* harmony export */ __webpack_require__.d(exports, "$win", function() { return $win; });
/* harmony export */ __webpack_require__.d(exports, "$doc", function() { return $doc; });
/* harmony export */ __webpack_require__.d(exports, "$html", function() { return $html; });
/* harmony export */ __webpack_require__.d(exports, "$body", function() { return $body; });
/* harmony export */ __webpack_require__.d(exports, "$div", function() { return $div; });
/* harmony export */ __webpack_require__.d(exports, "startMicrotime", function() { return startMicrotime; });
/* harmony export */ __webpack_require__.d(exports, "community", function() { return community; });
/* harmony export */ __webpack_require__.d(exports, "dropdownVisibility", function() { return dropdownVisibility; });
/* harmony export */ __webpack_require__.d(exports, "useKeyboardShortcuts", function() { return useKeyboardShortcuts; });
/* harmony export */ __webpack_require__.d(exports, "sUserAgent", function() { return sUserAgent; });
/* harmony export */ __webpack_require__.d(exports, "bIE", function() { return bIE; });
/* harmony export */ __webpack_require__.d(exports, "bChrome", function() { return bChrome; });
/* harmony export */ __webpack_require__.d(exports, "bSafari", function() { return bSafari; });
/* harmony export */ __webpack_require__.d(exports, "bMobileDevice", function() { return bMobileDevice; });
/* harmony export */ __webpack_require__.d(exports, "bDisableNanoScroll", function() { return bDisableNanoScroll; });
/* harmony export */ __webpack_require__.d(exports, "bAnimationSupported", function() { return bAnimationSupported; });
/* harmony export */ __webpack_require__.d(exports, "bXMLHttpRequestSupported", function() { return bXMLHttpRequestSupported; });
/* harmony export */ __webpack_require__.d(exports, "oHtmlEditorDefaultConfig", function() { return oHtmlEditorDefaultConfig; });
/* harmony export */ __webpack_require__.d(exports, "oHtmlEditorLangsMap", function() { return oHtmlEditorLangsMap; });
/* harmony export */ __webpack_require__.d(exports, "bAllowPdfPreview", function() { return bAllowPdfPreview; });
/* harmony export */ __webpack_require__.d(exports, "aViewModels", function() { return aViewModels; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelDisabled", function() { return leftPanelDisabled; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelType", function() { return leftPanelType; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelWidth", function() { return leftPanelWidth; });
/* harmony export */ __webpack_require__.d(exports, "popupVisibilityNames", function() { return popupVisibilityNames; });
/* harmony export */ __webpack_require__.d(exports, "popupVisibility", function() { return popupVisibility; });
/* harmony export */ __webpack_require__.d(exports, "keyScopeReal", function() { return keyScopeReal; });
/* harmony export */ __webpack_require__.d(exports, "keyScopeFake", function() { return keyScopeFake; });
/* harmony export */ __webpack_require__.d(exports, "keyScope", function() { return keyScope; });
/* harmony export */ __webpack_require__.d(exports, "data", function() { return data; });
/* global RL_COMMUNITY */







var $win = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a);
$win.__sizes = [0, 0];



var $doc = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document);

var $html = __WEBPACK_IMPORTED_MODULE_2_____default()('html');

var $body = __WEBPACK_IMPORTED_MODULE_2_____default()('body');

var $div = __WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>');

var startMicrotime = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();

/**
 * @type {boolean}
 */
var community = false;

/**
 * @type {?}
 */
var dropdownVisibility = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(false).extend({ rateLimit: 0 });

/**
 * @type {boolean}
 */
var useKeyboardShortcuts = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(true);

/**
 * @type {string}
 */
var sUserAgent = 'navigator' in __WEBPACK_IMPORTED_MODULE_0_window___default.a && 'userAgent' in __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.userAgent.toLowerCase() || '';

/**
 * @type {boolean}
 */
var bIE = -1 < sUserAgent.indexOf('msie');

/**
 * @type {boolean}
 */
var bChrome = -1 < sUserAgent.indexOf('chrome');

/**
 * @type {boolean}
 */
var bSafari = !bChrome && -1 < sUserAgent.indexOf('safari');

/**
 * @type {boolean}
 */
var bMobileDevice = /android/i.test(sUserAgent) || /iphone/i.test(sUserAgent) || /ipod/i.test(sUserAgent) || /ipad/i.test(sUserAgent) || /blackberry/i.test(sUserAgent);

/**
 * @type {boolean}
 */
var bDisableNanoScroll = bMobileDevice;

/**
 * @type {boolean}
 */
var bAnimationSupported = !bMobileDevice && $html.hasClass('csstransitions') && $html.hasClass('cssanimations');

/**
 * @type {boolean}
 */
var bXMLHttpRequestSupported = !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.XMLHttpRequest;

/**
 * @type {Object}
 */
var oHtmlEditorDefaultConfig = {
	title: false,
	stylesSet: false,
	customConfig: '',
	contentsCss: '',
	toolbarGroups: [{ name: 'spec' }, { name: 'styles' }, { name: 'basicstyles', groups: ['basicstyles', 'cleanup', 'bidi'] }, { name: 'colors' }, bMobileDevice ? {} : { name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align'] }, { name: 'links' }, { name: 'insert' }, { name: 'document', groups: ['mode', 'document', 'doctools'] }, { name: 'others' }],

	removePlugins: 'liststyle',
	removeButtons: 'Format,Undo,Redo,Cut,Copy,Paste,Anchor,Strike,Subscript,Superscript,Image,SelectAll,Source',
	removeDialogTabs: 'link:advanced;link:target;image:advanced;images:advanced',

	extraPlugins: 'plain,signature',

	allowedContent: true,
	extraAllowedContent: true,

	fillEmptyBlocks: false,
	ignoreEmptyParagraph: true,
	disableNativeSpellChecker: false,

	font_defaultLabel: 'Arial',
	fontSize_defaultLabel: '13',
	fontSize_sizes: '10/10px;12/12px;13/13px;14/14px;16/16px;18/18px;20/20px;24/24px;28/28px;36/36px;48/48px'
};

/**
 * @type {Object}
 */
var oHtmlEditorLangsMap = {
	bg_bg: 'bg',
	de_de: 'de',
	el_gr: 'el',
	es_es: 'es',
	fr_fr: 'fr',
	hu_hu: 'hu',
	is_is: 'is',
	it_it: 'it',
	ja_jp: 'ja',
	ko_kr: 'ko',
	lt_lt: 'lt',
	lv_lv: 'lv',
	nl_nl: 'nl',
	bg_no: 'no',
	pl_pl: 'pl',
	pt_pt: 'pt',
	pt_br: 'pt-br',
	ro_ro: 'ro',
	ru_ru: 'ru',
	sk_sk: 'sk',
	sl_si: 'sl',
	sv_se: 'sv',
	tr_tr: 'tr',
	uk_ua: 'ru',
	zh_tw: 'zh',
	zh_cn: 'zh-cn'
};

/**
 * @type {boolean}
 */
var bAllowPdfPreview = !bMobileDevice;

if (bAllowPdfPreview && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes) {
	bAllowPdfPreview = !!__WEBPACK_IMPORTED_MODULE_1_____default.a.find(__WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes, function (oType) {
		return oType && 'application/pdf' === oType.type;
	});

	if (!bAllowPdfPreview) {
		bAllowPdfPreview = 'undefined' !== typeof __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes['application/pdf'];
	}
}



var aViewModels = {
	settings: [],
	'settings-removed': [],
	'settings-disabled': []
};

var leftPanelDisabled = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(false);
var leftPanelType = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable('');
var leftPanelWidth = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(0);

// popups
var popupVisibilityNames = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observableArray([]);

var popupVisibility = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.computed(function () {
	return 0 < popupVisibilityNames().length;
});

popupVisibility.subscribe(function (bValue) {
	$html.toggleClass('rl-modal', bValue);
});

// keys
var keyScopeReal = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);
var keyScopeFake = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);

var keyScope = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.computed({
	owner: this,
	read: function read() {
		return keyScopeFake();
	},
	write: function write(sValue) {

		if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu !== sValue) {
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Compose === sValue) {
				// disableKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function () {
					return useKeyboardShortcuts();
				};
			} else {
				// restoreKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function (event) {

					if (useKeyboardShortcuts()) {
						var oElement = event.target || event.srcElement,
						    sTagName = oElement ? oElement.tagName : '';

						sTagName = sTagName.toUpperCase();
						return !('INPUT' === sTagName || 'SELECT' === sTagName || 'TEXTAREA' === sTagName || oElement && 'DIV' === sTagName && ('editorHtmlArea' === oElement.className || 'true' === '' + oElement.contentEditable));
					}

					return false;
				};
			}

			keyScopeFake(sValue);
			if (dropdownVisibility()) {
				sValue = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu;
			}
		}

		keyScopeReal(sValue);
	}
});

keyScopeReal.subscribe(function (sValue) {
	//	window.console.log('keyScope=' + sValue); // DEBUG
	__WEBPACK_IMPORTED_MODULE_3_key___default.a.setScope(sValue);
});

dropdownVisibility.subscribe(function (bValue) {
	if (bValue) {
		keyScope(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu);
	} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu === __WEBPACK_IMPORTED_MODULE_3_key___default.a.getScope()) {
		keyScope(keyScopeFake());
	}
});

/**
 * @type {*}
 */
var data = {
	__APP__: null,
	iAjaxErrorCount: 0,
	iTokenErrorCount: 0,
	aBootstrapDropdowns: [],
	iMessageBodyCacheCount: 0,
	bUnload: false
};

/***/ },
/* 6 */
/*!***********************************!*\
  !*** ./dev/Common/Translator.jsx ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko___default = __WEBPACK_IMPORTED_MODULE_3_ko__ && __WEBPACK_IMPORTED_MODULE_3_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_3_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Promise__ = __webpack_require__(/*! Promise */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Promise___default = __WEBPACK_IMPORTED_MODULE_9_Promise__ && __WEBPACK_IMPORTED_MODULE_9_Promise__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_9_Promise__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_9_Promise__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_9_Promise___default, 'a', __WEBPACK_IMPORTED_MODULE_9_Promise___default);

/* harmony export */ __webpack_require__.d(exports, "trigger", function() { return trigger; });/* harmony export */ exports["i18n"] = i18n;/* harmony export */ exports["i18nToNodes"] = i18nToNodes;/* harmony export */ exports["initNotificationLanguage"] = initNotificationLanguage;/* harmony export */ exports["initOnStartOrLangChange"] = initOnStartOrLangChange;/* harmony export */ exports["getNotification"] = getNotification;/* harmony export */ exports["getNotificationFromResponse"] = getNotificationFromResponse;/* harmony export */ exports["getUploadErrorDescByCode"] = getUploadErrorDescByCode;/* harmony export */ exports["reload"] = reload;











var I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

var I18N_NOTIFICATION_DATA = {};
var I18N_NOTIFICATION_MAP = [[__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AuthError, 'NOTIFICATIONS/AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccessError, 'NOTIFICATIONS/ACCESS_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ConnectionError, 'NOTIFICATIONS/CONNECTION_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CaptchaError, 'NOTIFICATIONS/CAPTCHA_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialFacebookLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_FACEBOOK_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialTwitterLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_TWITTER_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialGoogleLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_GOOGLE_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainNotAllowed, 'NOTIFICATIONS/DOMAIN_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountNotAllowed, 'NOTIFICATIONS/ACCOUNT_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthRequired, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_REQUIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthError, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CouldNotSaveNewPassword, 'NOTIFICATIONS/COULD_NOT_SAVE_NEW_PASSWORD'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CurrentPasswordIncorrect, 'NOTIFICATIONS/CURRENT_PASSWORD_INCORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordShort, 'NOTIFICATIONS/NEW_PASSWORD_SHORT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordWeak, 'NOTIFICATIONS/NEW_PASSWORD_WEAK'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordForbidden, 'NOTIFICATIONS/NEW_PASSWORD_FORBIDDENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ContactsSyncError, 'NOTIFICATIONS/CONTACTS_SYNC_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessageList, 'NOTIFICATIONS/CANT_GET_MESSAGE_LIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessage, 'NOTIFICATIONS/CANT_GET_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteMessage, 'NOTIFICATIONS/CANT_DELETE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantMoveMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCopyMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveMessage, 'NOTIFICATIONS/CANT_SAVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSendMessage, 'NOTIFICATIONS/CANT_SEND_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidRecipients, 'NOTIFICATIONS/INVALID_RECIPIENTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveFilters, 'NOTIFICATIONS/CANT_SAVE_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetFilters, 'NOTIFICATIONS/CANT_GET_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].FiltersAreNotCorrect, 'NOTIFICATIONS/FILTERS_ARE_NOT_CORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCreateFolder, 'NOTIFICATIONS/CANT_CREATE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantRenameFolder, 'NOTIFICATIONS/CANT_RENAME_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteFolder, 'NOTIFICATIONS/CANT_DELETE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteNonEmptyFolder, 'NOTIFICATIONS/CANT_DELETE_NON_EMPTY_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSubscribeFolder, 'NOTIFICATIONS/CANT_SUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantUnsubscribeFolder, 'NOTIFICATIONS/CANT_UNSUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveSettings, 'NOTIFICATIONS/CANT_SAVE_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSavePluginSettings, 'NOTIFICATIONS/CANT_SAVE_PLUGIN_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainAlreadyExists, 'NOTIFICATIONS/DOMAIN_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantInstallPackage, 'NOTIFICATIONS/CANT_INSTALL_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeletePackage, 'NOTIFICATIONS/CANT_DELETE_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidPluginPackage, 'NOTIFICATIONS/INVALID_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnsupportedPluginPackage, 'NOTIFICATIONS/UNSUPPORTED_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingServerIsUnavailable, 'NOTIFICATIONS/LICENSING_SERVER_IS_UNAVAILABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingExpired, 'NOTIFICATIONS/LICENSING_EXPIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingBanned, 'NOTIFICATIONS/LICENSING_BANNED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoSendMessageError, 'NOTIFICATIONS/DEMO_SEND_MESSAGE_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoAccountError, 'NOTIFICATIONS/DEMO_ACCOUNT_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountAlreadyExists, 'NOTIFICATIONS/ACCOUNT_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountDoesNotExist, 'NOTIFICATIONS/ACCOUNT_DOES_NOT_EXIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].MailServerError, 'NOTIFICATIONS/MAIL_SERVER_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidInputArgument, 'NOTIFICATIONS/INVALID_INPUT_ARGUMENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification, 'NOTIFICATIONS/UNKNOWN_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownError, 'NOTIFICATIONS/UNKNOWN_ERROR']];

var trigger = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(false);

/**
 * @param {string} key
 * @param {Object=} valueList
 * @param {string=} defaulValue
 * @returns {string}
 */
function i18n(key, valueList, defaulValue) {
	var valueName = '',
	    result = I18N_DATA[key];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(result)) {
		result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(defaulValue) ? key : defaulValue;
	}

	if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(valueList) && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNull"])(valueList)) {
		for (valueName in valueList) {
			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["has"])(valueList, valueName)) {
				result = result.replace('%' + valueName + '%', valueList[valueName]);
			}
		}
	}

	return result;
}

var i18nToNode = function i18nToNode(element) {

	var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
	    key = $el.data('i18n');

	if (key) {
		if ('[' === key.substr(0, 1)) {
			switch (key.substr(0, 6)) {
				case '[html]':
					$el.html(i18n(key.substr(6)));
					break;
				case '[place':
					$el.attr('placeholder', i18n(key.substr(13)));
					break;
				case '[title':
					$el.attr('title', i18n(key.substr(7)));
					break;
				// no default
			}
		} else {
			$el.text(i18n(key));
		}
	}
};

/**
 * @param {Object} elements
 * @param {boolean=} animate = false
 */
function i18nToNodes(elements) {
	var animate = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {

		__WEBPACK_IMPORTED_MODULE_2_____default()('[data-i18n]', elements).each(function (index, item) {
			i18nToNode(item);
		});

		if (animate && __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["bAnimationSupported"]) {
			__WEBPACK_IMPORTED_MODULE_2_____default()('.i18n-animation[data-i18n]', elements).letterfx({
				fx: 'fall fade',
				backwards: false,
				timing: 50,
				fx_duration: '50ms',
				letter_end: 'restore',
				element_end: 'restore'
			});
		}
	});
}

var reloadData = function reloadData() {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N) {
		I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

		i18nToNodes(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document, true);

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Momentor__["reload"])();
		trigger(!trigger());
	}

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
};

/**
 * @returns {void}
 */
function initNotificationLanguage() {
	I18N_NOTIFICATION_MAP.forEach(function (item) {
		I18N_NOTIFICATION_DATA[item[0]] = i18n(item[1]);
	});
}

/**
 * @param {Function} startCallback
 * @param {Function=} langCallback = null
 */
function initOnStartOrLangChange(startCallback) {
	var langCallback = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

	if (startCallback) {
		startCallback();
	}

	if (langCallback) {
		trigger.subscribe(function () {
			if (startCallback) {
				startCallback();
			}

			langCallback();
		});
	} else if (startCallback) {
		trigger.subscribe(startCallback);
	}
}

/**
 * @param {number} code
 * @param {*=} message = ''
 * @param {*=} defCode = null
 * @returns {string}
 */
function getNotification(code) {
	var message = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
	var defCode = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

	code = __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0;
	if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ClientViewError === code && message) {
		return message;
	}

	defCode = defCode ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(defCode, 10) || 0 : 0;
	return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[code]) ? defCode && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[defCode]) ? I18N_NOTIFICATION_DATA[defCode] : '' : I18N_NOTIFICATION_DATA[code];
}

/**
 * @param {object} response
 * @param {number} defCode = Notification.UnknownNotification
 * @returns {string}
 */
function getNotificationFromResponse(response) {
	var defCode = arguments.length <= 1 || arguments[1] === undefined ? __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification : arguments[1];

	return response && response.ErrorCode ? getNotification(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(response.ErrorCode), response.ErrorMessage || '') : getNotification(defCode);
}

/**
 * @param {*} code
 * @returns {string}
 */
function getUploadErrorDescByCode(code) {
	var result = '';
	switch (__WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0) {
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileIsTooBig:
			result = i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FilePartiallyUploaded:
			result = i18n('UPLOAD/ERROR_FILE_PARTIALLY_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileNoUploaded:
			result = i18n('UPLOAD/ERROR_NO_FILE_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].MissingTempFolder:
			result = i18n('UPLOAD/ERROR_MISSING_TEMP_FOLDER');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileOnSaveingError:
			result = i18n('UPLOAD/ERROR_ON_SAVING_FILE');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileType:
			result = i18n('UPLOAD/ERROR_FILE_TYPE');
			break;
		default:
			result = i18n('UPLOAD/ERROR_UNKNOWN');
			break;
	}

	return result;
}

/**
 * @param {boolean} admin
 * @param {string} language
 */
function reload(admin, language) {
	var start = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])();

	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-changing-language');

	return new __WEBPACK_IMPORTED_MODULE_9_Promise___default.a(function (resolve, reject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.ajax({
			url: __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_8_Common_Links__["langLink"])(language, admin),
			dataType: 'script',
			cache: true
		}).then(function () {
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {

				reloadData();

				var isRtl = -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(language, ['ar', 'ar_sa', 'he', 'he_he', 'ur', 'ur_ir']);

				__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language').removeClass('rl-rtl rl-ltr')
				//					.attr('dir', isRtl ? 'rtl' : 'ltr')
				.addClass(isRtl ? 'rl-rtl' : 'rl-ltr');

				resolve();
			}, 500 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])() - start ? 1 : 500);
		}, function () {
			__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language');
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
			reject();
		});
	});
}

// init section
__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-' + (__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].attr('dir') || 'ltr'));

/***/ },
/* 7 */
/*!**********************************!*\
  !*** ./dev/Storage/Settings.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony export */ exports["settingsGet"] = settingsGet;/* harmony export */ exports["settingsSet"] = settingsSet;/* harmony export */ exports["appSettingsGet"] = appSettingsGet;/* harmony export */ exports["capa"] = capa;



var SETTINGS = __WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_data() || null;
SETTINGS = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(SETTINGS) ? SETTINGS : {};

var APP_SETTINGS = SETTINGS.System || null;
APP_SETTINGS = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(APP_SETTINGS) ? APP_SETTINGS : {};

/**
 * @param {string} name
 * @returns {*}
 */
function settingsGet(name) {
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SETTINGS[name]) ? null : SETTINGS[name];
}

/**
 * @param {string} name
 * @param {*} value
 */
function settingsSet(name, value) {
  SETTINGS[name] = value;
}

/**
 * @param {string} name
 * @returns {*}
 */
function appSettingsGet(name) {
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(APP_SETTINGS[name]) ? null : APP_SETTINGS[name];
}

/**
 * @param {string} name
 * @returns {boolean}
 */
function capa(name) {
  var values = settingsGet('Capa');
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(values) && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(name) && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["inArray"])(name, values);
}

/***/ },
/* 8 */
/*!**************************!*\
  !*** ./dev/App/User.jsx ***!
  \**************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_progressJs__ = __webpack_require__(/*! progressJs */ 49);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_progressJs___default = __WEBPACK_IMPORTED_MODULE_3_progressJs__ && __WEBPACK_IMPORTED_MODULE_3_progressJs__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_progressJs__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_progressJs__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_progressJs___default, 'a', __WEBPACK_IMPORTED_MODULE_3_progressJs___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Tinycon__ = __webpack_require__(/*! Tinycon */ 185);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Tinycon___default = __WEBPACK_IMPORTED_MODULE_4_Tinycon__ && __WEBPACK_IMPORTED_MODULE_4_Tinycon__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_4_Tinycon__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_4_Tinycon__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_4_Tinycon___default, 'a', __WEBPACK_IMPORTED_MODULE_4_Tinycon___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Stores_Social__ = __webpack_require__(/*! Stores/Social */ 34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Stores_Social___default = __WEBPACK_IMPORTED_MODULE_15_Stores_Social__ && __WEBPACK_IMPORTED_MODULE_15_Stores_Social__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_15_Stores_Social__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_15_Stores_Social__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default, 'a', __WEBPACK_IMPORTED_MODULE_15_Stores_Social___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings__ = __webpack_require__(/*! Stores/User/Settings */ 24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default = __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings__ && __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default, 'a', __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default = __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__ && __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default, 'a', __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity__ = __webpack_require__(/*! Stores/User/Identity */ 56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default = __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity__ && __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default, 'a', __WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template__ = __webpack_require__(/*! Stores/User/Template */ 93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default = __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template__ && __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default, 'a', __WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder__ = __webpack_require__(/*! Stores/User/Folder */ 20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder__ && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default, 'a', __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 31);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default = __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp__ && __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default, 'a', __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message__ = __webpack_require__(/*! Stores/User/Message */ 29);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default = __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message__ && __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default, 'a', __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact__ = __webpack_require__(/*! Stores/User/Contact */ 53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default = __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact__ && __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default, 'a', __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_Storage_Client__ = __webpack_require__(/*! Storage/Client */ 47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26_Storage_RainLoop__ = __webpack_require__(/*! Storage/RainLoop */ 55);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__ = __webpack_require__(/*! Remote/User/Ajax */ 14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default = __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__ && __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default, 'a', __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax__ = __webpack_require__(/*! Promises/User/Ajax */ 42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default = __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax__ && __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default, 'a', __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29_Model_Email__ = __webpack_require__(/*! Model/Email */ 30);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30_Model_Account__ = __webpack_require__(/*! Model/Account */ 162);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31_Model_Identity__ = __webpack_require__(/*! Model/Identity */ 168);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32_Model_Template__ = __webpack_require__(/*! Model/Template */ 171);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33_Model_OpenPgpKey__ = __webpack_require__(/*! Model/OpenPgpKey */ 170);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_34_Screen_User_Login__ = __webpack_require__(/*! Screen/User/Login */ 174);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_35_Screen_User_MailBox__ = __webpack_require__(/*! Screen/User/MailBox */ 175);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_36_Screen_User_Settings__ = __webpack_require__(/*! Screen/User/Settings */ 176);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_38_App_Abstract__ = __webpack_require__(/*! App/Abstract */ 66);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












































// import {AboutUserScreen} from 'Screen/User/About';








var AppUser = function (_AbstractApp) {
	_inherits(AppUser, _AbstractApp);

	function AppUser() {
		_classCallCheck(this, AppUser);

		var _this = _possibleConstructorReturn(this, _AbstractApp.call(this, __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a));

		_this.moveCache = {};

		_this.quotaDebounce = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(_this.quota, 1000 * 30);
		_this.moveOrDeleteResponseHelper = __WEBPACK_IMPORTED_MODULE_1_____default.a.bind(_this.moveOrDeleteResponseHelper, _this);

		_this.messagesMoveTrigger = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(_this.messagesMoveTrigger, 500);

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.30s');
		}, 30000);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.1m');
		}, 60000);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.2m');
		}, 60000 * 2);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.3m');
		}, 60000 * 3);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.5m');
		}, 60000 * 5);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.10m');
		}, 60000 * 10);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.15m');
		}, 60000 * 15);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
			return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.20m');
		}, 60000 * 15);

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.2m-after5m');
			}, 60000 * 2);
		}, 60000 * 5);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.5m-after5m');
			}, 60000 * 5);
		}, 60000 * 5);
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return __WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
				return __WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('interval.10m-after5m');
			}, 60000 * 10);
		}, 60000 * 5);

		__WEBPACK_IMPORTED_MODULE_2_____default.a.wakeUp(function () {
			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_26_Storage_RainLoop__["b" /* checkTimestamp */])()) {
				_this.reload();
			}

			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.jsVersion(function (sResult, oData) {
				if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === sResult && oData && !oData.Result) {
					_this.reload();
				}
			}, __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('version'));
		}, {}, 60 * 60 * 1000);

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_26_Storage_RainLoop__["b" /* checkTimestamp */])()) {
			_this.reload();
		}

		if (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('UserBackgroundHash')) {
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
				__WEBPACK_IMPORTED_MODULE_2_____default()('#rl-bg').attr('style', 'background-image: none !important;').backstretch(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["userBackground"](__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('UserBackgroundHash')), {
					fade: __WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bAnimationSupported"] ? 1000 : 0,
					centeredX: true,
					centeredY: true
				}).removeAttr('style');
			}, 1000);
		}

		_this.socialUsers = __WEBPACK_IMPORTED_MODULE_1_____default.a.bind(_this.socialUsers, _this);
		return _this;
	}

	AppUser.prototype.remote = function remote() {
		return __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a;
	};

	AppUser.prototype.reload = function reload() {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent && !!__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('inIframe')) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent.location.reload();
		} else {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.reload();
		}
	};

	AppUser.prototype.reloadFlagsCurrentMessageListAndMessageFromCache = function reloadFlagsCurrentMessageListAndMessageFromCache() {
		__WEBPACK_IMPORTED_MODULE_1_____default.a.each(__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageList(), function (message) {
			__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["initMessageFlagsFromCache"](message);
		});
		__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["initMessageFlagsFromCache"](__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.message());
	};

	/**
  * @param {boolean=} bDropPagePosition = false
  * @param {boolean=} bDropCurrenFolderCache = false
  */


	AppUser.prototype.reloadMessageList = function reloadMessageList() {
		var bDropPagePosition = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var bDropCurrenFolderCache = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];


		var iOffset = (__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListPage() - 1) * __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default.a.messagesPerPage();

		if (bDropCurrenFolderCache) {
			__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["setFolderHash"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw(), '');
		}

		if (bDropPagePosition) {
			__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListPage(1);
			__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListPageBeforeThread(1);
			iOffset = 0;

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["mailBox"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameHash(), __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListPage(), __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListSearch(), __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListThreadUid()), true, true);
		}

		__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListLoading(true);
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageList(function (sResult, oData, bCached) {

			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === sResult && oData && oData.Result) {
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListError('');
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListLoading(false);

				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.setMessageList(oData, bCached);
			} else if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Unload === sResult) {
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListError('');
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListLoading(false);
			} else if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Abort !== sResult) {
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageList([]);
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListLoading(false);
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListError(oData && oData.ErrorCode ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["getNotification"])(oData.ErrorCode) : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["i18n"])('NOTIFICATIONS/CANT_GET_MESSAGE_LIST'));
			}
		}, __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw(), iOffset, __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default.a.messagesPerPage(), __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListSearch(), __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListThreadUid());
	};

	AppUser.prototype.recacheInboxMessageList = function recacheInboxMessageList() {
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageList(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"](), 0, __WEBPACK_IMPORTED_MODULE_16_Stores_User_Settings___default.a.messagesPerPage(), '', '', true);
	};

	/**
  * @param {Function} fResultFunc
  * @returns {boolean}
  */


	AppUser.prototype.contactsSync = function contactsSync(fResultFunc) {

		var oContacts = __WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default.a.contacts;
		if (oContacts.importing() || oContacts.syncing() || !__WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default.a.enableContactsSync() || !__WEBPACK_IMPORTED_MODULE_23_Stores_User_Contact___default.a.allowContactsSync()) {
			return false;
		}

		oContacts.syncing(true);

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.contactsSync(function (sResult, oData) {

			oContacts.syncing(false);

			if (fResultFunc) {
				fResultFunc(sResult, oData);
			}
		});

		return true;
	};

	AppUser.prototype.messagesMoveTrigger = function messagesMoveTrigger() {
		var _this2 = this;

		var sTrashFolder = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.trashFolder(),
		    sSpamFolder = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.spamFolder();

		__WEBPACK_IMPORTED_MODULE_1_____default.a.each(this.moveCache, function (oItem) {

			var bSpam = sSpamFolder === oItem.To,
			    bTrash = sTrashFolder === oItem.To,
			    bHam = !bSpam && sSpamFolder === oItem.From && __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]() === oItem.To;

			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messagesMove(_this2.moveOrDeleteResponseHelper, oItem.From, oItem.To, oItem.Uid, bSpam ? 'SPAM' : bHam ? 'HAM' : '', bSpam || bTrash);
		});

		this.moveCache = {};
	};

	AppUser.prototype.messagesMoveHelper = function messagesMoveHelper(sFromFolderFullNameRaw, sToFolderFullNameRaw, aUidForMove) {

		var sH = '$$' + sFromFolderFullNameRaw + '$$' + sToFolderFullNameRaw + '$$';
		if (!this.moveCache[sH]) {
			this.moveCache[sH] = {
				From: sFromFolderFullNameRaw,
				To: sToFolderFullNameRaw,
				Uid: []
			};
		}

		this.moveCache[sH].Uid = __WEBPACK_IMPORTED_MODULE_1_____default.a.union(this.moveCache[sH].Uid, aUidForMove);
		this.messagesMoveTrigger();
	};

	AppUser.prototype.messagesCopyHelper = function messagesCopyHelper(sFromFolderFullNameRaw, sToFolderFullNameRaw, aUidForCopy) {
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messagesCopy(this.moveOrDeleteResponseHelper, sFromFolderFullNameRaw, sToFolderFullNameRaw, aUidForCopy);
	};

	AppUser.prototype.messagesDeleteHelper = function messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove) {
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messagesDelete(this.moveOrDeleteResponseHelper, sFromFolderFullNameRaw, aUidForRemove);
	};

	AppUser.prototype.moveOrDeleteResponseHelper = function moveOrDeleteResponseHelper(sResult, oData) {

		if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === sResult && __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolder()) {
			if (oData && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(oData.Result) && 2 === oData.Result.length) {
				__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["setFolderHash"](oData.Result[0], oData.Result[1]);
			} else {
				__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["setFolderHash"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw(), '');

				if (oData && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(oData.ErrorCode, [__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Notification"].CantMoveMessage, __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Notification"].CantCopyMessage])) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.alert(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["getNotification"])(oData.ErrorCode));
				}
			}

			this.reloadMessageList(0 === __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageList().length);
			this.quotaDebounce();
		}
	};

	/**
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForRemove
  */


	AppUser.prototype.deleteMessagesFromFolderWithoutCheck = function deleteMessagesFromFolderWithoutCheck(sFromFolderFullNameRaw, aUidForRemove) {
		this.messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove);
		__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove);
	};

	/**
  * @param {number} iDeleteType
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForRemove
  * @param {boolean=} bUseFolder = true
  */


	AppUser.prototype.deleteMessagesFromFolder = function deleteMessagesFromFolder(iDeleteType, sFromFolderFullNameRaw, aUidForRemove, bUseFolder) {
		var _this3 = this;

		var oMoveFolder = null,
		    nSetSystemFoldersNotification = null;

		switch (iDeleteType) {
			case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Spam:
				oMoveFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.spamFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SetSystemFoldersNotification"].Spam;
				break;
			case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].NotSpam:
				oMoveFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]());
				break;
			case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Trash:
				oMoveFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.trashFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SetSystemFoldersNotification"].Trash;
				break;
			case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Archive:
				oMoveFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.archiveFolder());
				nSetSystemFoldersNotification = __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["SetSystemFoldersNotification"].Archive;
				break;
			// no default
		}

		bUseFolder = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(bUseFolder) ? true : !!bUseFolder;
		if (bUseFolder) {
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Spam === iDeleteType && __WEBPACK_IMPORTED_MODULE_8_Common_Consts__["UNUSED_OPTION_VALUE"] === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.spamFolder() || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Trash === iDeleteType && __WEBPACK_IMPORTED_MODULE_8_Common_Consts__["UNUSED_OPTION_VALUE"] === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.trashFolder() || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Archive === iDeleteType && __WEBPACK_IMPORTED_MODULE_8_Common_Consts__["UNUSED_OPTION_VALUE"] === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.archiveFolder()) {
				bUseFolder = false;
			}
		}

		if (!oMoveFolder && bUseFolder) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/FolderSystem */ 54), [nSetSystemFoldersNotification]);
		} else if (!bUseFolder || __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["FolderType"].Trash === iDeleteType && (sFromFolderFullNameRaw === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.spamFolder() || sFromFolderFullNameRaw === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.trashFolder())) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/Ask */ 39), [__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["i18n"])('POPUPS_ASK/DESC_WANT_DELETE_MESSAGES'), function () {
				_this3.messagesDeleteHelper(sFromFolderFullNameRaw, aUidForRemove);
				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove);
			}]);
		} else if (oMoveFolder) {
			this.messagesMoveHelper(sFromFolderFullNameRaw, oMoveFolder.fullNameRaw, aUidForRemove);
			__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.removeMessagesFromList(sFromFolderFullNameRaw, aUidForRemove, oMoveFolder.fullNameRaw);
		}
	};

	/**
  * @param {string} sFromFolderFullNameRaw
  * @param {Array} aUidForMove
  * @param {string} sToFolderFullNameRaw
  * @param {boolean=} bCopy = false
  */


	AppUser.prototype.moveMessagesToFolder = function moveMessagesToFolder(sFromFolderFullNameRaw, aUidForMove, sToFolderFullNameRaw, bCopy) {

		if (sFromFolderFullNameRaw !== sToFolderFullNameRaw && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(aUidForMove) && 0 < aUidForMove.length) {
			var oFromFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](sFromFolderFullNameRaw),
			    oToFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](sToFolderFullNameRaw);

			if (oFromFolder && oToFolder) {
				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(bCopy) ? false : !!bCopy) {
					this.messagesCopyHelper(oFromFolder.fullNameRaw, oToFolder.fullNameRaw, aUidForMove);
				} else {
					this.messagesMoveHelper(oFromFolder.fullNameRaw, oToFolder.fullNameRaw, aUidForMove);
				}

				__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.removeMessagesFromList(oFromFolder.fullNameRaw, aUidForMove, oToFolder.fullNameRaw, bCopy);
				return true;
			}
		}

		return false;
	};

	/**
  * @param {Function=} callback = null
  */


	AppUser.prototype.foldersReload = function foldersReload() {
		var callback = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];

		var prom = __WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default.a.foldersReload(__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.foldersLoading);
		if (callback) {
			prom.then(function (value) {
				callback(!!value);
			}).catch(function () {
				__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
					callback(false);
				}, 1);
			});
		}
	};

	AppUser.prototype.foldersPromisesActionHelper = function foldersPromisesActionHelper(promise, errorDefCode) {

		__WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default.a.abort('Folders').fastResolve(true).then(function () {
			return promise;
		}).then(function () {
			__WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default.a.foldersReloadWithTimeout(__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.foldersLoading);
		}, function (errorCode) {
			__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.folderList.error(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["getNotification"])(errorCode, '', errorDefCode));
			__WEBPACK_IMPORTED_MODULE_28_Promises_User_Ajax___default.a.foldersReloadWithTimeout(__WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.foldersLoading);
		});
	};

	AppUser.prototype.reloadOpenPgpKeys = function reloadOpenPgpKeys() {

		if (__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.capaOpenPGP()) {
			var aKeys = [],
			    oEmail = new __WEBPACK_IMPORTED_MODULE_29_Model_Email__["EmailModel"](),
			    oOpenpgpKeyring = __WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgpKeyring,
			    oOpenpgpKeys = oOpenpgpKeyring ? oOpenpgpKeyring.getAllKeys() : [];

			__WEBPACK_IMPORTED_MODULE_1_____default.a.each(oOpenpgpKeys, function (oItem, iIndex) {
				if (oItem && oItem.primaryKey) {
					var aEmails = [],
					    aUsers = [],
					    oPrimaryUser = oItem.getPrimaryUser(),
					    sUser = oPrimaryUser && oPrimaryUser.user ? oPrimaryUser.user.userId.userid : oItem.users && oItem.users[0] ? oItem.users[0].userId.userid : '';

					if (oItem.users) {
						__WEBPACK_IMPORTED_MODULE_1_____default.a.each(oItem.users, function (item) {
							if (item.userId) {
								oEmail.clear();
								oEmail.mailsoParse(item.userId.userid);
								if (oEmail.validate()) {
									aEmails.push(oEmail.email);
									aUsers.push(item.userId.userid);
								}
							}
						});
					}

					if (aEmails.length) {
						aKeys.push(new __WEBPACK_IMPORTED_MODULE_33_Model_OpenPgpKey__["a" /* OpenPgpKeyModel */](iIndex, oItem.primaryKey.getFingerprint(), oItem.primaryKey.getKeyId().toHex().toLowerCase(), __WEBPACK_IMPORTED_MODULE_1_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(oItem.getKeyIds(), function (item) {
							return item && item.toHex ? item.toHex() : null;
						}))), aUsers, aEmails, oItem.isPrivate(), oItem.armor(), sUser));
					}
				}
			});

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgpkeys());
			__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgpkeys(aKeys);
		}
	};

	AppUser.prototype.accountsCounts = function accountsCounts() {
		return false;
		//		AccountStore.accounts.loading(true);
		//
		//		Remote.accountsCounts((sResult, oData) => {
		//
		//			AccountStore.accounts.loading(false);
		//
		//			if (StorageResultType.Success === sResult && oData.Result && oData.Result['Counts'])
		//			{
		//				var
		//					sEmail = AccountStore.email(),
		//					aAcounts = AccountStore.accounts()
		//				;
		//
		//				_.each(oData.Result['Counts'], (oItem) => {
		//
		//					var oAccount = _.find(aAcounts, (oAccount) => {
		//						return oAccount && oItem[0] === oAccount.email && sEmail !== oAccount.email;
		//					});
		//
		//					if (oAccount)
		//					{
		//						oAccount.count(pInt(oItem[1]));
		//					}
		//				});
		//			}
		//		});
	};

	AppUser.prototype.accountsAndIdentities = function accountsAndIdentities(bBoot) {
		var _this4 = this;

		__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.accounts.loading(true);
		__WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default.a.identities.loading(true);

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.accountsAndIdentities(function (sResult, oData) {

			__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.accounts.loading(false);
			__WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default.a.identities.loading(false);

			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === sResult && oData.Result) {
				var aCounts = {},
				    sParentEmail = __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('ParentEmail'),
				    sAccountEmail = __WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.email();

				sParentEmail = '' === sParentEmail ? sAccountEmail : sParentEmail;

				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(oData.Result.Accounts)) {
					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.accounts(), function (oAccount) {
						aCounts[oAccount.email] = oAccount.count();
					});

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.accounts());

					__WEBPACK_IMPORTED_MODULE_17_Stores_User_Account___default.a.accounts(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(oData.Result.Accounts, function (sValue) {
						return new __WEBPACK_IMPORTED_MODULE_30_Model_Account__["a" /* AccountModel */](sValue, sValue !== sParentEmail, aCounts[sValue] || 0);
					}));
				}

				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(bBoot) ? false : !!bBoot) {
					__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
						return _this4.accountsCounts();
					}, 1000 * 5);
					__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.10m-after5m', function () {
						return _this4.accountsCounts();
					});
				}

				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(oData.Result.Identities)) {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default.a.identities());

					__WEBPACK_IMPORTED_MODULE_18_Stores_User_Identity___default.a.identities(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(oData.Result.Identities, function (oIdentityData) {

						var sId = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.Id),
						    sEmail = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.Email),
						    oIdentity = new __WEBPACK_IMPORTED_MODULE_31_Model_Identity__["a" /* IdentityModel */](sId, sEmail);

						oIdentity.name(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.Name));
						oIdentity.replyTo(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.ReplyTo));
						oIdentity.bcc(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.Bcc));
						oIdentity.signature(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(oIdentityData.Signature));
						oIdentity.signatureInsertBefore(!!oIdentityData.SignatureInsertBefore);

						return oIdentity;
					}));
				}
			}
		});
	};

	AppUser.prototype.templates = function templates() {

		__WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default.a.templates.loading(true);

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.templates(function (result, data) {

			__WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default.a.templates.loading(false);

			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data.Result && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(data.Result.Templates)) {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["delegateRunOnDestroy"])(__WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default.a.templates());

				__WEBPACK_IMPORTED_MODULE_19_Stores_User_Template___default.a.templates(__WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data.Result.Templates, function (templateData) {
					var template = new __WEBPACK_IMPORTED_MODULE_32_Model_Template__["a" /* TemplateModel */]();
					return template.parse(templateData) ? template : null;
				})));
			}
		});
	};

	AppUser.prototype.quota = function quota() {
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.quota(function (result, data) {
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(data.Result) && 1 < data.Result.length && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isPosNumeric"])(data.Result[0], true) && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isPosNumeric"])(data.Result[1], true)) {
				__webpack_require__(/*! Stores/User/Quota */ 92).populateData(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(data.Result[1]), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(data.Result[0]));
			}
		});
	};

	/**
  * @param {string} folder
  * @param {Array=} list = []
  */


	AppUser.prototype.folderInformation = function folderInformation(folder, list) {
		var _this5 = this;

		if ('' !== __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(folder)) {
			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.folderInformation(function (result, data) {
				if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result) {
					if (data && data.Result && data.Result.Hash && data.Result.Folder) {
						var uid = '',
						    check = false,
						    unreadCountChange = false;

						var folderFromCache = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](data.Result.Folder);
						if (folderFromCache) {
							folderFromCache.interval = __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["momentNowUnix"]();

							if (data.Result.Hash) {
								__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["setFolderHash"](data.Result.Folder, data.Result.Hash);
							}

							if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(data.Result.MessageCount)) {
								folderFromCache.messageCountAll(data.Result.MessageCount);
							}

							if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(data.Result.MessageUnseenCount)) {
								if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(folderFromCache.messageCountUnread()) !== __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(data.Result.MessageUnseenCount)) {
									unreadCountChange = true;
								}

								folderFromCache.messageCountUnread(data.Result.MessageUnseenCount);
							}

							if (unreadCountChange) {
								__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["clearMessageFlagsFromCacheByFolder"](folderFromCache.fullNameRaw);
							}

							if (data.Result.Flags) {
								for (uid in data.Result.Flags) {
									if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["has"])(data.Result.Flags, uid)) {
										check = true;
										var flags = data.Result.Flags[uid];
										__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["storeMessageFlagsToCacheByFolderAndUid"](folderFromCache.fullNameRaw, uid.toString(), [!flags.IsSeen, !!flags.IsFlagged, !!flags.IsAnswered, !!flags.IsForwarded, !!flags.IsReadReceipt]);
									}
								}

								if (check) {
									_this5.reloadFlagsCurrentMessageListAndMessageFromCache();
								}
							}

							__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.initUidNextAndNewMessages(folderFromCache.fullNameRaw, data.Result.UidNext, data.Result.NewMessages);

							var hash = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderHash"](data.Result.Folder);
							if (data.Result.Hash !== hash || '' === hash || unreadCountChange) {
								if (folderFromCache.fullNameRaw === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw()) {
									_this5.reloadMessageList();
								} else if (__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]() === folderFromCache.fullNameRaw) {
									_this5.recacheInboxMessageList();
								}
							}
						}
					}
				}
			}, folder, list);
		}
	};

	/**
  * @param {boolean=} boot = false
  */


	AppUser.prototype.folderInformationMultiply = function folderInformationMultiply() {
		var _this6 = this;

		var boot = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];


		var folders = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.getNextFolderNames();
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(folders)) {
			__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.folderInformationMultiply(function (sResult, oData) {
				if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === sResult) {
					if (oData && oData.Result && oData.Result.List && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(oData.Result.List)) {
						(function () {
							var utc = __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["momentNowUnix"]();
							__WEBPACK_IMPORTED_MODULE_1_____default.a.each(oData.Result.List, function (oItem) {

								var sHash = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderHash"](oItem.Folder),
								    oFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](oItem.Folder),
								    bUnreadCountChange = false;

								if (oFolder) {
									oFolder.interval = utc;

									if (oItem.Hash) {
										__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["setFolderHash"](oItem.Folder, oItem.Hash);
									}

									if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(oItem.MessageCount)) {
										oFolder.messageCountAll(oItem.MessageCount);
									}

									if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(oItem.MessageUnseenCount)) {
										if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(oFolder.messageCountUnread()) !== __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(oItem.MessageUnseenCount)) {
											bUnreadCountChange = true;
										}

										oFolder.messageCountUnread(oItem.MessageUnseenCount);
									}

									if (bUnreadCountChange) {
										__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["clearMessageFlagsFromCacheByFolder"](oFolder.fullNameRaw);
									}

									if (oItem.Hash !== sHash || '' === sHash) {
										if (oFolder.fullNameRaw === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw()) {
											_this6.reloadMessageList();
										}
									} else if (bUnreadCountChange) {
										if (oFolder.fullNameRaw === __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw()) {
											var aList = __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageList();
											if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(aList)) {
												_this6.folderInformation(oFolder.fullNameRaw, aList);
											}
										}
									}
								}
							});

							if (boot) {
								__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
									return _this6.folderInformationMultiply(true);
								}, 2000);
							}
						})();
					}
				}
			}, folders);
		}
	};

	/**
  * @param {string} sFolderFullNameRaw
  * @param {string|bool} mUid
  * @param {number} iSetAction
  * @param {Array=} aMessages = null
  */


	AppUser.prototype.messageListAction = function messageListAction(sFolderFullNameRaw, mUid, iSetAction, aMessages) {

		var oFolder = null,
		    aRootUids = [],
		    iAlreadyUnread = 0;

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(aMessages)) {
			aMessages = __WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.messageListChecked();
		}

		aRootUids = __WEBPACK_IMPORTED_MODULE_1_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(aMessages, function (oMessage) {
			return oMessage && oMessage.uid ? oMessage.uid : null;
		})));

		if ('' !== sFolderFullNameRaw && 0 < aRootUids.length) {
			switch (iSetAction) {
				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["MessageSetAction"].SetSeen:

					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aRootUids, function (sSubUid) {
						iAlreadyUnread += __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["storeMessageFlagsToCacheBySetAction"](sFolderFullNameRaw, sSubUid, iSetAction);
					});

					oFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](sFolderFullNameRaw);
					if (oFolder) {
						oFolder.messageCountUnread(oFolder.messageCountUnread() - iAlreadyUnread);
					}

					__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageSetSeen(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], sFolderFullNameRaw, aRootUids, true);
					break;

				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["MessageSetAction"].UnsetSeen:

					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aRootUids, function (sSubUid) {
						iAlreadyUnread += __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["storeMessageFlagsToCacheBySetAction"](sFolderFullNameRaw, sSubUid, iSetAction);
					});

					oFolder = __WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderFromCacheList"](sFolderFullNameRaw);
					if (oFolder) {
						oFolder.messageCountUnread(oFolder.messageCountUnread() - iAlreadyUnread + aRootUids.length);
					}

					__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageSetSeen(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], sFolderFullNameRaw, aRootUids, false);
					break;

				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["MessageSetAction"].SetFlag:

					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aRootUids, function (sSubUid) {
						__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["storeMessageFlagsToCacheBySetAction"](sFolderFullNameRaw, sSubUid, iSetAction);
					});

					__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageSetFlagged(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], sFolderFullNameRaw, aRootUids, true);
					break;

				case __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["MessageSetAction"].UnsetFlag:

					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aRootUids, function (sSubUid) {
						__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["storeMessageFlagsToCacheBySetAction"](sFolderFullNameRaw, sSubUid, iSetAction);
					});

					__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.messageSetFlagged(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], sFolderFullNameRaw, aRootUids, false);
					break;
				// no default
			}

			this.reloadFlagsCurrentMessageListAndMessageFromCache();
			__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.message.viewTrigger(!__WEBPACK_IMPORTED_MODULE_22_Stores_User_Message___default.a.message.viewTrigger());
		}
	};

	AppUser.prototype.googleConnect = function googleConnect() {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.open(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["socialGoogle"](), 'Google', 'left=200,top=100,width=650,height=600,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	AppUser.prototype.twitterConnect = function twitterConnect() {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.open(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["socialTwitter"](), 'Twitter', 'left=200,top=100,width=650,height=350,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	AppUser.prototype.facebookConnect = function facebookConnect() {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.open(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["socialFacebook"](), 'Facebook', 'left=200,top=100,width=650,height=335,menubar=no,status=no,resizable=yes,scrollbars=yes');
	};

	/**
  * @param {boolean=} fireAllActions = false
  */


	AppUser.prototype.socialUsers = function socialUsers() {
		var fireAllActions = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		if (true === fireAllActions) {
			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.loading(true);
			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.loading(true);
			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.loading(true);
		}

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.socialUsers(function (result, data) {

			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.userName(data.Result.Google || '');
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.userName(data.Result.Facebook || '');
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.userName(data.Result.Twitter || '');
			} else {
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.userName('');
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.userName('');
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.userName('');
			}

			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.loading(false);
			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.loading(false);
			__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.loading(false);
		});
	};

	AppUser.prototype.googleDisconnect = function googleDisconnect() {
		__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.loading(true);
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.googleDisconnect(this.socialUsers);
	};

	AppUser.prototype.facebookDisconnect = function facebookDisconnect() {
		__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.loading(true);
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.facebookDisconnect(this.socialUsers);
	};

	AppUser.prototype.twitterDisconnect = function twitterDisconnect() {
		__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.loading(true);
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.twitterDisconnect(this.socialUsers);
	};

	/**
  * @param {string} query
  * @param {Function} autocompleteCallback
  */


	AppUser.prototype.getAutocomplete = function getAutocomplete(query, autocompleteCallback) {
		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.suggestions(function (result, data) {
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(data.Result)) {
				autocompleteCallback(__WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data.Result, function (item) {
					return item && item[0] ? new __WEBPACK_IMPORTED_MODULE_29_Model_Email__["EmailModel"](item[0], item[1]) : null;
				})));
			} else if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Abort !== result) {
				autocompleteCallback([]);
			}
		}, query);
	};

	/**
  * @param {string} sFullNameHash
  * @param {boolean} bExpanded
  */


	AppUser.prototype.setExpandedFolder = function setExpandedFolder(sFullNameHash, bExpanded) {
		var aExpandedList = __WEBPACK_IMPORTED_MODULE_24_Storage_Client__["get"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["ClientSideKeyName"].ExpandedFolders);
		if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(aExpandedList)) {
			aExpandedList = [];
		}

		if (bExpanded) {
			aExpandedList.push(sFullNameHash);
			aExpandedList = __WEBPACK_IMPORTED_MODULE_1_____default.a.uniq(aExpandedList);
		} else {
			aExpandedList = __WEBPACK_IMPORTED_MODULE_1_____default.a.without(aExpandedList, sFullNameHash);
		}

		__WEBPACK_IMPORTED_MODULE_24_Storage_Client__["set"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["ClientSideKeyName"].ExpandedFolders, aExpandedList);
	};

	AppUser.prototype.initHorizontalLayoutResizer = function initHorizontalLayoutResizer(sClientSideKeyName) {

		var iMinHeight = 200,
		    iMaxHeight = 500,
		    oTop = null,
		    oBottom = null,
		    fSetHeight = function fSetHeight(height) {
			if (height) {
				if (oTop) {
					oTop.attr('style', 'height:' + height + 'px');
				}

				if (oBottom) {
					oBottom.attr('style', 'top:' + (55 /* top toolbar */ + height) + 'px');
				}
			}
		},
		    fResizeCreateFunction = function fResizeCreateFunction(event) {
			if (event && event.target) {
				var oResizableHandle = __WEBPACK_IMPORTED_MODULE_2_____default()(event.target).find('.ui-resizable-handle');

				oResizableHandle.on('mousedown', function () {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
				}).on('mouseup', function () {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-resizer');
				});
			}
		},
		    fResizeStartFunction = function fResizeStartFunction() {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
		},
		    fResizeResizeFunction = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
		}, 500, true),
		    fResizeStopFunction = function fResizeStopFunction(oEvent, oObject) {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-resizer');
			if (oObject && oObject.size && oObject.size.height) {
				__WEBPACK_IMPORTED_MODULE_24_Storage_Client__["set"](sClientSideKeyName, oObject.size.height);

				fSetHeight(oObject.size.height);

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["windowResize"])();
			}
		},
		    oOptions = {
			helper: 'ui-resizable-helper-h',
			minHeight: iMinHeight,
			maxHeight: iMaxHeight,
			handles: 's',
			create: fResizeCreateFunction,
			resize: fResizeResizeFunction,
			start: fResizeStartFunction,
			stop: fResizeStopFunction
		},
		    fDisable = function fDisable(bDisable) {
			if (bDisable) {
				if (oTop && oTop.hasClass('ui-resizable')) {
					oTop.resizable('destroy').removeAttr('style');
				}

				if (oBottom) {
					oBottom.removeAttr('style');
				}
			} else if (__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].hasClass('rl-bottom-preview-pane')) {
				oTop = __WEBPACK_IMPORTED_MODULE_2_____default()('.b-message-list-wrapper');
				oBottom = __WEBPACK_IMPORTED_MODULE_2_____default()('.b-message-view-wrapper');

				if (!oTop.hasClass('ui-resizable')) {
					oTop.resizable(oOptions);
				}

				var iHeight = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_24_Storage_Client__["get"](sClientSideKeyName)) || 300;
				fSetHeight(iHeight > iMinHeight ? iHeight : iMinHeight);
			}
		};

		fDisable(false);

		__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('layout', function (layout) {
			fDisable(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Layout"].BottomPreview !== layout);
		});
	};

	AppUser.prototype.initVerticalLayoutResizer = function initVerticalLayoutResizer(sClientSideKeyName) {

		var iDisabledWidth = 60,
		    iMinWidth = 155,
		    oLeft = __WEBPACK_IMPORTED_MODULE_2_____default()('#rl-left'),
		    oRight = __WEBPACK_IMPORTED_MODULE_2_____default()('#rl-right'),
		    mLeftWidth = __WEBPACK_IMPORTED_MODULE_24_Storage_Client__["get"](sClientSideKeyName) || null,
		    fSetWidth = function fSetWidth(iWidth) {
			if (iWidth) {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["leftPanelWidth"])(iWidth);

				__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-resizer');

				oLeft.css({
					width: '' + iWidth + 'px'
				});

				oRight.css({
					left: '' + iWidth + 'px'
				});
			}
		},
		    fDisable = function fDisable(bDisable) {
			if (bDisable) {
				oLeft.resizable('disable');
				fSetWidth(iDisabledWidth);
			} else {
				oLeft.resizable('enable');
				var iWidth = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_24_Storage_Client__["get"](sClientSideKeyName)) || iMinWidth;
				fSetWidth(iWidth > iMinWidth ? iWidth : iMinWidth);
			}
		},
		    fResizeCreateFunction = function fResizeCreateFunction(oEvent) {
			if (oEvent && oEvent.target) {
				__WEBPACK_IMPORTED_MODULE_2_____default()(oEvent.target).find('.ui-resizable-handle').on('mousedown', function () {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
				}).on('mouseup', function () {
					__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-resizer');
				});
			}
		},
		    fResizeResizeFunction = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
		}, 500, true),
		    fResizeStartFunction = function fResizeStartFunction() {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-resizer');
		},
		    fResizeStopFunction = function fResizeStopFunction(oEvent, oObject) {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-resizer');
			if (oObject && oObject.size && oObject.size.width) {
				__WEBPACK_IMPORTED_MODULE_24_Storage_Client__["set"](sClientSideKeyName, oObject.size.width);

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["leftPanelWidth"])(oObject.size.width);

				oRight.css({
					left: '' + oObject.size.width + 'px'
				});

				oLeft.css({
					position: '',
					top: '',
					left: '',
					height: ''
				});
			}
		};

		if (null !== mLeftWidth) {
			fSetWidth(mLeftWidth > iMinWidth ? mLeftWidth : iMinWidth);
		}

		oLeft.resizable({
			helper: 'ui-resizable-helper-w',
			minWidth: iMinWidth,
			maxWidth: 350,
			handles: 'e',
			create: fResizeCreateFunction,
			resize: fResizeResizeFunction,
			start: fResizeStartFunction,
			stop: fResizeStopFunction
		});

		__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('left-panel.off', function () {
			fDisable(true);
		});

		__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('left-panel.on', function () {
			fDisable(false);
		});
	};

	AppUser.prototype.logout = function logout() {
		var _this7 = this;

		__WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.logout(function () {
			_this7.loginAndLogoutReload(false, true, __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('ParentEmail') && 0 < __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('ParentEmail').length);
		});
	};

	AppUser.prototype.bootstartTwoFactorScreen = function bootstartTwoFactorScreen() {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/TwoFactorConfiguration */ 100), [true]);
	};

	AppUser.prototype.bootstartWelcomePopup = function bootstartWelcomePopup(url) {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["showScreenPopup"])(__webpack_require__(/*! View/Popup/WelcomePage */ 150), [url]);
	};

	AppUser.prototype.bootstartLoginScreen = function bootstartLoginScreen() {

		__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].removeClass('rl-user-auth').addClass('rl-user-no-auth');

		var customLoginLink = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('customLoginLink'));
		if (!customLoginLink) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_34_Screen_User_Login__["a" /* LoginUserScreen */]]);

			__WEBPACK_IMPORTED_MODULE_9_Common_Plugins__["runHook"]('rl-start-login-screens');
			__WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('rl.bootstart-login-screens');
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["routeOff"])();
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["root"](), true);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = customLoginLink;
			});
		}
	};

	AppUser.prototype.bootend = function bootend() {
		if (__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a) {
			__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a.set(100).end();
		}
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["hideLoading"])();
	};

	AppUser.prototype.bootstart = function bootstart() {
		var _this8 = this;

		_AbstractApp.prototype.bootstart.call(this);

		__webpack_require__(/*! Stores/User/App */ 22).populate();
		__webpack_require__(/*! Stores/User/Settings */ 24).populate();
		__webpack_require__(/*! Stores/User/Notification */ 62).populate();
		__webpack_require__(/*! Stores/User/Account */ 28).populate();
		__webpack_require__(/*! Stores/User/Contact */ 53).populate();

		var sJsHash = __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('jsHash'),
		    sStartupUrl = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('StartupUrl')),
		    iContactsSyncInterval = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('ContactsSyncInterval')),
		    bGoogle = __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('AllowGoogleSocial'),
		    bFacebook = __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('AllowFacebookSocial'),
		    bTwitter = __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('AllowTwitterSocial');

		if (__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a) {
			__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a.set(90);
		}

		__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["leftPanelDisabled"].subscribe(function (value) {
			__WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('left-panel.' + (value ? 'off' : 'on'));
		});

		this.setWindowTitle('');
		if (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('Auth')) {
			__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["$html"].addClass('rl-user-auth');

			if (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Capa"].TwoFactor) && __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Capa"].TwoFactorForce) && __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('RequireTwoFactor')) {
				this.bootend();
				this.bootstartTwoFactorScreen();
			} else {
				this.setWindowTitle(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_14_Common_Translator__["i18n"])('TITLES/LOADING'));

				// require.ensure([], function() { // require code splitting

				this.foldersReload(function (value) {

					_this8.bootend();

					if (value) {
						if ('' !== sStartupUrl) {
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["routeOff"])();
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["root"](sStartupUrl), true);
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["routeOn"])();
						}

						if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.jassl && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues && __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Capa"].OpenPGP)) {
							(function () {
								var openpgpCallback = function openpgpCallback(openpgp) {

									__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgp = openpgp;

									if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.Worker) {
										try {
											__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgp.initWorker({ path: __WEBPACK_IMPORTED_MODULE_10_Common_Links__["openPgpWorkerJs"]() });
										} catch (e) {
											__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["log"])(e);
										}
									}

									__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.openpgpKeyring = new openpgp.Keyring();
									__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.capaOpenPGP(true);

									__WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('openpgp.init');

									_this8.reloadOpenPgpKeys();
								};

								if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.openpgp) {
									openpgpCallback(__WEBPACK_IMPORTED_MODULE_0_window___default.a.openpgp);
								} else {
									__WEBPACK_IMPORTED_MODULE_0_window___default.a.jassl(__WEBPACK_IMPORTED_MODULE_10_Common_Links__["openPgpJs"]()).then(function () {
										if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.openpgp) {
											openpgpCallback(__WEBPACK_IMPORTED_MODULE_0_window___default.a.openpgp);
										}
									});
								}
							})();
						} else {
							__WEBPACK_IMPORTED_MODULE_21_Stores_User_Pgp___default.a.capaOpenPGP(false);
						}

						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_37_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_35_Screen_User_MailBox__["a" /* MailBoxUserScreen */], __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Capa"].Settings) ? __WEBPACK_IMPORTED_MODULE_36_Screen_User_Settings__["a" /* SettingsUserScreen */] : null
						//							false ? AboutUserScreen : null
						]);

						if (bGoogle || bFacebook || bTwitter) {
							_this8.socialUsers(true);
						}

						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.2m', function () {
							return _this8.folderInformation(__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]());
						});
						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.3m', function () {
							var sF = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw();
							if (__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]() !== sF) {
								_this8.folderInformation(sF);
							}
						});

						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.2m-after5m', function () {
							return _this8.folderInformationMultiply();
						});
						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.15m', function () {
							return _this8.quota();
						});
						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.20m', function () {
							return _this8.foldersReload();
						});

						iContactsSyncInterval = 5 <= iContactsSyncInterval ? iContactsSyncInterval : 20;
						iContactsSyncInterval = 320 >= iContactsSyncInterval ? iContactsSyncInterval : 320;

						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							return _this8.contactsSync();
						}, 10000);
						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							return _this8.folderInformationMultiply(true);
						}, 2000);

						__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(function () {
							return _this8.contactsSync();
						}, iContactsSyncInterval * 60000 + 5000);

						_this8.accountsAndIdentities(true);

						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							var sF = __WEBPACK_IMPORTED_MODULE_20_Stores_User_Folder___default.a.currentFolderFullNameRaw();
							if (__WEBPACK_IMPORTED_MODULE_13_Common_Cache__["getFolderInboxName"]() !== sF) {
								_this8.folderInformation(sF);
							}
						}, 1000);

						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							return _this8.quota();
						}, 5000);
						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							return __WEBPACK_IMPORTED_MODULE_27_Remote_User_Ajax___default.a.appDelayStart(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"]);
						}, 35000);

						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('rl.auto-logout', function () {
							return _this8.logout();
						});

						__WEBPACK_IMPORTED_MODULE_9_Common_Plugins__["runHook"]('rl-start-user-screens');
						__WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('rl.bootstart-user-screens');

						if (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('WelcomePageUrl')) {
							__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
								return _this8.bootstartWelcomePopup(__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('WelcomePageUrl'));
							}, 1000);
						}

						if (!!__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('AccountSignMe') && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.registerProtocolHandler && __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Capa"].Composer)) {
							__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
								try {
									__WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.registerProtocolHandler('mailto', __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.protocol + '//' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.host + __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.pathname + '?mailto&to=%s', '' + (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('Title') || 'RainLoop'));
								} catch (e) {} // eslint-disable-line no-empty

								if (__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('MailToEmail')) {
									__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["mailToHelper"])(__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["settingsGet"]('MailToEmail'), __webpack_require__(/*! View/Popup/Compose */ 25));
								}
							}, 500);
						}

						if (!__WEBPACK_IMPORTED_MODULE_7_Common_Globals__["bMobileDevice"]) {
							__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
								return _this8.initVerticalLayoutResizer(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["ClientSideKeyName"].FolderListSize);
							});

							if (__WEBPACK_IMPORTED_MODULE_4_Tinycon___default.a && __WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('faviconStatus') && !__WEBPACK_IMPORTED_MODULE_25_Storage_Settings__["appSettingsGet"]('listPermanentFiltered')) {
								__WEBPACK_IMPORTED_MODULE_4_Tinycon___default.a.setOptions({
									fallback: false
								});

								__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('mailbox.inbox-unread-count', function (iCount) {
									return __WEBPACK_IMPORTED_MODULE_4_Tinycon___default.a.setBubble(0 < iCount ? 99 < iCount ? 99 : iCount : 0);
								});
							}
						}
					} else {
						_this8.logout();
					}
				});

				// }); // require code splitting
			}
		} else {
			this.bootend();
			this.bootstartLoginScreen();
		}

		if (bGoogle) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a['rl_' + sJsHash + '_google_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.google.loading(true);
				_this8.socialUsers();
			};
		}

		if (bFacebook) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a['rl_' + sJsHash + '_facebook_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.facebook.loading(true);
				_this8.socialUsers();
			};
		}

		if (bTwitter) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a['rl_' + sJsHash + '_twitter_service'] = function () {
				__WEBPACK_IMPORTED_MODULE_15_Stores_Social___default.a.twitter.loading(true);
				_this8.socialUsers();
			};
		}

		__WEBPACK_IMPORTED_MODULE_11_Common_Events__["sub"]('interval.1m', function () {
			return __WEBPACK_IMPORTED_MODULE_12_Common_Momentor__["reload"]();
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Plugins__["runHook"]('rl-start-screens');
		__WEBPACK_IMPORTED_MODULE_11_Common_Events__["pub"]('rl.bootstart-end');
	};

	return AppUser;
}(__WEBPACK_IMPORTED_MODULE_38_App_Abstract__["a" /* AbstractApp */]);

/* harmony default export */ exports["default"] = new AppUser();

/***/ },
/* 9 */
/*!*************************!*\
  !*** external "window" ***!
  \*************************/
/***/ function(module, exports) {

module.exports = window;

/***/ },
/* 10 */
/*!********************************!*\
  !*** external "window.jQuery" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.jQuery;

/***/ },
/* 11 */
/*!***********************************!*\
  !*** ./dev/Knoin/AbstractView.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Globals = __webpack_require__(/*! Common/Globals */ 5);

/**
 * @constructor
 * @param {string=} sPosition = ''
 * @param {string=} sTemplate = ''
 */
function AbstractView(sPosition, sTemplate)
{
	this.bDisabeCloseOnEsc = false;
	this.sPosition = Utils.pString(sPosition);
	this.sTemplate = Utils.pString(sTemplate);

	this.sDefaultKeyScope = Enums.KeyState.None;
	this.sCurrentKeyScope = this.sDefaultKeyScope;

	this.viewModelVisibility = ko.observable(false);
	this.modalVisibility = ko.observable(false).extend({'rateLimit': 0});

	this.viewModelName = '';
	this.viewModelNames = [];
	this.viewModelDom = null;
}

/**
 * @type {boolean}
 */
AbstractView.prototype.bDisabeCloseOnEsc = false;

/**
 * @type {string}
 */
AbstractView.prototype.sPosition = '';

/**
 * @type {string}
 */
AbstractView.prototype.sTemplate = '';

/**
 * @type {string}
 */
AbstractView.prototype.sDefaultKeyScope = Enums.KeyState.None;

/**
 * @type {string}
 */
AbstractView.prototype.sCurrentKeyScope = Enums.KeyState.None;

/**
 * @type {string}
 */
AbstractView.prototype.viewModelName = '';

/**
 * @type {Array}
 */
AbstractView.prototype.viewModelNames = [];

/**
 * @type {?}
 */
AbstractView.prototype.viewModelDom = null;

/**
 * @returns {string}
 */
AbstractView.prototype.viewModelTemplate = function()
{
	return this.sTemplate;
};

/**
 * @returns {string}
 */
AbstractView.prototype.viewModelPosition = function()
{
	return this.sPosition;
};

AbstractView.prototype.cancelCommand = Utils.noop;
AbstractView.prototype.closeCommand = Utils.noop;

AbstractView.prototype.storeAndSetKeyScope = function()
{
	this.sCurrentKeyScope = Globals.keyScope();
	Globals.keyScope(this.sDefaultKeyScope);
};

AbstractView.prototype.restoreKeyScope = function()
{
	Globals.keyScope(this.sCurrentKeyScope);
};

AbstractView.prototype.registerPopupKeyDown = function()
{
	var self = this;

	Globals.$win.on('keydown', function(oEvent) {
		if (oEvent && self.modalVisibility && self.modalVisibility())
		{
			if (!this.bDisabeCloseOnEsc && Enums.EventKeyCode.Esc === oEvent.keyCode)
			{
				Utils.delegateRun(self, 'cancelCommand');
				return false;
			}
			else if (Enums.EventKeyCode.Backspace === oEvent.keyCode && !Utils.inFocus())
			{
				return false;
			}
		}

		return true;
	});
};

module.exports = AbstractView;


/***/ },
/* 12 */
/*!******************************!*\
  !*** ./dev/Common/Links.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony export */ exports["populateAuthSuffix"] = populateAuthSuffix;/* harmony export */ exports["subQueryPrefix"] = subQueryPrefix;/* harmony export */ exports["root"] = root;/* harmony export */ exports["rootAdmin"] = rootAdmin;/* harmony export */ exports["rootUser"] = rootUser;/* harmony export */ exports["attachmentRaw"] = attachmentRaw;/* harmony export */ exports["attachmentDownload"] = attachmentDownload;/* harmony export */ exports["attachmentPreview"] = attachmentPreview;/* harmony export */ exports["attachmentThumbnailPreview"] = attachmentThumbnailPreview;/* harmony export */ exports["attachmentPreviewAsPlain"] = attachmentPreviewAsPlain;/* harmony export */ exports["attachmentFramed"] = attachmentFramed;/* harmony export */ exports["serverRequest"] = serverRequest;/* harmony export */ exports["upload"] = upload;/* harmony export */ exports["uploadContacts"] = uploadContacts;/* harmony export */ exports["uploadBackground"] = uploadBackground;/* harmony export */ exports["append"] = append;/* harmony export */ exports["change"] = change;/* harmony export */ exports["ajax"] = ajax;/* harmony export */ exports["messageViewLink"] = messageViewLink;/* harmony export */ exports["messageDownloadLink"] = messageDownloadLink;/* harmony export */ exports["avatarLink"] = avatarLink;/* harmony export */ exports["publicLink"] = publicLink;/* harmony export */ exports["userBackground"] = userBackground;/* harmony export */ exports["phpInfo"] = phpInfo;/* harmony export */ exports["langLink"] = langLink;/* harmony export */ exports["exportContactsVcf"] = exportContactsVcf;/* harmony export */ exports["exportContactsCsv"] = exportContactsCsv;/* harmony export */ exports["socialGoogle"] = socialGoogle;/* harmony export */ exports["socialTwitter"] = socialTwitter;/* harmony export */ exports["socialFacebook"] = socialFacebook;/* harmony export */ exports["staticPrefix"] = staticPrefix;/* harmony export */ exports["emptyContactPic"] = emptyContactPic;/* harmony export */ exports["sound"] = sound;/* harmony export */ exports["notificationMailIcon"] = notificationMailIcon;/* harmony export */ exports["openPgpJs"] = openPgpJs;/* harmony export */ exports["openPgpWorkerJs"] = openPgpWorkerJs;/* harmony export */ exports["openPgpWorkerPath"] = openPgpWorkerPath;/* harmony export */ exports["themePreviewLink"] = themePreviewLink;/* harmony export */ exports["inbox"] = inbox;/* harmony export */ exports["settings"] = settings;/* harmony export */ exports["about"] = about;/* harmony export */ exports["admin"] = admin;/* harmony export */ exports["mailBox"] = mailBox;




var ROOT = './',
    HASH_PREFIX = '#/',
    SERVER_PREFIX = './?',
    SUB_QUERY_PREFIX = '&q[]=',
    VERSION = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('version'),
    WEB_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webPath') || '',
    VERSION_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webVersionPath') || 'rainloop/v/' + VERSION + '/',
    STATIC_PREFIX = VERSION_PREFIX + 'static/',
    ADMIN_HOST_USE = !!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminHostUse'),
    ADMIN_PATH = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminPath') || 'admin';

var AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';

/**
 * @returns {void}
 */
function populateAuthSuffix() {
  AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';
}

/**
 * @returns {string}
 */
function subQueryPrefix() {
  return SUB_QUERY_PREFIX;
}

/**
 * @param {string=} startupUrl
 * @returns {string}
 */
function root() {
  var startupUrl = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

  return HASH_PREFIX + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(startupUrl);
}

/**
 * @returns {string}
 */
function rootAdmin() {
  return ADMIN_HOST_USE ? ROOT : SERVER_PREFIX + ADMIN_PATH;
}

/**
 * @param {boolean=} mobile = false
 * @returns {string}
 */
function rootUser() {
  var mobile = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

  return mobile ? SERVER_PREFIX + '/Mobile/' : ROOT;
}

/**
 * @param {string} type
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentRaw(type, download, customSpecSuffix) {
  customSpecSuffix = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(customSpecSuffix) ? AUTH_PREFIX : customSpecSuffix;
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + customSpecSuffix + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + download;
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentDownload(download, customSpecSuffix) {
  return attachmentRaw('Download', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreview(download, customSpecSuffix) {
  return attachmentRaw('View', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentThumbnailPreview(download, customSpecSuffix) {
  return attachmentRaw('ViewThumbnail', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreviewAsPlain(download, customSpecSuffix) {
  return attachmentRaw('ViewAsPlain', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentFramed(download, customSpecSuffix) {
  return attachmentRaw('FramedView', download, customSpecSuffix);
}

/**
 * @param {string} type
 * @returns {string}
 */
function serverRequest(type) {
  return SERVER_PREFIX + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/';
}

/**
 * @returns {string}
 */
function upload() {
  return serverRequest('Upload');
}

/**
 * @returns {string}
 */
function uploadContacts() {
  return serverRequest('UploadContacts');
}

/**
 * @returns {string}
 */
function uploadBackground() {
  return serverRequest('UploadBackground');
}

/**
 * @returns {string}
 */
function append() {
  return serverRequest('Append');
}

/**
 * @param {string} email
 * @returns {string}
 */
function change(email) {
  return serverRequest('Change') + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} add
 * @returns {string}
 */
function ajax(add) {
  return serverRequest('Ajax') + add;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageViewLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ViewAsPlain/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageDownloadLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/Download/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} email
 * @returns {string}
 */
function avatarLink(email) {
  return SERVER_PREFIX + '/Raw/0/Avatar/' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function publicLink(hash) {
  return SERVER_PREFIX + '/Raw/0/Public/' + hash + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function userBackground(hash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/UserBackground/' + SUB_QUERY_PREFIX + '/' + hash;
}

/**
 * @returns {string}
 */
function phpInfo() {
  return SERVER_PREFIX + '/Info';
}

/**
 * @param {string} lang
 * @param {boolean} isAdmin
 * @returns {string}
 */
function langLink(lang, isAdmin) {
  return SERVER_PREFIX + '/Lang/0/' + (isAdmin ? 'Admin' : 'App') + '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(lang) + '/' + VERSION + '/';
}

/**
 * @returns {string}
 */
function exportContactsVcf() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsVcf/';
}

/**
 * @returns {string}
 */
function exportContactsCsv() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsCsv/';
}

/**
 * @param {boolean} xauth = false
 * @returns {string}
 */
function socialGoogle() {
  var xauth = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

  return SERVER_PREFIX + 'SocialGoogle' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '') + (xauth ? '&xauth=1' : '');
}

/**
 * @returns {string}
 */
function socialTwitter() {
  return SERVER_PREFIX + 'SocialTwitter' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @returns {string}
 */
function socialFacebook() {
  return SERVER_PREFIX + 'SocialFacebook' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @param {string} path
 * @returns {string}
 */
function staticPrefix(path) {
  return STATIC_PREFIX + path;
}

/**
 * @returns {string}
 */
function emptyContactPic() {
  return staticPrefix('css/images/empty-contact.png');
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function sound(fileName) {
  return staticPrefix('sounds/' + fileName);
}

/**
 * @returns {string}
 */
function notificationMailIcon() {
  return staticPrefix('css/images/icom-message-notification.png');
}

/**
 * @returns {string}
 */
function openPgpJs() {
  return staticPrefix('js/min/openpgp.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerJs() {
  return staticPrefix('js/min/openpgp.worker.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerPath() {
  return staticPrefix('js/min/');
}

/**
 * @param {string} theme
 * @returns {string}
 */
function themePreviewLink(theme) {
  var prefix = VERSION_PREFIX;
  if ('@custom' === theme.substr(-7)) {
    theme = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(theme.substring(0, theme.length - 7));
    prefix = WEB_PREFIX;
  }

  return prefix + 'themes/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(theme) + '/images/preview.png';
}

/**
 * @param {string} inboxFolderName = 'INBOX'
 * @returns {string}
 */
function inbox() {
  var inboxFolderName = arguments.length <= 0 || arguments[0] === undefined ? 'INBOX' : arguments[0];

  return HASH_PREFIX + 'mailbox/' + inboxFolderName;
}

/**
 * @param {string=} screenName = ''
 * @returns {string}
 */
function settings() {
  var screenName = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

  return HASH_PREFIX + 'settings' + (screenName ? '/' + screenName : '');
}

/**
 * @returns {string}
 */
function about() {
  return HASH_PREFIX + 'about';
}

/**
 * @param {string} screenName
 * @returns {string}
 */
function admin(screenName) {
  var result = HASH_PREFIX;
  switch (screenName) {
    case 'AdminDomains':
      result += 'domains';
      break;
    case 'AdminSecurity':
      result += 'security';
      break;
    case 'AdminLicensing':
      result += 'licensing';
      break;
    // no default
  }

  return result;
}

/**
 * @param {string} folder
 * @param {number=} page = 1
 * @param {string=} search = ''
 * @param {string=} threadUid = ''
 * @returns {string}
 */
function mailBox(folder) {
  var page = arguments.length <= 1 || arguments[1] === undefined ? 1 : arguments[1];
  var search = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];
  var threadUid = arguments.length <= 3 || arguments[3] === undefined ? '' : arguments[3];

  page = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(page) ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(page) : 1;
  search = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(search);

  var result = HASH_PREFIX + 'mailbox/';

  if ('' !== folder) {
    var resultThreadUid = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(threadUid);
    result += __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(folder) + (0 < resultThreadUid ? '~' + resultThreadUid : '');
  }

  if (1 < page) {
    result = result.replace(/[\/]+$/, '');
    result += '/p' + page;
  }

  if ('' !== search) {
    result = result.replace(/[\/]+$/, '');
    result += '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(search);
  }

  return result;
}

/***/ },
/* 13 */
/*!************************************!*\
  !*** ./dev/Component/Abstract.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractComponent; });
/* harmony export */ __webpack_require__.d(exports, "b", function() { return componentExportHelper; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractComponent = function () {
	function AbstractComponent() {
		_classCallCheck(this, AbstractComponent);

		this.disposable = [];
	}

	AbstractComponent.prototype.dispose = function dispose() {
		this.disposable.forEach(function (funcToDispose) {
			if (funcToDispose && funcToDispose.dispose) {
				funcToDispose.dispose();
			}
		});
	};

	return AbstractComponent;
}();

/**
 * @param {*} ClassObject
 * @param {string} templateID = ''
 * @returns {Object}
 */


var componentExportHelper = function componentExportHelper(ClassObject) {
	var templateID = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
	return {
		template: templateID ? { element: templateID } : '<b></b>',
		viewModel: {
			createViewModel: function createViewModel(params, componentInfo) {

				params = params || {};
				params.element = null;

				if (componentInfo && componentInfo.element) {
					params.component = componentInfo;
					params.element = __WEBPACK_IMPORTED_MODULE_0_____default()(componentInfo.element);

					__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(params.element);

					if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.inline) && __WEBPACK_IMPORTED_MODULE_1_ko___default.a.unwrap(params.inline)) {
						params.element.css('display', 'inline-block');
					}
				}

				return new ClassObject(params);
			}
		}
	};
};



/***/ },
/* 14 */
/*!*********************************!*\
  !*** ./dev/Remote/User/Ajax.js ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Base64 = __webpack_require__(/*! Common/Base64 */ 159),

	Cache = __webpack_require__(/*! Common/Cache */ 19),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),

	AbstractAjaxRemote = __webpack_require__(/*! Remote/AbstractAjax */ 58);

/**
 * @constructor
 * @extends AbstractRemoteStorage
 */
function RemoteUserAjax()
{
	AbstractAjaxRemote.call(this);

	this.oRequests = {};
}

_.extend(RemoteUserAjax.prototype, AbstractAjaxRemote.prototype);

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.folders = function(fCallback)
{
	this.defaultRequest(fCallback, 'Folders', {
		'SentFolder': Settings.settingsGet('SentFolder'),
		'DraftFolder': Settings.settingsGet('DraftFolder'),
		'SpamFolder': Settings.settingsGet('SpamFolder'),
		'TrashFolder': Settings.settingsGet('TrashFolder'),
		'ArchiveFolder': Settings.settingsGet('ArchiveFolder')
	}, null, '', ['Folders']);
};

/**
 * @param {?Function} fCallback
 * @param {string} sEmail
 * @param {string} sLogin
 * @param {string} sPassword
 * @param {boolean} bSignMe
 * @param {string=} sLanguage
 * @param {string=} sAdditionalCode
 * @param {boolean=} bAdditionalCodeSignMe
 */
RemoteUserAjax.prototype.login = function(fCallback, sEmail, sLogin, sPassword, bSignMe, sLanguage, sAdditionalCode, bAdditionalCodeSignMe)
{
	this.defaultRequest(fCallback, 'Login', {
		'Email': sEmail,
		'Login': sLogin,
		'Password': sPassword,
		'Language': sLanguage || '',
		'AdditionalCode': sAdditionalCode || '',
		'AdditionalCodeSignMe': bAdditionalCodeSignMe ? '1' : '0',
		'SignMe': bSignMe ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.getTwoFactor = function(fCallback)
{
	this.defaultRequest(fCallback, 'GetTwoFactorInfo');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.createTwoFactor = function(fCallback)
{
	this.defaultRequest(fCallback, 'CreateTwoFactorSecret');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.clearTwoFactor = function(fCallback)
{
	this.defaultRequest(fCallback, 'ClearTwoFactorInfo');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.showTwoFactorSecret = function(fCallback)
{
	this.defaultRequest(fCallback, 'ShowTwoFactorSecret');
};

/**
 * @param {?Function} fCallback
 * @param {string} sCode
 */
RemoteUserAjax.prototype.testTwoFactor = function(fCallback, sCode)
{
	this.defaultRequest(fCallback, 'TestTwoFactorInfo', {
		'Code': sCode
	});
};

/**
 * @param {?Function} fCallback
 * @param {boolean} bEnable
 */
RemoteUserAjax.prototype.enableTwoFactor = function(fCallback, bEnable)
{
	this.defaultRequest(fCallback, 'EnableTwoFactor', {
		'Enable': bEnable ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.clearTwoFactorInfo = function(fCallback)
{
	this.defaultRequest(fCallback, 'ClearTwoFactorInfo');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.contactsSync = function(fCallback)
{
	this.defaultRequest(fCallback, 'ContactsSync', null, Consts.CONTACTS_SYNC_AJAX_TIMEOUT);
};

/**
 * @param {?Function} fCallback
 * @param {boolean} bEnable
 * @param {string} sUrl
 * @param {string} sUser
 * @param {string} sPassword
 */
RemoteUserAjax.prototype.saveContactsSyncData = function(fCallback, bEnable, sUrl, sUser, sPassword)
{
	this.defaultRequest(fCallback, 'SaveContactsSyncData', {
		'Enable': bEnable ? '1' : '0',
		'Url': sUrl,
		'User': sUser,
		'Password': sPassword
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sEmail
 * @param {string} sPassword
 * @param {boolean=} bNew
 */
RemoteUserAjax.prototype.accountSetup = function(fCallback, sEmail, sPassword, bNew)
{
	bNew = Utils.isUnd(bNew) ? true : !!bNew;

	this.defaultRequest(fCallback, 'AccountSetup', {
		'Email': sEmail,
		'Password': sPassword,
		'New': bNew ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sEmailToDelete
 */
RemoteUserAjax.prototype.accountDelete = function(fCallback, sEmailToDelete)
{
	this.defaultRequest(fCallback, 'AccountDelete', {
		'EmailToDelete': sEmailToDelete
	});
};

/**
 * @param {?Function} fCallback
 * @param {Array} aAccounts
 * @param {Array} aIdentities
 */
RemoteUserAjax.prototype.accountsAndIdentitiesSortOrder = function(fCallback, aAccounts, aIdentities)
{
	this.defaultRequest(fCallback, 'AccountsAndIdentitiesSortOrder', {
		'Accounts': aAccounts,
		'Identities': aIdentities
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sId
 * @param {string} sEmail
 * @param {string} sName
 * @param {string} sReplyTo
 * @param {string} sBcc
 * @param {string} sSignature
 * @param {boolean} bSignatureInsertBefore
 */
RemoteUserAjax.prototype.identityUpdate = function(fCallback, sId, sEmail, sName, sReplyTo, sBcc,
	sSignature, bSignatureInsertBefore)
{
	this.defaultRequest(fCallback, 'IdentityUpdate', {
		'Id': sId,
		'Email': sEmail,
		'Name': sName,
		'ReplyTo': sReplyTo,
		'Bcc': sBcc,
		'Signature': sSignature,
		'SignatureInsertBefore': bSignatureInsertBefore ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sIdToDelete
 */
RemoteUserAjax.prototype.identityDelete = function(fCallback, sIdToDelete)
{
	this.defaultRequest(fCallback, 'IdentityDelete', {
		'IdToDelete': sIdToDelete
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.accountsAndIdentities = function(fCallback)
{
	this.defaultRequest(fCallback, 'AccountsAndIdentities');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.accountsCounts = function(fCallback)
{
	this.defaultRequest(fCallback, 'AccountsCounts');
};

/**
 * @param {?Function} fCallback
 * @param {Array} aFilters
 * @param {string} sRaw
 * @param {boolean} bRawIsActive
 */
RemoteUserAjax.prototype.filtersSave = function(fCallback, aFilters, sRaw, bRawIsActive)
{
	this.defaultRequest(fCallback, 'FiltersSave', {
		'Raw': sRaw,
		'RawIsActive': bRawIsActive ? '1' : '0',
		'Filters': _.map(aFilters, function(oItem) {
			return oItem.toJson();
		})
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.filtersGet = function(fCallback)
{
	this.defaultRequest(fCallback, 'Filters', {});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.templates = function(fCallback)
{
	this.defaultRequest(fCallback, 'Templates', {});
};

/**
 * @param {Function} fCallback
 * @param {string} sID
 */
RemoteUserAjax.prototype.templateGetById = function(fCallback, sID)
{
	this.defaultRequest(fCallback, 'TemplateGetByID', {
		'ID': sID
	});
};

/**
 * @param {Function} fCallback
 * @param {string} sID
 */
RemoteUserAjax.prototype.templateDelete = function(fCallback, sID)
{
	this.defaultRequest(fCallback, 'TemplateDelete', {
		'IdToDelete': sID
	});
};

/**
 * @param {Function} fCallback
 * @param {string} sID
 * @param {string} sName
 * @param {string} sBody
 */
RemoteUserAjax.prototype.templateSetup = function(fCallback, sID, sName, sBody)
{
	this.defaultRequest(fCallback, 'TemplateSetup', {
		'ID': sID,
		'Name': sName,
		'Body': sBody
	});
};

/**
 * @param {Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {number=} iOffset = 0
 * @param {number=} iLimit = 20
 * @param {string=} sSearch = ''
 * @param {string=} sThreadUid = ''
 * @param {boolean=} bSilent = false
 */
RemoteUserAjax.prototype.messageList = function(fCallback, sFolderFullNameRaw, iOffset, iLimit, sSearch, sThreadUid, bSilent)
{
	sFolderFullNameRaw = Utils.pString(sFolderFullNameRaw);

	var
		sFolderHash = Cache.getFolderHash(sFolderFullNameRaw),
		bUseThreads = AppStore.threadsAllowed() && SettingsStore.useThreads(),
		sInboxUidNext = Cache.getFolderInboxName() === sFolderFullNameRaw ? Cache.getFolderUidNext(sFolderFullNameRaw) : '';

	bSilent = Utils.isUnd(bSilent) ? false : !!bSilent;
	iOffset = Utils.isUnd(iOffset) ? 0 : Utils.pInt(iOffset);
	iLimit = Utils.isUnd(iOffset) ? 20 : Utils.pInt(iLimit);
	sSearch = Utils.pString(sSearch);
	sThreadUid = Utils.pString(sThreadUid);

	if ('' !== sFolderHash && ('' === sSearch || -1 === sSearch.indexOf('is:')))
	{
		return this.defaultRequest(fCallback, 'MessageList', {},
			'' === sSearch ? Consts.DEFAULT_AJAX_TIMEOUT : Consts.SEARCH_AJAX_TIMEOUT,
			'MessageList/' + Links.subQueryPrefix() + '/' + Base64.urlsafe_encode([
				sFolderFullNameRaw,
				iOffset,
				iLimit,
				sSearch,
				AppStore.projectHash(),
				sFolderHash,
				sInboxUidNext,
				bUseThreads ? '1' : '0',
				bUseThreads ? sThreadUid : ''
			].join(String.fromCharCode(0))), bSilent ? [] : ['MessageList']);
	}

	return this.defaultRequest(fCallback, 'MessageList', {
		Folder: sFolderFullNameRaw,
		Offset: iOffset,
		Limit: iLimit,
		Search: sSearch,
		UidNext: sInboxUidNext,
		UseThreads: bUseThreads ? '1' : '0',
		ThreadUid: bUseThreads ? sThreadUid : ''
	}, '' === sSearch ? Consts.DEFAULT_AJAX_TIMEOUT : Consts.SEARCH_AJAX_TIMEOUT,
		'', bSilent ? [] : ['MessageList']);
};

/**
 * @param {?Function} fCallback
 * @param {Array} aDownloads
 */
RemoteUserAjax.prototype.messageUploadAttachments = function(fCallback, aDownloads)
{
	this.defaultRequest(fCallback, 'MessageUploadAttachments', {
		'Attachments': aDownloads
	}, 999000);
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {number} iUid
 * @returns {boolean}
 */
RemoteUserAjax.prototype.message = function(fCallback, sFolderFullNameRaw, iUid)
{
	sFolderFullNameRaw = Utils.pString(sFolderFullNameRaw);
	iUid = Utils.pInt(iUid);

	if (Cache.getFolderFromCacheList(sFolderFullNameRaw) && 0 < iUid)
	{
		this.defaultRequest(fCallback, 'Message', {}, null,
			'Message/' + Links.subQueryPrefix() + '/' + Base64.urlsafe_encode([
				sFolderFullNameRaw,
				iUid,
				AppStore.projectHash(),
				AppStore.threadsAllowed() && SettingsStore.useThreads() ? '1' : '0'
			].join(String.fromCharCode(0))), ['Message']);

		return true;
	}

	return false;
};

/**
 * @param {?Function} fCallback
 * @param {Array} aExternals
 */
RemoteUserAjax.prototype.composeUploadExternals = function(fCallback, aExternals)
{
	this.defaultRequest(fCallback, 'ComposeUploadExternals', {
		'Externals': aExternals
	}, 999000);
};

/**
 * @param {?Function} fCallback
 * @param {string} sUrl
 * @param {string} sAccessToken
 */
RemoteUserAjax.prototype.composeUploadDrive = function(fCallback, sUrl, sAccessToken)
{
	this.defaultRequest(fCallback, 'ComposeUploadDrive', {
		'AccessToken': sAccessToken,
		'Url': sUrl
	}, 999000);
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolder
 * @param {Array=} aList = []
 */
RemoteUserAjax.prototype.folderInformation = function(fCallback, sFolder, aList)
{
	var
		bRequest = true,
		aUids = [];

	if (Utils.isArray(aList) && 0 < aList.length)
	{
		bRequest = false;
		_.each(aList, function(oMessageListItem) {
			if (!Cache.getMessageFlagsFromCache(oMessageListItem.folderFullNameRaw, oMessageListItem.uid))
			{
				aUids.push(oMessageListItem.uid);
			}

			if (0 < oMessageListItem.threads().length)
			{
				_.each(oMessageListItem.threads(), function(sUid) {
					if (!Cache.getMessageFlagsFromCache(oMessageListItem.folderFullNameRaw, sUid))
					{
						aUids.push(sUid);
					}
				});
			}
		});

		if (0 < aUids.length)
		{
			bRequest = true;
		}
	}

	if (bRequest)
	{
		this.defaultRequest(fCallback, 'FolderInformation', {
			'Folder': sFolder,
			'FlagsUids': Utils.isArray(aUids) ? aUids.join(',') : '',
			'UidNext': Cache.getFolderInboxName() === sFolder ? Cache.getFolderUidNext(sFolder) : ''
		});
	}
	else if (SettingsStore.useThreads())
	{
		__webpack_require__(/*! App/User */ 8).default.reloadFlagsCurrentMessageListAndMessageFromCache();
	}
};

/**
 * @param {?Function} fCallback
 * @param {Array} aFolders
 */
RemoteUserAjax.prototype.folderInformationMultiply = function(fCallback, aFolders)
{
	this.defaultRequest(fCallback, 'FolderInformationMultiply', {
		'Folders': aFolders
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.logout = function(fCallback)
{
	this.defaultRequest(fCallback, 'Logout');
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {Array} aUids
 * @param {boolean} bSetFlagged
 */
RemoteUserAjax.prototype.messageSetFlagged = function(fCallback, sFolderFullNameRaw, aUids, bSetFlagged)
{
	this.defaultRequest(fCallback, 'MessageSetFlagged', {
		'Folder': sFolderFullNameRaw,
		'Uids': aUids.join(','),
		'SetAction': bSetFlagged ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {Array} aUids
 * @param {boolean} bSetSeen
 */
RemoteUserAjax.prototype.messageSetSeen = function(fCallback, sFolderFullNameRaw, aUids, bSetSeen)
{
	this.defaultRequest(fCallback, 'MessageSetSeen', {
		'Folder': sFolderFullNameRaw,
		'Uids': aUids.join(','),
		'SetAction': bSetSeen ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {boolean} bSetSeen
 */
RemoteUserAjax.prototype.messageSetSeenToAll = function(fCallback, sFolderFullNameRaw, bSetSeen)
{
	this.defaultRequest(fCallback, 'MessageSetSeenToAll', {
		'Folder': sFolderFullNameRaw,
		'SetAction': bSetSeen ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sIdentityID
 * @param {string} sMessageFolder
 * @param {string} sMessageUid
 * @param {string} sDraftFolder
 * @param {string} sTo
 * @param {string} sCc
 * @param {string} sBcc
 * @param {string} sReplyTo
 * @param {string} sSubject
 * @param {boolean} bTextIsHtml
 * @param {string} sText
 * @param {Array} aAttachments
 * @param {(Array|null)} aDraftInfo
 * @param {string} sInReplyTo
 * @param {string} sReferences
 * @param {boolean} bMarkAsImportant
 */
RemoteUserAjax.prototype.saveMessage = function(fCallback, sIdentityID, sMessageFolder, sMessageUid, sDraftFolder,
	sTo, sCc, sBcc, sReplyTo, sSubject, bTextIsHtml, sText, aAttachments, aDraftInfo, sInReplyTo, sReferences, bMarkAsImportant)
{
	this.defaultRequest(fCallback, 'SaveMessage', {
		'IdentityID': sIdentityID,
		'MessageFolder': sMessageFolder,
		'MessageUid': sMessageUid,
		'DraftFolder': sDraftFolder,
		'To': sTo,
		'Cc': sCc,
		'Bcc': sBcc,
		'ReplyTo': sReplyTo,
		'Subject': sSubject,
		'TextIsHtml': bTextIsHtml ? '1' : '0',
		'Text': sText,
		'DraftInfo': aDraftInfo,
		'InReplyTo': sInReplyTo,
		'References': sReferences,
		'MarkAsImportant': bMarkAsImportant ? '1' : '0',
		'Attachments': aAttachments
	}, Consts.SAVE_MESSAGE_AJAX_TIMEOUT);
};

/**
 * @param {?Function} fCallback
 * @param {string} sMessageFolder
 * @param {string} sMessageUid
 * @param {string} sReadReceipt
 * @param {string} sSubject
 * @param {string} sText
 */
RemoteUserAjax.prototype.sendReadReceiptMessage = function(fCallback, sMessageFolder, sMessageUid, sReadReceipt, sSubject, sText)
{
	this.defaultRequest(fCallback, 'SendReadReceiptMessage', {
		'MessageFolder': sMessageFolder,
		'MessageUid': sMessageUid,
		'ReadReceipt': sReadReceipt,
		'Subject': sSubject,
		'Text': sText
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sIdentityID
 * @param {string} sMessageFolder
 * @param {string} sMessageUid
 * @param {string} sSentFolder
 * @param {string} sTo
 * @param {string} sCc
 * @param {string} sBcc
 * @param {string} sReplyTo
 * @param {string} sSubject
 * @param {boolean} bTextIsHtml
 * @param {string} sText
 * @param {Array} aAttachments
 * @param {(Array|null)} aDraftInfo
 * @param {string} sInReplyTo
 * @param {string} sReferences
 * @param {boolean} bRequestDsn
 * @param {boolean} bRequestReadReceipt
 * @param {boolean} bMarkAsImportant
 */
RemoteUserAjax.prototype.sendMessage = function(fCallback, sIdentityID, sMessageFolder, sMessageUid, sSentFolder,
	sTo, sCc, sBcc, sReplyTo, sSubject, bTextIsHtml, sText, aAttachments, aDraftInfo, sInReplyTo, sReferences,
	bRequestDsn, bRequestReadReceipt, bMarkAsImportant)
{
	this.defaultRequest(fCallback, 'SendMessage', {
		'IdentityID': sIdentityID,
		'MessageFolder': sMessageFolder,
		'MessageUid': sMessageUid,
		'SentFolder': sSentFolder,
		'To': sTo,
		'Cc': sCc,
		'Bcc': sBcc,
		'ReplyTo': sReplyTo,
		'Subject': sSubject,
		'TextIsHtml': bTextIsHtml ? '1' : '0',
		'Text': sText,
		'DraftInfo': aDraftInfo,
		'InReplyTo': sInReplyTo,
		'References': sReferences,
		'Dsn': bRequestDsn ? '1' : '0',
		'ReadReceiptRequest': bRequestReadReceipt ? '1' : '0',
		'MarkAsImportant': bMarkAsImportant ? '1' : '0',
		'Attachments': aAttachments
	}, Consts.SEND_MESSAGE_AJAX_TIMEOUT);
};

/**
 * @param {?Function} fCallback
 * @param {Object} oData
 */
RemoteUserAjax.prototype.saveSystemFolders = function(fCallback, oData)
{
	this.defaultRequest(fCallback, 'SystemFoldersUpdate', oData);
};

/**
 * @param {?Function} fCallback
 * @param {Object} oData
 */
RemoteUserAjax.prototype.saveSettings = function(fCallback, oData)
{
	this.defaultRequest(fCallback, 'SettingsUpdate', oData);
};

/**
 * @param {?Function} fCallback
 * @param {string} sPrevPassword
 * @param {string} sNewPassword
 */
RemoteUserAjax.prototype.changePassword = function(fCallback, sPrevPassword, sNewPassword)
{
	this.defaultRequest(fCallback, 'ChangePassword', {
		'PrevPassword': sPrevPassword,
		'NewPassword': sNewPassword
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 */
RemoteUserAjax.prototype.folderClear = function(fCallback, sFolderFullNameRaw)
{
	this.defaultRequest(fCallback, 'FolderClear', {
		'Folder': sFolderFullNameRaw
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {boolean} bSubscribe
 */
RemoteUserAjax.prototype.folderSetSubscribe = function(fCallback, sFolderFullNameRaw, bSubscribe)
{
	this.defaultRequest(fCallback, 'FolderSubscribe', {
		'Folder': sFolderFullNameRaw,
		'Subscribe': bSubscribe ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolderFullNameRaw
 * @param {boolean} bCheckable
 */
RemoteUserAjax.prototype.folderSetCheckable = function(fCallback, sFolderFullNameRaw, bCheckable)
{
	this.defaultRequest(fCallback, 'FolderCheckable', {
		'Folder': sFolderFullNameRaw,
		'Checkable': bCheckable ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolder
 * @param {string} sToFolder
 * @param {Array} aUids
 * @param {string=} sLearning
 * @param {boolean=} bMarkAsRead
 */
RemoteUserAjax.prototype.messagesMove = function(fCallback, sFolder, sToFolder, aUids, sLearning, bMarkAsRead)
{
	this.defaultRequest(fCallback, 'MessageMove', {
		'FromFolder': sFolder,
		'ToFolder': sToFolder,
		'Uids': aUids.join(','),
		'MarkAsRead': bMarkAsRead ? '1' : '0',
		'Learning': sLearning || ''
	}, null, '', ['MessageList']);
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolder
 * @param {string} sToFolder
 * @param {Array} aUids
 */
RemoteUserAjax.prototype.messagesCopy = function(fCallback, sFolder, sToFolder, aUids)
{
	this.defaultRequest(fCallback, 'MessageCopy', {
		'FromFolder': sFolder,
		'ToFolder': sToFolder,
		'Uids': aUids.join(',')
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sFolder
 * @param {Array} aUids
 */
RemoteUserAjax.prototype.messagesDelete = function(fCallback, sFolder, aUids)
{
	this.defaultRequest(fCallback, 'MessageDelete', {
		'Folder': sFolder,
		'Uids': aUids.join(',')
	}, null, '', ['MessageList']);
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.appDelayStart = function(fCallback)
{
	this.defaultRequest(fCallback, 'AppDelayStart');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.quota = function(fCallback)
{
	this.defaultRequest(fCallback, 'Quota');
};

/**
 * @param {?Function} fCallback
 * @param {number} iOffset
 * @param {number} iLimit
 * @param {string} sSearch
 */
RemoteUserAjax.prototype.contacts = function(fCallback, iOffset, iLimit, sSearch)
{
	this.defaultRequest(fCallback, 'Contacts', {
		'Offset': iOffset,
		'Limit': iLimit,
		'Search': sSearch
	}, null, '', ['Contacts']);
};

/**
 * @param {?Function} fCallback
 * @param {string} sRequestUid
 * @param {string} sUid
 * @param {Array} aProperties
 */
RemoteUserAjax.prototype.contactSave = function(fCallback, sRequestUid, sUid, aProperties)
{
	this.defaultRequest(fCallback, 'ContactSave', {
		'RequestUid': sRequestUid,
		'Uid': Utils.trim(sUid),
		'Properties': aProperties
	});
};

/**
 * @param {?Function} fCallback
 * @param {Array} aUids
 */
RemoteUserAjax.prototype.contactsDelete = function(fCallback, aUids)
{
	this.defaultRequest(fCallback, 'ContactsDelete', {
		'Uids': aUids.join(',')
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sQuery
 * @param {number} iPage
 */
RemoteUserAjax.prototype.suggestions = function(fCallback, sQuery, iPage)
{
	this.defaultRequest(fCallback, 'Suggestions', {
		'Query': sQuery,
		'Page': iPage
	}, null, '', ['Suggestions']);
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.clearUserBackground = function(fCallback)
{
	this.defaultRequest(fCallback, 'ClearUserBackground');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.facebookUser = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialFacebookUserInformation');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.facebookDisconnect = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialFacebookDisconnect');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.twitterUser = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialTwitterUserInformation');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.twitterDisconnect = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialTwitterDisconnect');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.googleUser = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialGoogleUserInformation');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.googleDisconnect = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialGoogleDisconnect');
};

/**
 * @param {?Function} fCallback
 */
RemoteUserAjax.prototype.socialUsers = function(fCallback)
{
	this.defaultRequest(fCallback, 'SocialUsers');
};

module.exports = new RemoteUserAjax();


/***/ },
/* 15 */
/*!*******************************!*\
  !*** ./dev/Common/Consts.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "MESSAGES_PER_PAGE", function() { return MESSAGES_PER_PAGE; });
/* harmony export */ __webpack_require__.d(exports, "MESSAGES_PER_PAGE_VALUES", function() { return MESSAGES_PER_PAGE_VALUES; });
/* harmony export */ __webpack_require__.d(exports, "CONTACTS_PER_PAGE", function() { return CONTACTS_PER_PAGE; });
/* harmony export */ __webpack_require__.d(exports, "DEFAULT_AJAX_TIMEOUT", function() { return DEFAULT_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SEARCH_AJAX_TIMEOUT", function() { return SEARCH_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SEND_MESSAGE_AJAX_TIMEOUT", function() { return SEND_MESSAGE_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SAVE_MESSAGE_AJAX_TIMEOUT", function() { return SAVE_MESSAGE_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "CONTACTS_SYNC_AJAX_TIMEOUT", function() { return CONTACTS_SYNC_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "UNUSED_OPTION_VALUE", function() { return UNUSED_OPTION_VALUE; });
/* harmony export */ __webpack_require__.d(exports, "CLIENT_SIDE_STORAGE_INDEX_NAME", function() { return CLIENT_SIDE_STORAGE_INDEX_NAME; });
/* harmony export */ __webpack_require__.d(exports, "IMAP_DEFAULT_PORT", function() { return IMAP_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "IMAP_DEFAULT_SECURE_PORT", function() { return IMAP_DEFAULT_SECURE_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SMTP_DEFAULT_PORT", function() { return SMTP_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SMTP_DEFAULT_SECURE_PORT", function() { return SMTP_DEFAULT_SECURE_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SIEVE_DEFAULT_PORT", function() { return SIEVE_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "MESSAGE_BODY_CACHE_LIMIT", function() { return MESSAGE_BODY_CACHE_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "AJAX_ERROR_LIMIT", function() { return AJAX_ERROR_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "TOKEN_ERROR_LIMIT", function() { return TOKEN_ERROR_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "RAINLOOP_TRIAL_KEY", function() { return RAINLOOP_TRIAL_KEY; });
/* harmony export */ __webpack_require__.d(exports, "DATA_IMAGE_USER_DOT_PIC", function() { return DATA_IMAGE_USER_DOT_PIC; });
/* harmony export */ __webpack_require__.d(exports, "DATA_IMAGE_TRANSP_PIC", function() { return DATA_IMAGE_TRANSP_PIC; });
/* eslint max-len: 0 */
var MESSAGES_PER_PAGE = 20;

var MESSAGES_PER_PAGE_VALUES = [10, 20, 30, 50, 100];

var CONTACTS_PER_PAGE = 50;

var DEFAULT_AJAX_TIMEOUT = 30000;

var SEARCH_AJAX_TIMEOUT = 300000;

var SEND_MESSAGE_AJAX_TIMEOUT = 300000;

var SAVE_MESSAGE_AJAX_TIMEOUT = 200000;

var CONTACTS_SYNC_AJAX_TIMEOUT = 200000;

var UNUSED_OPTION_VALUE = '__UNUSE__';

var CLIENT_SIDE_STORAGE_INDEX_NAME = 'rlcsc';

var IMAP_DEFAULT_PORT = 143;

var IMAP_DEFAULT_SECURE_PORT = 993;

var SMTP_DEFAULT_PORT = 25;

var SMTP_DEFAULT_SECURE_PORT = 465;

var SIEVE_DEFAULT_PORT = 4190;

var MESSAGE_BODY_CACHE_LIMIT = 15;

var AJAX_ERROR_LIMIT = 7;

var TOKEN_ERROR_LIMIT = 10;

var RAINLOOP_TRIAL_KEY = 'RAINLOOP-TRIAL-KEY';

var DATA_IMAGE_USER_DOT_PIC = 'data:image/png;base64,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';

var DATA_IMAGE_TRANSP_PIC = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQIW2NkAAIAAAoAAggA9GkAAAAASUVORK5CYII=';

/***/ },
/* 16 */
/*!*****************************!*\
  !*** external "window.key" ***!
  \*****************************/
/***/ function(module, exports) {

module.exports = window.key;

/***/ },
/* 17 */,
/* 18 */,
/* 19 */
/*!******************************!*\
  !*** ./dev/Common/Cache.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony export */ exports["clear"] = clear;/* harmony export */ exports["getUserPic"] = getUserPic;/* harmony export */ exports["getMessageKey"] = getMessageKey;/* harmony export */ exports["addRequestedMessage"] = addRequestedMessage;/* harmony export */ exports["hasRequestedMessage"] = hasRequestedMessage;/* harmony export */ exports["addNewMessageCache"] = addNewMessageCache;/* harmony export */ exports["hasNewMessageAndRemoveFromCache"] = hasNewMessageAndRemoveFromCache;/* harmony export */ exports["clearNewMessageCache"] = clearNewMessageCache;/* harmony export */ exports["getFolderInboxName"] = getFolderInboxName;/* harmony export */ exports["getFolderFullNameRaw"] = getFolderFullNameRaw;/* harmony export */ exports["setFolderFullNameRaw"] = setFolderFullNameRaw;/* harmony export */ exports["getFolderHash"] = getFolderHash;/* harmony export */ exports["setFolderHash"] = setFolderHash;/* harmony export */ exports["getFolderUidNext"] = getFolderUidNext;/* harmony export */ exports["setFolderUidNext"] = setFolderUidNext;/* harmony export */ exports["getFolderFromCacheList"] = getFolderFromCacheList;/* harmony export */ exports["setFolderToCacheList"] = setFolderToCacheList;/* harmony export */ exports["removeFolderFromCacheList"] = removeFolderFromCacheList;/* harmony export */ exports["getMessageFlagsFromCache"] = getMessageFlagsFromCache;/* harmony export */ exports["setMessageFlagsToCache"] = setMessageFlagsToCache;/* harmony export */ exports["clearMessageFlagsFromCacheByFolder"] = clearMessageFlagsFromCacheByFolder;/* harmony export */ exports["initMessageFlagsFromCache"] = initMessageFlagsFromCache;/* harmony export */ exports["storeMessageFlagsToCache"] = storeMessageFlagsToCache;/* harmony export */ exports["storeMessageFlagsToCacheByFolderAndUid"] = storeMessageFlagsToCacheByFolderAndUid;/* harmony export */ exports["storeMessageFlagsToCacheBySetAction"] = storeMessageFlagsToCacheBySetAction;






var FOLDERS_CACHE = {},
    FOLDERS_NAME_CACHE = {},
    FOLDERS_HASH_CACHE = {},
    FOLDERS_UID_NEXT_CACHE = {},
    MESSAGE_FLAGS_CACHE = {},
    NEW_MESSAGE_CACHE = {},
    inboxFolderName = '';

var REQUESTED_MESSAGE_CACHE = {},
    capaGravatar = __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["capa"](__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Capa"].Gravatar);

/**
 * @returns {void}
 */
function clear() {
	FOLDERS_CACHE = {};
	FOLDERS_NAME_CACHE = {};
	FOLDERS_HASH_CACHE = {};
	FOLDERS_UID_NEXT_CACHE = {};
	MESSAGE_FLAGS_CACHE = {};
}

/**
 * @param {string} email
 * @param {Function} callback
 * @returns {string}
 */
function getUserPic(email, callback) {
	email = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["trim"])(email);
	callback(capaGravatar && '' !== email ? __WEBPACK_IMPORTED_MODULE_3_Common_Links__["avatarLink"](email) : '', email);
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 * @returns {string}
 */
function getMessageKey(folderFullNameRaw, uid) {
	return folderFullNameRaw + '#' + uid;
}

/**
 * @param {string} folder
 * @param {string} uid
 */
function addRequestedMessage(folder, uid) {
	REQUESTED_MESSAGE_CACHE[getMessageKey(folder, uid)] = true;
}

/**
 * @param {string} folder
 * @param {string} uid
 * @returns {boolean}
 */
function hasRequestedMessage(folder, uid) {
	return true === REQUESTED_MESSAGE_CACHE[getMessageKey(folder, uid)];
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 */
function addNewMessageCache(folderFullNameRaw, uid) {
	NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)] = true;
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uid
 */
function hasNewMessageAndRemoveFromCache(folderFullNameRaw, uid) {
	if (NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)]) {
		NEW_MESSAGE_CACHE[getMessageKey(folderFullNameRaw, uid)] = null;
		return true;
	}
	return false;
}

/**
 * @returns {void}
 */
function clearNewMessageCache() {
	NEW_MESSAGE_CACHE = {};
}

/**
 * @returns {string}
 */
function getFolderInboxName() {
	return '' === inboxFolderName ? 'INBOX' : inboxFolderName;
}

/**
 * @param {string} folderHash
 * @returns {string}
 */
function getFolderFullNameRaw(folderHash) {
	return '' !== folderHash && FOLDERS_NAME_CACHE[folderHash] ? FOLDERS_NAME_CACHE[folderHash] : '';
}

/**
 * @param {string} folderHash
 * @param {string} folderFullNameRaw
 */
function setFolderFullNameRaw(folderHash, folderFullNameRaw) {
	FOLDERS_NAME_CACHE[folderHash] = folderFullNameRaw;
	if ('INBOX' === folderFullNameRaw || '' === inboxFolderName) {
		inboxFolderName = folderFullNameRaw;
	}
}

/**
 * @param {string} folderFullNameRaw
 * @returns {string}
 */
function getFolderHash(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_HASH_CACHE[folderFullNameRaw] ? FOLDERS_HASH_CACHE[folderFullNameRaw] : '';
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} folderHash
 */
function setFolderHash(folderFullNameRaw, folderHash) {
	if ('' !== folderFullNameRaw) {
		FOLDERS_HASH_CACHE[folderFullNameRaw] = folderHash;
	}
}

/**
 * @param {string} folderFullNameRaw
 * @returns {string}
 */
function getFolderUidNext(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] ? FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] : '';
}

/**
 * @param {string} folderFullNameRaw
 * @param {string} uidNext
 */
function setFolderUidNext(folderFullNameRaw, uidNext) {
	FOLDERS_UID_NEXT_CACHE[folderFullNameRaw] = uidNext;
}

/**
 * @param {string} folderFullNameRaw
 * @returns {?FolderModel}
 */
function getFolderFromCacheList(folderFullNameRaw) {
	return '' !== folderFullNameRaw && FOLDERS_CACHE[folderFullNameRaw] ? FOLDERS_CACHE[folderFullNameRaw] : null;
}

/**
 * @param {string} folderFullNameRaw
 * @param {?FolderModel} folder
 */
function setFolderToCacheList(folderFullNameRaw, folder) {
	FOLDERS_CACHE[folderFullNameRaw] = folder;
}

/**
 * @param {string} folderFullNameRaw
 */
function removeFolderFromCacheList(folderFullNameRaw) {
	setFolderToCacheList(folderFullNameRaw, null);
}

/**
 * @param {string} folderFullName
 * @param {string} uid
 * @returns {?Array}
 */
function getMessageFlagsFromCache(folderFullName, uid) {
	return MESSAGE_FLAGS_CACHE[folderFullName] && MESSAGE_FLAGS_CACHE[folderFullName][uid] ? MESSAGE_FLAGS_CACHE[folderFullName][uid] : null;
}

/**
 * @param {string} folderFullName
 * @param {string} uid
 * @param {Array} flagsCache
 */
function setMessageFlagsToCache(folderFullName, uid, flagsCache) {
	if (!MESSAGE_FLAGS_CACHE[folderFullName]) {
		MESSAGE_FLAGS_CACHE[folderFullName] = {};
	}

	MESSAGE_FLAGS_CACHE[folderFullName][uid] = flagsCache;
}

/**
 * @param {string} folderFullName
 */
function clearMessageFlagsFromCacheByFolder(folderFullName) {
	MESSAGE_FLAGS_CACHE[folderFullName] = {};
}

/**
 * @param {(MessageModel|null)} message
 */
function initMessageFlagsFromCache(message) {

	if (message) {
		(function () {
			var uid = message.uid,
			    flags = getMessageFlagsFromCache(message.folderFullNameRaw, uid);

			if (flags && 0 < flags.length) {
				message.flagged(!!flags[1]);

				if (!message.isSimpleMessage) {
					message.unseen(!!flags[0]);
					message.answered(!!flags[2]);
					message.forwarded(!!flags[3]);
					message.isReadReceipt(!!flags[4]);
					message.deletedMark(!!flags[5]);
				}
			}

			if (0 < message.threads().length) {
				var unseenSubUid = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(message.threads(), function (sSubUid) {
					if (uid !== sSubUid) {
						var subFlags = getMessageFlagsFromCache(message.folderFullNameRaw, sSubUid);
						return subFlags && 0 < subFlags.length && !!subFlags[0];
					}
					return false;
				});

				var flaggedSubUid = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(message.threads(), function (sSubUid) {
					if (uid !== sSubUid) {
						var subFlags = getMessageFlagsFromCache(message.folderFullNameRaw, sSubUid);
						return subFlags && 0 < subFlags.length && !!subFlags[1];
					}
					return false;
				});

				message.hasUnseenSubMessage(unseenSubUid && 0 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pInt"])(unseenSubUid));
				message.hasFlaggedSubMessage(flaggedSubUid && 0 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pInt"])(flaggedSubUid));
			}
		})();
	}
}

/**
 * @param {(MessageModel|null)} message
 */
function storeMessageFlagsToCache(message) {
	if (message) {
		setMessageFlagsToCache(message.folderFullNameRaw, message.uid, [message.unseen(), message.flagged(), message.answered(), message.forwarded(), message.isReadReceipt(), message.deletedMark()]);
	}
}

/**
 * @param {string} folder
 * @param {string} uid
 * @param {Array} flags
 */
function storeMessageFlagsToCacheByFolderAndUid(folder, uid, flags) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(flags) && 0 < flags.length) {
		setMessageFlagsToCache(folder, uid, flags);
	}
}

/**
 * @param {string} folder
 * @param {string} uid
 * @param {number} setAction
 */
function storeMessageFlagsToCacheBySetAction(folder, uid, setAction) {

	var unread = 0;
	var flags = getMessageFlagsFromCache(folder, uid);

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(flags) && 0 < flags.length) {
		if (flags[0]) {
			unread = 1;
		}

		switch (setAction) {
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].SetSeen:
				flags[0] = false;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].UnsetSeen:
				flags[0] = true;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].SetFlag:
				flags[1] = true;
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["MessageSetAction"].UnsetFlag:
				flags[1] = false;
				break;
			// no default
		}

		setMessageFlagsToCache(folder, uid, flags);
	}

	return unread;
}

/***/ },
/* 20 */
/*!***********************************!*\
  !*** ./dev/Stores/User/Folder.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Cache = __webpack_require__(/*! Common/Cache */ 19);

/**
 * @constructor
 */
function FolderUserStore()
{
	this.displaySpecSetting = ko.observable(true);

	this.sentFolder = ko.observable('');
	this.draftFolder = ko.observable('');
	this.spamFolder = ko.observable('');
	this.trashFolder = ko.observable('');
	this.archiveFolder = ko.observable('');

	this.namespace = '';

	this.folderList = ko.observableArray([]);
	this.folderList.optimized = ko.observable(false);
	this.folderList.error = ko.observable('');

	this.foldersLoading = ko.observable(false);
	this.foldersCreating = ko.observable(false);
	this.foldersDeleting = ko.observable(false);
	this.foldersRenaming = ko.observable(false);

	this.foldersInboxUnreadCount = ko.observable(0);

	this.currentFolder = ko.observable(null).extend({toggleSubscribe: [
		null,
		function(oPrev) {
			if (oPrev) {
				oPrev.selected(false);
			}
		},
		function(oNext) {
			if (oNext) {
				oNext.selected(true);
			}
		}
	]});

	this.computers();
	this.subscribers();
}

FolderUserStore.prototype.computers = function()
{
	this.draftFolderNotEnabled = ko.computed(function() {
		return '' === this.draftFolder() || Consts.UNUSED_OPTION_VALUE === this.draftFolder();
	}, this);

	this.foldersListWithSingleInboxRootFolder = ko.computed(function() {
		return !_.find(this.folderList(), function(oFolder) {
			return oFolder && !oFolder.isSystemFolder() && oFolder.visible();
		});
	}, this);

	this.currentFolderFullNameRaw = ko.computed(function() {
		return this.currentFolder() ? this.currentFolder().fullNameRaw : '';
	}, this);

	this.currentFolderFullName = ko.computed(function() {
		return this.currentFolder() ? this.currentFolder().fullName : '';
	}, this);

	this.currentFolderFullNameHash = ko.computed(function() {
		return this.currentFolder() ? this.currentFolder().fullNameHash : '';
	}, this);

	this.foldersChanging = ko.computed(function() {
		var
			bLoading = this.foldersLoading(),
			bCreating = this.foldersCreating(),
			bDeleting = this.foldersDeleting(),
			bRenaming = this.foldersRenaming();
		return bLoading || bCreating || bDeleting || bRenaming;
	}, this);

	this.folderListSystemNames = ko.computed(function() {

		var
			aList = [Cache.getFolderInboxName()],
			aFolders = this.folderList(),
			sSentFolder = this.sentFolder(),
			sDraftFolder = this.draftFolder(),
			sSpamFolder = this.spamFolder(),
			sTrashFolder = this.trashFolder(),
			sArchiveFolder = this.archiveFolder();

		if (Utils.isArray(aFolders) && 0 < aFolders.length)
		{
			if ('' !== sSentFolder && Consts.UNUSED_OPTION_VALUE !== sSentFolder)
			{
				aList.push(sSentFolder);
			}
			if ('' !== sDraftFolder && Consts.UNUSED_OPTION_VALUE !== sDraftFolder)
			{
				aList.push(sDraftFolder);
			}
			if ('' !== sSpamFolder && Consts.UNUSED_OPTION_VALUE !== sSpamFolder)
			{
				aList.push(sSpamFolder);
			}
			if ('' !== sTrashFolder && Consts.UNUSED_OPTION_VALUE !== sTrashFolder)
			{
				aList.push(sTrashFolder);
			}
			if ('' !== sArchiveFolder && Consts.UNUSED_OPTION_VALUE !== sArchiveFolder)
			{
				aList.push(sArchiveFolder);
			}
		}

		return aList;

	}, this);

	this.folderListSystem = ko.computed(function() {
		return _.compact(_.map(this.folderListSystemNames(), function(sName) {
			return Cache.getFolderFromCacheList(sName);
		}));
	}, this);

	this.folderMenuForMove = ko.computed(function() {
		return Utils.folderListOptionsBuilder(this.folderListSystem(), this.folderList(), [
			this.currentFolderFullNameRaw()
		], null, null, null, null, function(oItem) {
			return oItem ? oItem.localName() : '';
		});
	}, this);

	this.folderMenuForFilters = ko.computed(function() {
		return Utils.folderListOptionsBuilder(this.folderListSystem(), this.folderList(),
			['INBOX'], [['', '']], null, null, null, function(oItem) {
				return oItem ? oItem.localName() : '';
			}
		);
	}, this);
};

FolderUserStore.prototype.subscribers = function()
{
	var
		fRemoveSystemFolderType = function(observable) {
			return function() {
				var oFolder = Cache.getFolderFromCacheList(observable());
				if (oFolder)
				{
					oFolder.type(Enums.FolderType.User);
				}
			};
		},
		fSetSystemFolderType = function(iType) {
			return function(sValue) {
				var oFolder = Cache.getFolderFromCacheList(sValue);
				if (oFolder)
				{
					oFolder.type(iType);
				}
			};
		};

	this.sentFolder.subscribe(fRemoveSystemFolderType(this.sentFolder), this, 'beforeChange');
	this.draftFolder.subscribe(fRemoveSystemFolderType(this.draftFolder), this, 'beforeChange');
	this.spamFolder.subscribe(fRemoveSystemFolderType(this.spamFolder), this, 'beforeChange');
	this.trashFolder.subscribe(fRemoveSystemFolderType(this.trashFolder), this, 'beforeChange');
	this.archiveFolder.subscribe(fRemoveSystemFolderType(this.archiveFolder), this, 'beforeChange');

	this.sentFolder.subscribe(fSetSystemFolderType(Enums.FolderType.SentItems), this);
	this.draftFolder.subscribe(fSetSystemFolderType(Enums.FolderType.Draft), this);
	this.spamFolder.subscribe(fSetSystemFolderType(Enums.FolderType.Spam), this);
	this.trashFolder.subscribe(fSetSystemFolderType(Enums.FolderType.Trash), this);
	this.archiveFolder.subscribe(fSetSystemFolderType(Enums.FolderType.Archive), this);
};

/**
 * @returns {Array}
 */
FolderUserStore.prototype.getNextFolderNames = function()
{
	var
		aResult = [],
		iLimit = 5,
		iUtc = __webpack_require__(/*! Common/Momentor */ 26).momentNowUnix(),
		iTimeout = iUtc - 60 * 5,
		aTimeouts = [],
		sInboxFolderName = Cache.getFolderInboxName(),
		fSearchFunction = function(aList) {
			_.each(aList, function(oFolder) {
				if (oFolder && sInboxFolderName !== oFolder.fullNameRaw &&
					oFolder.selectable && oFolder.existen &&
					iTimeout > oFolder.interval &&
					(oFolder.isSystemFolder() || (oFolder.subScribed() && oFolder.checkable()))
				)
				{
					aTimeouts.push([oFolder.interval, oFolder.fullNameRaw]);
				}

				if (oFolder && 0 < oFolder.subFolders().length)
				{
					fSearchFunction(oFolder.subFolders());
				}
			});
		};

	fSearchFunction(this.folderList());

	aTimeouts.sort(function(a, b) {
		if (a[0] < b[0])
		{
			return -1;
		}
		else if (a[0] > b[0])
		{
			return 1;
		}

		return 0;
	});

	_.find(aTimeouts, function(aItem) {
		var oFolder = Cache.getFolderFromCacheList(aItem[1]);
		if (oFolder)
		{
			oFolder.interval = iUtc;
			aResult.push(aItem[1]);
		}

		return iLimit <= aResult.length;
	});

	aResult = _.uniq(aResult);

	return aResult;
};

module.exports = new FolderUserStore();


/***/ },
/* 21 */
/*!********************************!*\
  !*** ./dev/Common/Plugins.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony export */ exports["addHook"] = addHook;/* harmony export */ exports["runHook"] = runHook;/* harmony export */ exports["mainSettingsGet"] = mainSettingsGet;/* harmony export */ exports["remoteRequest"] = remoteRequest;/* harmony export */ exports["addSettingsViewModel"] = addSettingsViewModel;/* harmony export */ exports["addSettingsViewModelForAdmin"] = addSettingsViewModelForAdmin;/* harmony export */ exports["runSettingsViewModelHooks"] = runSettingsViewModelHooks;/* harmony export */ exports["settingsGet"] = settingsGet;





var SIMPLE_HOOKS = {},
    USER_VIEW_MODELS_HOOKS = [],
    ADMIN_VIEW_MODELS_HOOKS = [];

/**
 * @param {string} name
 * @param {Function} callback
 */
function addHook(name, callback) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isFunc"])(callback)) {
		if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
			SIMPLE_HOOKS[name] = [];
		}

		SIMPLE_HOOKS[name].push(callback);
	}
}

/**
 * @param {string} name
 * @param {Array=} args = []
 */
function runHook(name) {
	var args = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SIMPLE_HOOKS[name], function (callback) {
			callback.apply(undefined, args);
		});
	}
}

/**
 * @param {string} name
 * @returns {?}
 */
function mainSettingsGet(name) {
	return __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"](name);
}

/**
 * @param {Function} callback
 * @param {string} action
 * @param {Object=} parameters
 * @param {?number=} timeout
 */
function remoteRequest(callback, action, parameters, timeout) {
	if (__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__) {
		__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__.remote().defaultRequest(callback, 'Plugin' + action, parameters, timeout);
	}
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	USER_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModelForAdmin(SettingsViewModelClass, template, labelName, route) {
	ADMIN_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {boolean} admin
 */
function runSettingsViewModelHooks(admin) {
	var Knoin = __webpack_require__(/*! Knoin/Knoin */ 4);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(admin ? ADMIN_VIEW_MODELS_HOOKS : USER_VIEW_MODELS_HOOKS, function (view) {
		Knoin.addSettingsViewModel(view[0], view[1], view[2], view[3]);
	});
}

/**
 * @param {string} pluginSection
 * @param {string} name
 * @returns {?}
 */
function settingsGet(pluginSection, name) {
	var plugins = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Plugins');
	plugins = plugins && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[pluginSection]) ? plugins[pluginSection] : null;
	return plugins ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[name]) ? null : plugins[name] : null;
}

/***/ },
/* 22 */
/*!*********************************!*\
  !*** ./dev/Stores/User/App.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Stores_AbstractApp__ = __webpack_require__(/*! Stores/AbstractApp */ 81);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }









var AppUserStore = function (_AbstractAppStore) {
	_inherits(AppUserStore, _AbstractAppStore);

	function AppUserStore() {
		_classCallCheck(this, AppUserStore);

		var _this = _possibleConstructorReturn(this, _AbstractAppStore.call(this));

		_this.currentAudio = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.focusedState = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Focused"].None);

		_this.focusedState.subscribe(function (value) {

			switch (value) {
				case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Focused"].MessageList:
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["KeyState"].MessageList);
					break;
				case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Focused"].MessageView:
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["KeyState"].MessageView);
					break;
				case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["Focused"].FolderList:
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["keyScope"])(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["KeyState"].FolderList);
					break;
				default:
					break;
			}
		}, _this);

		_this.projectHash = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.threadsAllowed = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.composeInEdit = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.contactsAutosave = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.useLocalProxyForExternalImages = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.contactsIsAllowed = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.attachmentsActions = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observableArray([]);

		_this.devEmail = '';
		_this.devPassword = '';
		return _this;
	}

	AppUserStore.prototype.populate = function populate() {

		_AbstractAppStore.prototype.populate.call(this);

		this.projectHash(__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ProjectHash'));

		this.contactsAutosave(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsAutosave'));
		this.useLocalProxyForExternalImages(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('UseLocalProxyForExternalImages'));

		this.contactsIsAllowed(!!__WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('ContactsIsAllowed'));

		var attachmentsActions = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["appSettingsGet"]('attachmentsActions');
		this.attachmentsActions(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isNonEmptyArray"])(attachmentsActions) ? attachmentsActions : []);

		this.devEmail = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('DevEmail');
		this.devPassword = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('DevPassword');
	};

	return AppUserStore;
}(__WEBPACK_IMPORTED_MODULE_5_Stores_AbstractApp__["a" /* AbstractAppStore */]);

module.exports = new AppUserStore();

/***/ },
/* 23 */
/*!*******************************!*\
  !*** ./dev/Common/Events.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony export */ exports["sub"] = sub;/* harmony export */ exports["pub"] = pub;




var SUBS = {};

/**
 * @param {string|Object} name
 * @param {Function} func
 * @param {Object=} context
 */
function sub(name, func, context) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isObject"])(name)) {
		context = func || null;
		func = null;

		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(name, function (subFunc, subName) {
			sub(subName, subFunc, context);
		});
	} else {
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
			SUBS[name] = [];
		}

		SUBS[name].push([func, context]);
	}
}

/**
 * @param {string} name
 * @param {Array=} args
 */
function pub(name, args) {
	__WEBPACK_IMPORTED_MODULE_2_Common_Plugins__["runHook"]('rl-pub', [name, args]);

	if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SUBS[name], function (items) {
			if (items[0]) {
				items[0].apply(items[1] || null, args || []);
			}
		});
	}
}

/***/ },
/* 24 */
/*!*************************************!*\
  !*** ./dev/Stores/User/Settings.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	ko = __webpack_require__(/*! ko */ 1),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Events = __webpack_require__(/*! Common/Events */ 23),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function SettingsUserStore()
{
	this.iAutoLogoutTimer = 0;

	this.layout = ko.observable(Enums.Layout.SidePreview)
		.extend({'limitedList': [
			Enums.Layout.SidePreview, Enums.Layout.BottomPreview, Enums.Layout.NoPreview
		]});

	this.editorDefaultType = ko.observable(Enums.EditorDefaultType.Html)
		.extend({'limitedList': [
			Enums.EditorDefaultType.Html, Enums.EditorDefaultType.Plain,
			Enums.EditorDefaultType.HtmlForced, Enums.EditorDefaultType.PlainForced
		]});

	this.messagesPerPage = ko.observable(Consts.MESSAGES_PER_PAGE)
		.extend({'limitedList': Consts.MESSAGES_PER_PAGE_VALUES});

	this.showImages = ko.observable(false);
	this.useCheckboxesInList = ko.observable(true);
	this.useThreads = ko.observable(false);
	this.replySameFolder = ko.observable(false);

	this.autoLogout = ko.observable(30);

	this.computers();
	this.subscribers();
}

SettingsUserStore.prototype.computers = function()
{
	this.usePreviewPane = ko.computed(function() {
		return Enums.Layout.NoPreview !== this.layout();
	}, this);
};

SettingsUserStore.prototype.subscribers = function()
{
	this.layout.subscribe(function(nValue) {

		Globals.$html.toggleClass('rl-no-preview-pane', Enums.Layout.NoPreview === nValue);
		Globals.$html.toggleClass('rl-side-preview-pane', Enums.Layout.SidePreview === nValue);
		Globals.$html.toggleClass('rl-bottom-preview-pane', Enums.Layout.BottomPreview === nValue);

		Events.pub('layout', [nValue]);
	});
};

SettingsUserStore.prototype.populate = function()
{
	this.layout(Utils.pInt(Settings.settingsGet('Layout')));
	this.editorDefaultType(Settings.settingsGet('EditorDefaultType'));

	this.autoLogout(Utils.pInt(Settings.settingsGet('AutoLogout')));
	this.messagesPerPage(Settings.settingsGet('MPP'));

	this.showImages(!!Settings.settingsGet('ShowImages'));
	this.useCheckboxesInList(!!Settings.settingsGet('UseCheckboxesInList'));
	this.useThreads(!!Settings.settingsGet('UseThreads'));
	this.replySameFolder(!!Settings.settingsGet('ReplySameFolder'));

	var self = this;

	Events.sub('rl.auto-logout-refresh', function() {
		window.clearTimeout(self.iAutoLogoutTimer);
		if (0 < self.autoLogout() && !Settings.settingsGet('AccountSignMe'))
		{
			self.iAutoLogoutTimer = window.setTimeout(function() {
				Events.pub('rl.auto-logout');
			}, self.autoLogout() * Enums.Magics.Time1m);
		}
	});

	Events.pub('rl.auto-logout-refresh');
};

module.exports = new SettingsUserStore();


/***/ },
/* 25 */
/*!***********************************!*\
  !*** ./dev/View/Popup/Compose.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	JSON = __webpack_require__(/*! JSON */ 33),
	Jua = __webpack_require__(/*! Jua */ 86),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Events = __webpack_require__(/*! Common/Events */ 23),
	Links = __webpack_require__(/*! Common/Links */ 12),
	HtmlEditor = __webpack_require__(/*! Common/HtmlEditor */ 45),

	Translator = __webpack_require__(/*! Common/Translator */ 6),
	Momentor = __webpack_require__(/*! Common/Momentor */ 26),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	IdentityStore = __webpack_require__(/*! Stores/User/Identity */ 56),
	AccountStore = __webpack_require__(/*! Stores/User/Account */ 28),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),
	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),
	SocialStore = __webpack_require__(/*! Stores/Social */ 34),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	ComposeAttachmentModel = __webpack_require__(/*! Model/ComposeAttachment */ 163).default,

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function ComposePopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsCompose');

	var
		self = this,
		fEmailOutInHelper = function(context, oIdentity, sName, bIn) {
			if (oIdentity && context && oIdentity[sName]() && (bIn ? true : context[sName]()))
			{
				var
					sIdentityEmail = oIdentity[sName](),
					aList = Utils.trim(context[sName]()).split(/[,]/);

				aList = _.filter(aList, function(sEmail) {
					sEmail = Utils.trim(sEmail);
					return sEmail && Utils.trim(sIdentityEmail) !== sEmail;
				});

				if (bIn)
				{
					aList.push(sIdentityEmail);
				}

				context[sName](aList.join(','));
			}
		};

	this.oLastMessage = null;
	this.oEditor = null;
	this.aDraftInfo = null;
	this.sInReplyTo = '';
	this.bFromDraft = false;
	this.sReferences = '';

	this.sLastFocusedField = 'to';

	this.resizerTrigger = _.bind(this.resizerTrigger, this);

	this.allowContacts = !!AppStore.contactsIsAllowed();
	this.allowFolders = !!Settings.capa(Enums.Capa.Folders);

	this.bSkipNextHide = false;
	this.composeInEdit = AppStore.composeInEdit;
	this.editorDefaultType = SettingsStore.editorDefaultType;

	this.capaOpenPGP = PgpStore.capaOpenPGP;

	this.identitiesDropdownTrigger = ko.observable(false);

	this.to = ko.observable('');
	this.to.focused = ko.observable(false);
	this.cc = ko.observable('');
	this.cc.focused = ko.observable(false);
	this.bcc = ko.observable('');
	this.bcc.focused = ko.observable(false);
	this.replyTo = ko.observable('');
	this.replyTo.focused = ko.observable(false);

	ko.computed(function() {
		switch (true)
		{
			case this.to.focused():
				this.sLastFocusedField = 'to';
				break;
			case this.cc.focused():
				this.sLastFocusedField = 'cc';
				break;
			case this.bcc.focused():
				this.sLastFocusedField = 'bcc';
				break;
			// no default
		}
	}, this).extend({'notify': 'always'});

	this.subject = ko.observable('');
	this.subject.focused = ko.observable(false);

	this.isHtml = ko.observable(false);

	this.requestDsn = ko.observable(false);
	this.requestReadReceipt = ko.observable(false);
	this.markAsImportant = ko.observable(false);

	this.sendError = ko.observable(false);
	this.sendSuccessButSaveError = ko.observable(false);
	this.savedError = ko.observable(false);

	this.sendButtonSuccess = ko.computed(function() {
		return !this.sendError() && !this.sendSuccessButSaveError();
	}, this);

	this.sendErrorDesc = ko.observable('');
	this.savedErrorDesc = ko.observable('');

	this.sendError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.sendErrorDesc('');
		}
	}, this);

	this.savedError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.savedErrorDesc('');
		}
	}, this);

	this.sendSuccessButSaveError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.savedErrorDesc('');
		}
	}, this);

	this.savedTime = ko.observable(0);
	this.savedTimeText = ko.computed(function() {
		return 0 < this.savedTime() ? Translator.i18n('COMPOSE/SAVED_TIME', {
			'TIME': Momentor.format(this.savedTime() - 1, 'LT')
		}) : '';
	}, this);

	this.emptyToError = ko.observable(false);
	this.emptyToErrorTooltip = ko.computed(function() {
		return this.emptyToError() ? Translator.i18n('COMPOSE/EMPTY_TO_ERROR_DESC') : '';
	}, this);

	this.attachmentsInProcessError = ko.observable(false);
	this.attachmentsInErrorError = ko.observable(false);

	this.attachmentsErrorTooltip = ko.computed(function() {

		var sResult = '';
		switch (true)
		{
			case this.attachmentsInProcessError():
				sResult = Translator.i18n('COMPOSE/ATTACHMENTS_UPLOAD_ERROR_DESC');
				break;
			case this.attachmentsInErrorError():
				sResult = Translator.i18n('COMPOSE/ATTACHMENTS_ERROR_DESC');
				break;
			// no default
		}

		return sResult;

	}, this);

	this.showCc = ko.observable(false);
	this.showBcc = ko.observable(false);
	this.showReplyTo = ko.observable(false);

	this.cc.subscribe(function(aValue) {
		if (false === self.showCc() && 0 < aValue.length)
		{
			self.showCc(true);
		}
	}, this);

	this.bcc.subscribe(function(aValue) {
		if (false === self.showBcc() && 0 < aValue.length)
		{
			self.showBcc(true);
		}
	}, this);

	this.replyTo.subscribe(function(aValue) {
		if (false === self.showReplyTo() && 0 < aValue.length)
		{
			self.showReplyTo(true);
		}
	}, this);

	this.draftFolder = ko.observable('');
	this.draftUid = ko.observable('');
	this.sending = ko.observable(false);
	this.saving = ko.observable(false);
	this.attachments = ko.observableArray([]);

	this.attachmentsInProcess = this.attachments.filter(function(oItem) {
		return oItem && !oItem.complete();
	});

	this.attachmentsInReady = this.attachments.filter(function(oItem) {
		return oItem && oItem.complete();
	});

	this.attachmentsInError = this.attachments.filter(function(oItem) {
		return oItem && '' !== oItem.error();
	});

	this.attachmentsCount = ko.computed(function() {
		return this.attachments().length;
	}, this);

	this.attachmentsInErrorCount = ko.computed(function() {
		return this.attachmentsInError().length;
	}, this);

	this.attachmentsInProcessCount = ko.computed(function() {
		return this.attachmentsInProcess().length;
	}, this);

	this.isDraftFolderMessage = ko.computed(function() {
		return '' !== this.draftFolder() && '' !== this.draftUid();
	}, this);

	this.attachmentsPlace = ko.observable(false);

	this.attachments.subscribe(this.resizerTrigger);
	this.attachmentsPlace.subscribe(this.resizerTrigger);

	this.attachmentsInErrorCount.subscribe(function(iN) {
		if (0 === iN)
		{
			this.attachmentsInErrorError(false);
		}
	}, this);

	this.composeUploaderButton = ko.observable(null);
	this.composeUploaderDropPlace = ko.observable(null);
	this.dragAndDropEnabled = ko.observable(false);
	this.dragAndDropOver = ko.observable(false).extend({'throttle': 1});
	this.dragAndDropVisible = ko.observable(false).extend({'throttle': 1});
	this.attacheMultipleAllowed = ko.observable(false);
	this.addAttachmentEnabled = ko.observable(false);

	this.composeEditorArea = ko.observable(null);

	this.identities = IdentityStore.identities;
	this.identitiesOptions = ko.computed(function() {
		return _.map(IdentityStore.identities(), function(oItem) {
			return {
				'item': oItem,
				'optValue': oItem.id(),
				'optText': oItem.formattedName()
			};
		});
	}, this);

	this.currentIdentity = ko.observable(
		this.identities()[0] ? this.identities()[0] : null);

	this.currentIdentity.extend({'toggleSubscribe': [this,
		function(oIdentity) {
			fEmailOutInHelper(this, oIdentity, 'bcc');
			fEmailOutInHelper(this, oIdentity, 'replyTo');
		}, function(oIdentity) {
			fEmailOutInHelper(this, oIdentity, 'bcc', true);
			fEmailOutInHelper(this, oIdentity, 'replyTo', true);
		}
	]});

	this.currentIdentityView = ko.computed(function() {
		var oItem = this.currentIdentity();
		return oItem ? oItem.formattedName() : 'unknown';
	}, this);

	this.to.subscribe(function(sValue) {
		if (this.emptyToError() && 0 < sValue.length)
		{
			this.emptyToError(false);
		}
	}, this);

	this.attachmentsInProcess.subscribe(function(aValue) {
		if (this.attachmentsInProcessError() && Utils.isArray(aValue) && 0 === aValue.length)
		{
			this.attachmentsInProcessError(false);
		}
	}, this);

	this.resizer = ko.observable(false).extend({'throttle': 50});

	this.resizer.subscribe(_.bind(function() {
		if (this.oEditor) {
			this.oEditor.resize();
		}
	}, this));

	this.canBeSentOrSaved = ko.computed(function() {
		return !this.sending() && !this.saving();
	}, this);

	this.deleteCommand = Utils.createCommand(this, function() {

		var
			PopupsAskViewModel = __webpack_require__(/*! View/Popup/Ask */ 39);

		if (!kn.isPopupVisible(PopupsAskViewModel) && this.modalVisibility())
		{
			kn.showScreenPopup(PopupsAskViewModel, [Translator.i18n('POPUPS_ASK/DESC_WANT_DELETE_MESSAGES'), function() {
				if (self.modalVisibility())
				{
					__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolderWithoutCheck(self.draftFolder(), [self.draftUid()]);
					kn.hideScreenPopup(ComposePopupView);
				}
			}]);
		}

	}, function() {
		return this.isDraftFolderMessage();
	});

	this.sendMessageResponse = _.bind(this.sendMessageResponse, this);
	this.saveMessageResponse = _.bind(this.saveMessageResponse, this);

	this.sendCommand = Utils.createCommand(this, function() {

		var
			sTo = Utils.trim(this.to()),
			sCc = Utils.trim(this.cc()),
			sBcc = Utils.trim(this.bcc()),
			sSentFolder = FolderStore.sentFolder(),
			aFlagsCache = [];

		this.attachmentsInProcessError(false);
		this.attachmentsInErrorError(false);
		this.emptyToError(false);

		if (0 < this.attachmentsInProcess().length)
		{
			this.attachmentsInProcessError(true);
			this.attachmentsPlace(true);
		}
		else if (0 < this.attachmentsInError().length)
		{
			this.attachmentsInErrorError(true);
			this.attachmentsPlace(true);
		}

		if ('' === sTo && '' === sCc && '' === sBcc)
		{
			this.emptyToError(true);
		}

		if (!this.emptyToError() && !this.attachmentsInErrorError() && !this.attachmentsInProcessError())
		{
			if (SettingsStore.replySameFolder())
			{
				if (Utils.isArray(this.aDraftInfo) && 3 === this.aDraftInfo.length && Utils.isNormal(this.aDraftInfo[2]) && 0 < this.aDraftInfo[2].length)
				{
					sSentFolder = this.aDraftInfo[2];
				}
			}

			if (!this.allowFolders)
			{
				sSentFolder = Consts.UNUSED_OPTION_VALUE;
			}

			if ('' === sSentFolder)
			{
				kn.showScreenPopup(__webpack_require__(/*! View/Popup/FolderSystem */ 54), [Enums.SetSystemFoldersNotification.Sent]);
			}
			else
			{
				this.sendError(false);
				this.sending(true);

				if (Utils.isArray(this.aDraftInfo) && 3 === this.aDraftInfo.length)
				{
					aFlagsCache = Cache.getMessageFlagsFromCache(this.aDraftInfo[2], this.aDraftInfo[1]);
					if (aFlagsCache)
					{
						if ('forward' === this.aDraftInfo[0])
						{
							aFlagsCache[3] = true;
						}
						else
						{
							aFlagsCache[2] = true;
						}

						Cache.setMessageFlagsToCache(this.aDraftInfo[2], this.aDraftInfo[1], aFlagsCache);
						__webpack_require__(/*! App/User */ 8).default.reloadFlagsCurrentMessageListAndMessageFromCache();
						Cache.setFolderHash(this.aDraftInfo[2], '');
					}
				}

				sSentFolder = Consts.UNUSED_OPTION_VALUE === sSentFolder ? '' : sSentFolder;

				Cache.setFolderHash(this.draftFolder(), '');
				Cache.setFolderHash(sSentFolder, '');

				Remote.sendMessage(
					this.sendMessageResponse,
					this.currentIdentity() ? this.currentIdentity().id() : '',
					this.draftFolder(),
					this.draftUid(),
					sSentFolder,
					sTo,
					this.cc(),
					this.bcc(),
					this.replyTo(),
					this.subject(),
					this.oEditor ? this.oEditor.isHtml() : false,
					this.oEditor ? this.oEditor.getData(true, true) : '',
					this.prepearAttachmentsForSendOrSave(),
					this.aDraftInfo,
					this.sInReplyTo,
					this.sReferences,
					this.requestDsn(),
					this.requestReadReceipt(),
					this.markAsImportant()
				);
			}
		}

	}, this.canBeSentOrSaved);

	this.saveCommand = Utils.createCommand(this, function() {

		if (!this.allowFolders)
		{
			return false;
		}

		if (FolderStore.draftFolderNotEnabled())
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/FolderSystem */ 54), [Enums.SetSystemFoldersNotification.Draft]);
		}
		else
		{
			this.savedError(false);
			this.saving(true);

			this.autosaveStart();

			Cache.setFolderHash(FolderStore.draftFolder(), '');

			Remote.saveMessage(
				this.saveMessageResponse,
				this.currentIdentity() ? this.currentIdentity().id() : '',
				this.draftFolder(),
				this.draftUid(),
				FolderStore.draftFolder(),
				this.to(),
				this.cc(),
				this.bcc(),
				this.replyTo(),
				this.subject(),
				this.oEditor ? this.oEditor.isHtml() : false,
				this.oEditor ? this.oEditor.getData(true) : '',
				this.prepearAttachmentsForSendOrSave(),
				this.aDraftInfo,
				this.sInReplyTo,
				this.sReferences,
				this.markAsImportant()
			);
		}

		return true;

	}, this.canBeSentOrSaved);

	this.skipCommand = Utils.createCommand(this, function() {

		this.bSkipNextHide = true;

		if (this.modalVisibility() && !this.saving() && !this.sending() &&
			!FolderStore.draftFolderNotEnabled())
		{
			this.saveCommand();
		}

		this.tryToClosePopup();

	}, this.canBeSentOrSaved);

	this.contactsCommand = Utils.createCommand(this, function() {

		if (this.allowContacts)
		{
			this.skipCommand();
			_.delay(function() {
				kn.showScreenPopup(__webpack_require__(/*! View/Popup/Contacts */ 64),
					[true, self.sLastFocusedField]);
			}, Enums.Magics.Time200ms);
		}

	}, function() {
		return this.allowContacts;
	});

	Events.sub('interval.2m', function() {

		if (this.modalVisibility() && !FolderStore.draftFolderNotEnabled() && !this.isEmptyForm(false) &&
			!this.saving() && !this.sending() && !this.savedError())
		{
			this.saveCommand();
		}
	}, this);

	this.showCc.subscribe(this.resizerTrigger);
	this.showBcc.subscribe(this.resizerTrigger);
	this.showReplyTo.subscribe(this.resizerTrigger);

	this.dropboxEnabled = SocialStore.dropbox.enabled;
	this.dropboxApiKey = SocialStore.dropbox.apiKey;

	this.dropboxCommand = Utils.createCommand(this, function() {

		if (window.Dropbox)
		{
			window.Dropbox.choose({
				'success': function(files) {
					if (files && files[0] && files[0].link)
					{
						self.addDropboxAttachment(files[0]);
					}
				},
				'linkType': 'direct',
				'multiselect': false
			});
		}

		return true;

	}, function() {
		return this.dropboxEnabled();
	});

	this.driveEnabled = ko.observable(Globals.bXMLHttpRequestSupported &&
		!!Settings.settingsGet('AllowGoogleSocial') && !!Settings.settingsGet('AllowGoogleSocialDrive') &&
		!!Settings.settingsGet('GoogleClientID') && !!Settings.settingsGet('GoogleApiKey'));

	this.driveVisible = ko.observable(false);

	this.driveCommand = Utils.createCommand(this, function() {

		this.driveOpenPopup();
		return true;

	}, function() {
		return this.driveEnabled();
	});

	this.driveCallback = _.bind(this.driveCallback, this);

	this.onMessageUploadAttachments = _.bind(this.onMessageUploadAttachments, this);

	this.bDisabeCloseOnEsc = true;
	this.sDefaultKeyScope = Enums.KeyState.Compose;

	this.tryToClosePopup = _.debounce(_.bind(this.tryToClosePopup, this), Enums.Magics.Time200ms);

	this.emailsSource = _.bind(this.emailsSource, this);
	this.autosaveFunction = _.bind(this.autosaveFunction, this);

	this.iTimer = 0;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Compose', 'PopupsComposeViewModel'], ComposePopupView);
_.extend(ComposePopupView.prototype, AbstractView.prototype);

ComposePopupView.prototype.autosaveFunction = function()
{
	if (this.modalVisibility() && !FolderStore.draftFolderNotEnabled() && !this.isEmptyForm(false) &&
		!this.saving() && !this.sending() && !this.savedError())
	{
		this.saveCommand();
	}

	this.autosaveStart();
};

ComposePopupView.prototype.autosaveStart = function()
{
	window.clearTimeout(this.iTimer);
	this.iTimer = window.setTimeout(this.autosaveFunction, Enums.Magics.Time1m);
};

ComposePopupView.prototype.autosaveStop = function()
{
	window.clearTimeout(this.iTimer);
};

ComposePopupView.prototype.emailsSource = function(oData, fResponse)
{
	__webpack_require__(/*! App/User */ 8).default.getAutocomplete(oData.term, function(aData) {
		fResponse(_.map(aData, function(oEmailItem) {
			return oEmailItem.toLine(false);
		}));
	});
};

ComposePopupView.prototype.openOpenPgpPopup = function()
{
	if (PgpStore.capaOpenPGP() && this.oEditor && !this.oEditor.isHtml())
	{
		var self = this;
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/ComposeOpenPgp */ 142), [
			function(sResult) {
				self.editor(function(oEditor) {
					oEditor.setPlain(sResult);
				});
			},
			this.oEditor.getData(false, true),
			this.currentIdentity(),
			this.to(),
			this.cc(),
			this.bcc()
		]);
	}
};

ComposePopupView.prototype.reloadDraftFolder = function()
{
	var
		sDraftFolder = FolderStore.draftFolder();

	if ('' !== sDraftFolder && Consts.UNUSED_OPTION_VALUE !== sDraftFolder)
	{
		Cache.setFolderHash(sDraftFolder, '');
		if (FolderStore.currentFolderFullNameRaw() === sDraftFolder)
		{
			__webpack_require__(/*! App/User */ 8).default.reloadMessageList(true);
		}
		else
		{
			__webpack_require__(/*! App/User */ 8).default.folderInformation(sDraftFolder);
		}
	}
};

ComposePopupView.prototype.findIdentityByMessage = function(sComposeType, oMessage)
{
	var
		aIdentities = IdentityStore.identities(),
		iResultIndex = 1000,
		oResultIdentity = null,
		oIdentitiesCache = {},

		fEachHelper = function(oItem) {

			if (oItem && oItem.email && oIdentitiesCache[oItem.email])
			{
				if (!oResultIdentity || iResultIndex > oIdentitiesCache[oItem.email][1])
				{
					oResultIdentity = oIdentitiesCache[oItem.email][0];
					iResultIndex = oIdentitiesCache[oItem.email][1];
				}
			}
		};

	_.each(aIdentities, function(oItem, iIndex) {
		oIdentitiesCache[oItem.email()] = [oItem, iIndex];
	});

	if (oMessage)
	{
		switch (sComposeType)
		{
			case Enums.ComposeType.Empty:
				break;
			case Enums.ComposeType.Reply:
			case Enums.ComposeType.ReplyAll:
			case Enums.ComposeType.Forward:
			case Enums.ComposeType.ForwardAsAttachment:
				_.each(_.union(oMessage.to, oMessage.cc, oMessage.bcc), fEachHelper);
				if (!oResultIdentity) {
					_.each(oMessage.deliveredTo, fEachHelper);
				}
				break;
			case Enums.ComposeType.Draft:
				_.each(_.union(oMessage.from, oMessage.replyTo), fEachHelper);
				break;
			// no default
		}
	}

	return oResultIdentity || aIdentities[0] || null;
};

ComposePopupView.prototype.selectIdentity = function(oIdentity)
{
	if (oIdentity && oIdentity.item)
	{
		this.currentIdentity(oIdentity.item);
		this.setSignatureFromIdentity(oIdentity.item);
	}
};

ComposePopupView.prototype.sendMessageResponse = function(sResult, oData)
{
	var
		bResult = false,
		sMessage = '';

	this.sending(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		bResult = true;
		if (this.modalVisibility())
		{
			Utils.delegateRun(this, 'closeCommand');
		}
	}

	if (this.modalVisibility() && !bResult)
	{
		if (oData && Enums.Notification.CantSaveMessage === oData.ErrorCode)
		{
			this.sendSuccessButSaveError(true);
			this.savedErrorDesc(Utils.trim(Translator.i18n('COMPOSE/SAVED_ERROR_ON_SEND')));
		}
		else
		{
			sMessage = Translator.getNotification(oData && oData.ErrorCode ? oData.ErrorCode : Enums.Notification.CantSendMessage,
				oData && oData.ErrorMessage ? oData.ErrorMessage : '');

			this.sendError(true);
			this.sendErrorDesc(sMessage || Translator.getNotification(Enums.Notification.CantSendMessage));
		}
	}

	this.reloadDraftFolder();
};

ComposePopupView.prototype.saveMessageResponse = function(sResult, oData)
{
	var
		bResult = false,
		oMessage = null;

	this.saving(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		if (oData.Result.NewFolder && oData.Result.NewUid)
		{
			bResult = true;

			if (this.bFromDraft)
			{
				oMessage = MessageStore.message();
				if (oMessage && this.draftFolder() === oMessage.folderFullNameRaw && this.draftUid() === oMessage.uid)
				{
					MessageStore.message(null);
				}
			}

			this.draftFolder(oData.Result.NewFolder);
			this.draftUid(oData.Result.NewUid);

			this.savedTime(window.Math.round((new window.Date()).getTime() / 1000));

			if (this.bFromDraft)
			{
				Cache.setFolderHash(this.draftFolder(), '');
			}
		}
	}

	if (!bResult)
	{
		this.savedError(true);
		this.savedErrorDesc(Translator.getNotification(Enums.Notification.CantSaveMessage));
	}

	this.reloadDraftFolder();
};

ComposePopupView.prototype.onHide = function()
{
	this.autosaveStop();

	if (!this.bSkipNextHide)
	{
		AppStore.composeInEdit(false);
		this.reset();
	}

	this.bSkipNextHide = false;

	this.to.focused(false);

	kn.routeOn();
};

ComposePopupView.prototype.editor = function(fOnInit)
{
	if (fOnInit)
	{
		var self = this;
		if (!this.oEditor && this.composeEditorArea())
		{
// _.delay(function() {
			self.oEditor = new HtmlEditor(self.composeEditorArea(), null, function() {
				fOnInit(self.oEditor);
				self.resizerTrigger();
			}, function(bHtml) {
				self.isHtml(!!bHtml);
			});
// }, 1000);
		}
		else if (this.oEditor)
		{
			fOnInit(this.oEditor);
			this.resizerTrigger();
		}
	}
};

ComposePopupView.prototype.converSignature = function(sSignature)
{
	var
		iLimit = 10,
		oMatch = null,
		aMoments = [],
		oMomentRegx = /{{MOMENT:([^}]+)}}/g,
		sFrom = '';

	sSignature = sSignature.replace(/[\r]/g, '');

	sFrom = this.oLastMessage ? this.emailArrayToStringLineHelper(this.oLastMessage.from, true) : '';
	if ('' !== sFrom)
	{
		sSignature = sSignature.replace(/{{FROM-FULL}}/g, sFrom);

		if (-1 === sFrom.indexOf(' ') && 0 < sFrom.indexOf('@'))
		{
			sFrom = sFrom.replace(/@[\S]+/, '');
		}

		sSignature = sSignature.replace(/{{FROM}}/g, sFrom);
	}

	sSignature = sSignature.replace(/[\s]{1,2}{{FROM}}/g, '{{FROM}}');
	sSignature = sSignature.replace(/[\s]{1,2}{{FROM-FULL}}/g, '{{FROM-FULL}}');

	sSignature = sSignature.replace(/{{FROM}}/g, '');
	sSignature = sSignature.replace(/{{FROM-FULL}}/g, '');

	if (-1 < sSignature.indexOf('{{DATE}}'))
	{
		sSignature = sSignature.replace(/{{DATE}}/g, Momentor.format(0, 'llll'));
	}

	if (-1 < sSignature.indexOf('{{TIME}}'))
	{
		sSignature = sSignature.replace(/{{TIME}}/g, Momentor.format(0, 'LT'));
	}
	if (-1 < sSignature.indexOf('{{MOMENT:'))
	{
		try
		{
			while (null !== (oMatch = oMomentRegx.exec(sSignature))) // eslint-disable-line no-cond-assign
			{
				if (oMatch && oMatch[0] && oMatch[1])
				{
					aMoments.push([oMatch[0], oMatch[1]]);
				}

				iLimit -= 1;
				if (0 === iLimit)
				{
					break;
				}
			}

			if (aMoments && 0 < aMoments.length)
			{
				_.each(aMoments, function(aData) {
					sSignature = sSignature.replace(
						aData[0], Momentor.format(0, aData[1]));
				});
			}

			sSignature = sSignature.replace(/{{MOMENT:[^}]+}}/g, '');
		}
		catch (e) {} // eslint-disable-line no-empty
	}

	return sSignature;
};

ComposePopupView.prototype.setSignatureFromIdentity = function(oIdentity)
{
	if (oIdentity)
	{
		var self = this;
		this.editor(function(oEditor) {
			var bHtml = false, sSignature = oIdentity.signature();
			if ('' !== sSignature)
			{
				if (':HTML:' === sSignature.substr(0, 6))
				{
					bHtml = true;
					sSignature = sSignature.substr(6);
				}
			}

			oEditor.setSignature(self.converSignature(sSignature),
				bHtml, !!oIdentity.signatureInsertBefore());
		});
	}
};

/**
 * @param {string=} sType = Enums.ComposeType.Empty
 * @param {?MessageModel|Array=} oMessageOrArray = null
 * @param {Array=} aToEmails = null
 * @param {Array=} aCcEmails = null
 * @param {Array=} aBccEmails = null
 * @param {string=} sCustomSubject = null
 * @param {string=} sCustomPlainText = null
 */
ComposePopupView.prototype.onShow = function(sType, oMessageOrArray,
	aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText)
{
	kn.routeOff();

	this.autosaveStart();

	if (AppStore.composeInEdit())
	{
		sType = sType || Enums.ComposeType.Empty;

		var self = this;

		if (Enums.ComposeType.Empty !== sType)
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/Ask */ 39), [Translator.i18n('COMPOSE/DISCARD_UNSAVED_DATA'), function() {
				self.initOnShow(sType, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText);
			}, null, null, null, false]);
		}
		else
		{
			this.addEmailsTo(this.to, aToEmails);
			this.addEmailsTo(this.cc, aCcEmails);
			this.addEmailsTo(this.bcc, aBccEmails);

			if (Utils.isNormal(sCustomSubject) && '' !== sCustomSubject &&
				'' === this.subject())
			{
				this.subject(sCustomSubject);
			}
		}
	}
	else
	{
		this.initOnShow(sType, oMessageOrArray, aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText);
	}
};

/**
 * @param {Function} fKoValue
 * @param {Array} aEmails
 */
ComposePopupView.prototype.addEmailsTo = function(fKoValue, aEmails)
{
	var
		sValue = Utils.trim(fKoValue()),
		aValue = [];

	if (Utils.isNonEmptyArray(aEmails))
	{
		aValue = _.uniq(_.compact(_.map(aEmails, function(oItem) {
			return oItem ? oItem.toLine(false) : null;
		})));

		fKoValue(sValue + ('' === sValue ? '' : ', ') + Utils.trim(aValue.join(', ')));
	}
};

/**
 *
 * @param {Array} aList
 * @param {boolean} bFriendly
 * @returns {string}
 */
ComposePopupView.prototype.emailArrayToStringLineHelper = function(aList, bFriendly)
{
	var
		iIndex = 0,
		iLen = aList.length,
		aResult = [];

	for (; iIndex < iLen; iIndex++)
	{
		aResult.push(aList[iIndex].toLine(!!bFriendly));
	}

	return aResult.join(', ');
};

/**
 * @param {string=} sType = Enums.ComposeType.Empty
 * @param {?MessageModel|Array=} oMessageOrArray = null
 * @param {Array=} aToEmails = null
 * @param {Array=} aCcEmails = null
 * @param {Array=} aBccEmails = null
 * @param {string=} sCustomSubject = null
 * @param {string=} sCustomPlainText = null
 */
ComposePopupView.prototype.initOnShow = function(sType, oMessageOrArray,
	aToEmails, aCcEmails, aBccEmails, sCustomSubject, sCustomPlainText)
{
	AppStore.composeInEdit(true);

	var
		self = this,
		sFrom = '',
		sTo = '',
		sCc = '',
		sDate = '',
		sSubject = '',
		oText = null,
		sText = '',
		sReplyTitle = '',
		aResplyAllParts = [],
		oExcludeEmail = {},
		oIdentity = null,
		mEmail = AccountStore.email(),
		aDownloads = [],
		aDraftInfo = null,
		oMessage = null,
		sComposeType = sType || Enums.ComposeType.Empty;

	oMessageOrArray = oMessageOrArray || null;
	if (oMessageOrArray && Utils.isNormal(oMessageOrArray))
	{
		oMessage = Utils.isArray(oMessageOrArray) && 1 === oMessageOrArray.length ? oMessageOrArray[0] :
			(!Utils.isArray(oMessageOrArray) ? oMessageOrArray : null);
	}

	this.oLastMessage = oMessage;

	if (null !== mEmail)
	{
		oExcludeEmail[mEmail] = true;
	}

	this.reset();

	oIdentity = this.findIdentityByMessage(sComposeType, oMessage);
	if (oIdentity)
	{
		oExcludeEmail[oIdentity.email()] = true;
	}

	if (Utils.isNonEmptyArray(aToEmails))
	{
		this.to(this.emailArrayToStringLineHelper(aToEmails));
	}

	if (Utils.isNonEmptyArray(aCcEmails))
	{
		this.cc(this.emailArrayToStringLineHelper(aCcEmails));
	}

	if (Utils.isNonEmptyArray(aBccEmails))
	{
		this.bcc(this.emailArrayToStringLineHelper(aBccEmails));
	}

	if ('' !== sComposeType && oMessage)
	{
		sDate = Momentor.format(oMessage.dateTimeStampInUTC(), 'FULL');
		sSubject = oMessage.subject();
		aDraftInfo = oMessage.aDraftInfo;

		oText = $(oMessage.body).clone();
		if (oText)
		{
			Utils.clearBqSwitcher(oText);

			sText = oText.html();
		}

		switch (sComposeType)
		{
			case Enums.ComposeType.Empty:
				break;

			case Enums.ComposeType.Reply:
				this.to(this.emailArrayToStringLineHelper(oMessage.replyEmails(oExcludeEmail)));
				this.subject(Utils.replySubjectAdd('Re', sSubject));
				this.prepearMessageAttachments(oMessage, sComposeType);
				this.aDraftInfo = ['reply', oMessage.uid, oMessage.folderFullNameRaw];
				this.sInReplyTo = oMessage.sMessageId;
				this.sReferences = Utils.trim(this.sInReplyTo + ' ' + oMessage.sReferences);
				break;

			case Enums.ComposeType.ReplyAll:
				aResplyAllParts = oMessage.replyAllEmails(oExcludeEmail);
				this.to(this.emailArrayToStringLineHelper(aResplyAllParts[0]));
				this.cc(this.emailArrayToStringLineHelper(aResplyAllParts[1]));
				this.subject(Utils.replySubjectAdd('Re', sSubject));
				this.prepearMessageAttachments(oMessage, sComposeType);
				this.aDraftInfo = ['reply', oMessage.uid, oMessage.folderFullNameRaw];
				this.sInReplyTo = oMessage.sMessageId;
				this.sReferences = Utils.trim(this.sInReplyTo + ' ' + oMessage.references());
				break;

			case Enums.ComposeType.Forward:
				this.subject(Utils.replySubjectAdd('Fwd', sSubject));
				this.prepearMessageAttachments(oMessage, sComposeType);
				this.aDraftInfo = ['forward', oMessage.uid, oMessage.folderFullNameRaw];
				this.sInReplyTo = oMessage.sMessageId;
				this.sReferences = Utils.trim(this.sInReplyTo + ' ' + oMessage.sReferences);
				break;

			case Enums.ComposeType.ForwardAsAttachment:
				this.subject(Utils.replySubjectAdd('Fwd', sSubject));
				this.prepearMessageAttachments(oMessage, sComposeType);
				this.aDraftInfo = ['forward', oMessage.uid, oMessage.folderFullNameRaw];
				this.sInReplyTo = oMessage.sMessageId;
				this.sReferences = Utils.trim(this.sInReplyTo + ' ' + oMessage.sReferences);
				break;

			case Enums.ComposeType.Draft:
				this.to(this.emailArrayToStringLineHelper(oMessage.to));
				this.cc(this.emailArrayToStringLineHelper(oMessage.cc));
				this.bcc(this.emailArrayToStringLineHelper(oMessage.bcc));
				this.replyTo(this.emailArrayToStringLineHelper(oMessage.replyTo));

				this.bFromDraft = true;

				this.draftFolder(oMessage.folderFullNameRaw);
				this.draftUid(oMessage.uid);

				this.subject(sSubject);
				this.prepearMessageAttachments(oMessage, sComposeType);

				this.aDraftInfo = Utils.isNonEmptyArray(aDraftInfo) && 3 === aDraftInfo.length ? aDraftInfo : null;
				this.sInReplyTo = oMessage.sInReplyTo;
				this.sReferences = oMessage.sReferences;
				break;

			case Enums.ComposeType.EditAsNew:
				this.to(this.emailArrayToStringLineHelper(oMessage.to));
				this.cc(this.emailArrayToStringLineHelper(oMessage.cc));
				this.bcc(this.emailArrayToStringLineHelper(oMessage.bcc));
				this.replyTo(this.emailArrayToStringLineHelper(oMessage.replyTo));

				this.subject(sSubject);
				this.prepearMessageAttachments(oMessage, sComposeType);

				this.aDraftInfo = Utils.isNonEmptyArray(aDraftInfo) && 3 === aDraftInfo.length ? aDraftInfo : null;
				this.sInReplyTo = oMessage.sInReplyTo;
				this.sReferences = oMessage.sReferences;
				break;
			// no default
		}

		switch (sComposeType)
		{
			case Enums.ComposeType.Reply:
			case Enums.ComposeType.ReplyAll:
				sFrom = oMessage.fromToLine(false, true);
				sReplyTitle = Translator.i18n('COMPOSE/REPLY_MESSAGE_TITLE', {
					'DATETIME': sDate,
					'EMAIL': sFrom
				});

				sText = '<br /><br />' + sReplyTitle + ':' +
					'<blockquote>' + Utils.trim(sText) + '</blockquote>';
//						'<blockquote><p>' + Utils.trim(sText) + '</p></blockquote>';

				break;

			case Enums.ComposeType.Forward:
				sFrom = oMessage.fromToLine(false, true);
				sTo = oMessage.toToLine(false, true);
				sCc = oMessage.ccToLine(false, true);
				sText = '<br /><br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_TITLE') +
						'<br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_FROM') + ': ' + sFrom +
						'<br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_TO') + ': ' + sTo +
						(0 < sCc.length ? '<br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_CC') + ': ' + sCc : '') +
						'<br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_SENT') + ': ' + Utils.encodeHtml(sDate) +
						'<br />' + Translator.i18n('COMPOSE/FORWARD_MESSAGE_TOP_SUBJECT') + ': ' + Utils.encodeHtml(sSubject) +
						'<br /><br />' + Utils.trim(sText) + '<br /><br />';
				break;

			case Enums.ComposeType.ForwardAsAttachment:
				sText = '';
				break;
			// no default
		}

		this.editor(function(oEditor) {

			oEditor.setHtml(sText, false);

			if (Enums.EditorDefaultType.PlainForced === self.editorDefaultType() ||
				(!oMessage.isHtml() && Enums.EditorDefaultType.HtmlForced !== self.editorDefaultType()))
			{
				oEditor.modeToggle(false);
			}

			if (oIdentity && Enums.ComposeType.Draft !== sComposeType && Enums.ComposeType.EditAsNew !== sComposeType)
			{
				self.setSignatureFromIdentity(oIdentity);
			}

			self.setFocusInPopup();
		});
	}
	else if (Enums.ComposeType.Empty === sComposeType)
	{
		this.subject(Utils.isNormal(sCustomSubject) ? '' + sCustomSubject : '');

		sText = Utils.isNormal(sCustomPlainText) ? '' + sCustomPlainText : '';

		this.editor(function(oEditor) {

			oEditor.setHtml(sText, false);

			if (Enums.EditorDefaultType.Html !== self.editorDefaultType() &&
				Enums.EditorDefaultType.HtmlForced !== self.editorDefaultType())
			{
				oEditor.modeToggle(false);
			}

			if (oIdentity)
			{
				self.setSignatureFromIdentity(oIdentity);
			}

			self.setFocusInPopup();
		});
	}
	else if (Utils.isNonEmptyArray(oMessageOrArray))
	{
		_.each(oMessageOrArray, function(oItem) {
			self.addMessageAsAttachment(oItem);
		});

		this.editor(function(oEditor) {

			oEditor.setHtml('', false);

			if (Enums.EditorDefaultType.Html !== self.editorDefaultType() &&
				Enums.EditorDefaultType.HtmlForced !== self.editorDefaultType())
			{
				oEditor.modeToggle(false);
			}

			if (oIdentity && Enums.ComposeType.Draft !== sComposeType && Enums.ComposeType.EditAsNew !== sComposeType)
			{
				self.setSignatureFromIdentity(oIdentity);
			}

			self.setFocusInPopup();
		});
	}
	else
	{
		this.setFocusInPopup();
	}

	aDownloads = this.getAttachmentsDownloadsForUpload();
	if (Utils.isNonEmptyArray(aDownloads))
	{
		Remote.messageUploadAttachments(this.onMessageUploadAttachments, aDownloads);
	}

	if (oIdentity)
	{
		this.currentIdentity(oIdentity);
	}

	this.resizerTrigger();
};

ComposePopupView.prototype.onMessageUploadAttachments = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		var
			oAttachment = null,
			sTempName = '';

		if (!this.viewModelVisibility())
		{
			for (sTempName in oData.Result)
			{
				if (Utils.has(oData.Result, sTempName))
				{
					oAttachment = this.getAttachmentById(oData.Result[sTempName]);
					if (oAttachment)
					{
						oAttachment.tempName(sTempName);
						oAttachment.waiting(false).uploading(false).complete(true);
					}
				}
			}
		}
	}
	else
	{
		this.setMessageAttachmentFailedDownloadText();
	}
};

ComposePopupView.prototype.setFocusInPopup = function()
{
	if (!Globals.bMobileDevice)
	{
		var self = this;
		_.delay(function() {

			if ('' === self.to())
			{
				self.to.focused(true);
			}
			else if (self.oEditor)
			{
				if (!self.to.focused())
				{
					self.oEditor.focus();
				}
			}

		}, Enums.Magics.Time100ms);
	}
};

ComposePopupView.prototype.onShowWithDelay = function()
{
	this.resizerTrigger();
};

ComposePopupView.prototype.tryToClosePopup = function()
{
	var
		self = this,
		PopupsAskViewModel = __webpack_require__(/*! View/Popup/Ask */ 39);

	if (!kn.isPopupVisible(PopupsAskViewModel) && this.modalVisibility())
	{
		if (this.bSkipNextHide || (this.isEmptyForm() && !this.draftUid()))
		{
			Utils.delegateRun(self, 'closeCommand');
		}
		else
		{
			kn.showScreenPopup(PopupsAskViewModel, [Translator.i18n('POPUPS_ASK/DESC_WANT_CLOSE_THIS_WINDOW'), function() {
				if (self.modalVisibility())
				{
					Utils.delegateRun(self, 'closeCommand');
				}
			}]);
		}
	}
};

ComposePopupView.prototype.onBuild = function()
{
	this.initUploader();

	var
		self = this,
		oScript = null;

	key('ctrl+q, command+q, ctrl+w, command+w', Enums.KeyState.Compose, function() {
		return false;
	});

	key('`', Enums.KeyState.Compose, function() {
		if (self.oEditor && !self.oEditor.hasFocus() && !Utils.inFocus())
		{
			self.identitiesDropdownTrigger(true);
			return false;
		}

		return true;
	});

	key('ctrl+`', Enums.KeyState.Compose, function() {
		self.identitiesDropdownTrigger(true);
		return false;
	});

	key('esc, ctrl+down, command+down', Enums.KeyState.Compose, function() {
		self.skipCommand();
		return false;
	});

	if (this.allowFolders)
	{
		key('ctrl+s, command+s', Enums.KeyState.Compose, function() {
			self.saveCommand();
			return false;
		});
	}

	if (Settings.appSettingsGet('allowCtrlEnterOnCompose'))
	{
		key('ctrl+enter, command+enter', Enums.KeyState.Compose, function() {
			self.sendCommand();
			return false;
		});
	}

	key('shift+esc', Enums.KeyState.Compose, function() {
		if (self.modalVisibility())
		{
			self.tryToClosePopup();
		}
		return false;
	});

	Events.sub('window.resize.real', this.resizerTrigger);
	Events.sub('window.resize.real', _.debounce(this.resizerTrigger, Enums.Magics.Time50ms));

	if (this.dropboxEnabled() && this.dropboxApiKey() && !window.Dropbox)
	{
		oScript = window.document.createElement('script');
		oScript.type = 'text/javascript';
		oScript.src = 'https://www.dropbox.com/static/api/2/dropins.js';
		$(oScript).attr('id', 'dropboxjs').attr('data-app-key', self.dropboxApiKey());

		window.document.body.appendChild(oScript);
	}

	if (this.driveEnabled())
	{
		$.getScript('https://apis.google.com/js/api.js', function() {
			if (window.gapi)
			{
				self.driveVisible(true);
			}
		});
	}

	window.setInterval(function() {
		if (self.modalVisibility() && self.oEditor)
		{
			self.oEditor.resize();
		}
	}, Enums.Magics.Time5s);
};

ComposePopupView.prototype.driveCallback = function(sAccessToken, oData)
{
	if (oData && window.XMLHttpRequest && window.google &&
		oData[window.google.picker.Response.ACTION] === window.google.picker.Action.PICKED &&
		oData[window.google.picker.Response.DOCUMENTS] && oData[window.google.picker.Response.DOCUMENTS][0] &&
		oData[window.google.picker.Response.DOCUMENTS][0].id)
	{
		var
			self = this,
			oRequest = new window.XMLHttpRequest();

		oRequest.open('GET', 'https://www.googleapis.com/drive/v2/files/' + oData[window.google.picker.Response.DOCUMENTS][0].id);
		oRequest.setRequestHeader('Authorization', 'Bearer ' + sAccessToken);
		oRequest.addEventListener('load', function() {
			if (oRequest && oRequest.responseText)
			{
				var
					oResponse = JSON.parse(oRequest.responseText),
					fExport = function(oItem, sMimeType, sExt) {
						if (oItem && oItem.exportLinks)
						{
							if (oItem.exportLinks[sMimeType])
							{
								oResponse.downloadUrl = oItem.exportLinks[sMimeType];
								oResponse.title = oItem.title + '.' + sExt;
								oResponse.mimeType = sMimeType;
							}
							else if (oItem.exportLinks['application/pdf'])
							{
								oResponse.downloadUrl = oItem.exportLinks['application/pdf'];
								oResponse.title = oItem.title + '.pdf';
								oResponse.mimeType = 'application/pdf';
							}
						}
					};

				if (oResponse && !oResponse.downloadUrl && oResponse.mimeType && oResponse.exportLinks)
				{
					switch (oResponse.mimeType.toString().toLowerCase())
					{
						case 'application/vnd.google-apps.document':
							fExport(oResponse, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'docx');
							break;
						case 'application/vnd.google-apps.spreadsheet':
							fExport(oResponse, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'xlsx');
							break;
						case 'application/vnd.google-apps.drawing':
							fExport(oResponse, 'image/png', 'png');
							break;
						case 'application/vnd.google-apps.presentation':
							fExport(oResponse, 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'pptx');
							break;
						default:
							fExport(oResponse, 'application/pdf', 'pdf');
							break;
					}
				}

				if (oResponse && oResponse.downloadUrl)
				{
					self.addDriveAttachment(oResponse, sAccessToken);
				}
			}
		});

		oRequest.send();
	}
};

ComposePopupView.prototype.driveCreatePiker = function(oOauthToken)
{
	if (window.gapi && oOauthToken && oOauthToken.access_token)
	{
		var self = this;

		window.gapi.load('picker', {'callback': function() {

			if (window.google && window.google.picker)
			{
				var drivePicker = new window.google.picker.PickerBuilder()
					// .addView(window.google.picker.ViewId.FOLDERS)
					.addView(window.google.picker.ViewId.DOCS)
					.setAppId(Settings.settingsGet('GoogleClientID'))
					.setOAuthToken(oOauthToken.access_token)
					.setCallback(_.bind(self.driveCallback, self, oOauthToken.access_token))
					.enableFeature(window.google.picker.Feature.NAV_HIDDEN)
					// .setOrigin(window.location.protocol + '//' + window.location.host)
					.build();

				drivePicker.setVisible(true);
			}
		}});
	}
};

ComposePopupView.prototype.driveOpenPopup = function()
{
	if (window.gapi)
	{
		var self = this;

		window.gapi.load('auth', {'callback': function() {

			var
				oAuthToken = window.gapi.auth.getToken(),
				fResult = function(oAuthResult) {
					if (oAuthResult && !oAuthResult.error)
					{
						var oToken = window.gapi.auth.getToken();
						if (oToken)
						{
							self.driveCreatePiker(oToken);
						}

						return true;
					}

					return false;
				};

			if (!oAuthToken)
			{
				window.gapi.auth.authorize({
					'client_id': Settings.settingsGet('GoogleClientID'),
					'scope': 'https://www.googleapis.com/auth/drive.readonly',
					'immediate': true
				}, function(oAuthResult) {

					if (!fResult(oAuthResult))
					{
						window.gapi.auth.authorize({
							'client_id': Settings.settingsGet('GoogleClientID'),
							'scope': 'https://www.googleapis.com/auth/drive.readonly',
							'immediate': false
						}, fResult);
					}
				});
			}
			else
			{
				self.driveCreatePiker(oAuthToken);
			}
		}});
	}
};

/**
 * @param {string} sId
 * @returns {?Object}
 */
ComposePopupView.prototype.getAttachmentById = function(sId)
{
	var
		aAttachments = this.attachments(),
		iIndex = 0,
		iLen = aAttachments.length;

	for (; iIndex < iLen; iIndex++)
	{
		if (aAttachments[iIndex] && sId === aAttachments[iIndex].id)
		{
			return aAttachments[iIndex];
		}
	}

	return null;
};

ComposePopupView.prototype.cancelAttachmentHelper = function(sId, oJua) {

	var self = this;
	return function() {

		var attachment = _.find(self.attachments(), function(oItem) {
			return oItem && oItem.id === sId;
		});

		if (attachment)
		{
			self.attachments.remove(attachment);
			Utils.delegateRunOnDestroy(attachment);

			if (oJua)
			{
				oJua.cancel(sId);
			}
		}
	};

};

ComposePopupView.prototype.initUploader = function()
{
	if (this.composeUploaderButton())
	{
		var
			oUploadCache = {},
			iAttachmentSizeLimit = Utils.pInt(Settings.settingsGet('AttachmentLimit')),
			oJua = new Jua({
				'action': Links.upload(),
				'name': 'uploader',
				'queueSize': 2,
				'multipleSizeLimit': 50,
				'clickElement': this.composeUploaderButton(),
				'dragAndDropElement': this.composeUploaderDropPlace()
			});

		if (oJua)
		{
			oJua
//				.on('onLimitReached', function(iLimit) {
//					alert(iLimit);
//				})
				.on('onDragEnter', _.bind(function() {
					this.dragAndDropOver(true);
				}, this))
				.on('onDragLeave', _.bind(function() {
					this.dragAndDropOver(false);
				}, this))
				.on('onBodyDragEnter', _.bind(function() {
					this.attachmentsPlace(true);
					this.dragAndDropVisible(true);
				}, this))
				.on('onBodyDragLeave', _.bind(function() {
					this.dragAndDropVisible(false);
				}, this))
				.on('onProgress', _.bind(function(sId, iLoaded, iTotal) {
					var oItem = null;
					if (Utils.isUnd(oUploadCache[sId]))
					{
						oItem = this.getAttachmentById(sId);
						if (oItem)
						{
							oUploadCache[sId] = oItem;
						}
					}
					else
					{
						oItem = oUploadCache[sId];
					}

					if (oItem)
					{
						oItem.progress(window.Math.floor(iLoaded / iTotal * 100));
					}

				}, this))
				.on('onSelect', _.bind(function(sId, oData) {

					this.dragAndDropOver(false);

					var
						self = this,
						sFileName = Utils.isUnd(oData.FileName) ? '' : oData.FileName.toString(),
						mSize = Utils.isNormal(oData.Size) ? Utils.pInt(oData.Size) : null,
						oAttachment = new ComposeAttachmentModel(sId, sFileName, mSize);

					oAttachment.cancel = self.cancelAttachmentHelper(sId, oJua);

					this.attachments.push(oAttachment);

					this.attachmentsPlace(true);

					if (0 < mSize && 0 < iAttachmentSizeLimit && iAttachmentSizeLimit < mSize)
					{
						oAttachment
							.waiting(false).uploading(true).complete(true)
							.error(Translator.i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG'));

						return false;
					}

					return true;

				}, this))
				.on('onStart', _.bind(function(sId) {

					var
						oItem = null;

					if (Utils.isUnd(oUploadCache[sId]))
					{
						oItem = this.getAttachmentById(sId);
						if (oItem)
						{
							oUploadCache[sId] = oItem;
						}
					}
					else
					{
						oItem = oUploadCache[sId];
					}

					if (oItem)
					{
						oItem.waiting(false).uploading(true).complete(false);
					}

				}, this))
				.on('onComplete', _.bind(function(sId, bResult, oData) {

					var
						sError = '',
						mErrorCode = null,
						oAttachmentJson = null,
						oAttachment = this.getAttachmentById(sId);

					oAttachmentJson = bResult && oData && oData.Result && oData.Result.Attachment ? oData.Result.Attachment : null;
					mErrorCode = oData && oData.Result && oData.Result.ErrorCode ? oData.Result.ErrorCode : null;

					if (null !== mErrorCode)
					{
						sError = Translator.getUploadErrorDescByCode(mErrorCode);
					}
					else if (!oAttachmentJson)
					{
						sError = Translator.i18n('UPLOAD/ERROR_UNKNOWN');
					}

					if (oAttachment)
					{
						if ('' !== sError && 0 < sError.length)
						{
							oAttachment
								.waiting(false)
								.uploading(false)
								.complete(true)
								.error(sError);
						}
						else if (oAttachmentJson)
						{
							oAttachment
								.waiting(false)
								.uploading(false)
								.complete(true);

							oAttachment.initByUploadJson(oAttachmentJson);
						}

						if (Utils.isUnd(oUploadCache[sId]))
						{
							delete (oUploadCache[sId]);
						}
					}

				}, this));

			this
				.addAttachmentEnabled(true)
				.dragAndDropEnabled(oJua.isDragAndDropSupported());
		}
		else
		{
			this
				.addAttachmentEnabled(false)
				.dragAndDropEnabled(false);
		}
	}
};

/**
 * @returns {Object}
 */
ComposePopupView.prototype.prepearAttachmentsForSendOrSave = function()
{
	var oResult = {};
	_.each(this.attachmentsInReady(), function(oItem) {
		if (oItem && '' !== oItem.tempName() && oItem.enabled())
		{
			oResult[oItem.tempName()] = [
				oItem.fileName(),
				oItem.isInline ? '1' : '0',
				oItem.CID,
				oItem.contentLocation
			];
		}
	});

	return oResult;
};

/**
 * @param {MessageModel} oMessage
 */
ComposePopupView.prototype.addMessageAsAttachment = function(oMessage)
{
	if (oMessage)
	{
		var
			oAttachment = null,
			sTemp = oMessage.subject();

		sTemp = '.eml' === sTemp.substr(-4).toLowerCase() ? sTemp : sTemp + '.eml';
		oAttachment = new ComposeAttachmentModel(
			oMessage.requestHash, sTemp, oMessage.size()
		);

		oAttachment.fromMessage = true;
		oAttachment.cancel = this.cancelAttachmentHelper(oMessage.requestHash);
		oAttachment.waiting(false).uploading(true).complete(true);

		this.attachments.push(oAttachment);
	}
};

/**
 * @param {Object} oDropboxFile
 * @returns {boolean}
 */
ComposePopupView.prototype.addDropboxAttachment = function(oDropboxFile)
{
	var
		oAttachment = null,
		iAttachmentSizeLimit = Utils.pInt(Settings.settingsGet('AttachmentLimit')),
		mSize = oDropboxFile.bytes;

	oAttachment = new ComposeAttachmentModel(
		oDropboxFile.link, oDropboxFile.name, mSize
	);

	oAttachment.fromMessage = false;
	oAttachment.cancel = this.cancelAttachmentHelper(oDropboxFile.link);
	oAttachment.waiting(false).uploading(true).complete(false);

	this.attachments.push(oAttachment);

	this.attachmentsPlace(true);

	if (0 < mSize && 0 < iAttachmentSizeLimit && iAttachmentSizeLimit < mSize)
	{
		oAttachment.uploading(false).complete(true);
		oAttachment.error(Translator.i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG'));
		return false;
	}

	Remote.composeUploadExternals(function(sResult, oData) {

		var bResult = false;
		oAttachment.uploading(false).complete(true);

		if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
		{
			if (oData.Result[oAttachment.id])
			{
				bResult = true;
				oAttachment.tempName(oData.Result[oAttachment.id]);
			}
		}

		if (!bResult)
		{
			oAttachment.error(Translator.getUploadErrorDescByCode(Enums.UploadErrorCode.FileNoUploaded));
		}

	}, [oDropboxFile.link]);

	return true;
};

/**
 * @param {Object} oDriveFile
 * @param {string} sAccessToken
 * @returns {boolean}
 */
ComposePopupView.prototype.addDriveAttachment = function(oDriveFile, sAccessToken)
{
	var
		iAttachmentSizeLimit = Utils.pInt(Settings.settingsGet('AttachmentLimit')),
		oAttachment = null,
		mSize = oDriveFile.fileSize ? Utils.pInt(oDriveFile.fileSize) : 0;

	oAttachment = new ComposeAttachmentModel(
		oDriveFile.downloadUrl, oDriveFile.title, mSize
	);

	oAttachment.fromMessage = false;
	oAttachment.cancel = this.cancelAttachmentHelper(oDriveFile.downloadUrl);
	oAttachment.waiting(false).uploading(true).complete(false);

	this.attachments.push(oAttachment);

	this.attachmentsPlace(true);

	if (0 < mSize && 0 < iAttachmentSizeLimit && iAttachmentSizeLimit < mSize)
	{
		oAttachment.uploading(false).complete(true);
		oAttachment.error(Translator.i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG'));
		return false;
	}

	Remote.composeUploadDrive(function(sResult, oData) {

		var bResult = false;
		oAttachment.uploading(false).complete(true);

		if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
		{
			if (oData.Result[oAttachment.id])
			{
				bResult = true;
				oAttachment.tempName(oData.Result[oAttachment.id][0]);
				oAttachment.size(Utils.pInt(oData.Result[oAttachment.id][1]));
			}
		}

		if (!bResult)
		{
			oAttachment.error(Translator.getUploadErrorDescByCode(Enums.UploadErrorCode.FileNoUploaded));
		}

	}, oDriveFile.downloadUrl, sAccessToken);

	return true;
};

/**
 * @param {MessageModel} oMessage
 * @param {string} sType
 */
ComposePopupView.prototype.prepearMessageAttachments = function(oMessage, sType)
{
	if (oMessage)
	{
		var
			aAttachments = Utils.isNonEmptyArray(oMessage.attachments()) ? oMessage.attachments() : [],
			iIndex = 0,
			iLen = aAttachments.length,
			oAttachment = null,
			oItem = null,
			bAdd = false;

		if (Enums.ComposeType.ForwardAsAttachment === sType)
		{
			this.addMessageAsAttachment(oMessage);
		}
		else
		{
			for (; iIndex < iLen; iIndex++)
			{
				oItem = aAttachments[iIndex];

				bAdd = false;
				switch (sType)
				{
					case Enums.ComposeType.Reply:
					case Enums.ComposeType.ReplyAll:
						bAdd = oItem.isLinked;
						break;

					case Enums.ComposeType.Forward:
					case Enums.ComposeType.Draft:
					case Enums.ComposeType.EditAsNew:
						bAdd = true;
						break;
					// no default
				}

				if (bAdd)
				{
					oAttachment = new ComposeAttachmentModel(
						oItem.download, oItem.fileName, oItem.estimatedSize,
						oItem.isInline, oItem.isLinked, oItem.cid, oItem.contentLocation
					);

					oAttachment.fromMessage = true;
					oAttachment.cancel = this.cancelAttachmentHelper(oItem.download);
					oAttachment.waiting(false).uploading(true).complete(false);

					this.attachments.push(oAttachment);
				}
			}
		}
	}
};

ComposePopupView.prototype.removeLinkedAttachments = function()
{
	var arrachment = _.find(this.attachments(), function(oItem) {
		return oItem && oItem.isLinked;
	});

	if (arrachment)
	{
		this.attachments.remove(arrachment);
		Utils.delegateRunOnDestroy(arrachment);
	}
};

ComposePopupView.prototype.setMessageAttachmentFailedDownloadText = function()
{
	_.each(this.attachments(), function(oAttachment) {
		if (oAttachment && oAttachment.fromMessage)
		{
			oAttachment
				.waiting(false)
				.uploading(false)
				.complete(true)
				.error(Translator.getUploadErrorDescByCode(Enums.UploadErrorCode.FileNoUploaded));
		}
	}, this);
};

/**
 * @param {boolean=} bIncludeAttachmentInProgress = true
 * @returns {boolean}
 */
ComposePopupView.prototype.isEmptyForm = function(bIncludeAttachmentInProgress)
{
	bIncludeAttachmentInProgress = Utils.isUnd(bIncludeAttachmentInProgress) ? true : !!bIncludeAttachmentInProgress;
	var bWithoutAttach = bIncludeAttachmentInProgress ?
		0 === this.attachments().length : 0 === this.attachmentsInReady().length;

	return 0 === this.to().length &&
		0 === this.cc().length &&
		0 === this.bcc().length &&
		0 === this.replyTo().length &&
		0 === this.subject().length &&
		bWithoutAttach &&
		(!this.oEditor || '' === this.oEditor.getData());
};

ComposePopupView.prototype.reset = function()
{
	this.to('');
	this.cc('');
	this.bcc('');
	this.replyTo('');
	this.subject('');

	this.requestDsn(false);
	this.requestReadReceipt(false);
	this.markAsImportant(false);

	this.attachmentsPlace(false);

	this.aDraftInfo = null;
	this.sInReplyTo = '';
	this.bFromDraft = false;
	this.sReferences = '';

	this.sendError(false);
	this.sendSuccessButSaveError(false);
	this.savedError(false);
	this.savedTime(0);
	this.emptyToError(false);
	this.attachmentsInProcessError(false);

	this.showCc(false);
	this.showBcc(false);
	this.showReplyTo(false);

	Utils.delegateRunOnDestroy(this.attachments());
	this.attachments([]);

	this.dragAndDropOver(false);
	this.dragAndDropVisible(false);

	this.draftFolder('');
	this.draftUid('');

	this.sending(false);
	this.saving(false);

	if (this.oEditor)
	{
		this.oEditor.clear(false);
	}
};

/**
 * @returns {Array}
 */
ComposePopupView.prototype.getAttachmentsDownloadsForUpload = function()
{
	return _.map(_.filter(this.attachments(), function(oItem) {
		return oItem && '' === oItem.tempName();
	}), function(oItem) {
		return oItem.id;
	});
};

ComposePopupView.prototype.resizerTrigger = function()
{
	this.resizer(!this.resizer());
};

module.exports = ComposePopupView;


/***/ },
/* 26 */
/*!*********************************!*\
  !*** ./dev/Common/Momentor.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment__ = __webpack_require__(/*! moment */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment___default = __WEBPACK_IMPORTED_MODULE_3_moment__ && __WEBPACK_IMPORTED_MODULE_3_moment__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_moment__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_moment__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_moment___default, 'a', __WEBPACK_IMPORTED_MODULE_3_moment___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony export */ exports["momentNow"] = momentNow;/* harmony export */ exports["momentNowUnix"] = momentNowUnix;/* harmony export */ exports["searchSubtractFormatDateHelper"] = searchSubtractFormatDateHelper;/* harmony export */ exports["format"] = format;/* harmony export */ exports["momentToNode"] = momentToNode;/* harmony export */ exports["reload"] = reload;






var _moment = null;
var _momentNow = 0;

var updateMomentNow = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_moment = __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}, 500, true);

var updateMomentNowUnix = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_momentNow = __WEBPACK_IMPORTED_MODULE_3_moment___default()().unix();
}, 500, true);

/**
 * @returns {moment}
 */
function momentNow() {
	updateMomentNow();
	return _moment || __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}

/**
 * @returns {number}
 */
function momentNowUnix() {
	updateMomentNowUnix();
	return _momentNow || 0;
}

/**
 * @param {number} date
 * @returns {string}
 */
function searchSubtractFormatDateHelper(date) {
	return momentNow().clone().subtract('days', date).format('YYYY.MM.DD');
}

/**
 * @param {Object} m
 * @returns {string}
 */
function formatCustomShortDate(m) {
	var now = momentNow();
	if (m && now) {
		switch (true) {
			case 4 >= now.diff(m, 'hours'):
				return m.fromNow();
			case now.format('L') === m.format('L'):
				return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/TODAY_AT', {
					TIME: m.format('LT')
				});
			case now.clone().subtract('days', 1).format('L') === m.format('L'):
				return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/YESTERDAY_AT', {
					TIME: m.format('LT')
				});
			case now.year() === m.year():
				return m.format('D MMM.');
			// no default
		}
	}

	return m ? m.format('LL') : '';
}

/**
 * @param {number} timeStampInUTC
 * @param {string} formatStr
 * @returns {string}
 */
function format(timeStampInUTC, formatStr) {

	var m = null,
	    result = '';

	var now = momentNowUnix();

	timeStampInUTC = 0 < timeStampInUTC ? timeStampInUTC : 0 === timeStampInUTC ? now : 0;
	timeStampInUTC = now < timeStampInUTC ? now : timeStampInUTC;

	m = 0 < timeStampInUTC ? __WEBPACK_IMPORTED_MODULE_3_moment___default.a.unix(timeStampInUTC) : null;

	if (m && 1970 === m.year()) {
		m = null;
	}

	if (m) {
		switch (formatStr) {
			case 'FROMNOW':
				result = m.fromNow();
				break;
			case 'SHORT':
				result = formatCustomShortDate(m);
				break;
			case 'FULL':
				result = m.format('LLL');
				break;
			default:
				result = m.format(formatStr);
				break;
		}
	}

	return result;
}

/**
 * @param {Object} element
 * @returns {void}
 */
function momentToNode(element) {
	var key = '',
	    time = 0,
	    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

	time = $el.data('moment-time');
	if (time) {
		key = $el.data('moment-format');
		if (key) {
			$el.text(format(time, key));
		}

		key = $el.data('moment-format-title');
		if (key) {
			$el.attr('title', format(time, key));
		}
	}
}

/**
 * @returns {void}
 */
function reload() {
	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
		__WEBPACK_IMPORTED_MODULE_2_____default()('.moment', __WEBPACK_IMPORTED_MODULE_0_window___default.a.document).each(function (index, item) {
			momentToNode(item);
		});
	});
}

/***/ },
/* 27 */
/*!*************************************!*\
  !*** ./dev/Knoin/AbstractModel.jsx ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }




var AbstractModel = function () {
	/**
  * @param {string} modelName
  */

	function AbstractModel(modelName) {
		_classCallCheck(this, AbstractModel);

		this.sModelName = modelName || '';
		this.disposables = [];
	}

	AbstractModel.prototype.regDisposables = function regDisposables(value) {
		var _this = this;

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(value)) {
			__WEBPACK_IMPORTED_MODULE_0_____default.a.each(value, function (item) {
				_this.disposables.push(item);
			});
		} else if (value) {
			this.disposables.push(value);
		}
	};

	AbstractModel.prototype.onDestroy = function onDestroy() {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["disposeObject"])(this);
	};

	return AbstractModel;
}();



/***/ },
/* 28 */
/*!************************************!*\
  !*** ./dev/Stores/User/Account.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function AccountUserStore()
{
	this.email = ko.observable('');
	this.parentEmail = ko.observable('');
//		this.incLogin = ko.observable('');
//		this.outLogin = ko.observable('');

	this.signature = ko.observable('');

	this.accounts = ko.observableArray([]);
	this.accounts.loading = ko.observable(false).extend({'throttle': 100});

	this.computers();
}

AccountUserStore.prototype.computers = function()
{
	this.accountsEmails = ko.computed(function() {
		return _.compact(_.map(this.accounts(), function(oItem) {
			return oItem ? oItem.email : null;
		}));
	}, this);

	this.accountsUnreadCount = ko.computed(function() {

		var iResult = 0;

//			_.each(this.accounts(), function(oItem) {
//				if (oItem)
//				{
//					iResult += oItem.count();
//				}
//			});

		return iResult;

	}, this);
};

AccountUserStore.prototype.populate = function()
{
	this.email(Settings.settingsGet('Email'));
	this.parentEmail(Settings.settingsGet('ParentEmail'));
};

/**
 * @returns {boolean}
 */
AccountUserStore.prototype.isRootAccount = function()
{
	return '' === this.parentEmail();
};

module.exports = new AccountUserStore();


/***/ },
/* 29 */
/*!************************************!*\
  !*** ./dev/Stores/User/Message.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	window = __webpack_require__(/*! window */ 9),
	$ = __webpack_require__(/*! $ */ 10),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),
	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	MessageModel = __webpack_require__(/*! Model/Message */ 169).default,
	MessageHelper = __webpack_require__(/*! Helper/Message */ 103);

/**
 * @constructor
 */
function MessageUserStore()
{
	this.staticMessage = new MessageModel();

	this.messageList = ko.observableArray([]).extend({'rateLimit': 0});

	this.messageListCount = ko.observable(0);
	this.messageListSearch = ko.observable('');
	this.messageListThreadUid = ko.observable('');
	this.messageListPage = ko.observable(1);
	this.messageListPageBeforeThread = ko.observable(1);
	this.messageListError = ko.observable('');

	this.messageListEndFolder = ko.observable('');
	this.messageListEndSearch = ko.observable('');
	this.messageListEndThreadUid = ko.observable('');
	this.messageListEndPage = ko.observable(1);

	this.messageListLoading = ko.observable(false);
	this.messageListIsNotCompleted = ko.observable(false);
	this.messageListCompleteLoadingThrottle = ko.observable(false).extend({'throttle': 200});
	this.messageListCompleteLoadingThrottleForAnimation = ko.observable(false).extend({'specialThrottle': 700});

	this.messageListDisableAutoSelect = ko.observable(false).extend({'falseTimeout': 500});

	this.selectorMessageSelected = ko.observable(null);
	this.selectorMessageFocused = ko.observable(null);

	// message viewer
	this.message = ko.observable(null);

	this.message.viewTrigger = ko.observable(false);

	this.messageError = ko.observable('');

	this.messageCurrentLoading = ko.observable(false);

	this.messageLoading = ko.computed(function() {
		return this.messageCurrentLoading();
	}, this);

	this.messageLoadingThrottle = ko.observable(false).extend({'throttle': Enums.Magics.Time50ms});

	this.messageFullScreenMode = ko.observable(false);

	this.messagesBodiesDom = ko.observable(null);
	this.messageActiveDom = ko.observable(null);

	this.computers();
	this.subscribers();

	this.onMessageResponse = _.bind(this.onMessageResponse, this);

	this.purgeMessageBodyCacheThrottle = _.throttle(this.purgeMessageBodyCache, Enums.Magics.Time30s);
}

MessageUserStore.prototype.computers = function()
{
	var self = this;

	this.messageListEndHash = ko.computed(function() {
		return this.messageListEndFolder() + '|' + this.messageListEndSearch() +
			'|' + this.messageListEndThreadUid() +
			'|' + this.messageListEndPage();
	}, this);

	this.messageListPageCount = ko.computed(function() {
		var iPage = window.Math.ceil(this.messageListCount() /
			SettingsStore.messagesPerPage());
		return 0 >= iPage ? 1 : iPage;
	}, this);

	this.mainMessageListSearch = ko.computed({
		'read': this.messageListSearch,
		'write': function(sValue) {
			kn.setHash(Links.mailBox(
				FolderStore.currentFolderFullNameHash(), 1,
				Utils.trim(sValue.toString()), self.messageListThreadUid()
			));
		},
		'owner': this
	});

	this.messageListCompleteLoading = ko.computed(function() {
		var
			bOne = this.messageListLoading(),
			bTwo = this.messageListIsNotCompleted();
		return bOne || bTwo;
	}, this);

	this.isMessageSelected = ko.computed(function() {
		return null !== this.message();
	}, this);

	this.messageListChecked = ko.computed(function() {
		return _.filter(this.messageList(), function(oItem) {
			return oItem.checked();
		});
	}, this).extend({'rateLimit': 0});

	this.hasCheckedMessages = ko.computed(function() {
		return 0 < this.messageListChecked().length;
	}, this).extend({'rateLimit': 0});

	this.messageListCheckedOrSelected = ko.computed(function() {

		var
			aChecked = this.messageListChecked(),
			oSelectedMessage = this.selectorMessageSelected();

		return _.union(aChecked, oSelectedMessage ? [oSelectedMessage] : []);

	}, this);

	this.messageListCheckedOrSelectedUidsWithSubMails = ko.computed(function() {
		var aList = [];
		_.each(this.messageListCheckedOrSelected(), function(oMessage) {
			if (oMessage)
			{
				aList.push(oMessage.uid);
				if (1 < oMessage.threadsLen())
				{
					aList = _.union(aList, oMessage.threads());
				}
			}
		});
		return aList;
	}, this);
};

MessageUserStore.prototype.subscribers = function()
{
	this.messageListCompleteLoading.subscribe(function(bValue) {
		bValue = !!bValue;
		this.messageListCompleteLoadingThrottle(bValue);
		this.messageListCompleteLoadingThrottleForAnimation(bValue);
	}, this);

	this.messageList.subscribe(_.debounce(function(aList) {
		_.each(aList, function(oItem) {
			if (oItem && oItem.newForAnimation())
			{
				oItem.newForAnimation(false);
			}
		});
	}, Enums.Magics.Time500ms));

	this.message.subscribe(function(oMessage) {

		if (oMessage)
		{
			if (Enums.Layout.NoPreview === SettingsStore.layout())
			{
				AppStore.focusedState(Enums.Focused.MessageView);
			}
		}
		else
		{
			AppStore.focusedState(Enums.Focused.MessageList);

			this.messageFullScreenMode(false);
			this.hideMessageBodies();
		}

	}, this);

	this.messageLoading.subscribe(function(bValue) {
		this.messageLoadingThrottle(bValue);
	}, this);

	this.messagesBodiesDom.subscribe(function(oDom) {
		if (oDom && !(oDom instanceof $))
		{
			this.messagesBodiesDom($(oDom));
		}
	}, this);

	this.messageListEndFolder.subscribe(function(sFolder) {
		var oMessage = this.message();
		if (oMessage && sFolder && sFolder !== oMessage.folderFullNameRaw)
		{
			this.message(null);
		}
	}, this);
};

MessageUserStore.prototype.purgeMessageBodyCache = function()
{
	var
		iCount = 0,
		oMessagesDom = null,
		iEnd = Globals.data.iMessageBodyCacheCount - Consts.MESSAGE_BODY_CACHE_LIMIT;

	if (0 < iEnd)
	{
		oMessagesDom = this.messagesBodiesDom();
		if (oMessagesDom)
		{
			oMessagesDom.find('.rl-cache-class').each(function() {
				var oItem = $(this);
				if (iEnd > oItem.data('rl-cache-count'))
				{
					oItem.addClass('rl-cache-purge');
					iCount += 1;
				}
			});

			if (0 < iCount)
			{
				_.delay(function() {
					oMessagesDom.find('.rl-cache-purge').remove();
				}, Enums.Magics.Time350ms);
			}
		}
	}
};

MessageUserStore.prototype.initUidNextAndNewMessages = function(sFolder, sUidNext, aNewMessages)
{
	if (Cache.getFolderInboxName() === sFolder && Utils.isNormal(sUidNext) && '' !== sUidNext)
	{
		if (Utils.isArray(aNewMessages) && 0 < aNewMessages.length)
		{
			var
				iIndex = 0,
				iLen = aNewMessages.length,
				NotificationStore = __webpack_require__(/*! Stores/User/Notification */ 62);

			_.each(aNewMessages, function(oItem) {
				Cache.addNewMessageCache(sFolder, oItem.Uid);
			});

			NotificationStore.playSoundNotification();

			if (3 < iLen)
			{
				NotificationStore.displayDesktopNotification(
					Links.notificationMailIcon(),
					__webpack_require__(/*! Stores/User/Account */ 28).email(),
					Translator.i18n('MESSAGE_LIST/NEW_MESSAGE_NOTIFICATION', {
						'COUNT': iLen
					}),
					{'Folder': '', 'Uid': ''}
				);
			}
			else
			{
				for (; iIndex < iLen; iIndex++)
				{
					NotificationStore.displayDesktopNotification(
						Links.notificationMailIcon(),
						MessageHelper.emailArrayToString(MessageHelper.emailArrayFromJson(aNewMessages[iIndex].From), false),
						aNewMessages[iIndex].Subject,
						{'Folder': aNewMessages[iIndex].Folder, 'Uid': aNewMessages[iIndex].Uid}
					);
				}
			}
		}

		Cache.setFolderUidNext(sFolder, sUidNext);
	}
};

MessageUserStore.prototype.hideMessageBodies = function()
{
	var oMessagesDom = this.messagesBodiesDom();
	if (oMessagesDom)
	{
		oMessagesDom.find('.b-text-part').hide();
	}
};

/**
 * @param {string} sFromFolderFullNameRaw
 * @param {Array} aUidForRemove
 * @param {string=} sToFolderFullNameRaw = ''
 * @param {bCopy=} bCopy = false
 */
MessageUserStore.prototype.removeMessagesFromList = function(
	sFromFolderFullNameRaw, aUidForRemove, sToFolderFullNameRaw, bCopy)
{
	sToFolderFullNameRaw = Utils.isNormal(sToFolderFullNameRaw) ? sToFolderFullNameRaw : '';
	bCopy = Utils.isUnd(bCopy) ? false : !!bCopy;

	aUidForRemove = _.map(aUidForRemove, function(mValue) {
		return Utils.pInt(mValue);
	});

	var
		self = this,
		iUnseenCount = 0,
		oMessage = null,
		sTrashFolder = FolderStore.trashFolder(),
		sSpamFolder = FolderStore.spamFolder(),
		aMessageList = this.messageList(),
		oFromFolder = Cache.getFolderFromCacheList(sFromFolderFullNameRaw),
		oToFolder = '' === sToFolderFullNameRaw ? null : Cache.getFolderFromCacheList(sToFolderFullNameRaw || ''),
		sCurrentFolderFullNameRaw = FolderStore.currentFolderFullNameRaw(),
		oCurrentMessage = this.message(),
		aMessages = sCurrentFolderFullNameRaw === sFromFolderFullNameRaw ? _.filter(aMessageList, function(item) {
			return item && -1 < Utils.inArray(Utils.pInt(item.uid), aUidForRemove);
		}) : [];

	_.each(aMessages, function(item) {
		if (item && item.unseen())
		{
			iUnseenCount += 1;
		}
	});

	if (oFromFolder && !bCopy)
	{
		oFromFolder.messageCountAll(0 <= oFromFolder.messageCountAll() - aUidForRemove.length ?
			oFromFolder.messageCountAll() - aUidForRemove.length : 0);

		if (0 < iUnseenCount)
		{
			oFromFolder.messageCountUnread(0 <= oFromFolder.messageCountUnread() - iUnseenCount ?
				oFromFolder.messageCountUnread() - iUnseenCount : 0);
		}
	}

	if (oToFolder)
	{
		if (sTrashFolder === oToFolder.fullNameRaw || sSpamFolder === oToFolder.fullNameRaw)
		{
			iUnseenCount = 0;
		}

		oToFolder.messageCountAll(oToFolder.messageCountAll() + aUidForRemove.length);
		if (0 < iUnseenCount)
		{
			oToFolder.messageCountUnread(oToFolder.messageCountUnread() + iUnseenCount);
		}

		oToFolder.actionBlink(true);
	}

	if (0 < aMessages.length)
	{
		if (bCopy)
		{
			_.each(aMessages, function(item) {
				item.checked(false);
			});
		}
		else
		{
			this.messageListIsNotCompleted(true);

			_.each(aMessages, function(item) {
				if (oCurrentMessage && oCurrentMessage.hash === item.hash)
				{
					oCurrentMessage = null;
					self.message(null);
				}

				item.deleted(true);
			});

			_.delay(function() {
				_.each(aMessages, function(item) {
					self.messageList.remove(item);
				});
			}, Enums.Magics.Time350ms);
		}
	}

	if ('' !== sFromFolderFullNameRaw)
	{
		Cache.setFolderHash(sFromFolderFullNameRaw, '');
	}

	if ('' !== sToFolderFullNameRaw)
	{
		Cache.setFolderHash(sToFolderFullNameRaw, '');
	}

	if ('' !== this.messageListThreadUid())
	{
		aMessageList = this.messageList();

		if (aMessageList && 0 < aMessageList.length && !!_.find(aMessageList, function(item) {
			return !!(item && item.deleted() && item.uid === self.messageListThreadUid());
		}))
		{
			oMessage = _.find(aMessageList, function(item) {
				return item && !item.deleted();
			});

			if (oMessage && this.messageListThreadUid() !== Utils.pString(oMessage.uid))
			{
				this.messageListThreadUid(Utils.pString(oMessage.uid));

				kn.setHash(Links.mailBox(
					FolderStore.currentFolderFullNameHash(),
					this.messageListPage(),
					this.messageListSearch(),
					this.messageListThreadUid()
				), true, true);
			}
			else if (!oMessage)
			{
				if (1 < this.messageListPage())
				{
					this.messageListPage(this.messageListPage() - 1);

					kn.setHash(Links.mailBox(
						FolderStore.currentFolderFullNameHash(),
						this.messageListPage(),
						this.messageListSearch(),
						this.messageListThreadUid()
					), true, true);
				}
				else
				{
					this.messageListThreadUid('');

					kn.setHash(Links.mailBox(
						FolderStore.currentFolderFullNameHash(),
						this.messageListPageBeforeThread(),
						this.messageListSearch()
					), true, true);
				}
			}
		}
	}
};

MessageUserStore.prototype.addBlockquoteSwitcherCallback = function()
{
	var $self = $(this);
	if ('' !== Utils.trim(($self.text())))
	{
		$self.addClass('rl-bq-switcher hidden-bq');
		$('<span class="rlBlockquoteSwitcher"><i class="icon-ellipsis" /></span>')
			.insertBefore($self)
			.on('click.rlBlockquoteSwitcher', function() {
				$self.toggleClass('hidden-bq');
				Utils.windowResize();
			})
			.after('<br />')
			.before('<br />');
	}
};

/**
 * @param {Object} oMessageTextBody
 */
MessageUserStore.prototype.initBlockquoteSwitcher = function(oMessageTextBody)
{
	if (oMessageTextBody)
	{
		var $oList = $('blockquote:not(.rl-bq-switcher)', oMessageTextBody).filter(function() {
			return 0 === $(this).parent().closest('blockquote', oMessageTextBody).length;
		});

		if ($oList && 0 < $oList.length)
		{
			$oList.each(this.addBlockquoteSwitcherCallback);
		}
	}
};

/**
 * @param {Object} oMessageTextBody
 */
MessageUserStore.prototype.initOpenPgpControls = function(oMessageTextBody, oMessage)
{
	if (oMessageTextBody && oMessageTextBody.find)
	{
		oMessageTextBody.find('.b-plain-openpgp:not(.inited)').each(function() {
			PgpStore.initMessageBodyControls($(this), oMessage);
		});
	}
};

MessageUserStore.prototype.setMessage = function(oData, bCached)
{
	var
		bNew = false,
		bIsHtml = false,
		bHasExternals = false,
		bHasInternals = false,
		oBody = null,
		oTextBody = null,
		sId = '',
		sPlain = '',
		sResultHtml = '',
		bPgpSigned = false,
		bPgpEncrypted = false,
		oMessagesDom = this.messagesBodiesDom(),
		oSelectedMessage = this.selectorMessageSelected(),
		oMessage = this.message(),
		aThreads = [];

	if (oData && oMessage && oData.Result && 'Object/Message' === oData.Result['@Object'] &&
		oMessage.folderFullNameRaw === oData.Result.Folder)
	{
		aThreads = oMessage.threads();
		if (oMessage.uid !== oData.Result.Uid && 1 < aThreads.length &&
			-1 < Utils.inArray(oData.Result.Uid, aThreads))
		{
			oMessage = MessageModel.newInstanceFromJson(oData.Result);
			if (oMessage)
			{
				oMessage.threads(aThreads);
				Cache.initMessageFlagsFromCache(oMessage);

				this.message(this.staticMessage.populateByMessageListItem(oMessage));
				oMessage = this.message();

				bNew = true;
			}
		}

		if (oMessage && oMessage.uid === oData.Result.Uid)
		{
			this.messageError('');

			oMessage.initUpdateByMessageJson(oData.Result);
			Cache.addRequestedMessage(oMessage.folderFullNameRaw, oMessage.uid);

			if (!bCached)
			{
				oMessage.initFlagsByJson(oData.Result);
			}

			oMessagesDom = oMessagesDom && oMessagesDom[0] ? oMessagesDom : null;
			if (oMessagesDom)
			{
				sId = 'rl-mgs-' + oMessage.hash.replace(/[^a-zA-Z0-9]/g, '');
				oTextBody = oMessagesDom.find('#' + sId);

				if (!oTextBody || !oTextBody[0])
				{
					bHasExternals = !!oData.Result.HasExternals;
					bHasInternals = !!oData.Result.HasInternals;

					if (Utils.isNormal(oData.Result.Html) && '' !== oData.Result.Html)
					{
						bIsHtml = true;
						sResultHtml = oData.Result.Html.toString();
					}
					else if (Utils.isNormal(oData.Result.Plain) && '' !== oData.Result.Plain)
					{
						bIsHtml = false;
						sResultHtml = Utils.plainToHtml(oData.Result.Plain.toString(), false);

						if ((oMessage.isPgpSigned() || oMessage.isPgpEncrypted()) && __webpack_require__(/*! Stores/User/Pgp */ 31).capaOpenPGP())
						{
							sPlain = Utils.pString(oData.Result.Plain);

							bPgpEncrypted = (/---BEGIN PGP MESSAGE---/).test(sPlain);
							if (!bPgpEncrypted)
							{
								bPgpSigned = (/-----BEGIN PGP SIGNED MESSAGE-----/).test(sPlain) &&
									(/-----BEGIN PGP SIGNATURE-----/).test(sPlain);
							}

							Globals.$div.empty();
							if (bPgpSigned && oMessage.isPgpSigned())
							{
								sResultHtml =
									Globals.$div.append(
										$('<pre class="b-plain-openpgp signed"></pre>').text(sPlain)
									).html();
							}
							else if (bPgpEncrypted && oMessage.isPgpEncrypted())
							{
								sResultHtml =
									Globals.$div.append(
										$('<pre class="b-plain-openpgp encrypted"></pre>').text(sPlain)
									).html();
							}
							else
							{
								sResultHtml = '<pre>' + sResultHtml + '</pre>';
							}

							sPlain = '';

							Globals.$div.empty();

							oMessage.isPgpSigned(bPgpSigned);
							oMessage.isPgpEncrypted(bPgpEncrypted);
						}
						else
						{
							sResultHtml = '<pre>' + sResultHtml + '</pre>';
						}
					}
					else
					{
						bIsHtml = false;
						sResultHtml = '<pre>' + sResultHtml + '</pre>';
					}

					Globals.data.iMessageBodyCacheCount += 1;

					oBody = $('<div id="' + sId + '" ></div>').hide().addClass('rl-cache-class');
					oBody.data('rl-cache-count', Globals.data.iMessageBodyCacheCount);

					oBody
						.html(Utils.findEmailAndLinks(sResultHtml))
						.addClass('b-text-part ' + (bIsHtml ? 'html' : 'plain'));

					oMessage.isHtml(!!bIsHtml);
					oMessage.hasImages(!!bHasExternals);

					oMessage.body = oBody;
					if (oMessage.body)
					{
						oMessagesDom.append(oMessage.body);
					}

					oMessage.storeDataInDom();

					if (bHasInternals)
					{
						oMessage.showInternalImages(true);
					}

					if (oMessage.hasImages() && SettingsStore.showImages())
					{
						oMessage.showExternalImages(true);
					}

					this.purgeMessageBodyCacheThrottle();
				}
				else
				{
					oMessage.body = oTextBody;
					if (oMessage.body)
					{
						Globals.data.iMessageBodyCacheCount += 1;
						oMessage.body.data('rl-cache-count', Globals.data.iMessageBodyCacheCount);
						oMessage.fetchDataFromDom();
					}
				}

				this.messageActiveDom(oMessage.body);

				this.hideMessageBodies();

				if (oBody)
				{
					this.initOpenPgpControls(oBody, oMessage);

					this.initBlockquoteSwitcher(oBody);
				}

				oMessage.body.show();
			}

			Cache.initMessageFlagsFromCache(oMessage);
			if (oMessage.unseen() || oMessage.hasUnseenSubMessage())
			{
				__webpack_require__(/*! App/User */ 8).default.messageListAction(oMessage.folderFullNameRaw,
					oMessage.uid, Enums.MessageSetAction.SetSeen, [oMessage]);
			}

			if (bNew)
			{
				oMessage = this.message();

				if (oSelectedMessage && oMessage && (
					oMessage.folderFullNameRaw !== oSelectedMessage.folderFullNameRaw ||
					oMessage.uid !== oSelectedMessage.uid
				))
				{
					this.selectorMessageSelected(null);
					if (1 === this.messageList().length)
					{
						this.selectorMessageFocused(null);
					}
				}
				else if (!oSelectedMessage && oMessage)
				{
					oSelectedMessage = _.find(this.messageList(), function(oSubMessage) {
						return oSubMessage &&
							oSubMessage.folderFullNameRaw === oMessage.folderFullNameRaw &&
							oSubMessage.uid === oMessage.uid;
					});

					if (oSelectedMessage)
					{
						this.selectorMessageSelected(oSelectedMessage);
						this.selectorMessageFocused(oSelectedMessage);
					}
				}

			}

			Utils.windowResize();
		}
	}
};

MessageUserStore.prototype.selectMessage = function(oMessage)
{
	if (oMessage)
	{
		this.message(this.staticMessage.populateByMessageListItem(oMessage));

		this.populateMessageBody(this.message());
	}
	else
	{
		this.message(null);
	}
};

MessageUserStore.prototype.selectMessageByFolderAndUid = function(sFolder, sUid)
{
	if (sFolder && sUid)
	{
		this.message(this.staticMessage.populateByMessageListItem(null));
		this.message().folderFullNameRaw = sFolder;
		this.message().uid = sUid;

		this.populateMessageBody(this.message());
	}
	else
	{
		this.message(null);
	}
};

MessageUserStore.prototype.populateMessageBody = function(oMessage)
{
	if (oMessage)
	{
		if (Remote.message(this.onMessageResponse, oMessage.folderFullNameRaw, oMessage.uid))
		{
			this.messageCurrentLoading(true);
		}
	}
};

/**
 * @param {string} sResult
 * @param {AjaxJsonDefaultResponse} oData
 * @param {boolean} bCached
 */
MessageUserStore.prototype.onMessageResponse = function(sResult, oData, bCached)
{
	this.hideMessageBodies();

	this.messageCurrentLoading(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.setMessage(oData, bCached);
	}
	else if (Enums.StorageResultType.Unload === sResult)
	{
		this.message(null);
		this.messageError('');
	}
	else if (Enums.StorageResultType.Abort !== sResult)
	{
		this.message(null);
		this.messageError((oData && oData.ErrorCode ?
			Translator.getNotification(oData.ErrorCode) :
			Translator.getNotification(Enums.Notification.UnknownError)));
	}
};

/**
 * @param {Array} aList
 * @returns {string}
 */
MessageUserStore.prototype.calculateMessageListHash = function(aList)
{
	return _.map(aList, function(oMessage) {
		return '' + oMessage.hash + '_' + oMessage.threadsLen() + '_' + oMessage.flagHash();
	}).join('|');
};

MessageUserStore.prototype.setMessageList = function(oData, bCached)
{
	if (oData && oData.Result && 'Collection/MessageCollection' === oData.Result['@Object'] &&
		oData.Result['@Collection'] && Utils.isArray(oData.Result['@Collection']))
	{
		var
			iIndex = 0,
			iLen = 0,
			iCount = 0,
			iOffset = 0,
			aList = [],
			oJsonMessage = null,
			oMessage = null,
			oFolder = null,
			iNewCount = 0,
			iUtc = __webpack_require__(/*! Common/Momentor */ 26).momentNowUnix(),
			bUnreadCountChange = false;

		iCount = Utils.pInt(oData.Result.MessageResultCount);
		iOffset = Utils.pInt(oData.Result.Offset);

		oFolder = Cache.getFolderFromCacheList(
			Utils.isNormal(oData.Result.Folder) ? oData.Result.Folder : '');

		if (oFolder && !bCached)
		{
			oFolder.interval = iUtc;

			Cache.setFolderHash(oData.Result.Folder, oData.Result.FolderHash);

			if (Utils.isNormal(oData.Result.MessageCount))
			{
				oFolder.messageCountAll(oData.Result.MessageCount);
			}

			if (Utils.isNormal(oData.Result.MessageUnseenCount))
			{
				if (Utils.pInt(oFolder.messageCountUnread()) !== Utils.pInt(oData.Result.MessageUnseenCount))
				{
					bUnreadCountChange = true;
				}

				oFolder.messageCountUnread(oData.Result.MessageUnseenCount);
			}

			this.initUidNextAndNewMessages(oFolder.fullNameRaw, oData.Result.UidNext, oData.Result.NewMessages);
		}

		if (bUnreadCountChange && oFolder)
		{
			Cache.clearMessageFlagsFromCacheByFolder(oFolder.fullNameRaw);
		}

		for (iIndex = 0, iLen = oData.Result['@Collection'].length; iIndex < iLen; iIndex++)
		{
			oJsonMessage = oData.Result['@Collection'][iIndex];
			if (oJsonMessage && 'Object/Message' === oJsonMessage['@Object'])
			{
				oMessage = MessageModel.newInstanceFromJson(oJsonMessage);
				if (oMessage)
				{
					if (Cache.hasNewMessageAndRemoveFromCache(oMessage.folderFullNameRaw, oMessage.uid) && 5 >= iNewCount)
					{
						iNewCount += 1;
						oMessage.newForAnimation(true);
					}

					oMessage.deleted(false);

					if (bCached)
					{
						Cache.initMessageFlagsFromCache(oMessage);
					}
					else
					{
						Cache.storeMessageFlagsToCache(oMessage);
					}

					aList.push(oMessage);
				}
			}
		}

		this.messageListCount(iCount);
		this.messageListSearch(Utils.isNormal(oData.Result.Search) ? oData.Result.Search : '');
		this.messageListPage(window.Math.ceil((iOffset / SettingsStore.messagesPerPage()) + 1));
		this.messageListThreadUid(Utils.isNormal(oData.Result.ThreadUid) ? Utils.pString(oData.Result.ThreadUid) : '');

		this.messageListEndFolder(Utils.isNormal(oData.Result.Folder) ? oData.Result.Folder : '');
		this.messageListEndSearch(this.messageListSearch());
		this.messageListEndThreadUid(this.messageListThreadUid());
		this.messageListEndPage(this.messageListPage());

		this.messageListDisableAutoSelect(true);

		this.messageList(aList);
		this.messageListIsNotCompleted(false);

		Cache.clearNewMessageCache();

		if (oFolder && (bCached || bUnreadCountChange || SettingsStore.useThreads()))
		{
			__webpack_require__(/*! App/User */ 8).default.folderInformation(oFolder.fullNameRaw, aList);
		}
	}
	else
	{
		this.messageListCount(0);
		this.messageList([]);
		this.messageListError(Translator.getNotification(
			oData && oData.ErrorCode ? oData.ErrorCode : Enums.Notification.CantGetMessageList
		));
	}
};

module.exports = new MessageUserStore();


/***/ },
/* 30 */
/*!*****************************!*\
  !*** ./dev/Model/Email.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "EmailModel", function() { return EmailModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return EmailModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }



var EmailModel = function () {
	/**
  * @param {string=} email = ''
  * @param {string=} name = ''
  * @param {string=} dkimStatus = 'none'
  * @param {string=} dkimValue = ''
  */

	function EmailModel() {
		var email = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];
		var name = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
		var dkimStatus = arguments.length <= 2 || arguments[2] === undefined ? 'none' : arguments[2];
		var dkimValue = arguments.length <= 3 || arguments[3] === undefined ? '' : arguments[3];

		_classCallCheck(this, EmailModel);

		this.email = email;
		this.name = name;
		this.dkimStatus = dkimStatus;
		this.dkimValue = dkimValue;

		this.clearDuplicateName();
	}

	/**
  * @static
  * @param {AjaxJsonEmail} json
  * @returns {?EmailModel}
  */


	EmailModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var email = new EmailModel();
		return email.initByJson(json) ? email : null;
	};

	/**
  * @static
  * @param {string} line
  * @param {string=} delimiter = ';'
  * @returns {Array}
  */


	EmailModel.splitHelper = function splitHelper(line) {
		var delimiter = arguments.length <= 1 || arguments[1] === undefined ? ';' : arguments[1];

		line = line.replace(/[\r\n]+/g, '; ').replace(/[\s]+/g, ' ');

		var index = 0,
		    len = 0,
		    at = false,
		    char = '',
		    result = '';

		for (len = line.length; index < len; index++) {
			char = line.charAt(index);
			switch (char) {
				case '@':
					at = true;
					break;
				case ' ':
					if (at) {
						at = false;
						result += delimiter;
					}
					break;
				// no default
			}

			result += char;
		}

		return result.split(delimiter);
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clear = function clear() {
		this.email = '';
		this.name = '';

		this.dkimStatus = 'none';
		this.dkimValue = '';
	};

	/**
  * @returns {boolean}
  */


	EmailModel.prototype.validate = function validate() {
		return '' !== this.name || '' !== this.email;
	};

	/**
  * @param {boolean} withoutName = false
  * @returns {string}
  */


	EmailModel.prototype.hash = function hash() {
		var withoutName = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		return '#' + (withoutName ? '' : this.name) + '#' + this.email + '#';
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clearDuplicateName = function clearDuplicateName() {
		if (this.name === this.email) {
			this.name = '';
		}
	};

	/**
  * @param {string} query
  * @returns {boolean}
  */


	EmailModel.prototype.search = function search(query) {
		return -1 < (this.name + ' ' + this.email).toLowerCase().indexOf(query.toLowerCase());
	};

	/**
  * @param {string} str
  */


	EmailModel.prototype.parse = function parse(str) {
		this.clear();

		str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(str);

		var regex = /(?:"([^"]+)")? ?[<]?(.*?@[^>,]+)>?,? ?/g,
		    match = regex.exec(str);

		if (match) {
			this.name = match[1] || '';
			this.email = match[2] || '';

			this.clearDuplicateName();
		} else if (/^[^@]+@[^@]+$/.test(str)) {
			this.name = '';
			this.email = str;
		}
	};

	/**
  * @param {AjaxJsonEmail} oJsonEmail
  * @returns {boolean}
  */


	EmailModel.prototype.initByJson = function initByJson(json) {
		var result = false;
		if (json && 'Object/Email' === json['@Object']) {
			this.name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.Name);
			this.email = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.Email);
			this.dkimStatus = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.DkimStatus || '');
			this.dkimValue = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.DkimValue || '');

			result = '' !== this.email;
			this.clearDuplicateName();
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @param {boolean=} useEncodeHtml = false
  * @returns {string}
  */


	EmailModel.prototype.toLine = function toLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
		var useEncodeHtml = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

		var result = '';
		if ('' !== this.email) {
			if (friendlyView && '' !== this.name) {
				result = wrapWithLink ? '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.name) + '</a>' : __WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"] ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.name) : this.name;
			} else {
				result = this.email;
				if ('' !== this.name) {
					if (wrapWithLink) {
						result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <') + '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(result) + '</a>' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('>');
					} else {
						result = '"' + this.name + '" <' + result + '>';
						if (useEncodeHtml) {
							result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(result);
						}
					}
				} else if (wrapWithLink) {
					result = '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.email) + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.email) + '</a>';
				}
			}
		}

		return result;
	};

	/**
  * @param {string} $sEmailAddress
  * @returns {boolean}
  */


	EmailModel.prototype.mailsoParse = function mailsoParse($sEmailAddress) {
		$sEmailAddress = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sEmailAddress);
		if ('' === $sEmailAddress) {
			return false;
		}

		var substr = function substr(str, start, len) {
			str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pString"])(str);
			var end = str.length;

			if (0 > start) {
				start += end;
			}

			end = 'undefined' === typeof len ? end : 0 > len ? len + end : len + start;

			return start >= str.length || 0 > start || start > end ? false : str.slice(start, end);
		},
		    substrReplace = function substrReplace(str, replace, start, length) {
			str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pString"])(str);
			if (0 > start) {
				start += str.length;
			}

			length = 'undefined' !== typeof length ? length : str.length;
			if (0 > length) {
				length = length + str.length - start;
			}
			return str.slice(0, start) + replace.substr(0, length) + replace.slice(length) + str.slice(start + length);
		},
		    $sName = '',
		    $sEmail = '',
		    $sComment = '',
		    $bInName = false,
		    $bInAddress = false,
		    $bInComment = false,
		    $aRegs = null,
		    $iStartIndex = 0,
		    $iEndIndex = 0,
		    $iCurrentIndex = 0;

		while ($iCurrentIndex < $sEmailAddress.length) {
			switch ($sEmailAddress.substr($iCurrentIndex, 1)) {
				case '"':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInName = true;
						$iStartIndex = $iCurrentIndex;
					} else if (!$bInAddress && !$bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sName = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInName = false;
					}
					break;
				case '<':
					if (!$bInName && !$bInAddress && !$bInComment) {
						if (0 < $iCurrentIndex && 0 === $sName.length) {
							$sName = substr($sEmailAddress, 0, $iCurrentIndex);
						}

						$bInAddress = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case '>':
					if ($bInAddress) {
						$iEndIndex = $iCurrentIndex;
						$sEmail = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInAddress = false;
					}
					break;
				case '(':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInComment = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case ')':
					if ($bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sComment = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInComment = false;
					}
					break;
				case '\\':
					$iCurrentIndex += 1;
					break;
				// no default
			}

			$iCurrentIndex += 1;
		}

		if (0 === $sEmail.length) {
			$aRegs = $sEmailAddress.match(/[^@\s]+@\S+/i);
			if ($aRegs && $aRegs[0]) {
				$sEmail = $aRegs[0];
			} else {
				$sName = $sEmailAddress;
			}
		}

		if (0 < $sEmail.length && 0 === $sName.length && 0 === $sComment.length) {
			$sName = $sEmailAddress.replace($sEmail, '');
		}

		$sEmail = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sEmail).replace(/^[<]+/, '').replace(/[>]+$/, '');
		$sName = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sName).replace(/^["']+/, '').replace(/["']+$/, '');
		$sComment = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sComment).replace(/^[(]+/, '').replace(/[)]+$/, '');

		// Remove backslash
		$sName = $sName.replace(/\\\\(.)/g, '$1');
		$sComment = $sComment.replace(/\\\\(.)/g, '$1');

		this.name = $sName;
		this.email = $sEmail;

		this.clearDuplicateName();
		return true;
	};

	return EmailModel;
}();



/***/ },
/* 31 */
/*!********************************!*\
  !*** ./dev/Stores/User/Pgp.js ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	$ = __webpack_require__(/*! $ */ 10),
	kn = __webpack_require__(/*! Knoin/Knoin */ 4),

	Translator = __webpack_require__(/*! Common/Translator */ 6),
	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Utils = __webpack_require__(/*! Common/Utils */ 0);

/**
 * @constructor
 */
function PgpUserStore()
{
	this.capaOpenPGP = ko.observable(false);

	this.openpgp = null;

	this.openpgpkeys = ko.observableArray([]);
	this.openpgpKeyring = null;

	this.openpgpkeysPublic = this.openpgpkeys.filter(function(oItem) {
		return !!(oItem && !oItem.isPrivate);
	});

	this.openpgpkeysPrivate = this.openpgpkeys.filter(function(oItem) {
		return !!(oItem && oItem.isPrivate);
	});
}

/**
 * @returns {boolean}
 */
PgpUserStore.prototype.isSupported = function()
{
	return !!this.openpgp;
};

PgpUserStore.prototype.findKeyByHex = function(aKeys, sHash)
{
	return _.find(aKeys, function(oItem) {
		return sHash && oItem && (sHash === oItem.id || -1 < oItem.ids.indexOf(sHash));
	});
};

PgpUserStore.prototype.findPublicKeyByHex = function(sHash)
{
	return this.findKeyByHex(this.openpgpkeysPublic(), sHash);
};

PgpUserStore.prototype.findPrivateKeyByHex = function(sHash)
{
	return this.findKeyByHex(this.openpgpkeysPrivate(), sHash);
};

PgpUserStore.prototype.findPublicKeysByEmail = function(sEmail)
{
	return _.compact(_.flatten(_.map(this.openpgpkeysPublic(), function(oItem) {
		var oKey = oItem && -1 < oItem.emails.indexOf(sEmail) ? oItem : null;
		return oKey ? oKey.getNativeKeys() : [null];
	}), true));
};

PgpUserStore.prototype.findPublicKeysBySigningKeyIds = function(aSigningKeyIds)
{
	var self = this;
	return _.compact(_.flatten(_.map(aSigningKeyIds, function(oId) {
		var oKey = oId && oId.toHex ? self.findPublicKeyByHex(oId.toHex()) : null;
		return oKey ? oKey.getNativeKeys() : [null];
	}), true));
};

PgpUserStore.prototype.findPrivateKeysByEncryptionKeyIds = function(aEncryptionKeyIds, aRecipients, bReturnWrapKeys)
{
	var self = this, aResult = [];
	aResult = Utils.isArray(aEncryptionKeyIds) ? _.compact(_.flatten(_.map(aEncryptionKeyIds, function(oId) {
		var oKey = oId && oId.toHex ? self.findPrivateKeyByHex(oId.toHex()) : null;
		return oKey ? (bReturnWrapKeys ? [oKey] : oKey.getNativeKeys()) : [null];
	}), true)) : [];

	if (0 === aResult.length && Utils.isNonEmptyArray(aRecipients))
	{
		aResult = _.uniq(_.compact(_.flatten(_.map(aRecipients, function(sEmail) {
			var aKeys = sEmail ? self.findAllPrivateKeysByEmailNotNative(sEmail) : null;
			return aKeys ? (bReturnWrapKeys ? aKeys : _.flatten(_.map(aKeys, function(oKey) {
				return oKey.getNativeKeys();
			}), true)) : [null];
		}), true)), function(oKey) {return oKey.id;});
	}

	return aResult;
};

/**
 * @param {string} sEmail
 * @returns {?}
 */
PgpUserStore.prototype.findPublicKeyByEmailNotNative = function(sEmail)
{
	return _.find(this.openpgpkeysPublic(), function(oItem) {
		return oItem && -1 < oItem.emails.indexOf(sEmail);
	}) || null;
};

/**
 * @param {string} sEmail
 * @returns {?}
 */
PgpUserStore.prototype.findPrivateKeyByEmailNotNative = function(sEmail)
{
	return _.find(this.openpgpkeysPrivate(), function(oItem) {
		return oItem && -1 < oItem.emails.indexOf(sEmail);
	}) || null;
};

/**
 * @param {string} sEmail
 * @returns {?}
 */
PgpUserStore.prototype.findAllPublicKeysByEmailNotNative = function(sEmail)
{
	return _.filter(this.openpgpkeysPublic(), function(oItem) {
		return oItem && -1 < oItem.emails.indexOf(sEmail);
	}) || null;
};

/**
 * @param {string} sEmail
 * @returns {?}
 */
PgpUserStore.prototype.findAllPrivateKeysByEmailNotNative = function(sEmail)
{
	return _.filter(this.openpgpkeysPrivate(), function(oItem) {
		return oItem && -1 < oItem.emails.indexOf(sEmail);
	}) || null;
};

/**
 * @param {string} sEmail
 * @param {string=} sPassword
 * @returns {?}
 */
PgpUserStore.prototype.findPrivateKeyByEmail = function(sEmail, sPassword)
{
	var
		oPrivateKeys = [],
		oPrivateKey = null,
		oKey = _.find(this.openpgpkeysPrivate(), function(oItem) {
			return oItem && -1 < oItem.emails.indexOf(sEmail);
		});

	if (oKey)
	{
		oPrivateKeys = oKey.getNativeKeys();
		oPrivateKey = oPrivateKeys[0] || null;

		try
		{
			if (oPrivateKey)
			{
				oPrivateKey.decrypt(Utils.pString(sPassword));
			}
		}
		catch (e)
		{
			oPrivateKey = null;
		}
	}

	return oPrivateKey;
};

/**
 * @param {string=} sPassword
 * @returns {?}
 */
PgpUserStore.prototype.findSelfPrivateKey = function(sPassword)
{
	return this.findPrivateKeyByEmail(__webpack_require__(/*! Stores/User/Account */ 28).email(), sPassword);
};

PgpUserStore.prototype.decryptMessage = function(oMessage, aRecipients, fCallback)
{
	var self = this, aPrivateKeys = [];
	if (oMessage && oMessage.getEncryptionKeyIds)
	{
		aPrivateKeys = this.findPrivateKeysByEncryptionKeyIds(oMessage.getEncryptionKeyIds(), aRecipients, true);
		if (aPrivateKeys && 0 < aPrivateKeys.length)
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/MessageOpenPgp */ 145), [function(oDecryptedKey) {

				if (oDecryptedKey)
				{
					oMessage.decrypt(oDecryptedKey).then(function(oDecryptedMessage) {
						var oPrivateKey = null;
						if (oDecryptedMessage)
						{
							oPrivateKey = self.findPrivateKeyByHex(oDecryptedKey.primaryKey.keyid.toHex());
							if (oPrivateKey)
							{
								self.verifyMessage(oDecryptedMessage, function(oValidKey, aSigningKeyIds) {
									fCallback(oPrivateKey, oDecryptedMessage, oValidKey || null, aSigningKeyIds || null);
								});
							}
							else
							{
								fCallback(oPrivateKey, oDecryptedMessage);
							}
						}
						else
						{
							fCallback(oPrivateKey, oDecryptedMessage);
						}

					}, function() {
						fCallback(null, null);
					});
				}
				else
				{
					fCallback(null, null);
				}

			}, aPrivateKeys]);

			return false;
		}
	}

	fCallback(null, null);

	return false;
};

PgpUserStore.prototype.findKeyExternal = function(sEmail, fCallback)
{
	if (this.openpgp.HKP && Settings.appSettingsGet('openpgpPublicKeyServer'))
	{
		var oHkp = new this.openpgp.HKP(Settings.appSettingsGet('openpgpPublicKeyServer').replace(/\/$/, ''));
		oHkp.lookup({query: sEmail}).then(function(sKey) {
			fCallback(sKey);
		}, function() {
			fCallback(null);
		});
	}
	else
	{
		fCallback(null);
	}
};

PgpUserStore.prototype.verifyMessage = function(oMessage, fCallback)
{
	var oValid = null, aResult = [], aPublicKeys = [], aSigningKeyIds = [];
	if (oMessage && oMessage.getSigningKeyIds)
	{
		aSigningKeyIds = oMessage.getSigningKeyIds();
		if (aSigningKeyIds && 0 < aSigningKeyIds.length)
		{
//				this.findKeyExternal('support@rainloop.net', function(key) {
//					console.log(key);
//				});

			aPublicKeys = this.findPublicKeysBySigningKeyIds(aSigningKeyIds);
			if (aPublicKeys && 0 < aPublicKeys.length)
			{
				try
				{
					aResult = oMessage.verify(aPublicKeys);
					oValid = _.find(_.isArray(aResult) ? aResult : [], function(oItem) {
						return oItem && oItem.valid && oItem.keyid;
					});

					if (oValid && oValid.keyid && oValid.keyid && oValid.keyid.toHex)
					{
						fCallback(this.findPublicKeyByHex(oValid.keyid.toHex()));
						return true;
					}
				}
				catch (e)
				{
					Utils.log(e);
				}
			}

			fCallback(null, aSigningKeyIds);
			return false;
		}
	}

	fCallback(null);
	return false;
};

/**
 * @param {*} mDom
 */
PgpUserStore.prototype.controlsHelper = function(mDom, oVerControl, bSuccess, sTitle, sText)
{
	if (bSuccess)
	{
		mDom.removeClass('error').addClass('success').attr('title', sTitle);
		oVerControl.removeClass('error').addClass('success').attr('title', sTitle);
	}
	else
	{
		mDom.removeClass('success').addClass('error').attr('title', sTitle);
		oVerControl.removeClass('success').addClass('error').attr('title', sTitle);
	}

	if (!Utils.isUnd(sText))
	{
		mDom.text(Utils.trim(sText.replace(/(\u200C|\u0002)/g, '')));
	}
};

/**
 * @static
 */
PgpUserStore.domControlEncryptedClickHelper = function(store, mDom, sArmoredMessage, aRecipients)
{
	return function() {

		var oMessage = null, $this = $(this);

		if ($this.hasClass('success'))
		{
			return false;
		}

		try
		{
			oMessage = store.openpgp.message.readArmored(sArmoredMessage);
		}
		catch (e)
		{
			Utils.log(e);
		}

		if (oMessage && oMessage.getText && oMessage.verify && oMessage.decrypt)
		{
			store.decryptMessage(oMessage, aRecipients, function(oValidPrivateKey, oDecryptedMessage, oValidPublicKey, aSigningKeyIds) {

				if (oDecryptedMessage)
				{
					if (oValidPublicKey)
					{
						store.controlsHelper(mDom, $this, true, Translator.i18n('PGP_NOTIFICATIONS/GOOD_SIGNATURE', {
							'USER': oValidPublicKey.user + ' (' + oValidPublicKey.id + ')'
						}), oDecryptedMessage.getText());
					}
					else if (oValidPrivateKey)
					{
						var
							aKeyIds = Utils.isNonEmptyArray(aSigningKeyIds) ? aSigningKeyIds : null,
							sAdditional = aKeyIds ? _.compact(_.map(aKeyIds, function(oItem) {
								return oItem && oItem.toHex ? oItem.toHex() : null;
							})).join(', ') : '';

						store.controlsHelper(mDom, $this, false,
							Translator.i18n('PGP_NOTIFICATIONS/UNVERIFIRED_SIGNATURE') +
								(sAdditional ? ' (' + sAdditional + ')' : ''),
								oDecryptedMessage.getText());
					}
					else
					{
						store.controlsHelper(mDom, $this, false,
							Translator.i18n('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
					}
				}
				else
				{
					store.controlsHelper(mDom, $this, false,
						Translator.i18n('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
				}
			});

			return false;
		}

		store.controlsHelper(mDom, $this, false, Translator.i18n('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
		return false;
	};
};

/**
 * @static
 */
PgpUserStore.domControlSignedClickHelper = function(store, mDom, sArmoredMessage)
{
	return function() {

		var oMessage = null, $this = $(this);
		if ($this.hasClass('success') || $this.hasClass('error'))
		{
			return false;
		}

		try
		{
			oMessage = store.openpgp.cleartext.readArmored(sArmoredMessage);
		}
		catch (e)
		{
			Utils.log(e);
		}

		if (oMessage && oMessage.getText && oMessage.verify)
		{
			store.verifyMessage(oMessage, function(oValidKey, aSigningKeyIds) {
				if (oValidKey)
				{
					store.controlsHelper(mDom, $this, true, Translator.i18n('PGP_NOTIFICATIONS/GOOD_SIGNATURE', {
						'USER': oValidKey.user + ' (' + oValidKey.id + ')'
					}), oMessage.getText());
				}
				else
				{
					var
						aKeyIds = Utils.isNonEmptyArray(aSigningKeyIds) ? aSigningKeyIds : null,
						sAdditional = aKeyIds ? _.compact(_.map(aKeyIds, function(oItem) {
							return oItem && oItem.toHex ? oItem.toHex() : null;
						})).join(', ') : '';

					store.controlsHelper(mDom, $this, false,
						Translator.i18n('PGP_NOTIFICATIONS/UNVERIFIRED_SIGNATURE') +
							(sAdditional ? ' (' + sAdditional + ')' : ''));
				}
			});

			return false;
		}

		store.controlsHelper(mDom, $this, false, Translator.i18n('PGP_NOTIFICATIONS/DECRYPTION_ERROR'));
		return false;
	};
};

/**
 * @param {*} mDom
 * @param {MessageModel} oRainLoopMessage
 */
PgpUserStore.prototype.initMessageBodyControls = function(mDom, oRainLoopMessage)
{
	if (mDom && !mDom.hasClass('inited'))
	{
		mDom.addClass('inited');

		var
			bEncrypted = mDom.hasClass('encrypted'),
			bSigned = mDom.hasClass('signed'),
			oVerControl = null,
			aRecipients = oRainLoopMessage ? oRainLoopMessage.getEmails(['from', 'to', 'cc']) : [],
			sData = '';

		if (bEncrypted || bSigned)
		{
			sData = mDom.text();
			mDom.data('openpgp-original', sData);

			if (bEncrypted)
			{
				oVerControl = $('<div class="b-openpgp-control"><i class="icon-lock"></i></div>')
					.attr('title', Translator.i18n('MESSAGE/PGP_ENCRYPTED_MESSAGE_DESC'))
					.on('click', PgpUserStore.domControlEncryptedClickHelper(this, mDom, sData, aRecipients));
			}
			else if (bSigned)
			{
				oVerControl = $('<div class="b-openpgp-control"><i class="icon-lock"></i></div>')
					.attr('title', Translator.i18n('MESSAGE/PGP_SIGNED_MESSAGE_DESC'))
					.on('click', PgpUserStore.domControlSignedClickHelper(this, mDom, sData));
			}

			if (oVerControl)
			{
				mDom.before(oVerControl).before('<div></div>');
			}
		}
	}
};

module.exports = new PgpUserStore();


/***/ },
/* 32 */
/*!*****************************************!*\
  !*** ./dev/Component/AbstractInput.jsx ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractInput; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AbstractInput = function (_AbstractComponent) {
	_inherits(AbstractInput, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function AbstractInput(params) {
		_classCallCheck(this, AbstractInput);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.value = params.value || '';
		_this.size = params.size || 0;
		_this.label = params.label || '';
		_this.preLabel = params.preLabel || '';
		_this.enable = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.enable) ? true : params.enable;
		_this.trigger = params.trigger && params.trigger.subscribe ? params.trigger : null;
		_this.placeholder = params.placeholder || '';

		_this.labeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.label);
		_this.preLabeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.preLabel);
		_this.triggered = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.trigger) && !!_this.trigger;

		_this.classForTrigger = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.className = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {

			var size = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.unwrap(_this.size),
			    suffixValue = _this.trigger ? ' ' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])('settings-saved-trigger-input ' + _this.classForTrigger()) : '';

			return (0 < size ? 'span' + size : '') + suffixValue;
		}, _this);

		if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.width) && params.element) {
			params.element.find('input,select,textarea').css('width', params.width);
		}

		_this.disposable.push(_this.className);

		if (_this.trigger) {
			_this.setTriggerState(_this.trigger());

			_this.disposable.push(_this.trigger.subscribe(_this.setTriggerState, _this));
		}
		return _this;
	}

	AbstractInput.prototype.setTriggerState = function setTriggerState(value) {
		switch (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.classForTrigger('success');
				break;
			case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.classForTrigger('error');
				break;
			default:
				this.classForTrigger('');
				break;
		}
	};

	return AbstractInput;
}(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 33 */
/*!******************************!*\
  !*** external "window.JSON" ***!
  \******************************/
/***/ function(module, exports) {

module.exports = window.JSON;

/***/ },
/* 34 */
/*!******************************!*\
  !*** ./dev/Stores/Social.js ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function SocialStore()
{
	this.google = {};
	this.twitter = {};
	this.facebook = {};
	this.dropbox = {};

	// Google
	this.google.enabled = ko.observable(false);

	this.google.clientID = ko.observable('');
	this.google.clientSecret = ko.observable('');
	this.google.apiKey = ko.observable('');

	this.google.loading = ko.observable(false);
	this.google.userName = ko.observable('');

	this.google.loggined = ko.computed(function() {
		return '' !== this.google.userName();
	}, this);

	this.google.capa = {};
	this.google.capa.auth = ko.observable(false);
	this.google.capa.authFast = ko.observable(false);
	this.google.capa.drive = ko.observable(false);
	this.google.capa.preview = ko.observable(false);

	this.google.require = {};
	this.google.require.clientSettings = ko.computed(function() {
		return this.google.enabled() && (this.google.capa.auth() || this.google.capa.drive());
	}, this);

	this.google.require.apiKeySettings = ko.computed(function() {
		return this.google.enabled() && this.google.capa.drive();
	}, this);

	// Facebook
	this.facebook.enabled = ko.observable(false);
	this.facebook.appID = ko.observable('');
	this.facebook.appSecret = ko.observable('');
	this.facebook.loading = ko.observable(false);
	this.facebook.userName = ko.observable('');
	this.facebook.supported = ko.observable(false);

	this.facebook.loggined = ko.computed(function() {
		return '' !== this.facebook.userName();
	}, this);

	// Twitter
	this.twitter.enabled = ko.observable(false);
	this.twitter.consumerKey = ko.observable('');
	this.twitter.consumerSecret = ko.observable('');
	this.twitter.loading = ko.observable(false);
	this.twitter.userName = ko.observable('');

	this.twitter.loggined = ko.computed(function() {
		return '' !== this.twitter.userName();
	}, this);

	// Dropbox
	this.dropbox.enabled = ko.observable(false);
	this.dropbox.apiKey = ko.observable('');
}

SocialStore.prototype.google = {};
SocialStore.prototype.twitter = {};
SocialStore.prototype.facebook = {};
SocialStore.prototype.dropbox = {};

SocialStore.prototype.populate = function()
{
	var Settings = __webpack_require__(/*! Storage/Settings */ 7);

	this.google.enabled(!!Settings.settingsGet('AllowGoogleSocial'));
	this.google.clientID(Settings.settingsGet('GoogleClientID'));
	this.google.clientSecret(Settings.settingsGet('GoogleClientSecret'));
	this.google.apiKey(Settings.settingsGet('GoogleApiKey'));

	this.google.capa.auth(!!Settings.settingsGet('AllowGoogleSocialAuth'));
	this.google.capa.authFast(!!Settings.settingsGet('AllowGoogleSocialAuthFast'));
	this.google.capa.drive(!!Settings.settingsGet('AllowGoogleSocialDrive'));
	this.google.capa.preview(!!Settings.settingsGet('AllowGoogleSocialPreview'));

	this.facebook.enabled(!!Settings.settingsGet('AllowFacebookSocial'));
	this.facebook.appID(Settings.settingsGet('FacebookAppID'));
	this.facebook.appSecret(Settings.settingsGet('FacebookAppSecret'));
	this.facebook.supported(!!Settings.settingsGet('SupportedFacebookSocial'));

	this.twitter.enabled = ko.observable(!!Settings.settingsGet('AllowTwitterSocial'));
	this.twitter.consumerKey = ko.observable(Settings.settingsGet('TwitterConsumerKey'));
	this.twitter.consumerSecret = ko.observable(Settings.settingsGet('TwitterConsumerSecret'));

	this.dropbox.enabled(!!Settings.settingsGet('AllowDropboxSocial'));
	this.dropbox.apiKey(Settings.settingsGet('DropboxApiKey'));
};

module.exports = new SocialStore();


/***/ },
/* 35 */,
/* 36 */
/*!************************************!*\
  !*** ./dev/Component/Checkbox.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 46);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var CheckboxComponent = function (_AbstracCheckbox) {
  _inherits(CheckboxComponent, _AbstracCheckbox);

  function CheckboxComponent() {
    _classCallCheck(this, CheckboxComponent);

    return _possibleConstructorReturn(this, _AbstracCheckbox.apply(this, arguments));
  }

  return CheckboxComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(CheckboxComponent, 'CheckboxComponent');

/***/ },
/* 37 */
/*!*********************************!*\
  !*** external "window.Promise" ***!
  \*********************************/
/***/ function(module, exports) {

module.exports = window.Promise;

/***/ },
/* 38 */
/*!********************************!*\
  !*** ./dev/Stores/Language.js ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function LanguageStore()
{
	this.languages = ko.observableArray([]);
	this.languagesAdmin = ko.observableArray([]);

	this.language = ko.observable('')
		.extend({'limitedList': this.languages})
		.extend({'reversible': true});

	this.languageAdmin = ko.observable('')
		.extend({'limitedList': this.languagesAdmin})
		.extend({'reversible': true});

	this.userLanguage = ko.observable('');
	this.userLanguageAdmin = ko.observable('');
}

LanguageStore.prototype.populate = function()
{
	var
		aLanguages = Settings.appSettingsGet('languages'),
		aLanguagesAdmin = Settings.appSettingsGet('languagesAdmin');

	this.languages(Utils.isArray(aLanguages) ? aLanguages : []);
	this.languagesAdmin(Utils.isArray(aLanguagesAdmin) ? aLanguagesAdmin : []);

	this.language(Settings.settingsGet('Language'));
	this.languageAdmin(Settings.settingsGet('LanguageAdmin'));

	this.userLanguage(Settings.settingsGet('UserLanguage'));
	this.userLanguageAdmin(Settings.settingsGet('UserLanguageAdmin'));
};

module.exports = new LanguageStore();


/***/ },
/* 39 */
/*!*******************************!*\
  !*** ./dev/View/Popup/Ask.js ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AskPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsAsk');

	this.askDesc = ko.observable('');
	this.yesButton = ko.observable('');
	this.noButton = ko.observable('');

	this.yesFocus = ko.observable(false);
	this.noFocus = ko.observable(false);

	this.fYesAction = null;
	this.fNoAction = null;

	this.bFocusYesOnShow = true;
	this.bDisabeCloseOnEsc = true;
	this.sDefaultKeyScope = Enums.KeyState.PopupAsk;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Ask', 'PopupsAskViewModel'], AskPopupView);
_.extend(AskPopupView.prototype, AbstractView.prototype);

AskPopupView.prototype.clearPopup = function()
{
	this.askDesc('');
	this.yesButton(Translator.i18n('POPUPS_ASK/BUTTON_YES'));
	this.noButton(Translator.i18n('POPUPS_ASK/BUTTON_NO'));

	this.yesFocus(false);
	this.noFocus(false);

	this.fYesAction = null;
	this.fNoAction = null;
};

AskPopupView.prototype.yesClick = function()
{
	this.cancelCommand();

	if (Utils.isFunc(this.fYesAction))
	{
		this.fYesAction.call(null);
	}
};

AskPopupView.prototype.noClick = function()
{
	this.cancelCommand();

	if (Utils.isFunc(this.fNoAction))
	{
		this.fNoAction.call(null);
	}
};

/**
 * @param {string} sAskDesc
 * @param {Function=} fYesFunc
 * @param {Function=} fNoFunc
 * @param {string=} sYesButton
 * @param {string=} sNoButton
 * @param {boolean=} bFocusYesOnShow
 * @returns {void}
 */
AskPopupView.prototype.onShow = function(sAskDesc, fYesFunc, fNoFunc, sYesButton, sNoButton, bFocusYesOnShow)
{
	this.clearPopup();

	this.fYesAction = fYesFunc || null;
	this.fNoAction = fNoFunc || null;

	this.askDesc(sAskDesc || '');

	if (sYesButton)
	{
		this.yesButton(sYesButton);
	}

	if (sNoButton)
	{
		this.noButton(sNoButton);
	}

	this.bFocusYesOnShow = Utils.isUnd(bFocusYesOnShow) ? true : !!bFocusYesOnShow;
};

AskPopupView.prototype.onShowWithDelay = function()
{
	if (this.bFocusYesOnShow)
	{
		this.yesFocus(true);
	}
};

AskPopupView.prototype.onBuild = function()
{
	key('tab, shift+tab, right, left', Enums.KeyState.PopupAsk, _.bind(function() {
		if (this.yesFocus())
		{
			this.noFocus(true);
		}
		else
		{
			this.yesFocus(true);
		}
		return false;
	}, this));

	key('esc', Enums.KeyState.PopupAsk, _.bind(function() {
		this.noClick();
		return false;
	}, this));
};

module.exports = AskPopupView;


/***/ },
/* 40 */
/*!**************************************!*\
  !*** ./dev/Knoin/AbstractScreen.jsx ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_crossroads__ = __webpack_require__(/*! crossroads */ 48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_crossroads___default = __WEBPACK_IMPORTED_MODULE_1_crossroads__ && __WEBPACK_IMPORTED_MODULE_1_crossroads__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_crossroads__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_crossroads__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_crossroads___default, 'a', __WEBPACK_IMPORTED_MODULE_1_crossroads___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractScreen = function () {
	function AbstractScreen(screenName) {
		var viewModels = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

		_classCallCheck(this, AbstractScreen);

		this.oCross = null;
		this.sScreenName = screenName;
		this.aViewModels = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(viewModels) ? viewModels : [];
	}

	/**
  * @returns {Array}
  */


	AbstractScreen.prototype.viewModels = function viewModels() {
		return this.aViewModels;
	};

	/**
  * @returns {string}
  */


	AbstractScreen.prototype.screenName = function screenName() {
		return this.sScreenName;
	};

	/**
  * @returns {?Array)}
  */


	AbstractScreen.prototype.routes = function routes() {
		return null;
	};

	/**
  * @returns {?Object}
  */


	AbstractScreen.prototype.__cross = function __cross() {
		return this.oCross;
	};

	/**
  * @returns {void}
  */


	AbstractScreen.prototype.__start = function __start() {
		var route = null,
		    fMatcher = null;
		var routes = this.routes();

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isNonEmptyArray"])(routes)) {
			fMatcher = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(this.onRoute || __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["noop"], this);
			route = __WEBPACK_IMPORTED_MODULE_1_crossroads___default.a.create();

			__WEBPACK_IMPORTED_MODULE_0_____default.a.each(routes, function (aItem) {
				route.addRoute(aItem[0], fMatcher).rules = aItem[1];
			});

			this.oCross = route;
		}
	};

	return AbstractScreen;
}();



/***/ },
/* 41 */
/*!********************************!*\
  !*** external "window.moment" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.moment;

/***/ },
/* 42 */
/*!***********************************!*\
  !*** ./dev/Promises/User/Ajax.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),

	PromisesPopulator = __webpack_require__(/*! Promises/User/Populator */ 113),
	AbstractAjaxPromises = __webpack_require__(/*! Promises/AbstractAjax */ 112);

/**
 * @constructor
 * @extends AbstractAjaxPromises
 */
function UserAjaxUserPromises()
{
	AbstractAjaxPromises.call(this);
}

_.extend(UserAjaxUserPromises.prototype, AbstractAjaxPromises.prototype);

UserAjaxUserPromises.prototype.foldersReload = function(fTrigger)
{
	return this.abort('Folders')
		.postRequest('Folders', fTrigger).then(function(oData) {
			PromisesPopulator.foldersList(oData.Result);
			PromisesPopulator.foldersAdditionalParameters(oData.Result);
			return true;
		});
};

UserAjaxUserPromises.prototype.foldersTimeout = 0;
UserAjaxUserPromises.prototype.foldersReloadWithTimeout = function(fTrigger)
{
	this.setTrigger(fTrigger, true);

	var self = this;
	window.clearTimeout(this.foldersTimeout);
	this.foldersTimeout = window.setTimeout(function() {
		self.foldersReload(fTrigger);
	}, 500);
};

UserAjaxUserPromises.prototype.folderDelete = function(sFolderFullNameRaw, fTrigger)
{
	return this.postRequest('FolderDelete', fTrigger, {
		'Folder': sFolderFullNameRaw
	});
};

UserAjaxUserPromises.prototype.folderCreate = function(sNewFolderName, sParentName, fTrigger)
{
	return this.postRequest('FolderCreate', fTrigger, {
		'Folder': sNewFolderName,
		'Parent': sParentName
	});
};

UserAjaxUserPromises.prototype.folderRename = function(sPrevFolderFullNameRaw, sNewFolderName, fTrigger)
{
	return this.postRequest('FolderRename', fTrigger, {
		'Folder': sPrevFolderFullNameRaw,
		'NewFolderName': sNewFolderName
	});
};

UserAjaxUserPromises.prototype.attachmentsActions = function(sAction, aHashes, fTrigger)
{
	return this.postRequest('AttachmentsActions', fTrigger, {
		'Do': sAction,
		'Hashes': aHashes
	});
};

UserAjaxUserPromises.prototype.welcomeClose = function()
{
	return this.postRequest('WelcomeClose');
};

module.exports = new UserAjaxUserPromises();


/***/ },
/* 43 */
/*!*****************************!*\
  !*** ./dev/Stores/Theme.js ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function ThemeStore()
{
	this.themes = ko.observableArray([]);
	this.themeBackgroundName = ko.observable('');
	this.themeBackgroundHash = ko.observable('');

	this.theme = ko.observable('')
		.extend({'limitedList': this.themes});
}

ThemeStore.prototype.populate = function()
{
	var aThemes = Settings.appSettingsGet('themes');

	this.themes(Utils.isArray(aThemes) ? aThemes : []);
	this.theme(Settings.settingsGet('Theme'));
	this.themeBackgroundName(Settings.settingsGet('UserBackgroundName'));
	this.themeBackgroundHash(Settings.settingsGet('UserBackgroundHash'));
};

module.exports = new ThemeStore();


/***/ },
/* 44 */
/*!*************************************!*\
  !*** ./dev/View/Popup/Languages.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function LanguagesPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsLanguages');

	var self = this;

	this.fLang = null;
	this.userLanguage = ko.observable('');

	this.langs = ko.observableArray([]);

	this.languages = ko.computed(function() {
		var sUserLanguage = self.userLanguage();
		return _.map(self.langs(), function(sLanguage) {
			return {
				'key': sLanguage,
				'user': sLanguage === sUserLanguage,
				'selected': ko.observable(false),
				'fullName': Utils.convertLangName(sLanguage)
			};
		});
	});

	this.langs.subscribe(function() {
		this.setLanguageSelection();
	}, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Languages', 'PopupsLanguagesViewModel'], LanguagesPopupView);
_.extend(LanguagesPopupView.prototype, AbstractView.prototype);

LanguagesPopupView.prototype.languageTooltipName = function(sLanguage)
{
	var sResult = Utils.convertLangName(sLanguage, true);
	return Utils.convertLangName(sLanguage, false) === sResult ? '' : sResult;
};

LanguagesPopupView.prototype.setLanguageSelection = function()
{
	var currentLang = this.fLang ? ko.unwrap(this.fLang) : '';
	_.each(this.languages(), function(item) {
		item.selected(item.key === currentLang);
	});
};

LanguagesPopupView.prototype.onBeforeShow = function()
{
	this.fLang = null;
	this.userLanguage('');

	this.langs([]);
};

LanguagesPopupView.prototype.onShow = function(fLanguage, aLangs, sUserLanguage)
{
	this.fLang = fLanguage;
	this.userLanguage(sUserLanguage || '');

	this.langs(aLangs);
};

LanguagesPopupView.prototype.changeLanguage = function(sLang)
{
	if (this.fLang)
	{
		this.fLang(sLang);
	}

	this.cancelCommand();
};

module.exports = LanguagesPopupView;


/***/ },
/* 45 */
/*!***********************************!*\
  !*** ./dev/Common/HtmlEditor.jsx ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);

/* harmony export */ __webpack_require__.d(exports, "HtmlEditor", function() { return HtmlEditor; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return HtmlEditor; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }







var HtmlEditor = function () {
	/**
  * @constructor
  * @param {Object} element
  * @param {Function=} onBlur
  * @param {Function=} onReady
  * @param {Function=} onModeChange
  */

	function HtmlEditor(element) {
		var onBlur = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];
		var onReady = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
		var onModeChange = arguments.length <= 3 || arguments[3] === undefined ? null : arguments[3];

		_classCallCheck(this, HtmlEditor);

		this.editor = null;
		this.blurTimer = 0;

		this.onBlur = onBlur;
		this.onReady = onReady;
		this.onModeChange = onModeChange;

		this.$element = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

		this.resize = __WEBPACK_IMPORTED_MODULE_1_____default.a.throttle(__WEBPACK_IMPORTED_MODULE_1_____default.a.bind(this.resize, this), 100);

		this.__inited = false;

		this.init();
	}

	HtmlEditor.prototype.blurTrigger = function blurTrigger() {
		var _this = this;

		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(this.blurTimer);
			this.blurTimer = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				_this.onBlur();
			}, 200);
		}
	};

	HtmlEditor.prototype.focusTrigger = function focusTrigger() {
		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(this.blurTimer);
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.isHtml = function isHtml() {
		return this.editor ? 'wysiwyg' === this.editor.mode : false;
	};

	/**
  * @param {string} signature
  * @param {bool} html
  * @param {bool} insertBefore
  */


	HtmlEditor.prototype.setSignature = function setSignature(signature, html, insertBefore) {
		if (this.editor) {
			this.editor.execCommand('insertSignature', {
				isHtml: html,
				insertBefore: insertBefore,
				signature: signature
			});
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.checkDirty = function checkDirty() {
		return this.editor ? this.editor.checkDirty() : false;
	};

	HtmlEditor.prototype.resetDirty = function resetDirty() {
		if (this.editor) {
			this.editor.resetDirty();
		}
	};

	/**
  * @param {string} text
  * @returns {string}
  */


	HtmlEditor.prototype.clearSignatureSigns = function clearSignatureSigns(text) {
		return text.replace(/(\u200C|\u0002)/g, '');
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @param {boolean=} clearSignatureSigns = false
  * @returns {string}
  */


	HtmlEditor.prototype.getData = function getData() {
		var wrapIsHtml = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var clearSignatureSigns = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];


		var result = '';
		if (this.editor) {
			try {
				if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
					result = this.editor.__plain.getRawData();
				} else {
					result = wrapIsHtml ? '<div data-html-editor-font-wrapper="true" style="font-family: arial, sans-serif; font-size: 13px;">' + this.editor.getData() + '</div>' : this.editor.getData();
				}
			} catch (e) {} // eslint-disable-line no-empty

			if (clearSignatureSigns) {
				result = this.clearSignatureSigns(result);
			}
		}

		return result;
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @param {boolean=} clearSignatureSigns = false
  * @returns {string}
  */


	HtmlEditor.prototype.getDataWithHtmlMark = function getDataWithHtmlMark() {
		var wrapIsHtml = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var clearSignatureSigns = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return (this.isHtml() ? ':HTML:' : '') + this.getData(wrapIsHtml, clearSignatureSigns);
	};

	HtmlEditor.prototype.modeToggle = function modeToggle(plain, resize) {
		if (this.editor) {
			try {
				if (plain) {
					if ('plain' === this.editor.mode) {
						this.editor.setMode('wysiwyg');
					}
				} else {
					if ('wysiwyg' === this.editor.mode) {
						this.editor.setMode('plain');
					}
				}
			} catch (e) {} // eslint-disable-line no-empty

			if (resize) {
				this.resize();
			}
		}
	};

	HtmlEditor.prototype.setHtmlOrPlain = function setHtmlOrPlain(text, focus) {
		if (':HTML:' === text.substr(0, 6)) {
			this.setHtml(text.substr(6), focus);
		} else {
			this.setPlain(text, focus);
		}
	};

	HtmlEditor.prototype.setHtml = function setHtml(html, focus) {
		if (this.editor && this.__inited) {
			this.modeToggle(true);

			html = html.replace(/<p[^>]*><\/p>/ig, '');

			try {
				this.editor.setData(html);
			} catch (e) {} // eslint-disable-line no-empty

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.replaceHtml = function replaceHtml(find, _replaceHtml) {
		if (this.editor && this.__inited && 'wysiwyg' === this.editor.mode) {
			try {
				this.editor.setData(this.editor.getData().replace(find, _replaceHtml));
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setPlain = function setPlain(plain, focus) {
		if (this.editor && this.__inited) {
			this.modeToggle(false);
			if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
				this.editor.__plain.setRawData(plain);
			} else {
				try {
					this.editor.setData(plain);
				} catch (e) {} // eslint-disable-line no-empty
			}

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.init = function init() {
		var _this2 = this;

		if (this.$element && this.$element[0] && !this.editor) {
			var initFunc = function initFunc() {

				var config = __WEBPACK_IMPORTED_MODULE_3_Common_Globals__["oHtmlEditorDefaultConfig"],
				    language = __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('Language'),
				    allowSource = !!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["appSettingsGet"]('allowHtmlEditorSourceButton'),
				    biti = !!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["appSettingsGet"]('allowHtmlEditorBitiButtons');

				if ((allowSource || !biti) && !config.toolbarGroups.__cfgInited) {
					config.toolbarGroups.__cfgInited = true;

					if (allowSource) {
						config.removeButtons = config.removeButtons.replace(',Source', '');
					}

					if (!biti) {
						config.removePlugins += (config.removePlugins ? ',' : '') + 'bidi';
					}
				}

				config.enterMode = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.ENTER_BR;
				config.shiftEnterMode = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.ENTER_P;

				config.language = __WEBPACK_IMPORTED_MODULE_3_Common_Globals__["oHtmlEditorLangsMap"][language] || 'en';
				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.env) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.env.isCompatible = true;
				}

				_this2.editor = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.appendTo(_this2.$element[0], config);

				_this2.editor.on('key', function (event) {
					if (event && event.data && 9 /* Tab */ === event.data.keyCode) {
						return false;
					}

					return true;
				});

				_this2.editor.on('blur', function () {
					_this2.blurTrigger();
				});

				_this2.editor.on('mode', function () {
					_this2.blurTrigger();
					if (_this2.onModeChange) {
						_this2.onModeChange('plain' !== _this2.editor.mode);
					}
				});

				_this2.editor.on('focus', function () {
					_this2.focusTrigger();
				});

				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader) {
					_this2.editor.on('drop', function (event) {
						if (0 < event.data.dataTransfer.getFilesCount()) {
							var file = event.data.dataTransfer.getFile(0);
							if (file && __WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader && event.data.dataTransfer.id && file.type && file.type.match(/^image/i)) {
								var id = event.data.dataTransfer.id,
								    imageId = '[img=' + id + ']',
								    reader = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader();

								reader.onloadend = function () {
									if (reader.result) {
										_this2.replaceHtml(imageId, '<img src="' + reader.result + '" />');
									}
								};

								reader.readAsDataURL(file);

								event.data.dataTransfer.setData('text/html', imageId);
							}
						}
					});
				}

				_this2.editor.on('instanceReady', function () {

					if (_this2.editor.removeMenuItem) {
						_this2.editor.removeMenuItem('cut');
						_this2.editor.removeMenuItem('copy');
						_this2.editor.removeMenuItem('paste');
					}

					_this2.__resizable = true;
					_this2.__inited = true;

					_this2.resize();

					if (_this2.onReady) {
						_this2.onReady();
					}
				});
			};

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR) {
				initFunc();
			} else {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.__initEditor = initFunc;
			}
		}
	};

	HtmlEditor.prototype.focus = function focus() {
		if (this.editor) {
			try {
				this.editor.focus();
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.hasFocus = function hasFocus() {
		if (this.editor) {
			try {
				return !!this.editor.focusManager.hasFocus;
			} catch (e) {} // eslint-disable-line no-empty
		}

		return false;
	};

	HtmlEditor.prototype.blur = function blur() {
		if (this.editor) {
			try {
				this.editor.focusManager.blur(true);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.resize = function resize() {
		if (this.editor && this.__resizable) {
			try {
				this.editor.resize(this.$element.width(), this.$element.innerHeight());
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setReadOnly = function setReadOnly(value) {
		if (this.editor) {
			try {
				this.editor.setReadOnly(!!value);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.clear = function clear(focus) {
		this.setHtml('', focus);
	};

	return HtmlEditor;
}();


module.exports = HtmlEditor;

/***/ },
/* 46 */
/*!*******************************************!*\
  !*** ./dev/Component/AbstracCheckbox.jsx ***!
  \*******************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstracCheckbox; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var AbstracCheckbox = function (_AbstractComponent) {
	_inherits(AbstracCheckbox, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params = {}
  */

	function AbstracCheckbox() {
		var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

		_classCallCheck(this, AbstracCheckbox);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.value = params.value;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.value) ? false : !!_this.value);
		}

		_this.enable = params.enable;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.enable) || !_this.enable.subscribe) {
			_this.enable = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.enable) ? true : !!_this.enable);
		}

		_this.disable = params.disable;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.disable) || !_this.disable.subscribe) {
			_this.disable = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.disable) ? false : !!_this.disable);
		}

		_this.label = params.label || '';
		_this.inline = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;

		_this.readOnly = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;
		_this.inverted = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.inverted) ? false : !!params.inverted;

		_this.labeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.label);
		_this.labelAnimated = !!params.labelAnimated;
		return _this;
	}

	AbstracCheckbox.prototype.click = function click() {
		if (!this.readOnly && this.enable() && !this.disable()) {
			this.value(!this.value());
		}
	};

	return AbstracCheckbox;
}(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 47 */
/*!********************************!*\
  !*** ./dev/Storage/Client.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_ClientStorageDriver_Cookie__ = __webpack_require__(/*! Common/ClientStorageDriver/Cookie */ 160);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_ClientStorageDriver_LocalStorage__ = __webpack_require__(/*! Common/ClientStorageDriver/LocalStorage */ 161);
/* harmony export */ exports["set"] = set;/* harmony export */ exports["get"] = get;




var SupportedStorageDriver = __WEBPACK_IMPORTED_MODULE_0_____default.a.find([__WEBPACK_IMPORTED_MODULE_2_Common_ClientStorageDriver_LocalStorage__["a" /* LocalStorageDriver */], __WEBPACK_IMPORTED_MODULE_1_Common_ClientStorageDriver_Cookie__["a" /* CookieDriver */]], function (StorageDriver) {
  return StorageDriver && StorageDriver.supported();
});

var driver = SupportedStorageDriver ? new SupportedStorageDriver() : null;

/**
 * @param {number} key
 * @param {*} data
 * @returns {boolean}
 */
function set(key, data) {
  return driver ? driver.set('p' + key, data) : false;
}

/**
 * @param {number} key
 * @returns {*}
 */
function get(key) {
  return driver ? driver.get('p' + key) : null;
}

/***/ },
/* 48 */
/*!************************************!*\
  !*** external "window.crossroads" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.crossroads;

/***/ },
/* 49 */
/*!************************************!*\
  !*** external "window.progressJs" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.progressJs;

/***/ },
/* 50 */
/*!***************************!*\
  !*** ./dev/bootstrap.jsx ***!
  \***************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Model_Email__ = __webpack_require__(/*! Model/Email */ 30);










/* harmony default export */ exports["a"] = function (App) {

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["data"].__APP__ = App;

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$win"].on('keydown', __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["kill_CtrlA_CtrlS"]).on('unload', function () {
		__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["data"].bUnload = true;
	});

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$html"].addClass(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["bMobileDevice"] ? 'mobile' : 'no-mobile').on('click.dropdown.data-api', function () {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["detectDropdownVisibility"])();
	});

	var rl = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rl || {};

	rl.i18n = __WEBPACK_IMPORTED_MODULE_6_Common_Translator__["i18n"];
	rl.createCommand = __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["createCommand"];

	rl.addSettingsViewModel = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addSettingsViewModel"];
	rl.addSettingsViewModelForAdmin = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addSettingsViewModelForAdmin"];

	rl.addHook = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addHook"];
	rl.settingsGet = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["mainSettingsGet"];
	rl.pluginSettingsGet = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["settingsGet"];
	rl.pluginRemoteRequest = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["remoteRequest"];

	rl.EmailModel = __WEBPACK_IMPORTED_MODULE_7_Model_Email__["EmailModel"];
	rl.Enums = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rl = rl;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = function (fErrorCallback) {

		__WEBPACK_IMPORTED_MODULE_1_____default()(function () {

			__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES && __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0]) {
					__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-templates').html(__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0]);

					__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

						__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$html"].removeClass('no-js rl-booted-trigger').addClass('rl-booted');

						App.bootstart();
					}, 10);
				} else {
					fErrorCallback();
				}

				__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = null;
			}, 10);
		});
	};
};

/***/ },
/* 51 */,
/* 52 */,
/* 53 */
/*!************************************!*\
  !*** ./dev/Stores/User/Contact.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function ContactUserStore()
{
	this.contacts = ko.observableArray([]);
	this.contacts.loading = ko.observable(false).extend({'throttle': 200});
	this.contacts.importing = ko.observable(false).extend({'throttle': 200});
	this.contacts.syncing = ko.observable(false).extend({'throttle': 200});
	this.contacts.exportingVcf = ko.observable(false).extend({'throttle': 200});
	this.contacts.exportingCsv = ko.observable(false).extend({'throttle': 200});

	this.allowContactsSync = ko.observable(false);
	this.enableContactsSync = ko.observable(false);
	this.contactsSyncUrl = ko.observable('');
	this.contactsSyncUser = ko.observable('');
	this.contactsSyncPass = ko.observable('');
}

ContactUserStore.prototype.populate = function()
{
	this.allowContactsSync(!!Settings.settingsGet('ContactsSyncIsAllowed'));
	this.enableContactsSync(!!Settings.settingsGet('EnableContactsSync'));

	this.contactsSyncUrl(Settings.settingsGet('ContactsSyncUrl'));
	this.contactsSyncUser(Settings.settingsGet('ContactsSyncUser'));
	this.contactsSyncPass(Settings.settingsGet('ContactsSyncPassword'));
};

module.exports = new ContactUserStore();


/***/ },
/* 54 */
/*!****************************************!*\
  !*** ./dev/View/Popup/FolderSystem.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function FolderSystemPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsFolderSystem');

	Translator.initOnStartOrLangChange(_.bind(function() {
		this.sChooseOnText = Translator.i18n('POPUPS_SYSTEM_FOLDERS/SELECT_CHOOSE_ONE');
		this.sUnuseText = Translator.i18n('POPUPS_SYSTEM_FOLDERS/SELECT_UNUSE_NAME');
	}, this));

	this.notification = ko.observable('');

	this.folderSelectList = ko.computed(function() {
		return Utils.folderListOptionsBuilder([], FolderStore.folderList(), FolderStore.folderListSystemNames(), [
			['', this.sChooseOnText],
			[Consts.UNUSED_OPTION_VALUE, this.sUnuseText]
		], null, null, null, null, null, true);
	}, this);

	var
		fSaveSystemFolders = null,
		fCallback = null;

	this.sentFolder = FolderStore.sentFolder;
	this.draftFolder = FolderStore.draftFolder;
	this.spamFolder = FolderStore.spamFolder;
	this.trashFolder = FolderStore.trashFolder;
	this.archiveFolder = FolderStore.archiveFolder;

	fSaveSystemFolders = _.debounce(function() {

		Settings.settingsSet('SentFolder', FolderStore.sentFolder());
		Settings.settingsSet('DraftFolder', FolderStore.draftFolder());
		Settings.settingsSet('SpamFolder', FolderStore.spamFolder());
		Settings.settingsSet('TrashFolder', FolderStore.trashFolder());
		Settings.settingsSet('ArchiveFolder', FolderStore.archiveFolder());

		Remote.saveSystemFolders(Utils.noop, {
			'SentFolder': FolderStore.sentFolder(),
			'DraftFolder': FolderStore.draftFolder(),
			'SpamFolder': FolderStore.spamFolder(),
			'TrashFolder': FolderStore.trashFolder(),
			'ArchiveFolder': FolderStore.archiveFolder(),
			'NullFolder': 'NullFolder'
		});

	}, Enums.Magics.Time1s);

	fCallback = function() {

		Settings.settingsSet('SentFolder', FolderStore.sentFolder());
		Settings.settingsSet('DraftFolder', FolderStore.draftFolder());
		Settings.settingsSet('SpamFolder', FolderStore.spamFolder());
		Settings.settingsSet('TrashFolder', FolderStore.trashFolder());
		Settings.settingsSet('ArchiveFolder', FolderStore.archiveFolder());

		fSaveSystemFolders();
	};

	FolderStore.sentFolder.subscribe(fCallback);
	FolderStore.draftFolder.subscribe(fCallback);
	FolderStore.spamFolder.subscribe(fCallback);
	FolderStore.trashFolder.subscribe(fCallback);
	FolderStore.archiveFolder.subscribe(fCallback);

	this.defautOptionsAfterRender = Utils.defautOptionsAfterRender;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/FolderSystem', 'PopupsFolderSystemViewModel'], FolderSystemPopupView);
_.extend(FolderSystemPopupView.prototype, AbstractView.prototype);

FolderSystemPopupView.prototype.sChooseOnText = '';
FolderSystemPopupView.prototype.sUnuseText = '';

/**
 * @param {number=} iNotificationType = Enums.SetSystemFoldersNotification.None
 */
FolderSystemPopupView.prototype.onShow = function(iNotificationType)
{
	var sNotification = '';

	iNotificationType = Utils.isUnd(iNotificationType) ? Enums.SetSystemFoldersNotification.None : iNotificationType;

	switch (iNotificationType)
	{
		case Enums.SetSystemFoldersNotification.Sent:
			sNotification = Translator.i18n('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_SENT');
			break;
		case Enums.SetSystemFoldersNotification.Draft:
			sNotification = Translator.i18n('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_DRAFTS');
			break;
		case Enums.SetSystemFoldersNotification.Spam:
			sNotification = Translator.i18n('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_SPAM');
			break;
		case Enums.SetSystemFoldersNotification.Trash:
			sNotification = Translator.i18n('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_TRASH');
			break;
		case Enums.SetSystemFoldersNotification.Archive:
			sNotification = Translator.i18n('POPUPS_SYSTEM_FOLDERS/NOTIFICATION_ARCHIVE');
			break;
		// no default
	}

	this.notification(sNotification);
};

module.exports = FolderSystemPopupView;


/***/ },
/* 55 */
/*!**********************************!*\
  !*** ./dev/Storage/RainLoop.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_JSON__ = __webpack_require__(/*! JSON */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_JSON___default = __WEBPACK_IMPORTED_MODULE_1_JSON__ && __WEBPACK_IMPORTED_MODULE_1_JSON__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_JSON__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_JSON__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_JSON___default, 'a', __WEBPACK_IMPORTED_MODULE_1_JSON___default);
/* harmony export */ exports["a"] = isStorageSupported;/* harmony export */ exports["c"] = getHash;/* harmony export */ exports["d"] = setHash;/* harmony export */ exports["e"] = clearHash;/* harmony export */ exports["b"] = checkTimestamp;



var STORAGE_KEY = '__rlA';
var TIME_KEY = '__rlT';

/**
 * @param {string} storageName
 * @returns {boolean}
 */
function isStorageSupported(storageName) {
	if (storageName in __WEBPACK_IMPORTED_MODULE_0_window___default.a && __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName] && __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName].setItem) {
		var s = __WEBPACK_IMPORTED_MODULE_0_window___default.a[storageName],
		    key = 'testLocalStorage_' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.random();

		try {
			s.setItem(key, key);
			if (key === s.getItem(key)) {
				s.removeItem(key);
				return true;
			}
		} catch (e) {} // eslint-disable-line no-empty
	}

	return false;
}

var SESS_STORAGE = isStorageSupported('sessionStorage') ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.sessionStorage || null : null;
var WIN_STORAGE = __WEBPACK_IMPORTED_MODULE_0_window___default.a.top || __WEBPACK_IMPORTED_MODULE_0_window___default.a || null;

var __get = function __get(key) {

	var result = null;
	if (SESS_STORAGE) {
		result = SESS_STORAGE.getItem(key) || null;
	} else if (WIN_STORAGE && __WEBPACK_IMPORTED_MODULE_1_JSON___default.a) {
		var data = WIN_STORAGE.name && '{' === WIN_STORAGE.name.toString().substr(0, 1) ? __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.parse(WIN_STORAGE.name.toString()) : null;
		result = data ? data[key] || null : null;
	}

	return result;
};

var __set = function __set(key, value) {

	if (SESS_STORAGE) {
		SESS_STORAGE.setItem(key, value);
	} else if (WIN_STORAGE && __WEBPACK_IMPORTED_MODULE_1_JSON___default.a) {
		var data = WIN_STORAGE.name && '{' === WIN_STORAGE.name.toString().substr(0, 1) ? __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.parse(WIN_STORAGE.name.toString()) : null;
		data = data || {};
		data[key] = value;

		WIN_STORAGE.name = __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.stringify(data);
	}
};

var timestamp = function timestamp() {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime() / 1000);
};

var setTimestamp = function setTimestamp() {
	return __set(TIME_KEY, timestamp());
};

var getTimestamp = function getTimestamp() {
	var time = __get(TIME_KEY, 0);
	return time ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(time, 10) || 0 : 0;
};

/**
 * @returns {string}
 */
function getHash() {
	return __get(STORAGE_KEY);
}

/**
 * @returns {void}
 */
function setHash() {
	var key = 'AuthAccountHash',
	    appData = __WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_data();

	__set(STORAGE_KEY, appData && appData[key] ? appData[key] : '');
	setTimestamp();
}

/**
 * @returns {void}
 */
function clearHash() {
	__set(STORAGE_KEY, '');
	setTimestamp();
}

/**
 * @returns {boolean}
 */
function checkTimestamp() {
	if (timestamp() > getTimestamp() + 1000 * 60 * 60) // 60m
		{
			clearHash();
			return true;
		}
	return false;
}

// init section
__WEBPACK_IMPORTED_MODULE_0_window___default.a.setInterval(setTimestamp, 1000 * 60); // 1m

/***/ },
/* 56 */
/*!**************************************!*\
  !*** ./dev/Stores/User/Identity.jsx ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }




var IdentityUserStore = function IdentityUserStore() {
	var _this = this;

	_classCallCheck(this, IdentityUserStore);

	this.identities = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observableArray([]);
	this.identities.loading = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ throttle: 100 });

	this.identitiesIDS = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
		return __WEBPACK_IMPORTED_MODULE_0_____default.a.compact(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(_this.identities(), function (item) {
			return item ? item.id : null;
		}));
	});
};

module.exports = new IdentityUserStore();

/***/ },
/* 57 */
/*!*********************************!*\
  !*** ./dev/External/Opentip.js ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	Opentip = window.Opentip;

Opentip.styles.rainloop = {

	'extends': 'standard',

	'fixed': true,
	'target': true,

	'delay': 0.2,
	'hideDelay': 0,

	'hideEffect': 'fade',
	'hideEffectDuration': 0.2,

	'showEffect': 'fade',
	'showEffectDuration': 0.2,

	'showOn': 'mouseover click',
	'removeElementsOnHide': true,

	'background': '#fff',
	'shadow': false,

	'borderColor': '#999',
	'borderRadius': 2,
	'borderWidth': 1
};

Opentip.styles.rainloopTip = {
	'extends': 'rainloop',
	'delay': 0.4,
	'group': 'rainloopTips'
};

Opentip.styles.rainloopErrorTip = {
	'extends': 'rainloop',
	'className': 'rainloopErrorTip'
};

module.exports = Opentip;


/***/ },
/* 58 */
/*!************************************!*\
  !*** ./dev/Remote/AbstractAjax.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Plugins = __webpack_require__(/*! Common/Plugins */ 21),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
* @constructor
*/
function AbstractAjaxRemote()
{
	this.oRequests = {};
}

AbstractAjaxRemote.prototype.oRequests = {};

/**
 * @param {?Function} fCallback
 * @param {string} sRequestAction
 * @param {string} sType
 * @param {?AjaxJsonDefaultResponse} oData
 * @param {boolean} bCached
 * @param {*=} oRequestParameters
 */
AbstractAjaxRemote.prototype.defaultResponse = function(fCallback, sRequestAction, sType, oData, bCached, oRequestParameters)
{
	var
		fCall = function() {
			if (Enums.StorageResultType.Success !== sType && Globals.data.bUnload)
			{
				sType = Enums.StorageResultType.Unload;
			}

			if (Enums.StorageResultType.Success === sType && oData && !oData.Result)
			{
				if (oData && -1 < Utils.inArray(oData.ErrorCode, [
					Enums.Notification.AuthError, Enums.Notification.AccessError,
					Enums.Notification.ConnectionError, Enums.Notification.DomainNotAllowed, Enums.Notification.AccountNotAllowed,
					Enums.Notification.MailServerError,	Enums.Notification.UnknownNotification, Enums.Notification.UnknownError
				]))
				{
					Globals.data.iAjaxErrorCount += 1;
				}

				if (oData && Enums.Notification.InvalidToken === oData.ErrorCode)
				{
					Globals.data.iTokenErrorCount += 1;
				}

				if (Consts.TOKEN_ERROR_LIMIT < Globals.data.iTokenErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.loginAndLogoutReload)
					{
						Globals.data.__APP__.loginAndLogoutReload(false, true);
					}
				}

				if (oData.ClearAuth || oData.Logout || Consts.AJAX_ERROR_LIMIT < Globals.data.iAjaxErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.clearClientSideToken)
					{
						Globals.data.__APP__.clearClientSideToken();

						if (!oData.ClearAuth && Globals.data.__APP__.loginAndLogoutReload)
						{
							Globals.data.__APP__.loginAndLogoutReload(false, true);
						}
					}
				}
			}
			else if (Enums.StorageResultType.Success === sType && oData && oData.Result)
			{
				Globals.data.iAjaxErrorCount = 0;
				Globals.data.iTokenErrorCount = 0;
			}

			if (fCallback)
			{
				Plugins.runHook('ajax-default-response', [sRequestAction, Enums.StorageResultType.Success === sType ? oData : null, sType, bCached, oRequestParameters]);

				fCallback(
					sType,
					Enums.StorageResultType.Success === sType ? oData : null,
					bCached,
					sRequestAction,
					oRequestParameters
				);
			}
		};

	switch (sType)
	{
		case 'success':
			sType = Enums.StorageResultType.Success;
			break;
		case 'abort':
			sType = Enums.StorageResultType.Abort;
			break;
		default:
			sType = Enums.StorageResultType.Error;
			break;
	}

	if (Enums.StorageResultType.Error === sType)
	{
		_.delay(fCall, 300);
	}
	else
	{
		fCall();
	}
};

/**
 * @param {?Function} fResultCallback
 * @param {Object} oParameters
 * @param {?number=} iTimeOut = 20000
 * @param {string=} sGetAdd = ''
 * @param {Array=} aAbortActions = []
 * @returns {jQuery.jqXHR}
 */
AbstractAjaxRemote.prototype.ajaxRequest = function(fResultCallback, oParameters, iTimeOut, sGetAdd, aAbortActions)
{
	var
		self = this,
		bPost = '' === sGetAdd,
		oHeaders = {},
		iStart = (new window.Date()).getTime(),
		oDefAjax = null,
		sAction = '';

	oParameters = oParameters || {};
	iTimeOut = Utils.isNormal(iTimeOut) ? iTimeOut : 20000;
	sGetAdd = Utils.isUnd(sGetAdd) ? '' : Utils.pString(sGetAdd);
	aAbortActions = Utils.isArray(aAbortActions) ? aAbortActions : [];

	sAction = oParameters.Action || '';

	if (sAction && 0 < aAbortActions.length)
	{
		_.each(aAbortActions, function(sActionToAbort) {
			if (self.oRequests[sActionToAbort])
			{
				self.oRequests[sActionToAbort].__aborted = true;
				if (self.oRequests[sActionToAbort].abort)
				{
					self.oRequests[sActionToAbort].abort();
				}
				self.oRequests[sActionToAbort] = null;
			}
		});
	}

	if (bPost)
	{
		oParameters.XToken = Settings.appSettingsGet('token');
	}

	oDefAjax = $.ajax({
		type: bPost ? 'POST' : 'GET',
		url: Links.ajax(sGetAdd),
		async: true,
		dataType: 'json',
		data: bPost ? oParameters : {},
		headers: oHeaders,
		timeout: iTimeOut,
		global: true
	});

	oDefAjax.always(function(oData, sType) {

		var bCached = false;
		if (oData && oData.Time)
		{
			bCached = Utils.pInt(oData.Time) > (new window.Date()).getTime() - iStart;
		}

		if (sAction && self.oRequests[sAction])
		{
			if (self.oRequests[sAction].__aborted)
			{
				sType = 'abort';
			}

			self.oRequests[sAction] = null;
		}

		self.defaultResponse(fResultCallback, sAction, sType, oData, bCached, oParameters);
	});

	if (sAction && 0 < aAbortActions.length && -1 < Utils.inArray(sAction, aAbortActions))
	{
		if (this.oRequests[sAction])
		{
			this.oRequests[sAction].__aborted = true;
			if (this.oRequests[sAction].abort)
			{
				this.oRequests[sAction].abort();
			}
			this.oRequests[sAction] = null;
		}

		this.oRequests[sAction] = oDefAjax;
	}

	return oDefAjax;
};

/**
 * @param {?Function} fCallback
 * @param {string} sAction
 * @param {Object=} oParameters
 * @param {?number=} iTimeout
 * @param {string=} sGetAdd = ''
 * @param {Array=} aAbortActions = []
 */
AbstractAjaxRemote.prototype.defaultRequest = function(fCallback, sAction, oParameters, iTimeout, sGetAdd, aAbortActions)
{
	oParameters = oParameters || {};
	oParameters.Action = sAction;

	sGetAdd = Utils.pString(sGetAdd);

	Plugins.runHook('ajax-default-request', [sAction, oParameters, sGetAdd]);

	return this.ajaxRequest(fCallback, oParameters,
		Utils.isUnd(iTimeout) ? Consts.DEFAULT_AJAX_TIMEOUT : Utils.pInt(iTimeout), sGetAdd, aAbortActions);
};

/**
 * @param {?Function} fCallback
 */
AbstractAjaxRemote.prototype.noop = function(fCallback)
{
	this.defaultRequest(fCallback, 'Noop');
};

/**
 * @param {?Function} fCallback
 * @param {string} sMessage
 * @param {string} sFileName
 * @param {number} iLineNo
 * @param {string} sLocation
 * @param {string} sHtmlCapa
 * @param {number} iTime
 */
AbstractAjaxRemote.prototype.jsError = function(fCallback, sMessage, sFileName, iLineNo, sLocation, sHtmlCapa, iTime)
{
	this.defaultRequest(fCallback, 'JsError', {
		'Message': sMessage,
		'FileName': sFileName,
		'LineNo': iLineNo,
		'Location': sLocation,
		'HtmlCapa': sHtmlCapa,
		'TimeOnPage': iTime
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sType
 * @param {Array=} mData = null
 * @param {boolean=} bIsError = false
 */
AbstractAjaxRemote.prototype.jsInfo = function(fCallback, sType, mData, bIsError)
{
	this.defaultRequest(fCallback, 'JsInfo', {
		'Type': sType,
		'Data': mData,
		'IsError': (Utils.isUnd(bIsError) ? false : !!bIsError) ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 */
AbstractAjaxRemote.prototype.getPublicKey = function(fCallback)
{
	this.defaultRequest(fCallback, 'GetPublicKey');
};

/**
 * @param {?Function} fCallback
 * @param {string} sVersion
 */
AbstractAjaxRemote.prototype.jsVersion = function(fCallback, sVersion)
{
	this.defaultRequest(fCallback, 'Version', {
		'Version': sVersion
	});
};

module.exports = AbstractAjaxRemote;


/***/ },
/* 59 */,
/* 60 */,
/* 61 */,
/* 62 */
/*!*****************************************!*\
  !*** ./dev/Stores/User/Notification.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Events = __webpack_require__(/*! Common/Events */ 23),
	Audio = __webpack_require__(/*! Common/Audio */ 67),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function NotificationUserStore()
{
	var self = this;

	this.enableSoundNotification = ko.observable(false);
	this.soundNotificationIsSupported = ko.observable(false);

	this.allowDesktopNotification = ko.observable(false);

	this.desktopNotificationPermissions = ko.computed(function() {

		this.allowDesktopNotification();

		var
			NotificationClass = this.notificationClass(),
			iResult = Enums.DesktopNotification.NotSupported;

		if (NotificationClass && NotificationClass.permission)
		{
			switch (NotificationClass.permission.toLowerCase())
			{
				case 'granted':
					iResult = Enums.DesktopNotification.Allowed;
					break;
				case 'denied':
					iResult = Enums.DesktopNotification.Denied;
					break;
				case 'default':
					iResult = Enums.DesktopNotification.NotAllowed;
					break;
				// no default
			}
		}
		else if (window.webkitNotifications && window.webkitNotifications.checkPermission)
		{
			iResult = window.webkitNotifications.checkPermission();
		}

		return iResult;

	}, this).extend({'notify': 'always'});

	this.enableDesktopNotification = ko.computed({
		'owner': this,
		'read': function() {
			return this.allowDesktopNotification() &&
				Enums.DesktopNotification.Allowed === this.desktopNotificationPermissions();
		},
		'write': function(bValue) {
			if (bValue)
			{
				var
					NotificationClass = this.notificationClass(),
					iPermission = this.desktopNotificationPermissions();

				if (NotificationClass && Enums.DesktopNotification.Allowed === iPermission)
				{
					this.allowDesktopNotification(true);
				}
				else if (NotificationClass && Enums.DesktopNotification.NotAllowed === iPermission)
				{
					NotificationClass.requestPermission(function() {
						self.allowDesktopNotification.valueHasMutated();
						if (Enums.DesktopNotification.Allowed === self.desktopNotificationPermissions())
						{
							if (self.allowDesktopNotification())
							{
								self.allowDesktopNotification.valueHasMutated();
							}
							else
							{
								self.allowDesktopNotification(true);
							}
						}
						else
						{
							if (self.allowDesktopNotification())
							{
								self.allowDesktopNotification(false);
							}
							else
							{
								self.allowDesktopNotification.valueHasMutated();
							}
						}
					});
				}
				else
				{
					this.allowDesktopNotification(false);
				}
			}
			else
			{
				this.allowDesktopNotification(false);
			}
		}
	}).extend({'notify': 'always'});

	if (!this.enableDesktopNotification.valueHasMutated)
	{
		this.enableDesktopNotification.valueHasMutated = function() {
			self.allowDesktopNotification.valueHasMutated();
		};
	}

	this.computers();

	this.initNotificationPlayer();
}

NotificationUserStore.prototype.computers = function()
{
	this.isDesktopNotificationSupported = ko.computed(function() {
		return Enums.DesktopNotification.NotSupported !== this.desktopNotificationPermissions();
	}, this);

	this.isDesktopNotificationDenied = ko.computed(function() {
		return Enums.DesktopNotification.NotSupported === this.desktopNotificationPermissions() ||
			Enums.DesktopNotification.Denied === this.desktopNotificationPermissions();
	}, this);
};

NotificationUserStore.prototype.initNotificationPlayer = function()
{
	if (Audio && Audio.supportedNotification)
	{
		this.soundNotificationIsSupported(true);
	}
	else
	{
		this.enableSoundNotification(false);
		this.soundNotificationIsSupported(false);
	}
};

NotificationUserStore.prototype.playSoundNotification = function(bSkipSetting)
{
	if (Audio && Audio.supportedNotification && (bSkipSetting ? true : this.enableSoundNotification()))
	{
		Audio.playNotification();
	}
};

NotificationUserStore.prototype.displayDesktopNotification = function(sImageSrc, sTitle, sText, oMessageData)
{
	if (this.enableDesktopNotification())
	{
		var
			NotificationClass = this.notificationClass(),
			oNotification = NotificationClass ? new NotificationClass(sTitle, {
				'body': sText,
				'icon': sImageSrc
			}) : null;

		if (oNotification)
		{
			if (oNotification.show)
			{
				oNotification.show();
			}

			if (oMessageData)
			{
				oNotification.onclick = function() {

					window.focus();

					if (oMessageData.Folder && oMessageData.Uid)
					{
						Events.pub('mailbox.message.show', [oMessageData.Folder, oMessageData.Uid]);
					}
				};
			}

			window.setTimeout((function(oLocalNotifications) {
				return function() {
					if (oLocalNotifications.cancel)
					{
						oLocalNotifications.cancel();
					}
					else if (oLocalNotifications.close)
					{
						oLocalNotifications.close();
					}
				};
			}(oNotification)), Enums.Magics.Time7s);
		}
	}
};

NotificationUserStore.prototype.populate = function()
{
	this.enableSoundNotification(!!Settings.settingsGet('SoundNotification'));
	this.enableDesktopNotification(!!Settings.settingsGet('DesktopNotifications'));
};

/**
 * @returns {*|null}
 */
NotificationUserStore.prototype.notificationClass = function()
{
	return window.Notification && window.Notification.requestPermission ? window.Notification : null;
};

module.exports = new NotificationUserStore();


/***/ },
/* 63 */
/*!***********************************!*\
  !*** ./dev/View/Popup/Account.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AccountPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsAccount');

	this.isNew = ko.observable(true);

	this.email = ko.observable('');
	this.password = ko.observable('');

	this.emailError = ko.observable(false);
	this.passwordError = ko.observable(false);

	this.email.subscribe(function() {
		this.emailError(false);
	}, this);

	this.password.subscribe(function() {
		this.passwordError(false);
	}, this);

	this.submitRequest = ko.observable(false);
	this.submitError = ko.observable('');
	this.submitErrorAdditional = ko.observable('');

	this.emailFocus = ko.observable(false);

	this.addAccountCommand = Utils.createCommand(this, function() {

		this.emailError('' === Utils.trim(this.email()));
		this.passwordError('' === Utils.trim(this.password()));

		if (this.emailError() || this.passwordError())
		{
			return false;
		}

		this.submitRequest(true);

		Remote.accountSetup(_.bind(function(sResult, oData) {

			this.submitRequest(false);
			if (Enums.StorageResultType.Success === sResult && oData)
			{
				if (oData.Result)
				{
					__webpack_require__(/*! App/User */ 8).default.accountsAndIdentities();
					this.cancelCommand();
				}
				else
				{
					this.submitError(oData.ErrorCode ? Translator.getNotification(oData.ErrorCode) :
						Translator.getNotification(Enums.Notification.UnknownError));

					if (oData.ErrorMessageAdditional)
					{
						this.submitErrorAdditional(oData.ErrorMessageAdditional);
					}
				}
			}
			else
			{
				this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
				this.submitErrorAdditional('');
			}

		}, this), this.email(), this.password(), this.isNew());

		return true;

	}, function() {
		return !this.submitRequest();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Account', 'View/Popup/AddAccount', 'PopupsAddAccountViewModel'], AccountPopupView);
_.extend(AccountPopupView.prototype, AbstractView.prototype);

AccountPopupView.prototype.clearPopup = function()
{
	this.isNew(true);

	this.email('');
	this.password('');

	this.emailError(false);
	this.passwordError(false);

	this.submitRequest(false);
	this.submitError('');
	this.submitErrorAdditional('');
};

AccountPopupView.prototype.onShow = function(oAccount)
{
	this.clearPopup();
	if (oAccount && oAccount.canBeEdit())
	{
		this.isNew(false);
		this.email(oAccount.email);
	}
};

AccountPopupView.prototype.onShowWithDelay = function()
{
	this.emailFocus(true);
};

module.exports = AccountPopupView;


/***/ },
/* 64 */
/*!************************************!*\
  !*** ./dev/View/Popup/Contacts.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Selector = __webpack_require__(/*! Common/Selector */ 102),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	ContactStore = __webpack_require__(/*! Stores/User/Contact */ 53),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	EmailModel = __webpack_require__(/*! Model/Email */ 30).default,
	ContactModel = __webpack_require__(/*! Model/Contact */ 164).default,
	ContactPropertyModel = __webpack_require__(/*! Model/ContactProperty */ 165).default,

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function ContactsPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsContacts');

	var
		self = this,
		fFastClearEmptyListHelper = function(aList) {
			if (aList && 0 < aList.length) {
				self.viewProperties.removeAll(aList);
				Utils.delegateRunOnDestroy(aList);
			}
		};

	this.bBackToCompose = false;
	this.sLastComposeFocusedField = '';

	this.allowContactsSync = ContactStore.allowContactsSync;
	this.enableContactsSync = ContactStore.enableContactsSync;
	this.allowExport = !Globals.bMobileDevice;

	this.search = ko.observable('');
	this.contactsCount = ko.observable(0);
	this.contacts = ContactStore.contacts;

	this.currentContact = ko.observable(null);

	this.importUploaderButton = ko.observable(null);

	this.contactsPage = ko.observable(1);
	this.contactsPageCount = ko.computed(function() {
		var iPage = window.Math.ceil(this.contactsCount() / Consts.CONTACTS_PER_PAGE);
		return 0 >= iPage ? 1 : iPage;
	}, this);

	this.contactsPagenator = ko.computed(Utils.computedPagenatorHelper(this.contactsPage, this.contactsPageCount));

	this.emptySelection = ko.observable(true);
	this.viewClearSearch = ko.observable(false);

	this.viewID = ko.observable('');
	this.viewReadOnly = ko.observable(false);
	this.viewProperties = ko.observableArray([]);

	this.viewSaveTrigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.viewPropertiesNames = this.viewProperties.filter(function(oProperty) {
		return -1 < Utils.inArray(oProperty.type(), [
			Enums.ContactPropertyType.FirstName, Enums.ContactPropertyType.LastName
		]);
	});

	this.viewPropertiesOther = this.viewProperties.filter(function(oProperty) {
		return -1 < Utils.inArray(oProperty.type(), [
			Enums.ContactPropertyType.Note
		]);
	});

	this.viewPropertiesOther = ko.computed(function() {

		var aList = _.filter(this.viewProperties(), function(oProperty) {
			return -1 < Utils.inArray(oProperty.type(), [
				Enums.ContactPropertyType.Nick
			]);
		});

		return _.sortBy(aList, function(oProperty) {
			return oProperty.type();
		});

	}, this);

	this.viewPropertiesEmails = this.viewProperties.filter(function(oProperty) {
		return Enums.ContactPropertyType.Email === oProperty.type();
	});

	this.viewPropertiesWeb = this.viewProperties.filter(function(oProperty) {
		return Enums.ContactPropertyType.Web === oProperty.type();
	});

	this.viewHasNonEmptyRequaredProperties = ko.computed(function() {

		var
			aNames = this.viewPropertiesNames(),
			aEmail = this.viewPropertiesEmails(),
			fHelper = function(oProperty) {
				return '' !== Utils.trim(oProperty.value());
			};

		return !!(_.find(aNames, fHelper) || _.find(aEmail, fHelper));
	}, this);

	this.viewPropertiesPhones = this.viewProperties.filter(function(oProperty) {
		return Enums.ContactPropertyType.Phone === oProperty.type();
	});

	this.viewPropertiesEmailsNonEmpty = this.viewPropertiesNames.filter(function(oProperty) {
		return '' !== Utils.trim(oProperty.value());
	});

	this.viewPropertiesEmailsEmptyAndOnFocused = this.viewPropertiesEmails.filter(function(oProperty) {
		var bF = oProperty.focused();
		return '' === Utils.trim(oProperty.value()) && !bF;
	});

	this.viewPropertiesPhonesEmptyAndOnFocused = this.viewPropertiesPhones.filter(function(oProperty) {
		var bF = oProperty.focused();
		return '' === Utils.trim(oProperty.value()) && !bF;
	});

	this.viewPropertiesWebEmptyAndOnFocused = this.viewPropertiesWeb.filter(function(oProperty) {
		var bF = oProperty.focused();
		return '' === Utils.trim(oProperty.value()) && !bF;
	});

	this.viewPropertiesOtherEmptyAndOnFocused = ko.computed(function() {
		return _.filter(this.viewPropertiesOther(), function(oProperty) {
			var bF = oProperty.focused();
			return '' === Utils.trim(oProperty.value()) && !bF;
		});
	}, this);

	this.viewPropertiesEmailsEmptyAndOnFocused.subscribe(function(aList) {
		fFastClearEmptyListHelper(aList);
	});

	this.viewPropertiesPhonesEmptyAndOnFocused.subscribe(function(aList) {
		fFastClearEmptyListHelper(aList);
	});

	this.viewPropertiesWebEmptyAndOnFocused.subscribe(function(aList) {
		fFastClearEmptyListHelper(aList);
	});

	this.viewPropertiesOtherEmptyAndOnFocused.subscribe(function(aList) {
		fFastClearEmptyListHelper(aList);
	});

	this.viewSaving = ko.observable(false);

	this.useCheckboxesInList = SettingsStore.useCheckboxesInList;

	this.search.subscribe(function() {
		this.reloadContactList();
	}, this);

	this.contacts.subscribe(Utils.windowResizeCallback);
	this.viewProperties.subscribe(Utils.windowResizeCallback);

	this.contactsChecked = ko.computed(function() {
		return _.filter(this.contacts(), function(oItem) {
			return oItem.checked();
		});
	}, this);

	this.contactsCheckedOrSelected = ko.computed(function() {

		var
			aChecked = this.contactsChecked(),
			oSelected = this.currentContact();

		return _.union(aChecked, oSelected ? [oSelected] : []);

	}, this);

	this.contactsCheckedOrSelectedUids = ko.computed(function() {
		return _.map(this.contactsCheckedOrSelected(), function(oContact) {
			return oContact.idContact;
		});
	}, this);

	this.selector = new Selector.Selector(this.contacts, this.currentContact, null,
		'.e-contact-item .actionHandle', '.e-contact-item.selected', '.e-contact-item .checkboxItem',
			'.e-contact-item.focused');

	this.selector.on('onItemSelect', _.bind(function(oContact) {
		this.populateViewContact(oContact ? oContact : null);
		if (!oContact)
		{
			this.emptySelection(true);
		}
	}, this));

	this.selector.on('onItemGetUid', function(oContact) {
		return oContact ? oContact.generateUid() : '';
	});

	this.newCommand = Utils.createCommand(this, function() {
		this.populateViewContact(null);
		this.currentContact(null);
	});

	this.deleteCommand = Utils.createCommand(this, function() {
		this.deleteSelectedContacts();
		this.emptySelection(true);
	}, function() {
		return 0 < this.contactsCheckedOrSelected().length;
	});

	this.newMessageCommand = Utils.createCommand(this, function() {

		if (!Settings.capa(Enums.Capa.Composer))
		{
			return false;
		}

		var
			aE = [],
			aC = this.contactsCheckedOrSelected(),
			aToEmails = null,
			aCcEmails = null,
			aBccEmails = null;

		if (Utils.isNonEmptyArray(aC))
		{
			aE = _.map(aC, function(oItem) {
				if (oItem)
				{
					var
						aData = oItem.getNameAndEmailHelper(),
						oEmail = aData ? new EmailModel(aData[0], aData[1]) : null;

					if (oEmail && oEmail.validate())
					{
						return oEmail;
					}
				}

				return null;
			});

			aE = _.compact(aE);
		}

		if (Utils.isNonEmptyArray(aE))
		{
			self.bBackToCompose = false;

			kn.hideScreenPopup(__webpack_require__(/*! View/Popup/Contacts */ 64));

			switch (self.sLastComposeFocusedField)
			{
				case 'cc':
					aCcEmails = aE;
					break;
				case 'bcc':
					aBccEmails = aE;
					break;
				case 'to':
				default:
					aToEmails = aE;
					break;
			}

			self.sLastComposeFocusedField = '';

			_.delay(function() {
				kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25),
					[Enums.ComposeType.Empty, null, aToEmails, aCcEmails, aBccEmails]);
			}, Enums.Magics.Time200ms);
		}

		return true;

	}, function() {
		return 0 < this.contactsCheckedOrSelected().length;
	});

	this.clearCommand = Utils.createCommand(this, function() {
		this.search('');
	});

	this.saveCommand = Utils.createCommand(this, function() {

		this.viewSaving(true);
		this.viewSaveTrigger(Enums.SaveSettingsStep.Animate);

		var
			sRequestUid = Utils.fakeMd5(),
			aProperties = [];

		_.each(this.viewProperties(), function(oItem) {
			if (oItem.type() && '' !== Utils.trim(oItem.value()))
			{
				aProperties.push([oItem.type(), oItem.value(), oItem.typeStr()]);
			}
		});

		Remote.contactSave(function(sResult, oData) {

			var bRes = false;
			self.viewSaving(false);

			if (Enums.StorageResultType.Success === sResult && oData && oData.Result &&
				oData.Result.RequestUid === sRequestUid && 0 < Utils.pInt(oData.Result.ResultID))
			{
				if ('' === self.viewID())
				{
					self.viewID(Utils.pInt(oData.Result.ResultID));
				}

				self.reloadContactList();
				bRes = true;
			}

			_.delay(function() {
				self.viewSaveTrigger(bRes ? Enums.SaveSettingsStep.TrueResult : Enums.SaveSettingsStep.FalseResult);
			}, Enums.Magics.Time350ms);

			if (bRes)
			{
				self.watchDirty(false);

				_.delay(function() {
					self.viewSaveTrigger(Enums.SaveSettingsStep.Idle);
				}, Enums.Magics.Time1s);
			}

		}, sRequestUid, this.viewID(), aProperties);

	}, function() {
		var
			bV = this.viewHasNonEmptyRequaredProperties(),
			bReadOnly = this.viewReadOnly();
		return !this.viewSaving() && bV && !bReadOnly;
	});

	this.syncCommand = Utils.createCommand(this, function() {

		__webpack_require__(/*! App/User */ 8).default.contactsSync(function(sResult, oData) {
			if (Enums.StorageResultType.Success !== sResult || !oData || !oData.Result)
			{
				window.alert(Translator.getNotification(
					oData && oData.ErrorCode ? oData.ErrorCode : Enums.Notification.ContactsSyncError));
			}

			self.reloadContactList(true);
		});

	}, function() {
		return !this.contacts.syncing() && !this.contacts.importing();
	});

	this.bDropPageAfterDelete = false;

	this.watchDirty = ko.observable(false);
	this.watchHash = ko.observable(false);

	this.viewHash = ko.computed(function() {
		return '' + _.map(self.viewProperties(), function(oItem) {
			return oItem.value();
		}).join('');
	});

//	this.saveCommandDebounce = _.debounce(_.bind(this.saveCommand, this), 1000);

	this.viewHash.subscribe(function() {
		if (this.watchHash() && !this.viewReadOnly() && !this.watchDirty())
		{
			this.watchDirty(true);
		}
	}, this);

	this.sDefaultKeyScope = Enums.KeyState.ContactList;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Contacts', 'PopupsContactsViewModel'], ContactsPopupView);
_.extend(ContactsPopupView.prototype, AbstractView.prototype);

ContactsPopupView.prototype.getPropertyPlaceholder = function(sType)
{
	var sResult = '';
	switch (sType)
	{
		case Enums.ContactPropertyType.LastName:
			sResult = 'CONTACTS/PLACEHOLDER_ENTER_LAST_NAME';
			break;
		case Enums.ContactPropertyType.FirstName:
			sResult = 'CONTACTS/PLACEHOLDER_ENTER_FIRST_NAME';
			break;
		case Enums.ContactPropertyType.Nick:
			sResult = 'CONTACTS/PLACEHOLDER_ENTER_NICK_NAME';
			break;
		// no default
	}

	return sResult;
};

ContactsPopupView.prototype.addNewProperty = function(sType, sTypeStr)
{
	this.viewProperties.push(new ContactPropertyModel(sType, sTypeStr || '', '', true, this.getPropertyPlaceholder(sType)));
};

ContactsPopupView.prototype.addNewOrFocusProperty = function(sType, sTypeStr)
{
	var oItem = _.find(this.viewProperties(), function(oProp) {
		return sType === oProp.type();
	});

	if (oItem)
	{
		oItem.focused(true);
	}
	else
	{
		this.addNewProperty(sType, sTypeStr);
	}
};

ContactsPopupView.prototype.addNewEmail = function()
{
	this.addNewProperty(Enums.ContactPropertyType.Email, 'Home');
};

ContactsPopupView.prototype.addNewPhone = function()
{
	this.addNewProperty(Enums.ContactPropertyType.Phone, 'Mobile');
};

ContactsPopupView.prototype.addNewWeb = function()
{
	this.addNewProperty(Enums.ContactPropertyType.Web);
};

ContactsPopupView.prototype.addNewNickname = function()
{
	this.addNewOrFocusProperty(Enums.ContactPropertyType.Nick);
};

ContactsPopupView.prototype.addNewNotes = function()
{
	this.addNewOrFocusProperty(Enums.ContactPropertyType.Note);
};

ContactsPopupView.prototype.addNewBirthday = function()
{
	this.addNewOrFocusProperty(Enums.ContactPropertyType.Birthday);
};

ContactsPopupView.prototype.exportVcf = function()
{
	__webpack_require__(/*! App/User */ 8).default.download(Links.exportContactsVcf());
};

ContactsPopupView.prototype.exportCsv = function()
{
	__webpack_require__(/*! App/User */ 8).default.download(Links.exportContactsCsv());
};

ContactsPopupView.prototype.initUploader = function()
{
	if (this.importUploaderButton())
	{
		var
			oJua = new Jua({
				'action': Links.uploadContacts(),
				'name': 'uploader',
				'queueSize': 1,
				'multipleSizeLimit': 1,
				'disableDragAndDrop': true,
				'disableMultiple': true,
				'disableDocumentDropPrevent': true,
				'clickElement': this.importUploaderButton()
			});

		if (oJua)
		{
			oJua
				.on('onStart', _.bind(function() {
					this.contacts.importing(true);
				}, this))
				.on('onComplete', _.bind(function(sId, bResult, oData) {

					this.contacts.importing(false);
					this.reloadContactList();

					if (!sId || !bResult || !oData || !oData.Result)
					{
						window.alert(Translator.i18n('CONTACTS/ERROR_IMPORT_FILE'));
					}

				}, this));
		}
	}
};

ContactsPopupView.prototype.removeCheckedOrSelectedContactsFromList = function()
{
	var
		self = this,
		oKoContacts = this.contacts,
		oCurrentContact = this.currentContact(),
		iCount = this.contacts().length,
		aContacts = this.contactsCheckedOrSelected();

	if (0 < aContacts.length)
	{
		_.each(aContacts, function(oContact) {

			if (oCurrentContact && oCurrentContact.idContact === oContact.idContact)
			{
				oCurrentContact = null;
				self.currentContact(null);
			}

			oContact.deleted(true);
			iCount -= 1;
		});

		if (0 >= iCount)
		{
			this.bDropPageAfterDelete = true;
		}

		_.delay(function() {
			_.each(aContacts, function(oContact) {
				oKoContacts.remove(oContact);
				Utils.delegateRunOnDestroy(oContact);
			});
		}, Enums.Magics.Time500ms);
	}
};

ContactsPopupView.prototype.deleteSelectedContacts = function()
{
	if (0 < this.contactsCheckedOrSelected().length)
	{
		Remote.contactsDelete(
			_.bind(this.deleteResponse, this),
			this.contactsCheckedOrSelectedUids()
		);

		this.removeCheckedOrSelectedContactsFromList();
	}
};

/**
 * @param {string} sResult
 * @param {AjaxJsonDefaultResponse} oData
 */
ContactsPopupView.prototype.deleteResponse = function(sResult, oData)
{
	if (Enums.Magics.Time500ms < (Enums.StorageResultType.Success === sResult && oData && oData.Time ? Utils.pInt(oData.Time) : 0))
	{
		this.reloadContactList(this.bDropPageAfterDelete);
	}
	else
	{
		var self = this;
		_.delay(function() {
			self.reloadContactList(self.bDropPageAfterDelete);
		}, Enums.Magics.Time500ms);
	}
};

ContactsPopupView.prototype.removeProperty = function(oProp)
{
	this.viewProperties.remove(oProp);
	Utils.delegateRunOnDestroy(oProp);
};

/**
 * @param {?ContactModel} oContact
 */
ContactsPopupView.prototype.populateViewContact = function(oContact)
{
	var
		sId = '',
		sLastName = '',
		sFirstName = '',
		aList = [];

	this.watchHash(false);

	this.emptySelection(false);
	this.viewReadOnly(false);

	if (oContact)
	{
		sId = oContact.idContact;
		if (Utils.isNonEmptyArray(oContact.properties))
		{
			_.each(oContact.properties, function(aProperty) {
				if (aProperty && aProperty[0])
				{
					if (Enums.ContactPropertyType.LastName === aProperty[0])
					{
						sLastName = aProperty[1];
					}
					else if (Enums.ContactPropertyType.FirstName === aProperty[0])
					{
						sFirstName = aProperty[1];
					}
					else
					{
						aList.push(new ContactPropertyModel(aProperty[0], aProperty[2] || '', aProperty[1]));
					}
				}
			});
		}

		this.viewReadOnly(!!oContact.readOnly);
	}

	aList.unshift(new ContactPropertyModel(Enums.ContactPropertyType.LastName, '', sLastName, false,
		this.getPropertyPlaceholder(Enums.ContactPropertyType.LastName)));

	aList.unshift(new ContactPropertyModel(Enums.ContactPropertyType.FirstName, '', sFirstName, !oContact,
		this.getPropertyPlaceholder(Enums.ContactPropertyType.FirstName)));

	this.viewID(sId);

	Utils.delegateRunOnDestroy(this.viewProperties());

	this.viewProperties([]);
	this.viewProperties(aList);

	this.watchDirty(false);
	this.watchHash(true);
};

/**
 * @param {boolean=} bDropPagePosition = false
 */
ContactsPopupView.prototype.reloadContactList = function(bDropPagePosition)
{
	var
		self = this,
		iOffset = (this.contactsPage() - 1) * Consts.CONTACTS_PER_PAGE;

	this.bDropPageAfterDelete = false;

	if (Utils.isUnd(bDropPagePosition) ? false : !!bDropPagePosition)
	{
		this.contactsPage(1);
		iOffset = 0;
	}

	this.contacts.loading(true);
	Remote.contacts(function(sResult, oData) {

		var
			iCount = 0,
			aList = [];

		if (Enums.StorageResultType.Success === sResult && oData && oData.Result && oData.Result.List)
		{
			if (Utils.isNonEmptyArray(oData.Result.List))
			{
				aList = _.map(oData.Result.List, function(oItem) {
					var oContact = new ContactModel();
					return oContact.parse(oItem) ? oContact : null;
				});

				aList = _.compact(aList);

				iCount = Utils.pInt(oData.Result.Count);
				iCount = 0 < iCount ? iCount : 0;
			}
		}

		self.contactsCount(iCount);

		Utils.delegateRunOnDestroy(self.contacts());
		self.contacts(aList);

		self.contacts.loading(false);
		self.viewClearSearch('' !== self.search());

	}, iOffset, Consts.CONTACTS_PER_PAGE, this.search());
};

ContactsPopupView.prototype.onBuild = function(oDom)
{
	this.oContentVisible = $('.b-list-content', oDom);
	this.oContentScrollable = $('.content', this.oContentVisible);

	this.selector.init(this.oContentVisible, this.oContentScrollable, Enums.KeyState.ContactList);

	var self = this;

	key('delete', Enums.KeyState.ContactList, function() {
		self.deleteCommand();
		return false;
	});

	key('c, w', Enums.KeyState.ContactList, function() {
		self.newMessageCommand();
		return false;
	});

	oDom
		.on('click', '.e-pagenator .e-page', function() {
			var oPage = ko.dataFor(this);
			if (oPage)
			{
				self.contactsPage(Utils.pInt(oPage.value));
				self.reloadContactList();
			}
		});

	this.initUploader();
};

ContactsPopupView.prototype.onShow = function(bBackToCompose, sLastComposeFocusedField)
{
	this.bBackToCompose = Utils.isUnd(bBackToCompose) ? false : !!bBackToCompose;
	this.sLastComposeFocusedField = Utils.isUnd(sLastComposeFocusedField) ? '' : sLastComposeFocusedField;

	kn.routeOff();
	this.reloadContactList(true);
};

ContactsPopupView.prototype.onHide = function()
{
	kn.routeOn();

	this.currentContact(null);
	this.emptySelection(true);
	this.search('');
	this.contactsCount(0);

	Utils.delegateRunOnDestroy(this.contacts());
	this.contacts([]);

	this.sLastComposeFocusedField = '';

	if (this.bBackToCompose)
	{
		this.bBackToCompose = false;

		if (Settings.capa(Enums.Capa.Composer))
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
		}
	}
};

module.exports = ContactsPopupView;


/***/ },
/* 65 */
/*!************************************!*\
  !*** ./dev/View/Popup/Identity.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function IdentityPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsIdentity');

	var self = this;

	this.id = '';
	this.edit = ko.observable(false);
	this.owner = ko.observable(false);

	this.email = ko.observable('').validateEmail();
	this.email.focused = ko.observable(false);
	this.name = ko.observable('');
	this.name.focused = ko.observable(false);
	this.replyTo = ko.observable('').validateSimpleEmail();
	this.replyTo.focused = ko.observable(false);
	this.bcc = ko.observable('').validateSimpleEmail();
	this.bcc.focused = ko.observable(false);

	this.signature = ko.observable('');
	this.signatureInsertBefore = ko.observable(false);

	this.showBcc = ko.observable(false);
	this.showReplyTo = ko.observable(false);

	this.submitRequest = ko.observable(false);
	this.submitError = ko.observable('');

	this.bcc.subscribe(function(aValue) {
		if (false === self.showBcc() && 0 < aValue.length)
		{
			self.showBcc(true);
		}
	}, this);

	this.replyTo.subscribe(function(aValue) {
		if (false === self.showReplyTo() && 0 < aValue.length)
		{
			self.showReplyTo(true);
		}
	}, this);

	this.addOrEditIdentityCommand = Utils.createCommand(this, function() {

		if (this.signature && this.signature.__fetchEditorValue)
		{
			this.signature.__fetchEditorValue();
		}

		if (!this.email.hasError())
		{
			this.email.hasError('' === Utils.trim(this.email()));
		}

		if (this.email.hasError())
		{
			if (!this.owner())
			{
				this.email.focused(true);
			}

			return false;
		}

		if (this.replyTo.hasError())
		{
			this.replyTo.focused(true);
			return false;
		}

		if (this.bcc.hasError())
		{
			this.bcc.focused(true);
			return false;
		}

		this.submitRequest(true);

		Remote.identityUpdate(_.bind(function(sResult, oData) {

			this.submitRequest(false);
			if (Enums.StorageResultType.Success === sResult && oData)
			{
				if (oData.Result)
				{
					__webpack_require__(/*! App/User */ 8).default.accountsAndIdentities();
					this.cancelCommand();
				}
				else if (oData.ErrorCode)
				{
					this.submitError(Translator.getNotification(oData.ErrorCode));
				}
			}
			else
			{
				this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
			}

		}, this), this.id, this.email(), this.name(), this.replyTo(), this.bcc(),
			this.signature(), this.signatureInsertBefore());

		return true;

	}, function() {
		return !this.submitRequest();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Identity', 'PopupsIdentityViewModel'], IdentityPopupView);
_.extend(IdentityPopupView.prototype, AbstractView.prototype);

IdentityPopupView.prototype.clearPopup = function()
{
	this.id = '';
	this.edit(false);
	this.owner(false);

	this.name('');
	this.email('');
	this.replyTo('');
	this.bcc('');
	this.signature('');
	this.signatureInsertBefore(false);

	this.email.hasError(false);
	this.replyTo.hasError(false);
	this.bcc.hasError(false);

	this.showBcc(false);
	this.showReplyTo(false);

	this.submitRequest(false);
	this.submitError('');
};

/**
 * @param {?IdentityModel} oIdentity
 */
IdentityPopupView.prototype.onShow = function(oIdentity)
{
	this.clearPopup();

	if (oIdentity)
	{
		this.edit(true);

		this.id = oIdentity.id() || '';
		this.name(oIdentity.name());
		this.email(oIdentity.email());
		this.replyTo(oIdentity.replyTo());
		this.bcc(oIdentity.bcc());
		this.signature(oIdentity.signature());
		this.signatureInsertBefore(oIdentity.signatureInsertBefore());

		this.owner('' === this.id);
	}
	else
	{
		this.id = Utils.fakeMd5();
	}
};

IdentityPopupView.prototype.onShowWithDelay = function()
{
	if (!this.owner() && !Globals.bMobile)
	{
		this.email.focused(true);
	}
};

IdentityPopupView.prototype.onHideWithDelay = function()
{
	this.clearPopup();
};

module.exports = IdentityPopupView;


/***/ },
/* 66 */
/*!******************************!*\
  !*** ./dev/App/Abstract.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __WEBPACK_IMPORTED_MODULE_3_key__ && __WEBPACK_IMPORTED_MODULE_3_key__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_key__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_key__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_key___default, 'a', __WEBPACK_IMPORTED_MODULE_3_key___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Cmd__ = __webpack_require__(/*! Common/Cmd */ 68);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractBoot__ = __webpack_require__(/*! Knoin/AbstractBoot */ 79);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractApp; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




















var AbstractApp = function (_AbstractBoot) {
	_inherits(AbstractApp, _AbstractBoot);

	/**
  * @param {RemoteStorage|AdminRemoteStorage} Remote
  */

	function AbstractApp(Remote) {
		_classCallCheck(this, AbstractApp);

		var _this = _possibleConstructorReturn(this, _AbstractBoot.call(this));

		_this.googlePreviewSupportedCache = null;
		_this.isLocalAutocomplete = true;
		_this.iframe = null;
		_this.lastErrorTime = 0;

		_this.iframe = __WEBPACK_IMPORTED_MODULE_1_____default()('<iframe class="internal-hiddden" />').appendTo('body');

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].on('error', function (event) {
			if (event && event.originalEvent && event.originalEvent.message && -1 === __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(event.originalEvent.message, ['Script error.', 'Uncaught Error: Error calling method on NPObject.'])) {
				var time = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["timestamp"])();
				if (_this.lastErrorTime >= time) {
					return;
				}

				_this.lastErrorTime = time;

				Remote.jsError(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], event.originalEvent.message, event.originalEvent.filename, event.originalEvent.lineno, __WEBPACK_IMPORTED_MODULE_0_window___default.a.location && __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.toString ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.toString() : '', __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].attr('class'), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])() - __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["startMicrotime"]);
			}
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].on('resize', function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('window.resize');
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('window.resize', __WEBPACK_IMPORTED_MODULE_2_____default.a.throttle(function () {
			var iH = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].height(),
			    iW = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].height();

			if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[0] !== iH || __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[1] !== iW) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[0] = iH;
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[1] = iW;

				__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('window.resize.real');
			}
		}, 50));

		// DEBUG
		//		Events.sub({
		//			'window.resize': function() {
		//				window.console.log('window.resize');
		//			},
		//			'window.resize.real': function() {
		//				window.console.log('window.resize.real');
		//			}
		//		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$doc"].on('keydown', function (event) {
			if (event && event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('rl-ctrl-key-pressed');
			}
		}).on('keyup', function (event) {
			if (event && !event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('rl-ctrl-key-pressed');
			}
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$doc"].on('mousemove keypress click', __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('rl.auto-logout-refresh');
		}, 5000));

		__WEBPACK_IMPORTED_MODULE_3_key___default()('esc, enter', __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["KeyState"].All, function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["detectDropdownVisibility"])();
		});

		__WEBPACK_IMPORTED_MODULE_3_key___default()('ctrl+shift+`', __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["KeyState"].All, function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_11_Common_Cmd__["a" /* toggle */])();
		});
		return _this;
	}

	AbstractApp.prototype.remote = function remote() {
		return null;
	};

	AbstractApp.prototype.data = function data() {
		return null;
	};

	AbstractApp.prototype.getApplicationConfiguration = function getApplicationConfiguration(name, default_) {
		return this.applicationConfiguration[name] || default_;
	};

	/**
  * @param {string} link
  * @returns {boolean}
  */


	AbstractApp.prototype.download = function download(link) {

		if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"] && (-1 < __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"].indexOf('chrome') || -1 < __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"].indexOf('chrome'))) {
			var oLink = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('a');
			oLink.href = link;

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createEvent) {
				var oE = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createEvent.MouseEvents;
				if (oE && oE.initEvent && oLink.dispatchEvent) {
					oE.initEvent('click', true, true);
					oLink.dispatchEvent(oE);
					return true;
				}
			}
		}

		if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bMobileDevice"]) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.open(link, '_self');
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.focus();
		} else {
			this.iframe.attr('src', link);
			//		window.document.location.href = link;
		}

		return true;
	};

	/**
  * @returns {boolean}
  */


	AbstractApp.prototype.googlePreviewSupported = function googlePreviewSupported() {
		if (null === this.googlePreviewSupportedCache) {
			this.googlePreviewSupportedCache = !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AllowGoogleSocial') && !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AllowGoogleSocialPreview');
		}

		return this.googlePreviewSupportedCache;
	};

	/**
  * @param {string} title
  */


	AbstractApp.prototype.setWindowTitle = function setWindowTitle(title) {
		title = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(title) && 0 < title.length ? '' + title : '';
		if (__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Title')) {
			title += (title ? ' - ' : '') + __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Title');
		}

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.title = title + ' ...';
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.title = title;
	};

	AbstractApp.prototype.redirectToAdminPanel = function redirectToAdminPanel() {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootAdmin"]();
		}, 100);
	};

	AbstractApp.prototype.clearClientSideToken = function clearClientSideToken() {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_clear) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_clear();
		}
	};

	/**
  * @param {string} token
  */


	AbstractApp.prototype.setClientSideToken = function setClientSideToken(token) {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_set) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_set(token);

			__webpack_require__(/*! Storage/Settings */ 7).settingsSet('AuthAccountHash', token);
			__webpack_require__(/*! Common/Links */ 12).populateAuthSuffix();
		}
	};

	/**
  * @param {boolean=} admin = false
  * @param {boolean=} logout = false
  * @param {boolean=} close = false
  */


	AbstractApp.prototype.loginAndLogoutReload = function loginAndLogoutReload() {
		var admin = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var logout = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
		var close = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];


		var mobile = __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('mobile'),
		    inIframe = !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('inIframe');

		var customLogoutLink = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('customLogoutLink'));

		if (logout) {
			this.clearClientSideToken();
		}

		if (logout && close && __WEBPACK_IMPORTED_MODULE_0_window___default.a.close) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.close();
		}

		customLogoutLink = customLogoutLink || (admin ? __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootAdmin"](mobile) : __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootUser"](mobile));

		if (logout && __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href !== customLogoutLink) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				if (inIframe && __WEBPACK_IMPORTED_MODULE_0_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent.location.href = customLogoutLink;
				} else {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = customLogoutLink;
				}
			}, 100);
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["routeOff"])();
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_7_Common_Links__["root"](), true);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				if (inIframe && __WEBPACK_IMPORTED_MODULE_0_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent.location.reload();
				} else {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.reload();
				}
			}, 100);
		}
	};

	AbstractApp.prototype.historyBack = function historyBack() {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.history.back();
	};

	AbstractApp.prototype.bootstart = function bootstart() {

		// log('Ps' + 'ss, hac' + 'kers! The' + 're\'s not' + 'hing inte' + 'resting :' + ')');

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('rl.bootstart');

		var mobile = __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('mobile'),
		    ssm = __webpack_require__(/*! ssm */ 88),
		    ko = __webpack_require__(/*! ko */ 1);

		ko.components.register('SaveTrigger', __webpack_require__(/*! Component/SaveTrigger */ 75));
		ko.components.register('Input', __webpack_require__(/*! Component/Input */ 72));
		ko.components.register('Select', __webpack_require__(/*! Component/Select */ 77));
		ko.components.register('Radio', __webpack_require__(/*! Component/Radio */ 74));
		ko.components.register('TextArea', __webpack_require__(/*! Component/TextArea */ 78));
		ko.components.register('Date', __webpack_require__(/*! Component/Date */ 71));

		ko.components.register('x-script', __webpack_require__(/*! Component/Script */ 76));
		//		ko.components.register('svg-icon', require('Component/SvgIcon'));

		if (__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('materialDesign') && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bAnimationSupported"]) {
			ko.components.register('Checkbox', __webpack_require__(/*! Component/MaterialDesign/Checkbox */ 73));
			ko.components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 36));
		} else {
			//			ko.components.register('Checkbox', require('Component/Classic/Checkbox'));
			//			ko.components.register('CheckboxSimple', require('Component/Classic/Checkbox'));
			ko.components.register('Checkbox', __webpack_require__(/*! Component/Checkbox */ 36));
			ko.components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 36));
		}

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["initOnStartOrLangChange"])(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["initNotificationLanguage"]);

		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["windowResizeCallback"], 1000);

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('ssm.mobile-enter', function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"])(true);
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('ssm.mobile-leave', function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"])(false);
		});

		if (!mobile) {
			ssm.addState({
				id: 'mobile',
				maxWidth: 767,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-enter');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-leave');
				}
			});

			ssm.addState({
				id: 'tablet',
				minWidth: 768,
				maxWidth: 999,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-tablet');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-tablet');
				}
			});

			ssm.addState({
				id: 'desktop',
				minWidth: 1000,
				maxWidth: 1400,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-desktop');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-desktop');
				}
			});

			ssm.addState({
				id: 'desktop-large',
				minWidth: 1400,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-desktop-large');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-desktop-large');
				}
			});
		} else {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-mobile').addClass('rl-mobile');
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-enter');
		}

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"].subscribe(function (bValue) {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-disabled', bValue);
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-enabled', !bValue);
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelType"].subscribe(function (sValue) {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-none', 'none' === sValue);
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-short', 'short' === sValue);
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"].valueHasMutated();

		ssm.ready();

		__webpack_require__(/*! Stores/Language */ 38).populate();
		__webpack_require__(/*! Stores/Theme */ 43).populate();
		__webpack_require__(/*! Stores/Social */ 34).populate();
	};

	return AbstractApp;
}(__WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractBoot__["a" /* AbstractBoot */]);



/***/ },
/* 67 */
/*!******************************!*\
  !*** ./dev/Common/Audio.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }








var Audio = function () {
	function Audio() {
		var _this = this;

		_classCallCheck(this, Audio);

		this.notificator = null;

		this.supportedMp3 = false;
		this.supportedOgg = false;
		this.supportedWav = false;
		this.supportedNotification = false;

		this.player = this.createNewObject();

		this.supported = !__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bMobileDevice"] && !__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["bSafari"] && !!this.player && !!this.player.play;
		if (this.supported && this.player.canPlayType) {
			this.supportedMp3 = '' !== this.player.canPlayType('audio/mpeg;').replace(/no/, '');
			this.supportedWav = '' !== this.player.canPlayType('audio/wav; codecs="1"').replace(/no/, '');
			this.supportedOgg = '' !== this.player.canPlayType('audio/ogg; codecs="vorbis"').replace(/no/, '');
			this.supportedNotification = this.supported && this.supportedMp3;
		}

		if (!this.player || !this.supportedMp3 && !this.supportedOgg && !this.supportedWav) {
			this.supported = false;
			this.supportedMp3 = false;
			this.supportedOgg = false;
			this.supportedWav = false;
			this.supportedNotification = false;
		}

		if (this.supported) {
			__WEBPACK_IMPORTED_MODULE_1_____default()(this.player).on('ended error', function () {
				return _this.stop();
			});

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["sub"]('audio.api.stop', function () {
				return _this.stop();
			});
		}
	}

	Audio.prototype.createNewObject = function createNewObject() {
		var player = __WEBPACK_IMPORTED_MODULE_0_window___default.a.Audio ? new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Audio() : null;
		if (player && player.canPlayType && player.pause && player.play) {
			player.preload = 'none';
			player.loop = false;
			player.autoplay = false;
			player.muted = false;
		}

		return player;
	};

	Audio.prototype.paused = function paused() {
		return this.supported ? !!this.player.paused : true;
	};

	Audio.prototype.stop = function stop() {
		if (this.supported && this.player.pause) {
			this.player.pause();
		}

		__WEBPACK_IMPORTED_MODULE_4_Common_Events__["pub"]('audio.stop');
	};

	Audio.prototype.pause = function pause() {
		this.stop();
	};

	Audio.prototype.clearName = function clearName() {
		var name = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];
		var ext = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];


		name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(name);
		if (ext && '.' + ext === name.toLowerCase().substr((ext.length + 1) * -1)) {
			name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(name.substr(0, name.length - 4));
		}

		return '' === name ? 'audio' : name;
	};

	Audio.prototype.playMp3 = function playMp3(url, name) {
		if (this.supported && this.supportedMp3) {
			this.player.src = url;
			this.player.play();

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["pub"]('audio.start', [this.clearName(name, 'mp3'), 'mp3']);
		}
	};

	Audio.prototype.playOgg = function playOgg(url, name) {
		if (this.supported && this.supportedOgg) {
			this.player.src = url;
			this.player.play();

			name = this.clearName(name, 'oga');
			name = this.clearName(name, 'ogg');

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["pub"]('audio.start', [name, 'ogg']);
		}
	};

	Audio.prototype.playWav = function playWav(url, name) {
		if (this.supported && this.supportedWav) {
			this.player.src = url;
			this.player.play();

			__WEBPACK_IMPORTED_MODULE_4_Common_Events__["pub"]('audio.start', [this.clearName(name, 'wav'), 'wav']);
		}
	};

	Audio.prototype.playNotification = function playNotification() {
		if (this.supported && this.supportedMp3) {
			if (!this.notificator) {
				this.notificator = this.createNewObject();
				this.notificator.src = __WEBPACK_IMPORTED_MODULE_3_Common_Links__["sound"]('new-mail.mp3');
			}

			if (this.notificator && this.notificator.play) {
				this.notificator.play();
			}
		}
	};

	return Audio;
}();

module.exports = new Audio();

/***/ },
/* 68 */
/*!****************************!*\
  !*** ./dev/Common/Cmd.jsx ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony export */ exports["a"] = toggle;
// import window from 'window';




var opened = false,
    cmdDom = null;

/**
 * @returns {void}
 */
function init() {
	if (null === cmdDom) {
		cmdDom = __WEBPACK_IMPORTED_MODULE_0_____default()('<div class="rl-cmd"></div>');
		cmdDom.appendTo(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$body"]);
	}
}

/**
 * @returns {void}
 */
function toggle() {
	init();

	opened = !opened;

	__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
		cmdDom.toggleClass('opened', opened);
	}, 50);
}

/***/ },
/* 69 */
/*!*****************************!*\
  !*** ./dev/Common/Mime.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "a", function() { return Mime; });/* unused harmony export default */
/* eslint key-spacing: 0 */
/* eslint quote-props: 0 */

var Mime = {
	'eml': 'message/rfc822',
	'mime': 'message/rfc822',
	'txt': 'text/plain',
	'text': 'text/plain',
	'def': 'text/plain',
	'list': 'text/plain',
	'in': 'text/plain',
	'ini': 'text/plain',
	'log': 'text/plain',
	'sql': 'text/plain',
	'cfg': 'text/plain',
	'conf': 'text/plain',
	'asc': 'text/plain',
	'rtx': 'text/richtext',
	'vcard': 'text/vcard',
	'vcf': 'text/vcard',
	'htm': 'text/html',
	'html': 'text/html',
	'csv': 'text/csv',
	'ics': 'text/calendar',
	'ifb': 'text/calendar',
	'xml': 'text/xml',
	'json': 'application/json',
	'swf': 'application/x-shockwave-flash',
	'hlp': 'application/winhlp',
	'wgt': 'application/widget',
	'chm': 'application/vnd.ms-htmlhelp',
	'p10': 'application/pkcs10',
	'p7c': 'application/pkcs7-mime',
	'p7m': 'application/pkcs7-mime',
	'p7s': 'application/pkcs7-signature',
	'torrent': 'application/x-bittorrent',

	// scripts
	'js': 'application/javascript',
	'pl': 'text/perl',
	'css': 'text/css',
	'asp': 'text/asp',
	'php': 'application/x-httpd-php',
	'php3': 'application/x-httpd-php',
	'php4': 'application/x-httpd-php',
	'php5': 'application/x-httpd-php',
	'phtml': 'application/x-httpd-php',

	// images
	'png': 'image/png',
	'jpg': 'image/jpeg',
	'jpeg': 'image/jpeg',
	'jpe': 'image/jpeg',
	'jfif': 'image/jpeg',
	'gif': 'image/gif',
	'bmp': 'image/bmp',
	'cgm': 'image/cgm',
	'ief': 'image/ief',
	'ico': 'image/x-icon',
	'tif': 'image/tiff',
	'tiff': 'image/tiff',
	'svg': 'image/svg+xml',
	'svgz': 'image/svg+xml',
	'djv': 'image/vnd.djvu',
	'djvu': 'image/vnd.djvu',
	'webp': 'image/webp',

	// archives
	'zip': 'application/zip',
	'7z': 'application/x-7z-compressed',
	'rar': 'application/x-rar-compressed',
	'exe': 'application/x-msdownload',
	'dll': 'application/x-msdownload',
	'scr': 'application/x-msdownload',
	'com': 'application/x-msdownload',
	'bat': 'application/x-msdownload',
	'msi': 'application/x-msdownload',
	'cab': 'application/vnd.ms-cab-compressed',
	'gz': 'application/x-gzip',
	'tgz': 'application/x-gzip',
	'bz': 'application/x-bzip',
	'bz2': 'application/x-bzip2',
	'deb': 'application/x-debian-package',

	// fonts
	'psf': 'application/x-font-linux-psf',
	'otf': 'application/x-font-otf',
	'pcf': 'application/x-font-pcf',
	'snf': 'application/x-font-snf',
	'ttf': 'application/x-font-ttf',
	'ttc': 'application/x-font-ttf',

	// audio
	'mp3': 'audio/mpeg',
	'amr': 'audio/amr',
	'aac': 'audio/x-aac',
	'aif': 'audio/x-aiff',
	'aifc': 'audio/x-aiff',
	'aiff': 'audio/x-aiff',
	'wav': 'audio/x-wav',
	'wma': 'audio/x-ms-wma',
	'wax': 'audio/x-ms-wax',
	'midi': 'audio/midi',
	'mp4a': 'audio/mp4',
	'ogg': 'audio/ogg',
	'weba': 'audio/webm',
	'ra': 'audio/x-pn-realaudio',
	'ram': 'audio/x-pn-realaudio',
	'rmp': 'audio/x-pn-realaudio-plugin',
	'm3u': 'audio/x-mpegurl',

	// video
	'flv': 'video/x-flv',
	'qt': 'video/quicktime',
	'mov': 'video/quicktime',
	'wmv': 'video/windows-media',
	'avi': 'video/x-msvideo',
	'mpg': 'video/mpeg',
	'mpeg': 'video/mpeg',
	'mpe': 'video/mpeg',
	'm1v': 'video/mpeg',
	'm2v': 'video/mpeg',
	'3gp': 'video/3gpp',
	'3g2': 'video/3gpp2',
	'h261': 'video/h261',
	'h263': 'video/h263',
	'h264': 'video/h264',
	'jpgv': 'video/jpgv',
	'mp4': 'video/mp4',
	'mp4v': 'video/mp4',
	'mpg4': 'video/mp4',
	'ogv': 'video/ogg',
	'webm': 'video/webm',
	'm4v': 'video/x-m4v',
	'asf': 'video/x-ms-asf',
	'asx': 'video/x-ms-asf',
	'wm': 'video/x-ms-wm',
	'wmx': 'video/x-ms-wmx',
	'wvx': 'video/x-ms-wvx',
	'movie': 'video/x-sgi-movie',

	// adobe
	'pdf': 'application/pdf',
	'psd': 'image/vnd.adobe.photoshop',
	'ai': 'application/postscript',
	'eps': 'application/postscript',
	'ps': 'application/postscript',

	// ms office
	'doc': 'application/msword',
	'dot': 'application/msword',
	'rtf': 'application/rtf',
	'xls': 'application/vnd.ms-excel',
	'ppt': 'application/vnd.ms-powerpoint',
	'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'dotx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',

	// open office
	'odt': 'application/vnd.oasis.opendocument.text',
	'ods': 'application/vnd.oasis.opendocument.spreadsheet'
};



/***/ },
/* 70 */
/*!****************************************!*\
  !*** ./dev/Component/AbstracRadio.jsx ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstracRadio; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AbstracRadio = function (_AbstractComponent) {
	_inherits(AbstracRadio, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function AbstracRadio(params) {
		_classCallCheck(this, AbstracRadio);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.values = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observableArray([]);

		_this.value = params.value;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		}

		_this.inline = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;
		_this.readOnly = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;

		if (params.values) {
			_this.values(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(params.values, function (label, value) {
				return { label: label, value: value };
			}));
		}

		_this.click = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.click, _this);
		return _this;
	}

	AbstracRadio.prototype.click = function click(value) {
		if (!this.readOnly && value) {
			this.value(value.value);
		}
	};

	return AbstracRadio;
}(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 71 */
/*!********************************!*\
  !*** ./dev/Component/Date.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var DateComponent = function (_AbstractInput) {
  _inherits(DateComponent, _AbstractInput);

  function DateComponent() {
    _classCallCheck(this, DateComponent);

    return _possibleConstructorReturn(this, _AbstractInput.apply(this, arguments));
  }

  return DateComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(DateComponent, 'DateComponent');

/***/ },
/* 72 */
/*!*********************************!*\
  !*** ./dev/Component/Input.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var InputComponent = function (_AbstractInput) {
  _inherits(InputComponent, _AbstractInput);

  function InputComponent() {
    _classCallCheck(this, InputComponent);

    return _possibleConstructorReturn(this, _AbstractInput.apply(this, arguments));
  }

  return InputComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(InputComponent, 'InputComponent');

/***/ },
/* 73 */
/*!***************************************************!*\
  !*** ./dev/Component/MaterialDesign/Checkbox.jsx ***!
  \***************************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 46);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var CheckboxMaterialDesignComponent = function (_AbstracCheckbox) {
	_inherits(CheckboxMaterialDesignComponent, _AbstracCheckbox);

	/**
  * @constructor
  * @param {Object} params
  */

	function CheckboxMaterialDesignComponent(params) {
		_classCallCheck(this, CheckboxMaterialDesignComponent);

		var _this = _possibleConstructorReturn(this, _AbstracCheckbox.call(this, params));

		_this.animationBox = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ falseTimeout: 200 });
		_this.animationCheckmark = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ falseTimeout: 200 });

		_this.animationBoxSetTrue = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.animationBoxSetTrue, _this);
		_this.animationCheckmarkSetTrue = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.animationCheckmarkSetTrue, _this);

		_this.disposable.push(_this.value.subscribe(function (value) {
			_this.triggerAnimation(value);
		}, _this));
		return _this;
	}

	CheckboxMaterialDesignComponent.prototype.animationBoxSetTrue = function animationBoxSetTrue() {
		this.animationBox(true);
	};

	CheckboxMaterialDesignComponent.prototype.animationCheckmarkSetTrue = function animationCheckmarkSetTrue() {
		this.animationCheckmark(true);
	};

	CheckboxMaterialDesignComponent.prototype.triggerAnimation = function triggerAnimation(box) {
		if (box) {
			this.animationBoxSetTrue();
			__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(this.animationCheckmarkSetTrue, 200);
		} else {
			this.animationCheckmarkSetTrue();
			__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(this.animationBoxSetTrue, 200);
		}
	};

	return CheckboxMaterialDesignComponent;
}(__WEBPACK_IMPORTED_MODULE_3_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(CheckboxMaterialDesignComponent, 'CheckboxMaterialDesignComponent');

/***/ },
/* 74 */
/*!*********************************!*\
  !*** ./dev/Component/Radio.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstracRadio__ = __webpack_require__(/*! Component/AbstracRadio */ 70);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var RadioComponent = function (_AbstracRadio) {
  _inherits(RadioComponent, _AbstracRadio);

  function RadioComponent() {
    _classCallCheck(this, RadioComponent);

    return _possibleConstructorReturn(this, _AbstracRadio.apply(this, arguments));
  }

  return RadioComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstracRadio__["a" /* AbstracRadio */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(RadioComponent, 'RadioComponent');

/***/ },
/* 75 */
/*!***************************************!*\
  !*** ./dev/Component/SaveTrigger.jsx ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var SaveTriggerComponent = function (_AbstractComponent) {
	_inherits(SaveTriggerComponent, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function SaveTriggerComponent(params) {
		_classCallCheck(this, SaveTriggerComponent);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.element = params.element || null;
		_this.value = params.value && params.value.subscribe ? params.value : null;

		if (_this.element) {
			if (_this.value) {
				_this.element.css('display', 'inline-block');

				if (params.verticalAlign) {
					_this.element.css('vertical-align', params.verticalAlign);
				}

				_this.setState(_this.value());

				_this.disposable.push(_this.value.subscribe(_this.setState, _this));
			} else {
				_this.element.hide();
			}
		}
		return _this;
	}

	SaveTriggerComponent.prototype.setState = function setState(value) {

		switch (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.element.find('.animated,.error').hide().removeClass('visible').end().find('.success').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.element.find('.animated,.success').hide().removeClass('visible').end().find('.error').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].Animate:
				this.element.find('.error,.success').hide().removeClass('visible').end().find('.animated').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].Idle:
			default:
				this.element.find('.animated').hide().end().find('.error,.success').removeClass('visible');
				break;
		}
	};

	return SaveTriggerComponent;
}(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["a" /* AbstractComponent */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(SaveTriggerComponent, 'SaveTriggerComponent');

/***/ },
/* 76 */
/*!**********************************!*\
  !*** ./dev/Component/Script.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var ScriptComponent = function (_AbstractComponent) {
	_inherits(ScriptComponent, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function ScriptComponent(params) {
		_classCallCheck(this, ScriptComponent);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		if (params.component && params.component.templateNodes && params.element && params.element[0] && params.element[0].outerHTML) {
			var script = params.element[0].outerHTML;
			script = !script ? '' : script.replace(/<x-script/i, '<script').replace(/<b><\/b><\/x-script>/i, '</script>');

			if (script) {
				params.element.text('');
				params.element.replaceWith(__WEBPACK_IMPORTED_MODULE_0_____default()(script).text(params.component.templateNodes[0] && params.component.templateNodes[0].nodeValue ? params.component.templateNodes[0].nodeValue : ''));
			} else {
				params.element.remove();
			}
		}
		return _this;
	}

	return ScriptComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["a" /* AbstractComponent */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["b" /* componentExportHelper */])(ScriptComponent, 'ScriptComponent');

/***/ },
/* 77 */
/*!**********************************!*\
  !*** ./dev/Component/Select.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var SelectComponent = function (_AbstractInput) {
	_inherits(SelectComponent, _AbstractInput);

	/**
  * @constructor
  * @param {Object} params
  */

	function SelectComponent(params) {
		_classCallCheck(this, SelectComponent);

		var _this = _possibleConstructorReturn(this, _AbstractInput.call(this, params));

		_this.options = params.options || '';

		_this.optionsText = params.optionsText || null;
		_this.optionsValue = params.optionsValue || null;
		_this.optionsCaption = params.optionsCaption || null;

		if (_this.optionsCaption) {
			_this.optionsCaption = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Translator__["i18n"])(_this.optionsCaption);
		}

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_1_Common_Utils__["defautOptionsAfterRender"];
		return _this;
	}

	return SelectComponent;
}(__WEBPACK_IMPORTED_MODULE_3_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(SelectComponent, 'SelectComponent');

/***/ },
/* 78 */
/*!************************************!*\
  !*** ./dev/Component/TextArea.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var DEFAULT_ROWS = 5;

var TextAreaComponent = function (_AbstractInput) {
	_inherits(TextAreaComponent, _AbstractInput);

	/**
  * @constructor
  * @param {Object} params
  */

	function TextAreaComponent(params) {
		_classCallCheck(this, TextAreaComponent);

		var _this = _possibleConstructorReturn(this, _AbstractInput.call(this, params));

		_this.rows = params.rows || DEFAULT_ROWS;
		_this.spellcheck = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isUnd"])(params.spellcheck) ? false : !!params.spellcheck;
		return _this;
	}

	return TextAreaComponent;
}(__WEBPACK_IMPORTED_MODULE_2_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["b" /* componentExportHelper */])(TextAreaComponent, 'TextAreaComponent');

/***/ },
/* 79 */
/*!************************************!*\
  !*** ./dev/Knoin/AbstractBoot.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractBoot; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var AbstractBoot = function () {
	function AbstractBoot() {
		_classCallCheck(this, AbstractBoot);
	}

	AbstractBoot.prototype.bootstart = function bootstart() {/* no-empty */};

	return AbstractBoot;
}();



/***/ },
/* 80 */
/*!*****************************************!*\
  !*** ./dev/Screen/AbstractSettings.jsx ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractScreen__ = __webpack_require__(/*! Knoin/AbstractScreen */ 40);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractSettingsScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var AbstractSettingsScreen = function (_AbstractScreen) {
	_inherits(AbstractSettingsScreen, _AbstractScreen);

	/**
  * @param {Array} viewModels
  */

	function AbstractSettingsScreen(viewModels) {
		_classCallCheck(this, AbstractSettingsScreen);

		var _this = _possibleConstructorReturn(this, _AbstractScreen.call(this, 'settings', viewModels));

		_this.menu = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observableArray([]);

		_this.oCurrentSubScreen = null;
		_this.oViewModelPlace = null;

		_this.setupSettings();
		return _this;
	}

	/**
  * @param {Function=} fCallback
  */


	AbstractSettingsScreen.prototype.setupSettings = function setupSettings() {
		var fCallback = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];

		if (fCallback) {
			fCallback();
		}
	};

	AbstractSettingsScreen.prototype.onRoute = function onRoute(sSubName) {
		var self = this,
		    oSettingsScreen = null,
		    RoutedSettingsViewModel = null,
		    oViewModelPlace = null,
		    oViewModelDom = null;

		RoutedSettingsViewModel = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && sSubName === SettingsViewModel.__rlSettingsData.Route;
		});

		if (RoutedSettingsViewModel) {
			if (__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-removed'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}

			if (RoutedSettingsViewModel && __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-disabled'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}
		}

		if (RoutedSettingsViewModel) {
			if (RoutedSettingsViewModel.__builded && RoutedSettingsViewModel.__vm) {
				oSettingsScreen = RoutedSettingsViewModel.__vm;
			} else {
				oViewModelPlace = this.oViewModelPlace;
				if (oViewModelPlace && 1 === oViewModelPlace.length) {
					oSettingsScreen = new RoutedSettingsViewModel();

					oViewModelDom = __WEBPACK_IMPORTED_MODULE_1_____default()('<div></div>').addClass('rl-settings-view-model').hide();
					oViewModelDom.appendTo(oViewModelPlace);

					oSettingsScreen.viewModelDom = oViewModelDom;

					oSettingsScreen.__rlSettingsData = RoutedSettingsViewModel.__rlSettingsData;

					RoutedSettingsViewModel.__dom = oViewModelDom;
					RoutedSettingsViewModel.__builded = true;
					RoutedSettingsViewModel.__vm = oSettingsScreen;

					__WEBPACK_IMPORTED_MODULE_2_ko___default.a.applyBindingAccessorsToNode(oViewModelDom[0], {
						translatorInit: true,
						template: function template() {
							return { name: RoutedSettingsViewModel.__rlSettingsData.Template };
						}
					}, oSettingsScreen);

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(oSettingsScreen, 'onBuild', [oViewModelDom]);
				} else {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["log"])('Cannot find sub settings view model position: SettingsSubScreen');
				}
			}

			if (oSettingsScreen) {
				__WEBPACK_IMPORTED_MODULE_0_____default.a.defer(function () {
					// hide
					if (self.oCurrentSubScreen) {
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onHide');
						self.oCurrentSubScreen.viewModelDom.hide();
					}
					// --

					self.oCurrentSubScreen = oSettingsScreen;

					// show
					if (self.oCurrentSubScreen) {
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onBeforeShow');
						self.oCurrentSubScreen.viewModelDom.show();
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onShow');
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onShowWithDelay', [], 200);

						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(self.menu(), function (oItem) {
							oItem.selected(oSettingsScreen && oSettingsScreen.__rlSettingsData && oItem.route === oSettingsScreen.__rlSettingsData.Route);
						});

						__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content .b-settings .b-content .content').scrollTop(0);
					}
					// --

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["windowResize"])();
				});
			}
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__["setHash"])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Links__["settings"])(), false, true);
		}
	};

	AbstractSettingsScreen.prototype.onHide = function onHide() {
		if (this.oCurrentSubScreen && this.oCurrentSubScreen.viewModelDom) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(this.oCurrentSubScreen, 'onHide');
			this.oCurrentSubScreen.viewModelDom.hide();
		}
	};

	AbstractSettingsScreen.prototype.onBuild = function onBuild() {
		var _this2 = this;

		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			if (SettingsViewModel && SettingsViewModel.__rlSettingsData && !__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-removed'], function (RemoveSettingsViewModel) {
				return RemoveSettingsViewModel && RemoveSettingsViewModel === SettingsViewModel;
			})) {
				_this2.menu.push({
					route: SettingsViewModel.__rlSettingsData.Route,
					label: SettingsViewModel.__rlSettingsData.Label,
					selected: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false),
					disabled: !!__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-disabled'], function (DisabledSettingsViewModel) {
						return DisabledSettingsViewModel && DisabledSettingsViewModel === SettingsViewModel;
					})
				});
			}
		});

		this.oViewModelPlace = __WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content #rl-settings-subscreen');
	};

	AbstractSettingsScreen.prototype.routes = function routes() {
		var DefaultViewModel = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && SettingsViewModel.__rlSettingsData.IsDefault;
		}),
		    defaultRoute = DefaultViewModel && DefaultViewModel.__rlSettingsData ? DefaultViewModel.__rlSettingsData.Route : 'general',
		    oRules = {
			subname: /^(.*)$/,
			normalize_: function normalize_(oRequest, oVals) {
				oVals.subname = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(oVals.subname) ? defaultRoute : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pString"])(oVals.subname);
				return [oVals.subname];
			}
		};

		return [['{subname}/', oRules], ['{subname}', oRules], ['', oRules]];
	};

	return AbstractSettingsScreen;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractScreen__["a" /* AbstractScreen */]);



/***/ },
/* 81 */
/*!************************************!*\
  !*** ./dev/Stores/AbstractApp.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractAppStore; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractAppStore = function () {
	function AbstractAppStore() {
		_classCallCheck(this, AbstractAppStore);

		this.allowLanguagesOnSettings = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
		this.allowLanguagesOnLogin = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);

		this.interfaceAnimation = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);

		this.interfaceAnimation.subscribe(function (bValue) {
			var bAnim = __WEBPACK_IMPORTED_MODULE_1_Common_Globals__["bMobileDevice"] || !bValue;
			__WEBPACK_IMPORTED_MODULE_1_Common_Globals__["$html"].toggleClass('rl-anim', !bAnim).toggleClass('no-rl-anim', bAnim);
		});

		this.interfaceAnimation.valueHasMutated();

		this.prem = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		this.community = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
	}

	AbstractAppStore.prototype.populate = function populate() {
		this.allowLanguagesOnLogin(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AllowLanguagesOnLogin'));
		this.allowLanguagesOnSettings(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AllowLanguagesOnSettings'));

		this.interfaceAnimation(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('InterfaceAnimation'));

		this.prem(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('PremType'));
		this.community(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('Community'));
	};

	return AbstractAppStore;
}();



/***/ },
/* 82 */
/*!******************************!*\
  !*** ./~/pikaday/pikaday.js ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

/*!
 * Pikaday
 *
 * Copyright © 2014 David Bushell | BSD & MIT license | https://github.com/dbushell/Pikaday
 */

(function (root, factory)
{
    'use strict';

    var moment;
    if (true) {
        // CommonJS module
        // Load moment.js as an optional dependency
        try { moment = __webpack_require__(/*! moment */ 41); } catch (e) {}
        module.exports = factory(moment);
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(function (req)
        {
            // Load moment.js as an optional dependency
            var id = 'moment';
            try { moment = req(id); } catch (e) {}
            return factory(moment);
        });
    } else {
        root.Pikaday = factory(root.moment);
    }
}(this, function (moment)
{
    'use strict';

    /**
     * feature detection and helper functions
     */
    var hasMoment = typeof moment === 'function',

    hasEventListeners = !!window.addEventListener,

    document = window.document,

    sto = window.setTimeout,

    addEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.addEventListener(e, callback, !!capture);
        } else {
            el.attachEvent('on' + e, callback);
        }
    },

    removeEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.removeEventListener(e, callback, !!capture);
        } else {
            el.detachEvent('on' + e, callback);
        }
    },

    fireEvent = function(el, eventName, data)
    {
        var ev;

        if (document.createEvent) {
            ev = document.createEvent('HTMLEvents');
            ev.initEvent(eventName, true, false);
            ev = extend(ev, data);
            el.dispatchEvent(ev);
        } else if (document.createEventObject) {
            ev = document.createEventObject();
            ev = extend(ev, data);
            el.fireEvent('on' + eventName, ev);
        }
    },

    trim = function(str)
    {
        return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g,'');
    },

    hasClass = function(el, cn)
    {
        return (' ' + el.className + ' ').indexOf(' ' + cn + ' ') !== -1;
    },

    addClass = function(el, cn)
    {
        if (!hasClass(el, cn)) {
            el.className = (el.className === '') ? cn : el.className + ' ' + cn;
        }
    },

    removeClass = function(el, cn)
    {
        el.className = trim((' ' + el.className + ' ').replace(' ' + cn + ' ', ' '));
    },

    isArray = function(obj)
    {
        return (/Array/).test(Object.prototype.toString.call(obj));
    },

    isDate = function(obj)
    {
        return (/Date/).test(Object.prototype.toString.call(obj)) && !isNaN(obj.getTime());
    },

    isWeekend = function(date)
    {
        var day = date.getDay();
        return day === 0 || day === 6;
    },

    isLeapYear = function(year)
    {
        // solution by Matti Virkkunen: http://stackoverflow.com/a/4881951
        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
    },

    getDaysInMonth = function(year, month)
    {
        return [31, isLeapYear(year) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month];
    },

    setToStartOfDay = function(date)
    {
        if (isDate(date)) date.setHours(0,0,0,0);
    },

    compareDates = function(a,b)
    {
        // weak date comparison (use setToStartOfDay(date) to ensure correct result)
        return a.getTime() === b.getTime();
    },

    extend = function(to, from, overwrite)
    {
        var prop, hasProp;
        for (prop in from) {
            hasProp = to[prop] !== undefined;
            if (hasProp && typeof from[prop] === 'object' && from[prop] !== null && from[prop].nodeName === undefined) {
                if (isDate(from[prop])) {
                    if (overwrite) {
                        to[prop] = new Date(from[prop].getTime());
                    }
                }
                else if (isArray(from[prop])) {
                    if (overwrite) {
                        to[prop] = from[prop].slice(0);
                    }
                } else {
                    to[prop] = extend({}, from[prop], overwrite);
                }
            } else if (overwrite || !hasProp) {
                to[prop] = from[prop];
            }
        }
        return to;
    },

    adjustCalendar = function(calendar) {
        if (calendar.month < 0) {
            calendar.year -= Math.ceil(Math.abs(calendar.month)/12);
            calendar.month += 12;
        }
        if (calendar.month > 11) {
            calendar.year += Math.floor(Math.abs(calendar.month)/12);
            calendar.month -= 12;
        }
        return calendar;
    },

    /**
     * defaults and localisation
     */
    defaults = {

        // bind the picker to a form field
        field: null,

        // automatically show/hide the picker on `field` focus (default `true` if `field` is set)
        bound: undefined,

        // position of the datepicker, relative to the field (default to bottom & left)
        // ('bottom' & 'left' keywords are not used, 'top' & 'right' are modifier on the bottom/left position)
        position: 'bottom left',

        // automatically fit in the viewport even if it means repositioning from the position option
        reposition: true,

        // the default output format for `.toString()` and `field` value
        format: 'YYYY-MM-DD',

        // the initial date to view when first opened
        defaultDate: null,

        // make the `defaultDate` the initial selected value
        setDefaultDate: false,

        // first day of week (0: Sunday, 1: Monday etc)
        firstDay: 0,

        // the minimum/earliest date that can be selected
        minDate: null,
        // the maximum/latest date that can be selected
        maxDate: null,

        // number of years either side, or array of upper/lower range
        yearRange: 10,

        // show week numbers at head of row
        showWeekNumber: false,

        // used internally (don't config outside)
        minYear: 0,
        maxYear: 9999,
        minMonth: undefined,
        maxMonth: undefined,

        startRange: null,
        endRange: null,

        isRTL: false,

        // Additional text to append to the year in the calendar title
        yearSuffix: '',

        // Render the month after year in the calendar title
        showMonthAfterYear: false,

        // how many months are visible
        numberOfMonths: 1,

        // when numberOfMonths is used, this will help you to choose where the main calendar will be (default `left`, can be set to `right`)
        // only used for the first display or when a selected date is not visible
        mainCalendar: 'left',

        // Specify a DOM element to render the calendar in
        container: undefined,

        // internationalization
        i18n: {
            previousMonth : 'Previous Month',
            nextMonth     : 'Next Month',
            months        : ['January','February','March','April','May','June','July','August','September','October','November','December'],
            weekdays      : ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],
            weekdaysShort : ['Sun','Mon','Tue','Wed','Thu','Fri','Sat']
        },

        // Theme Classname
        theme: null,

        // callback function
        onSelect: null,
        onOpen: null,
        onClose: null,
        onDraw: null
    },


    /**
     * templating functions to abstract HTML rendering
     */
    renderDayName = function(opts, day, abbr)
    {
        day += opts.firstDay;
        while (day >= 7) {
            day -= 7;
        }
        return abbr ? opts.i18n.weekdaysShort[day] : opts.i18n.weekdays[day];
    },

    renderDay = function(opts)
    {
        if (opts.isEmpty) {
            return '<td class="is-empty"></td>';
        }
        var arr = [];
        if (opts.isDisabled) {
            arr.push('is-disabled');
        }
        if (opts.isToday) {
            arr.push('is-today');
        }
        if (opts.isSelected) {
            arr.push('is-selected');
        }
        if (opts.isInRange) {
            arr.push('is-inrange');
        }
        if (opts.isStartRange) {
            arr.push('is-startrange');
        }
        if (opts.isEndRange) {
            arr.push('is-endrange');
        }
        return '<td data-day="' + opts.day + '" class="' + arr.join(' ') + '">' +
                 '<button class="pika-button pika-day" type="button" ' +
                    'data-pika-year="' + opts.year + '" data-pika-month="' + opts.month + '" data-pika-day="' + opts.day + '">' +
                        opts.day +
                 '</button>' +
               '</td>';
    },

    renderWeek = function (d, m, y) {
        // Lifted from http://javascript.about.com/library/blweekyear.htm, lightly modified.
        var onejan = new Date(y, 0, 1),
            weekNum = Math.ceil((((new Date(y, m, d) - onejan) / 86400000) + onejan.getDay()+1)/7);
        return '<td class="pika-week">' + weekNum + '</td>';
    },

    renderRow = function(days, isRTL)
    {
        return '<tr>' + (isRTL ? days.reverse() : days).join('') + '</tr>';
    },

    renderBody = function(rows)
    {
        return '<tbody>' + rows.join('') + '</tbody>';
    },

    renderHead = function(opts)
    {
        var i, arr = [];
        if (opts.showWeekNumber) {
            arr.push('<th></th>');
        }
        for (i = 0; i < 7; i++) {
            arr.push('<th scope="col"><abbr title="' + renderDayName(opts, i) + '">' + renderDayName(opts, i, true) + '</abbr></th>');
        }
        return '<thead>' + (opts.isRTL ? arr.reverse() : arr).join('') + '</thead>';
    },

    renderTitle = function(instance, c, year, month, refYear)
    {
        var i, j, arr,
            opts = instance._o,
            isMinYear = year === opts.minYear,
            isMaxYear = year === opts.maxYear,
            html = '<div class="pika-title">',
            monthHtml,
            yearHtml,
            prev = true,
            next = true;

        for (arr = [], i = 0; i < 12; i++) {
            arr.push('<option value="' + (year === refYear ? i - c : 12 + i - c) + '"' +
                (i === month ? ' selected': '') +
                ((isMinYear && i < opts.minMonth) || (isMaxYear && i > opts.maxMonth) ? 'disabled' : '') + '>' +
                opts.i18n.months[i] + '</option>');
        }
        monthHtml = '<div class="pika-label">' + opts.i18n.months[month] + '<select class="pika-select pika-select-month" tabindex="-1">' + arr.join('') + '</select></div>';

        if (isArray(opts.yearRange)) {
            i = opts.yearRange[0];
            j = opts.yearRange[1] + 1;
        } else {
            i = year - opts.yearRange;
            j = 1 + year + opts.yearRange;
        }

        for (arr = []; i < j && i <= opts.maxYear; i++) {
            if (i >= opts.minYear) {
                arr.push('<option value="' + i + '"' + (i === year ? ' selected': '') + '>' + (i) + '</option>');
            }
        }
        yearHtml = '<div class="pika-label">' + year + opts.yearSuffix + '<select class="pika-select pika-select-year" tabindex="-1">' + arr.join('') + '</select></div>';

        if (opts.showMonthAfterYear) {
            html += yearHtml + monthHtml;
        } else {
            html += monthHtml + yearHtml;
        }

        if (isMinYear && (month === 0 || opts.minMonth >= month)) {
            prev = false;
        }

        if (isMaxYear && (month === 11 || opts.maxMonth <= month)) {
            next = false;
        }

        if (c === 0) {
            html += '<button class="pika-prev' + (prev ? '' : ' is-disabled') + '" type="button">' + opts.i18n.previousMonth + '</button>';
        }
        if (c === (instance._o.numberOfMonths - 1) ) {
            html += '<button class="pika-next' + (next ? '' : ' is-disabled') + '" type="button">' + opts.i18n.nextMonth + '</button>';
        }

        return html += '</div>';
    },

    renderTable = function(opts, data)
    {
        return '<table cellpadding="0" cellspacing="0" class="pika-table">' + renderHead(opts) + renderBody(data) + '</table>';
    },


    /**
     * Pikaday constructor
     */
    Pikaday = function(options)
    {
        var self = this,
            opts = self.config(options);

        self._onMouseDown = function(e)
        {
            if (!self._v) {
                return;
            }
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }

            if (!hasClass(target, 'is-disabled')) {
                if (hasClass(target, 'pika-button') && !hasClass(target, 'is-empty')) {
                    self.setDate(new Date(target.getAttribute('data-pika-year'), target.getAttribute('data-pika-month'), target.getAttribute('data-pika-day')));
                    if (opts.bound) {
                        sto(function() {
                            self.hide();
                            if (opts.field) {
                                opts.field.blur();
                            }
                        }, 100);
                    }
                }
                else if (hasClass(target, 'pika-prev')) {
                    self.prevMonth();
                }
                else if (hasClass(target, 'pika-next')) {
                    self.nextMonth();
                }
            }
            if (!hasClass(target, 'pika-select')) {
                // if this is touch event prevent mouse events emulation
                if (e.preventDefault) {
                    e.preventDefault();
                } else {
                    e.returnValue = false;
                    return false;
                }
            } else {
                self._c = true;
            }
        };

        self._onChange = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }
            if (hasClass(target, 'pika-select-month')) {
                self.gotoMonth(target.value);
            }
            else if (hasClass(target, 'pika-select-year')) {
                self.gotoYear(target.value);
            }
        };

        self._onInputChange = function(e)
        {
            var date;

            if (e.firedBy === self) {
                return;
            }
            if (hasMoment) {
                date = moment(opts.field.value, opts.format);
                date = (date && date.isValid()) ? date.toDate() : null;
            }
            else {
                date = new Date(Date.parse(opts.field.value));
            }
            if (isDate(date)) {
              self.setDate(date);
            }
            if (!self._v) {
                self.show();
            }
        };

        self._onInputFocus = function()
        {
            self.show();
        };

        self._onInputClick = function()
        {
            self.show();
        };

        self._onInputBlur = function()
        {
            // IE allows pika div to gain focus; catch blur the input field
            var pEl = document.activeElement;
            do {
                if (hasClass(pEl, 'pika-single')) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));

            if (!self._c) {
                self._b = sto(function() {
                    self.hide();
                }, 50);
            }
            self._c = false;
        };

        self._onClick = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement,
                pEl = target;
            if (!target) {
                return;
            }
            if (!hasEventListeners && hasClass(target, 'pika-select')) {
                if (!target.onchange) {
                    target.setAttribute('onchange', 'return;');
                    addEvent(target, 'change', self._onChange);
                }
            }
            do {
                if (hasClass(pEl, 'pika-single') || pEl === opts.trigger) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));
            if (self._v && target !== opts.trigger && pEl !== opts.trigger) {
                self.hide();
            }
        };

        self.el = document.createElement('div');
        self.el.className = 'pika-single' + (opts.isRTL ? ' is-rtl' : '') + (opts.theme ? ' ' + opts.theme : '');

        addEvent(self.el, 'mousedown', self._onMouseDown, true);
        addEvent(self.el, 'touchend', self._onMouseDown, true);
        addEvent(self.el, 'change', self._onChange);

        if (opts.field) {
            if (opts.container) {
                opts.container.appendChild(self.el);
            } else if (opts.bound) {
                document.body.appendChild(self.el);
            } else {
                opts.field.parentNode.insertBefore(self.el, opts.field.nextSibling);
            }
            addEvent(opts.field, 'change', self._onInputChange);

            if (!opts.defaultDate) {
                if (hasMoment && opts.field.value) {
                    opts.defaultDate = moment(opts.field.value, opts.format).toDate();
                } else {
                    opts.defaultDate = new Date(Date.parse(opts.field.value));
                }
                opts.setDefaultDate = true;
            }
        }

        var defDate = opts.defaultDate;

        if (isDate(defDate)) {
            if (opts.setDefaultDate) {
                self.setDate(defDate, true);
            } else {
                self.gotoDate(defDate);
            }
        } else {
            self.gotoDate(new Date());
        }

        if (opts.bound) {
            this.hide();
            self.el.className += ' is-bound';
            addEvent(opts.trigger, 'click', self._onInputClick);
            addEvent(opts.trigger, 'focus', self._onInputFocus);
            addEvent(opts.trigger, 'blur', self._onInputBlur);
        } else {
            this.show();
        }
    };


    /**
     * public Pikaday API
     */
    Pikaday.prototype = {


        /**
         * configure functionality
         */
        config: function(options)
        {
            if (!this._o) {
                this._o = extend({}, defaults, true);
            }

            var opts = extend(this._o, options, true);

            opts.isRTL = !!opts.isRTL;

            opts.field = (opts.field && opts.field.nodeName) ? opts.field : null;

            opts.theme = (typeof opts.theme) === 'string' && opts.theme ? opts.theme : null;

            opts.bound = !!(opts.bound !== undefined ? opts.field && opts.bound : opts.field);

            opts.trigger = (opts.trigger && opts.trigger.nodeName) ? opts.trigger : opts.field;

            opts.disableWeekends = !!opts.disableWeekends;

            opts.disableDayFn = (typeof opts.disableDayFn) === 'function' ? opts.disableDayFn : null;

            var nom = parseInt(opts.numberOfMonths, 10) || 1;
            opts.numberOfMonths = nom > 4 ? 4 : nom;

            if (!isDate(opts.minDate)) {
                opts.minDate = false;
            }
            if (!isDate(opts.maxDate)) {
                opts.maxDate = false;
            }
            if ((opts.minDate && opts.maxDate) && opts.maxDate < opts.minDate) {
                opts.maxDate = opts.minDate = false;
            }
            if (opts.minDate) {
                this.setMinDate(opts.minDate);
            }
            if (opts.maxDate) {
                this.setMaxDate(opts.maxDate);
            }

            if (isArray(opts.yearRange)) {
                var fallback = new Date().getFullYear() - 10;
                opts.yearRange[0] = parseInt(opts.yearRange[0], 10) || fallback;
                opts.yearRange[1] = parseInt(opts.yearRange[1], 10) || fallback;
            } else {
                opts.yearRange = Math.abs(parseInt(opts.yearRange, 10)) || defaults.yearRange;
                if (opts.yearRange > 100) {
                    opts.yearRange = 100;
                }
            }

            return opts;
        },

        /**
         * return a formatted string of the current selection (using Moment.js if available)
         */
        toString: function(format)
        {
            return !isDate(this._d) ? '' : hasMoment ? moment(this._d).format(format || this._o.format) : this._d.toDateString();
        },

        /**
         * return a Moment.js object of the current selection (if available)
         */
        getMoment: function()
        {
            return hasMoment ? moment(this._d) : null;
        },

        /**
         * set the current selection from a Moment.js object (if available)
         */
        setMoment: function(date, preventOnSelect)
        {
            if (hasMoment && moment.isMoment(date)) {
                this.setDate(date.toDate(), preventOnSelect);
            }
        },

        /**
         * return a Date object of the current selection
         */
        getDate: function()
        {
            return isDate(this._d) ? new Date(this._d.getTime()) : null;
        },

        /**
         * set the current selection
         */
        setDate: function(date, preventOnSelect)
        {
            if (!date) {
                this._d = null;

                if (this._o.field) {
                    this._o.field.value = '';
                    fireEvent(this._o.field, 'change', { firedBy: this });
                }

                return this.draw();
            }
            if (typeof date === 'string') {
                date = new Date(Date.parse(date));
            }
            if (!isDate(date)) {
                return;
            }

            var min = this._o.minDate,
                max = this._o.maxDate;

            if (isDate(min) && date < min) {
                date = min;
            } else if (isDate(max) && date > max) {
                date = max;
            }

            this._d = new Date(date.getTime());
            setToStartOfDay(this._d);
            this.gotoDate(this._d);

            if (this._o.field) {
                this._o.field.value = this.toString();
                fireEvent(this._o.field, 'change', { firedBy: this });
            }
            if (!preventOnSelect && typeof this._o.onSelect === 'function') {
                this._o.onSelect.call(this, this.getDate());
            }
        },

        /**
         * change view to a specific date
         */
        gotoDate: function(date)
        {
            var newCalendar = true;

            if (!isDate(date)) {
                return;
            }

            if (this.calendars) {
                var firstVisibleDate = new Date(this.calendars[0].year, this.calendars[0].month, 1),
                    lastVisibleDate = new Date(this.calendars[this.calendars.length-1].year, this.calendars[this.calendars.length-1].month, 1),
                    visibleDate = date.getTime();
                // get the end of the month
                lastVisibleDate.setMonth(lastVisibleDate.getMonth()+1);
                lastVisibleDate.setDate(lastVisibleDate.getDate()-1);
                newCalendar = (visibleDate < firstVisibleDate.getTime() || lastVisibleDate.getTime() < visibleDate);
            }

            if (newCalendar) {
                this.calendars = [{
                    month: date.getMonth(),
                    year: date.getFullYear()
                }];
                if (this._o.mainCalendar === 'right') {
                    this.calendars[0].month += 1 - this._o.numberOfMonths;
                }
            }

            this.adjustCalendars();
        },

        adjustCalendars: function() {
            this.calendars[0] = adjustCalendar(this.calendars[0]);
            for (var c = 1; c < this._o.numberOfMonths; c++) {
                this.calendars[c] = adjustCalendar({
                    month: this.calendars[0].month + c,
                    year: this.calendars[0].year
                });
            }
            this.draw();
        },

        gotoToday: function()
        {
            this.gotoDate(new Date());
        },

        /**
         * change view to a specific month (zero-index, e.g. 0: January)
         */
        gotoMonth: function(month)
        {
            if (!isNaN(month)) {
                this.calendars[0].month = parseInt(month, 10);
                this.adjustCalendars();
            }
        },

        nextMonth: function()
        {
            this.calendars[0].month++;
            this.adjustCalendars();
        },

        prevMonth: function()
        {
            this.calendars[0].month--;
            this.adjustCalendars();
        },

        /**
         * change view to a specific full year (e.g. "2012")
         */
        gotoYear: function(year)
        {
            if (!isNaN(year)) {
                this.calendars[0].year = parseInt(year, 10);
                this.adjustCalendars();
            }
        },

        /**
         * change the minDate
         */
        setMinDate: function(value)
        {
            setToStartOfDay(value);
            this._o.minDate = value;
            this._o.minYear  = value.getFullYear();
            this._o.minMonth = value.getMonth();
            this.draw();
        },

        /**
         * change the maxDate
         */
        setMaxDate: function(value)
        {
            setToStartOfDay(value);
            this._o.maxDate = value;
            this._o.maxYear = value.getFullYear();
            this._o.maxMonth = value.getMonth();
            this.draw();
        },

        setStartRange: function(value)
        {
            this._o.startRange = value;
        },

        setEndRange: function(value)
        {
            this._o.endRange = value;
        },

        /**
         * refresh the HTML
         */
        draw: function(force)
        {
            if (!this._v && !force) {
                return;
            }
            var opts = this._o,
                minYear = opts.minYear,
                maxYear = opts.maxYear,
                minMonth = opts.minMonth,
                maxMonth = opts.maxMonth,
                html = '';

            if (this._y <= minYear) {
                this._y = minYear;
                if (!isNaN(minMonth) && this._m < minMonth) {
                    this._m = minMonth;
                }
            }
            if (this._y >= maxYear) {
                this._y = maxYear;
                if (!isNaN(maxMonth) && this._m > maxMonth) {
                    this._m = maxMonth;
                }
            }

            for (var c = 0; c < opts.numberOfMonths; c++) {
                html += '<div class="pika-lendar">' + renderTitle(this, c, this.calendars[c].year, this.calendars[c].month, this.calendars[0].year) + this.render(this.calendars[c].year, this.calendars[c].month) + '</div>';
            }

            this.el.innerHTML = html;

            if (opts.bound) {
                if(opts.field.type !== 'hidden') {
                    sto(function() {
                        opts.trigger.focus();
                    }, 1);
                }
            }

            if (typeof this._o.onDraw === 'function') {
                var self = this;
                sto(function() {
                    self._o.onDraw.call(self);
                }, 0);
            }
        },

        adjustPosition: function()
        {
            var field, pEl, width, height, viewportWidth, viewportHeight, scrollTop, left, top, clientRect;

            if (this._o.container) return;

            this.el.style.position = 'absolute';

            field = this._o.trigger;
            pEl = field;
            width = this.el.offsetWidth;
            height = this.el.offsetHeight;
            viewportWidth = window.innerWidth || document.documentElement.clientWidth;
            viewportHeight = window.innerHeight || document.documentElement.clientHeight;
            scrollTop = window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop;

            if (typeof field.getBoundingClientRect === 'function') {
                clientRect = field.getBoundingClientRect();
                left = clientRect.left + window.pageXOffset;
                top = clientRect.bottom + window.pageYOffset;
            } else {
                left = pEl.offsetLeft;
                top  = pEl.offsetTop + pEl.offsetHeight;
                while((pEl = pEl.offsetParent)) {
                    left += pEl.offsetLeft;
                    top  += pEl.offsetTop;
                }
            }

            // default position is bottom & left
            if ((this._o.reposition && left + width > viewportWidth) ||
                (
                    this._o.position.indexOf('right') > -1 &&
                    left - width + field.offsetWidth > 0
                )
            ) {
                left = left - width + field.offsetWidth;
            }
            if ((this._o.reposition && top + height > viewportHeight + scrollTop) ||
                (
                    this._o.position.indexOf('top') > -1 &&
                    top - height - field.offsetHeight > 0
                )
            ) {
                top = top - height - field.offsetHeight;
            }

            this.el.style.left = left + 'px';
            this.el.style.top = top + 'px';
        },

        /**
         * render HTML for a particular month
         */
        render: function(year, month)
        {
            var opts   = this._o,
                now    = new Date(),
                days   = getDaysInMonth(year, month),
                before = new Date(year, month, 1).getDay(),
                data   = [],
                row    = [];
            setToStartOfDay(now);
            if (opts.firstDay > 0) {
                before -= opts.firstDay;
                if (before < 0) {
                    before += 7;
                }
            }
            var cells = days + before,
                after = cells;
            while(after > 7) {
                after -= 7;
            }
            cells += 7 - after;
            for (var i = 0, r = 0; i < cells; i++)
            {
                var day = new Date(year, month, 1 + (i - before)),
                    isSelected = isDate(this._d) ? compareDates(day, this._d) : false,
                    isToday = compareDates(day, now),
                    isEmpty = i < before || i >= (days + before),
                    isStartRange = opts.startRange && compareDates(opts.startRange, day),
                    isEndRange = opts.endRange && compareDates(opts.endRange, day),
                    isInRange = opts.startRange && opts.endRange && opts.startRange < day && day < opts.endRange,
                    isDisabled = (opts.minDate && day < opts.minDate) ||
                                 (opts.maxDate && day > opts.maxDate) ||
                                 (opts.disableWeekends && isWeekend(day)) ||
                                 (opts.disableDayFn && opts.disableDayFn(day)),
                    dayConfig = {
                        day: 1 + (i - before),
                        month: month,
                        year: year,
                        isSelected: isSelected,
                        isToday: isToday,
                        isDisabled: isDisabled,
                        isEmpty: isEmpty,
                        isStartRange: isStartRange,
                        isEndRange: isEndRange,
                        isInRange: isInRange
                    };

                row.push(renderDay(dayConfig));

                if (++r === 7) {
                    if (opts.showWeekNumber) {
                        row.unshift(renderWeek(i - before, month, year));
                    }
                    data.push(renderRow(row, opts.isRTL));
                    row = [];
                    r = 0;
                }
            }
            return renderTable(opts, data);
        },

        isVisible: function()
        {
            return this._v;
        },

        show: function()
        {
            if (!this._v) {
                removeClass(this.el, 'is-hidden');
                this._v = true;
                this.draw();
                if (this._o.bound) {
                    addEvent(document, 'click', this._onClick);
                    this.adjustPosition();
                }
                if (typeof this._o.onOpen === 'function') {
                    this._o.onOpen.call(this);
                }
            }
        },

        hide: function()
        {
            var v = this._v;
            if (v !== false) {
                if (this._o.bound) {
                    removeEvent(document, 'click', this._onClick);
                }
                this.el.style.position = 'static'; // reset
                this.el.style.left = 'auto';
                this.el.style.top = 'auto';
                addClass(this.el, 'is-hidden');
                this._v = false;
                if (v !== undefined && typeof this._o.onClose === 'function') {
                    this._o.onClose.call(this);
                }
            }
        },

        /**
         * GAME OVER
         */
        destroy: function()
        {
            this.hide();
            removeEvent(this.el, 'mousedown', this._onMouseDown, true);
            removeEvent(this.el, 'touchend', this._onMouseDown, true);
            removeEvent(this.el, 'change', this._onChange);
            if (this._o.field) {
                removeEvent(this._o.field, 'change', this._onInputChange);
                if (this._o.bound) {
                    removeEvent(this._o.trigger, 'click', this._onInputClick);
                    removeEvent(this._o.trigger, 'focus', this._onInputFocus);
                    removeEvent(this._o.trigger, 'blur', this._onInputBlur);
                }
            }
            if (this.el.parentNode) {
                this.el.parentNode.removeChild(this.el);
            }
        }

    };

    return Pikaday;

}));


/***/ },
/* 83 */,
/* 84 */
/*!************************************!*\
  !*** external "window.Autolinker" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.Autolinker;

/***/ },
/* 85 */
/*!***********************************!*\
  !*** external "window.JSEncrypt" ***!
  \***********************************/
/***/ function(module, exports) {

module.exports = window.JSEncrypt;

/***/ },
/* 86 */
/*!*****************************!*\
  !*** external "window.Jua" ***!
  \*****************************/
/***/ function(module, exports) {

module.exports = window.Jua;

/***/ },
/* 87 */
/*!********************************!*\
  !*** external "window.hasher" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.hasher;

/***/ },
/* 88 */
/*!*****************************!*\
  !*** external "window.ssm" ***!
  \*****************************/
/***/ function(module, exports) {

module.exports = window.ssm;

/***/ },
/* 89 */
/*!***************************************!*\
  !*** ./dev/Promises/AbstractBasic.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	Promise = __webpack_require__(/*! Promise */ 37),

	Utils = __webpack_require__(/*! Common/Utils */ 0);

/**
* @constructor
*/
function AbstractBasicPromises()
{
	this.oPromisesStack = {};
}

AbstractBasicPromises.prototype.func = function(fFunc)
{
	fFunc();
	return this;
};

AbstractBasicPromises.prototype.fastResolve = function(mData)
{
	return Promise.resolve(mData);
};

AbstractBasicPromises.prototype.fastReject = function(mData)
{
	return Promise.reject(mData);
};

AbstractBasicPromises.prototype.setTrigger = function(mTrigger, bValue)
{
	if (mTrigger)
	{
		_.each(Utils.isArray(mTrigger) ? mTrigger : [mTrigger], function(fTrigger) {
			if (fTrigger)
			{
				fTrigger(!!bValue);
			}
		});
	}
};

module.exports = AbstractBasicPromises;


/***/ },
/* 90 */,
/* 91 */
/*!***********************************!*\
  !*** ./dev/Stores/User/Filter.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function FilterUserStore()
{
	this.capa = ko.observable('');
	this.modules = ko.observable({});

	this.filters = ko.observableArray([]);

	this.filters.loading = ko.observable(false).extend({throttle: 200});
	this.filters.saving = ko.observable(false).extend({throttle: 200});

	this.raw = ko.observable('');
}

module.exports = new FilterUserStore();


/***/ },
/* 92 */
/*!**********************************!*\
  !*** ./dev/Stores/User/Quota.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function QuotaUserStore()
{
	this.quota = ko.observable(0);
	this.usage = ko.observable(0);

	this.percentage = ko.computed(function() {

		var
			iQuota = this.quota(),
			iUsed = this.usage();

		return 0 < iQuota ? window.Math.ceil((iUsed / iQuota) * 100) : 0;

	}, this);
}

/**
 * @param {number} iQuota
 * @param {number} iUsage
 */
QuotaUserStore.prototype.populateData = function(iQuota, iUsage)
{
	this.quota(iQuota * 1024);
	this.usage(iUsage * 1024);
};

module.exports = new QuotaUserStore();


/***/ },
/* 93 */
/*!*************************************!*\
  !*** ./dev/Stores/User/Template.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1);

//	Remote = require('Remote/User/Ajax');

/**
 * @constructor
 */
function TemplateUserStore()
{
	this.templates = ko.observableArray([]);
	this.templates.loading = ko.observable(false).extend({'throttle': 100});

	this.templatesNames = ko.observableArray([]).extend({'throttle': 1000});
	this.templatesNames.skipFirst = true;

	this.subscribers();
}

TemplateUserStore.prototype.subscribers = function()
{
	this.templates.subscribe(function(aList) {
		this.templatesNames(_.compact(_.map(aList, function(oItem) {
			return oItem ? oItem.name : null;
		})));
	}, this);

//	this.templatesNames.subscribe(function(aList) {
//		if (this.templatesNames.skipFirst)
//		{
//			this.templatesNames.skipFirst = false;
//		}
//		else if (aList && 1 < aList.length)
//		{
//			Remote.templatesSortOrder(null, aList);
//		}
//	}, this);
};

module.exports = new TemplateUserStore();


/***/ },
/* 94 */,
/* 95 */,
/* 96 */
/*!**********************************!*\
  !*** ./dev/View/Popup/Filter.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	FilterStore = __webpack_require__(/*! Stores/User/Filter */ 91),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function FilterPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsFilter');

	this.isNew = ko.observable(true);

	this.modules = FilterStore.modules;

	this.fTrueCallback = null;
	this.filter = ko.observable(null);

	this.allowMarkAsRead = ko.observable(false);

	this.defautOptionsAfterRender = Utils.defautOptionsAfterRender;
	this.folderSelectList = FolderStore.folderMenuForFilters;
	this.selectedFolderValue = ko.observable('');

	this.selectedFolderValue.subscribe(function() {
		if (this.filter())
		{
			this.filter().actionValue.error(false);
		}
	}, this);

	this.saveFilter = Utils.createCommand(this, function() {

		if (this.filter())
		{
			if (Enums.FiltersAction.MoveTo === this.filter().actionType())
			{
				this.filter().actionValue(this.selectedFolderValue());
			}

			if (!this.filter().verify())
			{
				return false;
			}

			if (this.fTrueCallback)
			{
				this.fTrueCallback(this.filter());
			}

			if (this.modalVisibility())
			{
				Utils.delegateRun(this, 'closeCommand');
			}
		}

		return true;
	});

	this.actionTypeOptions = ko.observableArray([]);
	this.fieldOptions = ko.observableArray([]);
	this.typeOptions = ko.observableArray([]);
	this.typeOptionsSize = ko.observableArray([]);

	Translator.initOnStartOrLangChange(_.bind(this.populateOptions, this));

	this.modules.subscribe(this.populateOptions, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Filter', 'PopupsFilterViewModel'], FilterPopupView);
_.extend(FilterPopupView.prototype, AbstractView.prototype);

FilterPopupView.prototype.populateOptions = function()
{
	this.actionTypeOptions([]);

//		this.actionTypeOptions.push({'id': Enums.FiltersAction.None,
//			'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_NONE')});

	var oModules = this.modules();
	if (oModules)
	{
		if (oModules.markasread)
		{
			this.allowMarkAsRead(true);
		}

		if (oModules.moveto)
		{
			this.actionTypeOptions.push({'id': Enums.FiltersAction.MoveTo,
				'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_MOVE_TO')});
		}

		if (oModules.redirect)
		{
			this.actionTypeOptions.push({'id': Enums.FiltersAction.Forward,
				'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_FORWARD_TO')});
		}

		if (oModules.reject)
		{
			this.actionTypeOptions.push({'id': Enums.FiltersAction.Reject,
				'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_REJECT')});
		}

		if (oModules.vacation)
		{
			this.actionTypeOptions.push({'id': Enums.FiltersAction.Vacation,
				'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_VACATION_MESSAGE')});

		}
	}

	this.actionTypeOptions.push({'id': Enums.FiltersAction.Discard,
		'name': Translator.i18n('POPUPS_FILTER/SELECT_ACTION_DISCARD')});

	this.fieldOptions([
		{'id': Enums.FilterConditionField.From, 'name': Translator.i18n('POPUPS_FILTER/SELECT_FIELD_FROM')},
		{'id': Enums.FilterConditionField.Recipient, 'name': Translator.i18n('POPUPS_FILTER/SELECT_FIELD_RECIPIENTS')},
		{'id': Enums.FilterConditionField.Subject, 'name': Translator.i18n('POPUPS_FILTER/SELECT_FIELD_SUBJECT')},
		{'id': Enums.FilterConditionField.Size, 'name': Translator.i18n('POPUPS_FILTER/SELECT_FIELD_SIZE')},
		{'id': Enums.FilterConditionField.Header, 'name': Translator.i18n('POPUPS_FILTER/SELECT_FIELD_HEADER')}
	]);

	this.typeOptions([
		{'id': Enums.FilterConditionType.Contains, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_CONTAINS')},
		{'id': Enums.FilterConditionType.NotContains, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_NOT_CONTAINS')},
		{'id': Enums.FilterConditionType.EqualTo, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_EQUAL_TO')},
		{'id': Enums.FilterConditionType.NotEqualTo, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_NOT_EQUAL_TO')}
	]);

	if (oModules && oModules.regex)
	{
		this.typeOptions.push({'id': Enums.FilterConditionType.Regex, 'name': 'Regex'});
	}

	this.typeOptionsSize([
		{'id': Enums.FilterConditionType.Over, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_OVER')},
		{'id': Enums.FilterConditionType.Under, 'name': Translator.i18n('POPUPS_FILTER/SELECT_TYPE_UNDER')}
	]);
};

FilterPopupView.prototype.removeCondition = function(oConditionToDelete)
{
	if (this.filter())
	{
		this.filter().removeCondition(oConditionToDelete);
	}
};

FilterPopupView.prototype.clearPopup = function()
{
	this.isNew(true);

	this.fTrueCallback = null;
	this.filter(null);
};

FilterPopupView.prototype.onShow = function(oFilter, fTrueCallback, bEdit)
{
	this.clearPopup();

	this.fTrueCallback = fTrueCallback;
	this.filter(oFilter);

	if (oFilter)
	{
		this.selectedFolderValue(oFilter.actionValue());
	}

	this.isNew(!bEdit);

	if (!bEdit && oFilter)
	{
		oFilter.name.focused(true);
	}
};

FilterPopupView.prototype.onShowWithDelay = function()
{
	if (this.isNew() && this.filter() && !Globals.bMobile)
	{
		this.filter().name.focused(true);
	}
};

module.exports = FilterPopupView;


/***/ },
/* 97 */
/*!****************************************!*\
  !*** ./dev/View/Popup/FolderCreate.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),

	Promises = __webpack_require__(/*! Promises/User/Ajax */ 42),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function FolderCreateView()
{
	AbstractView.call(this, 'Popups', 'PopupsFolderCreate');

	this.folderName = ko.observable('');
	this.folderName.focused = ko.observable(false);

	this.selectedParentValue = ko.observable(Consts.UNUSED_OPTION_VALUE);

	this.parentFolderSelectList = ko.computed(function() {

		var
			aTop = [],
			fDisableCallback = null,
			fVisibleCallback = null,
			aList = FolderStore.folderList(),
			fRenameCallback = function(oItem) {
				return oItem ? (oItem.isSystemFolder() ? oItem.name() + ' ' + oItem.manageFolderSystemName() : oItem.name()) : '';
			};

		aTop.push(['', '']);

		if ('' !== FolderStore.namespace)
		{
			fDisableCallback = function(oItem)
			{
				return FolderStore.namespace !== oItem.fullNameRaw.substr(0, FolderStore.namespace.length);
			};
		}

		return Utils.folderListOptionsBuilder([], aList, [], aTop, null, fDisableCallback, fVisibleCallback, fRenameCallback);

	}, this);

	// commands
	this.createFolder = Utils.createCommand(this, function() {

		var
			sParentFolderName = this.selectedParentValue();

		if ('' === sParentFolderName && 1 < FolderStore.namespace.length)
		{
			sParentFolderName = FolderStore.namespace.substr(0, FolderStore.namespace.length - 1);
		}

		__webpack_require__(/*! App/User */ 8).default.foldersPromisesActionHelper(
			Promises.folderCreate(this.folderName(), sParentFolderName, FolderStore.foldersCreating),
			Enums.Notification.CantCreateFolder
		);

		this.cancelCommand();

	}, function() {
		return this.simpleFolderNameValidation(this.folderName());
	});

	this.defautOptionsAfterRender = Utils.defautOptionsAfterRender;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/FolderCreate', 'PopupsFolderCreateViewModel'], FolderCreateView);
_.extend(FolderCreateView.prototype, AbstractView.prototype);

FolderCreateView.prototype.simpleFolderNameValidation = function(sName)
{
	return (/^[^\\\/]+$/g).test(Utils.trim(sName));
};

FolderCreateView.prototype.clearPopup = function()
{
	this.folderName('');
	this.selectedParentValue('');
	this.folderName.focused(false);
};

FolderCreateView.prototype.onShow = function()
{
	this.clearPopup();
};

FolderCreateView.prototype.onShowWithDelay = function()
{
	if (!Globals.bMobile)
	{
		this.folderName.focused(true);
	}
};

module.exports = FolderCreateView;


/***/ },
/* 98 */
/*!*************************************************!*\
  !*** ./dev/View/Popup/KeyboardShortcutsHelp.js ***!
  \*************************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function KeyboardShortcutsHelpPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsKeyboardShortcutsHelp');

	this.sDefaultKeyScope = Enums.KeyState.PopupKeyboardShortcutsHelp;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/KeyboardShortcutsHelp', 'PopupsKeyboardShortcutsHelpViewModel'], KeyboardShortcutsHelpPopupView);
_.extend(KeyboardShortcutsHelpPopupView.prototype, AbstractView.prototype);

KeyboardShortcutsHelpPopupView.prototype.onBuild = function(oDom)
{
	key('tab, shift+tab, left, right', Enums.KeyState.PopupKeyboardShortcutsHelp, _.throttle(function(event, handler) {

		if (event && handler)
		{
			var
				$tabs = oDom.find('.nav.nav-tabs > li'),
				isNext = handler && ('tab' === handler.shortcut || 'right' === handler.shortcut),
				index = $tabs.index($tabs.filter('.active'));

			if (!isNext && 0 < index)
			{
				index -= 1;
			}
			else if (isNext && index < $tabs.length - 1)
			{
				index += 1;
			}
			else
			{
				index = isNext ? 0 : $tabs.length - 1;
			}

			$tabs.eq(index).find('a[data-toggle="tab"]').tab('show');
			return false;
		}

		return true;

	}, Enums.Magics.Time100ms));
};

module.exports = KeyboardShortcutsHelpPopupView;


/***/ },
/* 99 */
/*!************************************!*\
  !*** ./dev/View/Popup/Template.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),
	HtmlEditor = __webpack_require__(/*! Common/HtmlEditor */ 45),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function TemplatePopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsTemplate');

	this.editor = null;
	this.signatureDom = ko.observable(null);

	this.id = ko.observable('');

	this.name = ko.observable('');
	this.name.error = ko.observable(false);
	this.name.focus = ko.observable(false);

	this.body = ko.observable('');
	this.body.loading = ko.observable(false);
	this.body.error = ko.observable(false);

	this.name.subscribe(function() {
		this.name.error(false);
	}, this);

	this.body.subscribe(function() {
		this.body.error(false);
	}, this);

	this.submitRequest = ko.observable(false);
	this.submitError = ko.observable('');

	this.addTemplateCommand = Utils.createCommand(this, function() {

		this.populateBodyFromEditor();

		this.name.error('' === Utils.trim(this.name()));
		this.body.error('' === Utils.trim(this.body()) ||
			':HTML:' === Utils.trim(this.body()));

		if (this.name.error() || this.body.error())
		{
			return false;
		}

		this.submitRequest(true);

		Remote.templateSetup(_.bind(function(sResult, oData) {

			this.submitRequest(false);
			if (Enums.StorageResultType.Success === sResult && oData)
			{
				if (oData.Result)
				{
					__webpack_require__(/*! App/User */ 8).default.templates();
					this.cancelCommand();
				}
				else if (oData.ErrorCode)
				{
					this.submitError(Translator.getNotification(oData.ErrorCode));
				}
			}
			else
			{
				this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
			}

		}, this), this.id(), this.name(), this.body());

		return true;

	}, function() {
		return !this.submitRequest();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Template'], TemplatePopupView);
_.extend(TemplatePopupView.prototype, AbstractView.prototype);

TemplatePopupView.prototype.clearPopup = function()
{
	this.id('');

	this.name('');
	this.name.error(false);

	this.body('');
	this.body.loading(false);
	this.body.error(false);

	this.submitRequest(false);
	this.submitError('');

	if (this.editor)
	{
		this.editor.setPlain('', false);
	}
};

TemplatePopupView.prototype.populateBodyFromEditor = function()
{
	if (this.editor)
	{
		this.body(this.editor.getDataWithHtmlMark());
	}
};

TemplatePopupView.prototype.editorSetBody = function(sBody)
{
	if (!this.editor && this.signatureDom())
	{
		var self = this;
		this.editor = new HtmlEditor(self.signatureDom(), function() {
			self.populateBodyFromEditor();
		}, function() {
			self.editor.setHtmlOrPlain(sBody);
		});
	}
	else
	{
		this.editor.setHtmlOrPlain(sBody);
	}
};

TemplatePopupView.prototype.onShow = function(oTemplate)
{
	var self = this;

	this.clearPopup();

	if (oTemplate && oTemplate.id)
	{
		this.id(oTemplate.id);
		this.name(oTemplate.name);
		this.body(oTemplate.body);

		if (oTemplate.populated)
		{
			self.editorSetBody(this.body());
		}
		else
		{
			this.body.loading(true);
			self.body.error(false);

			Remote.templateGetById(function(sResult, oData) {

				self.body.loading(false);

				if (Enums.StorageResultType.Success === sResult && oData && oData.Result &&
					'Object/Template' === oData.Result['@Object'] && Utils.isNormal(oData.Result.Body))
				{
					oTemplate.body = oData.Result.Body;
					oTemplate.populated = true;

					self.body(oTemplate.body);
					self.body.error(false);
				}
				else
				{
					self.body('');
					self.body.error(true);
				}

				self.editorSetBody(self.body());

			}, this.id());
		}
	}
	else
	{
		self.editorSetBody('');
	}
};

TemplatePopupView.prototype.onShowWithDelay = function()
{
	this.name.focus(true);
};

module.exports = TemplatePopupView;


/***/ },
/* 100 */
/*!**************************************************!*\
  !*** ./dev/View/Popup/TwoFactorConfiguration.js ***!
  \**************************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	qr = __webpack_require__(/*! qr */ 187),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function TwoFactorConfigurationPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsTwoFactorConfiguration');

	this.lock = ko.observable(false);

	this.capaTwoFactor = Settings.capa(Enums.Capa.TwoFactor);

	this.processing = ko.observable(false);
	this.clearing = ko.observable(false);
	this.secreting = ko.observable(false);

	this.viewUser = ko.observable('');
	this.twoFactorStatus = ko.observable(false);

	this.twoFactorTested = ko.observable(false);

	this.viewSecret = ko.observable('');
	this.viewBackupCodes = ko.observable('');
	this.viewUrlTitle = ko.observable('');
	this.viewUrl = ko.observable('');

	this.viewEnable_ = ko.observable(false);

	this.viewEnable = ko.computed({
		'owner': this,
		'read': this.viewEnable_,
		'write': function(bValue) {

			var self = this;

			bValue = !!bValue;

			if (bValue && this.twoFactorTested())
			{
				this.viewEnable_(bValue);

				Remote.enableTwoFactor(function(sResult, oData) {
					if (Enums.StorageResultType.Success !== sResult || !oData || !oData.Result)
					{
						self.viewEnable_(false);
					}

				}, true);
			}
			else
			{
				if (!bValue)
				{
					this.viewEnable_(bValue);
				}

				Remote.enableTwoFactor(function(sResult, oData) {
					if (Enums.StorageResultType.Success !== sResult || !oData || !oData.Result)
					{
						self.viewEnable_(false);
					}

				}, false);
			}
		}
	});

	this.viewTwoFactorEnableTooltip = ko.computed(function() {
		Translator.trigger();
		return this.twoFactorTested() || this.viewEnable_() ? '' :
			Translator.i18n('POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_TEST_BEFORE_DESC');
	}, this);

	this.viewTwoFactorStatus = ko.computed(function() {
		Translator.trigger();
		return Translator.i18n(this.twoFactorStatus() ?
			'POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_CONFIGURED_DESC' :
			'POPUPS_TWO_FACTOR_CFG/TWO_FACTOR_SECRET_NOT_CONFIGURED_DESC'
		);
	}, this);

	this.twoFactorAllowedEnable = ko.computed(function() {
		return this.viewEnable() || this.twoFactorTested();
	}, this);

	this.onResult = _.bind(this.onResult, this);
	this.onShowSecretResult = _.bind(this.onShowSecretResult, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/TwoFactorConfiguration', 'TwoFactorConfigurationPopupView'], TwoFactorConfigurationPopupView);
_.extend(TwoFactorConfigurationPopupView.prototype, AbstractView.prototype);

TwoFactorConfigurationPopupView.prototype.showSecret = function()
{
	this.secreting(true);
	Remote.showTwoFactorSecret(this.onShowSecretResult);
};

TwoFactorConfigurationPopupView.prototype.hideSecret = function()
{
	this.viewSecret('');
	this.viewBackupCodes('');
	this.viewUrlTitle('');
	this.viewUrl('');
};

TwoFactorConfigurationPopupView.prototype.createTwoFactor = function()
{
	this.processing(true);
	Remote.createTwoFactor(this.onResult);
};

TwoFactorConfigurationPopupView.prototype.logout = function()
{
	__webpack_require__(/*! App/User */ 8).default.logout();
};

TwoFactorConfigurationPopupView.prototype.testTwoFactor = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/TwoFactorTest */ 148), [this.twoFactorTested]);
};

TwoFactorConfigurationPopupView.prototype.clearTwoFactor = function()
{
	this.viewSecret('');
	this.viewBackupCodes('');
	this.viewUrlTitle('');
	this.viewUrl('');

	this.twoFactorTested(false);

	this.clearing(true);
	Remote.clearTwoFactor(this.onResult);
};

TwoFactorConfigurationPopupView.prototype.onShow = function(bLock)
{
	this.lock(!!bLock);

	this.viewSecret('');
	this.viewBackupCodes('');
	this.viewUrlTitle('');
	this.viewUrl('');
};

TwoFactorConfigurationPopupView.prototype.onHide = function()
{
	if (this.lock())
	{
		window.location.reload();
	}
};

TwoFactorConfigurationPopupView.prototype.getQr = function()
{
	return 'otpauth://totp/' + window.encodeURIComponent(this.viewUser()) +
		'?secret=' + window.encodeURIComponent(this.viewSecret()) +
		'&issuer=' + window.encodeURIComponent('');
};

TwoFactorConfigurationPopupView.prototype.onResult = function(sResult, oData)
{
	this.processing(false);
	this.clearing(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.viewUser(Utils.pString(oData.Result.User));
		this.viewEnable_(!!oData.Result.Enable);
		this.twoFactorStatus(!!oData.Result.IsSet);
		this.twoFactorTested(!!oData.Result.Tested);

		this.viewSecret(Utils.pString(oData.Result.Secret));
		this.viewBackupCodes(Utils.pString(oData.Result.BackupCodes).replace(/[\s]+/g, '  '));

		this.viewUrlTitle(Utils.pString(oData.Result.UrlTitle));
		this.viewUrl(qr.toDataURL({level: 'M', size: 8, value: this.getQr()}));
	}
	else
	{
		this.viewUser('');
		this.viewEnable_(false);
		this.twoFactorStatus(false);
		this.twoFactorTested(false);

		this.viewSecret('');
		this.viewBackupCodes('');
		this.viewUrlTitle('');
		this.viewUrl('');
	}
};

TwoFactorConfigurationPopupView.prototype.onShowSecretResult = function(sResult, oData)
{
	this.secreting(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.viewSecret(Utils.pString(oData.Result.Secret));
		this.viewUrlTitle(Utils.pString(oData.Result.UrlTitle));
		this.viewUrl(qr.toDataURL({level: 'M', size: 6, value: this.getQr()}));
	}
	else
	{
		this.viewSecret('');
		this.viewUrlTitle('');
		this.viewUrl('');
	}
};

TwoFactorConfigurationPopupView.prototype.onBuild = function()
{
	if (this.capaTwoFactor)
	{
		this.processing(true);
		Remote.getTwoFactor(this.onResult);
	}
};

module.exports = TwoFactorConfigurationPopupView;


/***/ },
/* 101 */
/*!*************************************************!*\
  !*** ./dev/View/User/AbstractSystemDropDown.js ***!
  \*************************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Events = __webpack_require__(/*! Common/Events */ 23),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	AccountStore = __webpack_require__(/*! Stores/User/Account */ 28),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AbstractSystemDropDownUserView()
{
	AbstractView.call(this, 'Right', 'SystemDropDown');

	this.logoImg = Utils.trim(Settings.settingsGet('UserLogo'));
	this.logoTitle = Utils.trim(Settings.settingsGet('UserLogoTitle'));

	this.mobile = !!Settings.appSettingsGet('mobile');
	this.mobileDevice = !!Settings.appSettingsGet('mobileDevice');

	this.allowSettings = !!Settings.capa(Enums.Capa.Settings);
	this.allowHelp = !!Settings.capa(Enums.Capa.Help);

	this.currentAudio = AppStore.currentAudio;

	this.accountEmail = AccountStore.email;

	this.accounts = AccountStore.accounts;
	this.accountsUnreadCount = AccountStore.accountsUnreadCount;

	this.accountMenuDropdownTrigger = ko.observable(false);
	this.capaAdditionalAccounts = ko.observable(Settings.capa(Enums.Capa.AdditionalAccounts));

	this.accountClick = _.bind(this.accountClick, this);

	this.accountClick = _.bind(this.accountClick, this);

	Events.sub('audio.stop', function() {
		AppStore.currentAudio('');
	});

	Events.sub('audio.start', function(sName) {
		AppStore.currentAudio(sName);
	});
}

_.extend(AbstractSystemDropDownUserView.prototype, AbstractView.prototype);

AbstractSystemDropDownUserView.prototype.stopPlay = function()
{
	Events.pub('audio.api.stop');
};

AbstractSystemDropDownUserView.prototype.accountClick = function(oAccount, oEvent)
{
	if (oAccount && oEvent && !Utils.isUnd(oEvent.which) && 1 === oEvent.which)
	{
		AccountStore.accounts.loading(true);

		_.delay(function() {
			AccountStore.accounts.loading(false);
		}, Enums.Magics.Time1s);
	}

	return true;
};

AbstractSystemDropDownUserView.prototype.emailTitle = function()
{
	return AccountStore.email();
};

AbstractSystemDropDownUserView.prototype.settingsClick = function()
{
	if (Settings.capa(Enums.Capa.Settings))
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).setHash(Links.settings());
	}
};

AbstractSystemDropDownUserView.prototype.settingsHelp = function()
{
	if (Settings.capa(Enums.Capa.Help))
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/KeyboardShortcutsHelp */ 98));
	}
};

AbstractSystemDropDownUserView.prototype.addAccountClick = function()
{
	if (this.capaAdditionalAccounts())
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Account */ 63));
	}
};

AbstractSystemDropDownUserView.prototype.logoutClick = function()
{
	__webpack_require__(/*! App/User */ 8).default.logout();
};

AbstractSystemDropDownUserView.prototype.onBuild = function()
{
	var self = this;
	key('`', [Enums.KeyState.MessageList, Enums.KeyState.MessageView, Enums.KeyState.Settings], function() {
		if (self.viewModelVisibility())
		{
			MessageStore.messageFullScreenMode(false);

			self.accountMenuDropdownTrigger(true);
		}
	});

	// shortcuts help
	key('shift+/', [Enums.KeyState.MessageList, Enums.KeyState.MessageView, Enums.KeyState.Settings], function() {
		if (self.viewModelVisibility())
		{
			__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/KeyboardShortcutsHelp */ 98));
			return false;
		}
		return true;
	});
};

module.exports = AbstractSystemDropDownUserView;


/***/ },
/* 102 */
/*!*********************************!*\
  !*** ./dev/Common/Selector.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_key__ = __webpack_require__(/*! key */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_key___default = __WEBPACK_IMPORTED_MODULE_2_key__ && __WEBPACK_IMPORTED_MODULE_2_key__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_key__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_key__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_key___default, 'a', __WEBPACK_IMPORTED_MODULE_2_key___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko___default = __WEBPACK_IMPORTED_MODULE_3_ko__ && __WEBPACK_IMPORTED_MODULE_3_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_3_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "Selector", function() { return Selector; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return Selector; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }








var Selector = function () {
	/**
  * @constructor
  * @param {koProperty} koList
  * @param {koProperty} koSelectedItem
  * @param {koProperty} koFocusedItem
  * @param {string} sItemSelector
  * @param {string} sItemSelectedSelector
  * @param {string} sItemCheckedSelector
  * @param {string} sItemFocusedSelector
  */

	function Selector(koList, koSelectedItem, koFocusedItem, sItemSelector, sItemSelectedSelector, sItemCheckedSelector, sItemFocusedSelector) {
		var _this = this;

		_classCallCheck(this, Selector);

		this.list = koList;

		this.listChecked = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_1_____default.a.filter(_this.list(), function (item) {
				return item.checked();
			});
		}).extend({ rateLimit: 0 });
		this.isListChecked = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return 0 < _this.listChecked().length;
		});

		this.focusedItem = koFocusedItem || __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(null);
		this.selectedItem = koSelectedItem || __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(null);
		this.selectedItemUseCallback = true;

		this.itemSelectedThrottle = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(__WEBPACK_IMPORTED_MODULE_1_____default.a.bind(this.itemSelected, this), 300);

		this.listChecked.subscribe(function (items) {
			if (0 < items.length) {
				if (null === _this.selectedItem()) {
					if (_this.selectedItem.valueHasMutated) {
						_this.selectedItem.valueHasMutated();
					}
				} else {
					_this.selectedItem(null);
				}
			} else if (_this.autoSelect() && _this.focusedItem()) {
				_this.selectedItem(_this.focusedItem());
			}
		}, this);

		this.selectedItem.subscribe(function (item) {

			if (item) {
				if (_this.isListChecked()) {
					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(_this.listChecked(), function (subItem) {
						subItem.checked(false);
					});
				}

				if (_this.selectedItemUseCallback) {
					_this.itemSelectedThrottle(item);
				}
			} else if (_this.selectedItemUseCallback) {
				_this.itemSelected(null);
			}
		}, this);

		this.selectedItem = this.selectedItem.extend({ toggleSubscribe: [null, function (prev) {
				if (prev) {
					prev.selected(false);
				}
			}, function (next) {
				if (next) {
					next.selected(true);
				}
			}] });

		this.focusedItem = this.focusedItem.extend({ toggleSubscribe: [null, function (prev) {
				if (prev) {
					prev.focused(false);
				}
			}, function (next) {
				if (next) {
					next.focused(true);
				}
			}] });

		this.iSelectNextHelper = 0;
		this.iFocusedNextHelper = 0;
		this.oContentVisible = null;
		this.oContentScrollable = null;

		this.sItemSelector = sItemSelector;
		this.sItemSelectedSelector = sItemSelectedSelector;
		this.sItemCheckedSelector = sItemCheckedSelector;
		this.sItemFocusedSelector = sItemFocusedSelector;

		this.sLastUid = '';
		this.oCallbacks = {};

		this.focusedItem.subscribe(function (item) {
			if (item) {
				_this.sLastUid = _this.getItemUid(item);
			}
		}, this);

		var aCache = [],
		    aCheckedCache = [],
		    mFocused = null,
		    mSelected = null;

		this.list.subscribe(function (items) {

			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(items)) {
				__WEBPACK_IMPORTED_MODULE_1_____default.a.each(items, function (item) {
					if (item) {
						var uid = _this.getItemUid(item);

						aCache.push(uid);
						if (item.checked()) {
							aCheckedCache.push(uid);
						}
						if (null === mFocused && item.focused()) {
							mFocused = uid;
						}
						if (null === mSelected && item.selected()) {
							mSelected = uid;
						}
					}
				});
			}
		}, this, 'beforeChange');

		this.list.subscribe(function (aItems) {

			var oTemp = null,
			    bGetNext = false,
			    aUids = [],
			    mNextFocused = mFocused,
			    bChecked = false,
			    bSelected = false,
			    iLen = 0;

			_this.selectedItemUseCallback = false;

			_this.focusedItem(null);
			_this.selectedItem(null);

			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isArray"])(aItems)) {
				iLen = aCheckedCache.length;

				__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aItems, function (oItem) {

					var sUid = _this.getItemUid(oItem);
					aUids.push(sUid);

					if (null !== mFocused && mFocused === sUid) {
						_this.focusedItem(oItem);
						mFocused = null;
					}

					if (0 < iLen && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(sUid, aCheckedCache)) {
						bChecked = true;
						oItem.checked(true);
						iLen -= 1;
					}

					if (!bChecked && null !== mSelected && mSelected === sUid) {
						bSelected = true;
						_this.selectedItem(oItem);
						mSelected = null;
					}
				});

				_this.selectedItemUseCallback = true;

				if (!bChecked && !bSelected && _this.autoSelect()) {
					if (_this.focusedItem()) {
						_this.selectedItem(_this.focusedItem());
					} else if (0 < aItems.length) {
						if (null !== mNextFocused) {
							bGetNext = false;
							mNextFocused = __WEBPACK_IMPORTED_MODULE_1_____default.a.find(aCache, function (sUid) {
								if (bGetNext && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(sUid, aUids)) {
									return sUid;
								} else if (mNextFocused === sUid) {
									bGetNext = true;
								}
								return false;
							});

							if (mNextFocused) {
								oTemp = __WEBPACK_IMPORTED_MODULE_1_____default.a.find(aItems, function (oItem) {
									return mNextFocused === _this.getItemUid(oItem);
								});
							}
						}

						_this.selectedItem(oTemp || null);
						_this.focusedItem(_this.selectedItem());
					}
				}

				if ((0 !== _this.iSelectNextHelper || 0 !== _this.iFocusedNextHelper) && 0 < aItems.length && !_this.focusedItem()) {
					oTemp = null;
					if (0 !== _this.iFocusedNextHelper) {
						oTemp = aItems[-1 === _this.iFocusedNextHelper ? aItems.length - 1 : 0] || null;
					}

					if (!oTemp && 0 !== _this.iSelectNextHelper) {
						oTemp = aItems[-1 === _this.iSelectNextHelper ? aItems.length - 1 : 0] || null;
					}

					if (oTemp) {
						if (0 !== _this.iSelectNextHelper) {
							_this.selectedItem(oTemp || null);
						}

						_this.focusedItem(oTemp || null);

						_this.scrollToFocused();

						__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
							return _this.scrollToFocused();
						}, 100);
					}

					_this.iSelectNextHelper = 0;
					_this.iFocusedNextHelper = 0;
				}
			}

			aCache = [];
			aCheckedCache = [];
			mFocused = null;
			mSelected = null;
		}, this);
	}

	Selector.prototype.itemSelected = function itemSelected(item) {

		if (this.isListChecked()) {
			if (!item) {
				(this.oCallbacks.onItemSelect || __WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"])(item || null);
			}
		} else {
			if (item) {
				(this.oCallbacks.onItemSelect || __WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"])(item);
			}
		}
	};

	/**
  * @param {boolean} forceSelect
  */


	Selector.prototype.goDown = function goDown(forceSelect) {
		this.newSelectPosition(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down, false, forceSelect);
	};

	/**
  * @param {boolean} forceSelect
  */


	Selector.prototype.goUp = function goUp(forceSelect) {
		this.newSelectPosition(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up, false, forceSelect);
	};

	Selector.prototype.unselect = function unselect() {
		this.selectedItem(null);
		this.focusedItem(null);
	};

	Selector.prototype.init = function init(contentVisible, contentScrollable) {
		var _this2 = this;

		var keyScope = arguments.length <= 2 || arguments[2] === undefined ? 'all' : arguments[2];


		this.oContentVisible = contentVisible;
		this.oContentScrollable = contentScrollable;

		if (this.oContentVisible && this.oContentScrollable) {
			__WEBPACK_IMPORTED_MODULE_0_____default()(this.oContentVisible).on('selectstart', function (event) {
				if (event && event.preventDefault) {
					event.preventDefault();
				}
			}).on('click', this.sItemSelector, function (event) {
				_this2.actionClick(__WEBPACK_IMPORTED_MODULE_3_ko___default.a.dataFor(event.currentTarget), event);
			}).on('click', this.sItemCheckedSelector, function (event) {
				var item = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.dataFor(event.currentTarget);
				if (item) {
					if (event && event.shiftKey) {
						_this2.actionClick(item, event);
					} else {
						_this2.focusedItem(item);
						item.checked(!item.checked());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_2_key___default()('enter', keyScope, function () {
				if (_this2.focusedItem() && !_this2.focusedItem().selected()) {
					_this2.actionClick(_this2.focusedItem());
					return false;
				}

				return true;
			});

			__WEBPACK_IMPORTED_MODULE_2_key___default()('ctrl+up, command+up, ctrl+down, command+down', keyScope, function () {
				return false;
			});

			__WEBPACK_IMPORTED_MODULE_2_key___default()('up, shift+up, down, shift+down, home, end, pageup, pagedown, insert, space', keyScope, function (event, handler) {
				if (event && handler && handler.shortcut) {
					var eventKey = 0;
					switch (handler.shortcut) {
						case 'up':
						case 'shift+up':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up;
							break;
						case 'down':
						case 'shift+down':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down;
							break;
						case 'insert':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert;
							break;
						case 'space':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space;
							break;
						case 'home':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Home;
							break;
						case 'end':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].End;
							break;
						case 'pageup':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageUp;
							break;
						case 'pagedown':
							eventKey = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageDown;
							break;
						// no default
					}

					if (0 < eventKey) {
						_this2.newSelectPosition(eventKey, __WEBPACK_IMPORTED_MODULE_2_key___default.a.shift);
						return false;
					}
				}

				return true;
			});
		}
	};

	/**
  * @returns {boolean}
  */


	Selector.prototype.autoSelect = function autoSelect() {
		return !!(this.oCallbacks.onAutoSelect || __WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noopTrue"])();
	};

	/**
  * @param {boolean} up
  */


	Selector.prototype.doUpUpOrDownDown = function doUpUpOrDownDown(up) {
		(this.oCallbacks.onUpUpOrDownDown || __WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noopTrue"])(!!up);
	};

	/**
  * @param {Object} oItem
  * @returns {string}
  */


	Selector.prototype.getItemUid = function getItemUid(item) {

		var uid = '';

		var getItemUidCallback = this.oCallbacks.onItemGetUid || null;
		if (getItemUidCallback && item) {
			uid = getItemUidCallback(item);
		}

		return uid.toString();
	};

	/**
  * @param {number} iEventKeyCode
  * @param {boolean} bShiftKey
  * @param {boolean=} bForceSelect = false
  */


	Selector.prototype.newSelectPosition = function newSelectPosition(iEventKeyCode, bShiftKey, bForceSelect) {

		var iIndex = 0,
		    iPageStep = 10,
		    bNext = false,
		    bStop = false,
		    oResult = null,
		    aList = this.list(),
		    iListLen = aList ? aList.length : 0,
		    oFocused = this.focusedItem();

		if (0 < iListLen) {
			if (!oFocused) {
				if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Home === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageUp === iEventKeyCode) {
					oResult = aList[0];
				} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].End === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageDown === iEventKeyCode) {
					oResult = aList[aList.length - 1];
				}
			} else if (oFocused) {
				if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(aList, function (item) {
						if (!bStop) {
							switch (iEventKeyCode) {
								case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up:
									if (oFocused === item) {
										bStop = true;
									} else {
										oResult = item;
									}
									break;
								case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down:
								case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert:
									if (bNext) {
										oResult = item;
										bStop = true;
									} else if (oFocused === item) {
										bNext = true;
									}
									break;
								// no default
							}
						}
					});

					if (!oResult && (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode)) {
						this.doUpUpOrDownDown(__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode);
					}
				} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Home === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].End === iEventKeyCode) {
					if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Home === iEventKeyCode) {
						oResult = aList[0];
					} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].End === iEventKeyCode) {
						oResult = aList[aList.length - 1];
					}
				} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageDown === iEventKeyCode) {
					for (; iIndex < iListLen; iIndex++) {
						if (oFocused === aList[iIndex]) {
							iIndex += iPageStep;
							iIndex = iListLen - 1 < iIndex ? iListLen - 1 : iIndex;
							oResult = aList[iIndex];
							break;
						}
					}
				} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].PageUp === iEventKeyCode) {
					for (iIndex = iListLen; 0 <= iIndex; iIndex--) {
						if (oFocused === aList[iIndex]) {
							iIndex -= iPageStep;
							iIndex = 0 > iIndex ? 0 : iIndex;
							oResult = aList[iIndex];
							break;
						}
					}
				}
			}
		}

		if (oResult) {
			this.focusedItem(oResult);

			if (oFocused) {
				if (bShiftKey) {
					if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down === iEventKeyCode) {
						oFocused.checked(!oFocused.checked());
					}
				} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
					oFocused.checked(!oFocused.checked());
				}
			}

			if ((this.autoSelect() || !!bForceSelect) && !this.isListChecked() && __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space !== iEventKeyCode) {
				this.selectedItem(oResult);
			}

			this.scrollToFocused();
		} else if (oFocused) {
			if (bShiftKey && (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Up === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Down === iEventKeyCode)) {
				oFocused.checked(!oFocused.checked());
			} else if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Insert === iEventKeyCode || __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["EventKeyCode"].Space === iEventKeyCode) {
				oFocused.checked(!oFocused.checked());
			}

			this.focusedItem(oFocused);
		}
	};

	/**
  * @returns {boolean}
  */


	Selector.prototype.scrollToFocused = function scrollToFocused() {

		if (!this.oContentVisible || !this.oContentScrollable) {
			return false;
		}

		var offset = 20,
		    list = this.list(),
		    $focused = __WEBPACK_IMPORTED_MODULE_0_____default()(this.sItemFocusedSelector, this.oContentScrollable),
		    pos = $focused.position(),
		    visibleHeight = this.oContentVisible.height(),
		    focusedHeight = $focused.outerHeight();

		if (list && list[0] && list[0].focused()) {
			this.oContentScrollable.scrollTop(0);
			return true;
		} else if (pos && (0 > pos.top || pos.top + focusedHeight > visibleHeight)) {
			this.oContentScrollable.scrollTop(0 > pos.top ? this.oContentScrollable.scrollTop() + pos.top - offset : this.oContentScrollable.scrollTop() + pos.top - visibleHeight + focusedHeight + offset);

			return true;
		}

		return false;
	};

	/**
  * @param {boolean=} fast = false
  * @returns {boolean}
  */


	Selector.prototype.scrollToTop = function scrollToTop() {
		var fast = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];


		if (!this.oContentVisible || !this.oContentScrollable) {
			return false;
		}

		if (fast || 50 > this.oContentScrollable.scrollTop()) {
			this.oContentScrollable.scrollTop(0);
		} else {
			this.oContentScrollable.stop().animate({ scrollTop: 0 }, 200);
		}

		return true;
	};

	Selector.prototype.eventClickFunction = function eventClickFunction(item, event) {

		var index = 0,
		    length = 0,
		    changeRange = false,
		    isInRange = false,
		    list = [],
		    checked = false,
		    listItem = null,
		    lineUid = '';

		var uid = this.getItemUid(item);
		if (event && event.shiftKey) {
			if ('' !== uid && '' !== this.sLastUid && uid !== this.sLastUid) {
				list = this.list();
				checked = item.checked();

				for (index = 0, length = list.length; index < length; index++) {
					listItem = list[index];
					lineUid = this.getItemUid(listItem);

					changeRange = false;
					if (lineUid === this.sLastUid || lineUid === uid) {
						changeRange = true;
					}

					if (changeRange) {
						isInRange = !isInRange;
					}

					if (isInRange || changeRange) {
						listItem.checked(checked);
					}
				}
			}
		}

		this.sLastUid = '' === uid ? '' : uid;
	};

	/**
  * @param {Object} item
  * @param {Object=} event
  */


	Selector.prototype.actionClick = function actionClick(item) {
		var event = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];


		if (item) {
			var click = true;
			if (event) {
				if (event.shiftKey && !(event.ctrlKey || event.metaKey) && !event.altKey) {
					click = false;
					if ('' === this.sLastUid) {
						this.sLastUid = this.getItemUid(item);
					}

					item.checked(!item.checked());
					this.eventClickFunction(item, event);

					this.focusedItem(item);
				} else if ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey) {
					click = false;
					this.focusedItem(item);

					if (this.selectedItem() && item !== this.selectedItem()) {
						this.selectedItem().checked(true);
					}

					item.checked(!item.checked());
				}
			}

			if (click) {
				this.selectMessageItem(item);
			}
		}
	};

	Selector.prototype.on = function on(eventName, callback) {
		this.oCallbacks[eventName] = callback;
	};

	Selector.prototype.selectMessageItem = function selectMessageItem(messageItem) {
		this.focusedItem(messageItem);
		this.selectedItem(messageItem);
		this.scrollToFocused();
	};

	return Selector;
}();



/***/ },
/* 103 */
/*!********************************!*\
  !*** ./dev/Helper/Message.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Model_Email__ = __webpack_require__(/*! Model/Email */ 30);
/* harmony export */ exports["emailArrayToString"] = emailArrayToString;/* harmony export */ exports["emailArrayToStringClear"] = emailArrayToStringClear;/* harmony export */ exports["emailArrayFromJson"] = emailArrayFromJson;/* harmony export */ exports["replyHelper"] = replyHelper;



/**
 * @param {Array.<EmailModel>} emails
 * @param {boolean=} friendlyView = false
 * @param {boolean=} wrapWithLink = false
 * @returns {string}
 */
function emailArrayToString(emails) {
	var friendlyView = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
	var wrapWithLink = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];


	var index = 0,
	    len = 0;
	var result = [];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(emails)) {
		for (len = emails.length; index < len; index++) {
			result.push(emails[index].toLine(friendlyView, wrapWithLink));
		}
	}

	return result.join(', ');
}

/**
 * @param {Array.<EmailModel>} emails
 * @returns {string}
 */
function emailArrayToStringClear(emails) {

	var index = 0,
	    len = 0;
	var result = [];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(emails)) {
		for (len = emails.length; index < len; index++) {
			if (emails[index] && emails[index].email && '' !== emails[index].name) {
				result.push(emails[index].email);
			}
		}
	}

	return result.join(', ');
}

/**
 * @param {?Array} json
 * @returns {Array.<EmailModel>}
 */
function emailArrayFromJson(json) {

	var index = 0,
	    len = 0,
	    email = null;
	var result = [];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isNonEmptyArray"])(json)) {
		for (index = 0, len = json.length; index < len; index++) {
			email = __WEBPACK_IMPORTED_MODULE_1_Model_Email__["EmailModel"].newInstanceFromJson(json[index]);
			if (email) {
				result.push(email);
			}
		}
	}

	return result;
}

/**
 * @param {Array.<EmailModel>} inputEmails
 * @param {Object} unic
 * @param {Array} localEmails
 */
function replyHelper(inputEmails, unic, localEmails) {

	if (inputEmails && 0 < inputEmails.length) {
		var index = 0;
		var len = inputEmails.length;

		for (; index < len; index++) {
			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isUnd"])(unic[inputEmails[index].email])) {
				unic[inputEmails[index].email] = true;
				localEmails.push(inputEmails[index]);
			}
		}
	}
}

/***/ },
/* 104 */
/*!**********************************!*\
  !*** ./dev/Model/Attachment.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Audio__ = __webpack_require__(/*! Common/Audio */ 67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Audio___default = __WEBPACK_IMPORTED_MODULE_8_Common_Audio__ && __WEBPACK_IMPORTED_MODULE_8_Common_Audio__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_8_Common_Audio__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_8_Common_Audio__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_8_Common_Audio___default, 'a', __WEBPACK_IMPORTED_MODULE_8_Common_Audio___default);

/* harmony export */ __webpack_require__.d(exports, "d", function() { return staticFileType; });
/* harmony export */ __webpack_require__.d(exports, "c", function() { return staticIconClass; });
/* harmony export */ __webpack_require__.d(exports, "a", function() { return staticCombinedIconClass; });
/* harmony export */ __webpack_require__.d(exports, "b", function() { return AttachmentModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }














/**
 * @param {string} sExt
 * @param {string} sMimeType
 * @returns {string}
 */
var staticFileType = __WEBPACK_IMPORTED_MODULE_1_____default.a.memoize(function (ext, mimeType) {
	ext = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(ext).toLowerCase();
	mimeType = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(mimeType).toLowerCase();

	var result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Unknown;
	var mimeTypeParts = mimeType.split('/');

	switch (true) {
		case 'image' === mimeTypeParts[0] || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['png', 'jpg', 'jpeg', 'gif', 'bmp']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Image;
			break;
		case 'audio' === mimeTypeParts[0] || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['mp3', 'ogg', 'oga', 'wav']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio;
			break;
		case 'video' === mimeTypeParts[0] || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['mkv', 'avi']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Video;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['php', 'js', 'css']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Code;
			break;
		case 'eml' === ext || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeType, ['message/delivery-status', 'message/rfc822']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Eml;
			break;
		case 'text' === mimeTypeParts[0] && 'html' !== mimeTypeParts[1] || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['txt', 'log']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Text;
			break;
		case 'text/html' === mimeType || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['html']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Html;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeTypeParts[1], ['zip', '7z', 'tar', 'rar', 'gzip', 'bzip', 'bzip2', 'x-zip', 'x-7z', 'x-rar', 'x-tar', 'x-gzip', 'x-bzip', 'x-bzip2', 'x-zip-compressed', 'x-7z-compressed', 'x-rar-compressed']) || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['zip', '7z', 'tar', 'rar', 'gzip', 'bzip', 'bzip2']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Archive;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeTypeParts[1], ['pdf', 'x-pdf']) || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['pdf']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Pdf;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeType, ['application/pgp-signature', 'application/pgp-keys']) || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['asc', 'pem', 'ppk']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Certificate;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeType, ['application/pkcs7-signature']) || -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(ext, ['p7s']):

			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].CertificateBin;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeTypeParts[1], ['rtf', 'msword', 'vnd.msword', 'vnd.openxmlformats-officedocument.wordprocessingml.document', 'vnd.openxmlformats-officedocument.wordprocessingml.template', 'vnd.ms-word.document.macroEnabled.12', 'vnd.ms-word.template.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].WordText;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeTypeParts[1], ['excel', 'ms-excel', 'vnd.ms-excel', 'vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'vnd.openxmlformats-officedocument.spreadsheetml.template', 'vnd.ms-excel.sheet.macroEnabled.12', 'vnd.ms-excel.template.macroEnabled.12', 'vnd.ms-excel.addin.macroEnabled.12', 'vnd.ms-excel.sheet.binary.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Sheet;
			break;
		case -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(mimeTypeParts[1], ['powerpoint', 'ms-powerpoint', 'vnd.ms-powerpoint', 'vnd.openxmlformats-officedocument.presentationml.presentation', 'vnd.openxmlformats-officedocument.presentationml.template', 'vnd.openxmlformats-officedocument.presentationml.slideshow', 'vnd.ms-powerpoint.addin.macroEnabled.12', 'vnd.ms-powerpoint.presentation.macroEnabled.12', 'vnd.ms-powerpoint.template.macroEnabled.12', 'vnd.ms-powerpoint.slideshow.macroEnabled.12']):
			result = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Presentation;
			break;
		// no default
	}

	return result;
});

/**
 * @param {string} sFileType
 * @returns {string}
 */
var staticIconClass = __WEBPACK_IMPORTED_MODULE_1_____default.a.memoize(function (fileType) {
	var resultText = '',
	    resultClass = 'icon-file';

	switch (fileType) {
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Text:
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Eml:
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].WordText:
			resultClass = 'icon-file-text';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Html:
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Code:
			resultClass = 'icon-file-code';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Image:
			resultClass = 'icon-file-image';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio:
			resultClass = 'icon-file-music';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Video:
			resultClass = 'icon-file-movie';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Archive:
			resultClass = 'icon-file-zip';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Certificate:
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].CertificateBin:
			resultClass = 'icon-file-certificate';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Sheet:
			resultClass = 'icon-file-excel';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Presentation:
			resultClass = 'icon-file-chart-graph';
			break;
		case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Pdf:
			resultText = 'pdf';
			resultClass = 'icon-none';
			break;
		// no default
	}

	return [resultClass, resultText];
});

/**
 * @static
 * @param {string} sFileType
 * @returns {string}
 */
var staticCombinedIconClass = function staticCombinedIconClass(data) {
	var result = '',
	    types = [];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNonEmptyArray"])(data)) {
		result = 'icon-attachment';
		types = __WEBPACK_IMPORTED_MODULE_1_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data, function (item) {
			return item ? staticFileType(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["getFileExtension"])(item[0]), item[1]) : '';
		})));

		if (types && 1 === types.length && types[0]) {
			switch (types[0]) {
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Text:
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].WordText:
					result = 'icon-file-text';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Html:
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Code:
					result = 'icon-file-code';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Image:
					result = 'icon-file-image';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio:
					result = 'icon-file-music';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Video:
					result = 'icon-file-movie';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Archive:
					result = 'icon-file-zip';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Certificate:
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].CertificateBin:
					result = 'icon-file-certificate';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Sheet:
					result = 'icon-file-excel';
					break;
				case __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Presentation:
					result = 'icon-file-chart-graph';
					break;
				// no default
			}
		}
	}

	return result;
};

var AttachmentModel = function (_AbstractModel) {
	_inherits(AttachmentModel, _AbstractModel);

	function AttachmentModel() {
		_classCallCheck(this, AttachmentModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'AttachmentModel'));

		_this.checked = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

		_this.mimeType = '';
		_this.fileName = '';
		_this.fileNameExt = '';
		_this.fileType = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Unknown;
		_this.estimatedSize = 0;
		_this.friendlySize = '';
		_this.isInline = false;
		_this.isLinked = false;
		_this.isThumbnail = false;
		_this.cid = '';
		_this.cidWithOutTags = '';
		_this.contentLocation = '';
		_this.download = '';
		_this.folder = '';
		_this.uid = '';
		_this.mimeIndex = '';
		_this.framed = false;
		return _this;
	}

	/**
  * @static
  * @param {AjaxJsonAttachment} json
  * @returns {?AttachmentModel}
  */


	AttachmentModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var attachment = new AttachmentModel();
		return attachment.initByJson(json) ? attachment : null;
	};

	/**
  * @param {AjaxJsonAttachment} json
  * @returns {boolean}
  */


	AttachmentModel.prototype.initByJson = function initByJson(json) {
		var bResult = false;
		if (json && 'Object/Attachment' === json['@Object']) {
			this.mimeType = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])((json.MimeType || '').toLowerCase());
			this.fileName = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["trim"])(json.FileName);
			this.estimatedSize = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(json.EstimatedSize);
			this.isInline = !!json.IsInline;
			this.isLinked = !!json.IsLinked;
			this.isThumbnail = !!json.IsThumbnail;
			this.cid = json.CID;
			this.contentLocation = json.ContentLocation;
			this.download = json.Download;

			this.folder = json.Folder;
			this.uid = json.Uid;
			this.mimeIndex = json.MimeIndex;
			this.framed = !!json.Framed;

			this.friendlySize = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["friendlySize"])(this.estimatedSize);
			this.cidWithOutTags = this.cid.replace(/^<+/, '').replace(/>+$/, '');

			this.fileNameExt = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["getFileExtension"])(this.fileName);
			this.fileType = staticFileType(this.fileNameExt, this.mimeType);

			bResult = true;
		}

		return bResult;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isImage = function isImage() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Image === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isMp3 = function isMp3() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio === this.fileType && 'mp3' === this.fileNameExt;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isOgg = function isOgg() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio === this.fileType && ('oga' === this.fileNameExt || 'ogg' === this.fileNameExt);
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isWav = function isWav() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Audio === this.fileType && 'wav' === this.fileNameExt;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasThumbnail = function hasThumbnail() {
		return this.isThumbnail;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isText = function isText() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Text === this.fileType || __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Eml === this.fileType || __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Certificate === this.fileType || __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Html === this.fileType || __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Code === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isPdf = function isPdf() {
		return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["FileType"].Pdf === this.fileType;
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.isFramed = function isFramed() {
		return this.framed && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["data"].__APP__ && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["data"].__APP__.googlePreviewSupported() && !(this.isPdf() && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bAllowPdfPreview"]) && !this.isText() && !this.isImage();
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasPreview = function hasPreview() {
		return this.isImage() || this.isPdf() && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bAllowPdfPreview"] || this.isText() || this.isFramed();
	};

	/**
  * @returns {boolean}
  */


	AttachmentModel.prototype.hasPreplay = function hasPreplay() {
		return __WEBPACK_IMPORTED_MODULE_8_Common_Audio___default.a.supportedMp3 && this.isMp3() || __WEBPACK_IMPORTED_MODULE_8_Common_Audio___default.a.supportedOgg && this.isOgg() || __WEBPACK_IMPORTED_MODULE_8_Common_Audio___default.a.supportedWav && this.isWav();
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkDownload = function linkDownload() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["attachmentDownload"])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreview = function linkPreview() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["attachmentPreview"])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkThumbnail = function linkThumbnail() {
		return this.hasThumbnail() ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["attachmentThumbnailPreview"])(this.download) : '';
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkThumbnailPreviewStyle = function linkThumbnailPreviewStyle() {
		var link = this.linkThumbnail();
		return '' === link ? '' : 'background:url(' + link + ')';
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkFramed = function linkFramed() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["attachmentFramed"])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreviewAsPlain = function linkPreviewAsPlain() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["attachmentPreviewAsPlain"])(this.download);
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.linkPreviewMain = function linkPreviewMain() {
		var result = '';
		switch (true) {
			case this.isImage():
			case this.isPdf() && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bAllowPdfPreview"]:
				result = this.linkPreview();
				break;
			case this.isText():
				result = this.linkPreviewAsPlain();
				break;
			case this.isFramed():
				result = this.linkFramed();
				break;
			// no default
		}

		return result;
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.generateTransferDownloadUrl = function generateTransferDownloadUrl() {
		var link = this.linkDownload();
		if ('http' !== link.substr(0, 4)) {
			link = __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.protocol + '//' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.host + __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.pathname + link;
		}

		return this.mimeType + ':' + this.fileName + ':' + link;
	};

	/**
  * @param {AttachmentModel} attachment
  * @param {*} event
  * @returns {boolean}
  */


	AttachmentModel.prototype.eventDragStart = function eventDragStart(attachment, event) {
		var localEvent = event.originalEvent || event;
		if (attachment && localEvent && localEvent.dataTransfer && localEvent.dataTransfer.setData) {
			localEvent.dataTransfer.setData('DownloadURL', this.generateTransferDownloadUrl());
		}

		return true;
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.iconClass = function iconClass() {
		return staticIconClass(this.fileType)[0];
	};

	/**
  * @returns {string}
  */


	AttachmentModel.prototype.iconText = function iconText() {
		return staticIconClass(this.fileType)[1];
	};

	return AttachmentModel;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 105 */
/*!******************************!*\
  !*** ./dev/Model/Filter.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Model_FilterCondition__ = __webpack_require__(/*! Model/FilterCondition */ 166);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "FilterModel", function() { return FilterModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return FilterModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var FilterModel = function (_AbstractModel) {
	_inherits(FilterModel, _AbstractModel);

	function FilterModel() {
		_classCallCheck(this, FilterModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'FilterModel'));

		_this.enabled = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);

		_this.id = '';

		_this.name = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		_this.name.error = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.name.focused = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);

		_this.conditions = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observableArray([]);
		_this.conditionsType = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FilterRulesType"].Any);

		// Actions
		_this.actionValue = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		_this.actionValue.error = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);

		_this.actionValueSecond = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		_this.actionValueThird = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');

		_this.actionValueFourth = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		_this.actionValueFourth.error = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);

		_this.actionMarkAsRead = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);

		_this.actionKeep = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);
		_this.actionNoStop = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);

		_this.actionType = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].MoveTo);

		_this.actionType.subscribe(function () {
			_this.actionValue('');
			_this.actionValue.error(false);
			_this.actionValueSecond('');
			_this.actionValueThird('');
			_this.actionValueFourth('');
			_this.actionValueFourth.error(false);
		});

		var fGetRealFolderName = function fGetRealFolderName(folderFullNameRaw) {
			var folder = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Cache__["getFolderFromCacheList"])(folderFullNameRaw);
			return folder ? folder.fullName.replace('.' === folder.delimiter ? /\./ : /[\\\/]+/, ' / ') : folderFullNameRaw;
		};

		_this.nameSub = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var result = '';
			var actionValue = _this.actionValue();

			switch (_this.actionType()) {
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].MoveTo:
					result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('SETTINGS_FILTERS/SUBNAME_MOVE_TO', {
						FOLDER: fGetRealFolderName(actionValue)
					});
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Forward:
					result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('SETTINGS_FILTERS/SUBNAME_FORWARD_TO', {
						EMAIL: actionValue
					});
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Vacation:
					result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('SETTINGS_FILTERS/SUBNAME_VACATION_MESSAGE');
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Reject:
					result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('SETTINGS_FILTERS/SUBNAME_REJECT');
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Discard:
					result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('SETTINGS_FILTERS/SUBNAME_DISCARD');
					break;
				// no default
			}

			return result ? '(' + result + ')' : '';
		});

		_this.actionTemplate = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var result = '';

			switch (_this.actionType()) {
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Forward:
					result = 'SettingsFiltersActionForward';
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Vacation:
					result = 'SettingsFiltersActionVacation';
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Reject:
					result = 'SettingsFiltersActionReject';
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].None:
					result = 'SettingsFiltersActionNone';
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Discard:
					result = 'SettingsFiltersActionDiscard';
					break;
				case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].MoveTo:
				default:
					result = 'SettingsFiltersActionMoveToFolder';
					break;
			}

			return result;
		});

		_this.regDisposables(_this.conditions.subscribe(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["windowResizeCallback"]));

		_this.regDisposables(_this.name.subscribe(function (sValue) {
			_this.name.error('' === sValue);
		}));

		_this.regDisposables(_this.actionValue.subscribe(function (sValue) {
			_this.actionValue.error('' === sValue);
		}));

		_this.regDisposables([_this.actionNoStop, _this.actionTemplate]);

		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.canBeDeleted = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);
		return _this;
	}

	FilterModel.prototype.generateID = function generateID() {
		this.id = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["fakeMd5"])();
	};

	FilterModel.prototype.verify = function verify() {
		if ('' === this.name()) {
			this.name.error(true);
			return false;
		}

		if (0 < this.conditions().length) {
			if (__WEBPACK_IMPORTED_MODULE_0_____default.a.find(this.conditions(), function (cond) {
				return cond && !cond.verify();
			})) {
				return false;
			}
		}

		if ('' === this.actionValue()) {
			if (-1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["inArray"])(this.actionType(), [__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].MoveTo, __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Forward, __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Reject, __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Vacation])) {
				this.actionValue.error(true);
				return false;
			}
		}

		if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Forward === this.actionType() && -1 === this.actionValue().indexOf('@')) {
			this.actionValue.error(true);
			return false;
		}

		if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FiltersAction"].Vacation === this.actionType() && '' !== this.actionValueFourth() && -1 === this.actionValueFourth().indexOf('@')) {
			this.actionValueFourth.error(true);
			return false;
		}

		this.name.error(false);
		this.actionValue.error(false);

		return true;
	};

	FilterModel.prototype.toJson = function toJson() {
		return {
			ID: this.id,
			Enabled: this.enabled() ? '1' : '0',
			Name: this.name(),
			ConditionsType: this.conditionsType(),
			Conditions: __WEBPACK_IMPORTED_MODULE_0_____default.a.map(this.conditions(), function (oItem) {
				return oItem.toJson();
			}),

			ActionValue: this.actionValue(),
			ActionValueSecond: this.actionValueSecond(),
			ActionValueThird: this.actionValueThird(),
			ActionValueFourth: this.actionValueFourth(),
			ActionType: this.actionType(),

			Stop: this.actionNoStop() ? '0' : '1',
			Keep: this.actionKeep() ? '1' : '0',
			MarkAsRead: this.actionMarkAsRead() ? '1' : '0'
		};
	};

	FilterModel.prototype.addCondition = function addCondition() {
		this.conditions.push(new __WEBPACK_IMPORTED_MODULE_6_Model_FilterCondition__["a" /* FilterConditionModel */]());
	};

	FilterModel.prototype.removeCondition = function removeCondition(oConditionToDelete) {
		this.conditions.remove(oConditionToDelete);
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["delegateRunOnDestroy"])(oConditionToDelete);
	};

	FilterModel.prototype.setRecipients = function setRecipients() {
		this.actionValueFourth(__webpack_require__(/*! Stores/User/Account */ 28).accountsEmails().join(', '));
	};

	FilterModel.prototype.parse = function parse(json) {
		var result = false;
		if (json && 'Object/Filter' === json['@Object']) {
			this.id = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ID);
			this.name(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.Name));
			this.enabled(!!json.Enabled);

			this.conditionsType(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ConditionsType));

			this.conditions([]);

			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNonEmptyArray"])(json.Conditions)) {
				this.conditions(__WEBPACK_IMPORTED_MODULE_0_____default.a.compact(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(json.Conditions, function (aData) {
					var filterCondition = new __WEBPACK_IMPORTED_MODULE_6_Model_FilterCondition__["a" /* FilterConditionModel */]();
					return filterCondition && filterCondition.parse(aData) ? filterCondition : null;
				})));
			}

			this.actionType(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ActionType));

			this.actionValue(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ActionValue));
			this.actionValueSecond(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ActionValueSecond));
			this.actionValueThird(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ActionValueThird));
			this.actionValueFourth(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.ActionValueFourth));

			this.actionNoStop(!json.Stop);
			this.actionKeep(!!json.Keep);
			this.actionMarkAsRead(!!json.MarkAsRead);

			result = true;
		}

		return result;
	};

	FilterModel.prototype.cloneSelf = function cloneSelf() {
		var filter = new FilterModel();

		filter.id = this.id;

		filter.enabled(this.enabled());

		filter.name(this.name());
		filter.name.error(this.name.error());

		filter.conditionsType(this.conditionsType());

		filter.actionMarkAsRead(this.actionMarkAsRead());

		filter.actionType(this.actionType());

		filter.actionValue(this.actionValue());
		filter.actionValue.error(this.actionValue.error());

		filter.actionValueSecond(this.actionValueSecond());
		filter.actionValueThird(this.actionValueThird());
		filter.actionValueFourth(this.actionValueFourth());

		filter.actionKeep(this.actionKeep());
		filter.actionNoStop(this.actionNoStop());

		filter.conditions(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(this.conditions(), function (item) {
			return item.cloneSelf();
		}));

		return filter;
	};

	return FilterModel;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 106 */,
/* 107 */,
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */,
/* 112 */
/*!**************************************!*\
  !*** ./dev/Promises/AbstractAjax.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	$ = __webpack_require__(/*! $ */ 10),
	_ = __webpack_require__(/*! _ */ 2),
	Promise = __webpack_require__(/*! Promise */ 37),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Plugins = __webpack_require__(/*! Common/Plugins */ 21),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	AbstractBasicPromises = __webpack_require__(/*! Promises/AbstractBasic */ 89);

/**
* @constructor
*/
function AbstractAjaxPromises()
{
	AbstractBasicPromises.call(this);

	this.clear();
}

_.extend(AbstractAjaxPromises.prototype, AbstractBasicPromises.prototype);

AbstractAjaxPromises.prototype.oRequests = {};

AbstractAjaxPromises.prototype.clear = function()
{
	this.oRequests = {};
};

AbstractAjaxPromises.prototype.abort = function(sAction, bClearOnly)
{
	if (this.oRequests[sAction])
	{
		if (!bClearOnly && this.oRequests[sAction].abort)
		{
			this.oRequests[sAction].__aborted__ = true;
			this.oRequests[sAction].abort();
		}

		this.oRequests[sAction] = null;
		delete this.oRequests[sAction];
	}

	return this;
};

AbstractAjaxPromises.prototype.ajaxRequest = function(sAction, bPost, iTimeOut, oParameters, sAdditionalGetString, fTrigger)
{
	var self = this;
	return new Promise(function(resolve, reject) {

		var
			oH = null,
			iStart = Utils.microtime();

		iTimeOut = Utils.isNormal(iTimeOut) ? iTimeOut : Consts.DEFAULT_AJAX_TIMEOUT;
		sAdditionalGetString = Utils.isUnd(sAdditionalGetString) ? '' : Utils.pString(sAdditionalGetString);

		if (bPost)
		{
			oParameters.XToken = Settings.appSettingsGet('token');
		}

		Plugins.runHook('ajax-default-request', [sAction, oParameters, sAdditionalGetString]);

		self.setTrigger(fTrigger, true);

		oH = $.ajax({
			type: bPost ? 'POST' : 'GET',
			url: Links.ajax(sAdditionalGetString),
			async: true,
			dataType: 'json',
			data: bPost ? (oParameters || {}) : {},
			timeout: iTimeOut,
			global: true
		}).always(function(oData, sTextStatus) {

			var bCached = false, oErrorData = null, sType = Enums.StorageResultType.Error;
			if (oData && oData.Time)
			{
				bCached = Utils.pInt(oData.Time) > Utils.microtime() - iStart;
			}

			// backward capability
			switch (true)
			{
				case 'success' === sTextStatus && oData && oData.Result && sAction === oData.Action:
					sType = Enums.StorageResultType.Success;
					break;
				case 'abort' === sTextStatus && (!oData || !oData.__aborted__):
					sType = Enums.StorageResultType.Abort;
					break;
				// no default
			}

			Plugins.runHook('ajax-default-response', [sAction,
				Enums.StorageResultType.Success === sType ? oData : null, sType, bCached, oParameters]);

			if ('success' === sTextStatus)
			{
				if (oData && oData.Result && sAction === oData.Action)
				{
					oData.__cached__ = bCached;
					resolve(oData);
				}
				else if (oData && oData.Action)
				{
					oErrorData = oData;
					reject(oData.ErrorCode ? oData.ErrorCode : Enums.Notification.AjaxFalse);
				}
				else
				{
					oErrorData = oData;
					reject(Enums.Notification.AjaxParse);
				}
			}
			else if ('timeout' === sTextStatus)
			{
				oErrorData = oData;
				reject(Enums.Notification.AjaxTimeout);
			}
			else if ('abort' === sTextStatus)
			{
				if (!oData || !oData.__aborted__)
				{
					reject(Enums.Notification.AjaxAbort);
				}
			}
			else
			{
				oErrorData = oData;
				reject(Enums.Notification.AjaxParse);
			}

			if (self.oRequests[sAction])
			{
				self.oRequests[sAction] = null;
				delete self.oRequests[sAction];
			}

			self.setTrigger(fTrigger, false);

			if (oErrorData)
			{
				if (-1 < Utils.inArray(oErrorData.ErrorCode, [
					Enums.Notification.AuthError, Enums.Notification.AccessError,
					Enums.Notification.ConnectionError, Enums.Notification.DomainNotAllowed, Enums.Notification.AccountNotAllowed,
					Enums.Notification.MailServerError,	Enums.Notification.UnknownNotification, Enums.Notification.UnknownError
				]))
				{
					Globals.data.iAjaxErrorCount += 1;
				}

				if (Enums.Notification.InvalidToken === oErrorData.ErrorCode)
				{
					Globals.data.iTokenErrorCount += 1;
				}

				if (Consts.TOKEN_ERROR_LIMIT < Globals.data.iTokenErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.loginAndLogoutReload)
					{
						Globals.data.__APP__.loginAndLogoutReload(false, true);
					}
				}

				if (oErrorData.ClearAuth || oErrorData.Logout || Consts.AJAX_ERROR_LIMIT < Globals.data.iAjaxErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.clearClientSideToken)
					{
						Globals.data.__APP__.clearClientSideToken();
					}

					if (Globals.data.__APP__ && !oErrorData.ClearAuth && Globals.data.__APP__.loginAndLogoutReload)
					{
						Globals.data.__APP__.loginAndLogoutReload(false, true);
					}
				}
			}

		});

		if (oH)
		{
			if (self.oRequests[sAction])
			{
				self.oRequests[sAction] = null;
				delete self.oRequests[sAction];
			}

			self.oRequests[sAction] = oH;
		}
	});
};

AbstractAjaxPromises.prototype.getRequest = function(sAction, fTrigger, sAdditionalGetString, iTimeOut)
{
	sAdditionalGetString = Utils.isUnd(sAdditionalGetString) ? '' : Utils.pString(sAdditionalGetString);
	sAdditionalGetString = sAction + '/' + sAdditionalGetString;

	return this.ajaxRequest(sAction, false, iTimeOut, null, sAdditionalGetString, fTrigger);
};

AbstractAjaxPromises.prototype.postRequest = function(action, fTrigger, params, timeOut)
{
	params = params || {};
	params.Action = action;

	return this.ajaxRequest(action, true, timeOut, params, '', fTrigger);
};

module.exports = AbstractAjaxPromises;


/***/ },
/* 113 */
/*!****************************************!*\
  !*** ./dev/Promises/User/Populator.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Cache = __webpack_require__(/*! Common/Cache */ 19),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Local = __webpack_require__(/*! Storage/Client */ 47),

	FolderModel = __webpack_require__(/*! Model/Folder */ 167).default,

	AbstractBasicPromises = __webpack_require__(/*! Promises/AbstractBasic */ 89);

/**
 * @constructor
 */
function PromisesUserPopulator()
{
	AbstractBasicPromises.call(this);
}

_.extend(PromisesUserPopulator.prototype, AbstractBasicPromises.prototype);

/**
 * @param {string} sFullNameHash
 * @returns {boolean}
 */
PromisesUserPopulator.prototype.isFolderExpanded = function(sFullNameHash)
{
	var aExpandedList = Local.get(Enums.ClientSideKeyName.ExpandedFolders);
	return Utils.isArray(aExpandedList) && -1 !== _.indexOf(aExpandedList, sFullNameHash);
};

/**
 * @param {string} sFolderFullNameRaw
 * @returns {string}
 */
PromisesUserPopulator.prototype.normalizeFolder = function(sFolderFullNameRaw)
{
	return ('' === sFolderFullNameRaw || Consts.UNUSED_OPTION_VALUE === sFolderFullNameRaw ||
		null !== Cache.getFolderFromCacheList(sFolderFullNameRaw)) ? sFolderFullNameRaw : '';
};

/**
 * @param {string} sNamespace
 * @param {Array} aFolders
 * @returns {Array}
 */
PromisesUserPopulator.prototype.folderResponseParseRec = function(sNamespace, aFolders)
{
	var
		self = this,
		iIndex = 0,
		iLen = 0,
		oFolder = null,
		oCacheFolder = null,
		sFolderFullNameRaw = '',
		aSubFolders = [],
		aList = [];

	for (iIndex = 0, iLen = aFolders.length; iIndex < iLen; iIndex++)
	{
		oFolder = aFolders[iIndex];
		if (oFolder)
		{
			sFolderFullNameRaw = oFolder.FullNameRaw;

			oCacheFolder = Cache.getFolderFromCacheList(sFolderFullNameRaw);
			if (!oCacheFolder)
			{
				oCacheFolder = FolderModel.newInstanceFromJson(oFolder);
				if (oCacheFolder)
				{
					Cache.setFolderToCacheList(sFolderFullNameRaw, oCacheFolder);
					Cache.setFolderFullNameRaw(oCacheFolder.fullNameHash, sFolderFullNameRaw, oCacheFolder);
				}
			}

			if (oCacheFolder)
			{
				if (!FolderStore.displaySpecSetting())
				{
					oCacheFolder.checkable(true);
				}
				else
				{
					oCacheFolder.checkable(!!oFolder.Checkable);
				}

				oCacheFolder.collapsed(!self.isFolderExpanded(oCacheFolder.fullNameHash));

				if (oFolder.Extended)
				{
					if (oFolder.Extended.Hash)
					{
						Cache.setFolderHash(oCacheFolder.fullNameRaw, oFolder.Extended.Hash);
					}

					if (Utils.isNormal(oFolder.Extended.MessageCount))
					{
						oCacheFolder.messageCountAll(oFolder.Extended.MessageCount);
					}

					if (Utils.isNormal(oFolder.Extended.MessageUnseenCount))
					{
						oCacheFolder.messageCountUnread(oFolder.Extended.MessageUnseenCount);
					}
				}

				aSubFolders = oFolder.SubFolders;
				if (aSubFolders && 'Collection/FolderCollection' === aSubFolders['@Object'] &&
					aSubFolders['@Collection'] && Utils.isArray(aSubFolders['@Collection']))
				{
					oCacheFolder.subFolders(
						this.folderResponseParseRec(sNamespace, aSubFolders['@Collection']));
				}

				aList.push(oCacheFolder);
			}
		}
	}

	return aList;
};

PromisesUserPopulator.prototype.foldersList = function(oData)
{
	if (oData && 'Collection/FolderCollection' === oData['@Object'] &&
		oData['@Collection'] && Utils.isArray(oData['@Collection']))
	{
		var
			iLimit = Utils.pInt(Settings.appSettingsGet('folderSpecLimit')),
			iC = Utils.pInt(oData.CountRec);

		iLimit = 100 < iLimit ? 100 : (10 > iLimit ? 10 : iLimit);

		FolderStore.displaySpecSetting(0 >= iC || iLimit < iC);
		FolderStore.folderList(this.folderResponseParseRec(
			Utils.isUnd(oData.Namespace) ? '' : oData.Namespace, oData['@Collection']));
	}
};

PromisesUserPopulator.prototype.foldersAdditionalParameters = function(oData)
{
	if (oData && oData && 'Collection/FolderCollection' === oData['@Object'] &&
		oData['@Collection'] && Utils.isArray(oData['@Collection']))
	{
		if (!Utils.isUnd(oData.Namespace))
		{
			FolderStore.namespace = oData.Namespace;
		}

		AppStore.threadsAllowed(!!Settings.appSettingsGet('useImapThread') && oData.IsThreadsSupported && true);

		FolderStore.folderList.optimized(!!oData.Optimized);

		var bUpdate = false;

		if (oData.SystemFolders && '' === '' +
			Settings.settingsGet('SentFolder') +
			Settings.settingsGet('DraftFolder') +
			Settings.settingsGet('SpamFolder') +
			Settings.settingsGet('TrashFolder') +
			Settings.settingsGet('ArchiveFolder') +
			Settings.settingsGet('NullFolder'))
		{
			Settings.settingsSet('SentFolder', oData.SystemFolders[Enums.ServerFolderType.SENT] || null);
			Settings.settingsSet('DraftFolder', oData.SystemFolders[Enums.ServerFolderType.DRAFTS] || null);
			Settings.settingsSet('SpamFolder', oData.SystemFolders[Enums.ServerFolderType.JUNK] || null);
			Settings.settingsSet('TrashFolder', oData.SystemFolders[Enums.ServerFolderType.TRASH] || null);
			Settings.settingsSet('ArchiveFolder', oData.SystemFolders[Enums.ServerFolderType.ALL] || null);

			bUpdate = true;
		}

		FolderStore.sentFolder(this.normalizeFolder(Settings.settingsGet('SentFolder')));
		FolderStore.draftFolder(this.normalizeFolder(Settings.settingsGet('DraftFolder')));
		FolderStore.spamFolder(this.normalizeFolder(Settings.settingsGet('SpamFolder')));
		FolderStore.trashFolder(this.normalizeFolder(Settings.settingsGet('TrashFolder')));
		FolderStore.archiveFolder(this.normalizeFolder(Settings.settingsGet('ArchiveFolder')));

		if (bUpdate)
		{
			__webpack_require__(/*! Remote/User/Ajax */ 14).saveSystemFolders(Utils.noop, {
				SentFolder: FolderStore.sentFolder(),
				DraftFolder: FolderStore.draftFolder(),
				SpamFolder: FolderStore.spamFolder(),
				TrashFolder: FolderStore.trashFolder(),
				ArchiveFolder: FolderStore.archiveFolder(),
				NullFolder: 'NullFolder'
			});
		}

		Local.set(Enums.ClientSideKeyName.FoldersLashHash, oData.FoldersHash);
	}
};

module.exports = new PromisesUserPopulator();


/***/ },
/* 114 */,
/* 115 */,
/* 116 */,
/* 117 */,
/* 118 */,
/* 119 */,
/* 120 */,
/* 121 */,
/* 122 */,
/* 123 */,
/* 124 */,
/* 125 */,
/* 126 */
/*!***************************************!*\
  !*** ./dev/Settings/User/Accounts.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Links = __webpack_require__(/*! Common/Links */ 12),

	AccountStore = __webpack_require__(/*! Stores/User/Account */ 28),
	IdentityStore = __webpack_require__(/*! Stores/User/Identity */ 56),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function AccountsUserSettings()
{
	this.allowAdditionalAccount = Settings.capa(Enums.Capa.AdditionalAccounts);
	this.allowIdentities = Settings.capa(Enums.Capa.Identities);

	this.accounts = AccountStore.accounts;
	this.identities = IdentityStore.identities;

	this.accountForDeletion = ko.observable(null).deleteAccessHelper();
	this.identityForDeletion = ko.observable(null).deleteAccessHelper();
}

AccountsUserSettings.prototype.scrollableOptions = function(sWrapper)
{
	return {
		handle: '.drag-handle',
		containment: sWrapper || 'parent',
		axis: 'y'
	};
};

AccountsUserSettings.prototype.addNewAccount = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Account */ 63));
};

AccountsUserSettings.prototype.editAccount = function(oAccountItem)
{
	if (oAccountItem && oAccountItem.canBeEdit())
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Account */ 63), [oAccountItem]);
	}
};

AccountsUserSettings.prototype.addNewIdentity = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Identity */ 65));
};

AccountsUserSettings.prototype.editIdentity = function(oIdentity)
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Identity */ 65), [oIdentity]);
};

/**
 * @param {AccountModel} oAccountToRemove
 */
AccountsUserSettings.prototype.deleteAccount = function(oAccountToRemove)
{
	if (oAccountToRemove && oAccountToRemove.deleteAccess())
	{
		this.accountForDeletion(null);

		var
			kn = __webpack_require__(/*! Knoin/Knoin */ 4),
			fRemoveAccount = function(oAccount) {
				return oAccountToRemove === oAccount;
			};

		if (oAccountToRemove)
		{
			this.accounts.remove(fRemoveAccount);

			Remote.accountDelete(function(sResult, oData) {

				if (Enums.StorageResultType.Success === sResult && oData &&
					oData.Result && oData.Reload)
				{
					kn.routeOff();
					kn.setHash(Links.root(), true);
					kn.routeOff();

					_.defer(function() {
						window.location.reload();
					});
				}
				else
				{
					__webpack_require__(/*! App/User */ 8).default.accountsAndIdentities();
				}

			}, oAccountToRemove.email);
		}
	}
};

/**
 * @param {IdentityModel} oIdentityToRemove
 */
AccountsUserSettings.prototype.deleteIdentity = function(oIdentityToRemove)
{
	if (oIdentityToRemove && oIdentityToRemove.deleteAccess())
	{
		this.identityForDeletion(null);

		if (oIdentityToRemove)
		{
			IdentityStore.identities.remove(function(oIdentity) {
				return oIdentityToRemove === oIdentity;
			});

			Remote.identityDelete(function() {
				__webpack_require__(/*! App/User */ 8).default.accountsAndIdentities();
			}, oIdentityToRemove.id);
		}
	}
};

AccountsUserSettings.prototype.accountsAndIdentitiesAfterMove = function()
{
	Remote.accountsAndIdentitiesSortOrder(null,
		AccountStore.accountsEmails.peek(), IdentityStore.identitiesIDS.peek());
};

AccountsUserSettings.prototype.onBuild = function(oDom)
{
	var self = this;

	oDom
		.on('click', '.accounts-list .account-item .e-action', function() {
			var oAccountItem = ko.dataFor(this);
			if (oAccountItem)
			{
				self.editAccount(oAccountItem);
			}
		})
		.on('click', '.identities-list .identity-item .e-action', function() {
			var oIdentityItem = ko.dataFor(this);
			if (oIdentityItem)
			{
				self.editIdentity(oIdentityItem);
			}
		});
};

module.exports = AccountsUserSettings;


/***/ },
/* 127 */
/*!*********************************************!*\
  !*** ./dev/Settings/User/ChangePassword.js ***!
  \*********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function ChangePasswordUserSettings()
{
	this.changeProcess = ko.observable(false);

	this.errorDescription = ko.observable('');
	this.passwordMismatch = ko.observable(false);
	this.passwordUpdateError = ko.observable(false);
	this.passwordUpdateSuccess = ko.observable(false);

	this.currentPassword = ko.observable('');
	this.currentPassword.error = ko.observable(false);
	this.newPassword = ko.observable('');
	this.newPassword2 = ko.observable('');

	this.currentPassword.subscribe(function() {
		this.passwordUpdateError(false);
		this.passwordUpdateSuccess(false);
		this.currentPassword.error(false);
	}, this);

	this.newPassword.subscribe(function() {
		this.passwordUpdateError(false);
		this.passwordUpdateSuccess(false);
		this.passwordMismatch(false);
	}, this);

	this.newPassword2.subscribe(function() {
		this.passwordUpdateError(false);
		this.passwordUpdateSuccess(false);
		this.passwordMismatch(false);
	}, this);

	this.saveNewPasswordCommand = Utils.createCommand(this, function() {

		if (this.newPassword() !== this.newPassword2())
		{
			this.passwordMismatch(true);
			this.errorDescription(Translator.i18n('SETTINGS_CHANGE_PASSWORD/ERROR_PASSWORD_MISMATCH'));
		}
		else
		{
			this.changeProcess(true);

			this.passwordUpdateError(false);
			this.passwordUpdateSuccess(false);
			this.currentPassword.error(false);
			this.passwordMismatch(false);
			this.errorDescription('');

			Remote.changePassword(this.onChangePasswordResponse, this.currentPassword(), this.newPassword());
		}

	}, function() {
		return !this.changeProcess() && '' !== this.currentPassword() &&
			'' !== this.newPassword() && '' !== this.newPassword2();
	});

	this.onChangePasswordResponse = _.bind(this.onChangePasswordResponse, this);
}

ChangePasswordUserSettings.prototype.onHide = function()
{
	this.changeProcess(false);
	this.currentPassword('');
	this.newPassword('');
	this.newPassword2('');
	this.errorDescription('');
	this.passwordMismatch(false);
	this.currentPassword.error(false);
};

ChangePasswordUserSettings.prototype.onChangePasswordResponse = function(sResult, oData)
{
	this.changeProcess(false);
	this.passwordMismatch(false);
	this.errorDescription('');
	this.currentPassword.error(false);

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.currentPassword('');
		this.newPassword('');
		this.newPassword2('');

		this.passwordUpdateSuccess(true);
		this.currentPassword.error(false);

		__webpack_require__(/*! App/User */ 8).default.setClientSideToken(oData.Result);
	}
	else
	{
		if (oData && Enums.Notification.CurrentPasswordIncorrect === oData.ErrorCode)
		{
			this.currentPassword.error(true);
		}

		this.passwordUpdateError(true);
		this.errorDescription(
			Translator.getNotificationFromResponse(oData, Enums.Notification.CouldNotSaveNewPassword));
	}
};

module.exports = ChangePasswordUserSettings;


/***/ },
/* 128 */
/*!***************************************!*\
  !*** ./dev/Settings/User/Contacts.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	ContactStore = __webpack_require__(/*! Stores/User/Contact */ 53),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function ContactsUserSettings()
{
	this.contactsAutosave = AppStore.contactsAutosave;

	this.allowContactsSync = ContactStore.allowContactsSync;
	this.enableContactsSync = ContactStore.enableContactsSync;
	this.contactsSyncUrl = ContactStore.contactsSyncUrl;
	this.contactsSyncUser = ContactStore.contactsSyncUser;
	this.contactsSyncPass = ContactStore.contactsSyncPass;

	this.saveTrigger = ko.computed(function() {
		return [
			this.enableContactsSync() ? '1' : '0',
			this.contactsSyncUrl(),
			this.contactsSyncUser(),
			this.contactsSyncPass()
		].join('|');
	}, this).extend({'throttle': 500});
}

ContactsUserSettings.prototype.onBuild = function()
{
	this.contactsAutosave.subscribe(function(bValue) {
		Remote.saveSettings(null, {
			'ContactsAutosave': bValue ? '1' : '0'
		});
	});

	this.saveTrigger.subscribe(function() {
		Remote.saveContactsSyncData(null,
			this.enableContactsSync(),
			this.contactsSyncUrl(),
			this.contactsSyncUser(),
			this.contactsSyncPass()
		);
	}, this);
};

module.exports = ContactsUserSettings;


/***/ },
/* 129 */
/*!**************************************!*\
  !*** ./dev/Settings/User/Filters.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),
	_ = __webpack_require__(/*! _ */ 2),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	FilterStore = __webpack_require__(/*! Stores/User/Filter */ 91),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function FiltersUserSettings()
{
	var self = this;

	this.modules = FilterStore.modules;
	this.filters = FilterStore.filters;

	this.inited = ko.observable(false);
	this.serverError = ko.observable(false);
	this.serverErrorDesc = ko.observable('');
	this.haveChanges = ko.observable(false);

	this.saveErrorText = ko.observable('');

	this.filters.subscribe(Utils.windowResizeCallback);

	this.serverError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.serverErrorDesc('');
		}
	}, this);

	this.filterRaw = FilterStore.raw;
	this.filterRaw.capa = FilterStore.capa;
	this.filterRaw.active = ko.observable(false);
	this.filterRaw.allow = ko.observable(false);
	this.filterRaw.error = ko.observable(false);

	this.filterForDeletion = ko.observable(null).extend({'falseTimeout': 3000}).extend(
		{'toggleSubscribeProperty': [this, 'deleteAccess']});

	this.saveChanges = Utils.createCommand(this, function() {

		if (!this.filters.saving())
		{
			if (this.filterRaw.active() && '' === Utils.trim(this.filterRaw()))
			{
				this.filterRaw.error(true);
				return false;
			}

			this.filters.saving(true);
			this.saveErrorText('');

			Remote.filtersSave(function(sResult, oData) {

				self.filters.saving(false);

				if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
				{
					self.haveChanges(false);
					self.updateList();
				}
				else if (oData && oData.ErrorCode)
				{
					self.saveErrorText(oData.ErrorMessageAdditional || Translator.getNotification(oData.ErrorCode));
				}
				else
				{
					self.saveErrorText(Translator.getNotification(Enums.Notification.CantSaveFilters));
				}

			}, this.filters(), this.filterRaw(), this.filterRaw.active());
		}

		return true;

	}, function() {
		return this.haveChanges();
	});

	this.filters.subscribe(function() {
		this.haveChanges(true);
	}, this);

	this.filterRaw.subscribe(function() {
		this.haveChanges(true);
		this.filterRaw.error(false);
	}, this);

	this.haveChanges.subscribe(function() {
		this.saveErrorText('');
	}, this);

	this.filterRaw.active.subscribe(function() {
		this.haveChanges(true);
		this.filterRaw.error(false);
	}, this);
}

FiltersUserSettings.prototype.scrollableOptions = function(sWrapper)
{
	return {
		handle: '.drag-handle',
		containment: sWrapper || 'parent',
		axis: 'y'
	};
};

FiltersUserSettings.prototype.updateList = function()
{
	var
		self = this,
		FilterModel = __webpack_require__(/*! Model/Filter */ 105).default;

	if (!this.filters.loading())
	{
		this.filters.loading(true);

		Remote.filtersGet(function(sResult, oData) {

			self.filters.loading(false);
			self.serverError(false);

			if (Enums.StorageResultType.Success === sResult && oData &&
				oData.Result && Utils.isArray(oData.Result.Filters))
			{
				self.inited(true);
				self.serverError(false);

				var aResult = _.compact(_.map(oData.Result.Filters, function(aItem) {
					var oNew = new FilterModel();
					return (oNew && oNew.parse(aItem)) ? oNew : null;
				}));

				self.filters(aResult);

				self.modules(oData.Result.Modules ? oData.Result.Modules : {});

				self.filterRaw(oData.Result.Raw || '');
				self.filterRaw.capa(Utils.isArray(oData.Result.Capa) ? oData.Result.Capa.join(' ') : '');
				self.filterRaw.active(!!oData.Result.RawIsActive);
				self.filterRaw.allow(!!oData.Result.RawIsAllow);
			}
			else
			{
				self.filters([]);
				self.modules({});
				self.filterRaw('');
				self.filterRaw.capa({});

				self.serverError(true);
				self.serverErrorDesc(oData && oData.ErrorCode ? Translator.getNotification(oData.ErrorCode) :
					Translator.getNotification(Enums.Notification.CantGetFilters));
			}

			self.haveChanges(false);
		});
	}
};

FiltersUserSettings.prototype.deleteFilter = function(oFilter)
{
	this.filters.remove(oFilter);
	Utils.delegateRunOnDestroy(oFilter);
};

FiltersUserSettings.prototype.addFilter = function()
{
	var
		self = this,
		FilterModel = __webpack_require__(/*! Model/Filter */ 105).default,
		oNew = new FilterModel();

	oNew.generateID();
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(
		__webpack_require__(/*! View/Popup/Filter */ 96), [oNew, function() {
			self.filters.push(oNew);
			self.filterRaw.active(false);
		}, false]);
};

FiltersUserSettings.prototype.editFilter = function(oEdit)
{
	var
		self = this,
		oCloned = oEdit.cloneSelf();

	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(
		__webpack_require__(/*! View/Popup/Filter */ 96), [oCloned, function() {

			var
				aFilters = self.filters(),
				iIndex = aFilters.indexOf(oEdit);

			if (-1 < iIndex && aFilters[iIndex])
			{
				Utils.delegateRunOnDestroy(aFilters[iIndex]);
				aFilters[iIndex] = oCloned;

				self.filters(aFilters);
				self.haveChanges(true);
			}

		}, true]);
};

FiltersUserSettings.prototype.onBuild = function(oDom)
{
	var self = this;

	oDom
		.on('click', '.filter-item .e-action', function() {
			var oFilterItem = ko.dataFor(this);
			if (oFilterItem)
			{
				self.editFilter(oFilterItem);
			}
		});
};

FiltersUserSettings.prototype.onShow = function()
{
	this.updateList();
};

module.exports = FiltersUserSettings;


/***/ },
/* 130 */
/*!**************************************!*\
  !*** ./dev/Settings/User/Folders.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Local = __webpack_require__(/*! Storage/Client */ 47),

	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),

	Promises = __webpack_require__(/*! Promises/User/Ajax */ 42),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function FoldersUserSettings()
{
	this.displaySpecSetting = FolderStore.displaySpecSetting;
	this.folderList = FolderStore.folderList;

	this.folderListHelp = ko.observable('').extend({'throttle': 100});

	this.loading = ko.computed(function() {

		var
			bLoading = FolderStore.foldersLoading(),
			bCreating = FolderStore.foldersCreating(),
			bDeleting = FolderStore.foldersDeleting(),
			bRenaming = FolderStore.foldersRenaming();

		return bLoading || bCreating || bDeleting || bRenaming;

	}, this);

	this.folderForDeletion = ko.observable(null).deleteAccessHelper();

	this.folderForEdit = ko.observable(null).extend({'toggleSubscribe': [this,
		function(oPrev) {
			if (oPrev)
			{
				oPrev.edited(false);
			}
		}, function(oNext) {
			if (oNext && oNext.canBeEdited())
			{
				oNext.edited(true);
			}
		}
	]});

	this.useImapSubscribe = !!Settings.appSettingsGet('useImapSubscribe');
}

FoldersUserSettings.prototype.folderEditOnEnter = function(oFolder)
{
	var
		sEditName = oFolder ? Utils.trim(oFolder.nameForEdit()) : '';

	if ('' !== sEditName && oFolder.name() !== sEditName)
	{
		Local.set(Enums.ClientSideKeyName.FoldersLashHash, '');

		__webpack_require__(/*! App/User */ 8).default.foldersPromisesActionHelper(
			Promises.folderRename(oFolder.fullNameRaw, sEditName, FolderStore.foldersRenaming),
			Enums.Notification.CantRenameFolder
		);

		Cache.removeFolderFromCacheList(oFolder.fullNameRaw);

		oFolder.name(sEditName);
	}

	oFolder.edited(false);
};

FoldersUserSettings.prototype.folderEditOnEsc = function(oFolder)
{
	if (oFolder)
	{
		oFolder.edited(false);
	}
};

FoldersUserSettings.prototype.onShow = function()
{
	FolderStore.folderList.error('');
};

FoldersUserSettings.prototype.onBuild = function(oDom)
{
	var self = this;
	oDom
		.on('mouseover', '.delete-folder-parent', function() {
			self.folderListHelp(Translator.i18n('SETTINGS_FOLDERS/HELP_DELETE_FOLDER'));
		})
		.on('mouseover', '.subscribe-folder-parent', function() {
			self.folderListHelp(Translator.i18n('SETTINGS_FOLDERS/HELP_SHOW_HIDE_FOLDER'));
		})
		.on('mouseover', '.check-folder-parent', function() {
			self.folderListHelp(Translator.i18n('SETTINGS_FOLDERS/HELP_CHECK_FOR_NEW_MESSAGES'));
		})
		.on('mouseout', '.subscribe-folder-parent, .check-folder-parent, .delete-folder-parent', function() {
			self.folderListHelp('');
		});
};

FoldersUserSettings.prototype.createFolder = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/FolderCreate */ 97));
};

FoldersUserSettings.prototype.systemFolder = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/FolderSystem */ 54));
};

FoldersUserSettings.prototype.deleteFolder = function(oFolderToRemove)
{
	if (oFolderToRemove && oFolderToRemove.canBeDeleted() && oFolderToRemove.deleteAccess() &&
		0 === oFolderToRemove.privateMessageCountAll())
	{
		this.folderForDeletion(null);

		var
			fRemoveFolder = function(oFolder) {

				if (oFolderToRemove === oFolder)
				{
					return true;
				}

				oFolder.subFolders.remove(fRemoveFolder);
				return false;
			};

		if (oFolderToRemove)
		{
			Local.set(Enums.ClientSideKeyName.FoldersLashHash, '');

			FolderStore.folderList.remove(fRemoveFolder);

			__webpack_require__(/*! App/User */ 8).default.foldersPromisesActionHelper(
				Promises.folderDelete(oFolderToRemove.fullNameRaw, FolderStore.foldersDeleting),
				Enums.Notification.CantDeleteFolder
			);

			Cache.removeFolderFromCacheList(oFolderToRemove.fullNameRaw);
		}
	}
	else if (0 < oFolderToRemove.privateMessageCountAll())
	{
		FolderStore.folderList.error(Translator.getNotification(Enums.Notification.CantDeleteNonEmptyFolder));
	}
};

FoldersUserSettings.prototype.subscribeFolder = function(oFolder)
{
	Local.set(Enums.ClientSideKeyName.FoldersLashHash, '');
	Remote.folderSetSubscribe(Utils.noop, oFolder.fullNameRaw, true);

	oFolder.subScribed(true);
};

FoldersUserSettings.prototype.unSubscribeFolder = function(oFolder)
{
	Local.set(Enums.ClientSideKeyName.FoldersLashHash, '');
	Remote.folderSetSubscribe(Utils.noop, oFolder.fullNameRaw, false);

	oFolder.subScribed(false);
};

FoldersUserSettings.prototype.checkableTrueFolder = function(oFolder)
{
	Remote.folderSetCheckable(Utils.noop, oFolder.fullNameRaw, true);

	oFolder.checkable(true);
};

FoldersUserSettings.prototype.checkableFalseFolder = function(oFolder)
{
	Remote.folderSetCheckable(Utils.noop, oFolder.fullNameRaw, false);

	oFolder.checkable(false);
};

module.exports = FoldersUserSettings;


/***/ },
/* 131 */
/*!**************************************!*\
  !*** ./dev/Settings/User/General.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	LanguageStore = __webpack_require__(/*! Stores/Language */ 38),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	IdentityStore = __webpack_require__(/*! Stores/User/Identity */ 56),
	NotificationStore = __webpack_require__(/*! Stores/User/Notification */ 62),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function GeneralUserSettings()
{
	this.language = LanguageStore.language;
	this.languages = LanguageStore.languages;
	this.messagesPerPage = SettingsStore.messagesPerPage;
	this.messagesPerPageArray = Consts.MESSAGES_PER_PAGE_VALUES;

	this.editorDefaultType = SettingsStore.editorDefaultType;
	this.layout = SettingsStore.layout;
	this.usePreviewPane = SettingsStore.usePreviewPane;

	this.soundNotificationIsSupported = NotificationStore.soundNotificationIsSupported;
	this.enableSoundNotification = NotificationStore.enableSoundNotification;

	this.enableDesktopNotification = NotificationStore.enableDesktopNotification;
	this.isDesktopNotificationSupported = NotificationStore.isDesktopNotificationSupported;
	this.isDesktopNotificationDenied = NotificationStore.isDesktopNotificationDenied;

	this.showImages = SettingsStore.showImages;
	this.useCheckboxesInList = SettingsStore.useCheckboxesInList;
	this.threadsAllowed = AppStore.threadsAllowed;
	this.useThreads = SettingsStore.useThreads;
	this.replySameFolder = SettingsStore.replySameFolder;
	this.allowLanguagesOnSettings = AppStore.allowLanguagesOnSettings;

	this.languageFullName = ko.computed(function() {
		return Utils.convertLangName(this.language());
	}, this);

	this.languageTrigger = ko.observable(Enums.SaveSettingsStep.Idle).extend({'throttle': Enums.Magics.Time100ms});

	this.mppTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.editorDefaultTypeTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.layoutTrigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.isAnimationSupported = Globals.bAnimationSupported;

	this.identities = IdentityStore.identities;

	this.identityMain = ko.computed(function() {
		var aList = this.identities();
		return Utils.isArray(aList) ? _.find(aList, function(oItem) {
			return oItem && '' === oItem.id();
		}) : null;
	}, this);

	this.identityMainDesc = ko.computed(function() {
		var oIdentity = this.identityMain();
		return oIdentity ? oIdentity.formattedName() : '---';
	}, this);

	this.editorDefaultTypes = ko.computed(function() {
		Translator.trigger();
		return [
			{'id': Enums.EditorDefaultType.Html, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_EDITOR_HTML')},
			{'id': Enums.EditorDefaultType.Plain, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_EDITOR_PLAIN')},
			{'id': Enums.EditorDefaultType.HtmlForced, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_EDITOR_HTML_FORCED')},
			{'id': Enums.EditorDefaultType.PlainForced, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_EDITOR_PLAIN_FORCED')}
		];
	}, this);

	this.layoutTypes = ko.computed(function() {
		Translator.trigger();
		return [
			{'id': Enums.Layout.NoPreview, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_LAYOUT_NO_SPLIT')},
			{'id': Enums.Layout.SidePreview, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_LAYOUT_VERTICAL_SPLIT')},
			{'id': Enums.Layout.BottomPreview, 'name': Translator.i18n('SETTINGS_GENERAL/LABEL_LAYOUT_HORIZONTAL_SPLIT')}
		];
	}, this);
}

GeneralUserSettings.prototype.editMainIdentity = function()
{
	var oIdentity = this.identityMain();
	if (oIdentity)
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Identity */ 65), [oIdentity]);
	}
};

GeneralUserSettings.prototype.testSoundNotification = function()
{
	NotificationStore.playSoundNotification(true);
};

GeneralUserSettings.prototype.onBuild = function()
{
	var self = this;

	_.delay(function() {

		var
			f0 = Utils.settingsSaveHelperSimpleFunction(self.editorDefaultTypeTrigger, self),
			f1 = Utils.settingsSaveHelperSimpleFunction(self.mppTrigger, self),
			f2 = Utils.settingsSaveHelperSimpleFunction(self.layoutTrigger, self),
			fReloadLanguageHelper = function(iSaveSettingsStep) {
				return function() {
					self.languageTrigger(iSaveSettingsStep);
					_.delay(function() {
						self.languageTrigger(Enums.SaveSettingsStep.Idle);
					}, Enums.Magics.Time1s);
				};
			};

		self.language.subscribe(function(sValue) {

			self.languageTrigger(Enums.SaveSettingsStep.Animate);

			Translator.reload(false, sValue).then(
				fReloadLanguageHelper(Enums.SaveSettingsStep.TrueResult),
				fReloadLanguageHelper(Enums.SaveSettingsStep.FalseResult)
			).then(function() {
				Remote.saveSettings(null, {
					'Language': sValue
				});
			});

		});

		self.editorDefaultType.subscribe(function(sValue) {
			Remote.saveSettings(f0, {
				'EditorDefaultType': sValue
			});
		});

		self.messagesPerPage.subscribe(function(iValue) {
			Remote.saveSettings(f1, {
				'MPP': iValue
			});
		});

		self.showImages.subscribe(function(bValue) {
			Remote.saveSettings(null, {
				'ShowImages': bValue ? '1' : '0'
			});
		});

		self.enableDesktopNotification.subscribe(function(bValue) {
			Utils.timeOutAction('SaveDesktopNotifications', function() {
				Remote.saveSettings(null, {
					'DesktopNotifications': bValue ? '1' : '0'
				});
			}, Enums.Magics.Time3s);
		});

		self.enableSoundNotification.subscribe(function(bValue) {
			Utils.timeOutAction('SaveSoundNotification', function() {
				Remote.saveSettings(null, {
					'SoundNotification': bValue ? '1' : '0'
				});
			}, Enums.Magics.Time3s);
		});

		self.replySameFolder.subscribe(function(bValue) {
			Utils.timeOutAction('SaveReplySameFolder', function() {
				Remote.saveSettings(null, {
					'ReplySameFolder': bValue ? '1' : '0'
				});
			}, Enums.Magics.Time3s);
		});

		self.useThreads.subscribe(function(bValue) {

			MessageStore.messageList([]);

			Remote.saveSettings(null, {
				'UseThreads': bValue ? '1' : '0'
			});
		});

		self.layout.subscribe(function(nValue) {

			MessageStore.messageList([]);

			Remote.saveSettings(f2, {
				'Layout': nValue
			});
		});

		self.useCheckboxesInList.subscribe(function(bValue) {
			Remote.saveSettings(null, {
				'UseCheckboxesInList': bValue ? '1' : '0'
			});
		});

	}, Enums.Magics.Time50ms);
};

GeneralUserSettings.prototype.onShow = function()
{
	this.enableDesktopNotification.valueHasMutated();
};

GeneralUserSettings.prototype.selectLanguage = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Languages */ 44), [
		this.language, this.languages(), LanguageStore.userLanguage()
	]);
};

module.exports = GeneralUserSettings;


/***/ },
/* 132 */
/*!**************************************!*\
  !*** ./dev/Settings/User/OpenPgp.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	window = __webpack_require__(/*! window */ 9),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),

	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31);

/**
 * @constructor
 */
function OpenPgpUserSettings()
{
	this.openpgpkeys = PgpStore.openpgpkeys;
	this.openpgpkeysPublic = PgpStore.openpgpkeysPublic;
	this.openpgpkeysPrivate = PgpStore.openpgpkeysPrivate;

	this.openPgpKeyForDeletion = ko.observable(null).deleteAccessHelper();

	this.isHttps = window.document && window.document.location ? 'https:' === window.document.location.protocol : false;
}

OpenPgpUserSettings.prototype.addOpenPgpKey = function()
{
	kn.showScreenPopup(__webpack_require__(/*! View/Popup/AddOpenPgpKey */ 140));
};

OpenPgpUserSettings.prototype.generateOpenPgpKey = function()
{
	kn.showScreenPopup(__webpack_require__(/*! View/Popup/NewOpenPgpKey */ 146));
};

OpenPgpUserSettings.prototype.viewOpenPgpKey = function(oOpenPgpKey)
{
	if (oOpenPgpKey)
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/ViewOpenPgpKey */ 149), [oOpenPgpKey]);
	}
};

/**
 * @param {OpenPgpKeyModel} oOpenPgpKeyToRemove
 */
OpenPgpUserSettings.prototype.deleteOpenPgpKey = function(oOpenPgpKeyToRemove)
{
	if (oOpenPgpKeyToRemove && oOpenPgpKeyToRemove.deleteAccess())
	{
		this.openPgpKeyForDeletion(null);

		if (oOpenPgpKeyToRemove && PgpStore.openpgpKeyring)
		{
			var oFindedItem = _.find(PgpStore.openpgpkeys(), function(oOpenPgpKey) {
				return oOpenPgpKeyToRemove === oOpenPgpKey;
			});

			if (oFindedItem)
			{
				PgpStore.openpgpkeys.remove(oFindedItem);
				Utils.delegateRunOnDestroy(oFindedItem);

				PgpStore.openpgpKeyring[oFindedItem.isPrivate ? 'privateKeys' : 'publicKeys']
					.removeForId(oFindedItem.guid);

				PgpStore.openpgpKeyring.store();
			}

			__webpack_require__(/*! App/User */ 8).default.reloadOpenPgpKeys();
		}
	}
};

module.exports = OpenPgpUserSettings;


/***/ },
/* 133 */
/*!***************************************!*\
  !*** ./dev/Settings/User/Security.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	SettinsStore = __webpack_require__(/*! Stores/User/Settings */ 24),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function SecurityUserSettings()
{
	this.capaAutoLogout = Settings.capa(Enums.Capa.AutoLogout);
	this.capaTwoFactor = Settings.capa(Enums.Capa.TwoFactor);

	this.autoLogout = SettinsStore.autoLogout;
	this.autoLogout.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.autoLogoutOptions = ko.computed(function() {
		Translator.trigger();
		return [
			{'id': 0, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_NEVER_OPTION_NAME')},
			{'id': 5, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_MINUTES_OPTION_NAME', {'MINUTES': 5})},
			{'id': 10, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_MINUTES_OPTION_NAME', {'MINUTES': 10})},
			{'id': 30, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_MINUTES_OPTION_NAME', {'MINUTES': 30})},
			{'id': 60, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_MINUTES_OPTION_NAME', {'MINUTES': 60})},
			{'id': 60 * 2, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_HOURS_OPTION_NAME', {'HOURS': 2})},
			{'id': 60 * 5, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_HOURS_OPTION_NAME', {'HOURS': 5})},
			{'id': 60 * 10, 'name': Translator.i18n('SETTINGS_SECURITY/AUTOLOGIN_HOURS_OPTION_NAME', {'HOURS': 10})}
		];
	});
}

SecurityUserSettings.prototype.configureTwoFactor = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/TwoFactorConfiguration */ 100));
};

SecurityUserSettings.prototype.onBuild = function()
{
	if (this.capaAutoLogout)
	{
		var self = this;

		_.delay(function() {

			var
				f0 = Utils.settingsSaveHelperSimpleFunction(self.autoLogout.trigger, self);

			self.autoLogout.subscribe(function(sValue) {
				Remote.saveSettings(f0, {
					'AutoLogout': Utils.pInt(sValue)
				});
			});

		});
	}
};

module.exports = SecurityUserSettings;


/***/ },
/* 134 */
/*!*************************************!*\
  !*** ./dev/Settings/User/Social.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


/**
 * @constructor
 */
function SocialUserSettings()
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		SocialStore = __webpack_require__(/*! Stores/Social */ 34);

	this.googleEnable = SocialStore.google.enabled;
	this.googleEnableAuth = SocialStore.google.capa.auth;
	this.googleEnableAuthFast = SocialStore.google.capa.authFast;
	this.googleEnableDrive = SocialStore.google.capa.drive;
	this.googleEnablePreview = SocialStore.google.capa.preview;

	this.googleActions = SocialStore.google.loading;
	this.googleLoggined = SocialStore.google.loggined;
	this.googleUserName = SocialStore.google.userName;

	this.facebookEnable = SocialStore.facebook.enabled;

	this.facebookActions = SocialStore.facebook.loading;
	this.facebookLoggined = SocialStore.facebook.loggined;
	this.facebookUserName = SocialStore.facebook.userName;

	this.twitterEnable = SocialStore.twitter.enabled;

	this.twitterActions = SocialStore.twitter.loading;
	this.twitterLoggined = SocialStore.twitter.loggined;
	this.twitterUserName = SocialStore.twitter.userName;

	this.connectGoogle = Utils.createCommand(this, function() {
		if (!this.googleLoggined())
		{
			__webpack_require__(/*! App/User */ 8).default.googleConnect();
		}
	}, function() {
		return !this.googleLoggined() && !this.googleActions();
	});

	this.disconnectGoogle = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.googleDisconnect();
	});

	this.connectFacebook = Utils.createCommand(this, function() {
		if (!this.facebookLoggined())
		{
			__webpack_require__(/*! App/User */ 8).default.facebookConnect();
		}
	}, function() {
		return !this.facebookLoggined() && !this.facebookActions();
	});

	this.disconnectFacebook = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.facebookDisconnect();
	});

	this.connectTwitter = Utils.createCommand(this, function() {
		if (!this.twitterLoggined())
		{
			__webpack_require__(/*! App/User */ 8).default.twitterConnect();
		}
	}, function() {
		return !this.twitterLoggined() && !this.twitterActions();
	});

	this.disconnectTwitter = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.twitterDisconnect();
	});
}

module.exports = SocialUserSettings;


/***/ },
/* 135 */
/*!****************************************!*\
  !*** ./dev/Settings/User/Templates.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	TemplateStore = __webpack_require__(/*! Stores/User/Template */ 93),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function TemplatesUserSettings()
{
	this.templates = TemplateStore.templates;

	this.processText = ko.computed(function() {
		return TemplateStore.templates.loading() ? Translator.i18n('SETTINGS_TEMPLETS/LOADING_PROCESS') : '';
	}, this);

	this.visibility = ko.computed(function() {
		return '' === this.processText() ? 'hidden' : 'visible';
	}, this);

	this.templateForDeletion = ko.observable(null).deleteAccessHelper();
}

TemplatesUserSettings.prototype.scrollableOptions = function(sWrapper)
{
	return {
		handle: '.drag-handle',
		containment: sWrapper || 'parent',
		axis: 'y'
	};
};

TemplatesUserSettings.prototype.addNewTemplate = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Template */ 99));
};

TemplatesUserSettings.prototype.editTemplate = function(oTemplateItem)
{
	if (oTemplateItem)
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Template */ 99), [oTemplateItem]);
	}
};

/**
 * @param {AccountModel} oTemplateToRemove
 */
TemplatesUserSettings.prototype.deleteTemplate = function(oTemplateToRemove)
{
	if (oTemplateToRemove && oTemplateToRemove.deleteAccess())
	{
		this.templateForDeletion(null);

		var
			self = this,
			fRemoveAccount = function(oAccount) {
				return oTemplateToRemove === oAccount;
			};

		if (oTemplateToRemove)
		{
			this.templates.remove(fRemoveAccount);

			Remote.templateDelete(function() {
				self.reloadTemplates();
			}, oTemplateToRemove.id);
		}
	}
};

TemplatesUserSettings.prototype.reloadTemplates = function()
{
	__webpack_require__(/*! App/User */ 8).default.templates();
};

TemplatesUserSettings.prototype.onBuild = function(oDom)
{
	var self = this;

	oDom
		.on('click', '.templates-list .template-item .e-action', function() {
			var oTemplateItem = ko.dataFor(this);
			if (oTemplateItem)
			{
				self.editTemplate(oTemplateItem);
			}
		});

	this.reloadTemplates();
};

module.exports = TemplatesUserSettings;


/***/ },
/* 136 */
/*!*************************************!*\
  !*** ./dev/Settings/User/Themes.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),

	Jua = __webpack_require__(/*! Jua */ 86),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	ThemeStore = __webpack_require__(/*! Stores/Theme */ 43),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14);

/**
 * @constructor
 */
function ThemesUserSettings()
{
	this.theme = ThemeStore.theme;
	this.themes = ThemeStore.themes;
	this.themesObjects = ko.observableArray([]);

	this.background = {};
	this.background.name = ThemeStore.themeBackgroundName;
	this.background.hash = ThemeStore.themeBackgroundHash;
	this.background.uploaderButton = ko.observable(null);
	this.background.loading = ko.observable(false);
	this.background.error = ko.observable('');

	this.capaUserBackground = ko.observable(Settings.capa(Enums.Capa.UserBackground));

	this.themeTrigger = ko.observable(Enums.SaveSettingsStep.Idle).extend({'throttle': 100});

	this.iTimer = 0;
	this.oThemeAjaxRequest = null;

	this.theme.subscribe(function(sValue) {

		_.each(this.themesObjects(), function(oTheme) {
			oTheme.selected(sValue === oTheme.name);
		});

		Utils.changeTheme(sValue, this.themeTrigger);

		Remote.saveSettings(null, {
			'Theme': sValue
		});

	}, this);

	this.background.hash.subscribe(function(sValue) {

		var $oBg = $('#rl-bg');
		if (!sValue)
		{
			if ($oBg.data('backstretch'))
			{
				$oBg.backstretch('destroy').attr('style', '');
			}
		}
		else
		{
			$('#rl-bg').attr('style', 'background-image: none !important;').backstretch(
				Links.userBackground(sValue), {
					'fade': 1000, 'centeredX': true, 'centeredY': true
				}).removeAttr('style');
		}

	}, this);
}

ThemesUserSettings.prototype.onBuild = function()
{
	var sCurrentTheme = this.theme();
	this.themesObjects(_.map(this.themes(), function(sTheme) {
		return {
			'name': sTheme,
			'nameDisplay': Utils.convertThemeName(sTheme),
			'selected': ko.observable(sTheme === sCurrentTheme),
			'themePreviewSrc': Links.themePreviewLink(sTheme)
		};
	}));

	this.initUploader();
};

ThemesUserSettings.prototype.onShow = function()
{
	this.background.error('');
};

ThemesUserSettings.prototype.clearBackground = function()
{
	if (this.capaUserBackground())
	{
		var self = this;
		Remote.clearUserBackground(function() {
			self.background.name('');
			self.background.hash('');
		});
	}
};

ThemesUserSettings.prototype.initUploader = function()
{
	if (this.background.uploaderButton() && this.capaUserBackground())
	{
		var
			oJua = new Jua({
				'action': Links.uploadBackground(),
				'name': 'uploader',
				'queueSize': 1,
				'multipleSizeLimit': 1,
				'disableDragAndDrop': true,
				'disableMultiple': true,
				'clickElement': this.background.uploaderButton()
			});

		oJua
			.on('onStart', _.bind(function() {

				this.background.loading(true);
				this.background.error('');

				return true;

			}, this))
			.on('onComplete', _.bind(function(sId, bResult, oData) {

				this.background.loading(false);

				if (bResult && sId && oData && oData.Result && oData.Result.Name && oData.Result.Hash)
				{
					this.background.name(oData.Result.Name);
					this.background.hash(oData.Result.Hash);
				}
				else
				{
					this.background.name('');
					this.background.hash('');

					var sError = '';
					if (oData.ErrorCode)
					{
						switch (oData.ErrorCode)
						{
							case Enums.UploadErrorCode.FileIsTooBig:
								sError = Translator.i18n('SETTINGS_THEMES/ERROR_FILE_IS_TOO_BIG');
								break;
							case Enums.UploadErrorCode.FileType:
								sError = Translator.i18n('SETTINGS_THEMES/ERROR_FILE_TYPE_ERROR');
								break;
							// no default
						}
					}

					if (!sError && oData.ErrorMessage)
					{
						sError = oData.ErrorMessage;
					}

					this.background.error(sError || Translator.i18n('SETTINGS_THEMES/ERROR_UNKNOWN'));
				}

				return true;

			}, this));
	}
};

module.exports = ThemesUserSettings;


/***/ },
/* 137 */,
/* 138 */,
/* 139 */,
/* 140 */
/*!*****************************************!*\
  !*** ./dev/View/Popup/AddOpenPgpKey.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AddOpenPgpKeyPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsAddOpenPgpKey');

	this.key = ko.observable('');
	this.key.error = ko.observable(false);
	this.key.focus = ko.observable(false);

	this.key.subscribe(function() {
		this.key.error(false);
	}, this);

	this.addOpenPgpKeyCommand = Utils.createCommand(this, function() {

		var
			count = 30,
			match = null,
			key = Utils.trim(this.key()),
			reg = /[\-]{3,6}BEGIN[\s]PGP[\s](PRIVATE|PUBLIC)[\s]KEY[\s]BLOCK[\-]{3,6}[\s\S]+?[\-]{3,6}END[\s]PGP[\s](PRIVATE|PUBLIC)[\s]KEY[\s]BLOCK[\-]{3,6}/gi,
			openpgpKeyring = PgpStore.openpgpKeyring,
			done = false;

		if (/[\n]/.test(key))
		{
			key = key.replace(/[\r]+/g, '').replace(/[\n]{2,}/g, '\n\n');
		}

		this.key.error('' === key);

		if (!openpgpKeyring || this.key.error())
		{
			return false;
		}

		do
		{
			match = reg.exec(key);
			if (match && 0 > count)
			{
				if (match[0] && match[1] && match[2] && match[1] === match[2])
				{
					if ('PRIVATE' === match[1])
					{
						openpgpKeyring.privateKeys.importKey(match[0]);
					}
					else if ('PUBLIC' === match[1])
					{
						openpgpKeyring.publicKeys.importKey(match[0]);
					}
				}

				count -= 1;
			}

			done = true;

		}
		while (done);

		openpgpKeyring.store();

		__webpack_require__(/*! App/User */ 8).default.reloadOpenPgpKeys();
		Utils.delegateRun(this, 'cancelCommand');

		return true;
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/AddOpenPgpKey', 'PopupsAddOpenPgpKeyViewModel'], AddOpenPgpKeyPopupView);
_.extend(AddOpenPgpKeyPopupView.prototype, AbstractView.prototype);

AddOpenPgpKeyPopupView.prototype.clearPopup = function()
{
	this.key('');
	this.key.error(false);
};

AddOpenPgpKeyPopupView.prototype.onShow = function()
{
	this.clearPopup();
};

AddOpenPgpKeyPopupView.prototype.onShowWithDelay = function()
{
	this.key.focus(true);
};

module.exports = AddOpenPgpKeyPopupView;


/***/ },
/* 141 */
/*!******************************************!*\
  !*** ./dev/View/Popup/AdvancedSearch.js ***!
  \******************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AdvancedSearchPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsAdvancedSearch');

	this.fromFocus = ko.observable(false);

	this.from = ko.observable('');
	this.to = ko.observable('');
	this.subject = ko.observable('');
	this.text = ko.observable('');
	this.selectedDateValue = ko.observable(-1);

	this.hasAttachment = ko.observable(false);
	this.starred = ko.observable(false);
	this.unseen = ko.observable(false);

	this.searchCommand = Utils.createCommand(this, function() {

		var sSearch = this.buildSearchString();
		if ('' !== sSearch)
		{
			MessageStore.mainMessageListSearch(sSearch);
		}

		this.cancelCommand();
	});

	this.selectedDates = ko.computed(function() {
		Translator.trigger();
		return [
			{'id': -1, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_ALL')},
			{'id': 3, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_3_DAYS')},
			{'id': 7, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_7_DAYS')},
			{'id': 30, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_MONTH')},
			{'id': 90, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_3_MONTHS')},
			{'id': 180, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_6_MONTHS')},
			{'id': 365, 'name': Translator.i18n('SEARCH/LABEL_ADV_DATE_YEAR')}
		];
	}, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/AdvancedSearch', 'PopupsAdvancedSearchViewModel'], AdvancedSearchPopupView);
_.extend(AdvancedSearchPopupView.prototype, AbstractView.prototype);

AdvancedSearchPopupView.prototype.parseSearchStringValue = function(search)
{
	var
		self = this,
		parts = (search || '').split(/[\s]+/g);

	_.each(parts, function(part) {
		switch (part)
		{
			case 'has:attachment':
				self.hasAttachment(true);
				break;
			case 'is:unseen,flagged':
				self.starred(true);
				/* falls through */
			case 'is:unseen':
				self.unseen(true);
				break;
			// no default
		}
	});
};

AdvancedSearchPopupView.prototype.buildSearchStringValue = function(sValue)
{
	if (-1 < sValue.indexOf(' '))
	{
		sValue = '"' + sValue + '"';
	}

	return sValue;
};

AdvancedSearchPopupView.prototype.buildSearchString = function()
{
	var
		aResult = [],
		sFrom = Utils.trim(this.from()),
		sTo = Utils.trim(this.to()),
		sSubject = Utils.trim(this.subject()),
		sText = Utils.trim(this.text()),
		aIs = [],
		aHas = [];

	if (sFrom && '' !== sFrom)
	{
		aResult.push('from:' + this.buildSearchStringValue(sFrom));
	}

	if (sTo && '' !== sTo)
	{
		aResult.push('to:' + this.buildSearchStringValue(sTo));
	}

	if (sSubject && '' !== sSubject)
	{
		aResult.push('subject:' + this.buildSearchStringValue(sSubject));
	}

	if (this.hasAttachment())
	{
		aHas.push('attachment');
	}

	if (this.unseen())
	{
		aIs.push('unseen');
	}

	if (this.starred())
	{
		aIs.push('flagged');
	}

	if (0 < aHas.length)
	{
		aResult.push('has:' + aHas.join(','));
	}

	if (0 < aIs.length)
	{
		aResult.push('is:' + aIs.join(','));
	}

	if (-1 < this.selectedDateValue())
	{
		aResult.push('date:' + __webpack_require__(/*! Common/Momentor */ 26).searchSubtractFormatDateHelper(this.selectedDateValue()) + '/');
	}

	if (sText && '' !== sText)
	{
		aResult.push('text:' + this.buildSearchStringValue(sText));
	}

	return Utils.trim(aResult.join(' '));
};

AdvancedSearchPopupView.prototype.clearPopup = function()
{
	this.from('');
	this.to('');
	this.subject('');
	this.text('');

	this.selectedDateValue(-1);
	this.hasAttachment(false);
	this.starred(false);
	this.unseen(false);

	this.fromFocus(true);
};

AdvancedSearchPopupView.prototype.onShow = function(search)
{
	this.clearPopup();
	this.parseSearchStringValue(search);
};

AdvancedSearchPopupView.prototype.onShowWithDelay = function()
{
	this.fromFocus(true);
};

module.exports = AdvancedSearchPopupView;


/***/ },
/* 142 */
/*!******************************************!*\
  !*** ./dev/View/Popup/ComposeOpenPgp.js ***!
  \******************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31),

	EmailModel = __webpack_require__(/*! Model/Email */ 30).default,

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function ComposeOpenPgpPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsComposeOpenPgp');

	var self = this;

	this.publicKeysOptionsCaption = Translator.i18n('PGP_NOTIFICATIONS/ADD_A_PUBLICK_KEY');
	this.privateKeysOptionsCaption = Translator.i18n('PGP_NOTIFICATIONS/SELECT_A_PRIVATE_KEY');

	this.notification = ko.observable('');

	this.sign = ko.observable(false);
	this.encrypt = ko.observable(false);

	this.password = ko.observable('');
	this.password.focus = ko.observable(false);
	this.buttonFocus = ko.observable(false);

	this.text = ko.observable('');
	this.selectedPrivateKey = ko.observable(null);
	this.selectedPublicKey = ko.observable(null);

	this.signKey = ko.observable(null);
	this.encryptKeys = ko.observableArray([]);

	this.encryptKeysView = ko.computed(function() {
		return _.compact(_.map(this.encryptKeys(), function(oKey) {
			return oKey ? oKey.key : null;
		}));
	}, this);

	this.privateKeysOptions = ko.computed(function() {
		return _.compact(_.flatten(_.map(PgpStore.openpgpkeysPrivate(), function(oKey, iIndex) {
			return self.signKey() && self.signKey().key.id === oKey.id ? null : _.map(oKey.users, function(sUser) {
				return {
					'id': oKey.guid,
					'name': '(' + oKey.id.substr(-8).toUpperCase() + ') ' + sUser,
					'key': oKey,
					'class': iIndex % 2 ? 'odd' : 'even'
				};
			});
		}), true));
	});

	this.publicKeysOptions = ko.computed(function() {
		return _.compact(_.flatten(_.map(PgpStore.openpgpkeysPublic(), function(oKey, iIndex) {
			return -1 < Utils.inArray(oKey, self.encryptKeysView()) ? null : _.map(oKey.users, function(sUser) {
				return {
					'id': oKey.guid,
					'name': '(' + oKey.id.substr(-8).toUpperCase() + ') ' + sUser,
					'key': oKey,
					'class': iIndex % 2 ? 'odd' : 'even'
				};
			});
		}), true));
	});

	this.submitRequest = ko.observable(false);

	this.resultCallback = null;

	// commands
	this.doCommand = Utils.createCommand(this, function() {

		var
			bResult = true,
			oPrivateKey = null,
			aPrivateKeys = [],
			aPublicKeys = [];

		this.submitRequest(true);

		if (bResult && this.sign())
		{
			if (!this.signKey())
			{
				this.notification(Translator.i18n('PGP_NOTIFICATIONS/NO_PRIVATE_KEY_FOUND'));
				bResult = false;
			}
			else if (!this.signKey().key)
			{
				this.notification(Translator.i18n('PGP_NOTIFICATIONS/NO_PRIVATE_KEY_FOUND_FOR', {
					'EMAIL': this.signKey().email
				}));

				bResult = false;
			}

			if (bResult)
			{
				aPrivateKeys = this.signKey().key.getNativeKeys();
				oPrivateKey = aPrivateKeys[0] || null;

				try
				{
					if (oPrivateKey)
					{
						oPrivateKey.decrypt(Utils.pString(this.password()));
					}
				}
				catch (e)
				{
					oPrivateKey = null;
				}

				if (!oPrivateKey)
				{
					this.notification(Translator.i18n('PGP_NOTIFICATIONS/NO_PRIVATE_KEY_FOUND'));
					bResult = false;
				}
			}
		}

		if (bResult && this.encrypt())
		{
			if (0 === this.encryptKeys().length)
			{
				this.notification(Translator.i18n('PGP_NOTIFICATIONS/NO_PUBLIC_KEYS_FOUND'));
				bResult = false;
			}
			else if (this.encryptKeys())
			{
				aPublicKeys = [];

				_.each(this.encryptKeys(), function(oKey) {
					if (oKey && oKey.key)
					{
						aPublicKeys = aPublicKeys.concat(_.compact(_.flatten(oKey.key.getNativeKeys())));
					}
					else if (oKey && oKey.email)
					{
						self.notification(Translator.i18n('PGP_NOTIFICATIONS/NO_PUBLIC_KEYS_FOUND_FOR', {
							'EMAIL': oKey.email
						}));

						bResult = false;
					}
				});

				if (bResult && (0 === aPublicKeys.length || this.encryptKeys().length !== aPublicKeys.length))
				{
					bResult = false;
				}
			}
		}

		if (bResult && self.resultCallback)
		{
			_.delay(function() {

				var oPromise = null;

				try
				{
					if (oPrivateKey && 0 === aPublicKeys.length)
					{
						oPromise = PgpStore.openpgp.sign({
							data: self.text(),
							privateKeys: [oPrivateKey]
						});
					}
					else if (oPrivateKey && 0 < aPublicKeys.length)
					{
						oPromise = PgpStore.openpgp.encrypt({
							data: self.text(),
							publicKeys: aPublicKeys,
							privateKeys: [oPrivateKey]
						});
					}
					else if (!oPrivateKey && 0 < aPublicKeys.length)
					{
						oPromise = PgpStore.openpgp.encrypt({
							data: self.text(),
							publicKeys: aPublicKeys
						});
					}
				}
				catch (e)
				{
					Utils.log(e);

					self.notification(Translator.i18n('PGP_NOTIFICATIONS/PGP_ERROR', {
						'ERROR': '' + e
					}));
				}

				if (oPromise)
				{
					try
					{
						oPromise.then(function(mData) {

							self.resultCallback(mData.data);
							self.cancelCommand();

						}).then(null, function(e) {
							self.notification(Translator.i18n('PGP_NOTIFICATIONS/PGP_ERROR', {
								'ERROR': '' + e
							}));
						});
					}
					catch (e)
					{
						self.notification(Translator.i18n('PGP_NOTIFICATIONS/PGP_ERROR', {
							'ERROR': '' + e
						}));
					}
				}

				self.submitRequest(false);

			}, Enums.Magics.Time20ms);
		}
		else
		{
			self.submitRequest(false);
		}

		return bResult;

	}, function() {
		return !this.submitRequest() &&	(this.sign() || this.encrypt());
	});

	this.selectCommand = Utils.createCommand(this, function() {

		var
			sKeyId = this.selectedPrivateKey(),
			oKey = null,
			oOption = sKeyId ? _.find(this.privateKeysOptions(), function(oItem) {
				return oItem && sKeyId === oItem.id;
			}) : null;

		if (oOption)
		{
			oKey = {
				'empty': !oOption.key,
				'selected': ko.observable(!!oOption.key),
				'users': oOption.key.users,
				'hash': oOption.key.id.substr(-8).toUpperCase(),
				'key': oOption.key
			};

			this.signKey(oKey);
		}
	});

	this.addCommand = Utils.createCommand(this, function() {

		var
			sKeyId = this.selectedPublicKey(),
			aKeys = this.encryptKeys(),
			oOption = sKeyId ? _.find(this.publicKeysOptions(), function(oItem) {
				return oItem && sKeyId === oItem.id;
			}) : null;

		if (oOption)
		{
			aKeys.push({
				'empty': !oOption.key,
				'selected': ko.observable(!!oOption.key),
				'removable': ko.observable(!this.sign() || !this.signKey() || this.signKey().key.id !== oOption.key.id),
				'users': oOption.key.users,
				'hash': oOption.key.id.substr(-8).toUpperCase(),
				'key': oOption.key
			});

			this.encryptKeys(aKeys);
		}
	});

	this.updateCommand = Utils.createCommand(this, function() {
		_.each(this.encryptKeys(), function(oKey) {
			oKey.removable(!self.sign() || !self.signKey() || self.signKey().key.id !== oKey.key.id);
		});
	});

	this.selectedPrivateKey.subscribe(function(sValue) {
		if (sValue)
		{
			this.selectCommand();
			this.updateCommand();
		}
	}, this);

	this.selectedPublicKey.subscribe(function(sValue) {
		if (sValue)
		{
			this.addCommand();
		}
	}, this);

	this.sDefaultKeyScope = Enums.KeyState.PopupComposeOpenPGP;

	this.defautOptionsAfterRender = Utils.defautOptionsAfterRender;

	this.addOptionClass = function(oDomOption, oItem) {

		self.defautOptionsAfterRender(oDomOption, oItem);

		if (oItem && !Utils.isUnd(oItem.class) && oDomOption)
		{
			$(oDomOption).addClass(oItem.class);
		}
	};

	this.deletePublickKey = _.bind(this.deletePublickKey, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/ComposeOpenPgp', 'PopupsComposeOpenPgpViewModel'], ComposeOpenPgpPopupView);
_.extend(ComposeOpenPgpPopupView.prototype, AbstractView.prototype);

ComposeOpenPgpPopupView.prototype.deletePublickKey = function(oKey)
{
	this.encryptKeys.remove(oKey);
};

ComposeOpenPgpPopupView.prototype.clearPopup = function()
{
	this.notification('');

	this.sign(false);
	this.encrypt(false);

	this.password('');
	this.password.focus(false);
	this.buttonFocus(false);

	this.signKey(null);
	this.encryptKeys([]);
	this.text('');

	this.resultCallback = null;
};

ComposeOpenPgpPopupView.prototype.onBuild = function()
{
	key('tab,shift+tab', Enums.KeyState.PopupComposeOpenPGP, _.bind(function() {

		switch (true)
		{
			case this.password.focus():
				this.buttonFocus(true);
				break;
			case this.buttonFocus():
				this.password.focus(true);
				break;
			// no default
		}

		return false;

	}, this));
};

ComposeOpenPgpPopupView.prototype.onHideWithDelay = function()
{
	this.clearPopup();
};

ComposeOpenPgpPopupView.prototype.onShowWithDelay = function()
{
	if (this.sign())
	{
		this.password.focus(true);
	}
	else
	{
		this.buttonFocus(true);
	}
};

ComposeOpenPgpPopupView.prototype.onShow = function(fCallback, sText, oIdentity, sTo, sCc, sBcc)
{
	this.clearPopup();

	var
		self = this,
		aRec = [],
		sEmail = '',
		aKeys = [],
		oEmail = new EmailModel();

	this.resultCallback = fCallback;

	if ('' !== sTo)
	{
		aRec.push(sTo);
	}

	if ('' !== sCc)
	{
		aRec.push(sCc);
	}

	if ('' !== sBcc)
	{
		aRec.push(sBcc);
	}

	aRec = aRec.join(', ').split(',');
	aRec = _.compact(_.map(aRec, function(sValue) {
		oEmail.clear();
		oEmail.mailsoParse(Utils.trim(sValue));
		return '' === oEmail.email ? false : oEmail.email;
	}));

	if (oIdentity && oIdentity.email())
	{
		sEmail = oIdentity.email();
		aRec.unshift(sEmail);
		aKeys = PgpStore.findAllPrivateKeysByEmailNotNative(sEmail);
		if (aKeys && aKeys[0])
		{
			this.signKey({
				'users': aKeys[0].users || [sEmail],
				'hash': aKeys[0].id.substr(-8).toUpperCase(),
				'key': aKeys[0]
			});
		}
	}

	if (this.signKey())
	{
		this.sign(true);
	}

	if (aRec && 0 < aRec.length)
	{
		this.encryptKeys(_.uniq(_.compact(_.flatten(_.map(aRec, function(sRecEmail) {
			var keys = PgpStore.findAllPublicKeysByEmailNotNative(sRecEmail);
			return keys ? _.map(keys, function(oKey) {
				return {
					'empty': !oKey,
					'selected': ko.observable(!!oKey),
					'removable': ko.observable(!self.sign() || !self.signKey() || self.signKey().key.id !== oKey.id),
					'users': oKey ? (oKey.users || [sRecEmail]) : [sRecEmail],
					'hash': oKey ? oKey.id.substr(-8).toUpperCase() : '',
					'key': oKey
				};
			}) : [];
		}), true)), function(oEncryptKey) {
			return oEncryptKey.hash;
		}));

		if (0 < this.encryptKeys().length)
		{
			this.encrypt(true);
		}
	}

	this.text(sText);
};

module.exports = ComposeOpenPgpPopupView;


/***/ },
/* 143 */,
/* 144 */
/*!***************************************!*\
  !*** ./dev/View/Popup/FolderClear.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function FolderClearPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsFolderClear');

	this.selectedFolder = ko.observable(null);
	this.clearingProcess = ko.observable(false);
	this.clearingError = ko.observable('');

	this.folderFullNameForClear = ko.computed(function() {
		var oFolder = this.selectedFolder();
		return oFolder ? oFolder.printableFullName() : '';
	}, this);

	this.folderNameForClear = ko.computed(function() {
		var oFolder = this.selectedFolder();
		return oFolder ? oFolder.localName() : '';
	}, this);

	this.dangerDescHtml = ko.computed(function() {
		return Translator.i18n('POPUPS_CLEAR_FOLDER/DANGER_DESC_HTML_1', {
			'FOLDER': this.folderNameForClear()
		});
	}, this);

	this.clearCommand = Utils.createCommand(this, function() {

		var
			self = this,
			oFolderToClear = this.selectedFolder();

		if (oFolderToClear)
		{
			MessageStore.message(null);
			MessageStore.messageList([]);

			this.clearingProcess(true);

			oFolderToClear.messageCountAll(0);
			oFolderToClear.messageCountUnread(0);

			Cache.setFolderHash(oFolderToClear.fullNameRaw, '');

			Remote.folderClear(function(sResult, oData) {

				self.clearingProcess(false);
				if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
				{
					__webpack_require__(/*! App/User */ 8).default.reloadMessageList(true);
					self.cancelCommand();
				}
				else
				{
					if (oData && oData.ErrorCode)
					{
						self.clearingError(Translator.getNotification(oData.ErrorCode));
					}
					else
					{
						self.clearingError(Translator.getNotification(Enums.Notification.MailServerError));
					}
				}
			}, oFolderToClear.fullNameRaw);
		}

	}, function() {

		var
			oFolder = this.selectedFolder(),
			bIsClearing = this.clearingProcess();

		return !bIsClearing && null !== oFolder;

	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/FolderClear', 'PopupsFolderClearViewModel'], FolderClearPopupView);
_.extend(FolderClearPopupView.prototype, AbstractView.prototype);

FolderClearPopupView.prototype.clearPopup = function()
{
	this.clearingProcess(false);
	this.selectedFolder(null);
};

FolderClearPopupView.prototype.onShow = function(oFolder)
{
	this.clearPopup();
	if (oFolder)
	{
		this.selectedFolder(oFolder);
	}
};

module.exports = FolderClearPopupView;


/***/ },
/* 145 */
/*!******************************************!*\
  !*** ./dev/View/Popup/MessageOpenPgp.js ***!
  \******************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),
	$ = __webpack_require__(/*! $ */ 10),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Enums = __webpack_require__(/*! Common/Enums */ 3),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function MessageOpenPgpPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsMessageOpenPgp');

	this.notification = ko.observable('');

	this.selectedKey = ko.observable(null);
	this.privateKeys = ko.observableArray([]);

	this.password = ko.observable('');
	this.password.focus = ko.observable(false);
	this.buttonFocus = ko.observable(false);

	this.resultCallback = null;

	this.submitRequest = ko.observable(false);

	// commands
	this.doCommand = Utils.createCommand(this, function() {

		this.submitRequest(true);

		_.delay(_.bind(function() {

			var
				oPrivateKeys = [],
				oPrivateKey = null;

			try
			{
				if (this.resultCallback && this.selectedKey())
				{
					oPrivateKeys = this.selectedKey().getNativeKeys();
					oPrivateKey = oPrivateKeys && oPrivateKeys[0] ? oPrivateKeys[0] : null;

					if (oPrivateKey)
					{
						try
						{
							if (!oPrivateKey.decrypt(Utils.pString(this.password())))
							{
								Utils.log('Error: Private key cannot be decrypted');
								oPrivateKey = null;
							}
						}
						catch (e)
						{
							Utils.log(e);
							oPrivateKey = null;
						}
					}
					else
					{
						Utils.log('Error: Private key cannot be found');
					}
				}
			}
			catch (e)
			{
				Utils.log(e);
				oPrivateKey = null;
			}

			this.submitRequest(false);

			this.cancelCommand();
			this.resultCallback(oPrivateKey);

		}, this), Enums.Magics.Time100ms);

	}, function() {
		return !this.submitRequest();
	});

	this.sDefaultKeyScope = Enums.KeyState.PopupMessageOpenPGP;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/MessageOpenPgp'], MessageOpenPgpPopupView);
_.extend(MessageOpenPgpPopupView.prototype, AbstractView.prototype);

MessageOpenPgpPopupView.prototype.clearPopup = function()
{
	this.notification('');

	this.password('');
	this.password.focus(false);
	this.buttonFocus(false);

	this.selectedKey(false);
	this.submitRequest(false);

	this.resultCallback = null;
	this.privateKeys([]);
};

MessageOpenPgpPopupView.prototype.onBuild = function(oDom)
{
	key('tab,shift+tab', Enums.KeyState.PopupMessageOpenPGP, _.bind(function() {

		switch (true)
		{
			case this.password.focus():
				this.buttonFocus(true);
				break;
			case this.buttonFocus():
				this.password.focus(true);
				break;
			// no default
		}

		return false;

	}, this));

	var self = this;

	oDom
		.on('click', '.key-list__item', function() {

			oDom.find('.key-list__item .key-list__item__radio')
				.addClass('icon-radio-unchecked')
				.removeClass('icon-radio-checked');

			$(this).find('.key-list__item__radio')
				.removeClass('icon-radio-unchecked')
				.addClass('icon-radio-checked');

			self.selectedKey(ko.dataFor(this));

			self.password.focus(true);
		});
};

MessageOpenPgpPopupView.prototype.onHideWithDelay = function()
{
	this.clearPopup();
};

MessageOpenPgpPopupView.prototype.onShowWithDelay = function()
{
	this.password.focus(true);
//		this.buttonFocus(true);
};

MessageOpenPgpPopupView.prototype.onShow = function(fCallback, aPrivateKeys)
{
	this.clearPopup();

	this.resultCallback = fCallback;
	this.privateKeys(aPrivateKeys);

	if (this.viewModelDom)
	{
		this.viewModelDom.find('.key-list__item').first().click();
	}
};

module.exports = MessageOpenPgpPopupView;


/***/ },
/* 146 */
/*!*****************************************!*\
  !*** ./dev/View/Popup/NewOpenPgpKey.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	PgpStore = __webpack_require__(/*! Stores/User/Pgp */ 31),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function NewOpenPgpKeyPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsNewOpenPgpKey');

	this.email = ko.observable('');
	this.email.focus = ko.observable('');
	this.email.error = ko.observable(false);

	this.name = ko.observable('');
	this.password = ko.observable('');
	this.keyBitLength = ko.observable(Enums.Magics.BitLength2048);

	this.submitRequest = ko.observable(false);

	this.email.subscribe(function() {
		this.email.error(false);
	}, this);

	this.generateOpenPgpKeyCommand = Utils.createCommand(this, function() {

		var
			self = this,
			oUserId = {},
			oOpenpgpKeyring = PgpStore.openpgpKeyring;

		this.email.error('' === Utils.trim(this.email()));
		if (!oOpenpgpKeyring || this.email.error())
		{
			return false;
		}

		oUserId.email = this.email();
		if ('' !== this.name())
		{
			oUserId.name = this.name();
		}

		this.submitRequest(true);

		_.delay(function() {

			var mPromise = false;

			try {

				mPromise = PgpStore.openpgp.generateKey({
					userIds: [oUserId],
					numBits: Utils.pInt(self.keyBitLength()),
					passphrase: Utils.trim(self.password())
				});

				mPromise.then(function(mKeyPair) {

					self.submitRequest(false);

					if (mKeyPair && mKeyPair.privateKeyArmored)
					{
						oOpenpgpKeyring.privateKeys.importKey(mKeyPair.privateKeyArmored);
						oOpenpgpKeyring.publicKeys.importKey(mKeyPair.publicKeyArmored);

						oOpenpgpKeyring.store();

						__webpack_require__(/*! App/User */ 8).default.reloadOpenPgpKeys();
						Utils.delegateRun(self, 'cancelCommand');
					}

				}).then(null, function() {
					self.submitRequest(false);
				});
			}
			catch (e)
			{
				Utils.log(e);
				self.submitRequest(false);
			}

		}, Enums.Magics.Time100ms);

		return true;
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/NewOpenPgpKey', 'PopupsNewOpenPgpKeyViewModel'], NewOpenPgpKeyPopupView);
_.extend(NewOpenPgpKeyPopupView.prototype, AbstractView.prototype);

NewOpenPgpKeyPopupView.prototype.clearPopup = function()
{
	this.name('');
	this.password('');

	this.email('');
	this.email.error(false);
	this.keyBitLength(Enums.Magics.BitLength2048);
};

NewOpenPgpKeyPopupView.prototype.onShow = function()
{
	this.clearPopup();
};

NewOpenPgpKeyPopupView.prototype.onShowWithDelay = function()
{
	this.email.focus(true);
};

module.exports = NewOpenPgpKeyPopupView;


/***/ },
/* 147 */,
/* 148 */
/*!*****************************************!*\
  !*** ./dev/View/Popup/TwoFactorTest.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function TwoFactorTestPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsTwoFactorTest');

	var self = this;

	this.code = ko.observable('');
	this.code.focused = ko.observable(false);
	this.code.status = ko.observable(null);

	this.koTestedTrigger = null;

	this.testing = ko.observable(false);

	// commands
	this.testCode = Utils.createCommand(this, function() {

		this.testing(true);
		Remote.testTwoFactor(function(sResult, oData) {

			self.testing(false);
			self.code.status(Enums.StorageResultType.Success === sResult && oData && !!oData.Result);

			if (self.koTestedTrigger && self.code.status())
			{
				self.koTestedTrigger(true);
			}

		}, this.code());

	}, function() {
		return '' !== this.code() && !this.testing();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/TwoFactorTest', 'PopupsTwoFactorTestViewModel'], TwoFactorTestPopupView);
_.extend(TwoFactorTestPopupView.prototype, AbstractView.prototype);

TwoFactorTestPopupView.prototype.clearPopup = function()
{
	this.code('');
	this.code.focused(false);
	this.code.status(null);
	this.testing(false);

	this.koTestedTrigger = null;
};

TwoFactorTestPopupView.prototype.onShow = function(koTestedTrigger)
{
	this.clearPopup();

	this.koTestedTrigger = koTestedTrigger;
};

TwoFactorTestPopupView.prototype.onShowWithDelay = function()
{
	if (!Globals.bMobile)
	{
		this.code.focused(true);
	}
};

module.exports = TwoFactorTestPopupView;


/***/ },
/* 149 */
/*!******************************************!*\
  !*** ./dev/View/Popup/ViewOpenPgpKey.js ***!
  \******************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function ViewOpenPgpKeyPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsViewOpenPgpKey');

	this.key = ko.observable('');
	this.keyDom = ko.observable(null);

	this.sDefaultKeyScope = Enums.KeyState.PopupViewOpenPGP;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/ViewOpenPgpKey', 'PopupsViewOpenPgpKeyViewModel'], ViewOpenPgpKeyPopupView);
_.extend(ViewOpenPgpKeyPopupView.prototype, AbstractView.prototype);

ViewOpenPgpKeyPopupView.prototype.clearPopup = function()
{
	this.key('');
};

ViewOpenPgpKeyPopupView.prototype.selectKey = function()
{
	var oEl = this.keyDom();
	if (oEl)
	{
		Utils.selectElement(oEl);
	}
};

ViewOpenPgpKeyPopupView.prototype.onShow = function(oOpenPgpKey)
{
	this.clearPopup();

	if (oOpenPgpKey)
	{
		this.key(oOpenPgpKey.armor);
	}
};

ViewOpenPgpKeyPopupView.prototype.onBuild = function()
{
	key('ctrl+a, command+a', Enums.KeyState.PopupViewOpenPGP, _.bind(function() {
		this.selectKey();
		return false;
	}, this));
};

module.exports = ViewOpenPgpKeyPopupView;


/***/ },
/* 150 */
/*!***************************************!*\
  !*** ./dev/View/Popup/WelcomePage.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Promises = __webpack_require__(/*! Promises/User/Ajax */ 42),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function WelcomePagePopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsWelcomePage');

	this.welcomePageURL = ko.observable('');

	this.closeFocused = ko.observable(false);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/WelcomePage', 'WelcomePagePopupViewModel'], WelcomePagePopupView);
_.extend(WelcomePagePopupView.prototype, AbstractView.prototype);

WelcomePagePopupView.prototype.clearPopup = function()
{
	this.welcomePageURL('');
	this.closeFocused(false);
};

/**
 * @param {string} sUrl
 * @returns {void}
 */
WelcomePagePopupView.prototype.onShow = function(sUrl)
{
	this.clearPopup();

	this.welcomePageURL(sUrl);
};

WelcomePagePopupView.prototype.onShowWithDelay = function()
{
	this.closeFocused(true);
};

WelcomePagePopupView.prototype.onHide = function()
{
	Promises.welcomeClose();
};

module.exports = WelcomePagePopupView;


/***/ },
/* 151 */
/*!********************************!*\
  !*** ./dev/View/User/Login.js ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Plugins = __webpack_require__(/*! Common/Plugins */ 21),

	LanguageStore = __webpack_require__(/*! Stores/Language */ 38),
	AppStore = __webpack_require__(/*! Stores/User/App */ 22),

	Local = __webpack_require__(/*! Storage/Client */ 47),
	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function LoginUserView()
{
	AbstractView.call(this, 'Center', 'Login');

	this.welcome = ko.observable(!!Settings.settingsGet('UseLoginWelcomePage'));

	this.email = ko.observable('');
	this.password = ko.observable('');
	this.signMe = ko.observable(false);

	this.additionalCode = ko.observable('');
	this.additionalCode.error = ko.observable(false);
	this.additionalCode.errorAnimation = ko.observable(false).extend({'falseTimeout': 500});
	this.additionalCode.focused = ko.observable(false);
	this.additionalCode.visibility = ko.observable(false);
	this.additionalCodeSignMe = ko.observable(false);

	this.logoImg = Utils.trim(Settings.settingsGet('LoginLogo'));
	this.logoPowered = !!Settings.settingsGet('LoginPowered');
	this.loginDescription = Utils.trim(Settings.settingsGet('LoginDescription'));

	this.mobile = !!Settings.appSettingsGet('mobile');
	this.mobileDevice = !!Settings.appSettingsGet('mobileDevice');

	this.forgotPasswordLinkUrl = Settings.appSettingsGet('forgotPasswordLinkUrl');
	this.registrationLinkUrl = Settings.appSettingsGet('registrationLinkUrl');

	this.emailError = ko.observable(false);
	this.passwordError = ko.observable(false);

	this.emailErrorAnimation = ko.observable(false).extend({'falseTimeout': 500});
	this.passwordErrorAnimation = ko.observable(false).extend({'falseTimeout': 500});

	this.formHidden = ko.observable(false);

	this.formError = ko.computed(function() {
		return this.emailErrorAnimation() || this.passwordErrorAnimation() ||
			(this.additionalCode.visibility() && this.additionalCode.errorAnimation());
	}, this);

	this.emailFocus = ko.observable(false);
	this.passwordFocus = ko.observable(false);
	this.submitFocus = ko.observable(false);

	this.email.subscribe(function() {
		this.emailError(false);
		this.additionalCode('');
		this.additionalCode.visibility(false);
	}, this);

	this.password.subscribe(function() {
		this.passwordError(false);
	}, this);

	this.additionalCode.subscribe(function() {
		this.additionalCode.error(false);
	}, this);

	this.additionalCode.visibility.subscribe(function() {
		this.additionalCode.error(false);
	}, this);

	this.emailError.subscribe(function(bV) {
		this.emailErrorAnimation(!!bV);
	}, this);

	this.passwordError.subscribe(function(bV) {
		this.passwordErrorAnimation(!!bV);
	}, this);

	this.additionalCode.error.subscribe(function(bV) {
		this.additionalCode.errorAnimation(!!bV);
	}, this);

	this.submitRequest = ko.observable(false);
	this.submitError = ko.observable('');
	this.submitErrorAddidional = ko.observable('');

	this.submitError.subscribe(function(sValue) {
		if ('' === sValue)
		{
			this.submitErrorAddidional('');
		}
	}, this);

	this.allowLanguagesOnLogin = AppStore.allowLanguagesOnLogin;

	this.langRequest = ko.observable(false);
	this.language = LanguageStore.language;
	this.languages = LanguageStore.languages;

	this.bSendLanguage = false;

	this.languageFullName = ko.computed(function() {
		return Utils.convertLangName(this.language());
	}, this);

	this.signMeType = ko.observable(Enums.LoginSignMeType.Unused);

	this.signMeType.subscribe(function(iValue) {
		this.signMe(Enums.LoginSignMeType.DefaultOn === iValue);
	}, this);

	this.signMeVisibility = ko.computed(function() {
		return Enums.LoginSignMeType.Unused !== this.signMeType();
	}, this);

	this.submitCommand = Utils.createCommand(this, function() {

		Utils.triggerAutocompleteInputChange();

		this.emailError(false);
		this.passwordError(false);

		this.emailError('' === Utils.trim(this.email()));
		this.passwordError('' === Utils.trim(this.password()));

		if (this.additionalCode.visibility())
		{
			this.additionalCode.error(false);
			this.additionalCode.error('' === Utils.trim(this.additionalCode()));
		}

		if (this.emailError() || this.passwordError() ||
			(this.additionalCode.visibility() && this.additionalCode.error()))
		{
			switch (true)
			{
				case this.emailError():
					this.emailFocus(true);
					break;
				case this.passwordError():
					this.passwordFocus(true);
					break;
				case this.additionalCode.visibility() && this.additionalCode.error():
					this.additionalCode.focused(true);
					break;
				// no default
			}

			return false;
		}

		var
			iPluginResultCode = 0,
			sPluginResultMessage = '',
			fSubmitResult = function(iResultCode, sResultMessage) {
				iPluginResultCode = iResultCode || 0;
				sPluginResultMessage = sResultMessage || '';
			};

		Plugins.runHook('user-login-submit', [fSubmitResult]);
		if (0 < iPluginResultCode)
		{
			this.submitError(Translator.getNotification(iPluginResultCode));
			return false;
		}
		else if ('' !== sPluginResultMessage)
		{
			this.submitError(sPluginResultMessage);
			return false;
		}

		this.submitRequest(true);

		var
			self = this,
			sPassword = this.password(),

			fLoginRequest = _.bind(function(sLoginPassword) {

				Remote.login(_.bind(function(sResult, oData) {

					if (Enums.StorageResultType.Success === sResult && oData && 'Login' === oData.Action)
					{
						if (oData.Result)
						{
							if (oData.TwoFactorAuth)
							{
								this.additionalCode('');
								this.additionalCode.visibility(true);
								this.submitRequest(false);

								_.delay(function() {
									self.additionalCode.focused(true);
								}, Enums.Magics.Time100ms);
							}
							else if (oData.Admin)
							{
								__webpack_require__(/*! App/User */ 8).default.redirectToAdminPanel();
							}
							else
							{
								__webpack_require__(/*! App/User */ 8).default.loginAndLogoutReload(false);
							}
						}
						else if (oData.ErrorCode)
						{
							this.submitRequest(false);
							if (-1 < Utils.inArray(oData.ErrorCode, [Enums.Notification.InvalidInputArgument]))
							{
								oData.ErrorCode = Enums.Notification.AuthError;
							}

							this.submitError(Translator.getNotificationFromResponse(oData));

							if ('' === this.submitError())
							{
								this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
							}
							else
							{
								if (oData.ErrorMessageAdditional)
								{
									this.submitErrorAddidional(oData.ErrorMessageAdditional);
								}
							}
						}
						else
						{
							this.submitRequest(false);
						}
					}
					else
					{
						this.submitRequest(false);
						this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
					}

				}, this), this.email(), '', sLoginPassword, !!this.signMe(),
					this.bSendLanguage ? this.language() : '',
					this.additionalCode.visibility() ? this.additionalCode() : '',
					this.additionalCode.visibility() ? !!this.additionalCodeSignMe() : false
				);

				Local.set(Enums.ClientSideKeyName.LastSignMe, this.signMe() ? '-1-' : '-0-');

			}, this);

		if (Settings.appSettingsGet('rsaPublicKey') && Utils.rsaEncode.supported)
		{
			fLoginRequest(Utils.rsaEncode(sPassword, Settings.appSettingsGet('rsaPublicKey')));
		}
		else
		{
			fLoginRequest(sPassword);
		}

		return true;

	}, function() {
		return !this.submitRequest();
	});

	this.facebookLoginEnabled = ko.observable(false);

	this.facebookCommand = Utils.createCommand(this, function() {

		window.open(Links.socialFacebook(), 'Facebook',
			'left=200,top=100,width=650,height=450,menubar=no,status=no,resizable=yes,scrollbars=yes');

		return true;

	}, function() {
		return !this.submitRequest() && this.facebookLoginEnabled();
	});

	this.googleLoginEnabled = ko.observable(false);
	this.googleFastLoginEnabled = ko.observable(false);

	this.googleCommand = Utils.createCommand(this, function() {

		window.open(Links.socialGoogle(), 'Google',
			'left=200,top=100,width=650,height=500,menubar=no,status=no,resizable=yes,scrollbars=yes');

		return true;

	}, function() {
		return !this.submitRequest() && this.googleLoginEnabled();
	});

	this.googleFastCommand = Utils.createCommand(this, function() {

		window.open(Links.socialGoogle(true), 'Google',
			'left=200,top=100,width=650,height=500,menubar=no,status=no,resizable=yes,scrollbars=yes');

		return true;

	}, function() {
		return !this.submitRequest() && this.googleFastLoginEnabled();
	});

	this.twitterLoginEnabled = ko.observable(false);

	this.twitterCommand = Utils.createCommand(this, function() {

		window.open(Links.socialTwitter(), 'Twitter',
			'left=200,top=100,width=650,height=450,menubar=no,status=no,resizable=yes,scrollbars=yes');

		return true;

	}, function() {
		return !this.submitRequest() && this.twitterLoginEnabled();
	});

	this.socialLoginEnabled = ko.computed(function() {

		var
			bF = this.facebookLoginEnabled(),
			bG = this.googleLoginEnabled(),
			bT = this.twitterLoginEnabled();

		return bF || bG || bT;
	}, this);

	if (Settings.settingsGet('AdditionalLoginError') && !this.submitError())
	{
		this.submitError(Settings.settingsGet('AdditionalLoginError'));
	}

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/Login', 'View/App/Login', 'LoginViewModel'], LoginUserView);
_.extend(LoginUserView.prototype, AbstractView.prototype);

LoginUserView.prototype.displayMainForm = function()
{
	this.welcome(false);
};

LoginUserView.prototype.onShow = function()
{
	kn.routeOff();
};

LoginUserView.prototype.onShowWithDelay = function()
{
	if ('' !== this.email() && '' !== this.password())
	{
		this.submitFocus(true);
	}
	else if ('' === this.email())
	{
		this.emailFocus(true);
	}
	else if ('' === this.password())
	{
		this.passwordFocus(true);
	}
	else
	{
		this.emailFocus(true);
	}
};

LoginUserView.prototype.onHide = function()
{
	this.submitFocus(false);
	this.emailFocus(false);
	this.passwordFocus(false);
};

LoginUserView.prototype.onBuild = function()
{
	var
		self = this,
		sSignMeLocal = Local.get(Enums.ClientSideKeyName.LastSignMe),
		sSignMe = (Settings.settingsGet('SignMe') || 'unused').toLowerCase(),
		sJsHash = Settings.appSettingsGet('jsHash'),
		fSocial = function(iErrorCode) {
			iErrorCode = Utils.pInt(iErrorCode);
			if (0 === iErrorCode)
			{
				self.submitRequest(true);
				__webpack_require__(/*! App/User */ 8).default.loginAndLogoutReload(false);
			}
			else
			{
				self.submitError(Translator.getNotification(iErrorCode));
			}
		};

	this.facebookLoginEnabled(!!Settings.settingsGet('AllowFacebookSocial'));
	this.twitterLoginEnabled(!!Settings.settingsGet('AllowTwitterSocial'));
	this.googleLoginEnabled(!!Settings.settingsGet('AllowGoogleSocial') &&
		!!Settings.settingsGet('AllowGoogleSocialAuth'));
	this.googleFastLoginEnabled(!!Settings.settingsGet('AllowGoogleSocial') &&
		!!Settings.settingsGet('AllowGoogleSocialAuthFast'));

	switch (sSignMe)
	{
		case Enums.LoginSignMeTypeAsString.DefaultOff:
		case Enums.LoginSignMeTypeAsString.DefaultOn:

			this.signMeType(Enums.LoginSignMeTypeAsString.DefaultOn === sSignMe ?
				Enums.LoginSignMeType.DefaultOn : Enums.LoginSignMeType.DefaultOff);

			switch (sSignMeLocal)
			{
				case '-1-':
					this.signMeType(Enums.LoginSignMeType.DefaultOn);
					break;
				case '-0-':
					this.signMeType(Enums.LoginSignMeType.DefaultOff);
					break;
				// no default
			}

			break;
		case Enums.LoginSignMeTypeAsString.Unused:
		default:
			this.signMeType(Enums.LoginSignMeType.Unused);
			break;
	}

	this.email(AppStore.devEmail);
	this.password(AppStore.devPassword);

	if (this.googleLoginEnabled() || this.googleFastLoginEnabled())
	{
		window['rl_' + sJsHash + '_google_login_service'] = fSocial;
	}

	if (this.facebookLoginEnabled())
	{
		window['rl_' + sJsHash + '_facebook_login_service'] = fSocial;
	}

	if (this.twitterLoginEnabled())
	{
		window['rl_' + sJsHash + '_twitter_login_service'] = fSocial;
	}

	_.delay(function() {

		LanguageStore.language.subscribe(function(sValue) {

			self.langRequest(true);

			Translator.reload(false, sValue).then(function() {
				self.langRequest(false);
				self.bSendLanguage = true;
			}, function() {
				self.langRequest(false);
			});

		});

	}, Enums.Magics.Time50ms);

	Utils.triggerAutocompleteInputChange(true);
};

LoginUserView.prototype.submitForm = function()
{
	this.submitCommand();
};

LoginUserView.prototype.selectLanguage = function()
{
	kn.showScreenPopup(__webpack_require__(/*! View/Popup/Languages */ 44), [
		this.language, this.languages(), LanguageStore.userLanguage()
	]);
};

LoginUserView.prototype.selectLanguageOnTab = function(bShift)
{
	if (!bShift)
	{
		var self = this;
		_.delay(function() {
			self.emailFocus(true);
		}, Enums.Magics.Time50ms);

		return false;
	}

	return true;
};

module.exports = LoginUserView;


/***/ },
/* 152 */
/*!*********************************************!*\
  !*** ./dev/View/User/MailBox/FolderList.js ***!
  \*********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function FolderListMailBoxUserView()
{
	AbstractView.call(this, 'Left', 'MailFolderList');

	this.oContentVisible = null;
	this.oContentScrollable = null;

	this.composeInEdit = AppStore.composeInEdit;

	this.messageList = MessageStore.messageList;
	this.folderList = FolderStore.folderList;
	this.folderListSystem = FolderStore.folderListSystem;
	this.foldersChanging = FolderStore.foldersChanging;

	this.foldersListWithSingleInboxRootFolder = FolderStore.foldersListWithSingleInboxRootFolder;

	this.leftPanelDisabled = Globals.leftPanelDisabled;

	this.iDropOverTimer = 0;

	this.allowComposer = !!Settings.capa(Enums.Capa.Composer);
	this.allowContacts = !!AppStore.contactsIsAllowed();
	this.allowFolders = !!Settings.capa(Enums.Capa.Folders);

	this.folderListFocused = ko.computed(function() {
		return Enums.Focused.FolderList === AppStore.focusedState();
	});

	this.isInboxStarred = ko.computed(function() {
		return FolderStore.currentFolder() &&
			FolderStore.currentFolder().isInbox() &&
			-1 < Utils.trim(MessageStore.messageListSearch()).indexOf('is:flagged');
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/MailBox/FolderList', 'View/App/MailBox/FolderList', 'MailBoxFolderListViewModel'], FolderListMailBoxUserView);
_.extend(FolderListMailBoxUserView.prototype, AbstractView.prototype);

FolderListMailBoxUserView.prototype.onBuild = function(oDom)
{
	this.oContentVisible = $('.b-content', oDom);
	this.oContentScrollable = $('.content', this.oContentVisible);

	var
		self = this,
		bMobile = Settings.appSettingsGet('mobile'),
		fSelectFolder = function(oEvent, bStarred) {

			if (bMobile)
			{
				Globals.leftPanelDisabled(true);
			}

			oEvent.preventDefault();

			if (bStarred)
			{
				oEvent.stopPropagation();
			}

			var
				oFolder = ko.dataFor(this);

			if (oFolder)
			{
				if (Enums.Layout.NoPreview === SettingsStore.layout())
				{
					MessageStore.message(null);
				}

				if (oFolder.fullNameRaw === FolderStore.currentFolderFullNameRaw())
				{
					Cache.setFolderHash(oFolder.fullNameRaw, '');
				}

				if (bStarred)
				{
					kn.setHash(Links.mailBox(oFolder.fullNameHash, 1, 'is:flagged'));
				}
				else
				{
					kn.setHash(Links.mailBox(oFolder.fullNameHash));
				}
			}
		};

	oDom
		.on('click', '.b-folders .e-item .e-link .e-collapsed-sign', function(oEvent) {

			var
				oFolder = ko.dataFor(this),
				bCollapsed = false;

			if (oFolder && oEvent)
			{
				bCollapsed = oFolder.collapsed();
				__webpack_require__(/*! App/User */ 8).default.setExpandedFolder(oFolder.fullNameHash, bCollapsed);

				oFolder.collapsed(!bCollapsed);
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		})
		.on('click', '.b-folders .e-item .e-link.selectable .inbox-star-icon', function(oEvent) {
			fSelectFolder.call(this, oEvent, !self.isInboxStarred());
		})
		.on('click', '.b-folders .e-item .e-link.selectable', function(oEvent) {
			fSelectFolder.call(this, oEvent, false);
		});

	key('up, down', Enums.KeyState.FolderList, function(event, handler) {

		var
			iIndex = -1,
			iKeyCode = handler && 'up' === handler.shortcut ? Enums.EventKeyCode.Up : Enums.EventKeyCode.Down,
			$items = $('.b-folders .e-item .e-link:not(.hidden):visible', oDom);

		if (event && $items.length)
		{
			iIndex = $items.index($items.filter('.focused'));
			if (-1 < iIndex)
			{
				$items.eq(iIndex).removeClass('focused');
			}

			if (Enums.EventKeyCode.Up === iKeyCode && 0 < iIndex)
			{
				iIndex -= 1;
			}
			else if (Enums.EventKeyCode.Down === iKeyCode && iIndex < $items.length - 1)
			{
				iIndex += 1;
			}

			$items.eq(iIndex).addClass('focused');
			self.scrollToFocused();
		}

		return false;
	});

	key('enter', Enums.KeyState.FolderList, function() {
		var $items = $('.b-folders .e-item .e-link:not(.hidden).focused', oDom);
		if ($items.length && $items[0])
		{
			AppStore.focusedState(Enums.Focused.MessageList);
			$items.click();
		}

		return false;
	});

	key('space', Enums.KeyState.FolderList, function() {
		var bCollapsed = true, oFolder = null, $items = $('.b-folders .e-item .e-link:not(.hidden).focused', oDom);
		if ($items.length && $items[0])
		{
			oFolder = ko.dataFor($items[0]);
			if (oFolder)
			{
				bCollapsed = oFolder.collapsed();
				__webpack_require__(/*! App/User */ 8).default.setExpandedFolder(oFolder.fullNameHash, bCollapsed);
				oFolder.collapsed(!bCollapsed);
			}
		}

		return false;
	});

	key('esc, tab, shift+tab, right', Enums.KeyState.FolderList, function() {
		AppStore.focusedState(Enums.Focused.MessageList);
		return false;
	});

	AppStore.focusedState.subscribe(function(mValue) {
		$('.b-folders .e-item .e-link.focused', oDom).removeClass('focused');
		if (Enums.Focused.FolderList === mValue)
		{
			$('.b-folders .e-item .e-link.selected', oDom).addClass('focused');
		}
	});
};

FolderListMailBoxUserView.prototype.messagesDropOver = function(oFolder)
{
	window.clearTimeout(this.iDropOverTimer);
	if (oFolder && oFolder.collapsed())
	{
		this.iDropOverTimer = window.setTimeout(function() {
			oFolder.collapsed(false);
			__webpack_require__(/*! App/User */ 8).default.setExpandedFolder(oFolder.fullNameHash, true);
			Utils.windowResize();
		}, Enums.Magics.Time500ms);
	}
};

FolderListMailBoxUserView.prototype.messagesDropOut = function()
{
	window.clearTimeout(this.iDropOverTimer);
};

FolderListMailBoxUserView.prototype.scrollToFocused = function()
{
	if (!this.oContentVisible || !this.oContentScrollable)
	{
		return false;
	}

	var
		iOffset = 20,
		oFocused = $('.e-item .e-link.focused', this.oContentScrollable),
		oPos = oFocused.position(),
		iVisibleHeight = this.oContentVisible.height(),
		iFocusedHeight = oFocused.outerHeight();

	if (oPos && (0 > oPos.top || oPos.top + iFocusedHeight > iVisibleHeight))
	{
		if (0 > oPos.top)
		{
			this.oContentScrollable.scrollTop(this.oContentScrollable.scrollTop() + oPos.top - iOffset);
		}
		else
		{
			this.oContentScrollable.scrollTop(this.oContentScrollable.scrollTop() + oPos.top - iVisibleHeight + iFocusedHeight + iOffset);
		}

		return true;
	}

	return false;
};

/**
 * @param {FolderModel} oToFolder
 * @param {{helper:jQuery}} oUi
 * @returns {void}
 */
FolderListMailBoxUserView.prototype.messagesDrop = function(oToFolder, oUi)
{
	if (oToFolder && oUi && oUi.helper)
	{
		var
			sFromFolderFullNameRaw = oUi.helper.data('rl-folder'),
			bCopy = Globals.$html.hasClass('rl-ctrl-key-pressed'),
			aUids = oUi.helper.data('rl-uids');

		if (Utils.isNormal(sFromFolderFullNameRaw) && '' !== sFromFolderFullNameRaw && Utils.isArray(aUids))
		{
			__webpack_require__(/*! App/User */ 8).default.moveMessagesToFolder(sFromFolderFullNameRaw, aUids, oToFolder.fullNameRaw, bCopy);
		}
	}
};

FolderListMailBoxUserView.prototype.composeClick = function()
{
	if (Settings.capa(Enums.Capa.Composer))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
	}
};

FolderListMailBoxUserView.prototype.createFolder = function()
{
	kn.showScreenPopup(__webpack_require__(/*! View/Popup/FolderCreate */ 97));
};

FolderListMailBoxUserView.prototype.configureFolders = function()
{
	kn.setHash(Links.settings('folders'));
};

FolderListMailBoxUserView.prototype.contactsClick = function()
{
	if (this.allowContacts)
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Contacts */ 64));
	}
};

module.exports = FolderListMailBoxUserView;


/***/ },
/* 153 */
/*!**********************************************!*\
  !*** ./dev/View/User/MailBox/MessageList.js ***!
  \**********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),
	Jua = __webpack_require__(/*! Jua */ 86),
	ifvisible = __webpack_require__(/*! ifvisible */ 186),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Events = __webpack_require__(/*! Common/Events */ 23),
	Selector = __webpack_require__(/*! Common/Selector */ 102),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	QuotaStore = __webpack_require__(/*! Stores/User/Quota */ 92),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function MessageListMailBoxUserView()
{
	AbstractView.call(this, 'Right', 'MailMessageList');

	this.sLastUid = null;
	this.bPrefetch = false;
	this.emptySubjectValue = '';

	this.mobile = !!Settings.appSettingsGet('mobile');

	this.allowReload = !!Settings.capa(Enums.Capa.Reload);
	this.allowSearch = !!Settings.capa(Enums.Capa.Search);
	this.allowSearchAdv = !!Settings.capa(Enums.Capa.SearchAdv);
	this.allowComposer = !!Settings.capa(Enums.Capa.Composer);
	this.allowMessageListActions = !!Settings.capa(Enums.Capa.MessageListActions);
	this.allowDangerousActions = !!Settings.capa(Enums.Capa.DangerousActions);
	this.allowFolders = !!Settings.capa(Enums.Capa.Folders);

	this.popupVisibility = Globals.popupVisibility;

	this.message = MessageStore.message;
	this.messageList = MessageStore.messageList;
	this.messageListDisableAutoSelect = MessageStore.messageListDisableAutoSelect;

	this.folderList = FolderStore.folderList;

	this.composeInEdit = AppStore.composeInEdit;
	this.leftPanelDisabled = Globals.leftPanelDisabled;

	this.selectorMessageSelected = MessageStore.selectorMessageSelected;
	this.selectorMessageFocused = MessageStore.selectorMessageFocused;
	this.isMessageSelected = MessageStore.isMessageSelected;
	this.messageListSearch = MessageStore.messageListSearch;
	this.messageListThreadUid = MessageStore.messageListThreadUid;
	this.messageListError = MessageStore.messageListError;
	this.folderMenuForMove = FolderStore.folderMenuForMove;

	this.useCheckboxesInList = SettingsStore.useCheckboxesInList;

	this.mainMessageListSearch = MessageStore.mainMessageListSearch;
	this.messageListEndFolder = MessageStore.messageListEndFolder;
	this.messageListEndThreadUid = MessageStore.messageListEndThreadUid;

	this.messageListChecked = MessageStore.messageListChecked;
	this.messageListCheckedOrSelected = MessageStore.messageListCheckedOrSelected;
	this.messageListCheckedOrSelectedUidsWithSubMails = MessageStore.messageListCheckedOrSelectedUidsWithSubMails;
	this.messageListCompleteLoadingThrottle = MessageStore.messageListCompleteLoadingThrottle;
	this.messageListCompleteLoadingThrottleForAnimation = MessageStore.messageListCompleteLoadingThrottleForAnimation;

	Translator.initOnStartOrLangChange(_.bind(function() {
		this.emptySubjectValue = Translator.i18n('MESSAGE_LIST/EMPTY_SUBJECT_TEXT');
	}, this));

	this.userQuota = QuotaStore.quota;
	this.userUsageSize = QuotaStore.usage;
	this.userUsageProc = QuotaStore.percentage;

	this.moveDropdownTrigger = ko.observable(false);
	this.moreDropdownTrigger = ko.observable(false);

	// append drag and drop
	this.dragOver = ko.observable(false).extend({'throttle': 1});
	this.dragOverEnter = ko.observable(false).extend({'throttle': 1});
	this.dragOverArea = ko.observable(null);
	this.dragOverBodyArea = ko.observable(null);

	this.messageListItemTemplate = ko.computed(function() {
		return this.mobile || Enums.Layout.SidePreview === SettingsStore.layout() ?
			'MailMessageListItem' : 'MailMessageListItemNoPreviewPane';
	}, this);

	this.messageListSearchDesc = ko.computed(function() {
		var sValue = MessageStore.messageListEndSearch();
		return '' === sValue ? '' : Translator.i18n('MESSAGE_LIST/SEARCH_RESULT_FOR', {'SEARCH': sValue});
	});

	this.messageListPagenator = ko.computed(Utils.computedPagenatorHelper(
		MessageStore.messageListPage, MessageStore.messageListPageCount));

	this.checkAll = ko.computed({
		'read': function() {
			return 0 < MessageStore.messageListChecked().length;
		},

		'write': function(bValue) {
			bValue = !!bValue;
			_.each(MessageStore.messageList(), function(oMessage) {
				oMessage.checked(bValue);
			});
		}
	});

	this.inputMessageListSearchFocus = ko.observable(false);

	this.sLastSearchValue = '';
	this.inputProxyMessageListSearch = ko.computed({
		'read': this.mainMessageListSearch,
		'write': function(sValue) {
			this.sLastSearchValue = sValue;
		},
		'owner': this
	});

	this.isIncompleteChecked = ko.computed(function() {
		var
			iM = MessageStore.messageList().length,
			iC = MessageStore.messageListChecked().length;
		return 0 < iM && 0 < iC && iM > iC;
	}, this);

	this.hasMessages = ko.computed(function() {
		return 0 < this.messageList().length;
	}, this);

	this.hasCheckedOrSelectedLines = ko.computed(function() {
		return 0 < this.messageListCheckedOrSelected().length;
	}, this);

	this.isSpamFolder = ko.computed(function() {
		return FolderStore.spamFolder() === this.messageListEndFolder() &&
			'' !== FolderStore.spamFolder();
	}, this);

	this.isSpamDisabled = ko.computed(function() {
		return Consts.UNUSED_OPTION_VALUE === FolderStore.spamFolder();
	}, this);

	this.isTrashFolder = ko.computed(function() {
		return FolderStore.trashFolder() === this.messageListEndFolder() &&
			'' !== FolderStore.trashFolder();
	}, this);

	this.isDraftFolder = ko.computed(function() {
		return FolderStore.draftFolder() === this.messageListEndFolder() &&
			'' !== FolderStore.draftFolder();
	}, this);

	this.isSentFolder = ko.computed(function() {
		return FolderStore.sentFolder() === this.messageListEndFolder() &&
			'' !== FolderStore.sentFolder();
	}, this);

	this.isArchiveFolder = ko.computed(function() {
		return FolderStore.archiveFolder() === this.messageListEndFolder() &&
			'' !== FolderStore.archiveFolder();
	}, this);

	this.isArchiveDisabled = ko.computed(function() {
		return Consts.UNUSED_OPTION_VALUE === FolderStore.archiveFolder();
	}, this);

	this.isArchiveVisible = ko.computed(function() {
		return !this.isArchiveFolder() && !this.isArchiveDisabled() && !this.isDraftFolder();
	}, this);

	this.isSpamVisible = ko.computed(function() {
		return !this.isSpamFolder() && !this.isSpamDisabled() && !this.isDraftFolder() && !this.isSentFolder();
	}, this);

	this.isUnSpamVisible = ko.computed(function() {
		return this.isSpamFolder() && !this.isSpamDisabled() && !this.isDraftFolder() && !this.isSentFolder();
	}, this);

	this.mobileCheckedStateShow = ko.computed(function() {
		var checked = 0 < this.messageListChecked().length;
		return this.mobile ? checked : true;
	}, this);

	this.mobileCheckedStateHide = ko.computed(function() {
		var checked = 0 < this.messageListChecked().length;
		return this.mobile ? !checked : true;
	}, this);

	this.messageListFocused = ko.computed(function() {
		return Enums.Focused.MessageList === AppStore.focusedState();
	});

	this.canBeMoved = this.hasCheckedOrSelectedLines;

	this.clearCommand = Utils.createCommand(this, function() {
		if (Settings.capa(Enums.Capa.DangerousActions))
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/FolderClear */ 144), [FolderStore.currentFolder()]);
		}
	});

	this.multyForwardCommand = Utils.createCommand(this, function() {
		if (Settings.capa(Enums.Capa.Composer))
		{
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25), [
				Enums.ComposeType.ForwardAsAttachment, MessageStore.messageListCheckedOrSelected()]);
		}
	}, this.canBeMoved);

	this.deleteWithoutMoveCommand = Utils.createCommand(this, function() {
		if (Settings.capa(Enums.Capa.DangerousActions))
		{
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Trash,
				FolderStore.currentFolderFullNameRaw(),
				MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), false);
		}
	}, this.canBeMoved);

	this.deleteCommand = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Trash,
			FolderStore.currentFolderFullNameRaw(),
			MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), true);
	}, this.canBeMoved);

	this.archiveCommand = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Archive,
			FolderStore.currentFolderFullNameRaw(),
			MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), true);
	}, this.canBeMoved);

	this.spamCommand = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Spam,
			FolderStore.currentFolderFullNameRaw(),
			MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), true);
	}, this.canBeMoved);

	this.notSpamCommand = Utils.createCommand(this, function() {
		__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.NotSpam,
			FolderStore.currentFolderFullNameRaw(),
			MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), true);
	}, this.canBeMoved);

	this.moveCommand = Utils.createCommand(this, Utils.noop, this.canBeMoved);

	this.reloadCommand = Utils.createCommand(this, function() {
		if (!MessageStore.messageListCompleteLoadingThrottleForAnimation() && this.allowReload)
		{
			__webpack_require__(/*! App/User */ 8).default.reloadMessageList(false, true);
		}
	});

	this.quotaTooltip = _.bind(this.quotaTooltip, this);

	this.selector = new Selector.Selector(this.messageList, this.selectorMessageSelected, this.selectorMessageFocused,
		'.messageListItem .actionHandle', '.messageListItem.selected', '.messageListItem .checkboxMessage',
			'.messageListItem.focused');

	this.selector.on('onItemSelect', _.bind(function(oMessage) {
		MessageStore.selectMessage(oMessage);
	}, this));

	this.selector.on('onItemGetUid', function(oMessage) {
		return oMessage ? oMessage.generateUid() : '';
	});

	this.selector.on('onAutoSelect', _.bind(function() {
		return this.useAutoSelect();
	}, this));

	this.selector.on('onUpUpOrDownDown', _.bind(function(bV) {
		this.goToUpUpOrDownDown(bV);
	}, this));

	Events.sub('mailbox.message-list.selector.go-down', function(bSelect) {
		this.selector.goDown(bSelect);
	}, this);

	Events.sub('mailbox.message-list.selector.go-up', function(bSelect) {
		this.selector.goUp(bSelect);
	}, this);

	Events.sub('mailbox.message.show', function(sFolder, sUid) {

		var oMessage = _.find(this.messageList(), function(oItem) {
			return oItem && sFolder === oItem.folderFullNameRaw && sUid === oItem.uid;
		});

		if ('INBOX' === sFolder)
		{
			kn.setHash(Links.mailBox(sFolder, 1));
		}

		if (oMessage)
		{
			this.selector.selectMessageItem(oMessage);
		}
		else
		{
			if ('INBOX' !== sFolder)
			{
				kn.setHash(Links.mailBox(sFolder, 1));
			}

			MessageStore.selectMessageByFolderAndUid(sFolder, sUid);
		}

	}, this);

	MessageStore.messageListEndHash.subscribe(function() {
		this.selector.scrollToTop();
	}, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/MailBox/MessageList', 'View/App/MailBox/MessageList', 'MailBoxMessageListViewModel'], MessageListMailBoxUserView);
_.extend(MessageListMailBoxUserView.prototype, AbstractView.prototype);

/**
 * @type {string}
 */
MessageListMailBoxUserView.prototype.emptySubjectValue = '';

MessageListMailBoxUserView.prototype.iGoToUpUpOrDownDownTimeout = 0;

MessageListMailBoxUserView.prototype.hideLeft = function(oItem, oEvent)
{
	oEvent.preventDefault();
	oEvent.stopPropagation();

	Globals.leftPanelDisabled(true);
};

MessageListMailBoxUserView.prototype.showLeft = function(oItem, oEvent)
{
	oEvent.preventDefault();
	oEvent.stopPropagation();

	Globals.leftPanelDisabled(false);
};

MessageListMailBoxUserView.prototype.composeClick = function()
{
	if (Settings.capa(Enums.Capa.Composer))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
	}
};

MessageListMailBoxUserView.prototype.goToUpUpOrDownDown = function(bUp)
{
	var self = this;

	if (0 < this.messageListChecked().length)
	{
		return false;
	}

	window.clearTimeout(this.iGoToUpUpOrDownDownTimeout);
	this.iGoToUpUpOrDownDownTimeout = window.setTimeout(function() {

		var
			oPrev = null,
			oNext = null,
			oTemp = null,
			oCurrent = null,
			aPages = self.messageListPagenator();

		_.find(aPages, function(oItem) {

			if (oItem)
			{
				if (oCurrent)
				{
					oNext = oItem;
				}

				if (oItem.current)
				{
					oCurrent = oItem;
					oPrev = oTemp;
				}

				if (oNext)
				{
					return true;
				}

				oTemp = oItem;
			}

			return false;
		});

		if (Enums.Layout.NoPreview === SettingsStore.layout() && !self.message())
		{
			self.selector.iFocusedNextHelper = bUp ? -1 : 1;
		}
		else
		{
			self.selector.iSelectNextHelper = bUp ? -1 : 1;
		}

		if (bUp ? oPrev : oNext)
		{
			self.selector.unselect();
			self.gotoPage(bUp ? oPrev : oNext);
		}

	}, Enums.Magics.Time350ms);

	return true;
};

MessageListMailBoxUserView.prototype.useAutoSelect = function()
{
	if (this.messageListDisableAutoSelect())
	{
		return false;
	}

	if (/is:unseen/.test(this.mainMessageListSearch()))
	{
		return false;
	}

	return Enums.Layout.NoPreview !== SettingsStore.layout();
};

MessageListMailBoxUserView.prototype.searchEnterAction = function()
{
	this.mainMessageListSearch(this.sLastSearchValue);
	this.inputMessageListSearchFocus(false);
};

/**
 * @returns {string}
 */
MessageListMailBoxUserView.prototype.printableMessageCountForDeletion = function()
{
	var iCnt = this.messageListCheckedOrSelectedUidsWithSubMails().length;
	return 1 < iCnt ? ' (' + (100 > iCnt ? iCnt : '99+') + ')' : ''; // eslint-disable-line no-magic-numbers
};

MessageListMailBoxUserView.prototype.cancelSearch = function()
{
	this.mainMessageListSearch('');
	this.inputMessageListSearchFocus(false);
};

MessageListMailBoxUserView.prototype.cancelThreadUid = function()
{
	kn.setHash(Links.mailBox(
		FolderStore.currentFolderFullNameHash(),
		MessageStore.messageListPageBeforeThread(),
		MessageStore.messageListSearch()
	));
};

/**
 * @param {string} sToFolderFullNameRaw
 * @param {boolean} bCopy
 * @returns {boolean}
 */
MessageListMailBoxUserView.prototype.moveSelectedMessagesToFolder = function(sToFolderFullNameRaw, bCopy)
{
	if (this.canBeMoved())
	{
		__webpack_require__(/*! App/User */ 8).default.moveMessagesToFolder(
			FolderStore.currentFolderFullNameRaw(),
			MessageStore.messageListCheckedOrSelectedUidsWithSubMails(), sToFolderFullNameRaw, bCopy);
	}

	return false;
};

MessageListMailBoxUserView.prototype.dragAndDronHelper = function(oMessageListItem)
{
	if (oMessageListItem)
	{
		oMessageListItem.checked(true);
	}

	var
		oEl = Utils.draggablePlace(),
		updateUidsInfo = function() {
			var aUids = MessageStore.messageListCheckedOrSelectedUidsWithSubMails();
			oEl.data('rl-uids', aUids);
			oEl.find('.text').text('' + aUids.length);
		};

	oEl.data('rl-folder', FolderStore.currentFolderFullNameRaw());

	updateUidsInfo();
	_.defer(updateUidsInfo);

	return oEl;
};

/**
 * @param {string} sFolderFullNameRaw
 * @param {string|bool} mUid
 * @param {number} iSetAction
 * @param {Array=} aMessages = null
 * @returns {void}
 */
MessageListMailBoxUserView.prototype.setAction = function(sFolderFullNameRaw, mUid, iSetAction, aMessages)
{
	__webpack_require__(/*! App/User */ 8).default.messageListAction(sFolderFullNameRaw, mUid, iSetAction, aMessages);
};

/**
 * @param {string} sFolderFullNameRaw
 * @param {number} iSetAction
 * @returns {void}
 */
MessageListMailBoxUserView.prototype.setActionForAll = function(sFolderFullNameRaw, iSetAction)
{
	var
		oFolder = null,
		aMessages = MessageStore.messageList();

	if ('' !== sFolderFullNameRaw)
	{
		oFolder = Cache.getFolderFromCacheList(sFolderFullNameRaw);

		if (oFolder)
		{
			switch (iSetAction)
			{
				case Enums.MessageSetAction.SetSeen:
					oFolder = Cache.getFolderFromCacheList(sFolderFullNameRaw);
					if (oFolder)
					{
						_.each(aMessages, function(oMessage) {
							oMessage.unseen(false);
						});

						oFolder.messageCountUnread(0);
						Cache.clearMessageFlagsFromCacheByFolder(sFolderFullNameRaw);
					}

					Remote.messageSetSeenToAll(Utils.noop, sFolderFullNameRaw, true);
					break;
				case Enums.MessageSetAction.UnsetSeen:
					oFolder = Cache.getFolderFromCacheList(sFolderFullNameRaw);
					if (oFolder)
					{
						_.each(aMessages, function(oMessage) {
							oMessage.unseen(true);
						});

						oFolder.messageCountUnread(oFolder.messageCountAll());
						Cache.clearMessageFlagsFromCacheByFolder(sFolderFullNameRaw);
					}
					Remote.messageSetSeenToAll(Utils.noop, sFolderFullNameRaw, false);
					break;
				// no default
			}

			__webpack_require__(/*! App/User */ 8).default.reloadFlagsCurrentMessageListAndMessageFromCache();
		}
	}
};

MessageListMailBoxUserView.prototype.listSetSeen = function()
{
	this.setAction(FolderStore.currentFolderFullNameRaw(), true,
		Enums.MessageSetAction.SetSeen, MessageStore.messageListCheckedOrSelected());
};

MessageListMailBoxUserView.prototype.listSetAllSeen = function()
{
	this.setActionForAll(FolderStore.currentFolderFullNameRaw(), Enums.MessageSetAction.SetSeen);
};

MessageListMailBoxUserView.prototype.listUnsetSeen = function()
{
	this.setAction(FolderStore.currentFolderFullNameRaw(), true,
		Enums.MessageSetAction.UnsetSeen, MessageStore.messageListCheckedOrSelected());
};

MessageListMailBoxUserView.prototype.listSetFlags = function()
{
	this.setAction(FolderStore.currentFolderFullNameRaw(), true,
		Enums.MessageSetAction.SetFlag, MessageStore.messageListCheckedOrSelected());
};

MessageListMailBoxUserView.prototype.listUnsetFlags = function()
{
	this.setAction(FolderStore.currentFolderFullNameRaw(), true,
		Enums.MessageSetAction.UnsetFlag, MessageStore.messageListCheckedOrSelected());
};

MessageListMailBoxUserView.prototype.flagMessages = function(oCurrentMessage)
{
	var
		aChecked = this.messageListCheckedOrSelected(),
		aCheckedUids = [];

	if (oCurrentMessage)
	{
		if (0 < aChecked.length)
		{
			aCheckedUids = _.map(aChecked, function(oMessage) {
				return oMessage.uid;
			});
		}

		if (0 < aCheckedUids.length && -1 < Utils.inArray(oCurrentMessage.uid, aCheckedUids))
		{
			this.setAction(oCurrentMessage.folderFullNameRaw, true, oCurrentMessage.flagged() ?
				Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, aChecked);
		}
		else
		{
			this.setAction(oCurrentMessage.folderFullNameRaw, true, oCurrentMessage.flagged() ?
				Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, [oCurrentMessage]);
		}
	}
};

MessageListMailBoxUserView.prototype.flagMessagesFast = function(bFlag)
{
	var
		aChecked = this.messageListCheckedOrSelected(),
		aFlagged = [];

	if (0 < aChecked.length)
	{
		aFlagged = _.filter(aChecked, function(oMessage) {
			return oMessage.flagged();
		});

		if (Utils.isUnd(bFlag))
		{
			this.setAction(aChecked[0].folderFullNameRaw, true,
				aChecked.length === aFlagged.length ? Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, aChecked);
		}
		else
		{
			this.setAction(aChecked[0].folderFullNameRaw, true,
				!bFlag ? Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, aChecked);
		}
	}
};

MessageListMailBoxUserView.prototype.seenMessagesFast = function(bSeen)
{
	var
		aChecked = this.messageListCheckedOrSelected(),
		aUnseen = [];

	if (0 < aChecked.length)
	{
		aUnseen = _.filter(aChecked, function(oMessage) {
			return oMessage.unseen();
		});

		if (Utils.isUnd(bSeen))
		{
			this.setAction(aChecked[0].folderFullNameRaw, true,
				0 < aUnseen.length ? Enums.MessageSetAction.SetSeen : Enums.MessageSetAction.UnsetSeen, aChecked);
		}
		else
		{
			this.setAction(aChecked[0].folderFullNameRaw, true,
				bSeen ? Enums.MessageSetAction.SetSeen : Enums.MessageSetAction.UnsetSeen, aChecked);
		}
	}
};

MessageListMailBoxUserView.prototype.gotoPage = function(oPage)
{
	if (oPage)
	{
		kn.setHash(Links.mailBox(
			FolderStore.currentFolderFullNameHash(),
			oPage.value,
			MessageStore.messageListSearch(),
			MessageStore.messageListThreadUid()
		));
	}
};

MessageListMailBoxUserView.prototype.gotoThread = function(oMessage)
{
	if (oMessage && 0 < oMessage.threadsLen())
	{
		MessageStore.messageListPageBeforeThread(MessageStore.messageListPage());

		kn.setHash(Links.mailBox(
			FolderStore.currentFolderFullNameHash(),
			1,
			MessageStore.messageListSearch(),
			oMessage.uid
		));
	}
};

MessageListMailBoxUserView.prototype.clearListIsVisible = function()
{
	return '' === this.messageListSearchDesc() && '' === this.messageListError() &&
		'' === MessageStore.messageListEndThreadUid() &&
		0 < this.messageList().length && (this.isSpamFolder() || this.isTrashFolder());
};

MessageListMailBoxUserView.prototype.onBuild = function(oDom)
{
	var self = this;

	this.oContentVisible = $('.b-content', oDom);
	this.oContentScrollable = $('.content', this.oContentVisible);

	this.selector.init(this.oContentVisible, this.oContentScrollable, Enums.KeyState.MessageList);

	if (this.mobile)
	{
		oDom
			.on('click', function() {
				Globals.leftPanelDisabled(true);
			});
	}

	oDom
		.on('click', '.messageList .b-message-list-wrapper', function() {
			if (Enums.Focused.MessageView === AppStore.focusedState())
			{
				AppStore.focusedState(Enums.Focused.MessageList);
			}
		})
		.on('click', '.e-pagenator .e-page', function() {
			self.gotoPage(ko.dataFor(this));
		})
		.on('click', '.messageList .checkboxCkeckAll', function() {
			self.checkAll(!self.checkAll());
		})
		.on('click', '.messageList .messageListItem .flagParent', function() {
			self.flagMessages(ko.dataFor(this));
		})
		.on('click', '.messageList .messageListItem .threads-len', function() {
			self.gotoThread(ko.dataFor(this));
		})
		.on('dblclick', '.messageList .messageListItem .actionHandle', function() {
			self.gotoThread(ko.dataFor(this));
		});

	this.initUploaderForAppend();
	this.initShortcuts();

	if (!Globals.bMobileDevice && ifvisible && Settings.capa(Enums.Capa.Prefetch))
	{
		ifvisible.setIdleDuration(Enums.Magics.ifvisibleIdle10s);

		ifvisible.idle(function() {
			self.prefetchNextTick();
		});
	}
};

MessageListMailBoxUserView.prototype.initShortcuts = function()
{
	var self = this;

	key('enter', Enums.KeyState.MessageList, function() {
		if (self.message() && self.useAutoSelect())
		{
			Events.pub('mailbox.message-view.toggle-full-screen');
			return false;
		}

		return true;
	});

	if (Settings.capa(Enums.Capa.MessageListActions))
	{
		// archive (zip)
		key('z', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.archiveCommand();
			return false;
		});

		// delete
		key('delete, shift+delete, shift+3', Enums.KeyState.MessageList, function(event, handler) {
			if (event)
			{
				if (0 < MessageStore.messageListCheckedOrSelected().length)
				{
					if (handler && 'shift+delete' === handler.shortcut)
					{
						self.deleteWithoutMoveCommand();
					}
					else
					{
						self.deleteCommand();
					}
				}

				return false;
			}

			return true;
		});
	}

	if (Settings.capa(Enums.Capa.Reload))
	{
		// check mail
		key('ctrl+r, command+r', [Enums.KeyState.FolderList, Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.reloadCommand();
			return false;
		});
	}

	// check all
	key('ctrl+a, command+a', Enums.KeyState.MessageList, function() {
		self.checkAll(!(self.checkAll() && !self.isIncompleteChecked()));
		return false;
	});

	if (Settings.capa(Enums.Capa.Composer))
	{
		// write/compose (open compose popup)
		key('w,c', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
			return false;
		});
	}

	if (Settings.capa(Enums.Capa.MessageListActions))
	{
		// important - star/flag messages
		key('i', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.flagMessagesFast();
			return false;
		});
	}

	key('t', [Enums.KeyState.MessageList], function() {

		var oMessage = self.selectorMessageSelected();
		if (!oMessage)
		{
			oMessage = self.selectorMessageFocused();
		}

		if (oMessage && 0 < oMessage.threadsLen())
		{
			self.gotoThread(oMessage);
		}

		return false;
	});

	if (Settings.capa(Enums.Capa.MessageListActions))
	{
		// move
		key('m', Enums.KeyState.MessageList, function() {
			self.moveDropdownTrigger(true);
			return false;
		});
	}

	if (Settings.capa(Enums.Capa.MessageListActions))
	{
		// read
		key('q', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.seenMessagesFast(true);
			return false;
		});

		// unread
		key('u', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.seenMessagesFast(false);
			return false;
		});
	}

	if (Settings.capa(Enums.Capa.Composer))
	{
		key('shift+f', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.multyForwardCommand();
			return false;
		});
	}

	if (Settings.capa(Enums.Capa.Search))
	{
		// search input focus
		key('/', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
			self.inputMessageListSearchFocus(true);
			return false;
		});
	}

	// cancel search
	key('esc', Enums.KeyState.MessageList, function() {
		if ('' !== self.messageListSearchDesc())
		{
			self.cancelSearch();
			return false;
		}
		else if ('' !== self.messageListEndThreadUid())
		{
			self.cancelThreadUid();
			return false;
		}

		return true;
	});

	// change focused state
	key('tab, shift+tab, left, right', Enums.KeyState.MessageList, function(event, handler) {
		if (event && handler && ('shift+tab' === handler.shortcut || 'left' === handler.shortcut))
		{
			AppStore.focusedState(Enums.Focused.FolderList);
		}
		else if (self.message())
		{
			AppStore.focusedState(Enums.Focused.MessageView);
		}

		return false;
	});

	key('ctrl+left, command+left', Enums.KeyState.MessageView, function() {
		return false;
	});

	key('ctrl+right, command+right', Enums.KeyState.MessageView, function() {
		return false;
	});
};

MessageListMailBoxUserView.prototype.prefetchNextTick = function()
{
	if (ifvisible && !this.bPrefetch && !ifvisible.now() && this.viewModelVisibility())
	{
		var
			self = this,
			oMessage = _.find(this.messageList(), function(oItem) {
				return oItem && !Cache.hasRequestedMessage(oItem.folderFullNameRaw, oItem.uid);
			});

		if (oMessage)
		{
			this.bPrefetch = true;

			Cache.addRequestedMessage(oMessage.folderFullNameRaw, oMessage.uid);

			Remote.message(function(sResult, oData) {

				var bNext = !!(Enums.StorageResultType.Success === sResult && oData && oData.Result);

				_.delay(function() {
					self.bPrefetch = false;
					if (bNext)
					{
						self.prefetchNextTick();
					}
				}, Enums.Magics.Time1s);

			}, oMessage.folderFullNameRaw, oMessage.uid);
		}
	}
};

MessageListMailBoxUserView.prototype.composeClick = function()
{
	if (Settings.capa(Enums.Capa.Composer))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
	}
};

MessageListMailBoxUserView.prototype.advancedSearchClick = function()
{
	if (Settings.capa(Enums.Capa.SearchAdv))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/AdvancedSearch */ 141), [this.mainMessageListSearch()]);
	}
};

MessageListMailBoxUserView.prototype.quotaTooltip = function()
{
	return Translator.i18n('MESSAGE_LIST/QUOTA_SIZE', {
		'SIZE': Utils.friendlySize(this.userUsageSize()),
		'PROC': this.userUsageProc(),
		'LIMIT': Utils.friendlySize(this.userQuota())
	});
};

MessageListMailBoxUserView.prototype.initUploaderForAppend = function()
{
	if (!Settings.appSettingsGet('allowAppendMessage') || !this.dragOverArea())
	{
		return false;
	}

	var
		oJua = new Jua({
			action: Links.append(),
			name: 'AppendFile',
			queueSize: 1,
			multipleSizeLimit: 1,
			hidden: {
				Folder: function() {
					return FolderStore.currentFolderFullNameRaw();
				}
			},
			dragAndDropElement: this.dragOverArea(),
			dragAndDropBodyElement: this.dragOverBodyArea()
		});

	this.dragOver.subscribe(function(bValue) {
		if (bValue)
		{
			this.selector.scrollToTop();
		}
	}, this);

	oJua
		.on('onDragEnter', _.bind(function() {
			this.dragOverEnter(true);
		}, this))
		.on('onDragLeave', _.bind(function() {
			this.dragOverEnter(false);
		}, this))
		.on('onBodyDragEnter', _.bind(function() {
			this.dragOver(true);
		}, this))
		.on('onBodyDragLeave', _.bind(function() {
			this.dragOver(false);
		}, this))
		.on('onSelect', _.bind(function(sUid, oData) {

			if (sUid && oData && 'message/rfc822' === oData.Type)
			{
				MessageStore.messageListLoading(true);
				return true;
			}

			return false;

		}, this))
		.on('onComplete', _.bind(function() {
			__webpack_require__(/*! App/User */ 8).default.reloadMessageList(true, true);
		}, this));

	return !!oJua;
};

module.exports = MessageListMailBoxUserView;


/***/ },
/* 154 */
/*!**********************************************!*\
  !*** ./dev/View/User/MailBox/MessageView.js ***!
  \**********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Events = __webpack_require__(/*! Common/Events */ 23),
	Translator = __webpack_require__(/*! Common/Translator */ 6),
	Audio = __webpack_require__(/*! Common/Audio */ 67),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Cache = __webpack_require__(/*! Common/Cache */ 19),

	SocialStore = __webpack_require__(/*! Stores/Social */ 34),
	AppStore = __webpack_require__(/*! Stores/User/App */ 22),
	SettingsStore = __webpack_require__(/*! Stores/User/Settings */ 24),
	AccountStore = __webpack_require__(/*! Stores/User/Account */ 28),
	FolderStore = __webpack_require__(/*! Stores/User/Folder */ 20),
	MessageStore = __webpack_require__(/*! Stores/User/Message */ 29),

	Local = __webpack_require__(/*! Storage/Client */ 47),
	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/User/Ajax */ 14),

	Promises = __webpack_require__(/*! Promises/User/Ajax */ 42),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function MessageViewMailBoxUserView()
{
	AbstractView.call(this, 'Right', 'MailMessageView');

	var
		self = this,
		sLastEmail = '',
		createCommandHelper = function(sType) {
			return Utils.createCommand(self, function() {
				this.lastReplyAction(sType);
				this.replyOrforward(sType);
			}, self.canBeRepliedOrForwarded);
		};

	this.oDom = null;
	this.oHeaderDom = null;
	this.oMessageScrollerDom = null;

	this.bodyBackgroundColor = ko.observable('');

	this.pswp = null;

	this.allowComposer = !!Settings.capa(Enums.Capa.Composer);
	this.allowMessageActions = !!Settings.capa(Enums.Capa.MessageActions);
	this.allowMessageListActions = !!Settings.capa(Enums.Capa.MessageListActions);

	this.logoImg = Utils.trim(Settings.settingsGet('UserLogoMessage'));
	this.logoIframe = Utils.trim(Settings.settingsGet('UserIframeMessage'));

	this.mobile = !!Settings.appSettingsGet('mobile');

	this.attachmentsActions = AppStore.attachmentsActions;

	this.message = MessageStore.message;
	this.messageListChecked = MessageStore.messageListChecked;
	this.hasCheckedMessages = MessageStore.hasCheckedMessages;
	this.messageListCheckedOrSelectedUidsWithSubMails = MessageStore.messageListCheckedOrSelectedUidsWithSubMails;
	this.messageLoadingThrottle = MessageStore.messageLoadingThrottle;
	this.messagesBodiesDom = MessageStore.messagesBodiesDom;
	this.useThreads = SettingsStore.useThreads;
	this.replySameFolder = SettingsStore.replySameFolder;
	this.layout = SettingsStore.layout;
	this.usePreviewPane = SettingsStore.usePreviewPane;
	this.isMessageSelected = MessageStore.isMessageSelected;
	this.messageActiveDom = MessageStore.messageActiveDom;
	this.messageError = MessageStore.messageError;

	this.fullScreenMode = MessageStore.messageFullScreenMode;

	this.messageListOfThreadsLoading = ko.observable(false).extend({'rateLimit': 1});

	this.highlightUnselectedAttachments = ko.observable(false).extend({'falseTimeout': 2000});

	this.showAttachmnetControls = ko.observable(false);

	this.allowAttachmnetControls = ko.computed(function() {
		return 0 < this.attachmentsActions().length &&
			Settings.capa(Enums.Capa.AttachmentsActions);
	}, this);

	this.downloadAsZipAllowed = ko.computed(function() {
		return -1 < Utils.inArray('zip', this.attachmentsActions()) &&
			this.allowAttachmnetControls();
	}, this);

	this.downloadAsZipLoading = ko.observable(false);
	this.downloadAsZipError = ko.observable(false).extend({'falseTimeout': 7000});

	this.saveToOwnCloudAllowed = ko.computed(function() {
		return -1 < Utils.inArray('owncloud', this.attachmentsActions()) &&
			this.allowAttachmnetControls();
	}, this);

	this.saveToOwnCloudLoading = ko.observable(false);
	this.saveToOwnCloudSuccess = ko.observable(false).extend({'falseTimeout': 2000});
	this.saveToOwnCloudError = ko.observable(false).extend({'falseTimeout': 7000});

	this.saveToOwnCloudSuccess.subscribe(function(bV) {
		if (bV)
		{
			this.saveToOwnCloudError(false);
		}
	}, this);

	this.saveToOwnCloudError.subscribe(function(bV) {
		if (bV)
		{
			this.saveToOwnCloudSuccess(false);
		}
	}, this);

	this.saveToDropboxAllowed = ko.computed(function() {
		return -1 < Utils.inArray('dropbox', this.attachmentsActions()) &&
			this.allowAttachmnetControls();
	}, this);

	this.saveToDropboxLoading = ko.observable(false);
	this.saveToDropboxSuccess = ko.observable(false).extend({'falseTimeout': 2000});
	this.saveToDropboxError = ko.observable(false).extend({'falseTimeout': 7000});

	this.saveToDropboxSuccess.subscribe(function(bV) {
		if (bV)
		{
			this.saveToDropboxError(false);
		}
	}, this);

	this.saveToDropboxError.subscribe(function(bV) {
		if (bV)
		{
			this.saveToDropboxSuccess(false);
		}
	}, this);

	this.showAttachmnetControls.subscribe(function(bV) {
		if (this.message())
		{
			_.each(this.message().attachments(), function(oItem) {
				if (oItem)
				{
					oItem.checked(!!bV);
				}
			});
		}
	}, this);

	this.lastReplyAction_ = ko.observable('');
	this.lastReplyAction = ko.computed({
		read: this.lastReplyAction_,
		write: function(sValue) {
			sValue = -1 === Utils.inArray(sValue, [
				Enums.ComposeType.Reply, Enums.ComposeType.ReplyAll, Enums.ComposeType.Forward
			]) ? Enums.ComposeType.Reply : sValue;
			this.lastReplyAction_(sValue);
		},
		owner: this
	});

	this.lastReplyAction(Local.get(Enums.ClientSideKeyName.LastReplyAction) || Enums.ComposeType.Reply);
	this.lastReplyAction_.subscribe(function(sValue) {
		Local.set(Enums.ClientSideKeyName.LastReplyAction, sValue);
	});

	this.showFullInfo = ko.observable('1' === Local.get(Enums.ClientSideKeyName.MessageHeaderFullInfo));
	this.moreDropdownTrigger = ko.observable(false);
	this.messageDomFocused = ko.observable(false).extend({'rateLimit': 0});

	this.messageVisibility = ko.computed(function() {
		return !this.messageLoadingThrottle() && !!this.message();
	}, this);

	this.message.subscribe(function(oMessage) {
		if (!oMessage)
		{
			MessageStore.selectorMessageSelected(null);
		}
	}, this);

	this.canBeRepliedOrForwarded = ko.computed(function() {
		var bV = this.messageVisibility();
		return !this.isDraftFolder() && bV;
	}, this);

	// commands
	this.closeMessage = Utils.createCommand(this, function() {
		MessageStore.message(null);
	});

	this.replyCommand = createCommandHelper(Enums.ComposeType.Reply);
	this.replyAllCommand = createCommandHelper(Enums.ComposeType.ReplyAll);
	this.forwardCommand = createCommandHelper(Enums.ComposeType.Forward);
	this.forwardAsAttachmentCommand = createCommandHelper(Enums.ComposeType.ForwardAsAttachment);
	this.editAsNewCommand = createCommandHelper(Enums.ComposeType.EditAsNew);

	this.messageVisibilityCommand = Utils.createCommand(this, Utils.noop, this.messageVisibility);

	this.messageEditCommand = Utils.createCommand(this, function() {
		this.editMessage();
	}, this.messageVisibility);

	this.deleteCommand = Utils.createCommand(this, function() {
		var oMessage = this.message();
		if (oMessage && this.allowMessageListActions)
		{
			this.message(null);
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Trash,
				oMessage.folderFullNameRaw, [oMessage.uid], true);
		}
	}, this.messageVisibility);

	this.deleteWithoutMoveCommand = Utils.createCommand(this, function() {
		var oMessage = this.message();
		if (oMessage && this.allowMessageListActions)
		{
			this.message(null);
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Trash,
				oMessage.folderFullNameRaw, [oMessage.uid], false);
		}
	}, this.messageVisibility);

	this.archiveCommand = Utils.createCommand(this, function() {
		var oMessage = this.message();
		if (oMessage && this.allowMessageListActions)
		{
			this.message(null);
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Archive,
				oMessage.folderFullNameRaw, [oMessage.uid], true);
		}
	}, this.messageVisibility);

	this.spamCommand = Utils.createCommand(this, function() {
		var oMessage = this.message();
		if (oMessage && this.allowMessageListActions)
		{
			this.message(null);
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.Spam,
				oMessage.folderFullNameRaw, [oMessage.uid], true);
		}
	}, this.messageVisibility);

	this.notSpamCommand = Utils.createCommand(this, function() {
		var oMessage = this.message();
		if (oMessage && this.allowMessageListActions)
		{
			this.message(null);
			__webpack_require__(/*! App/User */ 8).default.deleteMessagesFromFolder(Enums.FolderType.NotSpam,
				oMessage.folderFullNameRaw, [oMessage.uid], true);
		}
	}, this.messageVisibility);

	this.dropboxEnabled = SocialStore.dropbox.enabled;
	this.dropboxApiKey = SocialStore.dropbox.apiKey;

	// viewer

	this.viewBodyTopValue = ko.observable(0);

	this.viewFolder = '';
	this.viewUid = '';
	this.viewHash = '';
	this.viewSubject = ko.observable('');
	this.viewFromShort = ko.observable('');
	this.viewFromDkimData = ko.observable(['none', '']);
	this.viewToShort = ko.observable('');
	this.viewFrom = ko.observable('');
	this.viewTo = ko.observable('');
	this.viewCc = ko.observable('');
	this.viewBcc = ko.observable('');
	this.viewReplyTo = ko.observable('');
	this.viewTimeStamp = ko.observable(0);
	this.viewSize = ko.observable('');
	this.viewLineAsCss = ko.observable('');
	this.viewViewLink = ko.observable('');
	this.viewDownloadLink = ko.observable('');
	this.viewUserPic = ko.observable(Consts.DATA_IMAGE_USER_DOT_PIC);
	this.viewUserPicVisible = ko.observable(false);
	this.viewIsImportant = ko.observable(false);
	this.viewIsFlagged = ko.observable(false);

	this.viewFromDkimVisibility = ko.computed(function() {
		return 'none' !== this.viewFromDkimData()[0];
	}, this);

	this.viewFromDkimStatusIconClass = ko.computed(function() {

		var sResult = 'icon-none iconcolor-display-none';
//			var sResult = 'icon-warning-alt iconcolor-grey';
		switch (this.viewFromDkimData()[0])
		{
			case 'none':
				break;
			case 'pass':
				sResult = 'icon-ok iconcolor-green';
//					sResult = 'icon-warning-alt iconcolor-green';
				break;
			default:
				sResult = 'icon-warning-alt iconcolor-red';
				break;
			// no default
		}

		return sResult;

	}, this);

	this.viewFromDkimStatusTitle = ko.computed(function() {

		var aStatus = this.viewFromDkimData();
		if (Utils.isNonEmptyArray(aStatus))
		{
			if (aStatus[0] && aStatus[1])
			{
				return aStatus[1];
			}
			else if (aStatus[0])
			{
				return 'DKIM: ' + aStatus[0];
			}
		}

		return '';

	}, this);

	this.messageActiveDom.subscribe(function(oDom) {
		this.bodyBackgroundColor(oDom ? this.detectDomBackgroundColor(oDom) : '');
	}, this);

	this.message.subscribe(function(oMessage) {

		this.messageActiveDom(null);

		if (oMessage)
		{
			this.showAttachmnetControls(false);

			if (this.viewHash !== oMessage.hash)
			{
				this.scrollMessageToTop();
			}

			this.viewFolder = oMessage.folderFullNameRaw;
			this.viewUid = oMessage.uid;
			this.viewHash = oMessage.hash;
			this.viewSubject(oMessage.subject());
			this.viewFromShort(oMessage.fromToLine(true, true));
			this.viewFromDkimData(oMessage.fromDkimData());
			this.viewToShort(oMessage.toToLine(true, true));
			this.viewFrom(oMessage.fromToLine(false));
			this.viewTo(oMessage.toToLine(false));
			this.viewCc(oMessage.ccToLine(false));
			this.viewBcc(oMessage.bccToLine(false));
			this.viewReplyTo(oMessage.replyToToLine(false));
			this.viewTimeStamp(oMessage.dateTimeStampInUTC());
			this.viewSize(oMessage.friendlySize());
			this.viewLineAsCss(oMessage.lineAsCss());
			this.viewViewLink(oMessage.viewLink());
			this.viewDownloadLink(oMessage.downloadLink());
			this.viewIsImportant(oMessage.isImportant());
			this.viewIsFlagged(oMessage.flagged());

			sLastEmail = oMessage.fromAsSingleEmail();
			Cache.getUserPic(sLastEmail, function(sPic, sEmail) {
				if (sPic !== self.viewUserPic() && sLastEmail === sEmail)
				{
					self.viewUserPicVisible(false);
					self.viewUserPic(Consts.DATA_IMAGE_USER_DOT_PIC);
					if ('' !== sPic)
					{
						self.viewUserPicVisible(true);
						self.viewUserPic(sPic);
					}
				}
			});
		}
		else
		{
			this.viewFolder = '';
			this.viewUid = '';
			this.viewHash = '';

			this.scrollMessageToTop();
		}

	}, this);

	this.message.viewTrigger.subscribe(function() {
		var oMessage = this.message();
		if (oMessage)
		{
			this.viewIsFlagged(oMessage.flagged());
		}
		else
		{
			this.viewIsFlagged(false);
		}
	}, this);

	this.fullScreenMode.subscribe(function(bValue) {
		Globals.$html.toggleClass('rl-message-fullscreen', bValue);
		Utils.windowResize();
	});

	this.messageLoadingThrottle.subscribe(Utils.windowResizeCallback);

	this.messageFocused = ko.computed(function() {
		return Enums.Focused.MessageView === AppStore.focusedState();
	});

	this.messageListAndMessageViewLoading = ko.computed(function() {
		return MessageStore.messageListCompleteLoadingThrottle() || MessageStore.messageLoadingThrottle();
	});

	this.goUpCommand = Utils.createCommand(this, function() {
		Events.pub('mailbox.message-list.selector.go-up', [
			Enums.Layout.NoPreview === this.layout() ? !!this.message() : true
		]);
	}, function() {
		return !this.messageListAndMessageViewLoading();
	});

	this.goDownCommand = Utils.createCommand(this, function() {
		Events.pub('mailbox.message-list.selector.go-down', [
			Enums.Layout.NoPreview === this.layout() ? !!this.message() : true
		]);
	}, function() {
		return !this.messageListAndMessageViewLoading();
	});

	Events.sub('mailbox.message-view.toggle-full-screen', function() {
		this.toggleFullScreen();
	}, this);

	this.attachmentPreview = _.bind(this.attachmentPreview, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/MailBox/MessageView', 'View/App/MailBox/MessageView', 'MailBoxMessageViewViewModel'], MessageViewMailBoxUserView);
_.extend(MessageViewMailBoxUserView.prototype, AbstractView.prototype);

MessageViewMailBoxUserView.prototype.detectDomBackgroundColor = function(oDom)
{
	var
		iLimit = 5,
		sResult = '',
		aC = null,
		fFindDom = function(oInputDom) {
			var children = oInputDom ? oInputDom.children() : null;
			return (children && 1 === children.length && children.is('table,div,center')) ? children : null;
		},
		fFindColor = function(oInputDom) {
			var color = '';
			if (oInputDom)
			{
				color = oInputDom.css('background-color') || '';
				if (!oInputDom.is('table'))
				{
					color = 'rgba(0, 0, 0, 0)' === color || 'transparent' === color ? '' : color;
				}
			}

			return color;
		};

	if (oDom && 1 === oDom.length)
	{
		aC = oDom;
		while ('' === sResult)
		{
			iLimit -= 1;
			if (0 >= iLimit)
			{
				break;
			}

			aC = fFindDom(aC);
			if (aC)
			{
				sResult = fFindColor(aC);
			}
			else
			{
				break;
			}
		}

		sResult = 'rgba(0, 0, 0, 0)' === sResult || 'transparent' === sResult ? '' : sResult;
	}

	return sResult;
};

MessageViewMailBoxUserView.prototype.fullScreen = function()
{
	this.fullScreenMode(true);
	Utils.windowResize();
};

MessageViewMailBoxUserView.prototype.unFullScreen = function()
{
	this.fullScreenMode(false);
	Utils.windowResize();
};

MessageViewMailBoxUserView.prototype.toggleFullScreen = function()
{
	Utils.removeSelection();

	this.fullScreenMode(!this.fullScreenMode());
	Utils.windowResize();
};

/**
 * @param {string} sType
 * @returns {void}
 */
MessageViewMailBoxUserView.prototype.replyOrforward = function(sType)
{
	if (Settings.capa(Enums.Capa.Composer))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25), [sType, MessageStore.message()]);
	}
};

MessageViewMailBoxUserView.prototype.checkHeaderHeight = function()
{
	if (this.oHeaderDom)
	{
		this.viewBodyTopValue(this.message() ? this.oHeaderDom.height() +
			Enums.Magics.Size20px /* padding-(top/bottom): 20px */ + Enums.Magics.Size1px /* borded-bottom: 1px */ : 0);
	}
};

//	MessageViewMailBoxUserView.prototype.displayMailToPopup = function(sMailToUrl)
//	{
//		sMailToUrl = sMailToUrl.replace(/\?.+$/, '');
//
//		var
//			sResult = '',
//			aTo = [],
//			EmailModel = require('Model/Email').default,
//			fParseEmailLine = function(sLine) {
//				return sLine ? _.compact(_.map([window.decodeURIComponent(sLine)], function(sItem) {
//						var oEmailModel = new EmailModel();
//						oEmailModel.mailsoParse(sItem);
//						return '' !== oEmailModel.email ? oEmailModel : null;
//					})) : null;
//			}
//		;
//
//		aTo = fParseEmailLine(sMailToUrl);
//		sResult = aTo && aTo[0] ? aTo[0].email : '';
//
//		return sResult;
//	};

/**
 * @param {Object} oAttachment
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.attachmentPreview = function(oAttachment)
{
	if (oAttachment && oAttachment.isImage() && !oAttachment.isLinked && this.message() && this.message().attachments())
	{
		var
			oDiv = $('<div>'),
			iIndex = 0,
			iListIndex = 0,
			aDynamicEl = _.compact(_.map(this.message().attachments(), function(oItem) {
				if (oItem && !oItem.isLinked && oItem.isImage())
				{
					if (oItem === oAttachment)
					{
						iIndex = iListIndex;
					}

					iListIndex += 1;

					return {
						src: oItem.linkPreview(),
						thumb: oItem.linkThumbnail(),
						subHtml: oItem.fileName,
						downloadUrl: oItem.linkPreview()
					};
				}

				return null;
			}));

		if (0 < aDynamicEl.length)
		{
			oDiv.on('onBeforeOpen.lg', function() {
				Globals.useKeyboardShortcuts(false);
				Utils.removeInFocus(true);
			});

			oDiv.on('onCloseAfter.lg', function() {
				Globals.useKeyboardShortcuts(true);
			});

			oDiv.lightGallery({
				dynamic: true,
				loadYoutubeThumbnail: false,
				loadVimeoThumbnail: false,
				thumbWidth: 80,
				thumbContHeight: 95,
				showThumbByDefault: false,
				mode: 'lg-lollipop', // 'lg-slide',
				index: iIndex,
				dynamicEl: aDynamicEl
			});
		}

		return false;
	}

	return true;
};

MessageViewMailBoxUserView.prototype.onBuild = function(oDom)
{
	var
		self = this,
		oScript = null,
//			sErrorMessage = Translator.i18n('PREVIEW_POPUP/IMAGE_ERROR'),
		fCheckHeaderHeight = _.bind(this.checkHeaderHeight, this);

	this.oDom = oDom;

	this.fullScreenMode.subscribe(function(bValue) {
		if (bValue && self.message())
		{
			AppStore.focusedState(Enums.Focused.MessageView);
		}
	}, this);

	this.showAttachmnetControls.subscribe(fCheckHeaderHeight);
	this.fullScreenMode.subscribe(fCheckHeaderHeight);
	this.showFullInfo.subscribe(fCheckHeaderHeight);
	this.message.subscribe(fCheckHeaderHeight);

	Events.sub('window.resize', _.throttle(function() {
		_.delay(fCheckHeaderHeight, 1);
		_.delay(fCheckHeaderHeight, Enums.Magics.Time200ms);
		_.delay(fCheckHeaderHeight, Enums.Magics.Time500ms);
	}, Enums.Magics.Time50ms));

	this.showFullInfo.subscribe(function(value) {
		Utils.windowResize();
		Utils.windowResize(Enums.Magics.Time200ms);
		Local.set(Enums.ClientSideKeyName.MessageHeaderFullInfo, value ? '1' : '0');
	});

	if (this.dropboxEnabled() && this.dropboxApiKey() && !window.Dropbox)
	{
		oScript = window.document.createElement('script');
		oScript.type = 'text/javascript';
		oScript.src = 'https://www.dropbox.com/static/api/2/dropins.js';
		$(oScript).attr('id', 'dropboxjs').attr('data-app-key', self.dropboxApiKey());

		window.document.body.appendChild(oScript);
	}

	this.oHeaderDom = $('.messageItemHeader', oDom);
	this.oHeaderDom = this.oHeaderDom[0] ? this.oHeaderDom : null;

	if (this.mobile)
	{
		oDom
			.on('click', function() {
				Globals.leftPanelDisabled(true);
			});
	}

	oDom
		.on('click', 'a', function(oEvent) {
			// setup maito protocol
			return !(!!oEvent && Enums.Magics.EventWhichMouseMiddle !== oEvent.which && Utils.mailToHelper(
				$(this).attr('href'), Settings.capa(Enums.Capa.Composer) ? __webpack_require__(/*! View/Popup/Compose */ 25) : null
			));
		})
//			.on('mouseover', 'a', _.debounce(function(oEvent) {
//
//				if (oEvent)
//				{
//					var sMailToUrl = $(this).attr('href');
//					if (sMailToUrl && 'mailto:' === sMailToUrl.toString().substr(0, 7).toLowerCase())
//					{
//						sMailToUrl = sMailToUrl.toString().substr(7);
//						self.displayMailToPopup(sMailToUrl);
//					}
//				}
//
//				return true;
//
//			}, 1000))
		.on('click', '.attachmentsPlace .attachmentIconParent', function(oEvent) {
			if (oEvent && oEvent.stopPropagation)
			{
				oEvent.stopPropagation();
			}
		})
		.on('click', '.attachmentsPlace .showPreplay', function(oEvent) {
			if (oEvent && oEvent.stopPropagation)
			{
				oEvent.stopPropagation();
			}

			var oAttachment = ko.dataFor(this);
			if (oAttachment && Audio.supported)
			{
				switch (true)
				{
					case Audio.supportedMp3 && oAttachment.isMp3():
						Audio.playMp3(oAttachment.linkDownload(), oAttachment.fileName);
						break;
					case Audio.supportedOgg && oAttachment.isOgg():
						Audio.playOgg(oAttachment.linkDownload(), oAttachment.fileName);
						break;
					case Audio.supportedWav && oAttachment.isWav():
						Audio.playWav(oAttachment.linkDownload(), oAttachment.fileName);
						break;
					// no default
				}
			}
		})
		.on('click', '.attachmentsPlace .attachmentItem .attachmentNameParent', function() {

			var
				oAttachment = ko.dataFor(this);

			if (oAttachment && oAttachment.download)
			{
				__webpack_require__(/*! App/User */ 8).default.download(oAttachment.linkDownload());
			}
		})
		.on('click', '.messageItemHeader .subjectParent .flagParent', function() {
			var oMessage = self.message();
			if (oMessage)
			{
				__webpack_require__(/*! App/User */ 8).default.messageListAction(oMessage.folderFullNameRaw, oMessage.uid,
					oMessage.flagged() ? Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, [oMessage]);
			}
		})
		.on('click', '.thread-list .flagParent', function() {
			var oMessage = ko.dataFor(this);
			if (oMessage && oMessage.folder && oMessage.uid)
			{
				__webpack_require__(/*! App/User */ 8).default.messageListAction(
					oMessage.folder, oMessage.uid,
					oMessage.flagged() ? Enums.MessageSetAction.UnsetFlag : Enums.MessageSetAction.SetFlag, [oMessage]);
			}

			self.threadsDropdownTrigger(true);

			return false;
		});

	AppStore.focusedState.subscribe(function(sValue) {
		if (Enums.Focused.MessageView !== sValue)
		{
			this.scrollMessageToTop();
			this.scrollMessageToLeft();
		}
	}, this);

	Globals.keyScopeReal.subscribe(function(sValue) {
		this.messageDomFocused(Enums.KeyState.MessageView === sValue && !Utils.inFocus());
	}, this);

	this.oMessageScrollerDom = oDom.find('.messageItem .content');
	this.oMessageScrollerDom = this.oMessageScrollerDom && this.oMessageScrollerDom[0] ? this.oMessageScrollerDom : null;

	this.initShortcuts();
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.escShortcuts = function()
{
	if (this.viewModelVisibility() && this.message())
	{
		if (this.fullScreenMode())
		{
			this.fullScreenMode(false);

			if (Enums.Layout.NoPreview !== this.layout())
			{
				AppStore.focusedState(Enums.Focused.MessageList);
			}
		}
		else if (Enums.Layout.NoPreview === this.layout())
		{
			this.message(null);
		}
		else
		{
			AppStore.focusedState(Enums.Focused.MessageList);
		}

		return false;
	}

	return true;
};

MessageViewMailBoxUserView.prototype.initShortcuts = function()
{
	var self = this;

	// exit fullscreen, back
	key('esc, backspace', Enums.KeyState.MessageView, _.bind(this.escShortcuts, this));

	// fullscreen
	key('enter', Enums.KeyState.MessageView, function() {
		self.toggleFullScreen();
		return false;
	});

	// reply
	key('r', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		if (MessageStore.message())
		{
			self.replyCommand();
			return false;
		}

		return true;
	});

	// replaAll
	key('a', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		if (MessageStore.message())
		{
			self.replyAllCommand();
			return false;
		}

		return true;
	});

	// forward
	key('f', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		if (MessageStore.message())
		{
			self.forwardCommand();
			return false;
		}

		return true;
	});

	// message information
	key('ctrl+i, command+i', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		if (MessageStore.message())
		{
			self.showFullInfo(!self.showFullInfo());
		}
		return false;
	});

	// toggle message blockquotes
	key('b', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		if (MessageStore.message() && MessageStore.message().body)
		{
			MessageStore.message().body.find('.rlBlockquoteSwitcher').click();
			return false;
		}

		return true;
	});

	key('ctrl+up, command+up, ctrl+left, command+left', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		self.goUpCommand();
		return false;
	});

	key('ctrl+down, command+down, ctrl+right, command+right', [Enums.KeyState.MessageList, Enums.KeyState.MessageView], function() {
		self.goDownCommand();
		return false;
	});

	// print
	key('ctrl+p, command+p', [Enums.KeyState.MessageView, Enums.KeyState.MessageList], function() {
		if (self.message())
		{
			self.message().printMessage();
		}

		return false;
	});

	// delete
	key('delete, shift+delete', Enums.KeyState.MessageView, function(event, handler) {
		if (event)
		{
			if (handler && 'shift+delete' === handler.shortcut)
			{
				self.deleteWithoutMoveCommand();
			}
			else
			{
				self.deleteCommand();
			}

			return false;
		}

		return true;
	});

	// change focused state
	key('tab, shift+tab, left', Enums.KeyState.MessageView, function(event, handler) {
		if (!self.fullScreenMode() && self.message() && Enums.Layout.NoPreview !== self.layout())
		{
			if (event && handler && 'left' === handler.shortcut)
			{
				if (self.oMessageScrollerDom && 0 < self.oMessageScrollerDom.scrollLeft())
				{
					return true;
				}

				AppStore.focusedState(Enums.Focused.MessageList);
			}
			else
			{
				AppStore.focusedState(Enums.Focused.MessageList);
			}
		}
		else if (self.message() && Enums.Layout.NoPreview === self.layout() && event && handler && 'left' === handler.shortcut)
		{
			return true;
		}

		return false;
	});
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isDraftFolder = function()
{
	return MessageStore.message() && FolderStore.draftFolder() === MessageStore.message().folderFullNameRaw;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isSentFolder = function()
{
	return MessageStore.message() && FolderStore.sentFolder() === MessageStore.message().folderFullNameRaw;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isSpamFolder = function()
{
	return MessageStore.message() && FolderStore.spamFolder() === MessageStore.message().folderFullNameRaw;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isSpamDisabled = function()
{
	return MessageStore.message() && FolderStore.spamFolder() === Consts.UNUSED_OPTION_VALUE;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isArchiveFolder = function()
{
	return MessageStore.message() && FolderStore.archiveFolder() === MessageStore.message().folderFullNameRaw;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isArchiveDisabled = function()
{
	return MessageStore.message() && FolderStore.archiveFolder() === Consts.UNUSED_OPTION_VALUE;
};

/**
 * @returns {boolean}
 */
MessageViewMailBoxUserView.prototype.isDraftOrSentFolder = function()
{
	return this.isDraftFolder() || this.isSentFolder();
};

MessageViewMailBoxUserView.prototype.composeClick = function()
{
	if (Settings.capa(Enums.Capa.Composer))
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25));
	}
};

MessageViewMailBoxUserView.prototype.editMessage = function()
{
	if (Settings.capa(Enums.Capa.Composer) && MessageStore.message())
	{
		kn.showScreenPopup(__webpack_require__(/*! View/Popup/Compose */ 25), [Enums.ComposeType.Draft, MessageStore.message()]);
	}
};

MessageViewMailBoxUserView.prototype.scrollMessageToTop = function()
{
	if (this.oMessageScrollerDom)
	{
		if (Enums.Size50px < this.oMessageScrollerDom.scrollTop())
		{
			this.oMessageScrollerDom
				.scrollTop(Enums.Size50px)
				.animate({'scrollTop': 0}, Enums.Time200ms);
		}
		else
		{
			this.oMessageScrollerDom.scrollTop(0);
		}

		Utils.windowResize();
	}
};

MessageViewMailBoxUserView.prototype.scrollMessageToLeft = function()
{
	if (this.oMessageScrollerDom)
	{
		this.oMessageScrollerDom.scrollLeft(0);
		Utils.windowResize();
	}
};

MessageViewMailBoxUserView.prototype.getAttachmentsHashes = function()
{
	return _.compact(_.map(this.message() ? this.message().attachments() : [], function(oItem) {
		return oItem && !oItem.isLinked && oItem.checked() ? oItem.download : '';
	}));
};

MessageViewMailBoxUserView.prototype.downloadAsZip = function()
{
	var self = this, aHashes = this.getAttachmentsHashes();
	if (0 < aHashes.length)
	{
		Promises.attachmentsActions('Zip', aHashes, this.downloadAsZipLoading).then(function(oResult) {
			if (oResult && oResult.Result && oResult.Result.Files &&
				oResult.Result.Files[0] && oResult.Result.Files[0].Hash)
			{
				__webpack_require__(/*! App/User */ 8).default.download(
					Links.attachmentDownload(oResult.Result.Files[0].Hash));
			}
			else
			{
				self.downloadAsZipError(true);
			}
		}).catch(function() {
			self.downloadAsZipError(true);
		});
	}
	else
	{
		this.highlightUnselectedAttachments(true);
	}
};

MessageViewMailBoxUserView.prototype.saveToOwnCloud = function()
{
	var self = this, aHashes = this.getAttachmentsHashes();
	if (0 < aHashes.length)
	{
		Promises.attachmentsActions('OwnCloud', aHashes, this.saveToOwnCloudLoading).then(function(oResult) {
			if (oResult && oResult.Result)
			{
				self.saveToOwnCloudSuccess(true);
			}
			else
			{
				self.saveToOwnCloudError(true);
			}
		}).catch(function() {
			self.saveToOwnCloudError(true);
		});
	}
	else
	{
		this.highlightUnselectedAttachments(true);
	}
};

MessageViewMailBoxUserView.prototype.saveToDropbox = function()
{
	var self = this, aFiles = [], aHashes = this.getAttachmentsHashes();
	if (0 < aHashes.length)
	{
		if (window.Dropbox)
		{
			Promises.attachmentsActions('Dropbox', aHashes, this.saveToDropboxLoading).then(function(oResult) {
				if (oResult && oResult.Result && oResult.Result.Url && oResult.Result.ShortLife && oResult.Result.Files)
				{
					if (window.Dropbox && Utils.isArray(oResult.Result.Files))
					{
						_.each(oResult.Result.Files, function(oItem) {
							aFiles.push({
								'url': oResult.Result.Url +
									Links.attachmentDownload(oItem.Hash, oResult.Result.ShortLife),
								'filename': oItem.FileName
							});
						});

						window.Dropbox.save({
							'files': aFiles,
							'progress': function() {
								self.saveToDropboxLoading(true);
								self.saveToDropboxError(false);
								self.saveToDropboxSuccess(false);
							},
							'cancel': function() {
								self.saveToDropboxSuccess(false);
								self.saveToDropboxError(false);
								self.saveToDropboxLoading(false);
							},
							'success': function() {
								self.saveToDropboxSuccess(true);
								self.saveToDropboxLoading(false);
							},
							'error': function() {
								self.saveToDropboxError(true);
								self.saveToDropboxLoading(false);
							}
						});
					}
					else
					{
						self.saveToDropboxError(true);
					}
				}
			}).catch(function() {
				self.saveToDropboxError(true);
			});
		}
	}
	else
	{
		this.highlightUnselectedAttachments(true);
	}
};

/**
 * @param {MessageModel} oMessage
 * @returns {void}
 */
MessageViewMailBoxUserView.prototype.showImages = function(oMessage)
{
	if (oMessage && oMessage.showExternalImages)
	{
		oMessage.showExternalImages(true);
	}

	this.checkHeaderHeight();
};

/**
 * @returns {string}
 */
MessageViewMailBoxUserView.prototype.printableCheckedMessageCount = function()
{
	var iCnt = this.messageListCheckedOrSelectedUidsWithSubMails().length;
	return 0 < iCnt ? (100 > iCnt ? iCnt : '99+') : ''; // eslint-disable-line no-magic-numbers
};

/**
 * @param {MessageModel} oMessage
 * @returns {void}
 */
MessageViewMailBoxUserView.prototype.readReceipt = function(oMessage)
{
	if (oMessage && '' !== oMessage.readReceipt())
	{
		Remote.sendReadReceiptMessage(Utils.noop, oMessage.folderFullNameRaw, oMessage.uid,
			oMessage.readReceipt(),
			Translator.i18n('READ_RECEIPT/SUBJECT', {'SUBJECT': oMessage.subject()}),
			Translator.i18n('READ_RECEIPT/BODY', {'READ-RECEIPT': AccountStore.email()}));

		oMessage.isReadReceipt(true);

		Cache.storeMessageFlagsToCache(oMessage);

		__webpack_require__(/*! App/User */ 8).default.reloadFlagsCurrentMessageListAndMessageFromCache();
	}

	this.checkHeaderHeight();
};

module.exports = MessageViewMailBoxUserView;


/***/ },
/* 155 */
/*!*************************************************!*\
  !*** ./dev/View/User/MailBox/SystemDropDown.js ***!
  \*************************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractSystemDropDownViewModel = __webpack_require__(/*! View/User/AbstractSystemDropDown */ 101);

/**
 * @constructor
 * @extends AbstractSystemDropDownViewModel
 */
function SystemDropDownMailBoxUserView()
{
	AbstractSystemDropDownViewModel.call(this);
	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/MailBox/SystemDropDown', 'View/App/MailBox/SystemDropDown', 'MailBoxSystemDropDownViewModel'], SystemDropDownMailBoxUserView);
_.extend(SystemDropDownMailBoxUserView.prototype, AbstractSystemDropDownViewModel.prototype);

module.exports = SystemDropDownMailBoxUserView;


/***/ },
/* 156 */
/*!****************************************!*\
  !*** ./dev/View/User/Settings/Menu.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Cache = __webpack_require__(/*! Common/Cache */ 19),
	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @param {Object} oScreen
 */
function MenuSettingsUserView(oScreen)
{
	AbstractView.call(this, 'Left', 'SettingsMenu');

	this.leftPanelDisabled = Globals.leftPanelDisabled;

	this.mobile = Settings.appSettingsGet('mobile');

	this.menu = oScreen.menu;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/Settings/Menu', 'View/App/Settings/Menu', 'SettingsMenuViewModel'], MenuSettingsUserView);
_.extend(MenuSettingsUserView.prototype, AbstractView.prototype);

MenuSettingsUserView.prototype.onBuild = function(oDom)
{
	if (this.mobile)
	{
		oDom
			.on('click', '.b-settings-menu .e-item.selectable', function() {
				Globals.leftPanelDisabled(true);
			});
	}

	key('up, down', Enums.KeyState.Settings, _.throttle(function(event, handler) {

		var
			sH = '',
			iIndex = -1,
			bUp = handler && 'up' === handler.shortcut,
			$items = $('.b-settings-menu .e-item', oDom);

		if (event && $items.length)
		{
			iIndex = $items.index($items.filter('.selected'));
			if (bUp && 0 < iIndex)
			{
				iIndex -= 1;
			}
			else if (!bUp && iIndex < $items.length - 1)
			{
				iIndex += 1;
			}

			sH = $items.eq(iIndex).attr('href');
			if (sH)
			{
				kn.setHash(sH, false, true);
			}
		}

	}, 200)); // eslint-disable-line no-magic-numbers
};

MenuSettingsUserView.prototype.link = function(sRoute)
{
	return Links.settings(sRoute);
};

MenuSettingsUserView.prototype.backToMailBoxClick = function()
{
	kn.setHash(Links.inbox(Cache.getFolderInboxName()));
};

module.exports = MenuSettingsUserView;


/***/ },
/* 157 */
/*!****************************************!*\
  !*** ./dev/View/User/Settings/Pane.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Globals = __webpack_require__(/*! Common/Globals */ 5),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function PaneSettingsUserView()
{
	AbstractView.call(this, 'Right', 'SettingsPane');

	this.mobile = Settings.appSettingsGet('mobile');

	this.leftPanelDisabled = Globals.leftPanelDisabled;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/Settings/Pane', 'View/App/Settings/Pane', 'SettingsPaneViewModel'], PaneSettingsUserView);
_.extend(PaneSettingsUserView.prototype, AbstractView.prototype);

PaneSettingsUserView.prototype.onShow = function()
{
	__webpack_require__(/*! Stores/User/Message */ 29).message(null);
};

PaneSettingsUserView.prototype.hideLeft = function(oItem, oEvent)
{
	oEvent.preventDefault();
	oEvent.stopPropagation();

	Globals.leftPanelDisabled(true);
};

PaneSettingsUserView.prototype.showLeft = function(oItem, oEvent)
{
	oEvent.preventDefault();
	oEvent.stopPropagation();

	Globals.leftPanelDisabled(false);
};

PaneSettingsUserView.prototype.onBuild = function(oDom)
{
	if (this.mobile)
	{
		oDom
			.on('click', function() {
				Globals.leftPanelDisabled(true);
			});
	}
};

PaneSettingsUserView.prototype.backToMailBoxClick = function()
{
	kn.setHash(__webpack_require__(/*! Common/Links */ 12).inbox(
		__webpack_require__(/*! Common/Cache */ 19).getFolderInboxName()));
};

module.exports = PaneSettingsUserView;


/***/ },
/* 158 */
/*!**************************************************!*\
  !*** ./dev/View/User/Settings/SystemDropDown.js ***!
  \**************************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractSystemDropDownUserView = __webpack_require__(/*! View/User/AbstractSystemDropDown */ 101);

/**
 * @constructor
 * @extends AbstractSystemDropDownUserView
 */
function SystemDropDownSettingsUserView()
{
	AbstractSystemDropDownUserView.call(this);
	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/User/Settings/SystemDropDown', 'View/App/Settings/SystemDropDown', 'SettingsSystemDropDownViewModel'], SystemDropDownSettingsUserView);
_.extend(SystemDropDownSettingsUserView.prototype, AbstractSystemDropDownUserView.prototype);

module.exports = SystemDropDownSettingsUserView;


/***/ },
/* 159 */
/*!*******************************!*\
  !*** ./dev/Common/Base64.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "decode", function() { return decode; });
/* harmony export */ __webpack_require__.d(exports, "encode", function() { return encode; });
/* harmony export */ __webpack_require__.d(exports, "urlsafe_encode", function() { return urlsafe_encode; });
// Base64 encode / decode
// http://www.webtoolkit.info/

var BASE_64_CHR = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

/* eslint-disable  */
var Base64 = {

	// public method for urlsafe encoding
	urlsafe_encode: function urlsafe_encode(input) {
		return Base64.encode(input).replace(/[+]/g, '-').replace(/[\/]/g, '_').replace(/[=]/g, '.');
	},

	// public method for encoding
	encode: function encode(input) {

		var output = '',
		    chr1 = void 0,
		    chr2 = void 0,
		    chr3 = void 0,
		    enc1 = void 0,
		    enc2 = void 0,
		    enc3 = void 0,
		    enc4 = void 0,
		    i = 0;

		input = Base64._utf8_encode(input);

		while (i < input.length) {
			chr1 = input.charCodeAt(i++);
			chr2 = input.charCodeAt(i++);
			chr3 = input.charCodeAt(i++);

			enc1 = chr1 >> 2;
			enc2 = (chr1 & 3) << 4 | chr2 >> 4;
			enc3 = (chr2 & 15) << 2 | chr3 >> 6;
			enc4 = chr3 & 63;

			if (isNaN(chr2)) {
				enc3 = enc4 = 64;
			} else if (isNaN(chr3)) {
				enc4 = 64;
			}

			output = output + BASE_64_CHR.charAt(enc1) + BASE_64_CHR.charAt(enc2) + BASE_64_CHR.charAt(enc3) + BASE_64_CHR.charAt(enc4);
		}

		return output;
	},

	// public method for decoding
	decode: function decode(input) {

		var output = '',
		    chr1 = void 0,
		    chr2 = void 0,
		    chr3 = void 0,
		    enc1 = void 0,
		    enc2 = void 0,
		    enc3 = void 0,
		    enc4 = void 0,
		    i = 0;

		input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');

		while (i < input.length) {
			enc1 = BASE_64_CHR.indexOf(input.charAt(i++));
			enc2 = BASE_64_CHR.indexOf(input.charAt(i++));
			enc3 = BASE_64_CHR.indexOf(input.charAt(i++));
			enc4 = BASE_64_CHR.indexOf(input.charAt(i++));

			chr1 = enc1 << 2 | enc2 >> 4;
			chr2 = (enc2 & 15) << 4 | enc3 >> 2;
			chr3 = (enc3 & 3) << 6 | enc4;

			output = output + String.fromCharCode(chr1);

			if (enc3 !== 64) {
				output = output + String.fromCharCode(chr2);
			}

			if (enc4 !== 64) {
				output = output + String.fromCharCode(chr3);
			}
		}

		return Base64._utf8_decode(output);
	},

	// private method for UTF-8 encoding
	_utf8_encode: function _utf8_encode(string) {

		string = string.replace(/\r\n/g, "\n");

		var utftext = '',
		    n = 0,
		    l = string.length,
		    c = 0;

		for (; n < l; n++) {

			c = string.charCodeAt(n);

			if (c < 128) {
				utftext += String.fromCharCode(c);
			} else if (c > 127 && c < 2048) {
				utftext += String.fromCharCode(c >> 6 | 192);
				utftext += String.fromCharCode(c & 63 | 128);
			} else {
				utftext += String.fromCharCode(c >> 12 | 224);
				utftext += String.fromCharCode(c >> 6 & 63 | 128);
				utftext += String.fromCharCode(c & 63 | 128);
			}
		}

		return utftext;
	},

	// private method for UTF-8 decoding
	_utf8_decode: function _utf8_decode(utftext) {

		var string = '',
		    i = 0,
		    c = 0,
		    c2 = 0,
		    c3 = 0;

		while (i < utftext.length) {
			c = utftext.charCodeAt(i);

			if (c < 128) {
				string += String.fromCharCode(c);
				i++;
			} else if (c > 191 && c < 224) {
				c2 = utftext.charCodeAt(i + 1);
				string += String.fromCharCode((c & 31) << 6 | c2 & 63);
				i += 2;
			} else {
				c2 = utftext.charCodeAt(i + 1);
				c3 = utftext.charCodeAt(i + 2);
				string += String.fromCharCode((c & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
				i += 3;
			}
		}

		return string;
	}
};
/* eslint-enable */

var decode = Base64.decode;
var encode = Base64.encode;
var urlsafe_encode = Base64.urlsafe_encode;

/***/ },
/* 160 */
/*!***************************************************!*\
  !*** ./dev/Common/ClientStorageDriver/Cookie.jsx ***!
  \***************************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_JSON__ = __webpack_require__(/*! JSON */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_JSON___default = __WEBPACK_IMPORTED_MODULE_2_JSON__ && __WEBPACK_IMPORTED_MODULE_2_JSON__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_JSON__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_JSON__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_JSON___default, 'a', __WEBPACK_IMPORTED_MODULE_2_JSON___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 15);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return CookieDriver; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }







var CookieDriver = function () {
	function CookieDriver() {
		_classCallCheck(this, CookieDriver);
	}

	/**
  * @param {string} key
  * @param {*} data
  * @returns {boolean}
  */

	CookieDriver.prototype.set = function set(key, data) {

		var result = false,
		    storageResult = null;

		try {
			var storageValue = __WEBPACK_IMPORTED_MODULE_1_____default.a.cookie(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"]);
			storageResult = null === storageValue ? null : __WEBPACK_IMPORTED_MODULE_2_JSON___default.a.parse(storageValue);
		} catch (e) {} // eslint-disable-line no-empty

		(storageResult || (storageResult = {}))[key] = data;

		try {
			__WEBPACK_IMPORTED_MODULE_1_____default.a.cookie(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"], __WEBPACK_IMPORTED_MODULE_2_JSON___default.a.stringify(storageResult), {
				expires: 30
			});

			result = true;
		} catch (e) {} // eslint-disable-line no-empty

		return result;
	};

	/**
  * @param {string} key
  * @returns {*}
  */


	CookieDriver.prototype.get = function get(key) {

		var result = null;

		try {
			var storageValue = __WEBPACK_IMPORTED_MODULE_1_____default.a.cookie(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"]),
			    storageResult = null === storageValue ? null : __WEBPACK_IMPORTED_MODULE_2_JSON___default.a.parse(storageValue);

			result = storageResult && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isUnd"])(storageResult[key]) ? storageResult[key] : null;
		} catch (e) {} // eslint-disable-line no-empty

		return result;
	};

	/**
  * @returns {boolean}
  */


	CookieDriver.supported = function supported() {
		return !!(__WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.cookieEnabled);
	};

	return CookieDriver;
}();



/***/ },
/* 161 */
/*!*********************************************************!*\
  !*** ./dev/Common/ClientStorageDriver/LocalStorage.jsx ***!
  \*********************************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_JSON__ = __webpack_require__(/*! JSON */ 33);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_JSON___default = __WEBPACK_IMPORTED_MODULE_1_JSON__ && __WEBPACK_IMPORTED_MODULE_1_JSON__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_JSON__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_JSON__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_JSON___default, 'a', __WEBPACK_IMPORTED_MODULE_1_JSON___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_RainLoop__ = __webpack_require__(/*! Storage/RainLoop */ 55);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Consts__ = __webpack_require__(/*! Common/Consts */ 15);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return LocalStorageDriver; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }







var LocalStorageDriver = function () {
	function LocalStorageDriver() {
		_classCallCheck(this, LocalStorageDriver);

		this.s = __WEBPACK_IMPORTED_MODULE_0_window___default.a.localStorage || null;
	}

	/**
  * @param {string} key
  * @param {*} data
  * @returns {boolean}
  */


	LocalStorageDriver.prototype.set = function set(key, data) {
		if (!this.s) {
			return false;
		}

		var storageResult = null;
		try {
			var storageValue = this.s.getItem(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"]) || null;
			storageResult = null === storageValue ? null : __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.parse(storageValue);
		} catch (e) {} // eslint-disable-line no-empty

		(storageResult || (storageResult = {}))[key] = data;

		try {
			this.s.setItem(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"], __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.stringify(storageResult));
			return true;
		} catch (e) {} // eslint-disable-line no-empty

		return false;
	};

	/**
  * @param {string} key
  * @returns {*}
  */


	LocalStorageDriver.prototype.get = function get(key) {
		if (!this.s) {
			return null;
		}

		try {
			var storageValue = this.s.getItem(__WEBPACK_IMPORTED_MODULE_4_Common_Consts__["CLIENT_SIDE_STORAGE_INDEX_NAME"]) || null,
			    storageResult = null === storageValue ? null : __WEBPACK_IMPORTED_MODULE_1_JSON___default.a.parse(storageValue);

			return storageResult && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(storageResult[key]) ? storageResult[key] : null;
		} catch (e) {} // eslint-disable-line no-empty

		return null;
	};

	/**
  * @returns {boolean}
  */


	LocalStorageDriver.supported = function supported() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Storage_RainLoop__["a" /* isStorageSupported */])('localStorage');
	};

	return LocalStorageDriver;
}();



/***/ },
/* 162 */
/*!*******************************!*\
  !*** ./dev/Model/Account.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AccountModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var AccountModel = function (_AbstractModel) {
	_inherits(AccountModel, _AbstractModel);

	/**
  * @param {string} email
  * @param {boolean=} canBeDelete = true
  * @param {number=} count = 0
  */

	function AccountModel(email) {
		var canBeDelete = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];
		var count = arguments.length <= 2 || arguments[2] === undefined ? 0 : arguments[2];

		_classCallCheck(this, AccountModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'AccountModel'));

		_this.email = email;

		_this.count = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(count);

		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.canBeDeleted = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(!!canBeDelete);
		_this.canBeEdit = _this.canBeDeleted;
		return _this;
	}

	/**
  * @returns {string}
  */


	AccountModel.prototype.changeAccountLink = function changeAccountLink() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Links__["change"])(this.email);
	};

	return AccountModel;
}(__WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 163 */
/*!*****************************************!*\
  !*** ./dev/Model/ComposeAttachment.jsx ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Model_Attachment__ = __webpack_require__(/*! Model/Attachment */ 104);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "ComposeAttachmentModel", function() { return ComposeAttachmentModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return ComposeAttachmentModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var ComposeAttachmentModel = function (_AbstractModel) {
	_inherits(ComposeAttachmentModel, _AbstractModel);

	/**
  * @param {string} id
  * @param {string} fileName
  * @param {?number=} size = null
  * @param {boolean=} isInline = false
  * @param {boolean=} isLinked = false
  * @param {string=} CID = ''
  * @param {string=} contentLocation = ''
  */

	function ComposeAttachmentModel(id, fileName) {
		var size = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
		var isInline = arguments.length <= 3 || arguments[3] === undefined ? false : arguments[3];
		var isLinked = arguments.length <= 4 || arguments[4] === undefined ? false : arguments[4];
		var CID = arguments.length <= 5 || arguments[5] === undefined ? '' : arguments[5];
		var contentLocation = arguments.length <= 6 || arguments[6] === undefined ? '' : arguments[6];

		_classCallCheck(this, ComposeAttachmentModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'ComposeAttachmentModel'));

		_this.id = id;
		_this.isInline = !!isInline;
		_this.isLinked = !!isLinked;
		_this.CID = CID;
		_this.contentLocation = contentLocation;
		_this.fromMessage = false;

		_this.fileName = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(fileName);
		_this.size = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(size);
		_this.tempName = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.progress = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(0);
		_this.error = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.waiting = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
		_this.uploading = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.enabled = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
		_this.complete = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.progressText = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			var p = _this.progress();
			return 0 === p ? '' : '' + (98 < p ? 100 : p) + '%';
		});

		_this.progressStyle = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			var p = _this.progress();
			return 0 === p ? '' : 'width:' + (98 < p ? 100 : p) + '%';
		});

		_this.title = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			var error = _this.error();
			return '' !== error ? error : _this.fileName();
		});

		_this.friendlySize = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			var localSize = _this.size();
			return null === localSize ? '' : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["friendlySize"])(localSize);
		});

		_this.mimeType = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["mimeContentType"])(_this.fileName());
		});
		_this.fileExt = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["getFileExtension"])(_this.fileName());
		});

		_this.regDisposables([_this.progressText, _this.progressStyle, _this.title, _this.friendlySize, _this.mimeType, _this.fileExt]);
		return _this;
	}

	/**
  * @param {AjaxJsonComposeAttachment} json
  * @returns {boolean}
  */


	ComposeAttachmentModel.prototype.initByUploadJson = function initByUploadJson(json) {
		var bResult = false;
		if (json) {
			this.fileName(json.Name);
			this.size(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(json.Size) ? 0 : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(json.Size));
			this.tempName(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(json.TempName) ? '' : json.TempName);
			this.isInline = false;

			bResult = true;
		}

		return bResult;
	};

	/**
  * @returns {string}
  */


	ComposeAttachmentModel.prototype.iconClass = function iconClass() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Model_Attachment__["c" /* staticIconClass */])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Model_Attachment__["d" /* staticFileType */])(this.fileExt(), this.mimeType()))[0];
	};

	/**
  * @returns {string}
  */


	ComposeAttachmentModel.prototype.iconText = function iconText() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Model_Attachment__["c" /* staticIconClass */])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Model_Attachment__["d" /* staticFileType */])(this.fileExt(), this.mimeType()))[1];
	};

	return ComposeAttachmentModel;
}(__WEBPACK_IMPORTED_MODULE_3_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 164 */
/*!*******************************!*\
  !*** ./dev/Model/Contact.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "ContactModel", function() { return ContactModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return ContactModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }










var ContactModel = function (_AbstractModel) {
	_inherits(ContactModel, _AbstractModel);

	function ContactModel() {
		_classCallCheck(this, ContactModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'ContactModel'));

		_this.idContact = 0;
		_this.display = '';
		_this.properties = [];
		_this.readOnly = false;

		_this.focused = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.selected = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.checked = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.deleted = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		return _this;
	}

	/**
  * @returns {Array|null}
  */


	ContactModel.prototype.getNameAndEmailHelper = function getNameAndEmailHelper() {
		var name = '',
		    email = '';

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNonEmptyArray"])(this.properties)) {
			__WEBPACK_IMPORTED_MODULE_0_____default.a.each(this.properties, function (property) {
				if (property) {
					if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["ContactPropertyType"].FirstName === property[0]) {
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["trim"])(property[1] + ' ' + name);
					} else if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["ContactPropertyType"].LastName === property[0]) {
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["trim"])(name + ' ' + property[1]);
					} else if ('' === email && __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["ContactPropertyType"].Email === property[0]) {
						email = property[1];
					}
				}
			});
		}

		return '' === email ? null : [email, name];
	};

	/**
  * @param {Object} oItem
  * @returns {boolean}
  */


	ContactModel.prototype.parse = function parse(json) {
		var _this2 = this;

		var result = false;
		if (json && 'Object/Contact' === json['@Object']) {
			this.idContact = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pInt"])(json.IdContact);
			this.display = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(json.Display);
			this.readOnly = !!json.ReadOnly;

			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNonEmptyArray"])(json.Properties)) {
				__WEBPACK_IMPORTED_MODULE_0_____default.a.each(json.Properties, function (property) {
					if (property && property.Type && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNormal"])(property.Value) && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isNormal"])(property.TypeStr)) {
						_this2.properties.push([__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pInt"])(property.Type), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(property.Value), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(property.TypeStr)]);
					}
				});
			}

			result = true;
		}

		return result;
	};

	/**
  * @returns {string}
  */


	ContactModel.prototype.srcAttr = function srcAttr() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Links__["emptyContactPic"])();
	};

	/**
  * @returns {string}
  */


	ContactModel.prototype.generateUid = function generateUid() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["pString"])(this.idContact);
	};

	/**
  * @return string
  */


	ContactModel.prototype.lineAsCss = function lineAsCss() {
		var result = [];
		if (this.deleted()) {
			result.push('deleted');
		}
		if (this.selected()) {
			result.push('selected');
		}
		if (this.checked()) {
			result.push('checked');
		}
		if (this.focused()) {
			result.push('focused');
		}

		return result.join(' ');
	};

	return ContactModel;
}(__WEBPACK_IMPORTED_MODULE_5_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 165 */
/*!***************************************!*\
  !*** ./dev/Model/ContactProperty.jsx ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "ContactPropertyModel", function() { return ContactPropertyModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return ContactPropertyModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }









var ContactPropertyModel = function (_AbstractModel) {
	_inherits(ContactPropertyModel, _AbstractModel);

	/**
  * @param {number=} type = Enums.ContactPropertyType.Unknown
  * @param {string=} typeStr = ''
  * @param {string=} value = ''
  * @param {boolean=} focused = false
  * @param {string=} placeholder = ''
  */

	function ContactPropertyModel() {
		var type = arguments.length <= 0 || arguments[0] === undefined ? __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["ContactPropertyType"].Unknown : arguments[0];
		var typeStr = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
		var value = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];
		var focused = arguments.length <= 3 || arguments[3] === undefined ? false : arguments[3];
		var placeholder = arguments.length <= 4 || arguments[4] === undefined ? '' : arguments[4];

		_classCallCheck(this, ContactPropertyModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'ContactPropertyModel'));

		_this.type = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pInt"])(type));
		_this.typeStr = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(typeStr));
		_this.focused = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(!!focused);
		_this.value = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(value));

		_this.placeholder = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(placeholder);

		_this.placeholderValue = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			var v = _this.placeholder();
			return v ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Translator__["i18n"])(v) : '';
		});

		_this.largeValue = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["ContactPropertyType"].Note === _this.type();
		});

		_this.regDisposables([_this.placeholderValue, _this.largeValue]);
		return _this;
	}

	return ContactPropertyModel;
}(__WEBPACK_IMPORTED_MODULE_4_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 166 */
/*!***************************************!*\
  !*** ./dev/Model/FilterCondition.jsx ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return FilterConditionModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }








var FilterConditionModel = function (_AbstractModel) {
	_inherits(FilterConditionModel, _AbstractModel);

	function FilterConditionModel() {
		_classCallCheck(this, FilterConditionModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'FilterConditionModel'));

		_this.field = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["FilterConditionField"].From);
		_this.type = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["FilterConditionType"].Contains);
		_this.value = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.value.error = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.valueSecond = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.valueSecond.error = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.template = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {

			var sTemplate = '';
			switch (this.field()) {
				case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["FilterConditionField"].Size:
					sTemplate = 'SettingsFiltersConditionSize';
					break;
				case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["FilterConditionField"].Header:
					sTemplate = 'SettingsFiltersConditionMore';
					break;
				default:
					sTemplate = 'SettingsFiltersConditionDefault';
					break;
			}

			return sTemplate;
		}, _this);

		_this.field.subscribe(function () {
			this.value('');
			this.valueSecond('');
		}, _this);

		_this.regDisposables([_this.template]);
		return _this;
	}

	FilterConditionModel.prototype.verify = function verify() {
		if ('' === this.value()) {
			this.value.error(true);
			return false;
		}

		if (__WEBPACK_IMPORTED_MODULE_1_Common_Enums__["FilterConditionField"].Header === this.field() && '' === this.valueSecond()) {
			this.valueSecond.error(true);
			return false;
		}

		return true;
	};

	FilterConditionModel.prototype.parse = function parse(json) {
		if (json && json.Field && json.Type) {
			this.field(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(json.Field));
			this.type(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(json.Type));
			this.value(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(json.Value));
			this.valueSecond(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["pString"])(json.ValueSecond));

			return true;
		}

		return false;
	};

	FilterConditionModel.prototype.toJson = function toJson() {
		return {
			Field: this.field(),
			Type: this.type(),
			Value: this.value(),
			ValueSecond: this.valueSecond()
		};
	};

	FilterConditionModel.prototype.cloneSelf = function cloneSelf() {
		var filterCond = new FilterConditionModel();

		filterCond.field(this.field());
		filterCond.type(this.type());
		filterCond.value(this.value());
		filterCond.valueSecond(this.valueSecond());

		return filterCond;
	};

	return FilterConditionModel;
}(__WEBPACK_IMPORTED_MODULE_3_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 167 */
/*!******************************!*\
  !*** ./dev/Model/Folder.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "FolderModel", function() { return FolderModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return FolderModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var FolderModel = function (_AbstractModel) {
	_inherits(FolderModel, _AbstractModel);

	function FolderModel() {
		_classCallCheck(this, FolderModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'FolderModel'));

		_this.name = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		_this.fullName = '';
		_this.fullNameRaw = '';
		_this.fullNameHash = '';
		_this.delimiter = '';
		_this.namespace = '';
		_this.deep = 0;
		_this.interval = 0;

		_this.selectable = false;
		_this.existen = true;

		_this.type = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].User);

		_this.focused = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.selected = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.edited = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.collapsed = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);
		_this.subScribed = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);
		_this.checkable = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.subFolders = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observableArray([]);
		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false);
		_this.actionBlink = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ falseTimeout: 1000 });

		_this.nameForEdit = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');

		_this.privateMessageCountAll = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(0);
		_this.privateMessageCountUnread = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(0);

		_this.collapsedPrivate = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(true);
		return _this;
	}

	/**
  * @static
  * @param {AjaxJsonFolder} json
  * @returns {?FolderModel}
  */


	FolderModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var folder = new FolderModel();
		return folder.initByJson(json) ? folder.initComputed() : null;
	};

	/**
  * @returns {FolderModel}
  */


	FolderModel.prototype.initComputed = function initComputed() {
		var _this2 = this;

		var inboxFolderName = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Cache__["getFolderInboxName"])();

		this.isInbox = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Inbox === _this2.type();
		});

		this.hasSubScribedSubfolders = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return !!__WEBPACK_IMPORTED_MODULE_0_____default.a.find(this.subFolders(), function (oFolder) {
				return (oFolder.subScribed() || oFolder.hasSubScribedSubfolders()) && !oFolder.isSystemFolder();
			});
		}, this);

		this.canBeEdited = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].User === _this2.type() && _this2.existen && _this2.selectable;
		});

		this.visible = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var isSubScribed = _this2.subScribed(),
			    isSubFolders = _this2.hasSubScribedSubfolders();

			return isSubScribed || isSubFolders && (!_this2.existen || !_this2.selectable);
		});

		this.isSystemFolder = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].User !== _this2.type();
		});

		this.hidden = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var isSystem = _this2.isSystemFolder(),
			    isSubFolders = _this2.hasSubScribedSubfolders();

			return isSystem && !isSubFolders || !_this2.selectable && !isSubFolders;
		});

		this.selectableForFolderList = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return !_this2.isSystemFolder() && _this2.selectable;
		});

		this.messageCountAll = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed({
			read: this.privateMessageCountAll,
			write: function write(iValue) {
				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isPosNumeric"])(iValue, true)) {
					_this2.privateMessageCountAll(iValue);
				} else {
					_this2.privateMessageCountAll.valueHasMutated();
				}
			}
		}).extend({ notify: 'always' });

		this.messageCountUnread = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed({
			read: this.privateMessageCountUnread,
			write: function write(value) {
				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_3_Common_Utils__["isPosNumeric"])(value, true)) {
					_this2.privateMessageCountUnread(value);
				} else {
					_this2.privateMessageCountUnread.valueHasMutated();
				}
			}
		}).extend({ notify: 'always' });

		this.printableUnreadCount = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var count = _this2.messageCountAll(),
			    unread = _this2.messageCountUnread(),
			    type = _this2.type();

			if (0 < count) {
				if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Draft === type) {
					return '' + count;
				} else if (0 < unread && __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Trash !== type && __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Archive !== type && __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].SentItems !== type) {
					return '' + unread;
				}
			}

			return '';
		});

		this.canBeDeleted = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			var bSystem = _this2.isSystemFolder();
			return !bSystem && 0 === _this2.subFolders().length && inboxFolderName !== _this2.fullNameRaw;
		});

		this.canBeSubScribed = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return !_this2.isSystemFolder() && _this2.selectable && inboxFolderName !== _this2.fullNameRaw;
		});

		this.canBeChecked = this.canBeSubScribed;

		this.localName = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["trigger"])();

			var name = _this2.name();
			var type = _this2.type();

			if (_this2.isSystemFolder()) {
				switch (type) {
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Inbox:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/INBOX_NAME');
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].SentItems:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/SENT_NAME');
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Draft:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/DRAFTS_NAME');
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Spam:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/SPAM_NAME');
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Trash:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/TRASH_NAME');
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Archive:
						name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/ARCHIVE_NAME');
						break;
					// no default
				}
			}

			return name;
		});

		this.manageFolderSystemName = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["trigger"])();

			var suffix = '';
			var type = _this2.type(),
			    name = _this2.name();

			if (_this2.isSystemFolder()) {
				switch (type) {
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Inbox:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/INBOX_NAME') + ')';
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].SentItems:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/SENT_NAME') + ')';
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Draft:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/DRAFTS_NAME') + ')';
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Spam:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/SPAM_NAME') + ')';
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Trash:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/TRASH_NAME') + ')';
						break;
					case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Archive:
						suffix = '(' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('FOLDER_LIST/ARCHIVE_NAME') + ')';
						break;
					// no default
				}
			}

			if ('' !== suffix && '(' + name + ')' === suffix || '(inbox)' === suffix.toLowerCase()) {
				suffix = '';
			}

			return suffix;
		});

		this.collapsed = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed({
			read: function read() {
				return !_this2.hidden() && _this2.collapsedPrivate();
			},
			write: function write(value) {
				_this2.collapsedPrivate(value);
			}
		});

		this.hasUnreadMessages = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return 0 < _this2.messageCountUnread() && '' !== _this2.printableUnreadCount();
		});

		this.hasSubScribedUnreadMessagesSubfolders = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.computed(function () {
			return !!__WEBPACK_IMPORTED_MODULE_0_____default.a.find(this.subFolders(), function (folder) {
				return folder.hasUnreadMessages() || folder.hasSubScribedUnreadMessagesSubfolders();
			});
		}, this);

		// subscribe
		this.name.subscribe(function (value) {
			_this2.nameForEdit(value);
		});

		this.edited.subscribe(function (value) {
			if (value) {
				_this2.nameForEdit(_this2.name());
			}
		});

		this.messageCountUnread.subscribe(function (unread) {
			if (__WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Inbox === _this2.type()) {
				__WEBPACK_IMPORTED_MODULE_6_Common_Events__["pub"]('mailbox.inbox-unread-count', [unread]);
			}
		});

		return this;
	};

	/**
  * @returns {string}
  */


	FolderModel.prototype.collapsedCss = function collapsedCss() {
		return this.hasSubScribedSubfolders() ? this.collapsed() ? 'icon-right-mini e-collapsed-sign' : 'icon-down-mini e-collapsed-sign' : 'icon-none e-collapsed-sign';
	};

	/**
  * @param {AjaxJsonFolder} json
  * @returns {boolean}
  */


	FolderModel.prototype.initByJson = function initByJson(json) {
		var bResult = false;
		var sInboxFolderName = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Cache__["getFolderInboxName"])();

		if (json && 'Object/Folder' === json['@Object']) {
			this.name(json.Name);
			this.delimiter = json.Delimiter;
			this.fullName = json.FullName;
			this.fullNameRaw = json.FullNameRaw;
			this.fullNameHash = json.FullNameHash;
			this.deep = json.FullNameRaw.split(this.delimiter).length - 1;
			this.selectable = !!json.IsSelectable;
			this.existen = !!json.IsExists;

			this.subScribed(!!json.IsSubscribed);
			this.checkable(!!json.Checkable);

			this.type(sInboxFolderName === this.fullNameRaw ? __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].Inbox : __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["FolderType"].User);

			bResult = true;
		}

		return bResult;
	};

	/**
  * @returns {string}
  */


	FolderModel.prototype.printableFullName = function printableFullName() {
		return this.fullName.split(this.delimiter).join(' / ');
	};

	return FolderModel;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 168 */
/*!********************************!*\
  !*** ./dev/Model/Identity.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return IdentityModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var IdentityModel = function (_AbstractModel) {
	_inherits(IdentityModel, _AbstractModel);

	/**
  * @param {string} id
  * @param {string} email
  */

	function IdentityModel(id, email) {
		_classCallCheck(this, IdentityModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'IdentityModel'));

		_this.id = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(id || '');
		_this.email = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(email);
		_this.name = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.replyTo = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.bcc = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.signature = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');
		_this.signatureInsertBefore = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.canBeDeleted = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {
			return '' !== _this.id();
		});
		return _this;
	}

	/**
  * @returns {string}
  */


	IdentityModel.prototype.formattedName = function formattedName() {
		var name = this.name(),
		    email = this.email();

		return '' !== name ? name + ' (' + email + ')' : email;
	};

	return IdentityModel;
}(__WEBPACK_IMPORTED_MODULE_1_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 169 */
/*!*******************************!*\
  !*** ./dev/Model/Message.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Helper_Message__ = __webpack_require__(/*! Helper/Message */ 103);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Model_Attachment__ = __webpack_require__(/*! Model/Attachment */ 104);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "MessageModel", function() { return MessageModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return MessageModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

















var MessageModel = function (_AbstractModel) {
	_inherits(MessageModel, _AbstractModel);

	function MessageModel() {
		_classCallCheck(this, MessageModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'MessageModel'));

		_this.folderFullNameRaw = '';
		_this.uid = '';
		_this.hash = '';
		_this.requestHash = '';
		_this.subject = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.subjectPrefix = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.subjectSuffix = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.size = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(0);
		_this.dateTimeStampInUTC = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(0);
		_this.priority = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);

		_this.proxy = false;

		_this.fromEmailString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.fromClearEmailString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.toEmailsString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.toClearEmailsString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');

		_this.senderEmailsString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');
		_this.senderClearEmailsString = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');

		_this.emails = [];

		_this.from = [];
		_this.to = [];
		_this.cc = [];
		_this.bcc = [];
		_this.replyTo = [];
		_this.deliveredTo = [];

		_this.newForAnimation = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

		_this.deleted = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.deletedMark = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.unseen = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.flagged = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.answered = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.forwarded = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.isReadReceipt = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

		_this.focused = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.selected = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.checked = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.hasAttachments = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.attachmentsSpecData = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observableArray([]);

		_this.attachmentIconClass = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.computed(function () {
			return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_8_Model_Attachment__["a" /* staticCombinedIconClass */])(_this.hasAttachments() ? _this.attachmentsSpecData() : []);
		});

		_this.body = null;

		_this.isHtml = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.hasImages = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.attachments = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observableArray([]);

		_this.isPgpSigned = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.isPgpEncrypted = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.pgpSignedVerifyStatus = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["SignedVerifyStatus"].None);
		_this.pgpSignedVerifyUser = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');

		_this.priority = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);
		_this.readReceipt = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable('');

		_this.aDraftInfo = [];
		_this.sMessageId = '';
		_this.sInReplyTo = '';
		_this.sReferences = '';

		_this.hasUnseenSubMessage = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
		_this.hasFlaggedSubMessage = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

		_this.threads = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observableArray([]);

		_this.threadsLen = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.computed(function () {
			return _this.threads().length;
		});
		_this.isImportant = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.computed(function () {
			return __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].High === _this.priority();
		});

		_this.regDisposables([_this.attachmentIconClass, _this.threadsLen, _this.isImportant]);
		return _this;
	}

	/**
  * @static
  * @param {AjaxJsonMessage} oJsonMessage
  * @returns {?MessageModel}
  */


	MessageModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var oMessageModel = new MessageModel();
		return oMessageModel.initByJson(json) ? oMessageModel : null;
	};

	MessageModel.prototype.clear = function clear() {
		this.folderFullNameRaw = '';
		this.uid = '';
		this.hash = '';
		this.requestHash = '';
		this.subject('');
		this.subjectPrefix('');
		this.subjectSuffix('');
		this.size(0);
		this.dateTimeStampInUTC(0);
		this.priority(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);

		this.proxy = false;

		this.fromEmailString('');
		this.fromClearEmailString('');
		this.toEmailsString('');
		this.toClearEmailsString('');
		this.senderEmailsString('');
		this.senderClearEmailsString('');

		this.emails = [];

		this.from = [];
		this.to = [];
		this.cc = [];
		this.bcc = [];
		this.replyTo = [];
		this.deliveredTo = [];

		this.newForAnimation(false);

		this.deleted(false);
		this.deletedMark(false);
		this.unseen(false);
		this.flagged(false);
		this.answered(false);
		this.forwarded(false);
		this.isReadReceipt(false);

		this.selected(false);
		this.checked(false);
		this.hasAttachments(false);
		this.attachmentsSpecData([]);

		this.body = null;
		this.isHtml(false);
		this.hasImages(false);
		this.attachments([]);

		this.isPgpSigned(false);
		this.isPgpEncrypted(false);
		this.pgpSignedVerifyStatus(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["SignedVerifyStatus"].None);
		this.pgpSignedVerifyUser('');

		this.priority(__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);
		this.readReceipt('');
		this.aDraftInfo = [];
		this.sMessageId = '';
		this.sInReplyTo = '';
		this.sReferences = '';

		this.threads([]);

		this.hasUnseenSubMessage(false);
		this.hasFlaggedSubMessage(false);
	};

	/**
  * @param {Array} properties
  * @returns {Array}
  */


	MessageModel.prototype.getEmails = function getEmails(properties) {
		var _this2 = this;

		return __WEBPACK_IMPORTED_MODULE_0_____default.a.compact(__WEBPACK_IMPORTED_MODULE_0_____default.a.uniq(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(__WEBPACK_IMPORTED_MODULE_0_____default.a.reduce(properties, function (carry, property) {
			return carry.concat(_this2[property]);
		}, []), function (oItem) {
			return oItem ? oItem.email : '';
		})));
	};

	/**
  * @returns {Array}
  */


	MessageModel.prototype.getRecipientsEmails = function getRecipientsEmails() {
		return this.getEmails(['to', 'cc']);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.friendlySize = function friendlySize() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["friendlySize"])(this.size());
	};

	MessageModel.prototype.computeSenderEmail = function computeSenderEmail() {
		var sentFolder = __webpack_require__(/*! Stores/User/Folder */ 20).sentFolder(),
		    draftFolder = __webpack_require__(/*! Stores/User/Folder */ 20).draftFolder();

		this.senderEmailsString(this.folderFullNameRaw === sentFolder || this.folderFullNameRaw === draftFolder ? this.toEmailsString() : this.fromEmailString());

		this.senderClearEmailsString(this.folderFullNameRaw === sentFolder || this.folderFullNameRaw === draftFolder ? this.toClearEmailsString() : this.fromClearEmailString());
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initByJson = function initByJson(json) {
		var result = false,
		    priority = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal;

		if (json && 'Object/Message' === json['@Object']) {
			priority = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(json.Priority);
			this.priority(-1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["inArray"])(priority, [__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].High, __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Low]) ? priority : __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);

			this.folderFullNameRaw = json.Folder;
			this.uid = json.Uid;
			this.hash = json.Hash;
			this.requestHash = json.RequestHash;

			this.proxy = !!json.ExternalProxy;

			this.size(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(json.Size));

			this.from = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.From);
			this.to = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.To);
			this.cc = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.Cc);
			this.bcc = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.Bcc);
			this.replyTo = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.ReplyTo);
			this.deliveredTo = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayFromJson"])(json.DeliveredTo);

			this.subject(json.Subject);
			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(json.SubjectParts)) {
				this.subjectPrefix(json.SubjectParts[0]);
				this.subjectSuffix(json.SubjectParts[1]);
			} else {
				this.subjectPrefix('');
				this.subjectSuffix(this.subject());
			}

			this.dateTimeStampInUTC(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(json.DateTimeStampInUTC));
			this.hasAttachments(!!json.HasAttachments);
			this.attachmentsSpecData(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(json.AttachmentsSpecData) ? json.AttachmentsSpecData : []);

			this.fromEmailString(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.from, true));
			this.fromClearEmailString(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToStringClear"])(this.from));
			this.toEmailsString(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.to, true));
			this.toClearEmailsString(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToStringClear"])(this.to));

			this.threads(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(json.Threads) ? json.Threads : []);

			this.initFlagsByJson(json);
			this.computeSenderEmail();

			result = true;
		}

		return result;
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initUpdateByMessageJson = function initUpdateByMessageJson(json) {
		var result = false,
		    priority = __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal;

		if (json && 'Object/Message' === json['@Object']) {
			priority = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pInt"])(json.Priority);
			this.priority(-1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["inArray"])(priority, [__WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].High, __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Low]) ? priority : __WEBPACK_IMPORTED_MODULE_3_Common_Enums__["MessagePriority"].Normal);

			this.aDraftInfo = json.DraftInfo;

			this.sMessageId = json.MessageId;
			this.sInReplyTo = json.InReplyTo;
			this.sReferences = json.References;

			this.proxy = !!json.ExternalProxy;

			if (__webpack_require__(/*! Stores/User/Pgp */ 31).capaOpenPGP()) {
				this.isPgpSigned(!!json.PgpSigned);
				this.isPgpEncrypted(!!json.PgpEncrypted);
			}

			this.hasAttachments(!!json.HasAttachments);
			this.attachmentsSpecData(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(json.AttachmentsSpecData) ? json.AttachmentsSpecData : []);

			this.foundedCIDs = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(json.FoundedCIDs) ? json.FoundedCIDs : [];
			this.attachments(this.initAttachmentsFromJson(json.Attachments));

			this.readReceipt(json.ReadReceipt || '');

			this.computeSenderEmail();

			result = true;
		}

		return result;
	};

	/**
  * @param {(AjaxJsonAttachment|null)} oJsonAttachments
  * @returns {Array}
  */


	MessageModel.prototype.initAttachmentsFromJson = function initAttachmentsFromJson(json) {
		var index = 0,
		    len = 0,
		    attachment = null;
		var result = [];

		if (json && 'Collection/AttachmentCollection' === json['@Object'] && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isNonEmptyArray"])(json['@Collection'])) {
			for (index = 0, len = json['@Collection'].length; index < len; index++) {
				attachment = __WEBPACK_IMPORTED_MODULE_8_Model_Attachment__["b" /* AttachmentModel */].newInstanceFromJson(json['@Collection'][index]);
				if (attachment) {
					if ('' !== attachment.cidWithOutTags && 0 < this.foundedCIDs.length && 0 <= __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["inArray"])(attachment.cidWithOutTags, this.foundedCIDs)) {
						attachment.isLinked = true;
					}

					result.push(attachment);
				}
			}
		}

		return result;
	};

	/**
  * @param {AjaxJsonMessage} json
  * @returns {boolean}
  */


	MessageModel.prototype.initFlagsByJson = function initFlagsByJson(json) {
		var result = false;
		if (json && 'Object/Message' === json['@Object']) {
			this.unseen(!json.IsSeen);
			this.flagged(!!json.IsFlagged);
			this.answered(!!json.IsAnswered);
			this.forwarded(!!json.IsForwarded);
			this.isReadReceipt(!!json.IsReadReceipt);
			this.deletedMark(!!json.IsDeleted);

			result = true;
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.fromToLine = function fromToLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.from, friendlyView, wrapWithLink);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.fromDkimData = function fromDkimData() {
		var result = ['none', ''];
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isNonEmptyArray"])(this.from) && 1 === this.from.length && this.from[0] && this.from[0].dkimStatus) {
			result = [this.from[0].dkimStatus, this.from[0].dkimValue || ''];
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.toToLine = function toToLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.to, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.ccToLine = function ccToLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.cc, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.bccToLine = function bccToLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.bcc, friendlyView, wrapWithLink);
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @returns {string}
  */


	MessageModel.prototype.replyToToLine = function replyToToLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["emailArrayToString"])(this.replyTo, friendlyView, wrapWithLink);
	};

	/**
  * @return string
  */


	MessageModel.prototype.lineAsCss = function lineAsCss() {
		var result = [];
		if (this.deleted()) {
			result.push('deleted');
		}
		if (this.deletedMark()) {
			result.push('deleted-mark');
		}
		if (this.selected()) {
			result.push('selected');
		}
		if (this.checked()) {
			result.push('checked');
		}
		if (this.flagged()) {
			result.push('flagged');
		}
		if (this.unseen()) {
			result.push('unseen');
		}
		if (this.answered()) {
			result.push('answered');
		}
		if (this.forwarded()) {
			result.push('forwarded');
		}
		if (this.focused()) {
			result.push('focused');
		}
		if (this.isImportant()) {
			result.push('important');
		}
		if (this.hasAttachments()) {
			result.push('withAttachments');
		}
		if (this.newForAnimation()) {
			result.push('new');
		}
		if ('' === this.subject()) {
			result.push('emptySubject');
		}
		//		if (1 < this.threadsLen())
		//		{
		//			result.push('hasChildrenMessage');
		//		}
		if (this.hasUnseenSubMessage()) {
			result.push('hasUnseenSubMessage');
		}
		if (this.hasFlaggedSubMessage()) {
			result.push('hasFlaggedSubMessage');
		}

		return result.join(' ');
	};

	/**
  * @returns {boolean}
  */


	MessageModel.prototype.hasVisibleAttachments = function hasVisibleAttachments() {
		return !!__WEBPACK_IMPORTED_MODULE_0_____default.a.find(this.attachments(), function (item) {
			return !item.isLinked;
		});
	};

	/**
  * @param {string} cid
  * @returns {*}
  */


	MessageModel.prototype.findAttachmentByCid = function findAttachmentByCid(cid) {
		var result = null;
		var attachments = this.attachments();

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isNonEmptyArray"])(attachments)) {
			cid = cid.replace(/^<+/, '').replace(/>+$/, '');
			result = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(attachments, function (item) {
				return cid === item.cidWithOutTags;
			});
		}

		return result || null;
	};

	/**
  * @param {string} contentLocation
  * @returns {*}
  */


	MessageModel.prototype.findAttachmentByContentLocation = function findAttachmentByContentLocation(contentLocation) {
		var result = null;
		var attachments = this.attachments();

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isNonEmptyArray"])(attachments)) {
			result = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(attachments, function (item) {
				return contentLocation === item.contentLocation;
			});
		}

		return result || null;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.messageId = function messageId() {
		return this.sMessageId;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.inReplyTo = function inReplyTo() {
		return this.sInReplyTo;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.references = function references() {
		return this.sReferences;
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.fromAsSingleEmail = function fromAsSingleEmail() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isArray"])(this.from) && this.from[0] ? this.from[0].email : '';
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.viewLink = function viewLink() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["messageViewLink"])(this.requestHash);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.downloadLink = function downloadLink() {
		return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Links__["messageDownloadLink"])(this.requestHash);
	};

	/**
  * @param {Object} excludeEmails
  * @param {boolean=} last = false
  * @returns {Array}
  */


	MessageModel.prototype.replyEmails = function replyEmails(excludeEmails) {
		var last = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		var result = [],
		    unic = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(excludeEmails) ? {} : excludeEmails;

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.replyTo, unic, result);
		if (0 === result.length) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.from, unic, result);
		}

		if (0 === result.length && !last) {
			return this.replyEmails({}, true);
		}

		return result;
	};

	/**
  * @param {Object} excludeEmails
  * @param {boolean=} last = false
  * @returns {Array.<Array>}
  */


	MessageModel.prototype.replyAllEmails = function replyAllEmails(excludeEmails) {
		var last = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		var data = [];
		var toResult = [],
		    ccResult = [],
		    unic = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(excludeEmails) ? {} : excludeEmails;

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.replyTo, unic, toResult);
		if (0 === toResult.length) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.from, unic, toResult);
		}

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.to, unic, toResult);
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Helper_Message__["replyHelper"])(this.cc, unic, ccResult);

		if (0 === toResult.length && !last) {
			data = this.replyAllEmails({}, true);
			return [data[0], ccResult];
		}

		return [toResult, ccResult];
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.textBodyToString = function textBodyToString() {
		return this.body ? this.body.html() : '';
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.attachmentsToStringLine = function attachmentsToStringLine() {
		var attachLines = __WEBPACK_IMPORTED_MODULE_0_____default.a.map(this.attachments(), function (item) {
			return item.fileName + ' (' + item.friendlySize + ')';
		});
		return attachLines && 0 < attachLines.length ? attachLines.join(', ') : '';
	};

	/**
  * @param {boolean=} print = false
  */


	MessageModel.prototype.viewPopupMessage = function viewPopupMessage() {
		var print = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		this.showLazyExternalImagesInBody();
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["previewMessage"])(this.subject(), this.body, this.isHtml(), print);
	};

	MessageModel.prototype.printMessage = function printMessage() {
		this.viewPopupMessage(true);
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.generateUid = function generateUid() {
		return this.folderFullNameRaw + '/' + this.uid;
	};

	/**
  * @param {MessageModel} message
  * @returns {MessageModel}
  */


	MessageModel.prototype.populateByMessageListItem = function populateByMessageListItem(message) {
		if (message) {
			this.folderFullNameRaw = message.folderFullNameRaw;
			this.uid = message.uid;
			this.hash = message.hash;
			this.requestHash = message.requestHash;
			this.subject(message.subject());
		}

		this.subjectPrefix(this.subjectPrefix());
		this.subjectSuffix(this.subjectSuffix());

		if (message) {
			this.size(message.size());
			this.dateTimeStampInUTC(message.dateTimeStampInUTC());
			this.priority(message.priority());

			this.proxy = message.proxy;

			this.fromEmailString(message.fromEmailString());
			this.fromClearEmailString(message.fromClearEmailString());
			this.toEmailsString(message.toEmailsString());
			this.toClearEmailsString(message.toClearEmailsString());

			this.emails = message.emails;

			this.from = message.from;
			this.to = message.to;
			this.cc = message.cc;
			this.bcc = message.bcc;
			this.replyTo = message.replyTo;
			this.deliveredTo = message.deliveredTo;

			this.unseen(message.unseen());
			this.flagged(message.flagged());
			this.answered(message.answered());
			this.forwarded(message.forwarded());
			this.isReadReceipt(message.isReadReceipt());
			this.deletedMark(message.deletedMark());

			this.priority(message.priority());

			this.selected(message.selected());
			this.checked(message.checked());
			this.hasAttachments(message.hasAttachments());
			this.attachmentsSpecData(message.attachmentsSpecData());
		}

		this.body = null;

		this.aDraftInfo = [];
		this.sMessageId = '';
		this.sInReplyTo = '';
		this.sReferences = '';

		if (message) {
			this.threads(message.threads());
		}

		this.computeSenderEmail();

		return this;
	};

	MessageModel.prototype.showLazyExternalImagesInBody = function showLazyExternalImagesInBody() {
		if (this.body) {
			__WEBPACK_IMPORTED_MODULE_1_____default()('.lazy.lazy-inited[data-original]', this.body).each(function () {
				__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('src', __WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-original')).removeAttr('data-original');
			});
		}
	};

	MessageModel.prototype.showExternalImages = function showExternalImages() {
		var lazy = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		if (this.body && this.body.data('rl-has-images')) {
			this.hasImages(false);
			this.body.data('rl-has-images', false);

			var sAttr = this.proxy ? 'data-x-additional-src' : 'data-x-src';
			__WEBPACK_IMPORTED_MODULE_1_____default()('[' + sAttr + ']', this.body).each(function () {
				if (lazy && __WEBPACK_IMPORTED_MODULE_1_____default()(this).is('img')) {
					__WEBPACK_IMPORTED_MODULE_1_____default()(this).addClass('lazy').attr('data-original', __WEBPACK_IMPORTED_MODULE_1_____default()(this).attr(sAttr)).removeAttr(sAttr);
				} else {
					__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('src', __WEBPACK_IMPORTED_MODULE_1_____default()(this).attr(sAttr)).removeAttr(sAttr);
				}
			});

			sAttr = this.proxy ? 'data-x-additional-style-url' : 'data-x-style-url';
			__WEBPACK_IMPORTED_MODULE_1_____default()('[' + sAttr + ']', this.body).each(function () {
				var sStyle = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["trim"])(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('style'));
				sStyle = '' === sStyle ? '' : ';' === sStyle.substr(-1) ? sStyle + ' ' : sStyle + '; ';
				__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('style', sStyle + __WEBPACK_IMPORTED_MODULE_1_____default()(this).attr(sAttr)).removeAttr(sAttr);
			});

			if (lazy) {
				__WEBPACK_IMPORTED_MODULE_1_____default()('img.lazy', this.body).addClass('lazy-inited').lazyload({
					'threshold': 400,
					'effect': 'fadeIn',
					'skip_invisible': false,
					'container': __WEBPACK_IMPORTED_MODULE_1_____default()('.RL-MailMessageView .messageView .messageItem .content')[0]
				});

				__WEBPACK_IMPORTED_MODULE_5_Common_Globals__["$win"].resize();
			}

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["windowResize"])(500);
		}
	};

	MessageModel.prototype.showInternalImages = function showInternalImages() {
		var lazy = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		if (this.body && !this.body.data('rl-init-internal-images')) {
			this.body.data('rl-init-internal-images', true);

			var self = this;

			__WEBPACK_IMPORTED_MODULE_1_____default()('[data-x-src-cid]', this.body).each(function () {
				var attachment = self.findAttachmentByCid(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-x-src-cid'));
				if (attachment && attachment.download) {
					if (lazy && __WEBPACK_IMPORTED_MODULE_1_____default()(this).is('img')) {
						__WEBPACK_IMPORTED_MODULE_1_____default()(this).addClass('lazy').attr('data-original', attachment.linkPreview());
					} else {
						__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('src', attachment.linkPreview());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_1_____default()('[data-x-src-location]', this.body).each(function () {
				var attachment = self.findAttachmentByContentLocation(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-x-src-location'));
				if (!attachment) {
					attachment = self.findAttachmentByCid(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-x-src-location'));
				}

				if (attachment && attachment.download) {
					if (lazy && __WEBPACK_IMPORTED_MODULE_1_____default()(this).is('img')) {
						__WEBPACK_IMPORTED_MODULE_1_____default()(this).addClass('lazy').attr('data-original', attachment.linkPreview());
					} else {
						__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('src', attachment.linkPreview());
					}
				}
			});

			__WEBPACK_IMPORTED_MODULE_1_____default()('[data-x-style-cid]', this.body).each(function () {
				var style = '',
				    name = '';
				var attachment = self.findAttachmentByCid(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-x-style-cid'));

				if (attachment && attachment.linkPreview) {
					name = __WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('data-x-style-cid-name');
					if ('' !== name) {
						style = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["trim"])(__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('style'));
						style = '' === style ? '' : ';' === style.substr(-1) ? style + ' ' : style + '; ';
						__WEBPACK_IMPORTED_MODULE_1_____default()(this).attr('style', style + name + ': url(\'' + attachment.linkPreview() + '\')');
					}
				}
			});

			if (lazy) {
				(function ($oImg, oContainer) {
					__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
						$oImg.addClass('lazy-inited').lazyload({
							'threshold': 400,
							'effect': 'fadeIn',
							'skip_invisible': false,
							'container': oContainer
						});
					}, 300);
				})(__WEBPACK_IMPORTED_MODULE_1_____default()('img.lazy', self.body), __WEBPACK_IMPORTED_MODULE_1_____default()('.RL-MailMessageView .messageView .messageItem .content')[0]);
			}

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["windowResize"])(500);
		}
	};

	MessageModel.prototype.storeDataInDom = function storeDataInDom() {
		if (this.body) {
			this.body.data('rl-is-html', !!this.isHtml());
			this.body.data('rl-has-images', !!this.hasImages());
		}
	};

	MessageModel.prototype.fetchDataFromDom = function fetchDataFromDom() {
		if (this.body) {
			this.isHtml(!!this.body.data('rl-is-html'));
			this.hasImages(!!this.body.data('rl-has-images'));
		}
	};

	MessageModel.prototype.replacePlaneTextBody = function replacePlaneTextBody(plain) {
		if (this.body) {
			this.body.html(plain).addClass('b-text-part plain');
		}
	};

	/**
  * @returns {string}
  */


	MessageModel.prototype.flagHash = function flagHash() {
		return [this.deleted(), this.deletedMark(), this.unseen(), this.flagged(), this.answered(), this.forwarded(), this.isReadReceipt()].join(',');
	};

	return MessageModel;
}(__WEBPACK_IMPORTED_MODULE_9_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 170 */
/*!**********************************!*\
  !*** ./dev/Model/OpenPgpKey.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp__ = __webpack_require__(/*! Stores/User/Pgp */ 31);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp___default = __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp__ && __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp___default, 'a', __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp___default);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return OpenPgpKeyModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }









var OpenPgpKeyModel = function (_AbstractModel) {
	_inherits(OpenPgpKeyModel, _AbstractModel);

	/**
  * @param {string} index
  * @param {string} guID
  * @param {string} ID
  * @param {array} IDs
  * @param {array} userIDs
  * @param {array} emails
  * @param {boolean} isPrivate
  * @param {string} armor
  * @param {string} userID
  */

	function OpenPgpKeyModel(index, guID, ID, IDs, userIDs, emails, isPrivate, armor, userID) {
		_classCallCheck(this, OpenPgpKeyModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'OpenPgpKeyModel'));

		_this.index = index;
		_this.id = ID;
		_this.ids = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNonEmptyArray"])(IDs) ? IDs : [ID];
		_this.guid = guID;
		_this.user = '';
		_this.users = userIDs;
		_this.email = '';
		_this.emails = emails;
		_this.armor = armor;
		_this.isPrivate = !!isPrivate;

		_this.selectUser(userID);

		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		return _this;
	}

	OpenPgpKeyModel.prototype.getNativeKey = function getNativeKey() {
		var key = null;
		try {
			key = __WEBPACK_IMPORTED_MODULE_3_Stores_User_Pgp___default.a.openpgp.key.readArmored(this.armor);
			if (key && !key.err && key.keys && key.keys[0]) {
				return key;
			}
		} catch (e) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["log"])(e);
		}

		return null;
	};

	OpenPgpKeyModel.prototype.getNativeKeys = function getNativeKeys() {
		var key = this.getNativeKey();
		return key && key.keys ? key.keys : null;
	};

	OpenPgpKeyModel.prototype.select = function select(pattern, property) {
		if (this[property]) {
			var index = this[property].indexOf(pattern);
			if (-1 !== index) {
				this.user = this.users[index];
				this.email = this.emails[index];
			}
		}
	};

	OpenPgpKeyModel.prototype.selectUser = function selectUser(user) {
		this.select(user, 'users');
	};

	OpenPgpKeyModel.prototype.selectEmail = function selectEmail(email) {
		this.select(email, 'emails');
	};

	return OpenPgpKeyModel;
}(__WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 171 */
/*!********************************!*\
  !*** ./dev/Model/Template.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__ = __webpack_require__(/*! Knoin/AbstractModel */ 27);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return TemplateModel; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var TemplateModel = function (_AbstractModel) {
	_inherits(TemplateModel, _AbstractModel);

	/**
  * @param {string} id
  * @param {string} name
  * @param {string} body
  */

	function TemplateModel(id, name, body) {
		_classCallCheck(this, TemplateModel);

		var _this = _possibleConstructorReturn(this, _AbstractModel.call(this, 'TemplateModel'));

		_this.id = id;
		_this.name = name;
		_this.body = body;
		_this.populated = true;

		_this.deleteAccess = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		return _this;
	}

	/**
  * @returns {boolean}
  */


	TemplateModel.prototype.parse = function parse(json) {
		var result = false;
		if (json && 'Object/Template' === json['@Object']) {
			this.id = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(json.ID);
			this.name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(json.Name);
			this.body = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(json.Body);
			this.populated = !!json.Populated;

			result = true;
		}

		return result;
	};

	return TemplateModel;
}(__WEBPACK_IMPORTED_MODULE_2_Knoin_AbstractModel__["a" /* AbstractModel */]);



/***/ },
/* 172 */,
/* 173 */,
/* 174 */
/*!***********************************!*\
  !*** ./dev/Screen/User/Login.jsx ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Knoin_AbstractScreen__ = __webpack_require__(/*! Knoin/AbstractScreen */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_App_User__ = __webpack_require__(/*! App/User */ 8);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return LoginUserScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var LoginUserScreen = function (_AbstractScreen) {
	_inherits(LoginUserScreen, _AbstractScreen);

	function LoginUserScreen() {
		_classCallCheck(this, LoginUserScreen);

		return _possibleConstructorReturn(this, _AbstractScreen.call(this, 'login', [__webpack_require__(/*! View/User/Login */ 151)]));
	}

	LoginUserScreen.prototype.onShow = function onShow() {
		__WEBPACK_IMPORTED_MODULE_1_App_User__["default"].setWindowTitle('');
	};

	return LoginUserScreen;
}(__WEBPACK_IMPORTED_MODULE_0_Knoin_AbstractScreen__["a" /* AbstractScreen */]);



/***/ },
/* 175 */
/*!*************************************!*\
  !*** ./dev/Screen/User/MailBox.jsx ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Cache__ = __webpack_require__(/*! Common/Cache */ 19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Stores_User_App__ = __webpack_require__(/*! Stores/User/App */ 22);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Stores_User_App___default = __WEBPACK_IMPORTED_MODULE_8_Stores_User_App__ && __WEBPACK_IMPORTED_MODULE_8_Stores_User_App__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_8_Stores_User_App__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_8_Stores_User_App__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_8_Stores_User_App___default, 'a', __WEBPACK_IMPORTED_MODULE_8_Stores_User_App___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account__ = __webpack_require__(/*! Stores/User/Account */ 28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account___default = __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account__ && __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_9_Stores_User_Account__; };
/* harmony import */ __webpack