/* RainLoop Webmail (c) RainLoop Team | Licensed under RainLoop Software License */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.l = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// identity function for calling harmory imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };

/******/ 	// define getter function for harmory exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		Object.defineProperty(exports, name, {
/******/ 			configurable: false,
/******/ 			enumerable: true,
/******/ 			get: getter
/******/ 		});
/******/ 	};

/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "rainloop/v/0.0.0/static/js/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 177);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!******************************!*\
  !*** ./dev/Common/Utils.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko___default = __WEBPACK_IMPORTED_MODULE_3_ko__ && __WEBPACK_IMPORTED_MODULE_3_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_3_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Mime__ = __webpack_require__(/*! Common/Mime */ 69);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__ = __webpack_require__(/*! JSEncrypt */ 85);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default = __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__ && __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_7_JSEncrypt__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default, 'a', __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Autolinker__ = __webpack_require__(/*! Autolinker */ 84);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Autolinker___default = __WEBPACK_IMPORTED_MODULE_8_Autolinker__ && __WEBPACK_IMPORTED_MODULE_8_Autolinker__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_8_Autolinker__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_8_Autolinker__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_8_Autolinker___default, 'a', __WEBPACK_IMPORTED_MODULE_8_Autolinker___default);

/* harmony export */ __webpack_require__.d(exports, "isArray", function() { return isArray; });
/* harmony export */ __webpack_require__.d(exports, "isObject", function() { return isObject; });
/* harmony export */ __webpack_require__.d(exports, "isUnd", function() { return isUnd; });
/* harmony export */ __webpack_require__.d(exports, "isNull", function() { return isNull; });
/* harmony export */ __webpack_require__.d(exports, "has", function() { return has; });
/* harmony export */ __webpack_require__.d(exports, "bind", function() { return bind; });
/* harmony export */ __webpack_require__.d(exports, "noop", function() { return noop; });
/* harmony export */ __webpack_require__.d(exports, "noopTrue", function() { return noopTrue; });
/* harmony export */ __webpack_require__.d(exports, "noopFalse", function() { return noopFalse; });
/* harmony export */ __webpack_require__.d(exports, "trim", function() { return trim; });
/* harmony export */ __webpack_require__.d(exports, "inArray", function() { return inArray; });
/* harmony export */ __webpack_require__.d(exports, "isFunc", function() { return isFunc; });/* harmony export */ exports["silentTryCatch"] = silentTryCatch;/* harmony export */ exports["isNormal"] = isNormal;/* harmony export */ exports["isPosNumeric"] = isPosNumeric;/* harmony export */ exports["pInt"] = pInt;/* harmony export */ exports["pString"] = pString;/* harmony export */ exports["pBool"] = pBool;/* harmony export */ exports["isNonEmptyArray"] = isNonEmptyArray;/* harmony export */ exports["encodeURIComponent"] = encodeURIComponent;/* harmony export */ exports["decodeURIComponent"] = decodeURIComponent;/* harmony export */ exports["decodeURI"] = decodeURI;/* harmony export */ exports["encodeURI"] = encodeURI;/* harmony export */ exports["simpleQueryParser"] = simpleQueryParser;/* harmony export */ exports["fakeMd5"] = fakeMd5;
/* harmony export */ __webpack_require__.d(exports, "rsaEncode", function() { return rsaEncode; });/* harmony export */ exports["encodeHtml"] = encodeHtml;/* harmony export */ exports["splitPlainText"] = splitPlainText;
/* harmony export */ __webpack_require__.d(exports, "timeOutAction", function() { return timeOutAction; });
/* harmony export */ __webpack_require__.d(exports, "timeOutActionSecond", function() { return timeOutActionSecond; });/* harmony export */ exports["inFocus"] = inFocus;/* harmony export */ exports["removeInFocus"] = removeInFocus;/* harmony export */ exports["removeSelection"] = removeSelection;/* harmony export */ exports["replySubjectAdd"] = replySubjectAdd;/* harmony export */ exports["roundNumber"] = roundNumber;/* harmony export */ exports["friendlySize"] = friendlySize;/* harmony export */ exports["log"] = log;/* harmony export */ exports["delegateRun"] = delegateRun;/* harmony export */ exports["kill_CtrlA_CtrlS"] = kill_CtrlA_CtrlS;/* harmony export */ exports["createCommand"] = createCommand;
/* harmony export */ __webpack_require__.d(exports, "convertThemeName", function() { return convertThemeName; });/* harmony export */ exports["quoteName"] = quoteName;/* harmony export */ exports["microtime"] = microtime;/* harmony export */ exports["timestamp"] = timestamp;/* harmony export */ exports["convertLangName"] = convertLangName;/* harmony export */ exports["draggablePlace"] = draggablePlace;/* harmony export */ exports["defautOptionsAfterRender"] = defautOptionsAfterRender;/* harmony export */ exports["clearBqSwitcher"] = clearBqSwitcher;/* harmony export */ exports["previewMessage"] = previewMessage;/* harmony export */ exports["settingsSaveHelperFunction"] = settingsSaveHelperFunction;/* harmony export */ exports["settingsSaveHelperSimpleFunction"] = settingsSaveHelperSimpleFunction;/* harmony export */ exports["settingsSaveHelperSubscribeFunction"] = settingsSaveHelperSubscribeFunction;/* harmony export */ exports["findEmailAndLinks"] = findEmailAndLinks;/* harmony export */ exports["htmlToPlain"] = htmlToPlain;/* harmony export */ exports["plainToHtml"] = plainToHtml;/* harmony export */ exports["folderListOptionsBuilder"] = folderListOptionsBuilder;/* harmony export */ exports["selectElement"] = selectElement;
/* harmony export */ __webpack_require__.d(exports, "detectDropdownVisibility", function() { return detectDropdownVisibility; });/* harmony export */ exports["triggerAutocompleteInputChange"] = triggerAutocompleteInputChange;/* harmony export */ exports["getConfigurationFromScriptTag"] = getConfigurationFromScriptTag;/* harmony export */ exports["disposeOne"] = disposeOne;/* harmony export */ exports["disposeObject"] = disposeObject;/* harmony export */ exports["delegateRunOnDestroy"] = delegateRunOnDestroy;/* harmony export */ exports["appendStyles"] = appendStyles;/* harmony export */ exports["changeTheme"] = changeTheme;/* harmony export */ exports["computedPagenatorHelper"] = computedPagenatorHelper;/* harmony export */ exports["getFileExtension"] = getFileExtension;/* harmony export */ exports["mimeContentType"] = mimeContentType;/* harmony export */ exports["resizeAndCrop"] = resizeAndCrop;/* harmony export */ exports["mailToHelper"] = mailToHelper;
/* harmony export */ __webpack_require__.d(exports, "windowResize", function() { return windowResize; });/* harmony export */ exports["windowResizeCallback"] = windowResizeCallback;var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };












var trim = __WEBPACK_IMPORTED_MODULE_1_____default.a.trim;
var inArray = __WEBPACK_IMPORTED_MODULE_1_____default.a.inArray;
var isArray = __WEBPACK_IMPORTED_MODULE_2_____default.a.isArray;
var isObject = __WEBPACK_IMPORTED_MODULE_2_____default.a.isObject;
var isFunc = __WEBPACK_IMPORTED_MODULE_2_____default.a.isFunction;
var isUnd = __WEBPACK_IMPORTED_MODULE_2_____default.a.isUndefined;
var isNull = __WEBPACK_IMPORTED_MODULE_2_____default.a.isNull;
var has = __WEBPACK_IMPORTED_MODULE_2_____default.a.has;
var bind = __WEBPACK_IMPORTED_MODULE_2_____default.a.bind;
var noop = function noop() {}; // eslint-disable-line no-empty-function
var noopTrue = function noopTrue() {
	return true;
};
var noopFalse = function noopFalse() {
	return false;
};



/**
 * @param {Function} func
 */
function silentTryCatch(func) {
	try {
		func();
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function isNormal(value) {
	return !isUnd(value) && !isNull(value);
}

/**
 * @param {(string|number)} value
 * @param {boolean=} includeZero = true
 * @returns {boolean}
 */
function isPosNumeric(value) {
	var includeZero = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];

	return !isNormal(value) ? false : includeZero ? /^[0-9]*$/.test(value.toString()) : /^[1-9]+[0-9]*$/.test(value.toString());
}

/**
 * @param {*} value
 * @param {number=} defaultValur = 0
 * @returns {number}
 */
function pInt(value) {
	var defaultValur = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];

	var result = isNormal(value) && '' !== value ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(value, 10) : defaultValur;
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.isNaN(result) ? defaultValur : result;
}

/**
 * @param {*} value
 * @returns {string}
 */
function pString(value) {
	return isNormal(value) ? '' + value : '';
}

/**
 * @param {*} value
 * @returns {boolean}
 */
function pBool(value) {
	return !!value;
}

/**
 * @param {*} values
 * @returns {boolean}
 */
function isNonEmptyArray(values) {
	return isArray(values) && 0 < values.length;
}

/**
 * @param {string} component
 * @returns {string}
 */
function encodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURIComponent(component);
}

/**
 * @param {string} component
 * @returns {string}
 */
function decodeURIComponent(component) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURIComponent(component);
}

/**
 * @param {string} url
 * @returns {string}
 */
function decodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.decodeURI(url);
}

/**
 * @param {string} url
 * @returns {string}
 */
function encodeURI(url) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(url);
}

/**
 * @param {string} queryString
 * @returns {Object}
 */
function simpleQueryParser(queryString) {
	var index = 0,
	    len = 0,
	    temp = null;

	var queries = queryString.split('&'),
	    params = {};

	for (len = queries.length; index < len; index++) {
		temp = queries[index].split('=');
		params[decodeURIComponent(temp[0])] = decodeURIComponent(temp[1]);
	}

	return params;
}

/**
 * @param {number=} len = 32
 * @returns {string}
 */
function fakeMd5() {
	var len = arguments.length <= 0 || arguments[0] === undefined ? 32 : arguments[0];

	var line = '0123456789abcdefghijklmnopqrstuvwxyz',
	    lineLen = line.length;

	len = pInt(len);

	var result = '';
	while (result.length < len) {
		result += line.substr(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(__WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.random() * lineLen), 1);
	}

	return result;
}

var encryptObject = null;

/**
 * @param {constructor} JSEncryptClass
 * @param {string} publicKey
 * @returns {JSEncrypt|boolean}
 */
var rsaObject = function rsaObject(JSEncryptClass, publicKey) {

	if (JSEncryptClass && publicKey && (null === encryptObject || encryptObject && encryptObject.__publicKey !== publicKey) && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues) {
		encryptObject = new JSEncryptClass();
		encryptObject.setPublicKey(publicKey);
		encryptObject.__publicKey = publicKey;
	} else {
		encryptObject = false;
	}

	return encryptObject;
};

/**
 * @param {string} value
 * @param {string} publicKey
 * @returns {string}
 */
var rsaEncode = function rsaEncode(value, publicKey) {

	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues && publicKey) {
		var resultValue = false;
		var encrypt = rsaObject(__WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default.a, publicKey);

		if (encrypt) {
			resultValue = encrypt.encrypt(fakeMd5() + ':' + value + ':' + fakeMd5());
			if (false !== resultValue && isNormal(resultValue)) {
				return 'rsa:xxx:' + resultValue;
			}
		}
	}

	return value;
};

rsaEncode.supported = !!(__WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto && __WEBPACK_IMPORTED_MODULE_0_window___default.a.crypto.getRandomValues && false && __WEBPACK_IMPORTED_MODULE_7_JSEncrypt___default.a);



/**
 * @param {string} text
 * @returns {string}
 */
function encodeHtml(text) {
	return isNormal(text) ? __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(text.toString()) : '';
}

/**
 * @param {string} text
 * @param {number=} iLen = 100
 * @returns {string}
 */
function splitPlainText(text) {
	var len = arguments.length <= 1 || arguments[1] === undefined ? 100 : arguments[1];

	var prefix = '',
	    subText = '',
	    result = text,
	    spacePos = 0,
	    newLinePos = 0;

	while (result.length > len) {
		subText = result.substring(0, len);
		spacePos = subText.lastIndexOf(' ');
		newLinePos = subText.lastIndexOf('\n');

		if (-1 !== newLinePos) {
			spacePos = newLinePos;
		}

		if (-1 === spacePos) {
			spacePos = len;
		}

		prefix += subText.substring(0, spacePos) + '\n';
		result = result.substring(spacePos + 1);
	}

	return prefix + result;
}

var timeOutAction = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		timeOuts[action] = isUnd(timeOuts[action]) ? 0 : timeOuts[action];
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(timeOuts[action]);
		timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(fFunction, timeOut);
	};
}();

var timeOutActionSecond = function () {
	var timeOuts = {};
	return function (action, fFunction, timeOut) {
		if (!timeOuts[action]) {
			timeOuts[action] = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				fFunction();
				timeOuts[action] = 0;
			}, timeOut);
		}
	};
}();



/**
 * @returns {boolean}
 */
function inFocus() {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement) {
		if (isUnd(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache)) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement).is('input,textarea,iframe,.cke_editable');
		}

		return !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.__inFocusCache;
	}

	return false;
}

/**
 * @param {boolean} force
 * @returns {void}
 */
function removeInFocus(force) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur) {
		try {
			var activeEl = __WEBPACK_IMPORTED_MODULE_1_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement);
			if (activeEl && activeEl.is('input,textarea')) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			} else if (force) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.activeElement.blur();
			}
		} catch (e) {} // eslint-disable-line no-empty
	}
}

/**
 * @returns {void}
 */
function removeSelection() {
	try {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a && __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
			var sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
			if (sel && sel.removeAllRanges) {
				sel.removeAllRanges();
			}
		} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.empty();
		}
	} catch (e) {} // eslint-disable-line no-empty
}

/**
 * @param {string} prefix
 * @param {string} subject
 * @returns {string}
 */
function replySubjectAdd(prefix, subject) {
	prefix = trim(prefix.toUpperCase());
	subject = trim(subject.replace(/[\s]+/g, ' '));

	var drop = false,
	    re = 'RE' === prefix,
	    fwd = 'FWD' === prefix;

	var parts = [],
	    prefixIsRe = !fwd;

	if ('' !== subject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.each(subject.split(':'), function (part) {
			var trimmedPart = trim(part);
			if (!drop && (/^(RE|FWD)$/i.test(trimmedPart) || /^(RE|FWD)[\[\(][\d]+[\]\)]$/i.test(trimmedPart))) {
				if (!re) {
					re = !!/^RE/i.test(trimmedPart);
				}

				if (!fwd) {
					fwd = !!/^FWD/i.test(trimmedPart);
				}
			} else {
				parts.push(part);
				drop = true;
			}
		});
	}

	if (prefixIsRe) {
		re = false;
	} else {
		fwd = false;
	}

	return trim((prefixIsRe ? 'Re: ' : 'Fwd: ') + (re ? 'Re: ' : '') + (fwd ? 'Fwd: ' : '') + trim(parts.join(':')));
}

/**
 * @param {number} num
 * @param {number} dec
 * @returns {number}
 */
function roundNumber(num, dec) {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(num * __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec)) / __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.pow(10, dec);
}

/**
 * @param {(number|string)} sizeInBytes
 * @returns {string}
 */
function friendlySize(sizeInBytes) {
	sizeInBytes = pInt(sizeInBytes);

	switch (true) {
		case 1073741824 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1073741824, 1) + 'GB';
		case 1048576 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1048576, 1) + 'MB';
		case 1024 <= sizeInBytes:
			return roundNumber(sizeInBytes / 1024, 0) + 'KB';
		// no default
	}

	return sizeInBytes + 'B';
}

/**
 * @param {string} desc
 */
function log(desc) {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.console && __WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.console.log(desc);
	}
}

/**
 * @param {?} object
 * @param {string} methodName
 * @param {Array=} params
 * @param {number=} delay = 0
 */
function delegateRun(object, methodName, params) {
	var delay = arguments.length <= 3 || arguments[3] === undefined ? 0 : arguments[3];

	if (object && object[methodName]) {
		delay = pInt(delay);
		params = isArray(params) ? params : [];

		if (0 >= delay) {
			object[methodName].apply(object, params);
		} else {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				object[methodName].apply(object, params);
			}, delay);
		}
	}
}

/**
 * @param {?} event
 */
function kill_CtrlA_CtrlS(event) {
	event = event || __WEBPACK_IMPORTED_MODULE_0_window___default.a.event;
	if (event && event.ctrlKey && !event.shiftKey && !event.altKey) {
		var key = event.keyCode || event.which;
		if (key === __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].S) {
			event.preventDefault();
			return;
		} else if (key === __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["EventKeyCode"].A) {
			var sender = event.target || event.srcElement;
			if (sender && ('true' === '' + sender.contentEditable || sender.tagName && sender.tagName.match(/INPUT|TEXTAREA/i))) {
				return;
			}

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection().removeAllRanges();
			} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear) {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection.clear();
			}

			event.preventDefault();
		}
	}
}

/**
 * @param {(Object|null|undefined)} context
 * @param {Function} fExecute
 * @param {(Function|boolean|null)=} fCanExecute = true
 * @returns {Function}
 */
function createCommand(context, fExecute) {
	var fCanExecute = arguments.length <= 2 || arguments[2] === undefined ? true : arguments[2];

	var fResult = null;
	var fNonEmpty = function fNonEmpty() {
		for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
			args[_key] = arguments[_key];
		}

		if (fResult && fResult.canExecute && fResult.canExecute()) {
			fExecute.apply(context, args);
		}
		return false;
	};

	fResult = fExecute ? fNonEmpty : noop;
	fResult.enabled = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(true);

	if (isFunc(fCanExecute)) {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return fResult.enabled() && fCanExecute.call(context);
		});
	} else {
		fResult.canExecute = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.computed(function () {
			return fResult.enabled() && !!fCanExecute;
		});
	}

	return fResult;
}

/**
 * @param {string} theme
 * @returns {string}
 */
var convertThemeName = __WEBPACK_IMPORTED_MODULE_2_____default.a.memoize(function (theme) {

	if ('@custom' === theme.substr(-7)) {
		theme = trim(theme.substring(0, theme.length - 7));
	}

	return trim(theme.replace(/[^a-zA-Z0-9]+/g, ' ').replace(/([A-Z])/g, ' $1').replace(/[\s]+/g, ' '));
});

/**
 * @param {string} name
 * @returns {string}
 */
function quoteName(name) {
	return name.replace(/["]/g, '\\"');
}

/**
 * @returns {number}
 */
function microtime() {
	return new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();
}

/**
 * @returns {number}
 */
function timestamp() {
	return __WEBPACK_IMPORTED_MODULE_0_window___default.a.Math.round(microtime() / 1000);
}

/**
 *
 * @param {string} language
 * @param {boolean=} isEng = false
 * @returns {string}
 */
function convertLangName(language) {
	var isEng = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	return __webpack_require__(/*! Common/Translator */ 6).i18n('LANGS_NAMES' + (true === isEng ? '_EN' : '') + '/LANG_' + language.toUpperCase().replace(/[^a-zA-Z0-9]+/g, '_'), null, language);
}

/**
 * @returns {object}
 */
function draggablePlace() {
	return __WEBPACK_IMPORTED_MODULE_1_____default()('<div class="draggablePlace">' + '<span class="text"></span>&nbsp;' + '<i class="icon-copy icon-white visible-on-ctrl"></i>' + '<i class="icon-mail icon-white hidden-on-ctrl"></i>' + '</div>').appendTo('#rl-hidden');
}

/**
 * @param {object} domOption
 * @param {object} item
 * @returns {void}
 */
function defautOptionsAfterRender(domItem, item) {
	if (item && !isUnd(item.disabled) && domItem) {
		__WEBPACK_IMPORTED_MODULE_1_____default()(domItem).toggleClass('disabled', item.disabled).prop('disabled', item.disabled);
	}
}

/**
 * @param {string} title
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 */
function clearBqSwitcher(body) {
	body.find('blockquote.rl-bq-switcher').removeClass('rl-bq-switcher hidden-bq');
	body.find('.rlBlockquoteSwitcher').off('.rlBlockquoteSwitcher').remove();
	body.find('[data-html-editor-font-wrapper]').removeAttr('data-html-editor-font-wrapper');
}

/**
 * @param {string} title
 * @param {Object} body
 * @param {boolean} isHtml
 * @param {boolean} print
 */
function previewMessage(title, body, isHtml, print) {
	var win = __WEBPACK_IMPORTED_MODULE_0_window___default.a.open(''),
	    doc = win.document,
	    bodyClone = body.clone(),
	    bodyClass = isHtml ? 'html' : 'plain';

	clearBqSwitcher(bodyClone);

	var html = bodyClone ? bodyClone.html() : '';

	title = encodeHtml(title);

	doc.write('<html>\n<head>\n\t<meta charset="utf-8" />\n\t<meta name="viewport" content="user-scalable=no" />\n\t<meta name="apple-mobile-web-app-capable" content="yes" />\n\t<meta name="robots" content="noindex, nofollow, noodp" />\n\t<title>' + title + '</title>\n\t<style>\nhtml, body {\n\tbackground-color: #fff;\n\tfont-size: 13px;\n\tfont-family: arial, sans-serif;\n}\n\na {color: blue; text-decoration: underline}\na:visited {color: #609}\na:active {color: red}\nblockquote {border-left: 2px solid black; margin: 0; padding: 0px 10px}\n\npre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\tbackground: #fff;\n\tborder: none;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: break-all;\n}\n\nbody.html pre {\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\nbody.plain {\n\n\tpadding: 15px;\n\twhite-space: pre-wrap;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n}\n\nbody.plain pre {\n\tmargin: 0px;\n\tpadding: 0px;\n\tbackground: #fff;\n\tborder: none;\n\tfont-family: Monaco, Menlo, Consolas, \'Courier New\', monospace;\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n\tword-break: normal;\n}\n\nbody.plain blockquote {\n\tborder-left: 2px solid blue;\n\tcolor: blue;\n}\n\nbody.plain blockquote blockquote {\n\tborder-left: 2px solid green;\n\tcolor: green;\n}\n\nbody.plain blockquote blockquote blockquote {\n\tborder-left: 2px solid red;\n\tcolor: red;\n}\n\t</style>\n</head>\n<body class="' + bodyClass + '">' + html + '</body>\n</html>');

	doc.close();

	if (print) {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return win.print();
		}, 100);
	}
}

/**
 * @param {Function} fCallback
 * @param {?} koTrigger
 * @param {?} context = null
 * @param {number=} timer = 1000
 * @returns {Function}
 */
function settingsSaveHelperFunction(fCallback, koTrigger) {
	var context = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
	var timer = arguments.length <= 3 || arguments[3] === undefined ? 1000 : arguments[3];

	timer = pInt(timer);
	return function (type, data, cached, requestAction, requestParameters) {
		koTrigger.call(context, data && data.Result ? __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].TrueResult : __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].FalseResult);
		if (fCallback) {
			fCallback.call(context, type, data, cached, requestAction, requestParameters);
		}
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
			koTrigger.call(context, __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Idle);
		}, timer);
	};
}

/**
 * @param {object} koTrigger
 * @param {mixed} context
 * @returns {mixed}
 */
function settingsSaveHelperSimpleFunction(koTrigger, context) {
	return settingsSaveHelperFunction(null, koTrigger, context, 1000);
}

/**
 * @param {object} remote
 * @param {string} settingName
 * @param {string} type
 * @param {function} fTriggerFunction
 * @returns {function}
 */
function settingsSaveHelperSubscribeFunction(remote, settingName, type, fTriggerFunction) {
	return function (value) {

		if (remote) {
			switch (type) {
				case 'bool':
				case 'boolean':
					value = value ? '1' : '0';
					break;
				case 'int':
				case 'integer':
				case 'number':
					value = pInt(value);
					break;
				case 'trim':
					value = trim(value);
					break;
				default:
					value = pString(value);
					break;
			}

			var data = {};
			data[settingName] = value;

			if (remote.saveAdminConfig) {
				remote.saveAdminConfig(fTriggerFunction || null, data);
			} else if (remote.saveSettings) {
				remote.saveSettings(fTriggerFunction || null, data);
			}
		}
	};
}

/**
 * @param {string} html
 * @returns {string}
 */
function findEmailAndLinks(html) {
	//	return html;
	return __WEBPACK_IMPORTED_MODULE_8_Autolinker___default.a.link(html, {
		newWindow: true,
		stripPrefix: false,
		urls: true,
		email: true,
		twitter: false,
		replaceFn: function replaceFn(autolinker, match) {
			return !(autolinker && match && 'url' === match.getType() && match.matchedText && 0 !== match.matchedText.indexOf('http'));
		}
	});
}

/**
 * @param {string} html
 * @returns {string}
 */
function htmlToPlain(html) {
	var pos = 0,
	    limit = 0,
	    iP1 = 0,
	    iP2 = 0,
	    iP3 = 0,
	    text = '';

	var convertBlockquote = function convertBlockquote(blockquoteText) {
		blockquoteText = '> ' + trim(blockquoteText).replace(/\n/gm, '\n> ');
		return blockquoteText.replace(/(^|\n)([> ]+)/gm, function () {
			for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
				args[_key2] = arguments[_key2];
			}

			return args && 2 < args.length ? args[1] + trim(args[2].replace(/[\s]/g, '')) + ' ' : '';
		});
	},
	    convertDivs = function convertDivs() {
		for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
			args[_key3] = arguments[_key3];
		}

		if (args && 1 < args.length) {
			var divText = trim(args[1]);
			if (0 < divText.length) {
				divText = divText.replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs);
				divText = '\n' + trim(divText) + '\n';
			}

			return divText;
		}

		return '';
	},
	    convertPre = function convertPre() {
		for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
			args[_key4] = arguments[_key4];
		}

		return args && 1 < args.length ? args[1].toString().replace(/[\n]/gm, '<br />').replace(/[\r]/gm, '') : '';
	},
	    fixAttibuteValue = function fixAttibuteValue() {
		for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
			args[_key5] = arguments[_key5];
		}

		return args && 1 < args.length ? '' + args[1] + __WEBPACK_IMPORTED_MODULE_2_____default.a.escape(args[2]) : '';
	},
	    convertLinks = function convertLinks() {
		for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
			args[_key6] = arguments[_key6];
		}

		return args && 1 < args.length ? trim(args[1]) : '';
	};

	text = html.replace(/\u0002([\s\S]*)\u0002/gm, '‌$1‌').replace(/<p[^>]*><\/p>/gi, '').replace(/<pre[^>]*>([\s\S\r\n\t]*)<\/pre>/gmi, convertPre).replace(/[\s]+/gm, ' ').replace(/((?:href|data)\s?=\s?)("[^"]+?"|'[^']+?')/gmi, fixAttibuteValue).replace(/<br[^>]*>/gmi, '\n').replace(/<\/h[\d]>/gi, '\n').replace(/<\/p>/gi, '\n\n').replace(/<ul[^>]*>/gmi, '\n').replace(/<\/ul>/gi, '\n').replace(/<li[^>]*>/gmi, ' * ').replace(/<\/li>/gi, '\n').replace(/<\/td>/gi, '\n').replace(/<\/tr>/gi, '\n').replace(/<hr[^>]*>/gmi, '\n_______________________________\n\n').replace(/<div[^>]*>([\s\S\r\n]*)<\/div>/gmi, convertDivs).replace(/<blockquote[^>]*>/gmi, '\n__bq__start__\n').replace(/<\/blockquote>/gmi, '\n__bq__end__\n').replace(/<a [^>]*>([\s\S\r\n]*?)<\/a>/gmi, convertLinks).replace(/<\/div>/gi, '\n').replace(/&nbsp;/gi, ' ').replace(/&quot;/gi, '"').replace(/<[^>]*>/gm, '');

	text = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$div"].html(text).text();

	text = text.replace(/\n[ \t]+/gm, '\n').replace(/[\n]{3,}/gm, '\n\n').replace(/&gt;/gi, '>').replace(/&lt;/gi, '<').replace(/&amp;/gi, '&');

	text = splitPlainText(trim(text));

	pos = 0;
	limit = 800;

	while (0 < limit) {
		limit -= 1;
		iP1 = text.indexOf('__bq__start__', pos);
		if (-1 < iP1) {
			iP2 = text.indexOf('__bq__start__', iP1 + 5);
			iP3 = text.indexOf('__bq__end__', iP1 + 5);

			if ((-1 === iP2 || iP3 < iP2) && iP1 < iP3) {
				text = text.substring(0, iP1) + convertBlockquote(text.substring(iP1 + 13, iP3)) + text.substring(iP3 + 11);

				pos = 0;
			} else if (-1 < iP2 && iP2 < iP3) {
				pos = iP2 - 1;
			} else {
				pos = 0;
			}
		} else {
			break;
		}
	}

	text = text.replace(/__bq__start__/gm, '').replace(/__bq__end__/gm, '');

	return text;
}

/**
 * @param {string} plain
 * @param {boolean} findEmailAndLinksInText = false
 * @returns {string}
 */
function plainToHtml(plain) {
	var findEmailAndLinksInText = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	plain = plain.toString().replace(/\r/g, '');
	plain = plain.replace(/^>[> ]>+/gm, function (_ref) {
		var match = _ref[0];
		return match ? match.replace(/[ ]+/g, '') : match;
	});

	var bIn = false,
	    bDo = true,
	    bStart = true,
	    aNextText = [],
	    sLine = '',
	    iIndex = 0,
	    aText = plain.split('\n');

	do {
		bDo = false;
		aNextText = [];
		for (iIndex = 0; iIndex < aText.length; iIndex++) {
			sLine = aText[iIndex];
			bStart = '>' === sLine.substr(0, 1);
			if (bStart && !bIn) {
				bDo = true;
				bIn = true;
				aNextText.push('~~~blockquote~~~');
				aNextText.push(sLine.substr(1));
			} else if (!bStart && bIn) {
				if ('' !== sLine) {
					bIn = false;
					aNextText.push('~~~/blockquote~~~');
					aNextText.push(sLine);
				} else {
					aNextText.push(sLine);
				}
			} else if (bStart && bIn) {
				aNextText.push(sLine.substr(1));
			} else {
				aNextText.push(sLine);
			}
		}

		if (bIn) {
			bIn = false;
			aNextText.push('~~~/blockquote~~~');
		}

		aText = aNextText;
	} while (bDo);

	plain = aText.join('\n');

	plain = plain
	//			.replace(/~~~\/blockquote~~~\n~~~blockquote~~~/g, '\n')
	.replace(/&/g, '&amp;').replace(/>/g, '&gt;').replace(/</g, '&lt;').replace(/~~~blockquote~~~[\s]*/g, '<blockquote>').replace(/[\s]*~~~\/blockquote~~~/g, '</blockquote>').replace(/\u200C([\s\S]*)\u200C/g, '\u0002$1\u0002').replace(/\n/g, '<br />');

	return findEmailAndLinksInText ? findEmailAndLinks(plain) : plain;
}

__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloop_Utils_htmlToPlain = htmlToPlain;
__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloop_Utils_plainToHtml = plainToHtml;

/**
 * @param {Array} aSystem
 * @param {Array} aList
 * @param {Array=} aDisabled
 * @param {Array=} aHeaderLines
 * @param {?number=} iUnDeep
 * @param {Function=} fDisableCallback
 * @param {Function=} fVisibleCallback
 * @param {Function=} fRenameCallback
 * @param {boolean=} bSystem
 * @param {boolean=} bBuildUnvisible
 * @returns {Array}
 */
function folderListOptionsBuilder(aSystem, aList, aDisabled, aHeaderLines, iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible) {
	var
	/**
  * @type {?FolderModel}
  */
	oItem = null,
	    bSep = false,
	    iIndex = 0,
	    iLen = 0,
	    aResult = [];

	var sDeepPrefix = '   ';

	bBuildUnvisible = isUnd(bBuildUnvisible) ? false : !!bBuildUnvisible;
	bSystem = !isNormal(bSystem) ? 0 < aSystem.length : bSystem;
	iUnDeep = !isNormal(iUnDeep) ? 0 : iUnDeep;
	fDisableCallback = isNormal(fDisableCallback) ? fDisableCallback : null;
	fVisibleCallback = isNormal(fVisibleCallback) ? fVisibleCallback : null;
	fRenameCallback = isNormal(fRenameCallback) ? fRenameCallback : null;

	if (!isArray(aDisabled)) {
		aDisabled = [];
	}

	if (!isArray(aHeaderLines)) {
		aHeaderLines = [];
	}

	for (iIndex = 0, iLen = aHeaderLines.length; iIndex < iLen; iIndex++) {
		aResult.push({
			id: aHeaderLines[iIndex][0],
			name: aHeaderLines[iIndex][1],
			system: false,
			seporator: false,
			disabled: false
		});
	}

	bSep = true;
	for (iIndex = 0, iLen = aSystem.length; iIndex < iLen; iIndex++) {
		oItem = aSystem[iIndex];
		if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
			if (bSep && 0 < aResult.length) {
				aResult.push({
					id: '---',
					name: '---',
					system: false,
					seporator: true,
					disabled: true
				});
			}

			bSep = false;
			aResult.push({
				id: oItem.fullNameRaw,
				name: fRenameCallback ? fRenameCallback(oItem) : oItem.name(),
				system: true,
				seporator: false,
				disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
			});
		}
	}

	bSep = true;
	for (iIndex = 0, iLen = aList.length; iIndex < iLen; iIndex++) {
		oItem = aList[iIndex];
		//			if (oItem.subScribed() || !oItem.existen || bBuildUnvisible)
		if ((oItem.subScribed() || !oItem.existen || bBuildUnvisible) && (oItem.selectable || oItem.hasSubScribedSubfolders())) {
			if (fVisibleCallback ? fVisibleCallback(oItem) : true) {
				if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["FolderType"].User === oItem.type() || !bSystem || oItem.hasSubScribedSubfolders()) {
					if (bSep && 0 < aResult.length) {
						aResult.push({
							id: '---',
							name: '---',
							system: false,
							seporator: true,
							disabled: true
						});
					}

					bSep = false;
					aResult.push({
						id: oItem.fullNameRaw,
						name: new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Array(oItem.deep + 1 - iUnDeep).join(sDeepPrefix) + (fRenameCallback ? fRenameCallback(oItem) : oItem.name()),
						system: false,
						seporator: false,
						disabled: !oItem.selectable || -1 < inArray(oItem.fullNameRaw, aDisabled) || (fDisableCallback ? fDisableCallback(oItem) : false)
					});
				}
			}
		}

		if (oItem.subScribed() && 0 < oItem.subFolders().length) {
			aResult = aResult.concat(folderListOptionsBuilder([], oItem.subFolders(), aDisabled, [], iUnDeep, fDisableCallback, fVisibleCallback, fRenameCallback, bSystem, bBuildUnvisible));
		}
	}

	return aResult;
}

/**
 * @param {object} element
 * @returns {void}
 */
function selectElement(element) {
	var sel = null,
	    range = null;
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection) {
		sel = __WEBPACK_IMPORTED_MODULE_0_window___default.a.getSelection();
		sel.removeAllRanges();
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createRange();
		range.selectNodeContents(element);
		sel.addRange(range);
	} else if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.selection) {
		range = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.body.createTextRange();
		range.moveToElementText(element);
		range.select();
	}
}

var detectDropdownVisibility = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function () {
	__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["dropdownVisibility"])(!!__WEBPACK_IMPORTED_MODULE_2_____default.a.find(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["data"].aBootstrapDropdowns, function (item) {
		return item.hasClass('open');
	}));
}, 50);

/**
 * @param {boolean=} delay = false
 */
function triggerAutocompleteInputChange() {
	var delay = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];


	var fFunc = function fFunc() {
		__WEBPACK_IMPORTED_MODULE_1_____default()('.checkAutocomplete').trigger('change');
	};

	if (delay) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(fFunc, 100);
	} else {
		fFunc();
	}
}

var configurationScriptTagCache = {};

/**
 * @param {string} configuration
 * @returns {object}
 */
function getConfigurationFromScriptTag(configuration) {
	if (!configurationScriptTagCache[configuration]) {
		configurationScriptTagCache[configuration] = __WEBPACK_IMPORTED_MODULE_1_____default()('script[type="application/json"][data-configuration="' + configuration + '"]');
	}

	try {
		return JSON.parse(configurationScriptTagCache[configuration].text());
	} catch (e) {} // eslint-disable-line no-empty

	return {};
}

/**
 * @param {mixed} mPropOrValue
 * @param {mixed} value
 */
function disposeOne(propOrValue, value) {
	var disposable = value || propOrValue;
	if (disposable && 'function' === typeof disposable.dispose) {
		disposable.dispose();
	}
}

/**
 * @param {Object} object
 */
function disposeObject(object) {
	if (object) {
		if (isArray(object.disposables)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(object.disposables, disposeOne);
		}

		__WEBPACK_IMPORTED_MODULE_3_ko___default.a.utils.objectForEach(object, disposeOne);
	}
}

/**
 * @param {Object|Array} objectOrObjects
 * @returns {void}
 */
function delegateRunOnDestroy(objectOrObjects) {
	if (objectOrObjects) {
		if (isArray(objectOrObjects)) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.each(objectOrObjects, function (item) {
				delegateRunOnDestroy(item);
			});
		} else if (objectOrObjects && objectOrObjects.onDestroy) {
			objectOrObjects.onDestroy();
		}
	}
}

/**
 * @param {object} $styleTag
 * @param {string} css
 * @returns {boolean}
 */
function appendStyles($styleTag, css) {
	if ($styleTag && $styleTag[0]) {
		if ($styleTag[0].styleSheet && !isUnd($styleTag[0].styleSheet.cssText)) {
			$styleTag[0].styleSheet.cssText = css;
		} else {
			$styleTag.text(css);
		}

		return true;
	}

	return false;
}

var __themeTimer = 0,
    __themeAjax = null;

/**
 * @param {string} value
 * @param {function} themeTrigger
 * @returns {void}
 */
function changeTheme(value, themeTrigger) {
	var themeLink = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-link'),
	    clearTimer = function clearTimer() {
		__themeTimer = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			return themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Idle);
		}, 1000);
		__themeAjax = null;
	};

	var themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('#app-theme-style'),
	    url = themeLink.attr('href');

	if (!url) {
		url = themeStyle.attr('data-href');
	}

	if (url) {
		url = url.toString().replace(/\/-\/[^\/]+\/\-\//, '/-/' + value + '/-/');
		url = url.toString().replace(/\/Css\/[^\/]+\/User\//, '/Css/0/User/');
		url = url.toString().replace(/\/Hash\/[^\/]+\//, '/Hash/-/');

		if ('Json/' !== url.substring(url.length - 5, url.length)) {
			url += 'Json/';
		}

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(__themeTimer);
		themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].Animate);

		if (__themeAjax && __themeAjax.abort) {
			__themeAjax.abort();
		}

		__themeAjax = __WEBPACK_IMPORTED_MODULE_1_____default.a.ajax({
			url: url,
			dataType: 'json'
		}).then(function (data) {

			if (data && isArray(data) && 2 === data.length) {
				if (themeLink && themeLink[0] && (!themeStyle || !themeStyle[0])) {
					themeStyle = __WEBPACK_IMPORTED_MODULE_1_____default()('<style id="app-theme-style"></style>');
					themeLink.after(themeStyle);
					themeLink.remove();
				}

				if (themeStyle && themeStyle[0]) {
					if (appendStyles(themeStyle, data[1])) {
						themeStyle.attr('data-href', url).attr('data-theme', data[0]);
					}
				}

				themeTrigger(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["SaveSettingsStep"].TrueResult);
			}
		}).then(clearTimer, clearTimer);
	}
}

/**
 * @returns {function}
 */
function computedPagenatorHelper(koCurrentPage, koPageCount) {
	return function () {

		var currentPage = koCurrentPage(),
		    pageCount = koPageCount(),
		    result = [],
		    fAdd = function fAdd(index) {
			var push = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];
			var customName = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];


			var data = {
				current: index === currentPage,
				name: '' === customName ? index.toString() : customName.toString(),
				custom: '' !== customName,
				title: '' === customName ? '' : index.toString(),
				value: index.toString()
			};

			if (push) {
				result.push(data);
			} else {
				result.unshift(data);
			}
		};

		var prev = 0,
		    next = 0,
		    limit = 2;

		if (1 < pageCount || 0 < pageCount && pageCount < currentPage) {
			if (pageCount < currentPage) {
				fAdd(pageCount);
				prev = pageCount;
				next = pageCount;
			} else {
				if (3 >= currentPage || pageCount - 2 <= currentPage) {
					limit += 2;
				}

				fAdd(currentPage);
				prev = currentPage;
				next = currentPage;
			}

			while (0 < limit) {

				prev -= 1;
				next += 1;

				if (0 < prev) {
					fAdd(prev, false);
					limit -= 1;
				}

				if (pageCount >= next) {
					fAdd(next, true);
					limit -= 1;
				} else if (0 >= prev) {
					break;
				}
			}

			if (3 === prev) {
				fAdd(2, false);
			} else if (3 < prev) {
				fAdd(Math.round((prev - 1) / 2), false, '...');
			}

			if (pageCount - 2 === next) {
				fAdd(pageCount - 1, true);
			} else if (pageCount - 2 > next) {
				fAdd(Math.round((pageCount + next) / 2), true, '...');
			}

			// first and last
			if (1 < prev) {
				fAdd(1, false);
			}

			if (pageCount > next) {
				fAdd(pageCount, true);
			}
		}

		return result;
	};
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function getFileExtension(fileName) {
	fileName = trim(fileName).toLowerCase();

	var result = fileName.split('.').pop();
	return result === fileName ? '' : result;
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function mimeContentType(fileName) {
	var ext = '',
	    result = 'application/octet-stream';

	fileName = trim(fileName).toLowerCase();

	if ('winmail.dat' === fileName) {
		return 'application/ms-tnef';
	}

	ext = getFileExtension(fileName);
	if (ext && 0 < ext.length && !isUnd(__WEBPACK_IMPORTED_MODULE_6_Common_Mime__["a" /* Mime */][ext])) {
		result = __WEBPACK_IMPORTED_MODULE_6_Common_Mime__["a" /* Mime */][ext];
	}

	return result;
}

/**
 * @param {string} url
 * @param {number} value
 * @param {Function} fCallback
 */
function resizeAndCrop(url, value, fCallback) {
	var img = new Image();
	img.onload = function () {

		var diff = [0, 0];

		var canvas = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('canvas'),
		    ctx = canvas.getContext('2d');

		canvas.width = value;
		canvas.height = value;

		if (this.width > this.height) {
			diff = [this.width - this.height, 0];
		} else {
			diff = [0, this.height - this.width];
		}

		ctx.fillStyle = '#fff';
		ctx.fillRect(0, 0, value, value);
		ctx.drawImage(this, diff[0] / 2, diff[1] / 2, this.width - diff[0], this.height - diff[1], 0, 0, value, value);

		fCallback(canvas.toDataURL('image/jpeg'));
	};

	img.src = url;
}

/**
 * @param {string} mailToUrl
 * @param {Function} PopupComposeVoreModel
 * @returns {boolean}
 */
function mailToHelper(mailToUrl, PopupComposeVoreModel) {
	if (mailToUrl && 'mailto:' === mailToUrl.toString().substr(0, 7).toLowerCase()) {
		var _ret = function () {
			if (!PopupComposeVoreModel) {
				return {
					v: true
				};
			}

			mailToUrl = mailToUrl.toString().substr(7);

			var to = [],
			    cc = null,
			    bcc = null,
			    params = {};

			var email = mailToUrl.replace(/\?.+$/, ''),
			    query = mailToUrl.replace(/^[^\?]*\?/, ''),
			    EmailModel = __webpack_require__(/*! Model/Email */ 30).default,
			    emailObj = new EmailModel(),
			    fParseEmailLine = function fParseEmailLine(line) {
				return line ? __WEBPACK_IMPORTED_MODULE_2_____default.a.compact(__WEBPACK_IMPORTED_MODULE_2_____default.a.map(decodeURIComponent(line).split(/[,]/), function (item) {
					emailObj.clear();
					emailObj.mailsoParse(item);
					return '' !== emailObj.email ? emailObj : null;
				})) : null;
			};

			to = fParseEmailLine(email);
			params = simpleQueryParser(query);

			if (!isUnd(params.cc)) {
				cc = fParseEmailLine(decodeURIComponent(params.cc));
			}

			if (!isUnd(params.bcc)) {
				bcc = fParseEmailLine(decodeURIComponent(params.bcc));
			}

			__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(PopupComposeVoreModel, [__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["ComposeType"].Empty, null, to, cc, bcc, isUnd(params.subject) ? null : pString(decodeURIComponent(params.subject)), isUnd(params.body) ? null : plainToHtml(pString(decodeURIComponent(params.body)))]);

			return {
				v: true
			};
		}();

		if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
	}

	return false;
}

var windowResize = __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function (timeout) {
	if (isUnd(timeout) || isNull(timeout)) {
		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].resize();
	} else {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].resize();
		}, timeout);
	}
}, 50);

/**
 * @returns {void}
 */
function windowResizeCallback() {
	windowResize();
}

var substr = __WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr;
if ('b' !== 'ab'.substr(-1)) {
	substr = function substr(str, start, length) {
		start = 0 > start ? str.length + start : start;
		return str.substr(start, length);
	};

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.String.substr = substr;
}

/***/ },
/* 1 */
/*!****************************!*\
  !*** ./dev/External/ko.js ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	ko = window.ko,
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),
	JSON = __webpack_require__(/*! JSON */ 33),
	Opentip = __webpack_require__(/*! Opentip */ 57),
	Pikaday = __webpack_require__(/*! pikaday */ 82),

	fDisposalTooltipHelper = function(oElement) {
		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			if (oElement && oElement.__opentip)
			{
				oElement.__opentip.deactivate();
			}
		});
	};

ko.bindingHandlers.updateWidth = {
	init: function(oElement, fValueAccessor) {
		var
			$w = $(window),
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			fInit = function() {
				fValue($oEl.width());
				window.setTimeout(function() {
					fValue($oEl.width());
				}, 500);
			};

		$w.on('resize', fInit);
		fInit();

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$w.off('resize', fInit);
		});
	}
};

ko.bindingHandlers.editor = {
	init: function(oElement, fValueAccessor) {

		var
			oEditor = null,
			fValue = fValueAccessor(),

			fUpdateEditorValue = function() {
				if (fValue && fValue.__editor)
				{
					fValue.__editor.setHtmlOrPlain(fValue());
				}
			},

			fUpdateKoValue = function() {
				if (fValue && fValue.__editor)
				{
					fValue(fValue.__editor.getDataWithHtmlMark());
				}
			},

			fOnReady = function() {
				fValue.__editor = oEditor;
				fUpdateEditorValue();
			},

			HtmlEditor = __webpack_require__(/*! Common/HtmlEditor */ 45);

		if (ko.isObservable(fValue) && HtmlEditor)
		{
			oEditor = new HtmlEditor(oElement, fUpdateKoValue, fOnReady, fUpdateKoValue);

			fValue.__fetchEditorValue = fUpdateKoValue;

			fValue.subscribe(fUpdateEditorValue);

//				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
//				});
		}
	}
};

ko.bindingHandlers.json = {
	init: function(oElement, fValueAccessor) {
		$(oElement).text(JSON.stringify(ko.unwrap(fValueAccessor())));
	},
	update: function(oElement, fValueAccessor) {
		$(oElement).text(JSON.stringify(ko.unwrap(fValueAccessor())));
	}
};

ko.bindingHandlers.scrollerShadows = {
	init: function(oElement) {

		var
			iLimit = 8,
			$oEl = $(oElement),
			$win = $(window),
			oCont = $oEl.find('[data-scroller-shadows-content]')[0] || null,
			fFunc = _.throttle(function() {
				$oEl
					.toggleClass('scroller-shadow-top', iLimit < oCont.scrollTop)
					.toggleClass('scroller-shadow-bottom', oCont.scrollTop + iLimit < oCont.scrollHeight - oCont.clientHeight);
			}, 100);

		if (oCont)
		{
			$(oCont).on('scroll resize', fFunc);
			$win.on('resize', fFunc);

			ko.utils.domNodeDisposal.addDisposeCallback(oCont, function() {
				$(oCont).off();
				$win.off('resize', fFunc);
			});
		}
	}
};

ko.bindingHandlers.pikaday = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {

		ko.bindingHandlers.textInput
			.init.apply(oViewModel, Array.prototype.slice.call(arguments)); // eslint-disable-line prefer-rest-params

		if (Pikaday)
		{
			oElement.__pikaday = new Pikaday({
				field: oElement
			});
		}
	}
};

ko.bindingHandlers.tooltip = {
	init: function(oElement, fValueAccessor) {

		var
			bi18n = true,
			sValue = '',
			Translator = null,
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			bMobile = 'on' === ($oEl.data('tooltip-mobile') || 'off'),
			Globals = __webpack_require__(/*! Common/Globals */ 5);

		if (!Globals.bMobileDevice || bMobile)
		{
			bi18n = 'on' === ($oEl.data('tooltip-i18n') || 'on');
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue);

			oElement.__opentip = new Opentip(oElement, {
				'style': 'rainloopTip',
				'element': oElement,
				'tipJoint': $oEl.data('tooltip-join') || 'bottom'
			});

			Globals.dropdownVisibility.subscribe(function(bV) {
				if (bV) {
					oElement.__opentip.hide();
				}
			});

			if ('' === sValue)
			{
				oElement.__opentip.hide();
				oElement.__opentip.deactivate();
				oElement.__opentip.setContent('');
			}
			else
			{
				oElement.__opentip.activate();
			}

			if (bi18n)
			{
				Translator = __webpack_require__(/*! Common/Translator */ 6);

				oElement.__opentip.setContent(Translator.i18n(sValue));

				Translator.trigger.subscribe(function() {
					oElement.__opentip.setContent(Translator.i18n(sValue));
				});

				Globals.dropdownVisibility.subscribe(function() {
					if (oElement && oElement.__opentip)
					{
						oElement.__opentip.setContent(__webpack_require__(/*! Common/Translator */ 6).i18n(sValue));
					}
				});
			}
			else
			{
				oElement.__opentip.setContent(sValue);
			}
		}
	},
	update: function(oElement, fValueAccessor) {

		var
			bi18n = true,
			sValue = '',
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			bMobile = 'on' === ($oEl.data('tooltip-mobile') || 'off'),
			Globals = __webpack_require__(/*! Common/Globals */ 5);

		if ((!Globals.bMobileDevice || bMobile) && oElement.__opentip)
		{
			bi18n = 'on' === ($oEl.data('tooltip-i18n') || 'on');
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue);

			if (sValue)
			{
				oElement.__opentip.setContent(
					bi18n ? __webpack_require__(/*! Common/Translator */ 6).i18n(sValue) : sValue);
				oElement.__opentip.activate();
			}
			else
			{
				oElement.__opentip.hide();
				oElement.__opentip.deactivate();
				oElement.__opentip.setContent('');
			}
		}
	}
};

ko.bindingHandlers.tooltipErrorTip = {
	init: function(oElement) {

		var $oEl = $(oElement);

		oElement.__opentip = new Opentip(oElement, {
			'style': 'rainloopErrorTip',
			'hideOn': 'mouseout click',
			'element': oElement,
			'tipJoint': $oEl.data('tooltip-join') || 'top'
		});

		oElement.__opentip.deactivate();

		$(window.document).on('click', function() {
			if (oElement && oElement.__opentip)
			{
				oElement.__opentip.hide();
			}
		});

		fDisposalTooltipHelper(oElement);
	},
	update: function(oElement, fValueAccessor) {

		var
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			sValue = !ko.isObservable(fValue) && _.isFunction(fValue) ? fValue() : ko.unwrap(fValue),
			oOpenTips = oElement.__opentip;

		if (oOpenTips)
		{
			if ('' === sValue)
			{
				oOpenTips.hide();
				oOpenTips.deactivate();
				oOpenTips.setContent('');
			}
			else
			{
				_.delay(function() {
					if ($oEl.is(':visible'))
					{
						oOpenTips.setContent(sValue);
						oOpenTips.activate();
						oOpenTips.show();
					}
					else
					{
						oOpenTips.hide();
						oOpenTips.deactivate();
						oOpenTips.setContent('');
					}
				}, 100);
			}
		}
	}
};

ko.bindingHandlers.registrateBootstrapDropdown = {
	init: function(oElement) {
		var Globals = __webpack_require__(/*! Common/Globals */ 5);
		if (Globals && Globals.data.aBootstrapDropdowns)
		{
			Globals.data.aBootstrapDropdowns.push($(oElement));

			$(oElement).click(function() {
				__webpack_require__(/*! Common/Utils */ 0).detectDropdownVisibility();
			});

//				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
//				});
		}
	}
};

ko.bindingHandlers.openDropdownTrigger = {
	update: function(oElement, fValueAccessor) {
		if (ko.unwrap(fValueAccessor()))
		{
			var $oEl = $(oElement);
			if (!$oEl.hasClass('open'))
			{
				$oEl.find('.dropdown-toggle').dropdown('toggle');
			}

			$oEl.find('.dropdown-toggle').focus();

			__webpack_require__(/*! Common/Utils */ 0).detectDropdownVisibility();
			fValueAccessor()(false);
		}
	}
};

ko.bindingHandlers.dropdownCloser = {
	init: function(oElement) {
		$(oElement).closest('.dropdown').on('click', '.e-item', function() {
			$(oElement).dropdown('toggle');
		});
	}
};

ko.bindingHandlers.popover = {
	init: function(oElement, fValueAccessor) {
		$(oElement).popover(ko.unwrap(fValueAccessor()));

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).popover('destroy');
		});
	}
};

ko.bindingHandlers.csstext = {};
ko.bindingHandlers.csstext.init = ko.bindingHandlers.csstext.update = function(oElement, fValueAccessor) {
	if (oElement && oElement.styleSheet && 'undefined' !== typeof oElement.styleSheet.cssText)
	{
		oElement.styleSheet.cssText = ko.unwrap(fValueAccessor());
	}
	else
	{
		$(oElement).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.resizecrop = {
	init: function(oElement) {
		$(oElement).addClass('resizecrop').resizecrop({
			'width': '100',
			'height': '100',
			'wrapperCSS': {
				'border-radius': '10px'
			}
		});
	},
	update: function(oElement, fValueAccessor) {
		fValueAccessor()();
		$(oElement).resizecrop({
			'width': '100',
			'height': '100'
		});
	}
};

ko.bindingHandlers.onEnter = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keypress.koOnEnter', function(oEvent) {
			if (oEvent && 13 === window.parseInt(oEvent.keyCode, 10))
			{
				$(oElement).trigger('change');
				fValueAccessor().call(oViewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keypress.koOnEnter');
		});
	}
};

ko.bindingHandlers.onSpace = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keyup.koOnSpace', function(oEvent) {
			if (oEvent && 32 === window.parseInt(oEvent.keyCode, 10))
			{
				fValueAccessor().call(oViewModel, oEvent);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keyup.koOnSpace');
		});
	}
};

ko.bindingHandlers.onTab = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keydown.koOnTab', function(oEvent) {
			if (oEvent && 9 === window.parseInt(oEvent.keyCode, 10))
			{
				return fValueAccessor().call(oViewModel, !!oEvent.shiftKey);
			}
			return true;
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keydown.koOnTab');
		});
	}
};

ko.bindingHandlers.onEsc = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		$(oElement).on('keypress.koOnEsc', function(oEvent) {
			if (oEvent && 27 === window.parseInt(oEvent.keyCode, 10))
			{
				$(oElement).trigger('change');
				fValueAccessor().call(oViewModel);
			}
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement).off('keypress.koOnEsc');
		});
	}
};

ko.bindingHandlers.clickOnTrue = {
	update: function(oElement, fValueAccessor) {
		if (ko.unwrap(fValueAccessor()))
		{
			$(oElement).click();
		}
	}
};

ko.bindingHandlers.modal = {
	init: function(oElement, fValueAccessor) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Utils = __webpack_require__(/*! Common/Utils */ 0);

		$(oElement).toggleClass('fade', !Globals.bMobileDevice).modal({
			'keyboard': false,
			'show': ko.unwrap(fValueAccessor())
		})
		.on('shown.koModal', Utils.windowResizeCallback)
		.find('.close').on('click.koModal', function() {
			fValueAccessor()(false);
		});

		ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
			$(oElement)
				.off('shown.koModal')
				.find('.close')
				.off('click.koModal');
		});
	},
	update: function(oElement, fValueAccessor) {

		var Globals = __webpack_require__(/*! Common/Globals */ 5);

		$(oElement).modal(ko.unwrap(fValueAccessor()) ? 'show' : 'hide');

		if (Globals.$html.hasClass('rl-anim'))
		{
			Globals.$html.addClass('rl-modal-animation');
			_.delay(function() {
				Globals.$html.removeClass('rl-modal-animation');
			}, 400);
		}

	}
};

ko.bindingHandlers.moment = {
	init: function(oElement, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 26).momentToNode(
			$(oElement).addClass('moment').data('moment-time', ko.unwrap(fValueAccessor()))
		);
	},
	update: function(oElement, fValueAccessor) {
		__webpack_require__(/*! Common/Momentor */ 26).momentToNode(
			$(oElement).data('moment-time', ko.unwrap(fValueAccessor()))
		);
	}
};

ko.bindingHandlers.i18nInit = {
	init: function(oElement) {
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.translatorInit = {
	init: function(oElement) {
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.i18nUpdate = {
	update: function(oElement, fValueAccessor) {
		ko.unwrap(fValueAccessor());
		__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(oElement);
	}
};

ko.bindingHandlers.link = {
	update: function(oElement, fValueAccessor) {
		$(oElement).attr('href', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.title = {
	update: function(oElement, fValueAccessor) {
		$(oElement).attr('title', ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.textF = {
	init: function(oElement, fValueAccessor) {
		$(oElement).text(ko.unwrap(fValueAccessor()));
	}
};

ko.bindingHandlers.initDom = {
	init: function(oElement, fValueAccessor) {
		fValueAccessor()(oElement);
	}
};

ko.bindingHandlers.initFixedTrigger = {
	init: function(oElement, fValueAccessor) {
		var
			aValues = ko.unwrap(fValueAccessor()),
			$oContainer = null,
			$oElement = $(oElement),
			oOffset = null,

			iTop = aValues[1] || 0;

		$oContainer = $(aValues[0] || null);
		$oContainer = $oContainer[0] ? $oContainer : null;

		if ($oContainer)
		{
			$(window).resize(function() {
				oOffset = $oContainer.offset();
				if (oOffset && oOffset.top)
				{
					$oElement.css('top', oOffset.top + iTop);
				}
			});
		}
	}
};

ko.bindingHandlers.initResizeTrigger = {
	init: function(oElement, fValueAccessor) {
		var aValues = ko.unwrap(fValueAccessor());
		$(oElement).css({
			'height': aValues[1],
			'min-height': aValues[1]
		});
	},
	update: function(oElement, fValueAccessor) {

		var
			Utils = __webpack_require__(/*! Common/Utils */ 0),
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			aValues = ko.unwrap(fValueAccessor()),
			iValue = Utils.pInt(aValues[1]),
			iSize = 0,
			iOffset = $(oElement).offset().top;

		if (0 < iOffset)
		{
			iOffset += Utils.pInt(aValues[2]);
			iSize = Globals.$win.height() - iOffset;

			if (iValue < iSize)
			{
				iValue = iSize;
			}

			$(oElement).css({
				'height': iValue,
				'min-height': iValue
			});
		}
	}
};

ko.bindingHandlers.appendDom = {
	update: function(oElement, fValueAccessor) {
		$(oElement).hide().empty().append(ko.unwrap(fValueAccessor())).show();
	}
};

ko.bindingHandlers.draggable = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Utils = __webpack_require__(/*! Common/Utils */ 0);

		if (!Globals.bMobileDevice)
		{
			var
				iTriggerZone = 100,
				iScrollSpeed = 3,
				fAllValueFunc = fAllBindingsAccessor(),
				sDroppableSelector = fAllValueFunc && fAllValueFunc.droppableSelector ? fAllValueFunc.droppableSelector : '',
				oConf = {
					distance: 20,
					handle: '.dragHandle',
					cursorAt: {top: 22, left: 3},
					refreshPositions: true,
					scroll: true
				};

			if (sDroppableSelector)
			{
				oConf.drag = function(oEvent) {

					$(sDroppableSelector).each(function() {
						var
							moveUp = null,
							moveDown = null,
							$this = $(this),
							oOffset = $this.offset(),
							bottomPos = oOffset.top + $this.height();

						window.clearInterval($this.data('timerScroll'));
						$this.data('timerScroll', false);

						if (oEvent.pageX >= oOffset.left && oEvent.pageX <= oOffset.left + $this.width())
						{
							if (oEvent.pageY >= bottomPos - iTriggerZone && oEvent.pageY <= bottomPos)
							{
								moveUp = function() {
									$this.scrollTop($this.scrollTop() + iScrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', window.setInterval(moveUp, 10));
								moveUp();
							}

							if (oEvent.pageY >= oOffset.top && oEvent.pageY <= oOffset.top + iTriggerZone)
							{
								moveDown = function() {
									$this.scrollTop($this.scrollTop() - iScrollSpeed);
									Utils.windowResize();
								};

								$this.data('timerScroll', window.setInterval(moveDown, 10));
								moveDown();
							}
						}
					});
				};

				oConf.stop = function() {
					$(sDroppableSelector).each(function() {
						window.clearInterval($(this).data('timerScroll'));
						$(this).data('timerScroll', false);
					});
				};
			}

			oConf.helper = function(oEvent) {
				return fValueAccessor()(oEvent && oEvent.target ? ko.dataFor(oEvent.target) : null);
			};

			$(oElement).draggable(oConf).on('mousedown.koDraggable', function() {
				Utils.removeInFocus();
			});

			ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
				$(oElement)
					.off('mousedown.koDraggable')
					.draggable('destroy');
			});
		}
	}
};

ko.bindingHandlers.droppable = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {
		var Globals = __webpack_require__(/*! Common/Globals */ 5);
		if (!Globals.bMobileDevice)
		{
			var
				fValueFunc = fValueAccessor(),
				fAllValueFunc = fAllBindingsAccessor(),
				fOverCallback = fAllValueFunc && fAllValueFunc.droppableOver ? fAllValueFunc.droppableOver : null,
				fOutCallback = fAllValueFunc && fAllValueFunc.droppableOut ? fAllValueFunc.droppableOut : null,
				oConf = {
					tolerance: 'pointer',
					hoverClass: 'droppableHover'
				};

			if (fValueFunc)
			{
				oConf.drop = function(oEvent, oUi) {
					fValueFunc(oEvent, oUi);
				};

				if (fOverCallback)
				{
					oConf.over = function(oEvent, oUi) {
						fOverCallback(oEvent, oUi);
					};
				}

				if (fOutCallback)
				{
					oConf.out = function(oEvent, oUi) {
						fOutCallback(oEvent, oUi);
					};
				}

				$(oElement).droppable(oConf);

				ko.utils.domNodeDisposal.addDisposeCallback(oElement, function() {
					$(oElement).droppable('destroy');
				});
			}
		}
	}
};

ko.bindingHandlers.nano = {
	init: function(oElement) {

		var
			Globals = __webpack_require__(/*! Common/Globals */ 5),
			Settings = __webpack_require__(/*! Storage/Settings */ 7);

		if (!Globals.bDisableNanoScroll && !Settings.appSettingsGet('useNativeScrollbars'))
		{
			$(oElement)
				.addClass('nano')
				.nanoScroller({
					'iOSNativeScrolling': false,
					'preventPageScrolling': true
				});
		}
	}
};

ko.bindingHandlers.saveTrigger = {
	init: function(oElement) {

		var $oEl = $(oElement);

		$oEl.data('save-trigger-type', $oEl.is('input[type=text],input[type=email],input[type=password],select,textarea') ? 'input' : 'custom');

		if ('custom' === $oEl.data('save-trigger-type'))
		{
			$oEl.append(
				'&nbsp;&nbsp;<i class="icon-spinner animated"></i><i class="icon-remove error"></i><i class="icon-ok success"></i>'
			).addClass('settings-saved-trigger');
		}
		else
		{
			$oEl.addClass('settings-saved-trigger-input');
		}
	},
	update: function(oElement, fValueAccessor) {
		var
			mValue = ko.unwrap(fValueAccessor()),
			$oEl = $(oElement);

		if ('custom' === $oEl.data('save-trigger-type'))
		{
			switch (mValue.toString())
			{
				case '1':
					$oEl
						.find('.animated,.error').hide().removeClass('visible')
						.end()
						.find('.success').show().addClass('visible');
					break;
				case '0':
					$oEl
						.find('.animated,.success').hide().removeClass('visible')
						.end()
						.find('.error').show().addClass('visible');
					break;
				case '-2':
					$oEl
						.find('.error,.success').hide().removeClass('visible')
						.end()
						.find('.animated').show().addClass('visible');
					break;
				default:
					$oEl
						.find('.animated').hide()
						.end()
						.find('.error,.success').removeClass('visible');
					break;
			}
		}
		else
		{
			switch (mValue.toString())
			{
				case '1':
					$oEl.addClass('success').removeClass('error');
					break;
				case '0':
					$oEl.addClass('error').removeClass('success');
					break;
				case '-2':
//					$oEl;
					break;
				default:
					$oEl.removeClass('error success');
					break;
			}
		}
	}
};

ko.bindingHandlers.emailsTags = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor) {

		var
			Utils = __webpack_require__(/*! Common/Utils */ 0),
			EmailModel = __webpack_require__(/*! Model/Email */ 30).default,

			$oEl = $(oElement),
			fValue = fValueAccessor(),
			fAllBindings = fAllBindingsAccessor(),
			fAutoCompleteSource = fAllBindings.autoCompleteSource || null,
			fFocusCallback = function(bValue) {
				if (fValue && fValue.focused)
				{
					fValue.focused(!!bValue);
				}
			};

		$oEl.inputosaurus({
			'parseOnBlur': true,
			'allowDragAndDrop': true,
			'focusCallback': fFocusCallback,
			'inputDelimiters': [',', ';', '\n'],
			'autoCompleteSource': fAutoCompleteSource,
//				'elementHook': function(oEl, oItem) {
//					if (oEl && oItem)
//					{
//						oEl.addClass('pgp');
//						window.console.log(arguments);
//					}
//				},
			'parseHook': function(aInput) {

				return _.map(aInput, function(sInputValue) {

					var
						sValue = Utils.trim(sInputValue),
						oEmail = null;

					if ('' !== sValue)
					{
						oEmail = new EmailModel();
						oEmail.mailsoParse(sValue);
						return [oEmail.toLine(false), oEmail];
					}

					return [sValue, null];

				});

//					var aResult = [];
//
//					_.each(aInput, function(sInputValue) {
//
//						var
//							aM = null,
//							aValues = [],
//							sValue = Utils.trim(sInputValue),
//							oEmail = null
//						;
//
//						if ('' !== sValue)
//						{
//							aM = sValue.match(/[@]/g);
//							if (aM && 0 < aM.length)
//							{
//								sValue = sValue.replace(/[\r\n]+/g, '; ').replace(/[\s]+/g, ' ');
//								aValues = EmailModel.splitHelper(sValue, ';');
//
//								_.each(aValues, function(sV) {
//
//									oEmail = new EmailModel();
//									oEmail.mailsoParse(sV);
//
//									if (oEmail.email)
//									{
//										aResult.push([oEmail.toLine(false), oEmail]);
//									}
//									else
//									{
//										aResult.push(['', null]);
//									}
//								});
//							}
//							else
//							{
//								aResult.push([sInputValue, null]);
//							}
//						}
//						else
//						{
//							aResult.push([sInputValue, null]);
//						}
//					});
//
//					return aResult;
			},
			'change': _.bind(function(oEvent) {
				$oEl.data('EmailsTagsValue', oEvent.target.value);
				fValue(oEvent.target.value);
			}, this)
		});

		if (fValue && fValue.focused && fValue.focused.subscribe)
		{
			fValue.focused.subscribe(function(bValue) {
				$oEl.inputosaurus(bValue ? 'focus' : 'blur');
			});
		}
	},
	update: function(oElement, fValueAccessor) {

		var
			$oEl = $(oElement),
			fValue = fValueAccessor(),
			sValue = ko.unwrap(fValue);

		if ($oEl.data('EmailsTagsValue') !== sValue)
		{
			$oEl.val(sValue);
			$oEl.data('EmailsTagsValue', sValue);
			$oEl.inputosaurus('refresh');
		}
	}
};

ko.bindingHandlers.command = {
	init: function(oElement, fValueAccessor, fAllBindingsAccessor, oViewModel) {
		var
			jqElement = $(oElement),
			oCommand = fValueAccessor();

		if (!oCommand || !oCommand.enabled || !oCommand.canExecute)
		{
			throw new Error('You are not using command function');
		}

		jqElement.addClass('command');
		ko.bindingHandlers[jqElement.is('form') ? 'submit' : 'click']
			.init.apply(oViewModel, Array.prototype.slice.call(arguments)); // eslint-disable-line prefer-rest-params
	},

	update: function(oElement, fValueAccessor) {

		var
			bResult = true,
			jqElement = $(oElement),
			oCommand = fValueAccessor();

		bResult = oCommand.enabled();
		jqElement.toggleClass('command-not-enabled', !bResult);

		if (bResult)
		{
			bResult = oCommand.canExecute();
			jqElement.toggleClass('command-can-not-be-execute', !bResult);
		}

		jqElement.toggleClass('command-disabled disable disabled', !bResult).toggleClass('no-disabled', !!bResult);

		if (jqElement.is('input') || jqElement.is('button'))
		{
			jqElement.prop('disabled', !bResult);
		}
	}
};

// extenders

ko.extenders.trimmer = function(oTarget)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {
				oTarget(Utils.trim(sNewValue.toString()));
			},
			'owner': this
		});

	oResult(oTarget());
	return oResult;
};

ko.extenders.posInterer = function(oTarget, iDefault)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {
				var iNew = Utils.pInt(sNewValue.toString(), iDefault);
				if (0 >= iNew)
				{
					iNew = iDefault;
				}

				if (iNew === oTarget() && '' + iNew !== '' + sNewValue)
				{
					oTarget(iNew + 1);
				}

				oTarget(iNew);
			}
		});

	oResult(oTarget());
	return oResult;
};

ko.extenders.limitedList = function(oTarget, mList)
{
	var
		Utils = __webpack_require__(/*! Common/Utils */ 0),
		oResult = ko.computed({
			'read': oTarget,
			'write': function(sNewValue) {

				var
					sCurrentValue = ko.unwrap(oTarget),
					aList = ko.unwrap(mList);

				if (Utils.isNonEmptyArray(aList))
				{
					if (-1 < Utils.inArray(sNewValue, aList))
					{
						oTarget(sNewValue);
					}
					else if (-1 < Utils.inArray(sCurrentValue, aList))
					{
						oTarget(sCurrentValue + ' ');
						oTarget(sCurrentValue);
					}
					else
					{
						oTarget(aList[0] + ' ');
						oTarget(aList[0]);
					}
				}
				else
				{
					oTarget('');
				}
			}
		}).extend({'notify': 'always'});

	oResult(oTarget());

	if (!oResult.valueHasMutated)
	{
		oResult.valueHasMutated = function() {
			oTarget.valueHasMutated();
		};
	}

	return oResult;
};

ko.extenders.reversible = function(oTarget)
{
	var mValue = oTarget();

	oTarget.commit = function()
	{
		mValue = oTarget();
	};

	oTarget.reverse = function()
	{
		oTarget(mValue);
	};

	oTarget.commitedValue = function()
	{
		return mValue;
	};

	return oTarget;
};

ko.extenders.toggleSubscribe = function(oTarget, oOptions)
{
	oTarget.subscribe(oOptions[1], oOptions[0], 'beforeChange');
	oTarget.subscribe(oOptions[2], oOptions[0]);

	return oTarget;
};

ko.extenders.toggleSubscribeProperty = function(oTarget, oOptions)
{
	var sProp = oOptions[1];

	if (sProp)
	{
		oTarget.subscribe(function(oPrev) {
			if (oPrev && oPrev[sProp])
			{
				oPrev[sProp](false);
			}
		}, oOptions[0], 'beforeChange');

		oTarget.subscribe(function(oNext) {
			if (oNext && oNext[sProp])
			{
				oNext[sProp](true);
			}
		}, oOptions[0]);
	}

	return oTarget;
};

ko.extenders.falseTimeout = function(oTarget, iOption)
{
	oTarget.iFalseTimeoutTimeout = 0;
	oTarget.subscribe(function(bValue) {
		if (bValue)
		{
			window.clearTimeout(oTarget.iFalseTimeoutTimeout);
			oTarget.iFalseTimeoutTimeout = window.setTimeout(function() {
				oTarget(false);
				oTarget.iFalseTimeoutTimeout = 0;
			}, __webpack_require__(/*! Common/Utils */ 0).pInt(iOption));
		}
	});

	return oTarget;
};

ko.extenders.specialThrottle = function(oTarget, iOption)
{
	oTarget.iSpecialThrottleTimeoutValue = __webpack_require__(/*! Common/Utils */ 0).pInt(iOption);
	if (0 < oTarget.iSpecialThrottleTimeoutValue)
	{
		oTarget.iSpecialThrottleTimeout = 0;
		oTarget.valueForRead = ko.observable(!!oTarget()).extend({'throttle': 10});

		return ko.computed({
			'read': oTarget.valueForRead,
			'write': function(bValue) {

				if (bValue)
				{
					oTarget.valueForRead(bValue);
				}
				else
				{
					if (oTarget.valueForRead())
					{
						window.clearTimeout(oTarget.iSpecialThrottleTimeout);
						oTarget.iSpecialThrottleTimeout = window.setTimeout(function() {
							oTarget.valueForRead(false);
							oTarget.iSpecialThrottleTimeout = 0;
						}, oTarget.iSpecialThrottleTimeoutValue);
					}
					else
					{
						oTarget.valueForRead(bValue);
					}
				}
			}
		});
	}

	return oTarget;
};

// functions

ko.observable.fn.validateNone = function()
{
	this.hasError = ko.observable(false);
	return this;
};

ko.observable.fn.validateEmail = function()
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasError = ko.observable(false);

	this.subscribe(function(sValue) {
		sValue = Utils.trim(sValue);
		this.hasError('' !== sValue && !(/^[^@\s]+@[^@\s]+$/.test(sValue)));
	}, this);

	this.valueHasMutated();
	return this;
};

ko.observable.fn.validateSimpleEmail = function()
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasError = ko.observable(false);

	this.subscribe(function(sValue) {
		sValue = Utils.trim(sValue);
		this.hasError('' !== sValue && !(/^.+@.+$/.test(sValue)));
	}, this);

	this.valueHasMutated();
	return this;
};

ko.observable.fn.deleteAccessHelper = function()
{
	this.extend({'falseTimeout': 3000}).extend({'toggleSubscribe': [null,
		function(oPrev) {
			if (oPrev && oPrev.deleteAccess)
			{
				oPrev.deleteAccess(false);
			}
		}, function(oNext) {
			if (oNext && oNext.deleteAccess)
			{
				oNext.deleteAccess(true);
			}
		}
	]});

	return this;
};

ko.observable.fn.validateFunc = function(fFunc)
{
	var Utils = __webpack_require__(/*! Common/Utils */ 0);

	this.hasFuncError = ko.observable(false);

	if (Utils.isFunc(fFunc))
	{
		this.subscribe(function(sValue) {
			this.hasFuncError(!fFunc(sValue));
		}, this);

		this.valueHasMutated();
	}

	return this;
};

module.exports = ko;


/***/ },
/* 2 */
/*!***************************!*\
  !*** external "window._" ***!
  \***************************/
/***/ function(module, exports) {

module.exports = window._;

/***/ },
/* 3 */
/*!******************************!*\
  !*** ./dev/Common/Enums.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "FileType", function() { return FileType; });
/* harmony export */ __webpack_require__.d(exports, "StorageResultType", function() { return StorageResultType; });
/* harmony export */ __webpack_require__.d(exports, "Focused", function() { return Focused; });
/* harmony export */ __webpack_require__.d(exports, "State", function() { return State; });
/* harmony export */ __webpack_require__.d(exports, "StateType", function() { return StateType; });
/* harmony export */ __webpack_require__.d(exports, "Capa", function() { return Capa; });
/* harmony export */ __webpack_require__.d(exports, "KeyState", function() { return KeyState; });
/* harmony export */ __webpack_require__.d(exports, "FolderType", function() { return FolderType; });
/* harmony export */ __webpack_require__.d(exports, "ServerFolderType", function() { return ServerFolderType; });
/* harmony export */ __webpack_require__.d(exports, "LoginSignMeTypeAsString", function() { return LoginSignMeTypeAsString; });
/* harmony export */ __webpack_require__.d(exports, "LoginSignMeType", function() { return LoginSignMeType; });
/* harmony export */ __webpack_require__.d(exports, "ComposeType", function() { return ComposeType; });
/* harmony export */ __webpack_require__.d(exports, "UploadErrorCode", function() { return UploadErrorCode; });
/* harmony export */ __webpack_require__.d(exports, "SetSystemFoldersNotification", function() { return SetSystemFoldersNotification; });
/* harmony export */ __webpack_require__.d(exports, "ClientSideKeyName", function() { return ClientSideKeyName; });
/* harmony export */ __webpack_require__.d(exports, "EventKeyCode", function() { return EventKeyCode; });
/* harmony export */ __webpack_require__.d(exports, "MessageSetAction", function() { return MessageSetAction; });
/* harmony export */ __webpack_require__.d(exports, "MessageSelectAction", function() { return MessageSelectAction; });
/* harmony export */ __webpack_require__.d(exports, "DesktopNotification", function() { return DesktopNotification; });
/* harmony export */ __webpack_require__.d(exports, "MessagePriority", function() { return MessagePriority; });
/* harmony export */ __webpack_require__.d(exports, "EditorDefaultType", function() { return EditorDefaultType; });
/* harmony export */ __webpack_require__.d(exports, "ServerSecure", function() { return ServerSecure; });
/* harmony export */ __webpack_require__.d(exports, "SearchDateType", function() { return SearchDateType; });
/* harmony export */ __webpack_require__.d(exports, "SaveSettingsStep", function() { return SaveSettingsStep; });
/* harmony export */ __webpack_require__.d(exports, "Layout", function() { return Layout; });
/* harmony export */ __webpack_require__.d(exports, "FilterConditionField", function() { return FilterConditionField; });
/* harmony export */ __webpack_require__.d(exports, "FilterConditionType", function() { return FilterConditionType; });
/* harmony export */ __webpack_require__.d(exports, "FiltersAction", function() { return FiltersAction; });
/* harmony export */ __webpack_require__.d(exports, "FilterRulesType", function() { return FilterRulesType; });
/* harmony export */ __webpack_require__.d(exports, "SignedVerifyStatus", function() { return SignedVerifyStatus; });
/* harmony export */ __webpack_require__.d(exports, "ContactPropertyType", function() { return ContactPropertyType; });
/* harmony export */ __webpack_require__.d(exports, "Magics", function() { return Magics; });
/* harmony export */ __webpack_require__.d(exports, "Ports", function() { return Ports; });
/* harmony export */ __webpack_require__.d(exports, "Notification", function() { return Notification; });
/* eslint quote-props: 0 */

/**
 * @enum {string}
 */
var FileType = {
	'Unknown': 'unknown',
	'Text': 'text',
	'Html': 'html',
	'Code': 'code',
	'Eml': 'eml',
	'WordText': 'word-text',
	'Pdf': 'pdf',
	'Image': 'image',
	'Audio': 'audio',
	'Video': 'video',
	'Sheet': 'sheet',
	'Presentation': 'presentation',
	'Certificate': 'certificate',
	'CertificateBin': 'certificate-bin',
	'Archive': 'archive'
};

/**
 * @enum {string}
 */
var StorageResultType = {
	'Success': 'success',
	'Abort': 'abort',
	'Error': 'error',
	'Unload': 'unload'
};

/**
 * @enum {string}
 */
var Focused = {
	'None': 'none',
	'MessageList': 'message-list',
	'MessageView': 'message-view',
	'FolderList': 'folder-list'
};

/**
 * @enum {number}
 */
var State = {
	'Empty': 10,
	'Login': 20,
	'Auth': 30
};

/**
 * @enum {number}
 */
var StateType = {
	'Webmail': 0,
	'Admin': 1
};

/**
 * @enum {string}
 */
var Capa = {
	'TwoFactor': 'TWO_FACTOR',
	'TwoFactorForce': 'TWO_FACTOR_FORCE',
	'OpenPGP': 'OPEN_PGP',
	'Prefetch': 'PREFETCH',
	'Gravatar': 'GRAVATAR',
	'Folders': 'FOLDERS',
	'Composer': 'COMPOSER',
	'Contacts': 'CONTACTS',
	'Reload': 'RELOAD',
	'Search': 'SEARCH',
	'SearchAdv': 'SEARCH_ADV',
	'MessageActions': 'MESSAGE_ACTIONS',
	'MessageListActions': 'MESSAGELIST_ACTIONS',
	'AttachmentsActions': 'ATTACHMENTS_ACTIONS',
	'DangerousActions': 'DANGEROUS_ACTIONS',
	'Settings': 'SETTINGS',
	'Help': 'HELP',
	'Themes': 'THEMES',
	'UserBackground': 'USER_BACKGROUND',
	'Sieve': 'SIEVE',
	'Filters': 'FILTERS',
	'AttachmentThumbnails': 'ATTACHMENT_THUMBNAILS',
	'Templates': 'TEMPLATES',
	'AutoLogout': 'AUTOLOGOUT',
	'AdditionalAccounts': 'ADDITIONAL_ACCOUNTS',
	'Identities': 'IDENTITIES'
};

/**
 * @enum {string}
 */
var KeyState = {
	'All': 'all',
	'None': 'none',
	'ContactList': 'contact-list',
	'MessageList': 'message-list',
	'FolderList': 'folder-list',
	'MessageView': 'message-view',
	'Compose': 'compose',
	'Settings': 'settings',
	'Menu': 'menu',
	'PopupComposeOpenPGP': 'compose-open-pgp',
	'PopupMessageOpenPGP': 'message-open-pgp',
	'PopupViewOpenPGP': 'view-open-pgp',
	'PopupKeyboardShortcutsHelp': 'popup-keyboard-shortcuts-help',
	'PopupAsk': 'popup-ask'
};

/**
 * @enum {number}
 */
var FolderType = {
	'Inbox': 10,
	'SentItems': 11,
	'Draft': 12,
	'Trash': 13,
	'Spam': 14,
	'Archive': 15,
	'NotSpam': 80,
	'User': 99
};

/**
 * @enum {number}
 */
var ServerFolderType = {
	'USER': 0,
	'INBOX': 1,
	'SENT': 2,
	'DRAFTS': 3,
	'JUNK': 4,
	'TRASH': 5,
	'IMPORTANT': 10,
	'FLAGGED': 11,
	'ALL': 12
};

/**
 * @enum {string}
 */
var LoginSignMeTypeAsString = {
	'DefaultOff': 'defaultoff',
	'DefaultOn': 'defaulton',
	'Unused': 'unused'
};

/**
 * @enum {number}
 */
var LoginSignMeType = {
	'DefaultOff': 0,
	'DefaultOn': 1,
	'Unused': 2
};

/**
 * @enum {string}
 */
var ComposeType = {
	'Empty': 'empty',
	'Reply': 'reply',
	'ReplyAll': 'replyall',
	'Forward': 'forward',
	'ForwardAsAttachment': 'forward-as-attachment',
	'Draft': 'draft',
	'EditAsNew': 'editasnew'
};

/**
 * @enum {number}
 */
var UploadErrorCode = {
	'Normal': 0,
	'FileIsTooBig': 1,
	'FilePartiallyUploaded': 2,
	'FileNoUploaded': 3,
	'MissingTempFolder': 4,
	'FileOnSaveingError': 5,
	'FileType': 98,
	'Unknown': 99
};

/**
 * @enum {number}
 */
var SetSystemFoldersNotification = {
	'None': 0,
	'Sent': 1,
	'Draft': 2,
	'Spam': 3,
	'Trash': 4,
	'Archive': 5
};

/**
 * @enum {number}
 */
var ClientSideKeyName = {
	'FoldersLashHash': 0,
	'MessagesInboxLastHash': 1,
	'MailBoxListSize': 2,
	'ExpandedFolders': 3,
	'FolderListSize': 4,
	'MessageListSize': 5,
	'LastReplyAction': 6,
	'LastSignMe': 7,
	'ComposeLastIdentityID': 8,
	'MessageHeaderFullInfo': 9
};

/**
 * @enum {number}
 */
var EventKeyCode = {
	'Backspace': 8,
	'Tab': 9,
	'Enter': 13,
	'Esc': 27,
	'PageUp': 33,
	'PageDown': 34,
	'Left': 37,
	'Right': 39,
	'Up': 38,
	'Down': 40,
	'End': 35,
	'Home': 36,
	'Space': 32,
	'Insert': 45,
	'Delete': 46,
	'A': 65,
	'S': 83
};

/**
 * @enum {number}
 */
var MessageSetAction = {
	'SetSeen': 0,
	'UnsetSeen': 1,
	'SetFlag': 2,
	'UnsetFlag': 3
};

/**
 * @enum {number}
 */
var MessageSelectAction = {
	'All': 0,
	'None': 1,
	'Invert': 2,
	'Unseen': 3,
	'Seen': 4,
	'Flagged': 5,
	'Unflagged': 6
};

/**
 * @enum {number}
 */
var DesktopNotification = {
	'Allowed': 0,
	'NotAllowed': 1,
	'Denied': 2,
	'NotSupported': 9
};

/**
 * @enum {number}
 */
var MessagePriority = {
	'Low': 5,
	'Normal': 3,
	'High': 1
};

/**
 * @enum {string}
 */
var EditorDefaultType = {
	'Html': 'Html',
	'Plain': 'Plain',
	'HtmlForced': 'HtmlForced',
	'PlainForced': 'PlainForced'
};

/**
 * @enum {number}
 */
var ServerSecure = {
	'None': 0,
	'SSL': 1,
	'TLS': 2
};

/**
 * @enum {number}
 */
var SearchDateType = {
	'All': -1,
	'Days3': 3,
	'Days7': 7,
	'Month': 30
};

/**
 * @enum {number}
 */
var SaveSettingsStep = {
	'Animate': -2,
	'Idle': -1,
	'TrueResult': 1,
	'FalseResult': 0
};

/**
 * @enum {number}
 */
var Layout = {
	'NoPreview': 0,
	'SidePreview': 1,
	'BottomPreview': 2
};

/**
 * @enum {string}
 */
var FilterConditionField = {
	'From': 'From',
	'Recipient': 'Recipient',
	'Subject': 'Subject',
	'Header': 'Header',
	'Size': 'Size'
};

/**
 * @enum {string}
 */
var FilterConditionType = {
	'Contains': 'Contains',
	'NotContains': 'NotContains',
	'EqualTo': 'EqualTo',
	'NotEqualTo': 'NotEqualTo',
	'Regex': 'Regex',
	'Over': 'Over',
	'Under': 'Under'
};

/**
 * @enum {string}
 */
var FiltersAction = {
	'None': 'None',
	'MoveTo': 'MoveTo',
	'Discard': 'Discard',
	'Vacation': 'Vacation',
	'Reject': 'Reject',
	'Forward': 'Forward'
};

/**
 * @enum {string}
 */
var FilterRulesType = {
	'All': 'All',
	'Any': 'Any'
};

/**
 * @enum {number}
 */
var SignedVerifyStatus = {
	'UnknownPublicKeys': -4,
	'UnknownPrivateKey': -3,
	'Unverified': -2,
	'Error': -1,
	'None': 0,
	'Success': 1
};

/**
 * @enum {number}
 */
var ContactPropertyType = {

	'Unknown': 0,

	'FullName': 10,

	'FirstName': 15,
	'LastName': 16,
	'MiddleName': 16,
	'Nick': 18,

	'NamePrefix': 20,
	'NameSuffix': 21,

	'Email': 30,
	'Phone': 31,
	'Web': 32,

	'Birthday': 40,

	'Facebook': 90,
	'Skype': 91,
	'GitHub': 92,

	'Note': 110,

	'Custom': 250
};

/**
 * @enum {number}
 */
var Magics = {
	'EventWhichMouseMiddle': 3,
	'ifvisibleIdle10s': 10,

	'BitLength2048': 2048,
	'BitLength1024': 1024,

	'Size50px': 50,
	'Size20px': 20,
	'Size1px': 1,

	'Time1m': 60000,
	'Time30s': 30000,
	'Time7s': 7000,
	'Time5s': 5000,
	'Time3s': 3000,
	'Time1s': 1000,
	'Time500ms': 500,
	'Time350ms': 350,
	'Time250ms': 250,
	'Time200ms': 200,
	'Time100ms': 100,
	'Time50ms': 50,
	'Time20ms': 20
};

/**
 * @enum {number}
 */
var Ports = {
	'Imap': 143,
	'ImapSsl': 993,
	'Smtp': 25,
	'SmtpSsl': 465,
	'SmtpStartTls': 587
};

/**
 * @enum {number}
 */
var Notification = {
	'InvalidToken': 101,
	'AuthError': 102,
	'AccessError': 103,
	'ConnectionError': 104,
	'CaptchaError': 105,
	'SocialFacebookLoginAccessDisable': 106,
	'SocialTwitterLoginAccessDisable': 107,
	'SocialGoogleLoginAccessDisable': 108,
	'DomainNotAllowed': 109,
	'AccountNotAllowed': 110,

	'AccountTwoFactorAuthRequired': 120,
	'AccountTwoFactorAuthError': 121,

	'CouldNotSaveNewPassword': 130,
	'CurrentPasswordIncorrect': 131,
	'NewPasswordShort': 132,
	'NewPasswordWeak': 133,
	'NewPasswordForbidden': 134,

	'ContactsSyncError': 140,

	'CantGetMessageList': 201,
	'CantGetMessage': 202,
	'CantDeleteMessage': 203,
	'CantMoveMessage': 204,
	'CantCopyMessage': 205,

	'CantSaveMessage': 301,
	'CantSendMessage': 302,
	'InvalidRecipients': 303,

	'CantSaveFilters': 351,
	'CantGetFilters': 352,
	'FiltersAreNotCorrect': 355,

	'CantCreateFolder': 400,
	'CantRenameFolder': 401,
	'CantDeleteFolder': 402,
	'CantSubscribeFolder': 403,
	'CantUnsubscribeFolder': 404,
	'CantDeleteNonEmptyFolder': 405,

	'CantSaveSettings': 501,
	'CantSavePluginSettings': 502,

	'DomainAlreadyExists': 601,

	'CantInstallPackage': 701,
	'CantDeletePackage': 702,
	'InvalidPluginPackage': 703,
	'UnsupportedPluginPackage': 704,

	'LicensingServerIsUnavailable': 710,
	'LicensingExpired': 711,
	'LicensingBanned': 712,

	'DemoSendMessageError': 750,
	'DemoAccountError': 751,

	'AccountAlreadyExists': 801,
	'AccountDoesNotExist': 802,

	'MailServerError': 901,
	'ClientViewError': 902,
	'InvalidInputArgument': 903,

	'AjaxFalse': 950,
	'AjaxAbort': 951,
	'AjaxParse': 952,
	'AjaxTimeout': 953,

	'UnknownNotification': 999,
	'UnknownError': 999
};

/***/ },
/* 4 */
/*!*****************************!*\
  !*** ./dev/Knoin/Knoin.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher__ = __webpack_require__(/*! hasher */ 87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_hasher___default = __WEBPACK_IMPORTED_MODULE_3_hasher__ && __WEBPACK_IMPORTED_MODULE_3_hasher__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_hasher__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_hasher__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_hasher___default, 'a', __WEBPACK_IMPORTED_MODULE_3_hasher___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads__ = __webpack_require__(/*! crossroads */ 48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_crossroads___default = __WEBPACK_IMPORTED_MODULE_4_crossroads__ && __WEBPACK_IMPORTED_MODULE_4_crossroads__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_4_crossroads__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_4_crossroads__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_4_crossroads___default, 'a', __WEBPACK_IMPORTED_MODULE_4_crossroads___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony export */ exports["hideLoading"] = hideLoading;/* harmony export */ exports["constructorEnd"] = constructorEnd;/* harmony export */ exports["extendAsViewModel"] = extendAsViewModel;/* harmony export */ exports["addSettingsViewModel"] = addSettingsViewModel;/* harmony export */ exports["removeSettingsViewModel"] = removeSettingsViewModel;/* harmony export */ exports["disableSettingsViewModel"] = disableSettingsViewModel;/* harmony export */ exports["routeOff"] = routeOff;/* harmony export */ exports["routeOn"] = routeOn;/* harmony export */ exports["screen"] = screen;/* harmony export */ exports["hideScreenPopup"] = hideScreenPopup;/* harmony export */ exports["vmRunHook"] = vmRunHook;/* harmony export */ exports["buildViewModel"] = buildViewModel;/* harmony export */ exports["showScreenPopup"] = showScreenPopup;/* harmony export */ exports["isPopupVisible"] = isPopupVisible;/* harmony export */ exports["screenOnRoute"] = screenOnRoute;/* harmony export */ exports["startScreens"] = startScreens;/* harmony export */ exports["setHash"] = setHash;











var currentScreen = null,
    defaultScreenName = '';

var SCREENS = {};

/**
 * @returns {void}
 */
function hideLoading() {
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content').addClass('rl-content-show');
	__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-loading').hide().remove();
}

/**
 * @param {Object} context
 * @returns {void}
 */
function constructorEnd(context) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isFunc"])(context.__constructor_end)) {
		context.__constructor_end();
	}
}

/**
 * @param {string|Array} name
 * @param {Function} ViewModelClass
 * @returns {void}
 */
function extendAsViewModel(name, ViewModelClass) {
	if (ViewModelClass) {
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(name)) {
			ViewModelClass.__names = name;
		} else {
			ViewModelClass.__names = [name];
		}

		ViewModelClass.__name = ViewModelClass.__names[0];
	}
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} template
 * @param {string} labelName
 * @param {string} route
 * @param {boolean=} isDefault = false
 * @returns {void}
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	var isDefault = arguments.length <= 4 || arguments[4] === undefined ? false : arguments[4];

	SettingsViewModelClass.__rlSettingsData = {
		Label: labelName,
		Template: template,
		Route: route,
		IsDefault: !!isDefault
	};

	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"].settings.push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function removeSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"]['settings-removed'].push(SettingsViewModelClass);
}

/**
 * @param {Function} SettingsViewModelClass
 * @returns {void}
 */
function disableSettingsViewModel(SettingsViewModelClass) {
	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["aViewModels"]['settings-disabled'].push(SettingsViewModelClass);
}

/**
 * @returns {void}
 */
function routeOff() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
}

/**
 * @returns {void}
 */
function routeOn() {
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
}

/**
 * @param {string} screenName
 * @returns {?Object}
 */
function screen(screenName) {
	return '' !== screenName && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(SCREENS[screenName]) ? SCREENS[screenName] : null;
}

/**
 * @param {Function} ViewModelClassToHide
 * @returns {void}
 */
function hideScreenPopup(ViewModelClassToHide) {
	if (ViewModelClassToHide && ViewModelClassToHide.__vm && ViewModelClassToHide.__dom) {
		ViewModelClassToHide.__vm.modalVisibility(false);
	}
}

/**
 * @param {string} hookName
 * @param {Function} ViewModelClass
 * @param {mixed=} params = null
 */
function vmRunHook(hookName, ViewModelClass) {
	var params = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(ViewModelClass.__names, function (name) {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])(hookName, [name, ViewModelClass.__vm, params]);
	});
}

/**
 * @param {Function} ViewModelClass
 * @param {Object=} vmScreen
 * @returns {*}
 */
function buildViewModel(ViewModelClass, vmScreen) {
	if (ViewModelClass && !ViewModelClass.__builded) {
		(function () {
			var vmDom = null;
			var vm = new ViewModelClass(vmScreen),
			    position = vm.viewModelPosition(),
			    vmPlace = __WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content #rl-' + position.toLowerCase());

			ViewModelClass.__builded = true;
			ViewModelClass.__vm = vm;

			vm.onShowTrigger = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);
			vm.onHideTrigger = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false);

			vm.viewModelName = ViewModelClass.__name;
			vm.viewModelNames = ViewModelClass.__names;

			if (vmPlace && 1 === vmPlace.length) {
				vmDom = __WEBPACK_IMPORTED_MODULE_1_____default()('<div></div>').addClass('rl-view-model').addClass('RL-' + vm.viewModelTemplate()).hide();
				vmDom.appendTo(vmPlace);

				vm.viewModelDom = vmDom;
				ViewModelClass.__dom = vmDom;

				if ('Popups' === position) {
					vm.cancelCommand = vm.closeCommand = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["createCommand"])(vm, function () {
						hideScreenPopup(ViewModelClass);
					});

					vm.modalVisibility.subscribe(function (value) {
						if (value) {
							vm.viewModelDom.show();
							vm.storeAndSetKeyScope();

							__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"].push(vm.viewModelName);
							vm.viewModelDom.css('z-index', 3000 + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"])().length + 10);

							if (vm.onShowTrigger) {
								vm.onShowTrigger(!vm.onShowTrigger());
							}

							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onShowWithDelay', [], 500);
						} else {
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onHide');
							__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onHideWithDelay', [], 500);

							if (vm.onHideTrigger) {
								vm.onHideTrigger(!vm.onHideTrigger());
							}

							vm.restoreKeyScope();

							vmRunHook('view-model-on-hide', ViewModelClass);

							__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["popupVisibilityNames"].remove(vm.viewModelName);
							vm.viewModelDom.css('z-index', 2000);

							__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
								return vm.viewModelDom.hide();
							}, 300);
						}
					});
				}

				vmRunHook('view-model-pre-build', ViewModelClass, vmDom);

				__WEBPACK_IMPORTED_MODULE_2_ko___default.a.applyBindingAccessorsToNode(vmDom[0], {
					translatorInit: true,
					template: function template() {
						return { name: vm.viewModelTemplate() };
					}
				}, vm);

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vm, 'onBuild', [vmDom]);
				if (vm && 'Popups' === position) {
					vm.registerPopupKeyDown();
				}

				vmRunHook('view-model-post-build', ViewModelClass, vmDom);
			} else {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["log"])('Cannot find view model position: ' + position);
			}
		})();
	}

	return ViewModelClass ? ViewModelClass.__vm : null;
}

/**
 * @param {Function} ViewModelClassToShow
 * @param {Array=} params
 * @returns {void}
 */
function showScreenPopup(ViewModelClassToShow) {
	var params = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

	if (ViewModelClassToShow) {
		buildViewModel(ViewModelClassToShow);

		if (ViewModelClassToShow.__vm && ViewModelClassToShow.__dom) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClassToShow.__vm, 'onBeforeShow', params || []);

			ViewModelClassToShow.__vm.modalVisibility(true);

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClassToShow.__vm, 'onShow', params || []);

			vmRunHook('view-model-on-show', ViewModelClassToShow, params || []);
		}
	}
}

/**
 * @param {Function} ViewModelClassToShow
 * @returns {boolean}
 */
function isPopupVisible(ViewModelClassToShow) {
	return ViewModelClassToShow && ViewModelClassToShow.__vm ? ViewModelClassToShow.__vm.modalVisibility() : false;
}

/**
 * @param {string} screenName
 * @param {string} subPart
 * @returns {void}
 */
function screenOnRoute(screenName, subPart) {
	var vmScreen = null,
	    isSameScreen = false,
	    cross = null;

	if ('' === __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pString"])(screenName)) {
		screenName = defaultScreenName;
	}

	if ('' !== screenName) {
		vmScreen = screen(screenName);
		if (!vmScreen) {
			vmScreen = screen(defaultScreenName);
			if (vmScreen) {
				subPart = screenName + '/' + subPart;
				screenName = defaultScreenName;
			}
		}

		if (vmScreen && vmScreen.__started) {
			isSameScreen = currentScreen && vmScreen === currentScreen;

			if (!vmScreen.__builded) {
				vmScreen.__builded = true;

				if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(vmScreen.viewModels())) {
					__WEBPACK_IMPORTED_MODULE_0_____default.a.each(vmScreen.viewModels(), function (ViewModelClass) {
						buildViewModel(ViewModelClass, vmScreen);
					});
				}

				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vmScreen, 'onBuild');
			}

			__WEBPACK_IMPORTED_MODULE_0_____default.a.defer(function () {
				// hide screen
				if (currentScreen && !isSameScreen) {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onHide');
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onHideWithDelay', [], 500);

					if (currentScreen.onHideTrigger) {
						currentScreen.onHideTrigger(!currentScreen.onHideTrigger());
					}

					if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {
							if (ViewModelClass.__vm && ViewModelClass.__dom && 'Popups' !== ViewModelClass.__vm.viewModelPosition()) {
								ViewModelClass.__dom.hide();
								ViewModelClass.__vm.viewModelVisibility(false);

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHide');
								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onHideWithDelay', [], 500);

								if (ViewModelClass.__vm.onHideTrigger) {
									ViewModelClass.__vm.onHideTrigger(!ViewModelClass.__vm.onHideTrigger());
								}
							}
						});
					}
				}
				// --

				currentScreen = vmScreen;

				// show screen
				if (currentScreen && !isSameScreen) {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(currentScreen, 'onShow');
					if (currentScreen.onShowTrigger) {
						currentScreen.onShowTrigger(!currentScreen.onShowTrigger());
					}

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-on-show', [currentScreen.screenName(), currentScreen]);

					if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNonEmptyArray"])(currentScreen.viewModels())) {
						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(currentScreen.viewModels(), function (ViewModelClass) {

							if (ViewModelClass.__vm && ViewModelClass.__dom && 'Popups' !== ViewModelClass.__vm.viewModelPosition()) {
								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onBeforeShow');

								ViewModelClass.__dom.show();
								ViewModelClass.__vm.viewModelVisibility(true);

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShow');
								if (ViewModelClass.__vm.onShowTrigger) {
									ViewModelClass.__vm.onShowTrigger(!ViewModelClass.__vm.onShowTrigger());
								}

								__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(ViewModelClass.__vm, 'onShowWithDelay', [], 200);
								vmRunHook('view-model-on-show', ViewModelClass);
							}
						});
					}
				}
				// --

				cross = vmScreen.__cross ? vmScreen.__cross() : null;
				if (cross) {
					cross.parse(subPart);
				}
			});
		}
	}
}

/**
 * @param {Array} screensClasses
 * @returns {void}
 */
function startScreens(screensClasses) {
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(screensClasses, function (CScreen) {
		if (CScreen) {
			var vmScreen = new CScreen(),
			    screenName = vmScreen ? vmScreen.screenName() : '';

			if (vmScreen && '' !== screenName) {
				if ('' === defaultScreenName) {
					defaultScreenName = screenName;
				}

				SCREENS[screenName] = vmScreen;
			}
		}
	});

	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SCREENS, function (vmScreen) {
		if (vmScreen && !vmScreen.__started && vmScreen.__start) {
			vmScreen.__started = true;
			vmScreen.__start();

			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-pre-start', [vmScreen.screenName(), vmScreen]);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["delegateRun"])(vmScreen, 'onStart');
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["runHook"])('screen-post-start', [vmScreen.screenName(), vmScreen]);
		}
	});

	var cross = __WEBPACK_IMPORTED_MODULE_4_crossroads___default.a.create();
	cross.addRoute(/^([a-zA-Z0-9\-]*)\/?(.*)$/, screenOnRoute);

	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.initialized.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.add(cross.parse, cross);
	__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.init();

	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-started-trigger').addClass('rl-started');
	}, 100);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(function () {
		return __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-started-delay');
	}, 200);
}

/**
 * @param {string} sHash
 * @param {boolean=} silence = false
 * @param {boolean=} replace = false
 * @returns {void}
 */
function setHash(hash) {
	var silence = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
	var replace = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

	hash = '#' === hash.substr(0, 1) ? hash.substr(1) : hash;
	hash = '/' === hash.substr(0, 1) ? hash.substr(1) : hash;

	var cmd = replace ? 'replaceHash' : 'setHash';

	if (silence) {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = false;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
	} else {
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.changed.active = true;
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a[cmd](hash);
		__WEBPACK_IMPORTED_MODULE_3_hasher___default.a.setHash(hash);
	}
}

/***/ },
/* 5 */
/*!********************************!*\
  !*** ./dev/Common/Globals.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __WEBPACK_IMPORTED_MODULE_3_key__ && __WEBPACK_IMPORTED_MODULE_3_key__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_key__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_key__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_key___default, 'a', __WEBPACK_IMPORTED_MODULE_3_key___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ko___default = __WEBPACK_IMPORTED_MODULE_4_ko__ && __WEBPACK_IMPORTED_MODULE_4_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_4_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_4_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_4_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_4_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);

/* harmony export */ __webpack_require__.d(exports, "$win", function() { return $win; });
/* harmony export */ __webpack_require__.d(exports, "$doc", function() { return $doc; });
/* harmony export */ __webpack_require__.d(exports, "$html", function() { return $html; });
/* harmony export */ __webpack_require__.d(exports, "$body", function() { return $body; });
/* harmony export */ __webpack_require__.d(exports, "$div", function() { return $div; });
/* harmony export */ __webpack_require__.d(exports, "startMicrotime", function() { return startMicrotime; });
/* harmony export */ __webpack_require__.d(exports, "community", function() { return community; });
/* harmony export */ __webpack_require__.d(exports, "dropdownVisibility", function() { return dropdownVisibility; });
/* harmony export */ __webpack_require__.d(exports, "useKeyboardShortcuts", function() { return useKeyboardShortcuts; });
/* harmony export */ __webpack_require__.d(exports, "sUserAgent", function() { return sUserAgent; });
/* harmony export */ __webpack_require__.d(exports, "bIE", function() { return bIE; });
/* harmony export */ __webpack_require__.d(exports, "bChrome", function() { return bChrome; });
/* harmony export */ __webpack_require__.d(exports, "bSafari", function() { return bSafari; });
/* harmony export */ __webpack_require__.d(exports, "bMobileDevice", function() { return bMobileDevice; });
/* harmony export */ __webpack_require__.d(exports, "bDisableNanoScroll", function() { return bDisableNanoScroll; });
/* harmony export */ __webpack_require__.d(exports, "bAnimationSupported", function() { return bAnimationSupported; });
/* harmony export */ __webpack_require__.d(exports, "bXMLHttpRequestSupported", function() { return bXMLHttpRequestSupported; });
/* harmony export */ __webpack_require__.d(exports, "oHtmlEditorDefaultConfig", function() { return oHtmlEditorDefaultConfig; });
/* harmony export */ __webpack_require__.d(exports, "oHtmlEditorLangsMap", function() { return oHtmlEditorLangsMap; });
/* harmony export */ __webpack_require__.d(exports, "bAllowPdfPreview", function() { return bAllowPdfPreview; });
/* harmony export */ __webpack_require__.d(exports, "aViewModels", function() { return aViewModels; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelDisabled", function() { return leftPanelDisabled; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelType", function() { return leftPanelType; });
/* harmony export */ __webpack_require__.d(exports, "leftPanelWidth", function() { return leftPanelWidth; });
/* harmony export */ __webpack_require__.d(exports, "popupVisibilityNames", function() { return popupVisibilityNames; });
/* harmony export */ __webpack_require__.d(exports, "popupVisibility", function() { return popupVisibility; });
/* harmony export */ __webpack_require__.d(exports, "keyScopeReal", function() { return keyScopeReal; });
/* harmony export */ __webpack_require__.d(exports, "keyScopeFake", function() { return keyScopeFake; });
/* harmony export */ __webpack_require__.d(exports, "keyScope", function() { return keyScope; });
/* harmony export */ __webpack_require__.d(exports, "data", function() { return data; });
/* global RL_COMMUNITY */







var $win = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a);
$win.__sizes = [0, 0];



var $doc = __WEBPACK_IMPORTED_MODULE_2_____default()(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document);

var $html = __WEBPACK_IMPORTED_MODULE_2_____default()('html');

var $body = __WEBPACK_IMPORTED_MODULE_2_____default()('body');

var $div = __WEBPACK_IMPORTED_MODULE_2_____default()('<div></div>');

var startMicrotime = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.Date().getTime();

/**
 * @type {boolean}
 */
var community = false;

/**
 * @type {?}
 */
var dropdownVisibility = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(false).extend({ rateLimit: 0 });

/**
 * @type {boolean}
 */
var useKeyboardShortcuts = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(true);

/**
 * @type {string}
 */
var sUserAgent = 'navigator' in __WEBPACK_IMPORTED_MODULE_0_window___default.a && 'userAgent' in __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.userAgent.toLowerCase() || '';

/**
 * @type {boolean}
 */
var bIE = -1 < sUserAgent.indexOf('msie');

/**
 * @type {boolean}
 */
var bChrome = -1 < sUserAgent.indexOf('chrome');

/**
 * @type {boolean}
 */
var bSafari = !bChrome && -1 < sUserAgent.indexOf('safari');

/**
 * @type {boolean}
 */
var bMobileDevice = /android/i.test(sUserAgent) || /iphone/i.test(sUserAgent) || /ipod/i.test(sUserAgent) || /ipad/i.test(sUserAgent) || /blackberry/i.test(sUserAgent);

/**
 * @type {boolean}
 */
var bDisableNanoScroll = bMobileDevice;

/**
 * @type {boolean}
 */
var bAnimationSupported = !bMobileDevice && $html.hasClass('csstransitions') && $html.hasClass('cssanimations');

/**
 * @type {boolean}
 */
var bXMLHttpRequestSupported = !!__WEBPACK_IMPORTED_MODULE_0_window___default.a.XMLHttpRequest;

/**
 * @type {Object}
 */
var oHtmlEditorDefaultConfig = {
	title: false,
	stylesSet: false,
	customConfig: '',
	contentsCss: '',
	toolbarGroups: [{ name: 'spec' }, { name: 'styles' }, { name: 'basicstyles', groups: ['basicstyles', 'cleanup', 'bidi'] }, { name: 'colors' }, bMobileDevice ? {} : { name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align'] }, { name: 'links' }, { name: 'insert' }, { name: 'document', groups: ['mode', 'document', 'doctools'] }, { name: 'others' }],

	removePlugins: 'liststyle',
	removeButtons: 'Format,Undo,Redo,Cut,Copy,Paste,Anchor,Strike,Subscript,Superscript,Image,SelectAll,Source',
	removeDialogTabs: 'link:advanced;link:target;image:advanced;images:advanced',

	extraPlugins: 'plain,signature',

	allowedContent: true,
	extraAllowedContent: true,

	fillEmptyBlocks: false,
	ignoreEmptyParagraph: true,
	disableNativeSpellChecker: false,

	font_defaultLabel: 'Arial',
	fontSize_defaultLabel: '13',
	fontSize_sizes: '10/10px;12/12px;13/13px;14/14px;16/16px;18/18px;20/20px;24/24px;28/28px;36/36px;48/48px'
};

/**
 * @type {Object}
 */
var oHtmlEditorLangsMap = {
	bg_bg: 'bg',
	de_de: 'de',
	el_gr: 'el',
	es_es: 'es',
	fr_fr: 'fr',
	hu_hu: 'hu',
	is_is: 'is',
	it_it: 'it',
	ja_jp: 'ja',
	ko_kr: 'ko',
	lt_lt: 'lt',
	lv_lv: 'lv',
	nl_nl: 'nl',
	bg_no: 'no',
	pl_pl: 'pl',
	pt_pt: 'pt',
	pt_br: 'pt-br',
	ro_ro: 'ro',
	ru_ru: 'ru',
	sk_sk: 'sk',
	sl_si: 'sl',
	sv_se: 'sv',
	tr_tr: 'tr',
	uk_ua: 'ru',
	zh_tw: 'zh',
	zh_cn: 'zh-cn'
};

/**
 * @type {boolean}
 */
var bAllowPdfPreview = !bMobileDevice;

if (bAllowPdfPreview && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator && __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes) {
	bAllowPdfPreview = !!__WEBPACK_IMPORTED_MODULE_1_____default.a.find(__WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes, function (oType) {
		return oType && 'application/pdf' === oType.type;
	});

	if (!bAllowPdfPreview) {
		bAllowPdfPreview = 'undefined' !== typeof __WEBPACK_IMPORTED_MODULE_0_window___default.a.navigator.mimeTypes['application/pdf'];
	}
}



var aViewModels = {
	settings: [],
	'settings-removed': [],
	'settings-disabled': []
};

var leftPanelDisabled = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(false);
var leftPanelType = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable('');
var leftPanelWidth = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(0);

// popups
var popupVisibilityNames = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observableArray([]);

var popupVisibility = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.computed(function () {
	return 0 < popupVisibilityNames().length;
});

popupVisibility.subscribe(function (bValue) {
	$html.toggleClass('rl-modal', bValue);
});

// keys
var keyScopeReal = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);
var keyScopeFake = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.observable(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].All);

var keyScope = __WEBPACK_IMPORTED_MODULE_4_ko___default.a.computed({
	owner: this,
	read: function read() {
		return keyScopeFake();
	},
	write: function write(sValue) {

		if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu !== sValue) {
			if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Compose === sValue) {
				// disableKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function () {
					return useKeyboardShortcuts();
				};
			} else {
				// restoreKeyFilter
				__WEBPACK_IMPORTED_MODULE_3_key___default.a.filter = function (event) {

					if (useKeyboardShortcuts()) {
						var oElement = event.target || event.srcElement,
						    sTagName = oElement ? oElement.tagName : '';

						sTagName = sTagName.toUpperCase();
						return !('INPUT' === sTagName || 'SELECT' === sTagName || 'TEXTAREA' === sTagName || oElement && 'DIV' === sTagName && ('editorHtmlArea' === oElement.className || 'true' === '' + oElement.contentEditable));
					}

					return false;
				};
			}

			keyScopeFake(sValue);
			if (dropdownVisibility()) {
				sValue = __WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu;
			}
		}

		keyScopeReal(sValue);
	}
});

keyScopeReal.subscribe(function (sValue) {
	//	window.console.log('keyScope=' + sValue); // DEBUG
	__WEBPACK_IMPORTED_MODULE_3_key___default.a.setScope(sValue);
});

dropdownVisibility.subscribe(function (bValue) {
	if (bValue) {
		keyScope(__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu);
	} else if (__WEBPACK_IMPORTED_MODULE_5_Common_Enums__["KeyState"].Menu === __WEBPACK_IMPORTED_MODULE_3_key___default.a.getScope()) {
		keyScope(keyScopeFake());
	}
});

/**
 * @type {*}
 */
var data = {
	__APP__: null,
	iAjaxErrorCount: 0,
	iTokenErrorCount: 0,
	aBootstrapDropdowns: [],
	iMessageBodyCacheCount: 0,
	bUnload: false
};

/***/ },
/* 6 */
/*!***********************************!*\
  !*** ./dev/Common/Translator.jsx ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ko___default = __WEBPACK_IMPORTED_MODULE_3_ko__ && __WEBPACK_IMPORTED_MODULE_3_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_3_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Momentor__ = __webpack_require__(/*! Common/Momentor */ 26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Promise__ = __webpack_require__(/*! Promise */ 37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Promise___default = __WEBPACK_IMPORTED_MODULE_9_Promise__ && __WEBPACK_IMPORTED_MODULE_9_Promise__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_9_Promise__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_9_Promise__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_9_Promise___default, 'a', __WEBPACK_IMPORTED_MODULE_9_Promise___default);

/* harmony export */ __webpack_require__.d(exports, "trigger", function() { return trigger; });/* harmony export */ exports["i18n"] = i18n;/* harmony export */ exports["i18nToNodes"] = i18nToNodes;/* harmony export */ exports["initNotificationLanguage"] = initNotificationLanguage;/* harmony export */ exports["initOnStartOrLangChange"] = initOnStartOrLangChange;/* harmony export */ exports["getNotification"] = getNotification;/* harmony export */ exports["getNotificationFromResponse"] = getNotificationFromResponse;/* harmony export */ exports["getUploadErrorDescByCode"] = getUploadErrorDescByCode;/* harmony export */ exports["reload"] = reload;











var I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

var I18N_NOTIFICATION_DATA = {};
var I18N_NOTIFICATION_MAP = [[__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidToken, 'NOTIFICATIONS/INVALID_TOKEN'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AuthError, 'NOTIFICATIONS/AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccessError, 'NOTIFICATIONS/ACCESS_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ConnectionError, 'NOTIFICATIONS/CONNECTION_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CaptchaError, 'NOTIFICATIONS/CAPTCHA_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialFacebookLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_FACEBOOK_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialTwitterLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_TWITTER_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].SocialGoogleLoginAccessDisable, 'NOTIFICATIONS/SOCIAL_GOOGLE_LOGIN_ACCESS_DISABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainNotAllowed, 'NOTIFICATIONS/DOMAIN_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountNotAllowed, 'NOTIFICATIONS/ACCOUNT_NOT_ALLOWED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthRequired, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_REQUIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountTwoFactorAuthError, 'NOTIFICATIONS/ACCOUNT_TWO_FACTOR_AUTH_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CouldNotSaveNewPassword, 'NOTIFICATIONS/COULD_NOT_SAVE_NEW_PASSWORD'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CurrentPasswordIncorrect, 'NOTIFICATIONS/CURRENT_PASSWORD_INCORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordShort, 'NOTIFICATIONS/NEW_PASSWORD_SHORT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordWeak, 'NOTIFICATIONS/NEW_PASSWORD_WEAK'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].NewPasswordForbidden, 'NOTIFICATIONS/NEW_PASSWORD_FORBIDDENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ContactsSyncError, 'NOTIFICATIONS/CONTACTS_SYNC_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessageList, 'NOTIFICATIONS/CANT_GET_MESSAGE_LIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetMessage, 'NOTIFICATIONS/CANT_GET_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteMessage, 'NOTIFICATIONS/CANT_DELETE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantMoveMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCopyMessage, 'NOTIFICATIONS/CANT_MOVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveMessage, 'NOTIFICATIONS/CANT_SAVE_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSendMessage, 'NOTIFICATIONS/CANT_SEND_MESSAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidRecipients, 'NOTIFICATIONS/INVALID_RECIPIENTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveFilters, 'NOTIFICATIONS/CANT_SAVE_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantGetFilters, 'NOTIFICATIONS/CANT_GET_FILTERS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].FiltersAreNotCorrect, 'NOTIFICATIONS/FILTERS_ARE_NOT_CORRECT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantCreateFolder, 'NOTIFICATIONS/CANT_CREATE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantRenameFolder, 'NOTIFICATIONS/CANT_RENAME_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteFolder, 'NOTIFICATIONS/CANT_DELETE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeleteNonEmptyFolder, 'NOTIFICATIONS/CANT_DELETE_NON_EMPTY_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSubscribeFolder, 'NOTIFICATIONS/CANT_SUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantUnsubscribeFolder, 'NOTIFICATIONS/CANT_UNSUBSCRIBE_FOLDER'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSaveSettings, 'NOTIFICATIONS/CANT_SAVE_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantSavePluginSettings, 'NOTIFICATIONS/CANT_SAVE_PLUGIN_SETTINGS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DomainAlreadyExists, 'NOTIFICATIONS/DOMAIN_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantInstallPackage, 'NOTIFICATIONS/CANT_INSTALL_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].CantDeletePackage, 'NOTIFICATIONS/CANT_DELETE_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidPluginPackage, 'NOTIFICATIONS/INVALID_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnsupportedPluginPackage, 'NOTIFICATIONS/UNSUPPORTED_PLUGIN_PACKAGE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingServerIsUnavailable, 'NOTIFICATIONS/LICENSING_SERVER_IS_UNAVAILABLE'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingExpired, 'NOTIFICATIONS/LICENSING_EXPIRED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].LicensingBanned, 'NOTIFICATIONS/LICENSING_BANNED'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoSendMessageError, 'NOTIFICATIONS/DEMO_SEND_MESSAGE_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].DemoAccountError, 'NOTIFICATIONS/DEMO_ACCOUNT_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountAlreadyExists, 'NOTIFICATIONS/ACCOUNT_ALREADY_EXISTS'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].AccountDoesNotExist, 'NOTIFICATIONS/ACCOUNT_DOES_NOT_EXIST'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].MailServerError, 'NOTIFICATIONS/MAIL_SERVER_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].InvalidInputArgument, 'NOTIFICATIONS/INVALID_INPUT_ARGUMENT'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification, 'NOTIFICATIONS/UNKNOWN_ERROR'], [__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownError, 'NOTIFICATIONS/UNKNOWN_ERROR']];

var trigger = __WEBPACK_IMPORTED_MODULE_3_ko___default.a.observable(false);

/**
 * @param {string} key
 * @param {Object=} valueList
 * @param {string=} defaulValue
 * @returns {string}
 */
function i18n(key, valueList, defaulValue) {
	var valueName = '',
	    result = I18N_DATA[key];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(result)) {
		result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(defaulValue) ? key : defaulValue;
	}

	if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(valueList) && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNull"])(valueList)) {
		for (valueName in valueList) {
			if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["has"])(valueList, valueName)) {
				result = result.replace('%' + valueName + '%', valueList[valueName]);
			}
		}
	}

	return result;
}

var i18nToNode = function i18nToNode(element) {

	var $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element),
	    key = $el.data('i18n');

	if (key) {
		if ('[' === key.substr(0, 1)) {
			switch (key.substr(0, 6)) {
				case '[html]':
					$el.html(i18n(key.substr(6)));
					break;
				case '[place':
					$el.attr('placeholder', i18n(key.substr(13)));
					break;
				case '[title':
					$el.attr('title', i18n(key.substr(7)));
					break;
				// no default
			}
		} else {
			$el.text(i18n(key));
		}
	}
};

/**
 * @param {Object} elements
 * @param {boolean=} animate = false
 */
function i18nToNodes(elements) {
	var animate = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {

		__WEBPACK_IMPORTED_MODULE_2_____default()('[data-i18n]', elements).each(function (index, item) {
			i18nToNode(item);
		});

		if (animate && __WEBPACK_IMPORTED_MODULE_6_Common_Globals__["bAnimationSupported"]) {
			__WEBPACK_IMPORTED_MODULE_2_____default()('.i18n-animation[data-i18n]', elements).letterfx({
				fx: 'fall fade',
				backwards: false,
				timing: 50,
				fx_duration: '50ms',
				letter_end: 'restore',
				element_end: 'restore'
			});
		}
	});
}

var reloadData = function reloadData() {
	if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N) {
		I18N_DATA = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N || {};

		i18nToNodes(__WEBPACK_IMPORTED_MODULE_0_window___default.a.document, true);

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Momentor__["reload"])();
		trigger(!trigger());
	}

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
};

/**
 * @returns {void}
 */
function initNotificationLanguage() {
	I18N_NOTIFICATION_MAP.forEach(function (item) {
		I18N_NOTIFICATION_DATA[item[0]] = i18n(item[1]);
	});
}

/**
 * @param {Function} startCallback
 * @param {Function=} langCallback = null
 */
function initOnStartOrLangChange(startCallback) {
	var langCallback = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

	if (startCallback) {
		startCallback();
	}

	if (langCallback) {
		trigger.subscribe(function () {
			if (startCallback) {
				startCallback();
			}

			langCallback();
		});
	} else if (startCallback) {
		trigger.subscribe(startCallback);
	}
}

/**
 * @param {number} code
 * @param {*=} message = ''
 * @param {*=} defCode = null
 * @returns {string}
 */
function getNotification(code) {
	var message = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
	var defCode = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

	code = __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0;
	if (__WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].ClientViewError === code && message) {
		return message;
	}

	defCode = defCode ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(defCode, 10) || 0 : 0;
	return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[code]) ? defCode && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isUnd"])(I18N_NOTIFICATION_DATA[defCode]) ? I18N_NOTIFICATION_DATA[defCode] : '' : I18N_NOTIFICATION_DATA[code];
}

/**
 * @param {object} response
 * @param {number} defCode = Notification.UnknownNotification
 * @returns {string}
 */
function getNotificationFromResponse(response) {
	var defCode = arguments.length <= 1 || arguments[1] === undefined ? __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["Notification"].UnknownNotification : arguments[1];

	return response && response.ErrorCode ? getNotification(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pInt"])(response.ErrorCode), response.ErrorMessage || '') : getNotification(defCode);
}

/**
 * @param {*} code
 * @returns {string}
 */
function getUploadErrorDescByCode(code) {
	var result = '';
	switch (__WEBPACK_IMPORTED_MODULE_0_window___default.a.parseInt(code, 10) || 0) {
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileIsTooBig:
			result = i18n('UPLOAD/ERROR_FILE_IS_TOO_BIG');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FilePartiallyUploaded:
			result = i18n('UPLOAD/ERROR_FILE_PARTIALLY_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileNoUploaded:
			result = i18n('UPLOAD/ERROR_NO_FILE_UPLOADED');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].MissingTempFolder:
			result = i18n('UPLOAD/ERROR_MISSING_TEMP_FOLDER');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileOnSaveingError:
			result = i18n('UPLOAD/ERROR_ON_SAVING_FILE');
			break;
		case __WEBPACK_IMPORTED_MODULE_4_Common_Enums__["UploadErrorCode"].FileType:
			result = i18n('UPLOAD/ERROR_FILE_TYPE');
			break;
		default:
			result = i18n('UPLOAD/ERROR_UNKNOWN');
			break;
	}

	return result;
}

/**
 * @param {boolean} admin
 * @param {string} language
 */
function reload(admin, language) {
	var start = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])();

	__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-changing-language');

	return new __WEBPACK_IMPORTED_MODULE_9_Promise___default.a(function (resolve, reject) {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.ajax({
			url: __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_8_Common_Links__["langLink"])(language, admin),
			dataType: 'script',
			cache: true
		}).then(function () {
			__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {

				reloadData();

				var isRtl = -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(language, ['ar', 'ar_sa', 'he', 'he_he', 'ur', 'ur_ir']);

				__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language').removeClass('rl-rtl rl-ltr')
				//					.attr('dir', isRtl ? 'rtl' : 'ltr')
				.addClass(isRtl ? 'rl-rtl' : 'rl-ltr');

				resolve();
			}, 500 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])() - start ? 1 : 500);
		}, function () {
			__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].removeClass('rl-changing-language');
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopI18N = null;
			reject();
		});
	});
}

// init section
__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].addClass('rl-' + (__WEBPACK_IMPORTED_MODULE_6_Common_Globals__["$html"].attr('dir') || 'ltr'));

/***/ },
/* 7 */
/*!**********************************!*\
  !*** ./dev/Storage/Settings.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony export */ exports["settingsGet"] = settingsGet;/* harmony export */ exports["settingsSet"] = settingsSet;/* harmony export */ exports["appSettingsGet"] = appSettingsGet;/* harmony export */ exports["capa"] = capa;



var SETTINGS = __WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_data() || null;
SETTINGS = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(SETTINGS) ? SETTINGS : {};

var APP_SETTINGS = SETTINGS.System || null;
APP_SETTINGS = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(APP_SETTINGS) ? APP_SETTINGS : {};

/**
 * @param {string} name
 * @returns {*}
 */
function settingsGet(name) {
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SETTINGS[name]) ? null : SETTINGS[name];
}

/**
 * @param {string} name
 * @param {*} value
 */
function settingsSet(name, value) {
  SETTINGS[name] = value;
}

/**
 * @param {string} name
 * @returns {*}
 */
function appSettingsGet(name) {
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(APP_SETTINGS[name]) ? null : APP_SETTINGS[name];
}

/**
 * @param {string} name
 * @returns {boolean}
 */
function capa(name) {
  var values = settingsGet('Capa');
  return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(values) && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(name) && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["inArray"])(name, values);
}

/***/ },
/* 8 */,
/* 9 */
/*!*************************!*\
  !*** external "window" ***!
  \*************************/
/***/ function(module, exports) {

module.exports = window;

/***/ },
/* 10 */
/*!********************************!*\
  !*** external "window.jQuery" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.jQuery;

/***/ },
/* 11 */
/*!***********************************!*\
  !*** ./dev/Knoin/AbstractView.js ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Globals = __webpack_require__(/*! Common/Globals */ 5);

/**
 * @constructor
 * @param {string=} sPosition = ''
 * @param {string=} sTemplate = ''
 */
function AbstractView(sPosition, sTemplate)
{
	this.bDisabeCloseOnEsc = false;
	this.sPosition = Utils.pString(sPosition);
	this.sTemplate = Utils.pString(sTemplate);

	this.sDefaultKeyScope = Enums.KeyState.None;
	this.sCurrentKeyScope = this.sDefaultKeyScope;

	this.viewModelVisibility = ko.observable(false);
	this.modalVisibility = ko.observable(false).extend({'rateLimit': 0});

	this.viewModelName = '';
	this.viewModelNames = [];
	this.viewModelDom = null;
}

/**
 * @type {boolean}
 */
AbstractView.prototype.bDisabeCloseOnEsc = false;

/**
 * @type {string}
 */
AbstractView.prototype.sPosition = '';

/**
 * @type {string}
 */
AbstractView.prototype.sTemplate = '';

/**
 * @type {string}
 */
AbstractView.prototype.sDefaultKeyScope = Enums.KeyState.None;

/**
 * @type {string}
 */
AbstractView.prototype.sCurrentKeyScope = Enums.KeyState.None;

/**
 * @type {string}
 */
AbstractView.prototype.viewModelName = '';

/**
 * @type {Array}
 */
AbstractView.prototype.viewModelNames = [];

/**
 * @type {?}
 */
AbstractView.prototype.viewModelDom = null;

/**
 * @returns {string}
 */
AbstractView.prototype.viewModelTemplate = function()
{
	return this.sTemplate;
};

/**
 * @returns {string}
 */
AbstractView.prototype.viewModelPosition = function()
{
	return this.sPosition;
};

AbstractView.prototype.cancelCommand = Utils.noop;
AbstractView.prototype.closeCommand = Utils.noop;

AbstractView.prototype.storeAndSetKeyScope = function()
{
	this.sCurrentKeyScope = Globals.keyScope();
	Globals.keyScope(this.sDefaultKeyScope);
};

AbstractView.prototype.restoreKeyScope = function()
{
	Globals.keyScope(this.sCurrentKeyScope);
};

AbstractView.prototype.registerPopupKeyDown = function()
{
	var self = this;

	Globals.$win.on('keydown', function(oEvent) {
		if (oEvent && self.modalVisibility && self.modalVisibility())
		{
			if (!this.bDisabeCloseOnEsc && Enums.EventKeyCode.Esc === oEvent.keyCode)
			{
				Utils.delegateRun(self, 'cancelCommand');
				return false;
			}
			else if (Enums.EventKeyCode.Backspace === oEvent.keyCode && !Utils.inFocus())
			{
				return false;
			}
		}

		return true;
	});
};

module.exports = AbstractView;


/***/ },
/* 12 */
/*!******************************!*\
  !*** ./dev/Common/Links.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony export */ exports["populateAuthSuffix"] = populateAuthSuffix;/* harmony export */ exports["subQueryPrefix"] = subQueryPrefix;/* harmony export */ exports["root"] = root;/* harmony export */ exports["rootAdmin"] = rootAdmin;/* harmony export */ exports["rootUser"] = rootUser;/* harmony export */ exports["attachmentRaw"] = attachmentRaw;/* harmony export */ exports["attachmentDownload"] = attachmentDownload;/* harmony export */ exports["attachmentPreview"] = attachmentPreview;/* harmony export */ exports["attachmentThumbnailPreview"] = attachmentThumbnailPreview;/* harmony export */ exports["attachmentPreviewAsPlain"] = attachmentPreviewAsPlain;/* harmony export */ exports["attachmentFramed"] = attachmentFramed;/* harmony export */ exports["serverRequest"] = serverRequest;/* harmony export */ exports["upload"] = upload;/* harmony export */ exports["uploadContacts"] = uploadContacts;/* harmony export */ exports["uploadBackground"] = uploadBackground;/* harmony export */ exports["append"] = append;/* harmony export */ exports["change"] = change;/* harmony export */ exports["ajax"] = ajax;/* harmony export */ exports["messageViewLink"] = messageViewLink;/* harmony export */ exports["messageDownloadLink"] = messageDownloadLink;/* harmony export */ exports["avatarLink"] = avatarLink;/* harmony export */ exports["publicLink"] = publicLink;/* harmony export */ exports["userBackground"] = userBackground;/* harmony export */ exports["phpInfo"] = phpInfo;/* harmony export */ exports["langLink"] = langLink;/* harmony export */ exports["exportContactsVcf"] = exportContactsVcf;/* harmony export */ exports["exportContactsCsv"] = exportContactsCsv;/* harmony export */ exports["socialGoogle"] = socialGoogle;/* harmony export */ exports["socialTwitter"] = socialTwitter;/* harmony export */ exports["socialFacebook"] = socialFacebook;/* harmony export */ exports["staticPrefix"] = staticPrefix;/* harmony export */ exports["emptyContactPic"] = emptyContactPic;/* harmony export */ exports["sound"] = sound;/* harmony export */ exports["notificationMailIcon"] = notificationMailIcon;/* harmony export */ exports["openPgpJs"] = openPgpJs;/* harmony export */ exports["openPgpWorkerJs"] = openPgpWorkerJs;/* harmony export */ exports["openPgpWorkerPath"] = openPgpWorkerPath;/* harmony export */ exports["themePreviewLink"] = themePreviewLink;/* harmony export */ exports["inbox"] = inbox;/* harmony export */ exports["settings"] = settings;/* harmony export */ exports["about"] = about;/* harmony export */ exports["admin"] = admin;/* harmony export */ exports["mailBox"] = mailBox;




var ROOT = './',
    HASH_PREFIX = '#/',
    SERVER_PREFIX = './?',
    SUB_QUERY_PREFIX = '&q[]=',
    VERSION = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('version'),
    WEB_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webPath') || '',
    VERSION_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('webVersionPath') || 'rainloop/v/' + VERSION + '/',
    STATIC_PREFIX = VERSION_PREFIX + 'static/',
    ADMIN_HOST_USE = !!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminHostUse'),
    ADMIN_PATH = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["appSettingsGet"]('adminPath') || 'admin';

var AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';

/**
 * @returns {void}
 */
function populateAuthSuffix() {
  AUTH_PREFIX = __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AuthAccountHash') || '0';
}

/**
 * @returns {string}
 */
function subQueryPrefix() {
  return SUB_QUERY_PREFIX;
}

/**
 * @param {string=} startupUrl
 * @returns {string}
 */
function root() {
  var startupUrl = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

  return HASH_PREFIX + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(startupUrl);
}

/**
 * @returns {string}
 */
function rootAdmin() {
  return ADMIN_HOST_USE ? ROOT : SERVER_PREFIX + ADMIN_PATH;
}

/**
 * @param {boolean=} mobile = false
 * @returns {string}
 */
function rootUser() {
  var mobile = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

  return mobile ? SERVER_PREFIX + '/Mobile/' : ROOT;
}

/**
 * @param {string} type
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentRaw(type, download, customSpecSuffix) {
  customSpecSuffix = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(customSpecSuffix) ? AUTH_PREFIX : customSpecSuffix;
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + customSpecSuffix + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + download;
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentDownload(download, customSpecSuffix) {
  return attachmentRaw('Download', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreview(download, customSpecSuffix) {
  return attachmentRaw('View', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentThumbnailPreview(download, customSpecSuffix) {
  return attachmentRaw('ViewThumbnail', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentPreviewAsPlain(download, customSpecSuffix) {
  return attachmentRaw('ViewAsPlain', download, customSpecSuffix);
}

/**
 * @param {string} download
 * @param {string=} customSpecSuffix
 * @returns {string}
 */
function attachmentFramed(download, customSpecSuffix) {
  return attachmentRaw('FramedView', download, customSpecSuffix);
}

/**
 * @param {string} type
 * @returns {string}
 */
function serverRequest(type) {
  return SERVER_PREFIX + '/' + type + '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/';
}

/**
 * @returns {string}
 */
function upload() {
  return serverRequest('Upload');
}

/**
 * @returns {string}
 */
function uploadContacts() {
  return serverRequest('UploadContacts');
}

/**
 * @returns {string}
 */
function uploadBackground() {
  return serverRequest('UploadBackground');
}

/**
 * @returns {string}
 */
function append() {
  return serverRequest('Append');
}

/**
 * @param {string} email
 * @returns {string}
 */
function change(email) {
  return serverRequest('Change') + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} add
 * @returns {string}
 */
function ajax(add) {
  return serverRequest('Ajax') + add;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageViewLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ViewAsPlain/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} requestHash
 * @returns {string}
 */
function messageDownloadLink(requestHash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/Download/' + SUB_QUERY_PREFIX + '/' + requestHash;
}

/**
 * @param {string} email
 * @returns {string}
 */
function avatarLink(email) {
  return SERVER_PREFIX + '/Raw/0/Avatar/' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["encodeURIComponent"])(email) + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function publicLink(hash) {
  return SERVER_PREFIX + '/Raw/0/Public/' + hash + '/';
}

/**
 * @param {string} hash
 * @returns {string}
 */
function userBackground(hash) {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/UserBackground/' + SUB_QUERY_PREFIX + '/' + hash;
}

/**
 * @returns {string}
 */
function phpInfo() {
  return SERVER_PREFIX + '/Info';
}

/**
 * @param {string} lang
 * @param {boolean} isAdmin
 * @returns {string}
 */
function langLink(lang, isAdmin) {
  return SERVER_PREFIX + '/Lang/0/' + (isAdmin ? 'Admin' : 'App') + '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(lang) + '/' + VERSION + '/';
}

/**
 * @returns {string}
 */
function exportContactsVcf() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsVcf/';
}

/**
 * @returns {string}
 */
function exportContactsCsv() {
  return SERVER_PREFIX + '/Raw/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/ContactsCsv/';
}

/**
 * @param {boolean} xauth = false
 * @returns {string}
 */
function socialGoogle() {
  var xauth = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

  return SERVER_PREFIX + 'SocialGoogle' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '') + (xauth ? '&xauth=1' : '');
}

/**
 * @returns {string}
 */
function socialTwitter() {
  return SERVER_PREFIX + 'SocialTwitter' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @returns {string}
 */
function socialFacebook() {
  return SERVER_PREFIX + 'SocialFacebook' + ('' !== AUTH_PREFIX ? '/' + SUB_QUERY_PREFIX + '/' + AUTH_PREFIX + '/' : '');
}

/**
 * @param {string} path
 * @returns {string}
 */
function staticPrefix(path) {
  return STATIC_PREFIX + path;
}

/**
 * @returns {string}
 */
function emptyContactPic() {
  return staticPrefix('css/images/empty-contact.png');
}

/**
 * @param {string} fileName
 * @returns {string}
 */
function sound(fileName) {
  return staticPrefix('sounds/' + fileName);
}

/**
 * @returns {string}
 */
function notificationMailIcon() {
  return staticPrefix('css/images/icom-message-notification.png');
}

/**
 * @returns {string}
 */
function openPgpJs() {
  return staticPrefix('js/min/openpgp.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerJs() {
  return staticPrefix('js/min/openpgp.worker.min.js');
}

/**
 * @returns {string}
 */
function openPgpWorkerPath() {
  return staticPrefix('js/min/');
}

/**
 * @param {string} theme
 * @returns {string}
 */
function themePreviewLink(theme) {
  var prefix = VERSION_PREFIX;
  if ('@custom' === theme.substr(-7)) {
    theme = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])(theme.substring(0, theme.length - 7));
    prefix = WEB_PREFIX;
  }

  return prefix + 'themes/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(theme) + '/images/preview.png';
}

/**
 * @param {string} inboxFolderName = 'INBOX'
 * @returns {string}
 */
function inbox() {
  var inboxFolderName = arguments.length <= 0 || arguments[0] === undefined ? 'INBOX' : arguments[0];

  return HASH_PREFIX + 'mailbox/' + inboxFolderName;
}

/**
 * @param {string=} screenName = ''
 * @returns {string}
 */
function settings() {
  var screenName = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

  return HASH_PREFIX + 'settings' + (screenName ? '/' + screenName : '');
}

/**
 * @returns {string}
 */
function about() {
  return HASH_PREFIX + 'about';
}

/**
 * @param {string} screenName
 * @returns {string}
 */
function admin(screenName) {
  var result = HASH_PREFIX;
  switch (screenName) {
    case 'AdminDomains':
      result += 'domains';
      break;
    case 'AdminSecurity':
      result += 'security';
      break;
    case 'AdminLicensing':
      result += 'licensing';
      break;
    // no default
  }

  return result;
}

/**
 * @param {string} folder
 * @param {number=} page = 1
 * @param {string=} search = ''
 * @param {string=} threadUid = ''
 * @returns {string}
 */
function mailBox(folder) {
  var page = arguments.length <= 1 || arguments[1] === undefined ? 1 : arguments[1];
  var search = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];
  var threadUid = arguments.length <= 3 || arguments[3] === undefined ? '' : arguments[3];

  page = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isNormal"])(page) ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(page) : 1;
  search = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pString"])(search);

  var result = HASH_PREFIX + 'mailbox/';

  if ('' !== folder) {
    var resultThreadUid = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(threadUid);
    result += __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(folder) + (0 < resultThreadUid ? '~' + resultThreadUid : '');
  }

  if (1 < page) {
    result = result.replace(/[\/]+$/, '');
    result += '/p' + page;
  }

  if ('' !== search) {
    result = result.replace(/[\/]+$/, '');
    result += '/' + __WEBPACK_IMPORTED_MODULE_0_window___default.a.encodeURI(search);
  }

  return result;
}

/***/ },
/* 13 */
/*!************************************!*\
  !*** ./dev/Component/Abstract.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractComponent; });
/* harmony export */ __webpack_require__.d(exports, "b", function() { return componentExportHelper; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractComponent = function () {
	function AbstractComponent() {
		_classCallCheck(this, AbstractComponent);

		this.disposable = [];
	}

	AbstractComponent.prototype.dispose = function dispose() {
		this.disposable.forEach(function (funcToDispose) {
			if (funcToDispose && funcToDispose.dispose) {
				funcToDispose.dispose();
			}
		});
	};

	return AbstractComponent;
}();

/**
 * @param {*} ClassObject
 * @param {string} templateID = ''
 * @returns {Object}
 */


var componentExportHelper = function componentExportHelper(ClassObject) {
	var templateID = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
	return {
		template: templateID ? { element: templateID } : '<b></b>',
		viewModel: {
			createViewModel: function createViewModel(params, componentInfo) {

				params = params || {};
				params.element = null;

				if (componentInfo && componentInfo.element) {
					params.component = componentInfo;
					params.element = __WEBPACK_IMPORTED_MODULE_0_____default()(componentInfo.element);

					__webpack_require__(/*! Common/Translator */ 6).i18nToNodes(params.element);

					if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.inline) && __WEBPACK_IMPORTED_MODULE_1_ko___default.a.unwrap(params.inline)) {
						params.element.css('display', 'inline-block');
					}
				}

				return new ClassObject(params);
			}
		}
	};
};



/***/ },
/* 14 */,
/* 15 */
/*!*******************************!*\
  !*** ./dev/Common/Consts.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "MESSAGES_PER_PAGE", function() { return MESSAGES_PER_PAGE; });
/* harmony export */ __webpack_require__.d(exports, "MESSAGES_PER_PAGE_VALUES", function() { return MESSAGES_PER_PAGE_VALUES; });
/* harmony export */ __webpack_require__.d(exports, "CONTACTS_PER_PAGE", function() { return CONTACTS_PER_PAGE; });
/* harmony export */ __webpack_require__.d(exports, "DEFAULT_AJAX_TIMEOUT", function() { return DEFAULT_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SEARCH_AJAX_TIMEOUT", function() { return SEARCH_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SEND_MESSAGE_AJAX_TIMEOUT", function() { return SEND_MESSAGE_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "SAVE_MESSAGE_AJAX_TIMEOUT", function() { return SAVE_MESSAGE_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "CONTACTS_SYNC_AJAX_TIMEOUT", function() { return CONTACTS_SYNC_AJAX_TIMEOUT; });
/* harmony export */ __webpack_require__.d(exports, "UNUSED_OPTION_VALUE", function() { return UNUSED_OPTION_VALUE; });
/* harmony export */ __webpack_require__.d(exports, "CLIENT_SIDE_STORAGE_INDEX_NAME", function() { return CLIENT_SIDE_STORAGE_INDEX_NAME; });
/* harmony export */ __webpack_require__.d(exports, "IMAP_DEFAULT_PORT", function() { return IMAP_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "IMAP_DEFAULT_SECURE_PORT", function() { return IMAP_DEFAULT_SECURE_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SMTP_DEFAULT_PORT", function() { return SMTP_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SMTP_DEFAULT_SECURE_PORT", function() { return SMTP_DEFAULT_SECURE_PORT; });
/* harmony export */ __webpack_require__.d(exports, "SIEVE_DEFAULT_PORT", function() { return SIEVE_DEFAULT_PORT; });
/* harmony export */ __webpack_require__.d(exports, "MESSAGE_BODY_CACHE_LIMIT", function() { return MESSAGE_BODY_CACHE_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "AJAX_ERROR_LIMIT", function() { return AJAX_ERROR_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "TOKEN_ERROR_LIMIT", function() { return TOKEN_ERROR_LIMIT; });
/* harmony export */ __webpack_require__.d(exports, "RAINLOOP_TRIAL_KEY", function() { return RAINLOOP_TRIAL_KEY; });
/* harmony export */ __webpack_require__.d(exports, "DATA_IMAGE_USER_DOT_PIC", function() { return DATA_IMAGE_USER_DOT_PIC; });
/* harmony export */ __webpack_require__.d(exports, "DATA_IMAGE_TRANSP_PIC", function() { return DATA_IMAGE_TRANSP_PIC; });
/* eslint max-len: 0 */
var MESSAGES_PER_PAGE = 20;

var MESSAGES_PER_PAGE_VALUES = [10, 20, 30, 50, 100];

var CONTACTS_PER_PAGE = 50;

var DEFAULT_AJAX_TIMEOUT = 30000;

var SEARCH_AJAX_TIMEOUT = 300000;

var SEND_MESSAGE_AJAX_TIMEOUT = 300000;

var SAVE_MESSAGE_AJAX_TIMEOUT = 200000;

var CONTACTS_SYNC_AJAX_TIMEOUT = 200000;

var UNUSED_OPTION_VALUE = '__UNUSE__';

var CLIENT_SIDE_STORAGE_INDEX_NAME = 'rlcsc';

var IMAP_DEFAULT_PORT = 143;

var IMAP_DEFAULT_SECURE_PORT = 993;

var SMTP_DEFAULT_PORT = 25;

var SMTP_DEFAULT_SECURE_PORT = 465;

var SIEVE_DEFAULT_PORT = 4190;

var MESSAGE_BODY_CACHE_LIMIT = 15;

var AJAX_ERROR_LIMIT = 7;

var TOKEN_ERROR_LIMIT = 10;

var RAINLOOP_TRIAL_KEY = 'RAINLOOP-TRIAL-KEY';

var DATA_IMAGE_USER_DOT_PIC = 'data:image/png;base64,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';

var DATA_IMAGE_TRANSP_PIC = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQIW2NkAAIAAAoAAggA9GkAAAAASUVORK5CYII=';

/***/ },
/* 16 */
/*!*****************************!*\
  !*** external "window.key" ***!
  \*****************************/
/***/ function(module, exports) {

module.exports = window.key;

/***/ },
/* 17 */
/*!**********************************!*\
  !*** ./dev/Remote/Admin/Ajax.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	AbstractAjaxRemote = __webpack_require__(/*! Remote/AbstractAjax */ 58);

/**
 * @constructor
 * @extends AbstractAjaxRemote
 */
function RemoteAdminStorage()
{
	AbstractAjaxRemote.call(this);

	this.oRequests = {};
}

_.extend(RemoteAdminStorage.prototype, AbstractAjaxRemote.prototype);

/**
 * @param {?Function} fCallback
 * @param {string} sLogin
 * @param {string} sPassword
 */
RemoteAdminStorage.prototype.adminLogin = function(fCallback, sLogin, sPassword)
{
	this.defaultRequest(fCallback, 'AdminLogin', {
		'Login': sLogin,
		'Password': sPassword
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.adminLogout = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminLogout');
};

/**
 * @param {?Function} fCallback
 * @param {?} oData
 */
RemoteAdminStorage.prototype.saveAdminConfig = function(fCallback, oData)
{
	this.defaultRequest(fCallback, 'AdminSettingsUpdate', oData);
};

/**
 * @param {?Function} fCallback
 * @param {boolean=} bIncludeAliases = true
 */
RemoteAdminStorage.prototype.domainList = function(fCallback, bIncludeAliases)
{
	bIncludeAliases = Utils.isUnd(bIncludeAliases) ? true : bIncludeAliases;
	this.defaultRequest(fCallback, 'AdminDomainList', {
		'IncludeAliases': bIncludeAliases ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.pluginList = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminPluginList');
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.packagesList = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminPackagesList');
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.coreData = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminCoreData');
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.updateCoreData = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminUpdateCoreData', {}, 90000);
};

/**
 * @param {?Function} fCallback
 * @param {Object} oPackage
 */
RemoteAdminStorage.prototype.packageInstall = function(fCallback, oPackage)
{
	this.defaultRequest(fCallback, 'AdminPackageInstall', {
		'Id': oPackage.id,
		'Type': oPackage.type,
		'File': oPackage.file
	}, 60000);
};

/**
 * @param {?Function} fCallback
 * @param {Object} oPackage
 */
RemoteAdminStorage.prototype.packageDelete = function(fCallback, oPackage)
{
	this.defaultRequest(fCallback, 'AdminPackageDelete', {
		'Id': oPackage.id
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sName
 */
RemoteAdminStorage.prototype.domain = function(fCallback, sName)
{
	this.defaultRequest(fCallback, 'AdminDomainLoad', {
		'Name': sName
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sName
 */
RemoteAdminStorage.prototype.plugin = function(fCallback, sName)
{
	this.defaultRequest(fCallback, 'AdminPluginLoad', {
		'Name': sName
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sName
 */
RemoteAdminStorage.prototype.domainDelete = function(fCallback, sName)
{
	this.defaultRequest(fCallback, 'AdminDomainDelete', {
		'Name': sName
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sName
 * @param {boolean} bDisabled
 */
RemoteAdminStorage.prototype.domainDisable = function(fCallback, sName, bDisabled)
{
	return this.defaultRequest(fCallback, 'AdminDomainDisable', {
		Name: sName,
		Disabled: bDisabled ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {Object} oConfig
 */
RemoteAdminStorage.prototype.pluginSettingsUpdate = function(fCallback, oConfig)
{
	return this.defaultRequest(fCallback, 'AdminPluginSettingsUpdate', oConfig);
};

/**
 * @param {?Function} fCallback
 * @param {boolean} bForce
 */
RemoteAdminStorage.prototype.licensing = function(fCallback, bForce)
{
	return this.defaultRequest(fCallback, 'AdminLicensing', {
		Force: bForce ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sDomain
 * @param {string} sKey
 */
RemoteAdminStorage.prototype.licensingActivate = function(fCallback, sDomain, sKey)
{
	return this.defaultRequest(fCallback, 'AdminLicensingActivate', {
		Domain: sDomain,
		Key: sKey
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sName
 * @param {boolean} bDisabled
 */
RemoteAdminStorage.prototype.pluginDisable = function(fCallback, sName, bDisabled)
{
	return this.defaultRequest(fCallback, 'AdminPluginDisable', {
		Name: sName,
		Disabled: bDisabled ? '1' : '0'
	});
};

RemoteAdminStorage.prototype.createDomainAlias = function(fCallback, sName, sAlias)
{
	this.defaultRequest(fCallback, 'AdminDomainAliasSave', {
		Name: sName,
		Alias: sAlias
	});
};

RemoteAdminStorage.prototype.createOrUpdateDomain = function(fCallback,
	bCreate, sName,
	sIncHost, iIncPort, sIncSecure, bIncShortLogin,
	bUseSieve, sSieveAllowRaw, sSieveHost, iSievePort, sSieveSecure,
	sOutHost, iOutPort, sOutSecure, bOutShortLogin, bOutAuth, bOutPhpMail,
	sWhiteList)
{
	this.defaultRequest(fCallback, 'AdminDomainSave', {
		'Create': bCreate ? '1' : '0',
		'Name': sName,

		'IncHost': sIncHost,
		'IncPort': iIncPort,
		'IncSecure': sIncSecure,
		'IncShortLogin': bIncShortLogin ? '1' : '0',

		'UseSieve': bUseSieve ? '1' : '0',
		'SieveAllowRaw': sSieveAllowRaw ? '1' : '0',
		'SieveHost': sSieveHost,
		'SievePort': iSievePort,
		'SieveSecure': sSieveSecure,

		'OutHost': sOutHost,
		'OutPort': iOutPort,
		'OutSecure': sOutSecure,
		'OutShortLogin': bOutShortLogin ? '1' : '0',
		'OutAuth': bOutAuth ? '1' : '0',
		'OutUsePhpMail': bOutPhpMail ? '1' : '0',

		'WhiteList': sWhiteList
	});
};

RemoteAdminStorage.prototype.testConnectionForDomain = function(fCallback, sName,
	sIncHost, iIncPort, sIncSecure,
	bUseSieve, sSieveHost, iSievePort, sSieveSecure,
	sOutHost, iOutPort, sOutSecure, bOutAuth, bOutPhpMail)
{
	this.defaultRequest(fCallback, 'AdminDomainTest', {
		'Name': sName,
		'IncHost': sIncHost,
		'IncPort': iIncPort,
		'IncSecure': sIncSecure,
		'UseSieve': bUseSieve ? '1' : '0',
		'SieveHost': sSieveHost,
		'SievePort': iSievePort,
		'SieveSecure': sSieveSecure,
		'OutHost': sOutHost,
		'OutPort': iOutPort,
		'OutSecure': sOutSecure,
		'OutAuth': bOutAuth ? '1' : '0',
		'OutUsePhpMail': bOutPhpMail ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 * @param {?} oData
 */
RemoteAdminStorage.prototype.testContacts = function(fCallback, oData)
{
	this.defaultRequest(fCallback, 'AdminContactsTest', oData);
};

/**
 * @param {?Function} fCallback
 * @param {?} oData
 */
RemoteAdminStorage.prototype.saveNewAdminPassword = function(fCallback, oData)
{
	this.defaultRequest(fCallback, 'AdminPasswordUpdate', oData);
};

/**
 * @param {?Function} fCallback
 */
RemoteAdminStorage.prototype.adminPing = function(fCallback)
{
	this.defaultRequest(fCallback, 'AdminPing');
};

module.exports = new RemoteAdminStorage();


/***/ },
/* 18 */
/*!***************************!*\
  !*** ./dev/App/Admin.jsx ***!
  \***************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_progressJs__ = __webpack_require__(/*! progressJs */ 49);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_progressJs___default = __WEBPACK_IMPORTED_MODULE_3_progressJs__ && __WEBPACK_IMPORTED_MODULE_3_progressJs__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_progressJs__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_progressJs__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_progressJs___default, 'a', __WEBPACK_IMPORTED_MODULE_3_progressJs___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App__ = __webpack_require__(/*! Stores/Admin/App */ 35);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App___default = __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App__ && __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App___default, 'a', __WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain__ = __webpack_require__(/*! Stores/Admin/Domain */ 52);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default = __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain__ && __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default, 'a', __WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin__ = __webpack_require__(/*! Stores/Admin/Plugin */ 61);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default = __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin__ && __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default, 'a', __WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License__ = __webpack_require__(/*! Stores/Admin/License */ 59);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default = __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License__ && __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default, 'a', __WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package__ = __webpack_require__(/*! Stores/Admin/Package */ 60);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default = __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package__ && __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default, 'a', __WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core__ = __webpack_require__(/*! Stores/Admin/Core */ 90);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default = __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core__ && __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default, 'a', __WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax__ = __webpack_require__(/*! Remote/Admin/Ajax */ 17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default = __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax__ && __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default, 'a', __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_Screen_Admin_Settings__ = __webpack_require__(/*! Screen/Admin/Settings */ 173);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_Screen_Admin_Login__ = __webpack_require__(/*! Screen/Admin/Login */ 172);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_App_Abstract__ = __webpack_require__(/*! App/Abstract */ 66);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }



























var AdminApp = function (_AbstractApp) {
	_inherits(AdminApp, _AbstractApp);

	function AdminApp() {
		_classCallCheck(this, AdminApp);

		return _possibleConstructorReturn(this, _AbstractApp.call(this, __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a));
	}

	AdminApp.prototype.remote = function remote() {
		return __WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a;
	};

	AdminApp.prototype.reloadDomainList = function reloadDomainList() {
		__WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default.a.domains.loading(true);
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.domainList(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default.a.domains.loading(false);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_10_Stores_Admin_Domain___default.a.domains(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data.Result, function (_ref, name) {
					var enabled = _ref[0];
					var alias = _ref[1];
					return {
						name: name,
						disabled: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(!enabled),
						alias: alias,
						deleteAccess: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false)
					};
				}));
			}
		});
	};

	AdminApp.prototype.reloadPluginList = function reloadPluginList() {
		__WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default.a.plugins.loading(true);
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.pluginList(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default.a.plugins.loading(false);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_11_Stores_Admin_Plugin___default.a.plugins(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data.Result, function (item) {
					return {
						name: item.Name,
						disabled: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(!item.Enabled),
						configured: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(!!item.Configured)
					};
				}));
			}
		});
	};

	AdminApp.prototype.reloadPackagesList = function reloadPackagesList() {
		__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packages.loading(true);
		__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packagesReal(true);
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.packagesList(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packages.loading(false);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				(function () {
					__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packagesReal(!!data.Result.Real);
					__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packagesMainUpdatable(!!data.Result.MainUpdatable);

					var list = [];
					var loading = {};

					__WEBPACK_IMPORTED_MODULE_1_____default.a.each(__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packages(), function (item) {
						if (item && item.loading()) {
							loading[item.file] = item;
						}
					});

					if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isArray"])(data.Result.List)) {
						list = __WEBPACK_IMPORTED_MODULE_1_____default.a.compact(__WEBPACK_IMPORTED_MODULE_1_____default.a.map(data.Result.List, function (item) {
							if (item) {
								item.loading = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isUnd"])(loading[item.file]));
								return 'core' === item.type && !item.canBeInstalled ? null : item;
							}
							return null;
						}));
					}

					__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packages(list);
				})();
			} else {
				__WEBPACK_IMPORTED_MODULE_13_Stores_Admin_Package___default.a.packagesReal(false);
			}
		});
	};

	AdminApp.prototype.updateCoreData = function updateCoreData() {
		__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreUpdating(true);
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.updateCoreData(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreUpdating(false);
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersion('');
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteVersion('');
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteRelease('');
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersionCompare(-2);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreReal(true);
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.reload();
			} else {
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreReal(false);
			}
		});
	};

	AdminApp.prototype.reloadCoreData = function reloadCoreData() {
		__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreChecking(true);
		__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreReal(true);
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.coreData(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreChecking(false);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result) {
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreReal(!!data.Result.Real);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreChannel(data.Result.Channel || 'stable');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreType(data.Result.Type || 'stable');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreUpdatable(!!data.Result.Updatable);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreAccess(!!data.Result.Access);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreWarning(!!data.Result.Warning);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersion(data.Result.Version || '');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteVersion(data.Result.RemoteVersion || '');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteRelease(data.Result.RemoteRelease || '');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersionCompare(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.Result.VersionCompare));
			} else {
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreReal(false);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreChannel('stable');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreType('stable');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreWarning(false);
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersion('');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteVersion('');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreRemoteRelease('');
				__WEBPACK_IMPORTED_MODULE_14_Stores_Admin_Core___default.a.coreVersionCompare(-2);
			}
		});
	};

	/**
  * @param {boolean=} force = false
  */


	AdminApp.prototype.reloadLicensing = function reloadLicensing() {
		var force = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensingProcess(true);
		__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseError('');
		__WEBPACK_IMPORTED_MODULE_15_Remote_Admin_Ajax___default.a.licensing(function (result, data) {
			__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensingProcess(false);
			if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Success === result && data && data.Result && __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["isNormal"])(data.Result.Expired)) {
				__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseValid(true);
				__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseExpired(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.Result.Expired));
				__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseError('');
				__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensing(true);
				__WEBPACK_IMPORTED_MODULE_9_Stores_Admin_App___default.a.prem(true);
			} else {
				if (data && data.ErrorCode && -1 < __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["inArray"])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.ErrorCode), [__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Notification"].LicensingServerIsUnavailable, __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Notification"].LicensingExpired])) {
					__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseError(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Translator__["getNotification"])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_7_Common_Utils__["pInt"])(data.ErrorCode)));
					__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensing(true);
				} else {
					if (__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["StorageResultType"].Abort === result) {
						__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licenseError(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Translator__["getNotification"])(__WEBPACK_IMPORTED_MODULE_6_Common_Enums__["Notification"].LicensingServerIsUnavailable));
						__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensing(true);
					} else {
						__WEBPACK_IMPORTED_MODULE_12_Stores_Admin_License___default.a.licensing(false);
					}
				}
			}
		}, force);
	};

	AdminApp.prototype.bootend = function bootend() {
		var bootendCallback = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];

		if (__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a) {
			__WEBPACK_IMPORTED_MODULE_3_progressJs___default.a.end();
		}

		if (bootendCallback) {
			bootendCallback();
		}
	};

	AdminApp.prototype.bootstart = function bootstart() {

		_AbstractApp.prototype.bootstart.call(this);

		__webpack_require__(/*! Stores/Admin/App */ 35).populate();
		__webpack_require__(/*! Stores/Admin/Capa */ 51).populate();

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["hideLoading"])();

		if (!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('allowAdminPanel')) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["routeOff"])();
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_4_Common_Links__["root"](), true);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = '/';
			});
		} else {
			if (__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Auth')) {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_16_Screen_Admin_Settings__["a" /* SettingsAdminScreen */]]);
			} else {
				__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_18_Knoin_Knoin__["startScreens"])([__WEBPACK_IMPORTED_MODULE_17_Screen_Admin_Login__["a" /* LoginAdminScreen */]]);
			}
		}

		this.bootend();
	};

	return AdminApp;
}(__WEBPACK_IMPORTED_MODULE_19_App_Abstract__["a" /* AbstractApp */]);

/* harmony default export */ exports["default"] = new AdminApp();

/***/ },
/* 19 */,
/* 20 */,
/* 21 */
/*!********************************!*\
  !*** ./dev/Common/Plugins.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony export */ exports["addHook"] = addHook;/* harmony export */ exports["runHook"] = runHook;/* harmony export */ exports["mainSettingsGet"] = mainSettingsGet;/* harmony export */ exports["remoteRequest"] = remoteRequest;/* harmony export */ exports["addSettingsViewModel"] = addSettingsViewModel;/* harmony export */ exports["addSettingsViewModelForAdmin"] = addSettingsViewModelForAdmin;/* harmony export */ exports["runSettingsViewModelHooks"] = runSettingsViewModelHooks;/* harmony export */ exports["settingsGet"] = settingsGet;





var SIMPLE_HOOKS = {},
    USER_VIEW_MODELS_HOOKS = [],
    ADMIN_VIEW_MODELS_HOOKS = [];

/**
 * @param {string} name
 * @param {Function} callback
 */
function addHook(name, callback) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isFunc"])(callback)) {
		if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
			SIMPLE_HOOKS[name] = [];
		}

		SIMPLE_HOOKS[name].push(callback);
	}
}

/**
 * @param {string} name
 * @param {Array=} args = []
 */
function runHook(name) {
	var args = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isArray"])(SIMPLE_HOOKS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SIMPLE_HOOKS[name], function (callback) {
			callback.apply(undefined, args);
		});
	}
}

/**
 * @param {string} name
 * @returns {?}
 */
function mainSettingsGet(name) {
	return __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"](name);
}

/**
 * @param {Function} callback
 * @param {string} action
 * @param {Object=} parameters
 * @param {?number=} timeout
 */
function remoteRequest(callback, action, parameters, timeout) {
	if (__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__) {
		__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["data"].__APP__.remote().defaultRequest(callback, 'Plugin' + action, parameters, timeout);
	}
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModel(SettingsViewModelClass, template, labelName, route) {
	USER_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {Function} SettingsViewModelClass
 * @param {string} labelName
 * @param {string} template
 * @param {string} route
 */
function addSettingsViewModelForAdmin(SettingsViewModelClass, template, labelName, route) {
	ADMIN_VIEW_MODELS_HOOKS.push([SettingsViewModelClass, template, labelName, route]);
}

/**
 * @param {boolean} admin
 */
function runSettingsViewModelHooks(admin) {
	var Knoin = __webpack_require__(/*! Knoin/Knoin */ 4);
	__WEBPACK_IMPORTED_MODULE_0_____default.a.each(admin ? ADMIN_VIEW_MODELS_HOOKS : USER_VIEW_MODELS_HOOKS, function (view) {
		Knoin.addSettingsViewModel(view[0], view[1], view[2], view[3]);
	});
}

/**
 * @param {string} pluginSection
 * @param {string} name
 * @returns {?}
 */
function settingsGet(pluginSection, name) {
	var plugins = __WEBPACK_IMPORTED_MODULE_3_Storage_Settings__["settingsGet"]('Plugins');
	plugins = plugins && !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[pluginSection]) ? plugins[pluginSection] : null;
	return plugins ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(plugins[name]) ? null : plugins[name] : null;
}

/***/ },
/* 22 */,
/* 23 */
/*!*******************************!*\
  !*** ./dev/Common/Events.jsx ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony export */ exports["sub"] = sub;/* harmony export */ exports["pub"] = pub;




var SUBS = {};

/**
 * @param {string|Object} name
 * @param {Function} func
 * @param {Object=} context
 */
function sub(name, func, context) {
	if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isObject"])(name)) {
		context = func || null;
		func = null;

		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(name, function (subFunc, subName) {
			sub(subName, subFunc, context);
		});
	} else {
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
			SUBS[name] = [];
		}

		SUBS[name].push([func, context]);
	}
}

/**
 * @param {string} name
 * @param {Array=} args
 */
function pub(name, args) {
	__WEBPACK_IMPORTED_MODULE_2_Common_Plugins__["runHook"]('rl-pub', [name, args]);

	if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(SUBS[name])) {
		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(SUBS[name], function (items) {
			if (items[0]) {
				items[0].apply(items[1] || null, args || []);
			}
		});
	}
}

/***/ },
/* 24 */,
/* 25 */,
/* 26 */
/*!*********************************!*\
  !*** ./dev/Common/Momentor.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment__ = __webpack_require__(/*! moment */ 41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_moment___default = __WEBPACK_IMPORTED_MODULE_3_moment__ && __WEBPACK_IMPORTED_MODULE_3_moment__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_moment__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_moment__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_moment___default, 'a', __WEBPACK_IMPORTED_MODULE_3_moment___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony export */ exports["momentNow"] = momentNow;/* harmony export */ exports["momentNowUnix"] = momentNowUnix;/* harmony export */ exports["searchSubtractFormatDateHelper"] = searchSubtractFormatDateHelper;/* harmony export */ exports["format"] = format;/* harmony export */ exports["momentToNode"] = momentToNode;/* harmony export */ exports["reload"] = reload;






var _moment = null;
var _momentNow = 0;

var updateMomentNow = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_moment = __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}, 500, true);

var updateMomentNowUnix = __WEBPACK_IMPORTED_MODULE_1_____default.a.debounce(function () {
	_momentNow = __WEBPACK_IMPORTED_MODULE_3_moment___default()().unix();
}, 500, true);

/**
 * @returns {moment}
 */
function momentNow() {
	updateMomentNow();
	return _moment || __WEBPACK_IMPORTED_MODULE_3_moment___default()();
}

/**
 * @returns {number}
 */
function momentNowUnix() {
	updateMomentNowUnix();
	return _momentNow || 0;
}

/**
 * @param {number} date
 * @returns {string}
 */
function searchSubtractFormatDateHelper(date) {
	return momentNow().clone().subtract('days', date).format('YYYY.MM.DD');
}

/**
 * @param {Object} m
 * @returns {string}
 */
function formatCustomShortDate(m) {
	var now = momentNow();
	if (m && now) {
		switch (true) {
			case 4 >= now.diff(m, 'hours'):
				return m.fromNow();
			case now.format('L') === m.format('L'):
				return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/TODAY_AT', {
					TIME: m.format('LT')
				});
			case now.clone().subtract('days', 1).format('L') === m.format('L'):
				return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Translator__["i18n"])('MESSAGE_LIST/YESTERDAY_AT', {
					TIME: m.format('LT')
				});
			case now.year() === m.year():
				return m.format('D MMM.');
			// no default
		}
	}

	return m ? m.format('LL') : '';
}

/**
 * @param {number} timeStampInUTC
 * @param {string} formatStr
 * @returns {string}
 */
function format(timeStampInUTC, formatStr) {

	var m = null,
	    result = '';

	var now = momentNowUnix();

	timeStampInUTC = 0 < timeStampInUTC ? timeStampInUTC : 0 === timeStampInUTC ? now : 0;
	timeStampInUTC = now < timeStampInUTC ? now : timeStampInUTC;

	m = 0 < timeStampInUTC ? __WEBPACK_IMPORTED_MODULE_3_moment___default.a.unix(timeStampInUTC) : null;

	if (m && 1970 === m.year()) {
		m = null;
	}

	if (m) {
		switch (formatStr) {
			case 'FROMNOW':
				result = m.fromNow();
				break;
			case 'SHORT':
				result = formatCustomShortDate(m);
				break;
			case 'FULL':
				result = m.format('LLL');
				break;
			default:
				result = m.format(formatStr);
				break;
		}
	}

	return result;
}

/**
 * @param {Object} element
 * @returns {void}
 */
function momentToNode(element) {
	var key = '',
	    time = 0,
	    $el = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

	time = $el.data('moment-time');
	if (time) {
		key = $el.data('moment-format');
		if (key) {
			$el.text(format(time, key));
		}

		key = $el.data('moment-format-title');
		if (key) {
			$el.attr('title', format(time, key));
		}
	}
}

/**
 * @returns {void}
 */
function reload() {
	__WEBPACK_IMPORTED_MODULE_1_____default.a.defer(function () {
		__WEBPACK_IMPORTED_MODULE_2_____default()('.moment', __WEBPACK_IMPORTED_MODULE_0_window___default.a.document).each(function (index, item) {
			momentToNode(item);
		});
	});
}

/***/ },
/* 27 */,
/* 28 */,
/* 29 */,
/* 30 */
/*!*****************************!*\
  !*** ./dev/Model/Email.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "EmailModel", function() { return EmailModel; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return EmailModel; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }



var EmailModel = function () {
	/**
  * @param {string=} email = ''
  * @param {string=} name = ''
  * @param {string=} dkimStatus = 'none'
  * @param {string=} dkimValue = ''
  */

	function EmailModel() {
		var email = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];
		var name = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];
		var dkimStatus = arguments.length <= 2 || arguments[2] === undefined ? 'none' : arguments[2];
		var dkimValue = arguments.length <= 3 || arguments[3] === undefined ? '' : arguments[3];

		_classCallCheck(this, EmailModel);

		this.email = email;
		this.name = name;
		this.dkimStatus = dkimStatus;
		this.dkimValue = dkimValue;

		this.clearDuplicateName();
	}

	/**
  * @static
  * @param {AjaxJsonEmail} json
  * @returns {?EmailModel}
  */


	EmailModel.newInstanceFromJson = function newInstanceFromJson(json) {
		var email = new EmailModel();
		return email.initByJson(json) ? email : null;
	};

	/**
  * @static
  * @param {string} line
  * @param {string=} delimiter = ';'
  * @returns {Array}
  */


	EmailModel.splitHelper = function splitHelper(line) {
		var delimiter = arguments.length <= 1 || arguments[1] === undefined ? ';' : arguments[1];

		line = line.replace(/[\r\n]+/g, '; ').replace(/[\s]+/g, ' ');

		var index = 0,
		    len = 0,
		    at = false,
		    char = '',
		    result = '';

		for (len = line.length; index < len; index++) {
			char = line.charAt(index);
			switch (char) {
				case '@':
					at = true;
					break;
				case ' ':
					if (at) {
						at = false;
						result += delimiter;
					}
					break;
				// no default
			}

			result += char;
		}

		return result.split(delimiter);
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clear = function clear() {
		this.email = '';
		this.name = '';

		this.dkimStatus = 'none';
		this.dkimValue = '';
	};

	/**
  * @returns {boolean}
  */


	EmailModel.prototype.validate = function validate() {
		return '' !== this.name || '' !== this.email;
	};

	/**
  * @param {boolean} withoutName = false
  * @returns {string}
  */


	EmailModel.prototype.hash = function hash() {
		var withoutName = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

		return '#' + (withoutName ? '' : this.name) + '#' + this.email + '#';
	};

	/**
  * @returns {void}
  */


	EmailModel.prototype.clearDuplicateName = function clearDuplicateName() {
		if (this.name === this.email) {
			this.name = '';
		}
	};

	/**
  * @param {string} query
  * @returns {boolean}
  */


	EmailModel.prototype.search = function search(query) {
		return -1 < (this.name + ' ' + this.email).toLowerCase().indexOf(query.toLowerCase());
	};

	/**
  * @param {string} str
  */


	EmailModel.prototype.parse = function parse(str) {
		this.clear();

		str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(str);

		var regex = /(?:"([^"]+)")? ?[<]?(.*?@[^>,]+)>?,? ?/g,
		    match = regex.exec(str);

		if (match) {
			this.name = match[1] || '';
			this.email = match[2] || '';

			this.clearDuplicateName();
		} else if (/^[^@]+@[^@]+$/.test(str)) {
			this.name = '';
			this.email = str;
		}
	};

	/**
  * @param {AjaxJsonEmail} oJsonEmail
  * @returns {boolean}
  */


	EmailModel.prototype.initByJson = function initByJson(json) {
		var result = false;
		if (json && 'Object/Email' === json['@Object']) {
			this.name = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.Name);
			this.email = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.Email);
			this.dkimStatus = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.DkimStatus || '');
			this.dkimValue = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])(json.DkimValue || '');

			result = '' !== this.email;
			this.clearDuplicateName();
		}

		return result;
	};

	/**
  * @param {boolean} friendlyView
  * @param {boolean=} wrapWithLink = false
  * @param {boolean=} useEncodeHtml = false
  * @returns {string}
  */


	EmailModel.prototype.toLine = function toLine(friendlyView) {
		var wrapWithLink = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
		var useEncodeHtml = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

		var result = '';
		if ('' !== this.email) {
			if (friendlyView && '' !== this.name) {
				result = wrapWithLink ? '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.name) + '</a>' : __WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"] ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.name) : this.name;
			} else {
				result = this.email;
				if ('' !== this.name) {
					if (wrapWithLink) {
						result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <') + '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('"' + this.name + '" <' + this.email + '>') + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(result) + '</a>' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])('>');
					} else {
						result = '"' + this.name + '" <' + result + '>';
						if (useEncodeHtml) {
							result = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(result);
						}
					}
				} else if (wrapWithLink) {
					result = '<a href="mailto:' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.email) + '" target="_blank" tabindex="-1">' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["encodeHtml"])(this.email) + '</a>';
				}
			}
		}

		return result;
	};

	/**
  * @param {string} $sEmailAddress
  * @returns {boolean}
  */


	EmailModel.prototype.mailsoParse = function mailsoParse($sEmailAddress) {
		$sEmailAddress = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sEmailAddress);
		if ('' === $sEmailAddress) {
			return false;
		}

		var substr = function substr(str, start, len) {
			str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pString"])(str);
			var end = str.length;

			if (0 > start) {
				start += end;
			}

			end = 'undefined' === typeof len ? end : 0 > len ? len + end : len + start;

			return start >= str.length || 0 > start || start > end ? false : str.slice(start, end);
		},
		    substrReplace = function substrReplace(str, replace, start, length) {
			str = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pString"])(str);
			if (0 > start) {
				start += str.length;
			}

			length = 'undefined' !== typeof length ? length : str.length;
			if (0 > length) {
				length = length + str.length - start;
			}
			return str.slice(0, start) + replace.substr(0, length) + replace.slice(length) + str.slice(start + length);
		},
		    $sName = '',
		    $sEmail = '',
		    $sComment = '',
		    $bInName = false,
		    $bInAddress = false,
		    $bInComment = false,
		    $aRegs = null,
		    $iStartIndex = 0,
		    $iEndIndex = 0,
		    $iCurrentIndex = 0;

		while ($iCurrentIndex < $sEmailAddress.length) {
			switch ($sEmailAddress.substr($iCurrentIndex, 1)) {
				case '"':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInName = true;
						$iStartIndex = $iCurrentIndex;
					} else if (!$bInAddress && !$bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sName = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInName = false;
					}
					break;
				case '<':
					if (!$bInName && !$bInAddress && !$bInComment) {
						if (0 < $iCurrentIndex && 0 === $sName.length) {
							$sName = substr($sEmailAddress, 0, $iCurrentIndex);
						}

						$bInAddress = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case '>':
					if ($bInAddress) {
						$iEndIndex = $iCurrentIndex;
						$sEmail = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInAddress = false;
					}
					break;
				case '(':
					if (!$bInName && !$bInAddress && !$bInComment) {
						$bInComment = true;
						$iStartIndex = $iCurrentIndex;
					}
					break;
				case ')':
					if ($bInComment) {
						$iEndIndex = $iCurrentIndex;
						$sComment = substr($sEmailAddress, $iStartIndex + 1, $iEndIndex - $iStartIndex - 1);
						$sEmailAddress = substrReplace($sEmailAddress, '', $iStartIndex, $iEndIndex - $iStartIndex + 1);
						$iEndIndex = 0;
						$iCurrentIndex = 0;
						$iStartIndex = 0;
						$bInComment = false;
					}
					break;
				case '\\':
					$iCurrentIndex += 1;
					break;
				// no default
			}

			$iCurrentIndex += 1;
		}

		if (0 === $sEmail.length) {
			$aRegs = $sEmailAddress.match(/[^@\s]+@\S+/i);
			if ($aRegs && $aRegs[0]) {
				$sEmail = $aRegs[0];
			} else {
				$sName = $sEmailAddress;
			}
		}

		if (0 < $sEmail.length && 0 === $sName.length && 0 === $sComment.length) {
			$sName = $sEmailAddress.replace($sEmail, '');
		}

		$sEmail = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sEmail).replace(/^[<]+/, '').replace(/[>]+$/, '');
		$sName = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sName).replace(/^["']+/, '').replace(/["']+$/, '');
		$sComment = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["trim"])($sComment).replace(/^[(]+/, '').replace(/[)]+$/, '');

		// Remove backslash
		$sName = $sName.replace(/\\\\(.)/g, '$1');
		$sComment = $sComment.replace(/\\\\(.)/g, '$1');

		this.name = $sName;
		this.email = $sEmail;

		this.clearDuplicateName();
		return true;
	};

	return EmailModel;
}();



/***/ },
/* 31 */,
/* 32 */
/*!*****************************************!*\
  !*** ./dev/Component/AbstractInput.jsx ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractInput; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AbstractInput = function (_AbstractComponent) {
	_inherits(AbstractInput, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function AbstractInput(params) {
		_classCallCheck(this, AbstractInput);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.value = params.value || '';
		_this.size = params.size || 0;
		_this.label = params.label || '';
		_this.preLabel = params.preLabel || '';
		_this.enable = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.enable) ? true : params.enable;
		_this.trigger = params.trigger && params.trigger.subscribe ? params.trigger : null;
		_this.placeholder = params.placeholder || '';

		_this.labeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.label);
		_this.preLabeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.preLabel);
		_this.triggered = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.trigger) && !!_this.trigger;

		_this.classForTrigger = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable('');

		_this.className = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.computed(function () {

			var size = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.unwrap(_this.size),
			    suffixValue = _this.trigger ? ' ' + __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["trim"])('settings-saved-trigger-input ' + _this.classForTrigger()) : '';

			return (0 < size ? 'span' + size : '') + suffixValue;
		}, _this);

		if (!__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.width) && params.element) {
			params.element.find('input,select,textarea').css('width', params.width);
		}

		_this.disposable.push(_this.className);

		if (_this.trigger) {
			_this.setTriggerState(_this.trigger());

			_this.disposable.push(_this.trigger.subscribe(_this.setTriggerState, _this));
		}
		return _this;
	}

	AbstractInput.prototype.setTriggerState = function setTriggerState(value) {
		switch (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.classForTrigger('success');
				break;
			case __WEBPACK_IMPORTED_MODULE_2_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.classForTrigger('error');
				break;
			default:
				this.classForTrigger('');
				break;
		}
	};

	return AbstractInput;
}(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 33 */
/*!******************************!*\
  !*** external "window.JSON" ***!
  \******************************/
/***/ function(module, exports) {

module.exports = window.JSON;

/***/ },
/* 34 */
/*!******************************!*\
  !*** ./dev/Stores/Social.js ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function SocialStore()
{
	this.google = {};
	this.twitter = {};
	this.facebook = {};
	this.dropbox = {};

	// Google
	this.google.enabled = ko.observable(false);

	this.google.clientID = ko.observable('');
	this.google.clientSecret = ko.observable('');
	this.google.apiKey = ko.observable('');

	this.google.loading = ko.observable(false);
	this.google.userName = ko.observable('');

	this.google.loggined = ko.computed(function() {
		return '' !== this.google.userName();
	}, this);

	this.google.capa = {};
	this.google.capa.auth = ko.observable(false);
	this.google.capa.authFast = ko.observable(false);
	this.google.capa.drive = ko.observable(false);
	this.google.capa.preview = ko.observable(false);

	this.google.require = {};
	this.google.require.clientSettings = ko.computed(function() {
		return this.google.enabled() && (this.google.capa.auth() || this.google.capa.drive());
	}, this);

	this.google.require.apiKeySettings = ko.computed(function() {
		return this.google.enabled() && this.google.capa.drive();
	}, this);

	// Facebook
	this.facebook.enabled = ko.observable(false);
	this.facebook.appID = ko.observable('');
	this.facebook.appSecret = ko.observable('');
	this.facebook.loading = ko.observable(false);
	this.facebook.userName = ko.observable('');
	this.facebook.supported = ko.observable(false);

	this.facebook.loggined = ko.computed(function() {
		return '' !== this.facebook.userName();
	}, this);

	// Twitter
	this.twitter.enabled = ko.observable(false);
	this.twitter.consumerKey = ko.observable('');
	this.twitter.consumerSecret = ko.observable('');
	this.twitter.loading = ko.observable(false);
	this.twitter.userName = ko.observable('');

	this.twitter.loggined = ko.computed(function() {
		return '' !== this.twitter.userName();
	}, this);

	// Dropbox
	this.dropbox.enabled = ko.observable(false);
	this.dropbox.apiKey = ko.observable('');
}

SocialStore.prototype.google = {};
SocialStore.prototype.twitter = {};
SocialStore.prototype.facebook = {};
SocialStore.prototype.dropbox = {};

SocialStore.prototype.populate = function()
{
	var Settings = __webpack_require__(/*! Storage/Settings */ 7);

	this.google.enabled(!!Settings.settingsGet('AllowGoogleSocial'));
	this.google.clientID(Settings.settingsGet('GoogleClientID'));
	this.google.clientSecret(Settings.settingsGet('GoogleClientSecret'));
	this.google.apiKey(Settings.settingsGet('GoogleApiKey'));

	this.google.capa.auth(!!Settings.settingsGet('AllowGoogleSocialAuth'));
	this.google.capa.authFast(!!Settings.settingsGet('AllowGoogleSocialAuthFast'));
	this.google.capa.drive(!!Settings.settingsGet('AllowGoogleSocialDrive'));
	this.google.capa.preview(!!Settings.settingsGet('AllowGoogleSocialPreview'));

	this.facebook.enabled(!!Settings.settingsGet('AllowFacebookSocial'));
	this.facebook.appID(Settings.settingsGet('FacebookAppID'));
	this.facebook.appSecret(Settings.settingsGet('FacebookAppSecret'));
	this.facebook.supported(!!Settings.settingsGet('SupportedFacebookSocial'));

	this.twitter.enabled = ko.observable(!!Settings.settingsGet('AllowTwitterSocial'));
	this.twitter.consumerKey = ko.observable(Settings.settingsGet('TwitterConsumerKey'));
	this.twitter.consumerSecret = ko.observable(Settings.settingsGet('TwitterConsumerSecret'));

	this.dropbox.enabled(!!Settings.settingsGet('AllowDropboxSocial'));
	this.dropbox.apiKey(Settings.settingsGet('DropboxApiKey'));
};

module.exports = new SocialStore();


/***/ },
/* 35 */
/*!**********************************!*\
  !*** ./dev/Stores/Admin/App.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Stores_AbstractApp__ = __webpack_require__(/*! Stores/AbstractApp */ 81);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AppAdminStore = function (_AbstractAppStore) {
	_inherits(AppAdminStore, _AbstractAppStore);

	function AppAdminStore() {
		_classCallCheck(this, AppAdminStore);

		var _this = _possibleConstructorReturn(this, _AbstractAppStore.call(this));

		_this.determineUserLanguage = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.determineUserDomain = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);

		_this.weakPassword = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		_this.useLocalProxyForExternalImages = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		return _this;
	}

	AppAdminStore.prototype.populate = function populate() {

		_AbstractAppStore.prototype.populate.call(this);

		this.determineUserLanguage(!!__WEBPACK_IMPORTED_MODULE_1_Storage_Settings__["settingsGet"]('DetermineUserLanguage'));
		this.determineUserDomain(!!__WEBPACK_IMPORTED_MODULE_1_Storage_Settings__["settingsGet"]('DetermineUserDomain'));

		this.weakPassword(!!__WEBPACK_IMPORTED_MODULE_1_Storage_Settings__["settingsGet"]('WeakPassword'));
		this.useLocalProxyForExternalImages(!!__WEBPACK_IMPORTED_MODULE_1_Storage_Settings__["settingsGet"]('UseLocalProxyForExternalImages'));
	};

	return AppAdminStore;
}(__WEBPACK_IMPORTED_MODULE_2_Stores_AbstractApp__["a" /* AbstractAppStore */]);

module.exports = new AppAdminStore();

/***/ },
/* 36 */
/*!************************************!*\
  !*** ./dev/Component/Checkbox.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 46);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var CheckboxComponent = function (_AbstracCheckbox) {
  _inherits(CheckboxComponent, _AbstracCheckbox);

  function CheckboxComponent() {
    _classCallCheck(this, CheckboxComponent);

    return _possibleConstructorReturn(this, _AbstracCheckbox.apply(this, arguments));
  }

  return CheckboxComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(CheckboxComponent, 'CheckboxComponent');

/***/ },
/* 37 */
/*!*********************************!*\
  !*** external "window.Promise" ***!
  \*********************************/
/***/ function(module, exports) {

module.exports = window.Promise;

/***/ },
/* 38 */
/*!********************************!*\
  !*** ./dev/Stores/Language.js ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function LanguageStore()
{
	this.languages = ko.observableArray([]);
	this.languagesAdmin = ko.observableArray([]);

	this.language = ko.observable('')
		.extend({'limitedList': this.languages})
		.extend({'reversible': true});

	this.languageAdmin = ko.observable('')
		.extend({'limitedList': this.languagesAdmin})
		.extend({'reversible': true});

	this.userLanguage = ko.observable('');
	this.userLanguageAdmin = ko.observable('');
}

LanguageStore.prototype.populate = function()
{
	var
		aLanguages = Settings.appSettingsGet('languages'),
		aLanguagesAdmin = Settings.appSettingsGet('languagesAdmin');

	this.languages(Utils.isArray(aLanguages) ? aLanguages : []);
	this.languagesAdmin(Utils.isArray(aLanguagesAdmin) ? aLanguagesAdmin : []);

	this.language(Settings.settingsGet('Language'));
	this.languageAdmin(Settings.settingsGet('LanguageAdmin'));

	this.userLanguage(Settings.settingsGet('UserLanguage'));
	this.userLanguageAdmin(Settings.settingsGet('UserLanguageAdmin'));
};

module.exports = new LanguageStore();


/***/ },
/* 39 */
/*!*******************************!*\
  !*** ./dev/View/Popup/Ask.js ***!
  \*******************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function AskPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsAsk');

	this.askDesc = ko.observable('');
	this.yesButton = ko.observable('');
	this.noButton = ko.observable('');

	this.yesFocus = ko.observable(false);
	this.noFocus = ko.observable(false);

	this.fYesAction = null;
	this.fNoAction = null;

	this.bFocusYesOnShow = true;
	this.bDisabeCloseOnEsc = true;
	this.sDefaultKeyScope = Enums.KeyState.PopupAsk;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Ask', 'PopupsAskViewModel'], AskPopupView);
_.extend(AskPopupView.prototype, AbstractView.prototype);

AskPopupView.prototype.clearPopup = function()
{
	this.askDesc('');
	this.yesButton(Translator.i18n('POPUPS_ASK/BUTTON_YES'));
	this.noButton(Translator.i18n('POPUPS_ASK/BUTTON_NO'));

	this.yesFocus(false);
	this.noFocus(false);

	this.fYesAction = null;
	this.fNoAction = null;
};

AskPopupView.prototype.yesClick = function()
{
	this.cancelCommand();

	if (Utils.isFunc(this.fYesAction))
	{
		this.fYesAction.call(null);
	}
};

AskPopupView.prototype.noClick = function()
{
	this.cancelCommand();

	if (Utils.isFunc(this.fNoAction))
	{
		this.fNoAction.call(null);
	}
};

/**
 * @param {string} sAskDesc
 * @param {Function=} fYesFunc
 * @param {Function=} fNoFunc
 * @param {string=} sYesButton
 * @param {string=} sNoButton
 * @param {boolean=} bFocusYesOnShow
 * @returns {void}
 */
AskPopupView.prototype.onShow = function(sAskDesc, fYesFunc, fNoFunc, sYesButton, sNoButton, bFocusYesOnShow)
{
	this.clearPopup();

	this.fYesAction = fYesFunc || null;
	this.fNoAction = fNoFunc || null;

	this.askDesc(sAskDesc || '');

	if (sYesButton)
	{
		this.yesButton(sYesButton);
	}

	if (sNoButton)
	{
		this.noButton(sNoButton);
	}

	this.bFocusYesOnShow = Utils.isUnd(bFocusYesOnShow) ? true : !!bFocusYesOnShow;
};

AskPopupView.prototype.onShowWithDelay = function()
{
	if (this.bFocusYesOnShow)
	{
		this.yesFocus(true);
	}
};

AskPopupView.prototype.onBuild = function()
{
	key('tab, shift+tab, right, left', Enums.KeyState.PopupAsk, _.bind(function() {
		if (this.yesFocus())
		{
			this.noFocus(true);
		}
		else
		{
			this.yesFocus(true);
		}
		return false;
	}, this));

	key('esc', Enums.KeyState.PopupAsk, _.bind(function() {
		this.noClick();
		return false;
	}, this));
};

module.exports = AskPopupView;


/***/ },
/* 40 */
/*!**************************************!*\
  !*** ./dev/Knoin/AbstractScreen.jsx ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_crossroads__ = __webpack_require__(/*! crossroads */ 48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_crossroads___default = __WEBPACK_IMPORTED_MODULE_1_crossroads__ && __WEBPACK_IMPORTED_MODULE_1_crossroads__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_crossroads__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_crossroads__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_crossroads___default, 'a', __WEBPACK_IMPORTED_MODULE_1_crossroads___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractScreen = function () {
	function AbstractScreen(screenName) {
		var viewModels = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

		_classCallCheck(this, AbstractScreen);

		this.oCross = null;
		this.sScreenName = screenName;
		this.aViewModels = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isArray"])(viewModels) ? viewModels : [];
	}

	/**
  * @returns {Array}
  */


	AbstractScreen.prototype.viewModels = function viewModels() {
		return this.aViewModels;
	};

	/**
  * @returns {string}
  */


	AbstractScreen.prototype.screenName = function screenName() {
		return this.sScreenName;
	};

	/**
  * @returns {?Array)}
  */


	AbstractScreen.prototype.routes = function routes() {
		return null;
	};

	/**
  * @returns {?Object}
  */


	AbstractScreen.prototype.__cross = function __cross() {
		return this.oCross;
	};

	/**
  * @returns {void}
  */


	AbstractScreen.prototype.__start = function __start() {
		var route = null,
		    fMatcher = null;
		var routes = this.routes();

		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isNonEmptyArray"])(routes)) {
			fMatcher = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(this.onRoute || __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["noop"], this);
			route = __WEBPACK_IMPORTED_MODULE_1_crossroads___default.a.create();

			__WEBPACK_IMPORTED_MODULE_0_____default.a.each(routes, function (aItem) {
				route.addRoute(aItem[0], fMatcher).rules = aItem[1];
			});

			this.oCross = route;
		}
	};

	return AbstractScreen;
}();



/***/ },
/* 41 */
/*!********************************!*\
  !*** external "window.moment" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.moment;

/***/ },
/* 42 */,
/* 43 */
/*!*****************************!*\
  !*** ./dev/Stores/Theme.js ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function ThemeStore()
{
	this.themes = ko.observableArray([]);
	this.themeBackgroundName = ko.observable('');
	this.themeBackgroundHash = ko.observable('');

	this.theme = ko.observable('')
		.extend({'limitedList': this.themes});
}

ThemeStore.prototype.populate = function()
{
	var aThemes = Settings.appSettingsGet('themes');

	this.themes(Utils.isArray(aThemes) ? aThemes : []);
	this.theme(Settings.settingsGet('Theme'));
	this.themeBackgroundName(Settings.settingsGet('UserBackgroundName'));
	this.themeBackgroundHash(Settings.settingsGet('UserBackgroundHash'));
};

module.exports = new ThemeStore();


/***/ },
/* 44 */
/*!*************************************!*\
  !*** ./dev/View/Popup/Languages.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function LanguagesPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsLanguages');

	var self = this;

	this.fLang = null;
	this.userLanguage = ko.observable('');

	this.langs = ko.observableArray([]);

	this.languages = ko.computed(function() {
		var sUserLanguage = self.userLanguage();
		return _.map(self.langs(), function(sLanguage) {
			return {
				'key': sLanguage,
				'user': sLanguage === sUserLanguage,
				'selected': ko.observable(false),
				'fullName': Utils.convertLangName(sLanguage)
			};
		});
	});

	this.langs.subscribe(function() {
		this.setLanguageSelection();
	}, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Languages', 'PopupsLanguagesViewModel'], LanguagesPopupView);
_.extend(LanguagesPopupView.prototype, AbstractView.prototype);

LanguagesPopupView.prototype.languageTooltipName = function(sLanguage)
{
	var sResult = Utils.convertLangName(sLanguage, true);
	return Utils.convertLangName(sLanguage, false) === sResult ? '' : sResult;
};

LanguagesPopupView.prototype.setLanguageSelection = function()
{
	var currentLang = this.fLang ? ko.unwrap(this.fLang) : '';
	_.each(this.languages(), function(item) {
		item.selected(item.key === currentLang);
	});
};

LanguagesPopupView.prototype.onBeforeShow = function()
{
	this.fLang = null;
	this.userLanguage('');

	this.langs([]);
};

LanguagesPopupView.prototype.onShow = function(fLanguage, aLangs, sUserLanguage)
{
	this.fLang = fLanguage;
	this.userLanguage(sUserLanguage || '');

	this.langs(aLangs);
};

LanguagesPopupView.prototype.changeLanguage = function(sLang)
{
	if (this.fLang)
	{
		this.fLang(sLang);
	}

	this.cancelCommand();
};

module.exports = LanguagesPopupView;


/***/ },
/* 45 */
/*!***********************************!*\
  !*** ./dev/Common/HtmlEditor.jsx ***!
  \***********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);

/* harmony export */ __webpack_require__.d(exports, "HtmlEditor", function() { return HtmlEditor; });
/* harmony export */ __webpack_require__.d(exports, "default", function() { return HtmlEditor; });function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }







var HtmlEditor = function () {
	/**
  * @constructor
  * @param {Object} element
  * @param {Function=} onBlur
  * @param {Function=} onReady
  * @param {Function=} onModeChange
  */

	function HtmlEditor(element) {
		var onBlur = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];
		var onReady = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
		var onModeChange = arguments.length <= 3 || arguments[3] === undefined ? null : arguments[3];

		_classCallCheck(this, HtmlEditor);

		this.editor = null;
		this.blurTimer = 0;

		this.onBlur = onBlur;
		this.onReady = onReady;
		this.onModeChange = onModeChange;

		this.$element = __WEBPACK_IMPORTED_MODULE_2_____default()(element);

		this.resize = __WEBPACK_IMPORTED_MODULE_1_____default.a.throttle(__WEBPACK_IMPORTED_MODULE_1_____default.a.bind(this.resize, this), 100);

		this.__inited = false;

		this.init();
	}

	HtmlEditor.prototype.blurTrigger = function blurTrigger() {
		var _this = this;

		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(this.blurTimer);
			this.blurTimer = __WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {
				_this.onBlur();
			}, 200);
		}
	};

	HtmlEditor.prototype.focusTrigger = function focusTrigger() {
		if (this.onBlur) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.clearTimeout(this.blurTimer);
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.isHtml = function isHtml() {
		return this.editor ? 'wysiwyg' === this.editor.mode : false;
	};

	/**
  * @param {string} signature
  * @param {bool} html
  * @param {bool} insertBefore
  */


	HtmlEditor.prototype.setSignature = function setSignature(signature, html, insertBefore) {
		if (this.editor) {
			this.editor.execCommand('insertSignature', {
				isHtml: html,
				insertBefore: insertBefore,
				signature: signature
			});
		}
	};

	/**
  * @returns {boolean}
  */


	HtmlEditor.prototype.checkDirty = function checkDirty() {
		return this.editor ? this.editor.checkDirty() : false;
	};

	HtmlEditor.prototype.resetDirty = function resetDirty() {
		if (this.editor) {
			this.editor.resetDirty();
		}
	};

	/**
  * @param {string} text
  * @returns {string}
  */


	HtmlEditor.prototype.clearSignatureSigns = function clearSignatureSigns(text) {
		return text.replace(/(\u200C|\u0002)/g, '');
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @param {boolean=} clearSignatureSigns = false
  * @returns {string}
  */


	HtmlEditor.prototype.getData = function getData() {
		var wrapIsHtml = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var clearSignatureSigns = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];


		var result = '';
		if (this.editor) {
			try {
				if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
					result = this.editor.__plain.getRawData();
				} else {
					result = wrapIsHtml ? '<div data-html-editor-font-wrapper="true" style="font-family: arial, sans-serif; font-size: 13px;">' + this.editor.getData() + '</div>' : this.editor.getData();
				}
			} catch (e) {} // eslint-disable-line no-empty

			if (clearSignatureSigns) {
				result = this.clearSignatureSigns(result);
			}
		}

		return result;
	};

	/**
  * @param {boolean=} wrapIsHtml = false
  * @param {boolean=} clearSignatureSigns = false
  * @returns {string}
  */


	HtmlEditor.prototype.getDataWithHtmlMark = function getDataWithHtmlMark() {
		var wrapIsHtml = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var clearSignatureSigns = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

		return (this.isHtml() ? ':HTML:' : '') + this.getData(wrapIsHtml, clearSignatureSigns);
	};

	HtmlEditor.prototype.modeToggle = function modeToggle(plain, resize) {
		if (this.editor) {
			try {
				if (plain) {
					if ('plain' === this.editor.mode) {
						this.editor.setMode('wysiwyg');
					}
				} else {
					if ('wysiwyg' === this.editor.mode) {
						this.editor.setMode('plain');
					}
				}
			} catch (e) {} // eslint-disable-line no-empty

			if (resize) {
				this.resize();
			}
		}
	};

	HtmlEditor.prototype.setHtmlOrPlain = function setHtmlOrPlain(text, focus) {
		if (':HTML:' === text.substr(0, 6)) {
			this.setHtml(text.substr(6), focus);
		} else {
			this.setPlain(text, focus);
		}
	};

	HtmlEditor.prototype.setHtml = function setHtml(html, focus) {
		if (this.editor && this.__inited) {
			this.modeToggle(true);

			html = html.replace(/<p[^>]*><\/p>/ig, '');

			try {
				this.editor.setData(html);
			} catch (e) {} // eslint-disable-line no-empty

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.replaceHtml = function replaceHtml(find, _replaceHtml) {
		if (this.editor && this.__inited && 'wysiwyg' === this.editor.mode) {
			try {
				this.editor.setData(this.editor.getData().replace(find, _replaceHtml));
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setPlain = function setPlain(plain, focus) {
		if (this.editor && this.__inited) {
			this.modeToggle(false);
			if ('plain' === this.editor.mode && this.editor.plugins.plain && this.editor.__plain) {
				this.editor.__plain.setRawData(plain);
			} else {
				try {
					this.editor.setData(plain);
				} catch (e) {} // eslint-disable-line no-empty
			}

			if (focus) {
				this.focus();
			}
		}
	};

	HtmlEditor.prototype.init = function init() {
		var _this2 = this;

		if (this.$element && this.$element[0] && !this.editor) {
			var initFunc = function initFunc() {

				var config = __WEBPACK_IMPORTED_MODULE_3_Common_Globals__["oHtmlEditorDefaultConfig"],
				    language = __WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["settingsGet"]('Language'),
				    allowSource = !!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["appSettingsGet"]('allowHtmlEditorSourceButton'),
				    biti = !!__WEBPACK_IMPORTED_MODULE_4_Storage_Settings__["appSettingsGet"]('allowHtmlEditorBitiButtons');

				if ((allowSource || !biti) && !config.toolbarGroups.__cfgInited) {
					config.toolbarGroups.__cfgInited = true;

					if (allowSource) {
						config.removeButtons = config.removeButtons.replace(',Source', '');
					}

					if (!biti) {
						config.removePlugins += (config.removePlugins ? ',' : '') + 'bidi';
					}
				}

				config.enterMode = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.ENTER_BR;
				config.shiftEnterMode = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.ENTER_P;

				config.language = __WEBPACK_IMPORTED_MODULE_3_Common_Globals__["oHtmlEditorLangsMap"][language] || 'en';
				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.env) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.env.isCompatible = true;
				}

				_this2.editor = __WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR.appendTo(_this2.$element[0], config);

				_this2.editor.on('key', function (event) {
					if (event && event.data && 9 /* Tab */ === event.data.keyCode) {
						return false;
					}

					return true;
				});

				_this2.editor.on('blur', function () {
					_this2.blurTrigger();
				});

				_this2.editor.on('mode', function () {
					_this2.blurTrigger();
					if (_this2.onModeChange) {
						_this2.onModeChange('plain' !== _this2.editor.mode);
					}
				});

				_this2.editor.on('focus', function () {
					_this2.focusTrigger();
				});

				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader) {
					_this2.editor.on('drop', function (event) {
						if (0 < event.data.dataTransfer.getFilesCount()) {
							var file = event.data.dataTransfer.getFile(0);
							if (file && __WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader && event.data.dataTransfer.id && file.type && file.type.match(/^image/i)) {
								var id = event.data.dataTransfer.id,
								    imageId = '[img=' + id + ']',
								    reader = new __WEBPACK_IMPORTED_MODULE_0_window___default.a.FileReader();

								reader.onloadend = function () {
									if (reader.result) {
										_this2.replaceHtml(imageId, '<img src="' + reader.result + '" />');
									}
								};

								reader.readAsDataURL(file);

								event.data.dataTransfer.setData('text/html', imageId);
							}
						}
					});
				}

				_this2.editor.on('instanceReady', function () {

					if (_this2.editor.removeMenuItem) {
						_this2.editor.removeMenuItem('cut');
						_this2.editor.removeMenuItem('copy');
						_this2.editor.removeMenuItem('paste');
					}

					_this2.__resizable = true;
					_this2.__inited = true;

					_this2.resize();

					if (_this2.onReady) {
						_this2.onReady();
					}
				});
			};

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.CKEDITOR) {
				initFunc();
			} else {
				__WEBPACK_IMPORTED_MODULE_0_window___default.a.__initEditor = initFunc;
			}
		}
	};

	HtmlEditor.prototype.focus = function focus() {
		if (this.editor) {
			try {
				this.editor.focus();
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.hasFocus = function hasFocus() {
		if (this.editor) {
			try {
				return !!this.editor.focusManager.hasFocus;
			} catch (e) {} // eslint-disable-line no-empty
		}

		return false;
	};

	HtmlEditor.prototype.blur = function blur() {
		if (this.editor) {
			try {
				this.editor.focusManager.blur(true);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.resize = function resize() {
		if (this.editor && this.__resizable) {
			try {
				this.editor.resize(this.$element.width(), this.$element.innerHeight());
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.setReadOnly = function setReadOnly(value) {
		if (this.editor) {
			try {
				this.editor.setReadOnly(!!value);
			} catch (e) {} // eslint-disable-line no-empty
		}
	};

	HtmlEditor.prototype.clear = function clear(focus) {
		this.setHtml('', focus);
	};

	return HtmlEditor;
}();


module.exports = HtmlEditor;

/***/ },
/* 46 */
/*!*******************************************!*\
  !*** ./dev/Component/AbstracCheckbox.jsx ***!
  \*******************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstracCheckbox; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var AbstracCheckbox = function (_AbstractComponent) {
	_inherits(AbstracCheckbox, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params = {}
  */

	function AbstracCheckbox() {
		var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

		_classCallCheck(this, AbstracCheckbox);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.value = params.value;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.value) ? false : !!_this.value);
		}

		_this.enable = params.enable;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.enable) || !_this.enable.subscribe) {
			_this.enable = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.enable) ? true : !!_this.enable);
		}

		_this.disable = params.disable;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.disable) || !_this.disable.subscribe) {
			_this.disable = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(_this.disable) ? false : !!_this.disable);
		}

		_this.label = params.label || '';
		_this.inline = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;

		_this.readOnly = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;
		_this.inverted = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.inverted) ? false : !!params.inverted;

		_this.labeled = !__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Utils__["isUnd"])(params.label);
		_this.labelAnimated = !!params.labelAnimated;
		return _this;
	}

	AbstracCheckbox.prototype.click = function click() {
		if (!this.readOnly && this.enable() && !this.disable()) {
			this.value(!this.value());
		}
	};

	return AbstracCheckbox;
}(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 47 */,
/* 48 */
/*!************************************!*\
  !*** external "window.crossroads" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.crossroads;

/***/ },
/* 49 */
/*!************************************!*\
  !*** external "window.progressJs" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.progressJs;

/***/ },
/* 50 */
/*!***************************!*\
  !*** ./dev/bootstrap.jsx ***!
  \***************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Model_Email__ = __webpack_require__(/*! Model/Email */ 30);










/* harmony default export */ exports["a"] = function (App) {

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["data"].__APP__ = App;

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$win"].on('keydown', __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["kill_CtrlA_CtrlS"]).on('unload', function () {
		__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["data"].bUnload = true;
	});

	__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$html"].addClass(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["bMobileDevice"] ? 'mobile' : 'no-mobile').on('click.dropdown.data-api', function () {
		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["detectDropdownVisibility"])();
	});

	var rl = __WEBPACK_IMPORTED_MODULE_0_window___default.a.rl || {};

	rl.i18n = __WEBPACK_IMPORTED_MODULE_6_Common_Translator__["i18n"];
	rl.createCommand = __WEBPACK_IMPORTED_MODULE_2_Common_Utils__["createCommand"];

	rl.addSettingsViewModel = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addSettingsViewModel"];
	rl.addSettingsViewModelForAdmin = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addSettingsViewModelForAdmin"];

	rl.addHook = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["addHook"];
	rl.settingsGet = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["mainSettingsGet"];
	rl.pluginSettingsGet = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["settingsGet"];
	rl.pluginRemoteRequest = __WEBPACK_IMPORTED_MODULE_5_Common_Plugins__["remoteRequest"];

	rl.EmailModel = __WEBPACK_IMPORTED_MODULE_7_Model_Email__["EmailModel"];
	rl.Enums = __WEBPACK_IMPORTED_MODULE_4_Common_Enums__;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.rl = rl;

	__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = function (fErrorCallback) {

		__WEBPACK_IMPORTED_MODULE_1_____default()(function () {

			__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

				if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES && __WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0]) {
					__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-templates').html(__WEBPACK_IMPORTED_MODULE_0_window___default.a.rainloopTEMPLATES[0]);

					__WEBPACK_IMPORTED_MODULE_0_window___default.a.setTimeout(function () {

						__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["$html"].removeClass('no-js rl-booted-trigger').addClass('rl-booted');

						App.bootstart();
					}, 10);
				} else {
					fErrorCallback();
				}

				__WEBPACK_IMPORTED_MODULE_0_window___default.a.__APP_BOOT = null;
			}, 10);
		});
	};
};

/***/ },
/* 51 */
/*!**********************************!*\
  !*** ./dev/Stores/Admin/Capa.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function CapaAdminStore()
{
	this.additionalAccounts = ko.observable(false);
	this.identities = ko.observable(false);
	this.gravatar = ko.observable(false);
	this.attachmentThumbnails = ko.observable(false);
	this.sieve = ko.observable(false);
	this.filters = ko.observable(false);
	this.themes = ko.observable(true);
	this.userBackground = ko.observable(false);
	this.openPGP = ko.observable(false);
	this.twoFactorAuth = ko.observable(false);
	this.twoFactorAuthForce = ko.observable(false);
	this.templates = ko.observable(false);
}

CapaAdminStore.prototype.populate = function()
{
	this.additionalAccounts(Settings.capa(Enums.Capa.AdditionalAccounts));
	this.identities(Settings.capa(Enums.Capa.Identities));
	this.gravatar(Settings.capa(Enums.Capa.Gravatar));
	this.attachmentThumbnails(Settings.capa(Enums.Capa.AttachmentThumbnails));
	this.sieve(Settings.capa(Enums.Capa.Sieve));
	this.filters(Settings.capa(Enums.Capa.Filters));
	this.themes(Settings.capa(Enums.Capa.Themes));
	this.userBackground(Settings.capa(Enums.Capa.UserBackground));
	this.openPGP(Settings.capa(Enums.Capa.OpenPGP));
	this.twoFactorAuth(Settings.capa(Enums.Capa.TwoFactor));
	this.twoFactorAuthForce(Settings.capa(Enums.Capa.TwoFactorForce));
	this.templates(Settings.capa(Enums.Capa.Templates));
};

module.exports = new CapaAdminStore();


/***/ },
/* 52 */
/*!************************************!*\
  !*** ./dev/Stores/Admin/Domain.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function DomainAdminStore()
{
	this.domains = ko.observableArray([]);
	this.domains.loading = ko.observable(false).extend({'throttle': 100});

	this.domainsWithoutAliases = this.domains.filter(function(oItem) {
		return oItem && !oItem.alias;
	});
}

module.exports = new DomainAdminStore();


/***/ },
/* 53 */,
/* 54 */,
/* 55 */,
/* 56 */,
/* 57 */
/*!*********************************!*\
  !*** ./dev/External/Opentip.js ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	Opentip = window.Opentip;

Opentip.styles.rainloop = {

	'extends': 'standard',

	'fixed': true,
	'target': true,

	'delay': 0.2,
	'hideDelay': 0,

	'hideEffect': 'fade',
	'hideEffectDuration': 0.2,

	'showEffect': 'fade',
	'showEffectDuration': 0.2,

	'showOn': 'mouseover click',
	'removeElementsOnHide': true,

	'background': '#fff',
	'shadow': false,

	'borderColor': '#999',
	'borderRadius': 2,
	'borderWidth': 1
};

Opentip.styles.rainloopTip = {
	'extends': 'rainloop',
	'delay': 0.4,
	'group': 'rainloopTips'
};

Opentip.styles.rainloopErrorTip = {
	'extends': 'rainloop',
	'className': 'rainloopErrorTip'
};

module.exports = Opentip;


/***/ },
/* 58 */
/*!************************************!*\
  !*** ./dev/Remote/AbstractAjax.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	$ = __webpack_require__(/*! $ */ 10),

	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Plugins = __webpack_require__(/*! Common/Plugins */ 21),
	Links = __webpack_require__(/*! Common/Links */ 12),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
* @constructor
*/
function AbstractAjaxRemote()
{
	this.oRequests = {};
}

AbstractAjaxRemote.prototype.oRequests = {};

/**
 * @param {?Function} fCallback
 * @param {string} sRequestAction
 * @param {string} sType
 * @param {?AjaxJsonDefaultResponse} oData
 * @param {boolean} bCached
 * @param {*=} oRequestParameters
 */
AbstractAjaxRemote.prototype.defaultResponse = function(fCallback, sRequestAction, sType, oData, bCached, oRequestParameters)
{
	var
		fCall = function() {
			if (Enums.StorageResultType.Success !== sType && Globals.data.bUnload)
			{
				sType = Enums.StorageResultType.Unload;
			}

			if (Enums.StorageResultType.Success === sType && oData && !oData.Result)
			{
				if (oData && -1 < Utils.inArray(oData.ErrorCode, [
					Enums.Notification.AuthError, Enums.Notification.AccessError,
					Enums.Notification.ConnectionError, Enums.Notification.DomainNotAllowed, Enums.Notification.AccountNotAllowed,
					Enums.Notification.MailServerError,	Enums.Notification.UnknownNotification, Enums.Notification.UnknownError
				]))
				{
					Globals.data.iAjaxErrorCount += 1;
				}

				if (oData && Enums.Notification.InvalidToken === oData.ErrorCode)
				{
					Globals.data.iTokenErrorCount += 1;
				}

				if (Consts.TOKEN_ERROR_LIMIT < Globals.data.iTokenErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.loginAndLogoutReload)
					{
						Globals.data.__APP__.loginAndLogoutReload(false, true);
					}
				}

				if (oData.ClearAuth || oData.Logout || Consts.AJAX_ERROR_LIMIT < Globals.data.iAjaxErrorCount)
				{
					if (Globals.data.__APP__ && Globals.data.__APP__.clearClientSideToken)
					{
						Globals.data.__APP__.clearClientSideToken();

						if (!oData.ClearAuth && Globals.data.__APP__.loginAndLogoutReload)
						{
							Globals.data.__APP__.loginAndLogoutReload(false, true);
						}
					}
				}
			}
			else if (Enums.StorageResultType.Success === sType && oData && oData.Result)
			{
				Globals.data.iAjaxErrorCount = 0;
				Globals.data.iTokenErrorCount = 0;
			}

			if (fCallback)
			{
				Plugins.runHook('ajax-default-response', [sRequestAction, Enums.StorageResultType.Success === sType ? oData : null, sType, bCached, oRequestParameters]);

				fCallback(
					sType,
					Enums.StorageResultType.Success === sType ? oData : null,
					bCached,
					sRequestAction,
					oRequestParameters
				);
			}
		};

	switch (sType)
	{
		case 'success':
			sType = Enums.StorageResultType.Success;
			break;
		case 'abort':
			sType = Enums.StorageResultType.Abort;
			break;
		default:
			sType = Enums.StorageResultType.Error;
			break;
	}

	if (Enums.StorageResultType.Error === sType)
	{
		_.delay(fCall, 300);
	}
	else
	{
		fCall();
	}
};

/**
 * @param {?Function} fResultCallback
 * @param {Object} oParameters
 * @param {?number=} iTimeOut = 20000
 * @param {string=} sGetAdd = ''
 * @param {Array=} aAbortActions = []
 * @returns {jQuery.jqXHR}
 */
AbstractAjaxRemote.prototype.ajaxRequest = function(fResultCallback, oParameters, iTimeOut, sGetAdd, aAbortActions)
{
	var
		self = this,
		bPost = '' === sGetAdd,
		oHeaders = {},
		iStart = (new window.Date()).getTime(),
		oDefAjax = null,
		sAction = '';

	oParameters = oParameters || {};
	iTimeOut = Utils.isNormal(iTimeOut) ? iTimeOut : 20000;
	sGetAdd = Utils.isUnd(sGetAdd) ? '' : Utils.pString(sGetAdd);
	aAbortActions = Utils.isArray(aAbortActions) ? aAbortActions : [];

	sAction = oParameters.Action || '';

	if (sAction && 0 < aAbortActions.length)
	{
		_.each(aAbortActions, function(sActionToAbort) {
			if (self.oRequests[sActionToAbort])
			{
				self.oRequests[sActionToAbort].__aborted = true;
				if (self.oRequests[sActionToAbort].abort)
				{
					self.oRequests[sActionToAbort].abort();
				}
				self.oRequests[sActionToAbort] = null;
			}
		});
	}

	if (bPost)
	{
		oParameters.XToken = Settings.appSettingsGet('token');
	}

	oDefAjax = $.ajax({
		type: bPost ? 'POST' : 'GET',
		url: Links.ajax(sGetAdd),
		async: true,
		dataType: 'json',
		data: bPost ? oParameters : {},
		headers: oHeaders,
		timeout: iTimeOut,
		global: true
	});

	oDefAjax.always(function(oData, sType) {

		var bCached = false;
		if (oData && oData.Time)
		{
			bCached = Utils.pInt(oData.Time) > (new window.Date()).getTime() - iStart;
		}

		if (sAction && self.oRequests[sAction])
		{
			if (self.oRequests[sAction].__aborted)
			{
				sType = 'abort';
			}

			self.oRequests[sAction] = null;
		}

		self.defaultResponse(fResultCallback, sAction, sType, oData, bCached, oParameters);
	});

	if (sAction && 0 < aAbortActions.length && -1 < Utils.inArray(sAction, aAbortActions))
	{
		if (this.oRequests[sAction])
		{
			this.oRequests[sAction].__aborted = true;
			if (this.oRequests[sAction].abort)
			{
				this.oRequests[sAction].abort();
			}
			this.oRequests[sAction] = null;
		}

		this.oRequests[sAction] = oDefAjax;
	}

	return oDefAjax;
};

/**
 * @param {?Function} fCallback
 * @param {string} sAction
 * @param {Object=} oParameters
 * @param {?number=} iTimeout
 * @param {string=} sGetAdd = ''
 * @param {Array=} aAbortActions = []
 */
AbstractAjaxRemote.prototype.defaultRequest = function(fCallback, sAction, oParameters, iTimeout, sGetAdd, aAbortActions)
{
	oParameters = oParameters || {};
	oParameters.Action = sAction;

	sGetAdd = Utils.pString(sGetAdd);

	Plugins.runHook('ajax-default-request', [sAction, oParameters, sGetAdd]);

	return this.ajaxRequest(fCallback, oParameters,
		Utils.isUnd(iTimeout) ? Consts.DEFAULT_AJAX_TIMEOUT : Utils.pInt(iTimeout), sGetAdd, aAbortActions);
};

/**
 * @param {?Function} fCallback
 */
AbstractAjaxRemote.prototype.noop = function(fCallback)
{
	this.defaultRequest(fCallback, 'Noop');
};

/**
 * @param {?Function} fCallback
 * @param {string} sMessage
 * @param {string} sFileName
 * @param {number} iLineNo
 * @param {string} sLocation
 * @param {string} sHtmlCapa
 * @param {number} iTime
 */
AbstractAjaxRemote.prototype.jsError = function(fCallback, sMessage, sFileName, iLineNo, sLocation, sHtmlCapa, iTime)
{
	this.defaultRequest(fCallback, 'JsError', {
		'Message': sMessage,
		'FileName': sFileName,
		'LineNo': iLineNo,
		'Location': sLocation,
		'HtmlCapa': sHtmlCapa,
		'TimeOnPage': iTime
	});
};

/**
 * @param {?Function} fCallback
 * @param {string} sType
 * @param {Array=} mData = null
 * @param {boolean=} bIsError = false
 */
AbstractAjaxRemote.prototype.jsInfo = function(fCallback, sType, mData, bIsError)
{
	this.defaultRequest(fCallback, 'JsInfo', {
		'Type': sType,
		'Data': mData,
		'IsError': (Utils.isUnd(bIsError) ? false : !!bIsError) ? '1' : '0'
	});
};

/**
 * @param {?Function} fCallback
 */
AbstractAjaxRemote.prototype.getPublicKey = function(fCallback)
{
	this.defaultRequest(fCallback, 'GetPublicKey');
};

/**
 * @param {?Function} fCallback
 * @param {string} sVersion
 */
AbstractAjaxRemote.prototype.jsVersion = function(fCallback, sVersion)
{
	this.defaultRequest(fCallback, 'Version', {
		'Version': sVersion
	});
};

module.exports = AbstractAjaxRemote;


/***/ },
/* 59 */
/*!*************************************!*\
  !*** ./dev/Stores/Admin/License.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function LicenseAdminStore()
{
	this.licensing = ko.observable(false);
	this.licensingProcess = ko.observable(false);
	this.licenseValid = ko.observable(false);
	this.licenseExpired = ko.observable(0);
	this.licenseError = ko.observable('');

	this.licenseTrigger = ko.observable(false);
}

module.exports = new LicenseAdminStore();


/***/ },
/* 60 */
/*!*************************************!*\
  !*** ./dev/Stores/Admin/Package.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function PackageAdminStore()
{
	this.packages = ko.observableArray([]);
	this.packages.loading = ko.observable(false).extend({'throttle': 100});

	this.packagesReal = ko.observable(true);
	this.packagesMainUpdatable = ko.observable(true);
}

module.exports = new PackageAdminStore();


/***/ },
/* 61 */
/*!************************************!*\
  !*** ./dev/Stores/Admin/Plugin.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function PluginAdminStore()
{
	this.plugins = ko.observableArray([]);
	this.plugins.loading = ko.observable(false).extend({'throttle': 100});
	this.plugins.error = ko.observable('');
}

module.exports = new PluginAdminStore();


/***/ },
/* 62 */,
/* 63 */,
/* 64 */,
/* 65 */,
/* 66 */
/*!******************************!*\
  !*** ./dev/App/Abstract.jsx ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window__ = __webpack_require__(/*! window */ 9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_window___default = __WEBPACK_IMPORTED_MODULE_0_window__ && __WEBPACK_IMPORTED_MODULE_0_window__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_window__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_window__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_window___default, 'a', __WEBPACK_IMPORTED_MODULE_0_window___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_____default = __WEBPACK_IMPORTED_MODULE_2____ && __WEBPACK_IMPORTED_MODULE_2____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_____default, 'a', __WEBPACK_IMPORTED_MODULE_2_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key__ = __webpack_require__(/*! key */ 16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_key___default = __WEBPACK_IMPORTED_MODULE_3_key__ && __WEBPACK_IMPORTED_MODULE_3_key__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_3_key__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_3_key__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_3_key___default, 'a', __WEBPACK_IMPORTED_MODULE_3_key___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_Common_Events__ = __webpack_require__(/*! Common/Events */ 23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_Common_Cmd__ = __webpack_require__(/*! Common/Cmd */ 68);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractBoot__ = __webpack_require__(/*! Knoin/AbstractBoot */ 79);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractApp; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




















var AbstractApp = function (_AbstractBoot) {
	_inherits(AbstractApp, _AbstractBoot);

	/**
  * @param {RemoteStorage|AdminRemoteStorage} Remote
  */

	function AbstractApp(Remote) {
		_classCallCheck(this, AbstractApp);

		var _this = _possibleConstructorReturn(this, _AbstractBoot.call(this));

		_this.googlePreviewSupportedCache = null;
		_this.isLocalAutocomplete = true;
		_this.iframe = null;
		_this.lastErrorTime = 0;

		_this.iframe = __WEBPACK_IMPORTED_MODULE_1_____default()('<iframe class="internal-hiddden" />').appendTo('body');

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].on('error', function (event) {
			if (event && event.originalEvent && event.originalEvent.message && -1 === __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["inArray"])(event.originalEvent.message, ['Script error.', 'Uncaught Error: Error calling method on NPObject.'])) {
				var time = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["timestamp"])();
				if (_this.lastErrorTime >= time) {
					return;
				}

				_this.lastErrorTime = time;

				Remote.jsError(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["noop"], event.originalEvent.message, event.originalEvent.filename, event.originalEvent.lineno, __WEBPACK_IMPORTED_MODULE_0_window___default.a.location && __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.toString ? __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.toString() : '', __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].attr('class'), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["microtime"])() - __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["startMicrotime"]);
			}
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].on('resize', function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('window.resize');
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('window.resize', __WEBPACK_IMPORTED_MODULE_2_____default.a.throttle(function () {
			var iH = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].height(),
			    iW = __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].height();

			if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[0] !== iH || __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[1] !== iW) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[0] = iH;
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$win"].__sizes[1] = iW;

				__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('window.resize.real');
			}
		}, 50));

		// DEBUG
		//		Events.sub({
		//			'window.resize': function() {
		//				window.console.log('window.resize');
		//			},
		//			'window.resize.real': function() {
		//				window.console.log('window.resize.real');
		//			}
		//		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$doc"].on('keydown', function (event) {
			if (event && event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('rl-ctrl-key-pressed');
			}
		}).on('keyup', function (event) {
			if (event && !event.ctrlKey) {
				__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('rl-ctrl-key-pressed');
			}
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$doc"].on('mousemove keypress click', __WEBPACK_IMPORTED_MODULE_2_____default.a.debounce(function () {
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('rl.auto-logout-refresh');
		}, 5000));

		__WEBPACK_IMPORTED_MODULE_3_key___default()('esc, enter', __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["KeyState"].All, function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["detectDropdownVisibility"])();
		});

		__WEBPACK_IMPORTED_MODULE_3_key___default()('ctrl+shift+`', __WEBPACK_IMPORTED_MODULE_6_Common_Enums__["KeyState"].All, function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_11_Common_Cmd__["a" /* toggle */])();
		});
		return _this;
	}

	AbstractApp.prototype.remote = function remote() {
		return null;
	};

	AbstractApp.prototype.data = function data() {
		return null;
	};

	AbstractApp.prototype.getApplicationConfiguration = function getApplicationConfiguration(name, default_) {
		return this.applicationConfiguration[name] || default_;
	};

	/**
  * @param {string} link
  * @returns {boolean}
  */


	AbstractApp.prototype.download = function download(link) {

		if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"] && (-1 < __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"].indexOf('chrome') || -1 < __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["sUserAgent"].indexOf('chrome'))) {
			var oLink = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createElement('a');
			oLink.href = link;

			if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.document && __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createEvent) {
				var oE = __WEBPACK_IMPORTED_MODULE_0_window___default.a.document.createEvent.MouseEvents;
				if (oE && oE.initEvent && oLink.dispatchEvent) {
					oE.initEvent('click', true, true);
					oLink.dispatchEvent(oE);
					return true;
				}
			}
		}

		if (__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bMobileDevice"]) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.open(link, '_self');
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.focus();
		} else {
			this.iframe.attr('src', link);
			//		window.document.location.href = link;
		}

		return true;
	};

	/**
  * @returns {boolean}
  */


	AbstractApp.prototype.googlePreviewSupported = function googlePreviewSupported() {
		if (null === this.googlePreviewSupportedCache) {
			this.googlePreviewSupportedCache = !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AllowGoogleSocial') && !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('AllowGoogleSocialPreview');
		}

		return this.googlePreviewSupportedCache;
	};

	/**
  * @param {string} title
  */


	AbstractApp.prototype.setWindowTitle = function setWindowTitle(title) {
		title = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["isNormal"])(title) && 0 < title.length ? '' + title : '';
		if (__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Title')) {
			title += (title ? ' - ' : '') + __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["settingsGet"]('Title');
		}

		__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.title = title + ' ...';
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.document.title = title;
	};

	AbstractApp.prototype.redirectToAdminPanel = function redirectToAdminPanel() {
		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootAdmin"]();
		}, 100);
	};

	AbstractApp.prototype.clearClientSideToken = function clearClientSideToken() {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_clear) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_clear();
		}
	};

	/**
  * @param {string} token
  */


	AbstractApp.prototype.setClientSideToken = function setClientSideToken(token) {
		if (__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_set) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.__rlah_set(token);

			__webpack_require__(/*! Storage/Settings */ 7).settingsSet('AuthAccountHash', token);
			__webpack_require__(/*! Common/Links */ 12).populateAuthSuffix();
		}
	};

	/**
  * @param {boolean=} admin = false
  * @param {boolean=} logout = false
  * @param {boolean=} close = false
  */


	AbstractApp.prototype.loginAndLogoutReload = function loginAndLogoutReload() {
		var admin = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];
		var logout = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
		var close = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];


		var mobile = __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('mobile'),
		    inIframe = !!__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('inIframe');

		var customLogoutLink = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["pString"])(__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('customLogoutLink'));

		if (logout) {
			this.clearClientSideToken();
		}

		if (logout && close && __WEBPACK_IMPORTED_MODULE_0_window___default.a.close) {
			__WEBPACK_IMPORTED_MODULE_0_window___default.a.close();
		}

		customLogoutLink = customLogoutLink || (admin ? __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootAdmin"](mobile) : __WEBPACK_IMPORTED_MODULE_7_Common_Links__["rootUser"](mobile));

		if (logout && __WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href !== customLogoutLink) {
			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				if (inIframe && __WEBPACK_IMPORTED_MODULE_0_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent.location.href = customLogoutLink;
				} else {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.href = customLogoutLink;
				}
			}, 100);
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["routeOff"])();
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["setHash"])(__WEBPACK_IMPORTED_MODULE_7_Common_Links__["root"](), true);
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_12_Knoin_Knoin__["routeOff"])();

			__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(function () {
				if (inIframe && __WEBPACK_IMPORTED_MODULE_0_window___default.a.parent) {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.parent.location.reload();
				} else {
					__WEBPACK_IMPORTED_MODULE_0_window___default.a.location.reload();
				}
			}, 100);
		}
	};

	AbstractApp.prototype.historyBack = function historyBack() {
		__WEBPACK_IMPORTED_MODULE_0_window___default.a.history.back();
	};

	AbstractApp.prototype.bootstart = function bootstart() {

		// log('Ps' + 'ss, hac' + 'kers! The' + 're\'s not' + 'hing inte' + 'resting :' + ')');

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('rl.bootstart');

		var mobile = __WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('mobile'),
		    ssm = __webpack_require__(/*! ssm */ 88),
		    ko = __webpack_require__(/*! ko */ 1);

		ko.components.register('SaveTrigger', __webpack_require__(/*! Component/SaveTrigger */ 75));
		ko.components.register('Input', __webpack_require__(/*! Component/Input */ 72));
		ko.components.register('Select', __webpack_require__(/*! Component/Select */ 77));
		ko.components.register('Radio', __webpack_require__(/*! Component/Radio */ 74));
		ko.components.register('TextArea', __webpack_require__(/*! Component/TextArea */ 78));
		ko.components.register('Date', __webpack_require__(/*! Component/Date */ 71));

		ko.components.register('x-script', __webpack_require__(/*! Component/Script */ 76));
		//		ko.components.register('svg-icon', require('Component/SvgIcon'));

		if (__WEBPACK_IMPORTED_MODULE_8_Storage_Settings__["appSettingsGet"]('materialDesign') && __WEBPACK_IMPORTED_MODULE_4_Common_Globals__["bAnimationSupported"]) {
			ko.components.register('Checkbox', __webpack_require__(/*! Component/MaterialDesign/Checkbox */ 73));
			ko.components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 36));
		} else {
			//			ko.components.register('Checkbox', require('Component/Classic/Checkbox'));
			//			ko.components.register('CheckboxSimple', require('Component/Classic/Checkbox'));
			ko.components.register('Checkbox', __webpack_require__(/*! Component/Checkbox */ 36));
			ko.components.register('CheckboxSimple', __webpack_require__(/*! Component/Checkbox */ 36));
		}

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["initOnStartOrLangChange"])(__WEBPACK_IMPORTED_MODULE_10_Common_Translator__["initNotificationLanguage"]);

		__WEBPACK_IMPORTED_MODULE_2_____default.a.delay(__WEBPACK_IMPORTED_MODULE_5_Common_Utils__["windowResizeCallback"], 1000);

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('ssm.mobile-enter', function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"])(true);
		});

		__WEBPACK_IMPORTED_MODULE_9_Common_Events__["sub"]('ssm.mobile-leave', function () {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"])(false);
		});

		if (!mobile) {
			ssm.addState({
				id: 'mobile',
				maxWidth: 767,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-enter');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-mobile');
					__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-leave');
				}
			});

			ssm.addState({
				id: 'tablet',
				minWidth: 768,
				maxWidth: 999,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-tablet');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-tablet');
				}
			});

			ssm.addState({
				id: 'desktop',
				minWidth: 1000,
				maxWidth: 1400,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-desktop');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-desktop');
				}
			});

			ssm.addState({
				id: 'desktop-large',
				minWidth: 1400,
				onEnter: function onEnter() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-desktop-large');
				},
				onLeave: function onLeave() {
					__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].removeClass('ssm-state-desktop-large');
				}
			});
		} else {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].addClass('ssm-state-mobile').addClass('rl-mobile');
			__WEBPACK_IMPORTED_MODULE_9_Common_Events__["pub"]('ssm.mobile-enter');
		}

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"].subscribe(function (bValue) {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-disabled', bValue);
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-enabled', !bValue);
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelType"].subscribe(function (sValue) {
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-none', 'none' === sValue);
			__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["$html"].toggleClass('rl-left-panel-short', 'short' === sValue);
		});

		__WEBPACK_IMPORTED_MODULE_4_Common_Globals__["leftPanelDisabled"].valueHasMutated();

		ssm.ready();

		__webpack_require__(/*! Stores/Language */ 38).populate();
		__webpack_require__(/*! Stores/Theme */ 43).populate();
		__webpack_require__(/*! Stores/Social */ 34).populate();
	};

	return AbstractApp;
}(__WEBPACK_IMPORTED_MODULE_13_Knoin_AbstractBoot__["a" /* AbstractBoot */]);



/***/ },
/* 67 */,
/* 68 */
/*!****************************!*\
  !*** ./dev/Common/Cmd.jsx ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony export */ exports["a"] = toggle;
// import window from 'window';




var opened = false,
    cmdDom = null;

/**
 * @returns {void}
 */
function init() {
	if (null === cmdDom) {
		cmdDom = __WEBPACK_IMPORTED_MODULE_0_____default()('<div class="rl-cmd"></div>');
		cmdDom.appendTo(__WEBPACK_IMPORTED_MODULE_2_Common_Globals__["$body"]);
	}
}

/**
 * @returns {void}
 */
function toggle() {
	init();

	opened = !opened;

	__WEBPACK_IMPORTED_MODULE_1_____default.a.delay(function () {
		cmdDom.toggleClass('opened', opened);
	}, 50);
}

/***/ },
/* 69 */
/*!*****************************!*\
  !*** ./dev/Common/Mime.jsx ***!
  \*****************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "a", function() { return Mime; });/* unused harmony export default */
/* eslint key-spacing: 0 */
/* eslint quote-props: 0 */

var Mime = {
	'eml': 'message/rfc822',
	'mime': 'message/rfc822',
	'txt': 'text/plain',
	'text': 'text/plain',
	'def': 'text/plain',
	'list': 'text/plain',
	'in': 'text/plain',
	'ini': 'text/plain',
	'log': 'text/plain',
	'sql': 'text/plain',
	'cfg': 'text/plain',
	'conf': 'text/plain',
	'asc': 'text/plain',
	'rtx': 'text/richtext',
	'vcard': 'text/vcard',
	'vcf': 'text/vcard',
	'htm': 'text/html',
	'html': 'text/html',
	'csv': 'text/csv',
	'ics': 'text/calendar',
	'ifb': 'text/calendar',
	'xml': 'text/xml',
	'json': 'application/json',
	'swf': 'application/x-shockwave-flash',
	'hlp': 'application/winhlp',
	'wgt': 'application/widget',
	'chm': 'application/vnd.ms-htmlhelp',
	'p10': 'application/pkcs10',
	'p7c': 'application/pkcs7-mime',
	'p7m': 'application/pkcs7-mime',
	'p7s': 'application/pkcs7-signature',
	'torrent': 'application/x-bittorrent',

	// scripts
	'js': 'application/javascript',
	'pl': 'text/perl',
	'css': 'text/css',
	'asp': 'text/asp',
	'php': 'application/x-httpd-php',
	'php3': 'application/x-httpd-php',
	'php4': 'application/x-httpd-php',
	'php5': 'application/x-httpd-php',
	'phtml': 'application/x-httpd-php',

	// images
	'png': 'image/png',
	'jpg': 'image/jpeg',
	'jpeg': 'image/jpeg',
	'jpe': 'image/jpeg',
	'jfif': 'image/jpeg',
	'gif': 'image/gif',
	'bmp': 'image/bmp',
	'cgm': 'image/cgm',
	'ief': 'image/ief',
	'ico': 'image/x-icon',
	'tif': 'image/tiff',
	'tiff': 'image/tiff',
	'svg': 'image/svg+xml',
	'svgz': 'image/svg+xml',
	'djv': 'image/vnd.djvu',
	'djvu': 'image/vnd.djvu',
	'webp': 'image/webp',

	// archives
	'zip': 'application/zip',
	'7z': 'application/x-7z-compressed',
	'rar': 'application/x-rar-compressed',
	'exe': 'application/x-msdownload',
	'dll': 'application/x-msdownload',
	'scr': 'application/x-msdownload',
	'com': 'application/x-msdownload',
	'bat': 'application/x-msdownload',
	'msi': 'application/x-msdownload',
	'cab': 'application/vnd.ms-cab-compressed',
	'gz': 'application/x-gzip',
	'tgz': 'application/x-gzip',
	'bz': 'application/x-bzip',
	'bz2': 'application/x-bzip2',
	'deb': 'application/x-debian-package',

	// fonts
	'psf': 'application/x-font-linux-psf',
	'otf': 'application/x-font-otf',
	'pcf': 'application/x-font-pcf',
	'snf': 'application/x-font-snf',
	'ttf': 'application/x-font-ttf',
	'ttc': 'application/x-font-ttf',

	// audio
	'mp3': 'audio/mpeg',
	'amr': 'audio/amr',
	'aac': 'audio/x-aac',
	'aif': 'audio/x-aiff',
	'aifc': 'audio/x-aiff',
	'aiff': 'audio/x-aiff',
	'wav': 'audio/x-wav',
	'wma': 'audio/x-ms-wma',
	'wax': 'audio/x-ms-wax',
	'midi': 'audio/midi',
	'mp4a': 'audio/mp4',
	'ogg': 'audio/ogg',
	'weba': 'audio/webm',
	'ra': 'audio/x-pn-realaudio',
	'ram': 'audio/x-pn-realaudio',
	'rmp': 'audio/x-pn-realaudio-plugin',
	'm3u': 'audio/x-mpegurl',

	// video
	'flv': 'video/x-flv',
	'qt': 'video/quicktime',
	'mov': 'video/quicktime',
	'wmv': 'video/windows-media',
	'avi': 'video/x-msvideo',
	'mpg': 'video/mpeg',
	'mpeg': 'video/mpeg',
	'mpe': 'video/mpeg',
	'm1v': 'video/mpeg',
	'm2v': 'video/mpeg',
	'3gp': 'video/3gpp',
	'3g2': 'video/3gpp2',
	'h261': 'video/h261',
	'h263': 'video/h263',
	'h264': 'video/h264',
	'jpgv': 'video/jpgv',
	'mp4': 'video/mp4',
	'mp4v': 'video/mp4',
	'mpg4': 'video/mp4',
	'ogv': 'video/ogg',
	'webm': 'video/webm',
	'm4v': 'video/x-m4v',
	'asf': 'video/x-ms-asf',
	'asx': 'video/x-ms-asf',
	'wm': 'video/x-ms-wm',
	'wmx': 'video/x-ms-wmx',
	'wvx': 'video/x-ms-wvx',
	'movie': 'video/x-sgi-movie',

	// adobe
	'pdf': 'application/pdf',
	'psd': 'image/vnd.adobe.photoshop',
	'ai': 'application/postscript',
	'eps': 'application/postscript',
	'ps': 'application/postscript',

	// ms office
	'doc': 'application/msword',
	'dot': 'application/msword',
	'rtf': 'application/rtf',
	'xls': 'application/vnd.ms-excel',
	'ppt': 'application/vnd.ms-powerpoint',
	'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'dotx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',

	// open office
	'odt': 'application/vnd.oasis.opendocument.text',
	'ods': 'application/vnd.oasis.opendocument.spreadsheet'
};



/***/ },
/* 70 */
/*!****************************************!*\
  !*** ./dev/Component/AbstracRadio.jsx ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstracRadio; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AbstracRadio = function (_AbstractComponent) {
	_inherits(AbstracRadio, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function AbstracRadio(params) {
		_classCallCheck(this, AbstracRadio);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.values = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observableArray([]);

		_this.value = params.value;
		if (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(_this.value) || !_this.value.subscribe) {
			_this.value = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable('');
		}

		_this.inline = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.inline) ? false : params.inline;
		_this.readOnly = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Common_Utils__["isUnd"])(params.readOnly) ? false : !!params.readOnly;

		if (params.values) {
			_this.values(__WEBPACK_IMPORTED_MODULE_0_____default.a.map(params.values, function (label, value) {
				return { label: label, value: value };
			}));
		}

		_this.click = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.click, _this);
		return _this;
	}

	AbstracRadio.prototype.click = function click(value) {
		if (!this.readOnly && value) {
			this.value(value.value);
		}
	};

	return AbstracRadio;
}(__WEBPACK_IMPORTED_MODULE_3_Component_Abstract__["a" /* AbstractComponent */]);



/***/ },
/* 71 */
/*!********************************!*\
  !*** ./dev/Component/Date.jsx ***!
  \********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var DateComponent = function (_AbstractInput) {
  _inherits(DateComponent, _AbstractInput);

  function DateComponent() {
    _classCallCheck(this, DateComponent);

    return _possibleConstructorReturn(this, _AbstractInput.apply(this, arguments));
  }

  return DateComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(DateComponent, 'DateComponent');

/***/ },
/* 72 */
/*!*********************************!*\
  !*** ./dev/Component/Input.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var InputComponent = function (_AbstractInput) {
  _inherits(InputComponent, _AbstractInput);

  function InputComponent() {
    _classCallCheck(this, InputComponent);

    return _possibleConstructorReturn(this, _AbstractInput.apply(this, arguments));
  }

  return InputComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(InputComponent, 'InputComponent');

/***/ },
/* 73 */
/*!***************************************************!*\
  !*** ./dev/Component/MaterialDesign/Checkbox.jsx ***!
  \***************************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ko___default = __WEBPACK_IMPORTED_MODULE_1_ko__ && __WEBPACK_IMPORTED_MODULE_1_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_1_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_AbstracCheckbox__ = __webpack_require__(/*! Component/AbstracCheckbox */ 46);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var CheckboxMaterialDesignComponent = function (_AbstracCheckbox) {
	_inherits(CheckboxMaterialDesignComponent, _AbstracCheckbox);

	/**
  * @constructor
  * @param {Object} params
  */

	function CheckboxMaterialDesignComponent(params) {
		_classCallCheck(this, CheckboxMaterialDesignComponent);

		var _this = _possibleConstructorReturn(this, _AbstracCheckbox.call(this, params));

		_this.animationBox = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ falseTimeout: 200 });
		_this.animationCheckmark = __WEBPACK_IMPORTED_MODULE_1_ko___default.a.observable(false).extend({ falseTimeout: 200 });

		_this.animationBoxSetTrue = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.animationBoxSetTrue, _this);
		_this.animationCheckmarkSetTrue = __WEBPACK_IMPORTED_MODULE_0_____default.a.bind(_this.animationCheckmarkSetTrue, _this);

		_this.disposable.push(_this.value.subscribe(function (value) {
			_this.triggerAnimation(value);
		}, _this));
		return _this;
	}

	CheckboxMaterialDesignComponent.prototype.animationBoxSetTrue = function animationBoxSetTrue() {
		this.animationBox(true);
	};

	CheckboxMaterialDesignComponent.prototype.animationCheckmarkSetTrue = function animationCheckmarkSetTrue() {
		this.animationCheckmark(true);
	};

	CheckboxMaterialDesignComponent.prototype.triggerAnimation = function triggerAnimation(box) {
		if (box) {
			this.animationBoxSetTrue();
			__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(this.animationCheckmarkSetTrue, 200);
		} else {
			this.animationCheckmarkSetTrue();
			__WEBPACK_IMPORTED_MODULE_0_____default.a.delay(this.animationBoxSetTrue, 200);
		}
	};

	return CheckboxMaterialDesignComponent;
}(__WEBPACK_IMPORTED_MODULE_3_Component_AbstracCheckbox__["a" /* AbstracCheckbox */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(CheckboxMaterialDesignComponent, 'CheckboxMaterialDesignComponent');

/***/ },
/* 74 */
/*!*********************************!*\
  !*** ./dev/Component/Radio.jsx ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_AbstracRadio__ = __webpack_require__(/*! Component/AbstracRadio */ 70);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var RadioComponent = function (_AbstracRadio) {
  _inherits(RadioComponent, _AbstracRadio);

  function RadioComponent() {
    _classCallCheck(this, RadioComponent);

    return _possibleConstructorReturn(this, _AbstracRadio.apply(this, arguments));
  }

  return RadioComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_AbstracRadio__["a" /* AbstracRadio */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Component_Abstract__["b" /* componentExportHelper */])(RadioComponent, 'RadioComponent');

/***/ },
/* 75 */
/*!***************************************!*\
  !*** ./dev/Component/SaveTrigger.jsx ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Enums__ = __webpack_require__(/*! Common/Enums */ 3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var SaveTriggerComponent = function (_AbstractComponent) {
	_inherits(SaveTriggerComponent, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function SaveTriggerComponent(params) {
		_classCallCheck(this, SaveTriggerComponent);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		_this.element = params.element || null;
		_this.value = params.value && params.value.subscribe ? params.value : null;

		if (_this.element) {
			if (_this.value) {
				_this.element.css('display', 'inline-block');

				if (params.verticalAlign) {
					_this.element.css('vertical-align', params.verticalAlign);
				}

				_this.setState(_this.value());

				_this.disposable.push(_this.value.subscribe(_this.setState, _this));
			} else {
				_this.element.hide();
			}
		}
		return _this;
	}

	SaveTriggerComponent.prototype.setState = function setState(value) {

		switch (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["pInt"])(value)) {
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].TrueResult:
				this.element.find('.animated,.error').hide().removeClass('visible').end().find('.success').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].FalseResult:
				this.element.find('.animated,.success').hide().removeClass('visible').end().find('.error').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].Animate:
				this.element.find('.error,.success').hide().removeClass('visible').end().find('.animated').show().addClass('visible');
				break;
			case __WEBPACK_IMPORTED_MODULE_1_Common_Enums__["SaveSettingsStep"].Idle:
			default:
				this.element.find('.animated').hide().end().find('.error,.success').removeClass('visible');
				break;
		}
	};

	return SaveTriggerComponent;
}(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["a" /* AbstractComponent */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(SaveTriggerComponent, 'SaveTriggerComponent');

/***/ },
/* 76 */
/*!**********************************!*\
  !*** ./dev/Component/Script.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var ScriptComponent = function (_AbstractComponent) {
	_inherits(ScriptComponent, _AbstractComponent);

	/**
  * @constructor
  * @param {Object} params
  */

	function ScriptComponent(params) {
		_classCallCheck(this, ScriptComponent);

		var _this = _possibleConstructorReturn(this, _AbstractComponent.call(this));

		if (params.component && params.component.templateNodes && params.element && params.element[0] && params.element[0].outerHTML) {
			var script = params.element[0].outerHTML;
			script = !script ? '' : script.replace(/<x-script/i, '<script').replace(/<b><\/b><\/x-script>/i, '</script>');

			if (script) {
				params.element.text('');
				params.element.replaceWith(__WEBPACK_IMPORTED_MODULE_0_____default()(script).text(params.component.templateNodes[0] && params.component.templateNodes[0].nodeValue ? params.component.templateNodes[0].nodeValue : ''));
			} else {
				params.element.remove();
			}
		}
		return _this;
	}

	return ScriptComponent;
}(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["a" /* AbstractComponent */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["b" /* componentExportHelper */])(ScriptComponent, 'ScriptComponent');

/***/ },
/* 77 */
/*!**********************************!*\
  !*** ./dev/Component/Select.jsx ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Translator__ = __webpack_require__(/*! Common/Translator */ 6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var SelectComponent = function (_AbstractInput) {
	_inherits(SelectComponent, _AbstractInput);

	/**
  * @constructor
  * @param {Object} params
  */

	function SelectComponent(params) {
		_classCallCheck(this, SelectComponent);

		var _this = _possibleConstructorReturn(this, _AbstractInput.call(this, params));

		_this.options = params.options || '';

		_this.optionsText = params.optionsText || null;
		_this.optionsValue = params.optionsValue || null;
		_this.optionsCaption = params.optionsCaption || null;

		if (_this.optionsCaption) {
			_this.optionsCaption = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Translator__["i18n"])(_this.optionsCaption);
		}

		_this.defautOptionsAfterRender = __WEBPACK_IMPORTED_MODULE_1_Common_Utils__["defautOptionsAfterRender"];
		return _this;
	}

	return SelectComponent;
}(__WEBPACK_IMPORTED_MODULE_3_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_Component_Abstract__["b" /* componentExportHelper */])(SelectComponent, 'SelectComponent');

/***/ },
/* 78 */
/*!************************************!*\
  !*** ./dev/Component/TextArea.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Component_Abstract__ = __webpack_require__(/*! Component/Abstract */ 13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Component_AbstractInput__ = __webpack_require__(/*! Component/AbstractInput */ 32);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var DEFAULT_ROWS = 5;

var TextAreaComponent = function (_AbstractInput) {
	_inherits(TextAreaComponent, _AbstractInput);

	/**
  * @constructor
  * @param {Object} params
  */

	function TextAreaComponent(params) {
		_classCallCheck(this, TextAreaComponent);

		var _this = _possibleConstructorReturn(this, _AbstractInput.call(this, params));

		_this.rows = params.rows || DEFAULT_ROWS;
		_this.spellcheck = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Common_Utils__["isUnd"])(params.spellcheck) ? false : !!params.spellcheck;
		return _this;
	}

	return TextAreaComponent;
}(__WEBPACK_IMPORTED_MODULE_2_Component_AbstractInput__["a" /* AbstractInput */]);

module.exports = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Component_Abstract__["b" /* componentExportHelper */])(TextAreaComponent, 'TextAreaComponent');

/***/ },
/* 79 */
/*!************************************!*\
  !*** ./dev/Knoin/AbstractBoot.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractBoot; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var AbstractBoot = function () {
	function AbstractBoot() {
		_classCallCheck(this, AbstractBoot);
	}

	AbstractBoot.prototype.bootstart = function bootstart() {/* no-empty */};

	return AbstractBoot;
}();



/***/ },
/* 80 */
/*!*****************************************!*\
  !*** ./dev/Screen/AbstractSettings.jsx ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0____ = __webpack_require__(/*! _ */ 2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_____default = __WEBPACK_IMPORTED_MODULE_0____ && __WEBPACK_IMPORTED_MODULE_0____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_____default, 'a', __WEBPACK_IMPORTED_MODULE_0_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1____ = __webpack_require__(/*! $ */ 10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_____default = __WEBPACK_IMPORTED_MODULE_1____ && __WEBPACK_IMPORTED_MODULE_1____.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1____['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1____; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_1_____default, 'a', __WEBPACK_IMPORTED_MODULE_1_____default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ko___default = __WEBPACK_IMPORTED_MODULE_2_ko__ && __WEBPACK_IMPORTED_MODULE_2_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_2_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_2_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_Common_Utils__ = __webpack_require__(/*! Common/Utils */ 0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_Common_Links__ = __webpack_require__(/*! Common/Links */ 12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractScreen__ = __webpack_require__(/*! Knoin/AbstractScreen */ 40);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractSettingsScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var AbstractSettingsScreen = function (_AbstractScreen) {
	_inherits(AbstractSettingsScreen, _AbstractScreen);

	/**
  * @param {Array} viewModels
  */

	function AbstractSettingsScreen(viewModels) {
		_classCallCheck(this, AbstractSettingsScreen);

		var _this = _possibleConstructorReturn(this, _AbstractScreen.call(this, 'settings', viewModels));

		_this.menu = __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observableArray([]);

		_this.oCurrentSubScreen = null;
		_this.oViewModelPlace = null;

		_this.setupSettings();
		return _this;
	}

	/**
  * @param {Function=} fCallback
  */


	AbstractSettingsScreen.prototype.setupSettings = function setupSettings() {
		var fCallback = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];

		if (fCallback) {
			fCallback();
		}
	};

	AbstractSettingsScreen.prototype.onRoute = function onRoute(sSubName) {
		var self = this,
		    oSettingsScreen = null,
		    RoutedSettingsViewModel = null,
		    oViewModelPlace = null,
		    oViewModelDom = null;

		RoutedSettingsViewModel = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && sSubName === SettingsViewModel.__rlSettingsData.Route;
		});

		if (RoutedSettingsViewModel) {
			if (__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-removed'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}

			if (RoutedSettingsViewModel && __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-disabled'], function (DisabledSettingsViewModel) {
				return DisabledSettingsViewModel && DisabledSettingsViewModel === RoutedSettingsViewModel;
			})) {
				RoutedSettingsViewModel = null;
			}
		}

		if (RoutedSettingsViewModel) {
			if (RoutedSettingsViewModel.__builded && RoutedSettingsViewModel.__vm) {
				oSettingsScreen = RoutedSettingsViewModel.__vm;
			} else {
				oViewModelPlace = this.oViewModelPlace;
				if (oViewModelPlace && 1 === oViewModelPlace.length) {
					oSettingsScreen = new RoutedSettingsViewModel();

					oViewModelDom = __WEBPACK_IMPORTED_MODULE_1_____default()('<div></div>').addClass('rl-settings-view-model').hide();
					oViewModelDom.appendTo(oViewModelPlace);

					oSettingsScreen.viewModelDom = oViewModelDom;

					oSettingsScreen.__rlSettingsData = RoutedSettingsViewModel.__rlSettingsData;

					RoutedSettingsViewModel.__dom = oViewModelDom;
					RoutedSettingsViewModel.__builded = true;
					RoutedSettingsViewModel.__vm = oSettingsScreen;

					__WEBPACK_IMPORTED_MODULE_2_ko___default.a.applyBindingAccessorsToNode(oViewModelDom[0], {
						translatorInit: true,
						template: function template() {
							return { name: RoutedSettingsViewModel.__rlSettingsData.Template };
						}
					}, oSettingsScreen);

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(oSettingsScreen, 'onBuild', [oViewModelDom]);
				} else {
					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["log"])('Cannot find sub settings view model position: SettingsSubScreen');
				}
			}

			if (oSettingsScreen) {
				__WEBPACK_IMPORTED_MODULE_0_____default.a.defer(function () {
					// hide
					if (self.oCurrentSubScreen) {
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onHide');
						self.oCurrentSubScreen.viewModelDom.hide();
					}
					// --

					self.oCurrentSubScreen = oSettingsScreen;

					// show
					if (self.oCurrentSubScreen) {
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onBeforeShow');
						self.oCurrentSubScreen.viewModelDom.show();
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onShow');
						__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(self.oCurrentSubScreen, 'onShowWithDelay', [], 200);

						__WEBPACK_IMPORTED_MODULE_0_____default.a.each(self.menu(), function (oItem) {
							oItem.selected(oSettingsScreen && oSettingsScreen.__rlSettingsData && oItem.route === oSettingsScreen.__rlSettingsData.Route);
						});

						__WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content .b-settings .b-content .content').scrollTop(0);
					}
					// --

					__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["windowResize"])();
				});
			}
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6_Knoin_Knoin__["setHash"])(__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_5_Common_Links__["settings"])(), false, true);
		}
	};

	AbstractSettingsScreen.prototype.onHide = function onHide() {
		if (this.oCurrentSubScreen && this.oCurrentSubScreen.viewModelDom) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["delegateRun"])(this.oCurrentSubScreen, 'onHide');
			this.oCurrentSubScreen.viewModelDom.hide();
		}
	};

	AbstractSettingsScreen.prototype.onBuild = function onBuild() {
		var _this2 = this;

		__WEBPACK_IMPORTED_MODULE_0_____default.a.each(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			if (SettingsViewModel && SettingsViewModel.__rlSettingsData && !__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-removed'], function (RemoveSettingsViewModel) {
				return RemoveSettingsViewModel && RemoveSettingsViewModel === SettingsViewModel;
			})) {
				_this2.menu.push({
					route: SettingsViewModel.__rlSettingsData.Route,
					label: SettingsViewModel.__rlSettingsData.Label,
					selected: __WEBPACK_IMPORTED_MODULE_2_ko___default.a.observable(false),
					disabled: !!__WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"]['settings-disabled'], function (DisabledSettingsViewModel) {
						return DisabledSettingsViewModel && DisabledSettingsViewModel === SettingsViewModel;
					})
				});
			}
		});

		this.oViewModelPlace = __WEBPACK_IMPORTED_MODULE_1_____default()('#rl-content #rl-settings-subscreen');
	};

	AbstractSettingsScreen.prototype.routes = function routes() {
		var DefaultViewModel = __WEBPACK_IMPORTED_MODULE_0_____default.a.find(__WEBPACK_IMPORTED_MODULE_3_Common_Globals__["aViewModels"].settings, function (SettingsViewModel) {
			return SettingsViewModel && SettingsViewModel.__rlSettingsData && SettingsViewModel.__rlSettingsData.IsDefault;
		}),
		    defaultRoute = DefaultViewModel && DefaultViewModel.__rlSettingsData ? DefaultViewModel.__rlSettingsData.Route : 'general',
		    oRules = {
			subname: /^(.*)$/,
			normalize_: function normalize_(oRequest, oVals) {
				oVals.subname = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["isUnd"])(oVals.subname) ? defaultRoute : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_4_Common_Utils__["pString"])(oVals.subname);
				return [oVals.subname];
			}
		};

		return [['{subname}/', oRules], ['{subname}', oRules], ['', oRules]];
	};

	return AbstractSettingsScreen;
}(__WEBPACK_IMPORTED_MODULE_7_Knoin_AbstractScreen__["a" /* AbstractScreen */]);



/***/ },
/* 81 */
/*!************************************!*\
  !*** ./dev/Stores/AbstractApp.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko__ = __webpack_require__(/*! ko */ 1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_ko___default = __WEBPACK_IMPORTED_MODULE_0_ko__ && __WEBPACK_IMPORTED_MODULE_0_ko__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_ko__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_ko__; };
/* harmony import */ __webpack_require__.d(__WEBPACK_IMPORTED_MODULE_0_ko___default, 'a', __WEBPACK_IMPORTED_MODULE_0_ko___default);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Globals__ = __webpack_require__(/*! Common/Globals */ 5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Storage_Settings__ = __webpack_require__(/*! Storage/Settings */ 7);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return AbstractAppStore; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var AbstractAppStore = function () {
	function AbstractAppStore() {
		_classCallCheck(this, AbstractAppStore);

		this.allowLanguagesOnSettings = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
		this.allowLanguagesOnLogin = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);

		this.interfaceAnimation = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);

		this.interfaceAnimation.subscribe(function (bValue) {
			var bAnim = __WEBPACK_IMPORTED_MODULE_1_Common_Globals__["bMobileDevice"] || !bValue;
			__WEBPACK_IMPORTED_MODULE_1_Common_Globals__["$html"].toggleClass('rl-anim', !bAnim).toggleClass('no-rl-anim', bAnim);
		});

		this.interfaceAnimation.valueHasMutated();

		this.prem = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(false);
		this.community = __WEBPACK_IMPORTED_MODULE_0_ko___default.a.observable(true);
	}

	AbstractAppStore.prototype.populate = function populate() {
		this.allowLanguagesOnLogin(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AllowLanguagesOnLogin'));
		this.allowLanguagesOnSettings(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('AllowLanguagesOnSettings'));

		this.interfaceAnimation(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('InterfaceAnimation'));

		this.prem(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('PremType'));
		this.community(!!__WEBPACK_IMPORTED_MODULE_2_Storage_Settings__["settingsGet"]('Community'));
	};

	return AbstractAppStore;
}();



/***/ },
/* 82 */
/*!******************************!*\
  !*** ./~/pikaday/pikaday.js ***!
  \******************************/
/***/ function(module, exports, __webpack_require__) {

/*!
 * Pikaday
 *
 * Copyright © 2014 David Bushell | BSD & MIT license | https://github.com/dbushell/Pikaday
 */

(function (root, factory)
{
    'use strict';

    var moment;
    if (true) {
        // CommonJS module
        // Load moment.js as an optional dependency
        try { moment = __webpack_require__(/*! moment */ 41); } catch (e) {}
        module.exports = factory(moment);
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(function (req)
        {
            // Load moment.js as an optional dependency
            var id = 'moment';
            try { moment = req(id); } catch (e) {}
            return factory(moment);
        });
    } else {
        root.Pikaday = factory(root.moment);
    }
}(this, function (moment)
{
    'use strict';

    /**
     * feature detection and helper functions
     */
    var hasMoment = typeof moment === 'function',

    hasEventListeners = !!window.addEventListener,

    document = window.document,

    sto = window.setTimeout,

    addEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.addEventListener(e, callback, !!capture);
        } else {
            el.attachEvent('on' + e, callback);
        }
    },

    removeEvent = function(el, e, callback, capture)
    {
        if (hasEventListeners) {
            el.removeEventListener(e, callback, !!capture);
        } else {
            el.detachEvent('on' + e, callback);
        }
    },

    fireEvent = function(el, eventName, data)
    {
        var ev;

        if (document.createEvent) {
            ev = document.createEvent('HTMLEvents');
            ev.initEvent(eventName, true, false);
            ev = extend(ev, data);
            el.dispatchEvent(ev);
        } else if (document.createEventObject) {
            ev = document.createEventObject();
            ev = extend(ev, data);
            el.fireEvent('on' + eventName, ev);
        }
    },

    trim = function(str)
    {
        return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g,'');
    },

    hasClass = function(el, cn)
    {
        return (' ' + el.className + ' ').indexOf(' ' + cn + ' ') !== -1;
    },

    addClass = function(el, cn)
    {
        if (!hasClass(el, cn)) {
            el.className = (el.className === '') ? cn : el.className + ' ' + cn;
        }
    },

    removeClass = function(el, cn)
    {
        el.className = trim((' ' + el.className + ' ').replace(' ' + cn + ' ', ' '));
    },

    isArray = function(obj)
    {
        return (/Array/).test(Object.prototype.toString.call(obj));
    },

    isDate = function(obj)
    {
        return (/Date/).test(Object.prototype.toString.call(obj)) && !isNaN(obj.getTime());
    },

    isWeekend = function(date)
    {
        var day = date.getDay();
        return day === 0 || day === 6;
    },

    isLeapYear = function(year)
    {
        // solution by Matti Virkkunen: http://stackoverflow.com/a/4881951
        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
    },

    getDaysInMonth = function(year, month)
    {
        return [31, isLeapYear(year) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month];
    },

    setToStartOfDay = function(date)
    {
        if (isDate(date)) date.setHours(0,0,0,0);
    },

    compareDates = function(a,b)
    {
        // weak date comparison (use setToStartOfDay(date) to ensure correct result)
        return a.getTime() === b.getTime();
    },

    extend = function(to, from, overwrite)
    {
        var prop, hasProp;
        for (prop in from) {
            hasProp = to[prop] !== undefined;
            if (hasProp && typeof from[prop] === 'object' && from[prop] !== null && from[prop].nodeName === undefined) {
                if (isDate(from[prop])) {
                    if (overwrite) {
                        to[prop] = new Date(from[prop].getTime());
                    }
                }
                else if (isArray(from[prop])) {
                    if (overwrite) {
                        to[prop] = from[prop].slice(0);
                    }
                } else {
                    to[prop] = extend({}, from[prop], overwrite);
                }
            } else if (overwrite || !hasProp) {
                to[prop] = from[prop];
            }
        }
        return to;
    },

    adjustCalendar = function(calendar) {
        if (calendar.month < 0) {
            calendar.year -= Math.ceil(Math.abs(calendar.month)/12);
            calendar.month += 12;
        }
        if (calendar.month > 11) {
            calendar.year += Math.floor(Math.abs(calendar.month)/12);
            calendar.month -= 12;
        }
        return calendar;
    },

    /**
     * defaults and localisation
     */
    defaults = {

        // bind the picker to a form field
        field: null,

        // automatically show/hide the picker on `field` focus (default `true` if `field` is set)
        bound: undefined,

        // position of the datepicker, relative to the field (default to bottom & left)
        // ('bottom' & 'left' keywords are not used, 'top' & 'right' are modifier on the bottom/left position)
        position: 'bottom left',

        // automatically fit in the viewport even if it means repositioning from the position option
        reposition: true,

        // the default output format for `.toString()` and `field` value
        format: 'YYYY-MM-DD',

        // the initial date to view when first opened
        defaultDate: null,

        // make the `defaultDate` the initial selected value
        setDefaultDate: false,

        // first day of week (0: Sunday, 1: Monday etc)
        firstDay: 0,

        // the minimum/earliest date that can be selected
        minDate: null,
        // the maximum/latest date that can be selected
        maxDate: null,

        // number of years either side, or array of upper/lower range
        yearRange: 10,

        // show week numbers at head of row
        showWeekNumber: false,

        // used internally (don't config outside)
        minYear: 0,
        maxYear: 9999,
        minMonth: undefined,
        maxMonth: undefined,

        startRange: null,
        endRange: null,

        isRTL: false,

        // Additional text to append to the year in the calendar title
        yearSuffix: '',

        // Render the month after year in the calendar title
        showMonthAfterYear: false,

        // how many months are visible
        numberOfMonths: 1,

        // when numberOfMonths is used, this will help you to choose where the main calendar will be (default `left`, can be set to `right`)
        // only used for the first display or when a selected date is not visible
        mainCalendar: 'left',

        // Specify a DOM element to render the calendar in
        container: undefined,

        // internationalization
        i18n: {
            previousMonth : 'Previous Month',
            nextMonth     : 'Next Month',
            months        : ['January','February','March','April','May','June','July','August','September','October','November','December'],
            weekdays      : ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],
            weekdaysShort : ['Sun','Mon','Tue','Wed','Thu','Fri','Sat']
        },

        // Theme Classname
        theme: null,

        // callback function
        onSelect: null,
        onOpen: null,
        onClose: null,
        onDraw: null
    },


    /**
     * templating functions to abstract HTML rendering
     */
    renderDayName = function(opts, day, abbr)
    {
        day += opts.firstDay;
        while (day >= 7) {
            day -= 7;
        }
        return abbr ? opts.i18n.weekdaysShort[day] : opts.i18n.weekdays[day];
    },

    renderDay = function(opts)
    {
        if (opts.isEmpty) {
            return '<td class="is-empty"></td>';
        }
        var arr = [];
        if (opts.isDisabled) {
            arr.push('is-disabled');
        }
        if (opts.isToday) {
            arr.push('is-today');
        }
        if (opts.isSelected) {
            arr.push('is-selected');
        }
        if (opts.isInRange) {
            arr.push('is-inrange');
        }
        if (opts.isStartRange) {
            arr.push('is-startrange');
        }
        if (opts.isEndRange) {
            arr.push('is-endrange');
        }
        return '<td data-day="' + opts.day + '" class="' + arr.join(' ') + '">' +
                 '<button class="pika-button pika-day" type="button" ' +
                    'data-pika-year="' + opts.year + '" data-pika-month="' + opts.month + '" data-pika-day="' + opts.day + '">' +
                        opts.day +
                 '</button>' +
               '</td>';
    },

    renderWeek = function (d, m, y) {
        // Lifted from http://javascript.about.com/library/blweekyear.htm, lightly modified.
        var onejan = new Date(y, 0, 1),
            weekNum = Math.ceil((((new Date(y, m, d) - onejan) / 86400000) + onejan.getDay()+1)/7);
        return '<td class="pika-week">' + weekNum + '</td>';
    },

    renderRow = function(days, isRTL)
    {
        return '<tr>' + (isRTL ? days.reverse() : days).join('') + '</tr>';
    },

    renderBody = function(rows)
    {
        return '<tbody>' + rows.join('') + '</tbody>';
    },

    renderHead = function(opts)
    {
        var i, arr = [];
        if (opts.showWeekNumber) {
            arr.push('<th></th>');
        }
        for (i = 0; i < 7; i++) {
            arr.push('<th scope="col"><abbr title="' + renderDayName(opts, i) + '">' + renderDayName(opts, i, true) + '</abbr></th>');
        }
        return '<thead>' + (opts.isRTL ? arr.reverse() : arr).join('') + '</thead>';
    },

    renderTitle = function(instance, c, year, month, refYear)
    {
        var i, j, arr,
            opts = instance._o,
            isMinYear = year === opts.minYear,
            isMaxYear = year === opts.maxYear,
            html = '<div class="pika-title">',
            monthHtml,
            yearHtml,
            prev = true,
            next = true;

        for (arr = [], i = 0; i < 12; i++) {
            arr.push('<option value="' + (year === refYear ? i - c : 12 + i - c) + '"' +
                (i === month ? ' selected': '') +
                ((isMinYear && i < opts.minMonth) || (isMaxYear && i > opts.maxMonth) ? 'disabled' : '') + '>' +
                opts.i18n.months[i] + '</option>');
        }
        monthHtml = '<div class="pika-label">' + opts.i18n.months[month] + '<select class="pika-select pika-select-month" tabindex="-1">' + arr.join('') + '</select></div>';

        if (isArray(opts.yearRange)) {
            i = opts.yearRange[0];
            j = opts.yearRange[1] + 1;
        } else {
            i = year - opts.yearRange;
            j = 1 + year + opts.yearRange;
        }

        for (arr = []; i < j && i <= opts.maxYear; i++) {
            if (i >= opts.minYear) {
                arr.push('<option value="' + i + '"' + (i === year ? ' selected': '') + '>' + (i) + '</option>');
            }
        }
        yearHtml = '<div class="pika-label">' + year + opts.yearSuffix + '<select class="pika-select pika-select-year" tabindex="-1">' + arr.join('') + '</select></div>';

        if (opts.showMonthAfterYear) {
            html += yearHtml + monthHtml;
        } else {
            html += monthHtml + yearHtml;
        }

        if (isMinYear && (month === 0 || opts.minMonth >= month)) {
            prev = false;
        }

        if (isMaxYear && (month === 11 || opts.maxMonth <= month)) {
            next = false;
        }

        if (c === 0) {
            html += '<button class="pika-prev' + (prev ? '' : ' is-disabled') + '" type="button">' + opts.i18n.previousMonth + '</button>';
        }
        if (c === (instance._o.numberOfMonths - 1) ) {
            html += '<button class="pika-next' + (next ? '' : ' is-disabled') + '" type="button">' + opts.i18n.nextMonth + '</button>';
        }

        return html += '</div>';
    },

    renderTable = function(opts, data)
    {
        return '<table cellpadding="0" cellspacing="0" class="pika-table">' + renderHead(opts) + renderBody(data) + '</table>';
    },


    /**
     * Pikaday constructor
     */
    Pikaday = function(options)
    {
        var self = this,
            opts = self.config(options);

        self._onMouseDown = function(e)
        {
            if (!self._v) {
                return;
            }
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }

            if (!hasClass(target, 'is-disabled')) {
                if (hasClass(target, 'pika-button') && !hasClass(target, 'is-empty')) {
                    self.setDate(new Date(target.getAttribute('data-pika-year'), target.getAttribute('data-pika-month'), target.getAttribute('data-pika-day')));
                    if (opts.bound) {
                        sto(function() {
                            self.hide();
                            if (opts.field) {
                                opts.field.blur();
                            }
                        }, 100);
                    }
                }
                else if (hasClass(target, 'pika-prev')) {
                    self.prevMonth();
                }
                else if (hasClass(target, 'pika-next')) {
                    self.nextMonth();
                }
            }
            if (!hasClass(target, 'pika-select')) {
                // if this is touch event prevent mouse events emulation
                if (e.preventDefault) {
                    e.preventDefault();
                } else {
                    e.returnValue = false;
                    return false;
                }
            } else {
                self._c = true;
            }
        };

        self._onChange = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement;
            if (!target) {
                return;
            }
            if (hasClass(target, 'pika-select-month')) {
                self.gotoMonth(target.value);
            }
            else if (hasClass(target, 'pika-select-year')) {
                self.gotoYear(target.value);
            }
        };

        self._onInputChange = function(e)
        {
            var date;

            if (e.firedBy === self) {
                return;
            }
            if (hasMoment) {
                date = moment(opts.field.value, opts.format);
                date = (date && date.isValid()) ? date.toDate() : null;
            }
            else {
                date = new Date(Date.parse(opts.field.value));
            }
            if (isDate(date)) {
              self.setDate(date);
            }
            if (!self._v) {
                self.show();
            }
        };

        self._onInputFocus = function()
        {
            self.show();
        };

        self._onInputClick = function()
        {
            self.show();
        };

        self._onInputBlur = function()
        {
            // IE allows pika div to gain focus; catch blur the input field
            var pEl = document.activeElement;
            do {
                if (hasClass(pEl, 'pika-single')) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));

            if (!self._c) {
                self._b = sto(function() {
                    self.hide();
                }, 50);
            }
            self._c = false;
        };

        self._onClick = function(e)
        {
            e = e || window.event;
            var target = e.target || e.srcElement,
                pEl = target;
            if (!target) {
                return;
            }
            if (!hasEventListeners && hasClass(target, 'pika-select')) {
                if (!target.onchange) {
                    target.setAttribute('onchange', 'return;');
                    addEvent(target, 'change', self._onChange);
                }
            }
            do {
                if (hasClass(pEl, 'pika-single') || pEl === opts.trigger) {
                    return;
                }
            }
            while ((pEl = pEl.parentNode));
            if (self._v && target !== opts.trigger && pEl !== opts.trigger) {
                self.hide();
            }
        };

        self.el = document.createElement('div');
        self.el.className = 'pika-single' + (opts.isRTL ? ' is-rtl' : '') + (opts.theme ? ' ' + opts.theme : '');

        addEvent(self.el, 'mousedown', self._onMouseDown, true);
        addEvent(self.el, 'touchend', self._onMouseDown, true);
        addEvent(self.el, 'change', self._onChange);

        if (opts.field) {
            if (opts.container) {
                opts.container.appendChild(self.el);
            } else if (opts.bound) {
                document.body.appendChild(self.el);
            } else {
                opts.field.parentNode.insertBefore(self.el, opts.field.nextSibling);
            }
            addEvent(opts.field, 'change', self._onInputChange);

            if (!opts.defaultDate) {
                if (hasMoment && opts.field.value) {
                    opts.defaultDate = moment(opts.field.value, opts.format).toDate();
                } else {
                    opts.defaultDate = new Date(Date.parse(opts.field.value));
                }
                opts.setDefaultDate = true;
            }
        }

        var defDate = opts.defaultDate;

        if (isDate(defDate)) {
            if (opts.setDefaultDate) {
                self.setDate(defDate, true);
            } else {
                self.gotoDate(defDate);
            }
        } else {
            self.gotoDate(new Date());
        }

        if (opts.bound) {
            this.hide();
            self.el.className += ' is-bound';
            addEvent(opts.trigger, 'click', self._onInputClick);
            addEvent(opts.trigger, 'focus', self._onInputFocus);
            addEvent(opts.trigger, 'blur', self._onInputBlur);
        } else {
            this.show();
        }
    };


    /**
     * public Pikaday API
     */
    Pikaday.prototype = {


        /**
         * configure functionality
         */
        config: function(options)
        {
            if (!this._o) {
                this._o = extend({}, defaults, true);
            }

            var opts = extend(this._o, options, true);

            opts.isRTL = !!opts.isRTL;

            opts.field = (opts.field && opts.field.nodeName) ? opts.field : null;

            opts.theme = (typeof opts.theme) === 'string' && opts.theme ? opts.theme : null;

            opts.bound = !!(opts.bound !== undefined ? opts.field && opts.bound : opts.field);

            opts.trigger = (opts.trigger && opts.trigger.nodeName) ? opts.trigger : opts.field;

            opts.disableWeekends = !!opts.disableWeekends;

            opts.disableDayFn = (typeof opts.disableDayFn) === 'function' ? opts.disableDayFn : null;

            var nom = parseInt(opts.numberOfMonths, 10) || 1;
            opts.numberOfMonths = nom > 4 ? 4 : nom;

            if (!isDate(opts.minDate)) {
                opts.minDate = false;
            }
            if (!isDate(opts.maxDate)) {
                opts.maxDate = false;
            }
            if ((opts.minDate && opts.maxDate) && opts.maxDate < opts.minDate) {
                opts.maxDate = opts.minDate = false;
            }
            if (opts.minDate) {
                this.setMinDate(opts.minDate);
            }
            if (opts.maxDate) {
                this.setMaxDate(opts.maxDate);
            }

            if (isArray(opts.yearRange)) {
                var fallback = new Date().getFullYear() - 10;
                opts.yearRange[0] = parseInt(opts.yearRange[0], 10) || fallback;
                opts.yearRange[1] = parseInt(opts.yearRange[1], 10) || fallback;
            } else {
                opts.yearRange = Math.abs(parseInt(opts.yearRange, 10)) || defaults.yearRange;
                if (opts.yearRange > 100) {
                    opts.yearRange = 100;
                }
            }

            return opts;
        },

        /**
         * return a formatted string of the current selection (using Moment.js if available)
         */
        toString: function(format)
        {
            return !isDate(this._d) ? '' : hasMoment ? moment(this._d).format(format || this._o.format) : this._d.toDateString();
        },

        /**
         * return a Moment.js object of the current selection (if available)
         */
        getMoment: function()
        {
            return hasMoment ? moment(this._d) : null;
        },

        /**
         * set the current selection from a Moment.js object (if available)
         */
        setMoment: function(date, preventOnSelect)
        {
            if (hasMoment && moment.isMoment(date)) {
                this.setDate(date.toDate(), preventOnSelect);
            }
        },

        /**
         * return a Date object of the current selection
         */
        getDate: function()
        {
            return isDate(this._d) ? new Date(this._d.getTime()) : null;
        },

        /**
         * set the current selection
         */
        setDate: function(date, preventOnSelect)
        {
            if (!date) {
                this._d = null;

                if (this._o.field) {
                    this._o.field.value = '';
                    fireEvent(this._o.field, 'change', { firedBy: this });
                }

                return this.draw();
            }
            if (typeof date === 'string') {
                date = new Date(Date.parse(date));
            }
            if (!isDate(date)) {
                return;
            }

            var min = this._o.minDate,
                max = this._o.maxDate;

            if (isDate(min) && date < min) {
                date = min;
            } else if (isDate(max) && date > max) {
                date = max;
            }

            this._d = new Date(date.getTime());
            setToStartOfDay(this._d);
            this.gotoDate(this._d);

            if (this._o.field) {
                this._o.field.value = this.toString();
                fireEvent(this._o.field, 'change', { firedBy: this });
            }
            if (!preventOnSelect && typeof this._o.onSelect === 'function') {
                this._o.onSelect.call(this, this.getDate());
            }
        },

        /**
         * change view to a specific date
         */
        gotoDate: function(date)
        {
            var newCalendar = true;

            if (!isDate(date)) {
                return;
            }

            if (this.calendars) {
                var firstVisibleDate = new Date(this.calendars[0].year, this.calendars[0].month, 1),
                    lastVisibleDate = new Date(this.calendars[this.calendars.length-1].year, this.calendars[this.calendars.length-1].month, 1),
                    visibleDate = date.getTime();
                // get the end of the month
                lastVisibleDate.setMonth(lastVisibleDate.getMonth()+1);
                lastVisibleDate.setDate(lastVisibleDate.getDate()-1);
                newCalendar = (visibleDate < firstVisibleDate.getTime() || lastVisibleDate.getTime() < visibleDate);
            }

            if (newCalendar) {
                this.calendars = [{
                    month: date.getMonth(),
                    year: date.getFullYear()
                }];
                if (this._o.mainCalendar === 'right') {
                    this.calendars[0].month += 1 - this._o.numberOfMonths;
                }
            }

            this.adjustCalendars();
        },

        adjustCalendars: function() {
            this.calendars[0] = adjustCalendar(this.calendars[0]);
            for (var c = 1; c < this._o.numberOfMonths; c++) {
                this.calendars[c] = adjustCalendar({
                    month: this.calendars[0].month + c,
                    year: this.calendars[0].year
                });
            }
            this.draw();
        },

        gotoToday: function()
        {
            this.gotoDate(new Date());
        },

        /**
         * change view to a specific month (zero-index, e.g. 0: January)
         */
        gotoMonth: function(month)
        {
            if (!isNaN(month)) {
                this.calendars[0].month = parseInt(month, 10);
                this.adjustCalendars();
            }
        },

        nextMonth: function()
        {
            this.calendars[0].month++;
            this.adjustCalendars();
        },

        prevMonth: function()
        {
            this.calendars[0].month--;
            this.adjustCalendars();
        },

        /**
         * change view to a specific full year (e.g. "2012")
         */
        gotoYear: function(year)
        {
            if (!isNaN(year)) {
                this.calendars[0].year = parseInt(year, 10);
                this.adjustCalendars();
            }
        },

        /**
         * change the minDate
         */
        setMinDate: function(value)
        {
            setToStartOfDay(value);
            this._o.minDate = value;
            this._o.minYear  = value.getFullYear();
            this._o.minMonth = value.getMonth();
            this.draw();
        },

        /**
         * change the maxDate
         */
        setMaxDate: function(value)
        {
            setToStartOfDay(value);
            this._o.maxDate = value;
            this._o.maxYear = value.getFullYear();
            this._o.maxMonth = value.getMonth();
            this.draw();
        },

        setStartRange: function(value)
        {
            this._o.startRange = value;
        },

        setEndRange: function(value)
        {
            this._o.endRange = value;
        },

        /**
         * refresh the HTML
         */
        draw: function(force)
        {
            if (!this._v && !force) {
                return;
            }
            var opts = this._o,
                minYear = opts.minYear,
                maxYear = opts.maxYear,
                minMonth = opts.minMonth,
                maxMonth = opts.maxMonth,
                html = '';

            if (this._y <= minYear) {
                this._y = minYear;
                if (!isNaN(minMonth) && this._m < minMonth) {
                    this._m = minMonth;
                }
            }
            if (this._y >= maxYear) {
                this._y = maxYear;
                if (!isNaN(maxMonth) && this._m > maxMonth) {
                    this._m = maxMonth;
                }
            }

            for (var c = 0; c < opts.numberOfMonths; c++) {
                html += '<div class="pika-lendar">' + renderTitle(this, c, this.calendars[c].year, this.calendars[c].month, this.calendars[0].year) + this.render(this.calendars[c].year, this.calendars[c].month) + '</div>';
            }

            this.el.innerHTML = html;

            if (opts.bound) {
                if(opts.field.type !== 'hidden') {
                    sto(function() {
                        opts.trigger.focus();
                    }, 1);
                }
            }

            if (typeof this._o.onDraw === 'function') {
                var self = this;
                sto(function() {
                    self._o.onDraw.call(self);
                }, 0);
            }
        },

        adjustPosition: function()
        {
            var field, pEl, width, height, viewportWidth, viewportHeight, scrollTop, left, top, clientRect;

            if (this._o.container) return;

            this.el.style.position = 'absolute';

            field = this._o.trigger;
            pEl = field;
            width = this.el.offsetWidth;
            height = this.el.offsetHeight;
            viewportWidth = window.innerWidth || document.documentElement.clientWidth;
            viewportHeight = window.innerHeight || document.documentElement.clientHeight;
            scrollTop = window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop;

            if (typeof field.getBoundingClientRect === 'function') {
                clientRect = field.getBoundingClientRect();
                left = clientRect.left + window.pageXOffset;
                top = clientRect.bottom + window.pageYOffset;
            } else {
                left = pEl.offsetLeft;
                top  = pEl.offsetTop + pEl.offsetHeight;
                while((pEl = pEl.offsetParent)) {
                    left += pEl.offsetLeft;
                    top  += pEl.offsetTop;
                }
            }

            // default position is bottom & left
            if ((this._o.reposition && left + width > viewportWidth) ||
                (
                    this._o.position.indexOf('right') > -1 &&
                    left - width + field.offsetWidth > 0
                )
            ) {
                left = left - width + field.offsetWidth;
            }
            if ((this._o.reposition && top + height > viewportHeight + scrollTop) ||
                (
                    this._o.position.indexOf('top') > -1 &&
                    top - height - field.offsetHeight > 0
                )
            ) {
                top = top - height - field.offsetHeight;
            }

            this.el.style.left = left + 'px';
            this.el.style.top = top + 'px';
        },

        /**
         * render HTML for a particular month
         */
        render: function(year, month)
        {
            var opts   = this._o,
                now    = new Date(),
                days   = getDaysInMonth(year, month),
                before = new Date(year, month, 1).getDay(),
                data   = [],
                row    = [];
            setToStartOfDay(now);
            if (opts.firstDay > 0) {
                before -= opts.firstDay;
                if (before < 0) {
                    before += 7;
                }
            }
            var cells = days + before,
                after = cells;
            while(after > 7) {
                after -= 7;
            }
            cells += 7 - after;
            for (var i = 0, r = 0; i < cells; i++)
            {
                var day = new Date(year, month, 1 + (i - before)),
                    isSelected = isDate(this._d) ? compareDates(day, this._d) : false,
                    isToday = compareDates(day, now),
                    isEmpty = i < before || i >= (days + before),
                    isStartRange = opts.startRange && compareDates(opts.startRange, day),
                    isEndRange = opts.endRange && compareDates(opts.endRange, day),
                    isInRange = opts.startRange && opts.endRange && opts.startRange < day && day < opts.endRange,
                    isDisabled = (opts.minDate && day < opts.minDate) ||
                                 (opts.maxDate && day > opts.maxDate) ||
                                 (opts.disableWeekends && isWeekend(day)) ||
                                 (opts.disableDayFn && opts.disableDayFn(day)),
                    dayConfig = {
                        day: 1 + (i - before),
                        month: month,
                        year: year,
                        isSelected: isSelected,
                        isToday: isToday,
                        isDisabled: isDisabled,
                        isEmpty: isEmpty,
                        isStartRange: isStartRange,
                        isEndRange: isEndRange,
                        isInRange: isInRange
                    };

                row.push(renderDay(dayConfig));

                if (++r === 7) {
                    if (opts.showWeekNumber) {
                        row.unshift(renderWeek(i - before, month, year));
                    }
                    data.push(renderRow(row, opts.isRTL));
                    row = [];
                    r = 0;
                }
            }
            return renderTable(opts, data);
        },

        isVisible: function()
        {
            return this._v;
        },

        show: function()
        {
            if (!this._v) {
                removeClass(this.el, 'is-hidden');
                this._v = true;
                this.draw();
                if (this._o.bound) {
                    addEvent(document, 'click', this._onClick);
                    this.adjustPosition();
                }
                if (typeof this._o.onOpen === 'function') {
                    this._o.onOpen.call(this);
                }
            }
        },

        hide: function()
        {
            var v = this._v;
            if (v !== false) {
                if (this._o.bound) {
                    removeEvent(document, 'click', this._onClick);
                }
                this.el.style.position = 'static'; // reset
                this.el.style.left = 'auto';
                this.el.style.top = 'auto';
                addClass(this.el, 'is-hidden');
                this._v = false;
                if (v !== undefined && typeof this._o.onClose === 'function') {
                    this._o.onClose.call(this);
                }
            }
        },

        /**
         * GAME OVER
         */
        destroy: function()
        {
            this.hide();
            removeEvent(this.el, 'mousedown', this._onMouseDown, true);
            removeEvent(this.el, 'touchend', this._onMouseDown, true);
            removeEvent(this.el, 'change', this._onChange);
            if (this._o.field) {
                removeEvent(this._o.field, 'change', this._onInputChange);
                if (this._o.bound) {
                    removeEvent(this._o.trigger, 'click', this._onInputClick);
                    removeEvent(this._o.trigger, 'focus', this._onInputFocus);
                    removeEvent(this._o.trigger, 'blur', this._onInputBlur);
                }
            }
            if (this.el.parentNode) {
                this.el.parentNode.removeChild(this.el);
            }
        }

    };

    return Pikaday;

}));


/***/ },
/* 83 */,
/* 84 */
/*!************************************!*\
  !*** external "window.Autolinker" ***!
  \************************************/
/***/ function(module, exports) {

module.exports = window.Autolinker;

/***/ },
/* 85 */
/*!***********************************!*\
  !*** external "window.JSEncrypt" ***!
  \***********************************/
/***/ function(module, exports) {

module.exports = window.JSEncrypt;

/***/ },
/* 86 */,
/* 87 */
/*!********************************!*\
  !*** external "window.hasher" ***!
  \********************************/
/***/ function(module, exports) {

module.exports = window.hasher;

/***/ },
/* 88 */
/*!*****************************!*\
  !*** external "window.ssm" ***!
  \*****************************/
/***/ function(module, exports) {

module.exports = window.ssm;

/***/ },
/* 89 */,
/* 90 */
/*!**********************************!*\
  !*** ./dev/Stores/Admin/Core.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var ko = __webpack_require__(/*! ko */ 1);

/**
 * @constructor
 */
function CoreAdminStore()
{
	this.coreReal = ko.observable(true);
	this.coreChannel = ko.observable('stable');
	this.coreType = ko.observable('stable');
	this.coreUpdatable = ko.observable(true);
	this.coreAccess = ko.observable(true);
	this.coreWarning = ko.observable(false);
	this.coreChecking = ko.observable(false).extend({'throttle': 100});
	this.coreUpdating = ko.observable(false).extend({'throttle': 100});
	this.coreVersion = ko.observable('');
	this.coreRemoteVersion = ko.observable('');
	this.coreRemoteRelease = ko.observable('');
	this.coreVersionCompare = ko.observable(-2);
}

module.exports = new CoreAdminStore();


/***/ },
/* 91 */,
/* 92 */,
/* 93 */,
/* 94 */
/*!************************************!*\
  !*** ./dev/View/Popup/Activate.js ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	LicenseStore = __webpack_require__(/*! Stores/Admin/License */ 59),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function ActivatePopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsActivate');

	var self = this;

	this.domain = ko.observable('');
	this.key = ko.observable('');
	this.key.focus = ko.observable(false);
	this.activationSuccessed = ko.observable(false);

	this.licenseTrigger = LicenseStore.licenseTrigger;

	this.activateProcess = ko.observable(false);
	this.activateText = ko.observable('');
	this.activateText.isError = ko.observable(false);

	this.htmlDescription = ko.computed(function() {
		return Translator.i18n('POPUPS_ACTIVATE/HTML_DESC', {'DOMAIN': this.domain()});
	}, this);

	this.key.subscribe(function() {
		this.activateText('');
		this.activateText.isError(false);
	}, this);

	this.activationSuccessed.subscribe(function(bValue) {
		if (bValue)
		{
			this.licenseTrigger(!this.licenseTrigger());
		}
	}, this);

	this.activateCommand = Utils.createCommand(this, function() {

		this.activateProcess(true);
		if (this.validateSubscriptionKey())
		{
			Remote.licensingActivate(function(sResult, oData) {

				self.activateProcess(false);
				if (Enums.StorageResultType.Success === sResult && oData.Result)
				{
					if (true === oData.Result)
					{
						self.activationSuccessed(true);
						self.activateText(Translator.i18n('POPUPS_ACTIVATE/SUBS_KEY_ACTIVATED'));
						self.activateText.isError(false);
					}
					else
					{
						self.activateText(oData.Result);
						self.activateText.isError(true);
						self.key.focus(true);
					}
				}
				else if (oData.ErrorCode)
				{
					self.activateText(Translator.getNotification(oData.ErrorCode));
					self.activateText.isError(true);
					self.key.focus(true);
				}
				else
				{
					self.activateText(Translator.getNotification(Enums.Notification.UnknownError));
					self.activateText.isError(true);
					self.key.focus(true);
				}

			}, this.domain(), this.key());
		}
		else
		{
			this.activateProcess(false);
			this.activateText(Translator.i18n('POPUPS_ACTIVATE/ERROR_INVALID_SUBS_KEY'));
			this.activateText.isError(true);
			this.key.focus(true);
		}

	}, function() {
		return !this.activateProcess() && '' !== this.domain() && '' !== this.key() && !this.activationSuccessed();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Activate', 'PopupsActivateViewModel'], ActivatePopupView);
_.extend(ActivatePopupView.prototype, AbstractView.prototype);

ActivatePopupView.prototype.onShow = function(bTrial)
{
	this.domain(Settings.settingsGet('AdminDomain'));
	if (!this.activateProcess())
	{
		bTrial = Utils.isUnd(bTrial) ? false : !!bTrial;

		this.key(bTrial ? Consts.RAINLOOP_TRIAL_KEY : '');
		this.activateText('');
		this.activateText.isError(false);
		this.activationSuccessed(false);
	}
};

ActivatePopupView.prototype.onShowWithDelay = function()
{
	if (!this.activateProcess())
	{
		this.key.focus(true);
	}
};

/**
 * @returns {boolean}
 */
ActivatePopupView.prototype.validateSubscriptionKey = function()
{
	var sValue = this.key();
	return '' === sValue || Consts.RAINLOOP_TRIAL_KEY === sValue || !!(/^RL[\d]+-[A-Z0-9\-]+Z$/).test(Utils.trim(sValue));
};

module.exports = ActivatePopupView;


/***/ },
/* 95 */
/*!**********************************!*\
  !*** ./dev/View/Popup/Domain.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Consts = __webpack_require__(/*! Common/Consts */ 15),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	CapaAdminStore = __webpack_require__(/*! Stores/Admin/Capa */ 51),

	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function DomainPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsDomain');

	this.edit = ko.observable(false);
	this.saving = ko.observable(false);
	this.savingError = ko.observable('');
	this.page = ko.observable('main');
	this.sieveSettings = ko.observable(false);

	this.testing = ko.observable(false);
	this.testingDone = ko.observable(false);
	this.testingImapError = ko.observable(false);
	this.testingSieveError = ko.observable(false);
	this.testingSmtpError = ko.observable(false);
	this.testingImapErrorDesc = ko.observable('');
	this.testingSieveErrorDesc = ko.observable('');
	this.testingSmtpErrorDesc = ko.observable('');

	this.testingImapError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.testingImapErrorDesc('');
		}
	}, this);

	this.testingSieveError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.testingSieveErrorDesc('');
		}
	}, this);

	this.testingSmtpError.subscribe(function(bValue) {
		if (!bValue)
		{
			this.testingSmtpErrorDesc('');
		}
	}, this);

	this.imapServerFocus = ko.observable(false);
	this.sieveServerFocus = ko.observable(false);
	this.smtpServerFocus = ko.observable(false);

	this.name = ko.observable('');
	this.name.focused = ko.observable(false);

	this.imapServer = ko.observable('');
	this.imapPort = ko.observable('' + Consts.IMAP_DEFAULT_PORT);
	this.imapSecure = ko.observable(Enums.ServerSecure.None);
	this.imapShortLogin = ko.observable(false);
	this.useSieve = ko.observable(false);
	this.sieveAllowRaw = ko.observable(false);
	this.sieveServer = ko.observable('');
	this.sievePort = ko.observable('' + Consts.SIEVE_DEFAULT_PORT);
	this.sieveSecure = ko.observable(Enums.ServerSecure.None);
	this.smtpServer = ko.observable('');
	this.smtpPort = ko.observable('' + Consts.SMTP_DEFAULT_PORT);
	this.smtpSecure = ko.observable(Enums.ServerSecure.None);
	this.smtpShortLogin = ko.observable(false);
	this.smtpAuth = ko.observable(true);
	this.smtpPhpMail = ko.observable(false);
	this.whiteList = ko.observable('');
	this.aliasName = ko.observable('');

	this.enableSmartPorts = ko.observable(false);

	this.allowSieve = ko.computed(function() {
		return CapaAdminStore.filters() && CapaAdminStore.sieve();
	}, this);

	this.headerText = ko.computed(function() {

		var
			sName = this.name(),
			sAliasName = this.aliasName(),
			sResult = '';

		if (this.edit())
		{
			sResult = Translator.i18n('POPUPS_DOMAIN/TITLE_EDIT_DOMAIN', {'NAME': sName});
			if (sAliasName)
			{
				sResult += ' ← ' + sAliasName;
			}
		}
		else
		{
			sResult = ('' === sName ? Translator.i18n('POPUPS_DOMAIN/TITLE_ADD_DOMAIN') :
				Translator.i18n('POPUPS_DOMAIN/TITLE_ADD_DOMAIN_WITH_NAME', {'NAME': sName}));
		}

		return sResult;

	}, this);

	this.domainDesc = ko.computed(function() {
		var sName = this.name();
		return !this.edit() && sName ? Translator.i18n('POPUPS_DOMAIN/NEW_DOMAIN_DESC', {'NAME': '*@' + sName}) : '';
	}, this);

	this.domainIsComputed = ko.computed(function() {

		var
			bPhpMail = this.smtpPhpMail(),
			bAllowSieve = this.allowSieve(),
			bUseSieve = this.useSieve();

		return '' !== this.name() &&
			'' !== this.imapServer() &&
			'' !== this.imapPort() &&
			(bAllowSieve && bUseSieve ? ('' !== this.sieveServer() && '' !== this.sievePort()) : true) &&
			(('' !== this.smtpServer() && '' !== this.smtpPort()) || bPhpMail);

	}, this);

	this.canBeTested = ko.computed(function() {
		return !this.testing() && this.domainIsComputed();
	}, this);

	this.canBeSaved = ko.computed(function() {
		return !this.saving() && this.domainIsComputed();
	}, this);

	this.createOrAddCommand = Utils.createCommand(this, function() {
		this.saving(true);
		Remote.createOrUpdateDomain(
			_.bind(this.onDomainCreateOrSaveResponse, this),
			!this.edit(),
			this.name(),

			this.imapServer(),
			Utils.pInt(this.imapPort()),
			this.imapSecure(),
			this.imapShortLogin(),

			this.useSieve(),
			this.sieveAllowRaw(),
			this.sieveServer(),
			Utils.pInt(this.sievePort()),
			this.sieveSecure(),

			this.smtpServer(),
			Utils.pInt(this.smtpPort()),
			this.smtpSecure(),
			this.smtpShortLogin(),
			this.smtpAuth(),
			this.smtpPhpMail(),

			this.whiteList()
		);
	}, this.canBeSaved);

	this.testConnectionCommand = Utils.createCommand(this, function() {

		this.page('main');

		this.testingDone(false);
		this.testingImapError(false);
		this.testingSieveError(false);
		this.testingSmtpError(false);
		this.testing(true);

		Remote.testConnectionForDomain(
			_.bind(this.onTestConnectionResponse, this),
			this.name(),

			this.imapServer(),
			Utils.pInt(this.imapPort()),
			this.imapSecure(),

			this.useSieve(),
			this.sieveServer(),
			Utils.pInt(this.sievePort()),
			this.sieveSecure(),

			this.smtpServer(),
			Utils.pInt(this.smtpPort()),
			this.smtpSecure(),
			this.smtpAuth(),
			this.smtpPhpMail()
		);
	}, this.canBeTested);

	this.whiteListCommand = Utils.createCommand(this, function() {
		this.page('white-list');
	});

	this.backCommand = Utils.createCommand(this, function() {
		this.page('main');
	});

	this.sieveCommand = Utils.createCommand(this, function() {
		this.sieveSettings(!this.sieveSettings());
		this.clearTesting();
	});

	this.page.subscribe(function() {
		this.sieveSettings(false);
	}, this);

	// smart form improvements
	this.imapServerFocus.subscribe(function(bValue) {
		if (bValue && '' !== this.name() && '' === this.imapServer())
		{
			this.imapServer(this.name().replace(/[.]?[*][.]?/g, ''));
		}
	}, this);

	this.sieveServerFocus.subscribe(function(bValue) {
		if (bValue && '' !== this.imapServer() && '' === this.sieveServer())
		{
			this.sieveServer(this.imapServer());
		}
	}, this);

	this.smtpServerFocus.subscribe(function(bValue) {
		if (bValue && '' !== this.imapServer() && '' === this.smtpServer())
		{
			this.smtpServer(this.imapServer().replace(/imap/ig, 'smtp'));
		}
	}, this);

	this.imapSecure.subscribe(function(sValue) {
		if (this.enableSmartPorts())
		{
			var iPort = Utils.pInt(this.imapPort());
			switch (Utils.pString(sValue))
			{
				case '0':
					if (Enums.Ports.ImapSsl === iPort)
					{
						this.imapPort(Utils.pString(Enums.Ports.Imap));
					}
					break;
				case '1':
					if (Enums.Ports.Imap === iPort)
					{
						this.imapPort(Utils.pString(Enums.Ports.ImapSsl));
					}
					break;
				// no default
			}
		}
	}, this);

	this.smtpSecure.subscribe(function(sValue) {
		if (this.enableSmartPorts())
		{
			var iPort = Utils.pInt(this.smtpPort());
			switch (Utils.pString(sValue))
			{
				case '0':
					if (Enums.Ports.SmtpSsl === iPort || Enums.Ports.SmtpStartTls === iPort)
					{
						this.smtpPort(Utils.pString(Enums.Ports.Smtp));
					}
					break;
				case '1':
					if (Enums.Ports.Smtp === iPort || Enums.Ports.SmtpStartTls === iPort)
					{
						this.smtpPort(Utils.pString(Enums.Ports.SmtpSsl));
					}
					break;
				case '2':
					if (Enums.Ports.Smtp === iPort || Enums.Ports.SmtpSsl === iPort)
					{
						this.smtpPort(Utils.pString(Enums.Ports.SmtpStartTls));
					}
					break;
				// no default
			}
		}
	}, this);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Domain', 'PopupsDomainViewModel'], DomainPopupView);
_.extend(DomainPopupView.prototype, AbstractView.prototype);

DomainPopupView.prototype.onTestConnectionResponse = function(sResult, oData)
{
	this.testing(false);
	if (Enums.StorageResultType.Success === sResult && oData.Result)
	{
		var
			bImap = false,
			bSieve = false;

		this.testingDone(true);
		this.testingImapError(true !== oData.Result.Imap);
		this.testingSieveError(true !== oData.Result.Sieve);
		this.testingSmtpError(true !== oData.Result.Smtp);

		if (this.testingImapError() && oData.Result.Imap)
		{
			bImap = true;
			this.testingImapErrorDesc('');
			this.testingImapErrorDesc(oData.Result.Imap);
		}

		if (this.testingSieveError() && oData.Result.Sieve)
		{
			bSieve = true;
			this.testingSieveErrorDesc('');
			this.testingSieveErrorDesc(oData.Result.Sieve);
		}

		if (this.testingSmtpError() && oData.Result.Smtp)
		{
			this.testingSmtpErrorDesc('');
			this.testingSmtpErrorDesc(oData.Result.Smtp);
		}

		if (this.sieveSettings())
		{
			if (!bSieve && bImap)
			{
				this.sieveSettings(false);
			}
		}
		else
		{
			if (bSieve && !bImap)
			{
				this.sieveSettings(true);
			}
		}
	}
	else
	{
		this.testingImapError(true);
		this.testingSieveError(true);
		this.testingSmtpError(true);
		this.sieveSettings(false);
	}
};

DomainPopupView.prototype.onDomainCreateOrSaveResponse = function(sResult, oData)
{
	this.saving(false);
	if (Enums.StorageResultType.Success === sResult && oData)
	{
		if (oData.Result)
		{
			__webpack_require__(/*! App/Admin */ 18).default.reloadDomainList();
			this.closeCommand();
		}
		else if (Enums.Notification.DomainAlreadyExists === oData.ErrorCode)
		{
			this.savingError(Translator.i18n('ERRORS/DOMAIN_ALREADY_EXISTS'));
		}
	}
	else
	{
		this.savingError(Translator.i18n('ERRORS/UNKNOWN_ERROR'));
	}
};

DomainPopupView.prototype.clearTesting = function()
{
	this.testing(false);
	this.testingDone(false);
	this.testingImapError(false);
	this.testingSieveError(false);
	this.testingSmtpError(false);
};

DomainPopupView.prototype.onHide = function()
{
	this.page('main');
	this.sieveSettings(false);
};

DomainPopupView.prototype.onShow = function(oDomain)
{
	this.saving(false);

	this.page('main');
	this.sieveSettings(false);

	this.clearTesting();

	this.clearForm();
	if (oDomain)
	{
		this.enableSmartPorts(false);

		this.edit(true);

		this.name(Utils.trim(oDomain.Name));
		this.imapServer(Utils.trim(oDomain.IncHost));
		this.imapPort('' + Utils.pInt(oDomain.IncPort));
		this.imapSecure(Utils.trim(oDomain.IncSecure));
		this.imapShortLogin(!!oDomain.IncShortLogin);
		this.useSieve(!!oDomain.UseSieve);
		this.sieveAllowRaw(!!oDomain.SieveAllowRaw);
		this.sieveServer(Utils.trim(oDomain.SieveHost));
		this.sievePort('' + Utils.pInt(oDomain.SievePort));
		this.sieveSecure(Utils.trim(oDomain.SieveSecure));
		this.smtpServer(Utils.trim(oDomain.OutHost));
		this.smtpPort('' + Utils.pInt(oDomain.OutPort));
		this.smtpSecure(Utils.trim(oDomain.OutSecure));
		this.smtpShortLogin(!!oDomain.OutShortLogin);
		this.smtpAuth(!!oDomain.OutAuth);
		this.smtpPhpMail(!!oDomain.OutUsePhpMail);
		this.whiteList(Utils.trim(oDomain.WhiteList));
		this.aliasName(Utils.trim(oDomain.AliasName));

		this.enableSmartPorts(true);
	}
};

DomainPopupView.prototype.onShowWithDelay = function()
{
	if ('' === this.name() && !Globals.bMobile)
	{
		this.name.focused(true);
	}
};

DomainPopupView.prototype.clearForm = function()
{
	this.edit(false);

	this.page('main');
	this.sieveSettings(false);

	this.enableSmartPorts(false);

	this.savingError('');

	this.name('');
	this.name.focused(false);

	this.imapServer('');
	this.imapPort('' + Consts.IMAP_DEFAULT_PORT);
	this.imapSecure(Enums.ServerSecure.None);
	this.imapShortLogin(false);

	this.useSieve(false);
	this.sieveAllowRaw(false);
	this.sieveServer('');
	this.sievePort('' + Consts.SIEVE_DEFAULT_PORT);
	this.sieveSecure(Enums.ServerSecure.None);

	this.smtpServer('');
	this.smtpPort('' + Consts.SMTP_DEFAULT_PORT);
	this.smtpSecure(Enums.ServerSecure.None);
	this.smtpShortLogin(false);
	this.smtpAuth(true);
	this.smtpPhpMail(false);

	this.whiteList('');
	this.aliasName('');
	this.enableSmartPorts(true);
};

module.exports = DomainPopupView;


/***/ },
/* 96 */,
/* 97 */,
/* 98 */,
/* 99 */,
/* 100 */,
/* 101 */,
/* 102 */,
/* 103 */,
/* 104 */,
/* 105 */,
/* 106 */,
/* 107 */,
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */,
/* 112 */,
/* 113 */,
/* 114 */
/*!*************************************!*\
  !*** ./dev/Settings/Admin/About.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


/* global RL_COMMUNITY */

var
	ko = __webpack_require__(/*! ko */ 1),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	CoreStore = __webpack_require__(/*! Stores/Admin/Core */ 90),
	AppStore = __webpack_require__(/*! Stores/Admin/App */ 35);

/**
 * @constructor
 */
function AboutAdminSettings()
{
	this.version = ko.observable(Settings.appSettingsGet('version'));
	this.access = ko.observable(!!Settings.settingsGet('CoreAccess'));
	this.errorDesc = ko.observable('');

	this.coreReal = CoreStore.coreReal;
	this.coreChannel = CoreStore.coreChannel;
	this.coreType = CoreStore.coreType;
	this.coreUpdatable = CoreStore.coreUpdatable;
	this.coreAccess = CoreStore.coreAccess;
	this.coreChecking = CoreStore.coreChecking;
	this.coreUpdating = CoreStore.coreUpdating;
	this.coreWarning = CoreStore.coreWarning;
	this.coreVersion = CoreStore.coreVersion;
	this.coreRemoteVersion = CoreStore.coreRemoteVersion;
	this.coreRemoteRelease = CoreStore.coreRemoteRelease;
	this.coreVersionCompare = CoreStore.coreVersionCompare;

	this.community = false || AppStore.community();

	this.coreRemoteVersionHtmlDesc = ko.computed(function() {
		Translator.trigger();
		return Translator.i18n('TAB_ABOUT/HTML_NEW_VERSION', {'VERSION': this.coreRemoteVersion()});
	}, this);

	this.statusType = ko.computed(function() {

		var
			sType = '',
			iVersionCompare = this.coreVersionCompare(),
			bChecking = this.coreChecking(),
			bUpdating = this.coreUpdating(),
			bReal = this.coreReal();

		if (bChecking)
		{
			sType = 'checking';
		}
		else if (bUpdating)
		{
			sType = 'updating';
		}
		else if (bReal && 0 === iVersionCompare)
		{
			sType = 'up-to-date';
		}
		else if (bReal && -1 === iVersionCompare)
		{
			sType = 'available';
		}
		else if (!bReal)
		{
			sType = 'error';
			this.errorDesc('Cannot access the repository at the moment.');
		}

		return sType;

	}, this);
}

AboutAdminSettings.prototype.onBuild = function()
{
	if (this.access() && !this.community)
	{
		__webpack_require__(/*! App/Admin */ 18).default.reloadCoreData();
	}
};

AboutAdminSettings.prototype.updateCoreData = function()
{
	if (!this.coreUpdating() && !this.community)
	{
		__webpack_require__(/*! App/Admin */ 18).default.updateCoreData();
	}
};

module.exports = AboutAdminSettings;


/***/ },
/* 115 */
/*!****************************************!*\
  !*** ./dev/Settings/Admin/Branding.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


/* global RL_COMMUNITY */

var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6);

/**
 * @constructor
 */
function BrandingAdminSettings()
{
	var
		Enums = __webpack_require__(/*! Common/Enums */ 3),
		Settings = __webpack_require__(/*! Storage/Settings */ 7),
		AppStore = __webpack_require__(/*! Stores/Admin/App */ 35);

	this.capa = AppStore.prem;

	this.title = ko.observable(Settings.settingsGet('Title'));
	this.title.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.loadingDesc = ko.observable(Settings.settingsGet('LoadingDescription'));
	this.loadingDesc.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.faviconUrl = ko.observable(Settings.settingsGet('FaviconUrl'));
	this.faviconUrl.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.loginLogo = ko.observable(Settings.settingsGet('LoginLogo') || '');
	this.loginLogo.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.loginBackground = ko.observable(Settings.settingsGet('LoginBackground') || '');
	this.loginBackground.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.userLogo = ko.observable(Settings.settingsGet('UserLogo') || '');
	this.userLogo.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.userLogoMessage = ko.observable(Settings.settingsGet('UserLogoMessage') || '');
	this.userLogoMessage.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.userIframeMessage = ko.observable(Settings.settingsGet('UserIframeMessage') || '');
	this.userIframeMessage.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.userLogoTitle = ko.observable(Settings.settingsGet('UserLogoTitle') || '');
	this.userLogoTitle.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.loginDescription = ko.observable(Settings.settingsGet('LoginDescription'));
	this.loginDescription.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.loginCss = ko.observable(Settings.settingsGet('LoginCss'));
	this.loginCss.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.userCss = ko.observable(Settings.settingsGet('UserCss'));
	this.userCss.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.welcomePageUrl = ko.observable(Settings.settingsGet('WelcomePageUrl'));
	this.welcomePageUrl.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.welcomePageDisplay = ko.observable(Settings.settingsGet('WelcomePageDisplay'));
	this.welcomePageDisplay.trigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.welcomePageDisplay.options = ko.computed(function() {
		Translator.trigger();
		return [
			{'optValue': 'none', 'optText': Translator.i18n('TAB_BRANDING/OPTION_WELCOME_PAGE_DISPLAY_NONE')},
			{'optValue': 'once', 'optText': Translator.i18n('TAB_BRANDING/OPTION_WELCOME_PAGE_DISPLAY_ONCE')},
			{'optValue': 'always', 'optText': Translator.i18n('TAB_BRANDING/OPTION_WELCOME_PAGE_DISPLAY_ALWAYS')}
		];
	});

	this.loginPowered = ko.observable(!!Settings.settingsGet('LoginPowered'));

	this.community = false || AppStore.community();
}

BrandingAdminSettings.prototype.onBuild = function()
{
	var
		self = this,
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	_.delay(function() {

		var
			f1 = Utils.settingsSaveHelperSimpleFunction(self.title.trigger, self),
			f2 = Utils.settingsSaveHelperSimpleFunction(self.loadingDesc.trigger, self),
			f3 = Utils.settingsSaveHelperSimpleFunction(self.faviconUrl.trigger, self);

		self.title.subscribe(function(sValue) {
			Remote.saveAdminConfig(f1, {
				'Title': Utils.trim(sValue)
			});
		});

		self.loadingDesc.subscribe(function(sValue) {
			Remote.saveAdminConfig(f2, {
				'LoadingDescription': Utils.trim(sValue)
			});
		});

		self.faviconUrl.subscribe(function(sValue) {
			Remote.saveAdminConfig(f3, {
				'FaviconUrl': Utils.trim(sValue)
			});
		});

	}, 50);
};

module.exports = BrandingAdminSettings;


/***/ },
/* 116 */
/*!****************************************!*\
  !*** ./dev/Settings/Admin/Contacts.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function ContactsAdminSettings()
{
	var
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	this.defautOptionsAfterRender = Utils.defautOptionsAfterRender;
	this.enableContacts = ko.observable(!!Settings.settingsGet('ContactsEnable'));
	this.contactsSharing = ko.observable(!!Settings.settingsGet('ContactsSharing'));
	this.contactsSync = ko.observable(!!Settings.settingsGet('ContactsSync'));

	var
		aTypes = ['sqlite', 'mysql', 'pgsql'],
		aSupportedTypes = [],
		getTypeName = function(sName) {
			switch (sName)
			{
				case 'sqlite':
					sName = 'SQLite';
					break;
				case 'mysql':
					sName = 'MySQL';
					break;
				case 'pgsql':
					sName = 'PostgreSQL';
					break;
				// no default
			}

			return sName;
		};

	if (Settings.settingsGet('SQLiteIsSupported'))
	{
		aSupportedTypes.push('sqlite');
	}
	if (Settings.settingsGet('MySqlIsSupported'))
	{
		aSupportedTypes.push('mysql');
	}
	if (Settings.settingsGet('PostgreSqlIsSupported'))
	{
		aSupportedTypes.push('pgsql');
	}

	this.contactsSupported = 0 < aSupportedTypes.length;

	this.contactsTypes = ko.observableArray([]);
	this.contactsTypesOptions = this.contactsTypes.map(function(sValue) {
		var bDisabled = -1 === Utils.inArray(sValue, aSupportedTypes);
		return {
			'id': sValue,
			'name': getTypeName(sValue) + (bDisabled ? ' (' + Translator.i18n('HINTS/NOT_SUPPORTED') + ')' : ''),
			'disabled': bDisabled
		};
	});

	this.contactsTypes(aTypes);
	this.contactsType = ko.observable('');

	this.mainContactsType = ko.computed({
		'owner': this,
		'read': this.contactsType,
		'write': function(sValue) {
			if (sValue !== this.contactsType())
			{
				if (-1 < Utils.inArray(sValue, aSupportedTypes))
				{
					this.contactsType(sValue);
				}
				else if (0 < aSupportedTypes.length)
				{
					this.contactsType('');
				}
			}
			else
			{
				this.contactsType.valueHasMutated();
			}
		}
	}).extend({'notify': 'always'});

	this.contactsType.subscribe(function() {
		this.testContactsSuccess(false);
		this.testContactsError(false);
		this.testContactsErrorMessage('');
	}, this);

	this.pdoDsn = ko.observable(Settings.settingsGet('ContactsPdoDsn'));
	this.pdoUser = ko.observable(Settings.settingsGet('ContactsPdoUser'));
	this.pdoPassword = ko.observable(Settings.settingsGet('ContactsPdoPassword'));

	this.pdoDsnTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.pdoUserTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.pdoPasswordTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.contactsTypeTrigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.testing = ko.observable(false);
	this.testContactsSuccess = ko.observable(false);
	this.testContactsError = ko.observable(false);
	this.testContactsErrorMessage = ko.observable('');

	this.testContactsCommand = Utils.createCommand(this, function() {

		this.testContactsSuccess(false);
		this.testContactsError(false);
		this.testContactsErrorMessage('');
		this.testing(true);

		Remote.testContacts(this.onTestContactsResponse, {
			'ContactsPdoType': this.contactsType(),
			'ContactsPdoDsn': this.pdoDsn(),
			'ContactsPdoUser': this.pdoUser(),
			'ContactsPdoPassword': this.pdoPassword()
		});

	}, function() {
		return '' !== this.pdoDsn() && '' !== this.pdoUser();
	});

	this.contactsType(Settings.settingsGet('ContactsPdoType'));

	this.onTestContactsResponse = _.bind(this.onTestContactsResponse, this);
}

ContactsAdminSettings.prototype.onTestContactsResponse = function(sResult, oData)
{
	this.testContactsSuccess(false);
	this.testContactsError(false);
	this.testContactsErrorMessage('');

	if (Enums.StorageResultType.Success === sResult && oData && oData.Result && oData.Result.Result)
	{
		this.testContactsSuccess(true);
	}
	else
	{
		this.testContactsError(true);
		if (oData && oData.Result)
		{
			this.testContactsErrorMessage(oData.Result.Message || '');
		}
		else
		{
			this.testContactsErrorMessage('');
		}
	}

	this.testing(false);
};

ContactsAdminSettings.prototype.onShow = function()
{
	this.testContactsSuccess(false);
	this.testContactsError(false);
	this.testContactsErrorMessage('');
};

ContactsAdminSettings.prototype.onBuild = function()
{
	var
		self = this,
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	_.delay(function() {

		var
			f1 = Utils.settingsSaveHelperSimpleFunction(self.pdoDsnTrigger, self),
			f3 = Utils.settingsSaveHelperSimpleFunction(self.pdoUserTrigger, self),
			f4 = Utils.settingsSaveHelperSimpleFunction(self.pdoPasswordTrigger, self),
			f5 = Utils.settingsSaveHelperSimpleFunction(self.contactsTypeTrigger, self);

		self.enableContacts.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'ContactsEnable': bValue ? '1' : '0'
			});
		});

		self.contactsSharing.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'ContactsSharing': bValue ? '1' : '0'
			});
		});

		self.contactsSync.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'ContactsSync': bValue ? '1' : '0'
			});
		});

		self.contactsType.subscribe(function(sValue) {
			Remote.saveAdminConfig(f5, {
				'ContactsPdoType': sValue
			});
		});

		self.pdoDsn.subscribe(function(sValue) {
			Remote.saveAdminConfig(f1, {
				'ContactsPdoDsn': Utils.trim(sValue)
			});
		});

		self.pdoUser.subscribe(function(sValue) {
			Remote.saveAdminConfig(f3, {
				'ContactsPdoUser': Utils.trim(sValue)
			});
		});

		self.pdoPassword.subscribe(function(sValue) {
			Remote.saveAdminConfig(f4, {
				'ContactsPdoPassword': Utils.trim(sValue)
			});
		});

		self.contactsType(Settings.settingsGet('ContactsPdoType'));

	}, 50);
};

module.exports = ContactsAdminSettings;


/***/ },
/* 117 */
/*!***************************************!*\
  !*** ./dev/Settings/Admin/Domains.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),

	DomainStore = __webpack_require__(/*! Stores/Admin/Domain */ 52),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

/**
 * @constructor
 */
function DomainsAdminSettings()
{
	this.domains = DomainStore.domains;

	this.visibility = ko.computed(function() {
		return this.domains.loading() ? 'visible' : 'hidden';
	}, this);

	this.domainForDeletion = ko.observable(null).deleteAccessHelper();

	this.onDomainListChangeRequest = _.bind(this.onDomainListChangeRequest, this);
	this.onDomainLoadRequest = _.bind(this.onDomainLoadRequest, this);
}

DomainsAdminSettings.prototype.createDomain = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Domain */ 95));
};

DomainsAdminSettings.prototype.createDomainAlias = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/DomainAlias */ 143));
};

DomainsAdminSettings.prototype.deleteDomain = function(oDomain)
{
	this.domains.remove(oDomain);
	Remote.domainDelete(this.onDomainListChangeRequest, oDomain.name);
};

DomainsAdminSettings.prototype.disableDomain = function(oDomain)
{
	oDomain.disabled(!oDomain.disabled());
	Remote.domainDisable(this.onDomainListChangeRequest, oDomain.name, oDomain.disabled());
};

DomainsAdminSettings.prototype.onBuild = function(oDom)
{
	var self = this;
	oDom
		.on('click', '.b-admin-domains-list-table .e-item .e-action', function() {
			var oDomainItem = ko.dataFor(this);
			if (oDomainItem)
			{
				Remote.domain(self.onDomainLoadRequest, oDomainItem.name);
			}
		});

	__webpack_require__(/*! App/Admin */ 18).default.reloadDomainList();
};

DomainsAdminSettings.prototype.onDomainLoadRequest = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Domain */ 95), [oData.Result]);
	}
};

DomainsAdminSettings.prototype.onDomainListChangeRequest = function()
{
	__webpack_require__(/*! App/Admin */ 18).default.reloadDomainList();
};

module.exports = DomainsAdminSettings;


/***/ },
/* 118 */
/*!***************************************!*\
  !*** ./dev/Settings/Admin/General.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	ThemeStore = __webpack_require__(/*! Stores/Theme */ 43),
	LanguageStore = __webpack_require__(/*! Stores/Language */ 38),
	AppAdminStore = __webpack_require__(/*! Stores/Admin/App */ 35),
	CapaAdminStore = __webpack_require__(/*! Stores/Admin/Capa */ 51),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function GeneralAdminSettings()
{
	this.language = LanguageStore.language;
	this.languages = LanguageStore.languages;
	this.languageAdmin = LanguageStore.languageAdmin;
	this.languagesAdmin = LanguageStore.languagesAdmin;

	this.theme = ThemeStore.theme;
	this.themes = ThemeStore.themes;

	this.capaThemes = CapaAdminStore.themes;
	this.capaUserBackground = CapaAdminStore.userBackground;
	this.capaGravatar = CapaAdminStore.gravatar;
	this.capaAdditionalAccounts = CapaAdminStore.additionalAccounts;
	this.capaIdentities = CapaAdminStore.identities;
	this.capaAttachmentThumbnails = CapaAdminStore.attachmentThumbnails;
	this.capaTemplates = CapaAdminStore.templates;

	this.allowLanguagesOnSettings = AppAdminStore.allowLanguagesOnSettings;
	this.weakPassword = AppAdminStore.weakPassword;

	this.mainAttachmentLimit = ko.observable(Utils.pInt(Settings.settingsGet('AttachmentLimit')) / (1024 * 1024)).extend({'posInterer': 25});
	this.uploadData = Settings.settingsGet('PhpUploadSizes');
	this.uploadDataDesc = this.uploadData && (this.uploadData.upload_max_filesize || this.uploadData.post_max_size) ? [
		this.uploadData.upload_max_filesize ? 'upload_max_filesize = ' + this.uploadData.upload_max_filesize + '; ' : '',
		this.uploadData.post_max_size ? 'post_max_size = ' + this.uploadData.post_max_size : ''
	].join('') : '';

	this.themesOptions = ko.computed(function() {
		return _.map(this.themes(), function(sTheme) {
			return {
				optValue: sTheme,
				optText: Utils.convertThemeName(sTheme)
			};
		});
	}, this);

	this.languageFullName = ko.computed(function() {
		return Utils.convertLangName(this.language());
	}, this);

	this.languageAdminFullName = ko.computed(function() {
		return Utils.convertLangName(this.languageAdmin());
	}, this);

	this.attachmentLimitTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.languageTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
	this.languageAdminTrigger = ko.observable(Enums.SaveSettingsStep.Idle).extend({'throttle': 100});
	this.themeTrigger = ko.observable(Enums.SaveSettingsStep.Idle);
}

GeneralAdminSettings.prototype.onBuild = function()
{
	var
		self = this,
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	_.delay(function() {

		var
			f1 = Utils.settingsSaveHelperSimpleFunction(self.attachmentLimitTrigger, self),
			f2 = Utils.settingsSaveHelperSimpleFunction(self.languageTrigger, self),
			f3 = Utils.settingsSaveHelperSimpleFunction(self.themeTrigger, self),
			fReloadLanguageHelper = function(iSaveSettingsStep) {
				return function() {
					self.languageAdminTrigger(iSaveSettingsStep);
					_.delay(function() {
						self.languageAdminTrigger(Enums.SaveSettingsStep.Idle);
					}, 1000);
				};
			};

		self.mainAttachmentLimit.subscribe(function(sValue) {
			Remote.saveAdminConfig(f1, {
				'AttachmentLimit': Utils.pInt(sValue)
			});
		});

		self.language.subscribe(function(sValue) {
			Remote.saveAdminConfig(f2, {
				'Language': Utils.trim(sValue)
			});
		});

		self.languageAdmin.subscribe(function(sValue) {

			self.languageAdminTrigger(Enums.SaveSettingsStep.Animate);

			Translator.reload(true, sValue).then(
				fReloadLanguageHelper(Enums.SaveSettingsStep.TrueResult),
				fReloadLanguageHelper(Enums.SaveSettingsStep.FalseResult)
			).then(function() {
				Remote.saveAdminConfig(null, {
					'LanguageAdmin': Utils.trim(sValue)
				});
			});

		});

		self.theme.subscribe(function(sValue) {

			Utils.changeTheme(sValue, self.themeTrigger);

			Remote.saveAdminConfig(f3, {
				'Theme': Utils.trim(sValue)
			});
		});

		self.capaAdditionalAccounts.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaAdditionalAccounts': bValue ? '1' : '0'
			});
		});

		self.capaIdentities.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaIdentities': bValue ? '1' : '0'
			});
		});

		self.capaTemplates.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaTemplates': bValue ? '1' : '0'
			});
		});

		self.capaGravatar.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaGravatar': bValue ? '1' : '0'
			});
		});

		self.capaAttachmentThumbnails.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaAttachmentThumbnails': bValue ? '1' : '0'
			});
		});

		self.capaThemes.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaThemes': bValue ? '1' : '0'
			});
		});

		self.capaUserBackground.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'CapaUserBackground': bValue ? '1' : '0'
			});
		});

		self.allowLanguagesOnSettings.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'AllowLanguagesOnSettings': bValue ? '1' : '0'
			});
		});

	}, 50);
};

GeneralAdminSettings.prototype.selectLanguage = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Languages */ 44), [
		this.language, this.languages(), LanguageStore.userLanguage()
	]);
};

GeneralAdminSettings.prototype.selectLanguageAdmin = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Languages */ 44), [
		this.languageAdmin, this.languagesAdmin(), LanguageStore.userLanguageAdmin()
	]);
};

/**
 * @returns {string}
 */
GeneralAdminSettings.prototype.phpInfoLink = function()
{
	return Links.phpInfo();
};

module.exports = GeneralAdminSettings;


/***/ },
/* 119 */
/*!*************************************!*\
  !*** ./dev/Settings/Admin/Login.js ***!
  \*************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	AppAdminStore = __webpack_require__(/*! Stores/Admin/App */ 35),

	Settings = __webpack_require__(/*! Storage/Settings */ 7);

/**
 * @constructor
 */
function LoginAdminSettings()
{
	this.determineUserLanguage = AppAdminStore.determineUserLanguage;
	this.determineUserDomain = AppAdminStore.determineUserDomain;

	this.defaultDomain = ko.observable(Settings.settingsGet('LoginDefaultDomain'));

	this.allowLanguagesOnLogin = AppAdminStore.allowLanguagesOnLogin;
	this.defaultDomainTrigger = ko.observable(Enums.SaveSettingsStep.Idle);

	this.dummy = ko.observable(false);
}

LoginAdminSettings.prototype.onBuild = function()
{
	var
		self = this,
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	_.delay(function() {

		var f1 = Utils.settingsSaveHelperSimpleFunction(self.defaultDomainTrigger, self);

		self.determineUserLanguage.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'DetermineUserLanguage': bValue ? '1' : '0'
			});
		});

		self.determineUserDomain.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'DetermineUserDomain': bValue ? '1' : '0'
			});
		});

		self.allowLanguagesOnLogin.subscribe(function(bValue) {
			Remote.saveAdminConfig(null, {
				'AllowLanguagesOnLogin': bValue ? '1' : '0'
			});
		});

		self.defaultDomain.subscribe(function(sValue) {
			Remote.saveAdminConfig(f1, {
				'LoginDefaultDomain': Utils.trim(sValue)
			});
		});

	}, 50);
};

module.exports = LoginAdminSettings;


/***/ },
/* 120 */
/*!****************************************!*\
  !*** ./dev/Settings/Admin/Packages.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	window = __webpack_require__(/*! window */ 9),
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	PackageStore = __webpack_require__(/*! Stores/Admin/Package */ 60),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

/**
 * @constructor
 */
function PackagesAdminSettings()
{
	this.packagesError = ko.observable('');

	this.packages = PackageStore.packages;
	this.packagesReal = PackageStore.packagesReal;
	this.packagesMainUpdatable = PackageStore.packagesMainUpdatable;

	this.packagesCurrent = this.packages.filter(function(item) {
		return item && '' !== item.installed && !item.compare;
	});

	this.packagesAvailableForUpdate = this.packages.filter(function(item) {
		return item && '' !== item.installed && !!item.compare;
	});

	this.packagesAvailableForInstallation = this.packages.filter(function(item) {
		return item && '' === item.installed;
	});

	this.visibility = ko.computed(function() {
		return PackageStore.packages.loading() ? 'visible' : 'hidden';
	}, this);
}

PackagesAdminSettings.prototype.onShow = function()
{
	this.packagesError('');
};

PackagesAdminSettings.prototype.onBuild = function()
{
	__webpack_require__(/*! App/Admin */ 18).default.reloadPackagesList();
};

PackagesAdminSettings.prototype.requestHelper = function(oPackage, bInstall)
{
	var self = this;
	return function(sResult, oData) {

		if (Enums.StorageResultType.Success !== sResult || !oData || !oData.Result)
		{
			if (oData && oData.ErrorCode)
			{
				self.packagesError(Translator.getNotification(oData.ErrorCode));
			}
			else
			{
				self.packagesError(Translator.getNotification(
					bInstall ? Enums.Notification.CantInstallPackage : Enums.Notification.CantDeletePackage));
			}
		}

		_.each(self.packages(), function(item) {
			if (item && oPackage && item.loading && item.loading() && oPackage.file === item.file)
			{
				oPackage.loading(false);
				item.loading(false);
			}
		});

		if (Enums.StorageResultType.Success === sResult && oData && oData.Result && oData.Result.Reload)
		{
			window.location.reload();
		}
		else
		{
			__webpack_require__(/*! App/Admin */ 18).default.reloadPackagesList();
		}
	};
};

PackagesAdminSettings.prototype.deletePackage = function(oPackage)
{
	if (oPackage)
	{
		oPackage.loading(true);
		Remote.packageDelete(this.requestHelper(oPackage, false), oPackage);
	}
};

PackagesAdminSettings.prototype.installPackage = function(oPackage)
{
	if (oPackage)
	{
		oPackage.loading(true);
		Remote.packageInstall(this.requestHelper(oPackage, true), oPackage);
	}
};

module.exports = PackagesAdminSettings;


/***/ },
/* 121 */
/*!***************************************!*\
  !*** ./dev/Settings/Admin/Plugins.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


/* global RL_COMMUNITY */

var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),

	AppStore = __webpack_require__(/*! Stores/Admin/App */ 35),
	PluginStore = __webpack_require__(/*! Stores/Admin/Plugin */ 61),

	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

/**
 * @constructor
 */
function PluginsAdminSettings()
{
	this.enabledPlugins = ko.observable(!!Settings.settingsGet('EnabledPlugins'));

	this.plugins = PluginStore.plugins;
	this.pluginsError = PluginStore.plugins.error;

	this.community = false || AppStore.community();

	this.visibility = ko.computed(function() {
		return PluginStore.plugins.loading() ? 'visible' : 'hidden';
	}, this);

	this.onPluginLoadRequest = _.bind(this.onPluginLoadRequest, this);
	this.onPluginDisableRequest = _.bind(this.onPluginDisableRequest, this);
}

PluginsAdminSettings.prototype.disablePlugin = function(oPlugin)
{
	oPlugin.disabled(!oPlugin.disabled());
	Remote.pluginDisable(this.onPluginDisableRequest, oPlugin.name, oPlugin.disabled());
};

PluginsAdminSettings.prototype.configurePlugin = function(oPlugin)
{
	Remote.plugin(this.onPluginLoadRequest, oPlugin.name);
};

PluginsAdminSettings.prototype.onBuild = function(oDom)
{
	var self = this;

	oDom
		.on('click', '.e-item .configure-plugin-action', function() {
			var oPlugin = ko.dataFor(this);
			if (oPlugin)
			{
				self.configurePlugin(oPlugin);
			}
		})
		.on('click', '.e-item .disabled-plugin', function() {
			var oPlugin = ko.dataFor(this);
			if (oPlugin)
			{
				self.disablePlugin(oPlugin);
			}
		});

	this.enabledPlugins.subscribe(function(bValue) {
		Remote.saveAdminConfig(Utils.noop, {
			'EnabledPlugins': bValue ? '1' : '0'
		});
	});
};

PluginsAdminSettings.prototype.onShow = function()
{
	PluginStore.plugins.error('');
	__webpack_require__(/*! App/Admin */ 18).default.reloadPluginList();
};

PluginsAdminSettings.prototype.onPluginLoadRequest = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Plugin */ 147), [oData.Result]);
	}
};

PluginsAdminSettings.prototype.onPluginDisableRequest = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData)
	{
		if (!oData.Result && oData.ErrorCode)
		{
			if (Enums.Notification.UnsupportedPluginPackage === oData.ErrorCode && oData.ErrorMessage && '' !== oData.ErrorMessage)
			{
				PluginStore.plugins.error(oData.ErrorMessage);
			}
			else
			{
				PluginStore.plugins.error(Translator.getNotification(oData.ErrorCode));
			}
		}
	}

	__webpack_require__(/*! App/Admin */ 18).default.reloadPluginList();
};

module.exports = PluginsAdminSettings;


/***/ },
/* 122 */
/*!*********************************************!*\
  !*** ./dev/Settings/Admin/Prem/Branding.js ***!
  \*********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Utils = __webpack_require__(/*! Common/Utils */ 0),
	BrandingAdminSettings = __webpack_require__(/*! Settings/Admin/Branding */ 115);

/**
 * @constructor
 */
function BrandingPremAdminSettings()
{
	BrandingAdminSettings.call(this);
}

BrandingPremAdminSettings.prototype.onBuild = function(oDom)
{
	var
		self = this,
		Remote = null;

	BrandingAdminSettings.prototype.onBuild.call(this, oDom);

	if (this.capa && this.capa() && !this.community)
	{
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

		_.delay(function() {
			var
				f1 = Utils.settingsSaveHelperSimpleFunction(self.loginLogo.trigger, self),
				f2 = Utils.settingsSaveHelperSimpleFunction(self.loginDescription.trigger, self),
				f3 = Utils.settingsSaveHelperSimpleFunction(self.loginCss.trigger, self),
				f4 = Utils.settingsSaveHelperSimpleFunction(self.userLogo.trigger, self),
				f5 = Utils.settingsSaveHelperSimpleFunction(self.userLogoTitle.trigger, self),
				f6 = Utils.settingsSaveHelperSimpleFunction(self.loginBackground.trigger, self),
				f7 = Utils.settingsSaveHelperSimpleFunction(self.userCss.trigger, self),
				f8 = Utils.settingsSaveHelperSimpleFunction(self.welcomePageUrl.trigger, self),
				f9 = Utils.settingsSaveHelperSimpleFunction(self.welcomePageDisplay.trigger, self),
				f10 = Utils.settingsSaveHelperSimpleFunction(self.userLogoMessage.trigger, self),
				f11 = Utils.settingsSaveHelperSimpleFunction(self.userIframeMessage.trigger, self);

			self.loginLogo.subscribe(function(sValue) {
				Remote.saveAdminConfig(f1, {
					'LoginLogo': Utils.trim(sValue)
				});
			});

			self.loginDescription.subscribe(function(sValue) {
				Remote.saveAdminConfig(f2, {
					'LoginDescription': Utils.trim(sValue)
				});
			});

			self.loginCss.subscribe(function(sValue) {
				Remote.saveAdminConfig(f3, {
					'LoginCss': Utils.trim(sValue)
				});
			});

			self.userLogo.subscribe(function(sValue) {
				Remote.saveAdminConfig(f4, {
					'UserLogo': Utils.trim(sValue)
				});
			});

			self.userLogoTitle.subscribe(function(sValue) {
				Remote.saveAdminConfig(f5, {
					'UserLogoTitle': Utils.trim(sValue)
				});
			});

			self.userLogoMessage.subscribe(function(sValue) {
				Remote.saveAdminConfig(f10, {
					'UserLogoMessage': Utils.trim(sValue)
				});
			});

			self.userIframeMessage.subscribe(function(sValue) {
				Remote.saveAdminConfig(f11, {
					'UserIframeMessage': Utils.trim(sValue)
				});
			});

			self.loginBackground.subscribe(function(sValue) {
				Remote.saveAdminConfig(f6, {
					'LoginBackground': Utils.trim(sValue)
				});
			});

			self.userCss.subscribe(function(sValue) {
				Remote.saveAdminConfig(f7, {
					'UserCss': Utils.trim(sValue)
				});
			});

			self.welcomePageUrl.subscribe(function(sValue) {
				Remote.saveAdminConfig(f8, {
					'WelcomePageUrl': Utils.trim(sValue)
				});
			});

			self.welcomePageDisplay.subscribe(function(sValue) {
				Remote.saveAdminConfig(f9, {
					'WelcomePageDisplay': Utils.trim(sValue)
				});
			});

			self.loginPowered.subscribe(function(bValue) {
				Remote.saveAdminConfig(null, {
					'LoginPowered': bValue ? '1' : '0'
				});
			});
		}, 50);
	}
};

module.exports = BrandingPremAdminSettings;


/***/ },
/* 123 */
/*!**********************************************!*\
  !*** ./dev/Settings/Admin/Prem/Licensing.js ***!
  \**********************************************/
/***/ function(module, exports, __webpack_require__) {


var
	ko = __webpack_require__(/*! ko */ 1),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	LicenseStore = __webpack_require__(/*! Stores/Admin/License */ 59);

/**
 * @constructor
 */
function LicensingPremAdminSettings()
{
	this.licensing = LicenseStore.licensing;
	this.licensingProcess = LicenseStore.licensingProcess;
	this.licenseValid = LicenseStore.licenseValid;
	this.licenseExpired = LicenseStore.licenseExpired;
	this.licenseError = LicenseStore.licenseError;
	this.licenseTrigger = LicenseStore.licenseTrigger;

	this.adminDomain = ko.observable('');
	this.subscriptionEnabled = ko.observable(!!Settings.settingsGet('SubscriptionEnabled'));

	this.licenseTrigger.subscribe(function() {
		if (this.subscriptionEnabled())
		{
			__webpack_require__(/*! App/Admin */ 18).default.reloadLicensing(true);
		}
	}, this);
}

LicensingPremAdminSettings.prototype.onBuild = function()
{
	if (this.subscriptionEnabled())
	{
		__webpack_require__(/*! App/Admin */ 18).default.reloadLicensing(false);
	}
};

LicensingPremAdminSettings.prototype.onShow = function()
{
	this.adminDomain(Settings.settingsGet('AdminDomain'));
};

LicensingPremAdminSettings.prototype.showActivationForm = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Activate */ 94));
};

LicensingPremAdminSettings.prototype.showTrialForm = function()
{
	__webpack_require__(/*! Knoin/Knoin */ 4).showScreenPopup(__webpack_require__(/*! View/Popup/Activate */ 94), [true]);
};

/**
 * @returns {boolean}
 */
LicensingPremAdminSettings.prototype.licenseIsUnlim = function()
{
	return 1898625600 === this.licenseExpired() || 1898625700 === this.licenseExpired();
};

/**
 * @returns {string}
 */
LicensingPremAdminSettings.prototype.licenseExpiredMomentValue = function()
{
	var
		moment = __webpack_require__(/*! moment */ 41),
		iTime = this.licenseExpired(),
		oM = moment.unix(iTime);

	return this.licenseIsUnlim() ? 'Never' : (iTime && (oM.format('LL') + ' (' + oM.from(moment()) + ')'));
};

module.exports = LicensingPremAdminSettings;


/***/ },
/* 124 */
/*!****************************************!*\
  !*** ./dev/Settings/Admin/Security.js ***!
  \****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Links = __webpack_require__(/*! Common/Links */ 12),

	AppAdminStore = __webpack_require__(/*! Stores/Admin/App */ 35),
	CapaAdminStore = __webpack_require__(/*! Stores/Admin/Capa */ 51),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

/**
 * @constructor
 */
function SecurityAdminSettings()
{
	this.useLocalProxyForExternalImages = AppAdminStore.useLocalProxyForExternalImages;

	this.weakPassword = AppAdminStore.weakPassword;

	this.capaOpenPGP = CapaAdminStore.openPGP;

	this.capaTwoFactorAuth = CapaAdminStore.twoFactorAuth;
	this.capaTwoFactorAuthForce = CapaAdminStore.twoFactorAuthForce;

	this.capaTwoFactorAuth.subscribe(function(bValue) {
		if (!bValue)
		{
			this.capaTwoFactorAuthForce(false);
		}
	}, this);

	this.verifySslCertificate = ko.observable(!!Settings.settingsGet('VerifySslCertificate'));
	this.allowSelfSigned = ko.observable(!!Settings.settingsGet('AllowSelfSigned'));

	this.verifySslCertificate.subscribe(function(bValue) {
		if (!bValue)
		{
			this.allowSelfSigned(true);
		}
	}, this);

	this.adminLogin = ko.observable(Settings.settingsGet('AdminLogin'));
	this.adminLoginError = ko.observable(false);
	this.adminPassword = ko.observable('');
	this.adminPasswordNew = ko.observable('');
	this.adminPasswordNew2 = ko.observable('');
	this.adminPasswordNewError = ko.observable(false);

	this.adminPasswordUpdateError = ko.observable(false);
	this.adminPasswordUpdateSuccess = ko.observable(false);

	this.adminPassword.subscribe(function() {
		this.adminPasswordUpdateError(false);
		this.adminPasswordUpdateSuccess(false);
	}, this);

	this.adminLogin.subscribe(function() {
		this.adminLoginError(false);
	}, this);

	this.adminPasswordNew.subscribe(function() {
		this.adminPasswordUpdateError(false);
		this.adminPasswordUpdateSuccess(false);
		this.adminPasswordNewError(false);
	}, this);

	this.adminPasswordNew2.subscribe(function() {
		this.adminPasswordUpdateError(false);
		this.adminPasswordUpdateSuccess(false);
		this.adminPasswordNewError(false);
	}, this);

	this.saveNewAdminPasswordCommand = Utils.createCommand(this, function() {

		if ('' === Utils.trim(this.adminLogin()))
		{
			this.adminLoginError(true);
			return false;
		}

		if (this.adminPasswordNew() !== this.adminPasswordNew2())
		{
			this.adminPasswordNewError(true);
			return false;
		}

		this.adminPasswordUpdateError(false);
		this.adminPasswordUpdateSuccess(false);

		Remote.saveNewAdminPassword(this.onNewAdminPasswordResponse, {
			'Login': this.adminLogin(),
			'Password': this.adminPassword(),
			'NewPassword': this.adminPasswordNew()
		});

		return true;

	}, function() {
		return '' !== Utils.trim(this.adminLogin()) && '' !== this.adminPassword();
	});

	this.onNewAdminPasswordResponse = _.bind(this.onNewAdminPasswordResponse, this);
}

SecurityAdminSettings.prototype.onNewAdminPasswordResponse = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.adminPassword('');
		this.adminPasswordNew('');
		this.adminPasswordNew2('');

		this.adminPasswordUpdateSuccess(true);

		this.weakPassword(!!oData.Result.Weak);
	}
	else
	{
		this.adminPasswordUpdateError(true);
	}
};

SecurityAdminSettings.prototype.onBuild = function()
{
	this.capaOpenPGP.subscribe(function(bValue) {
		Remote.saveAdminConfig(Utils.noop, {
			'CapaOpenPGP': bValue ? '1' : '0'
		});
	});

	this.capaTwoFactorAuth.subscribe(function(bValue) {
		Remote.saveAdminConfig(Utils.noop, {
			'CapaTwoFactorAuth': bValue ? '1' : '0'
		});
	});

	this.capaTwoFactorAuthForce.subscribe(function(bValue) {
		Remote.saveAdminConfig(Utils.noop, {
			'CapaTwoFactorAuthForce': bValue ? '1' : '0'
		});
	});

	this.useLocalProxyForExternalImages.subscribe(function(bValue) {
		Remote.saveAdminConfig(null, {
			'UseLocalProxyForExternalImages': bValue ? '1' : '0'
		});
	});

	this.verifySslCertificate.subscribe(function(bValue) {
		Remote.saveAdminConfig(null, {
			'VerifySslCertificate': bValue ? '1' : '0'
		});
	});

	this.allowSelfSigned.subscribe(function(bValue) {
		Remote.saveAdminConfig(null, {
			'AllowSelfSigned': bValue ? '1' : '0'
		});
	});
};

SecurityAdminSettings.prototype.onHide = function()
{
	this.adminPassword('');
	this.adminPasswordNew('');
	this.adminPasswordNew2('');
};

/**
 * @returns {string}
 */
SecurityAdminSettings.prototype.phpInfoLink = function()
{
	return Links.phpInfo();
};

module.exports = SecurityAdminSettings;


/***/ },
/* 125 */
/*!**************************************!*\
  !*** ./dev/Settings/Admin/Social.js ***!
  \**************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0);

/**
 * @constructor
 */
function SocialAdminSettings()
{
	var SocialStore = __webpack_require__(/*! Stores/Social */ 34);

	this.googleEnable = SocialStore.google.enabled;
	this.googleEnableAuth = SocialStore.google.capa.auth;
	this.googleEnableAuthFast = SocialStore.google.capa.authFast;
	this.googleEnableDrive = SocialStore.google.capa.drive;
	this.googleEnablePreview = SocialStore.google.capa.preview;

	this.googleEnableRequireClientSettings = SocialStore.google.require.clientSettings;
	this.googleEnableRequireApiKey = SocialStore.google.require.apiKeySettings;

	this.googleClientID = SocialStore.google.clientID;
	this.googleClientSecret = SocialStore.google.clientSecret;
	this.googleApiKey = SocialStore.google.apiKey;

	this.googleTrigger1 = ko.observable(Enums.SaveSettingsStep.Idle);
	this.googleTrigger2 = ko.observable(Enums.SaveSettingsStep.Idle);
	this.googleTrigger3 = ko.observable(Enums.SaveSettingsStep.Idle);

	this.facebookSupported = SocialStore.facebook.supported;
	this.facebookEnable = SocialStore.facebook.enabled;
	this.facebookAppID = SocialStore.facebook.appID;
	this.facebookAppSecret = SocialStore.facebook.appSecret;

	this.facebookTrigger1 = ko.observable(Enums.SaveSettingsStep.Idle);
	this.facebookTrigger2 = ko.observable(Enums.SaveSettingsStep.Idle);

	this.twitterEnable = SocialStore.twitter.enabled;
	this.twitterConsumerKey = SocialStore.twitter.consumerKey;
	this.twitterConsumerSecret = SocialStore.twitter.consumerSecret;

	this.twitterTrigger1 = ko.observable(Enums.SaveSettingsStep.Idle);
	this.twitterTrigger2 = ko.observable(Enums.SaveSettingsStep.Idle);

	this.dropboxEnable = SocialStore.dropbox.enabled;
	this.dropboxApiKey = SocialStore.dropbox.apiKey;

	this.dropboxTrigger1 = ko.observable(Enums.SaveSettingsStep.Idle);
}

SocialAdminSettings.prototype.onBuild = function()
{
	var
		self = this,
		Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17);

	_.delay(function() {

		var
			f1 = Utils.settingsSaveHelperSimpleFunction(self.facebookTrigger1, self),
			f2 = Utils.settingsSaveHelperSimpleFunction(self.facebookTrigger2, self),
			f3 = Utils.settingsSaveHelperSimpleFunction(self.twitterTrigger1, self),
			f4 = Utils.settingsSaveHelperSimpleFunction(self.twitterTrigger2, self),
			f5 = Utils.settingsSaveHelperSimpleFunction(self.googleTrigger1, self),
			f6 = Utils.settingsSaveHelperSimpleFunction(self.googleTrigger2, self),
			f7 = Utils.settingsSaveHelperSimpleFunction(self.googleTrigger3, self),
			f8 = Utils.settingsSaveHelperSimpleFunction(self.dropboxTrigger1, self);

		self.facebookEnable.subscribe(function(bValue) {
			if (self.facebookSupported())
			{
				Remote.saveAdminConfig(Utils.noop, {
					'FacebookEnable': bValue ? '1' : '0'
				});
			}
		});

		self.facebookAppID.subscribe(function(sValue) {
			if (self.facebookSupported())
			{
				Remote.saveAdminConfig(f1, {
					'FacebookAppID': Utils.trim(sValue)
				});
			}
		});

		self.facebookAppSecret.subscribe(function(sValue) {
			if (self.facebookSupported())
			{
				Remote.saveAdminConfig(f2, {
					'FacebookAppSecret': Utils.trim(sValue)
				});
			}
		});

		self.twitterEnable.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'TwitterEnable': bValue ? '1' : '0'
			});
		});

		self.twitterConsumerKey.subscribe(function(sValue) {
			Remote.saveAdminConfig(f3, {
				'TwitterConsumerKey': Utils.trim(sValue)
			});
		});

		self.twitterConsumerSecret.subscribe(function(sValue) {
			Remote.saveAdminConfig(f4, {
				'TwitterConsumerSecret': Utils.trim(sValue)
			});
		});

		self.googleEnable.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'GoogleEnable': bValue ? '1' : '0'
			});
		});

		self.googleEnableAuth.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'GoogleEnableAuth': bValue ? '1' : '0'
			});
		});

		self.googleEnableDrive.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'GoogleEnableDrive': bValue ? '1' : '0'
			});
		});

		self.googleEnablePreview.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'GoogleEnablePreview': bValue ? '1' : '0'
			});
		});

		self.googleClientID.subscribe(function(sValue) {
			Remote.saveAdminConfig(f5, {
				'GoogleClientID': Utils.trim(sValue)
			});
		});

		self.googleClientSecret.subscribe(function(sValue) {
			Remote.saveAdminConfig(f6, {
				'GoogleClientSecret': Utils.trim(sValue)
			});
		});

		self.googleApiKey.subscribe(function(sValue) {
			Remote.saveAdminConfig(f7, {
				'GoogleApiKey': Utils.trim(sValue)
			});
		});

		self.dropboxEnable.subscribe(function(bValue) {
			Remote.saveAdminConfig(Utils.noop, {
				'DropboxEnable': bValue ? '1' : '0'
			});
		});

		self.dropboxApiKey.subscribe(function(sValue) {
			Remote.saveAdminConfig(f8, {
				'DropboxApiKey': Utils.trim(sValue)
			});
		});

	}, 50);
};

module.exports = SocialAdminSettings;


/***/ },
/* 126 */,
/* 127 */,
/* 128 */,
/* 129 */,
/* 130 */,
/* 131 */,
/* 132 */,
/* 133 */,
/* 134 */,
/* 135 */,
/* 136 */,
/* 137 */
/*!*********************************!*\
  !*** ./dev/View/Admin/Login.js ***!
  \*********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function LoginAdminView()
{
	AbstractView.call(this, 'Center', 'AdminLogin');

	this.logoPowered = !!Settings.settingsGet('LoginPowered');

	this.mobile = !!Settings.appSettingsGet('mobile');
	this.mobileDevice = !!Settings.appSettingsGet('mobileDevice');

	this.login = ko.observable('');
	this.password = ko.observable('');

	this.loginError = ko.observable(false);
	this.passwordError = ko.observable(false);

	this.loginErrorAnimation = ko.observable(false).extend({'falseTimeout': 500});
	this.passwordErrorAnimation = ko.observable(false).extend({'falseTimeout': 500});

	this.loginFocus = ko.observable(false);

	this.formHidden = ko.observable(false);

	this.formError = ko.computed(function() {
		return this.loginErrorAnimation() || this.passwordErrorAnimation();
	}, this);

	this.login.subscribe(function() {
		this.loginError(false);
	}, this);

	this.password.subscribe(function() {
		this.passwordError(false);
	}, this);

	this.loginError.subscribe(function(bV) {
		this.loginErrorAnimation(!!bV);
	}, this);

	this.passwordError.subscribe(function(bV) {
		this.passwordErrorAnimation(!!bV);
	}, this);

	this.submitRequest = ko.observable(false);
	this.submitError = ko.observable('');

	this.submitCommand = Utils.createCommand(this, function() {

		Utils.triggerAutocompleteInputChange();

		this.loginError(false);
		this.passwordError(false);

		this.loginError('' === Utils.trim(this.login()));
		this.passwordError('' === Utils.trim(this.password()));

		if (this.loginError() || this.passwordError())
		{
			return false;
		}

		this.submitRequest(true);

		Remote.adminLogin(_.bind(function(sResult, oData) {

			if (Enums.StorageResultType.Success === sResult && oData && 'AdminLogin' === oData.Action)
			{
				if (oData.Result)
				{
					__webpack_require__(/*! App/Admin */ 18).default.loginAndLogoutReload(true);
				}
				else if (oData.ErrorCode)
				{
					this.submitRequest(false);
					this.submitError(Translator.getNotification(oData.ErrorCode));
				}
			}
			else
			{
				this.submitRequest(false);
				this.submitError(Translator.getNotification(Enums.Notification.UnknownError));
			}

		}, this), this.login(), this.password());

		return true;

	}, function() {
		return !this.submitRequest();
	});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Admin/Login', 'AdminLoginViewModel'], LoginAdminView);
_.extend(LoginAdminView.prototype, AbstractView.prototype);

LoginAdminView.prototype.onShow = function()
{
	kn.routeOff();

	_.delay(_.bind(function() {
		this.loginFocus(true);
	}, this), Enums.Magics.Time100ms);

};

LoginAdminView.prototype.onHide = function()
{
	this.loginFocus(false);
};

LoginAdminView.prototype.onBuild = function()
{
	Utils.triggerAutocompleteInputChange(true);
};

LoginAdminView.prototype.submitForm = function()
{
	this.submitCommand();
};

module.exports = LoginAdminView;


/***/ },
/* 138 */
/*!*****************************************!*\
  !*** ./dev/View/Admin/Settings/Menu.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),

	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Enums = __webpack_require__(/*! Common/Enums */ 3),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @param {?} oScreen
 *
 * @extends AbstractView
 */
function MenuSettingsAdminView(oScreen)
{
	AbstractView.call(this, 'Left', 'AdminMenu');

	this.leftPanelDisabled = Globals.leftPanelDisabled;

	this.menu = oScreen.menu;

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Admin/Settings/Menu', 'AdminSettingsMenuViewModel'], MenuSettingsAdminView);
_.extend(MenuSettingsAdminView.prototype, AbstractView.prototype);

MenuSettingsAdminView.prototype.link = function(sRoute)
{
	return '#/' + sRoute;
};

MenuSettingsAdminView.prototype.onBuild = function(oDom)
{
	key('up, down', _.throttle(function(event, handler) {

		var
			sH = '',
			iIndex = -1,
			bUp = handler && 'up' === handler.shortcut,
			$items = $('.b-admin-menu .e-item', oDom);

		if (event && $items.length)
		{
			iIndex = $items.index($items.filter('.selected'));
			if (bUp && 0 < iIndex)
			{
				iIndex -= 1;
			}
			else if (!bUp && iIndex < $items.length - 1)
			{
				iIndex += 1;
			}

			sH = $items.eq(iIndex).attr('href');
			if (sH)
			{
				kn.setHash(sH, false, true);
			}
		}

	}, Enums.Magics.Time200ms));
};

module.exports = MenuSettingsAdminView;


/***/ },
/* 139 */
/*!*****************************************!*\
  !*** ./dev/View/Admin/Settings/Pane.js ***!
  \*****************************************/
/***/ function(module, exports, __webpack_require__) {


/* global RL_COMMUNITY */

var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Settings = __webpack_require__(/*! Storage/Settings */ 7),
	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function PaneSettingsAdminView()
{
	AbstractView.call(this, 'Right', 'AdminPane');

	this.adminDomain = ko.observable(Settings.settingsGet('AdminDomain'));
	this.version = ko.observable(Settings.appSettingsGet('version'));

	this.capa = !!Settings.settingsGet('PremType');
	this.community = false;

	this.adminManLoading = ko.computed(function() {
		return '000' !== [
			__webpack_require__(/*! Stores/Admin/Domain */ 52).domains.loading() ? '1' : '0',
			__webpack_require__(/*! Stores/Admin/Plugin */ 61).plugins.loading() ? '1' : '0',
			__webpack_require__(/*! Stores/Admin/Package */ 60).packages.loading() ? '1' : '0'
		].join('');
	}, this);

	this.adminManLoadingVisibility = ko.computed(function() {
		return this.adminManLoading() ? 'visible' : 'hidden';
	}, this).extend({'rateLimit': 300});

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Admin/Settings/Pane', 'AdminSettingsPaneViewModel'], PaneSettingsAdminView);
_.extend(PaneSettingsAdminView.prototype, AbstractView.prototype);

PaneSettingsAdminView.prototype.logoutClick = function()
{
	Remote.adminLogout(function() {
		__webpack_require__(/*! App/Admin */ 18).default.loginAndLogoutReload(true, true);
	});
};

module.exports = PaneSettingsAdminView;


/***/ },
/* 140 */,
/* 141 */,
/* 142 */,
/* 143 */
/*!***************************************!*\
  !*** ./dev/View/Popup/DomainAlias.js ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Globals = __webpack_require__(/*! Common/Globals */ 5),
	Utils = __webpack_require__(/*! Common/Utils */ 0),

	Translator = __webpack_require__(/*! Common/Translator */ 6),

	DomainStore = __webpack_require__(/*! Stores/Admin/Domain */ 52),

	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function DomainAliasPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsDomainAlias');

	this.saving = ko.observable(false);
	this.savingError = ko.observable('');

	this.name = ko.observable('');
	this.name.focused = ko.observable(false);

	this.alias = ko.observable('');

	this.domains = DomainStore.domainsWithoutAliases;

	this.domainsOptions = ko.computed(function() {
		return _.map(this.domains(), function(item) {
			return {
				optValue: item.name,
				optText: item.name
			};
		});
	}, this);

	this.canBeSaved = ko.computed(function() {
		return !this.saving() && '' !== this.name() && '' !== this.alias();
	}, this);

	this.createCommand = Utils.createCommand(this, function() {
		this.saving(true);
		Remote.createDomainAlias(
			_.bind(this.onDomainAliasCreateOrSaveResponse, this),
			this.name(),
			this.alias()
		);
	}, this.canBeSaved);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/DomainAlias', 'PopupsDomainAliasViewModel'], DomainAliasPopupView);
_.extend(DomainAliasPopupView.prototype, AbstractView.prototype);

DomainAliasPopupView.prototype.onDomainAliasCreateOrSaveResponse = function(sResult, oData)
{
	this.saving(false);
	if (Enums.StorageResultType.Success === sResult && oData)
	{
		if (oData.Result)
		{
			__webpack_require__(/*! App/Admin */ 18).default.reloadDomainList();
			this.closeCommand();
		}
		else if (Enums.Notification.DomainAlreadyExists === oData.ErrorCode)
		{
			this.savingError(Translator.i18n('ERRORS/DOMAIN_ALREADY_EXISTS'));
		}
	}
	else
	{
		this.savingError(Translator.i18n('ERRORS/UNKNOWN_ERROR'));
	}
};

DomainAliasPopupView.prototype.onShow = function()
{
	this.clearForm();
};

DomainAliasPopupView.prototype.onShowWithDelay = function()
{
	if ('' === this.name() && !Globals.bMobile)
	{
		this.name.focused(true);
	}
};

DomainAliasPopupView.prototype.clearForm = function()
{
	this.saving(false);
	this.savingError('');

	this.name('');
	this.name.focused(false);

	this.alias('');
};

module.exports = DomainAliasPopupView;


/***/ },
/* 144 */,
/* 145 */,
/* 146 */,
/* 147 */
/*!**********************************!*\
  !*** ./dev/View/Popup/Plugin.js ***!
  \**********************************/
/***/ function(module, exports, __webpack_require__) {


var
	_ = __webpack_require__(/*! _ */ 2),
	ko = __webpack_require__(/*! ko */ 1),
	key = __webpack_require__(/*! key */ 16),

	Enums = __webpack_require__(/*! Common/Enums */ 3),
	Utils = __webpack_require__(/*! Common/Utils */ 0),
	Translator = __webpack_require__(/*! Common/Translator */ 6),

	Remote = __webpack_require__(/*! Remote/Admin/Ajax */ 17),

	kn = __webpack_require__(/*! Knoin/Knoin */ 4),
	AbstractView = __webpack_require__(/*! Knoin/AbstractView */ 11);

/**
 * @constructor
 * @extends AbstractView
 */
function PluginPopupView()
{
	AbstractView.call(this, 'Popups', 'PopupsPlugin');

	var self = this;

	this.onPluginSettingsUpdateResponse = _.bind(this.onPluginSettingsUpdateResponse, this);

	this.saveError = ko.observable('');

	this.name = ko.observable('');
	this.readme = ko.observable('');

	this.configures = ko.observableArray([]);

	this.hasReadme = ko.computed(function() {
		return '' !== this.readme();
	}, this);

	this.hasConfiguration = ko.computed(function() {
		return 0 < this.configures().length;
	}, this);

	this.readmePopoverConf = {
		'placement': 'right',
		'trigger': 'hover',
//			'trigger': 'click',
		'title': Translator.i18n('POPUPS_PLUGIN/TOOLTIP_ABOUT_TITLE'),
		'container': 'body',
		'html': true,
		'content': function() {
			return '<pre>' + self.readme() + '</pre>';
//					.replace(/[\r]/g, '').replace(/[\n]/g, '<br />').replace(/[\t]/g, '&nbsp;&nbsp;&nbsp;');
		}
	};

	this.saveCommand = Utils.createCommand(this, function() {

		var list = {};

		list.Name = this.name();

		_.each(this.configures(), function(oItem) {

			var value = oItem.value();
			if (false === value || true === value)
			{
				value = value ? '1' : '0';
			}

			list['_' + oItem.Name] = value;

		}, this);

		this.saveError('');
		Remote.pluginSettingsUpdate(this.onPluginSettingsUpdateResponse, list);

	}, this.hasConfiguration);

	this.bDisabeCloseOnEsc = true;
	this.sDefaultKeyScope = Enums.KeyState.All;

	this.tryToClosePopup = _.debounce(_.bind(this.tryToClosePopup, this), Enums.Magics.Time200ms);

	kn.constructorEnd(this);
}

kn.extendAsViewModel(['View/Popup/Plugin', 'PopupsPluginViewModel'], PluginPopupView);
_.extend(PluginPopupView.prototype, AbstractView.prototype);

PluginPopupView.prototype.onPluginSettingsUpdateResponse = function(sResult, oData)
{
	if (Enums.StorageResultType.Success === sResult && oData && oData.Result)
	{
		this.cancelCommand();
	}
	else
	{
		this.saveError('');
		if (oData && oData.ErrorCode)
		{
			this.saveError(Translator.getNotification(oData.ErrorCode));
		}
		else
		{
			this.saveError(Translator.getNotification(Enums.Notification.CantSavePluginSettings));
		}
	}
};

PluginPopupView.prototype.onShow = function(oPlugin)
{
	this.name();
	this.readme();
	this.configures([]);

	if (oPlugin)
	{
		this.name(oPlugin.Name);
		this.readme(oPlugin.Readme);

		var aConfig = oPlugin.Config;
		if (Utils.isNonEmptyArray(aConfig))
		{
			this.configures(_.map(aConfig, function(aItem) {
				return {
					'value': ko.observable(aItem[0]),
					'placeholder': ko.observable(aItem[6]),
					'Name': aItem[1],
					'Type': aItem[2],
					'Label': aItem[3],
					'Default': aItem[4],
					'Desc': aItem[5]
				};
			}));
		}
	}
};

PluginPopupView.prototype.tryToClosePopup = function()
{
	var
		self = this,
		PopupsAskViewModel = __webpack_require__(/*! View/Popup/Ask */ 39);

	if (!kn.isPopupVisible(PopupsAskViewModel))
	{
		kn.showScreenPopup(PopupsAskViewModel, [Translator.i18n('POPUPS_ASK/DESC_WANT_CLOSE_THIS_WINDOW'), function() {
			if (self.modalVisibility())
			{
				Utils.delegateRun(self, 'cancelCommand');
			}
		}]);
	}
};

PluginPopupView.prototype.onBuild = function()
{
	key('esc', Enums.KeyState.All, _.bind(function() {
		if (this.modalVisibility())
		{
			this.tryToClosePopup();
		}
		return false;
	}, this));
};

module.exports = PluginPopupView;


/***/ },
/* 148 */,
/* 149 */,
/* 150 */,
/* 151 */,
/* 152 */,
/* 153 */,
/* 154 */,
/* 155 */,
/* 156 */,
/* 157 */,
/* 158 */,
/* 159 */,
/* 160 */,
/* 161 */,
/* 162 */,
/* 163 */,
/* 164 */,
/* 165 */,
/* 166 */,
/* 167 */,
/* 168 */,
/* 169 */,
/* 170 */,
/* 171 */,
/* 172 */
/*!************************************!*\
  !*** ./dev/Screen/Admin/Login.jsx ***!
  \************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Knoin_AbstractScreen__ = __webpack_require__(/*! Knoin/AbstractScreen */ 40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_App_Admin__ = __webpack_require__(/*! App/Admin */ 18);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return LoginAdminScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var LoginAdminScreen = function (_AbstractScreen) {
	_inherits(LoginAdminScreen, _AbstractScreen);

	function LoginAdminScreen() {
		_classCallCheck(this, LoginAdminScreen);

		return _possibleConstructorReturn(this, _AbstractScreen.call(this, 'login', [__webpack_require__(/*! View/Admin/Login */ 137)]));
	}

	LoginAdminScreen.prototype.onShow = function onShow() {
		__WEBPACK_IMPORTED_MODULE_1_App_Admin__["default"].setWindowTitle('');
	};

	return LoginAdminScreen;
}(__WEBPACK_IMPORTED_MODULE_0_Knoin_AbstractScreen__["a" /* AbstractScreen */]);



/***/ },
/* 173 */
/*!***************************************!*\
  !*** ./dev/Screen/Admin/Settings.jsx ***!
  \***************************************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__ = __webpack_require__(/*! Knoin/Knoin */ 4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_Common_Plugins__ = __webpack_require__(/*! Common/Plugins */ 21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_Screen_AbstractSettings__ = __webpack_require__(/*! Screen/AbstractSettings */ 80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_App_Admin__ = __webpack_require__(/*! App/Admin */ 18);

/* harmony export */ __webpack_require__.d(exports, "a", function() { return SettingsAdminScreen; });/* unused harmony export default */function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* global RL_COMMUNITY */







var SettingsAdminScreen = function (_AbstractSettingsScre) {
	_inherits(SettingsAdminScreen, _AbstractSettingsScre);

	function SettingsAdminScreen() {
		_classCallCheck(this, SettingsAdminScreen);

		return _possibleConstructorReturn(this, _AbstractSettingsScre.call(this, [__webpack_require__(/*! View/Admin/Settings/Menu */ 138), __webpack_require__(/*! View/Admin/Settings/Pane */ 139)]));
	}

	/**
  * @param {Function=} fCallback = null
  */


	SettingsAdminScreen.prototype.setupSettings = function setupSettings() {
		var fCallback = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/General */ 118), 'AdminSettingsGeneral', 'TABS_LABELS/LABEL_GENERAL_NAME', 'general', true);

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Login */ 119), 'AdminSettingsLogin', 'TABS_LABELS/LABEL_LOGIN_NAME', 'login');

		if (false) {
			addSettingsViewModel(require('Settings/Admin/Branding'), 'AdminSettingsBranding', 'TABS_LABELS/LABEL_BRANDING_NAME', 'branding');
		} else {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Prem/Branding */ 122), 'AdminSettingsBranding', 'TABS_LABELS/LABEL_BRANDING_NAME', 'branding');
		}

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Contacts */ 116), 'AdminSettingsContacts', 'TABS_LABELS/LABEL_CONTACTS_NAME', 'contacts');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Domains */ 117), 'AdminSettingsDomains', 'TABS_LABELS/LABEL_DOMAINS_NAME', 'domains');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Security */ 124), 'AdminSettingsSecurity', 'TABS_LABELS/LABEL_SECURITY_NAME', 'security');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Social */ 125), 'AdminSettingsSocial', 'TABS_LABELS/LABEL_INTEGRATION_NAME', 'integrations');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Plugins */ 121), 'AdminSettingsPlugins', 'TABS_LABELS/LABEL_PLUGINS_NAME', 'plugins');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Packages */ 120), 'AdminSettingsPackages', 'TABS_LABELS/LABEL_PACKAGES_NAME', 'packages');

		if (true) {
			__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/Prem/Licensing */ 123), 'AdminSettingsLicensing', 'TABS_LABELS/LABEL_LICENSING_NAME', 'licensing');
		}

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_Knoin_Knoin__["addSettingsViewModel"])(__webpack_require__(/*! Settings/Admin/About */ 114), 'AdminSettingsAbout', 'TABS_LABELS/LABEL_ABOUT_NAME', 'about');

		__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1_Common_Plugins__["runSettingsViewModelHooks"])(true);

		if (fCallback) {
			fCallback();
		}
	};

	SettingsAdminScreen.prototype.onShow = function onShow() {
		__WEBPACK_IMPORTED_MODULE_3_App_Admin__["default"].setWindowTitle('');
	};

	return SettingsAdminScreen;
}(__WEBPACK_IMPORTED_MODULE_2_Screen_AbstractSettings__["a" /* AbstractSettingsScreen */]);



/***/ },
/* 174 */,
/* 175 */,
/* 176 */,
/* 177 */
/*!***********************!*\
  !*** ./dev/admin.jsx ***!
  \***********************/
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_bootstrap__ = __webpack_require__(/*! bootstrap */ 50);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_App_Admin__ = __webpack_require__(/*! App/Admin */ 18);




__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0_bootstrap__["a" /* default */])(__WEBPACK_IMPORTED_MODULE_1_App_Admin__["default"]);

/***/ }
/******/ ]);
